/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitorcommunicate;

import cn.com.voltronicpower.monitorcommunicate.CommConnector;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.UpsTree;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class MulticastSocketServer
extends Thread {
    private static final Log logger = new Log();
    private MulticastSocket socket = null;
    private InetAddress broadcastAddress = null;
    byte[] inBuff = new byte[4096];
    private DatagramPacket inPacket = new DatagramPacket(this.inBuff, this.inBuff.length);
    private DatagramPacket outPacket = null;
    private String interfaceAddr;
    private boolean isClose = false;

    public MulticastSocketServer(String inetAddr) {
        try {
            this.socket = new MulticastSocket(30000);
            this.interfaceAddr = inetAddr;
            this.socket.setInterface(InetAddress.getByName(this.interfaceAddr));
            this.broadcastAddress = InetAddress.getByName("224.0.1.55");
            this.socket.setSoTimeout(2500);
            System.out.println(this.broadcastAddress);
            this.socket.joinGroup(this.broadcastAddress);
            this.socket.setTimeToLive(5);
            this.socket.setLoopbackMode(false);
            this.outPacket = new DatagramPacket(new byte[0], 0, this.broadcastAddress, 30000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void send(String msg) {
        try {
            if (this.outPacket != null && this.socket != null) {
                this.outPacket.setData(msg.getBytes());
                this.socket.send(this.outPacket);
            } else {
                logger.error("ERRIR:socket outpacket is null");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (!this.isClose) {
            try {
                this.socket.receive(this.inPacket);
            }
            catch (Exception e) {
                continue;
            }
            String msg = new String(this.inBuff, 0, this.inPacket.getLength());
            try {
                if (msg.equals("search")) {
                    this.send(CommConnector.getInstance().getLocalUpsInfoXML().asXML());
                    continue;
                }
                Document document = DocumentHelper.parseText((String)msg);
                if (document == null) continue;
                Element computerEle = document.getRootElement();
                UpsTree.getInstance().putComputer(computerEle, "LAN");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void close() {
        this.isClose = true;
        try {
            this.socket.leaveGroup(this.broadcastAddress);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket.close();
    }

    public boolean isClosed() {
        return this.isClose;
    }

    public static void main(String[] args) {
    }

    public String getInterfaceAddr() {
        return this.interfaceAddr;
    }
}

