/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitorcommunicate;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.data.bean.ModBusConfig;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import java.io.IOException;
import net.wimpi.modbus.ModbusException;
import net.wimpi.modbus.facade.ModbusSerialMaster;
import net.wimpi.modbus.procimg.InputRegister;
import net.wimpi.modbus.procimg.Register;
import net.wimpi.modbus.procimg.SimpleRegister;
import net.wimpi.modbus.util.BitVector;
import net.wimpi.modbus.util.ModbusUtil;
import net.wimpi.modbus.util.SerialParameters;

public class ModbusHandler
implements CommunicateHandlerInterface {
    private static final Log logger = new Log();
    private ModbusSerialMaster _modbus;
    private String _portId;
    private ModBusConfig _config;

    public ModbusHandler(String portId) {
        this._portId = portId;
        this._config = PropertiesUtils.getModBusConfigbyComPort(portId);
        if (this._config == null || this._config.getComPort() == null || this._config.getComPort().trim().equals("")) {
            this._config = null;
            return;
        }
        SerialParameters params = new SerialParameters(portId, this._config.getBaudRate(), 0, 0, this._config.getDataBit(), this._config.getStopBit(), this._config.getEfficacy(), false, 500);
        params.setEncoding("rtu");
        this._modbus = new ModbusSerialMaster(params, 500, 10);
    }

    public synchronized BitVector readCoils(int ref, int count) throws ModbusException {
        return this._modbus.readCoils(this._config.getMachineId(), ref, count);
    }

    public synchronized boolean writeCoil(int ref, boolean state) throws ModbusException {
        return this._modbus.writeCoil(this._config.getMachineId(), ref, state);
    }

    public synchronized void writeMultipleCoils(int ref, BitVector coils) throws ModbusException {
        this._modbus.writeMultipleCoils(this._config.getMachineId(), ref, coils);
    }

    public synchronized BitVector readInputDiscretes(int ref, int count) throws ModbusException {
        return this._modbus.readInputDiscretes(this._config.getMachineId(), ref, count);
    }

    public synchronized InputRegister[] readInputRegisters(int ref, int count) throws ModbusException {
        return this._modbus.readInputRegisters(this._config.getMachineId(), ref, count);
    }

    public synchronized Register[] readMultipleRegisters(int ref, int count) throws ModbusException {
        return this._modbus.readMultipleRegisters(this._config.getMachineId(), ref, count);
    }

    public synchronized void writeSingleRegister(int ref, Register register) throws ModbusException {
        this._modbus.writeSingleRegister(this._config.getMachineId(), ref, register);
    }

    public synchronized void writeMultipleRegisters(int ref, Register[] registers) throws ModbusException {
        this._modbus.writeMultipleRegisters(this._config.getMachineId(), ref, registers);
    }

    public void open() {
        try {
            this._modbus.connect();
            this._modbus.setTransDelayMS(10);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        this._modbus.disconnect();
    }

    public String excuteCommand(String command, boolean isResponse) throws IOException {
        return null;
    }

    public String excuteSimpleCommand(String command) throws IOException {
        return null;
    }

    public String getDeviceName() {
        String portName = this._portId;
        int index = portName.lastIndexOf("/");
        if (index > 0) {
            portName = portName.substring(index + 1, portName.length());
        }
        return portName;
    }

    public void setCrcCheck(boolean arg0) {
    }

    public void setCheckSum(boolean arg0) {
    }

    public String excuteSetCommand(String command, boolean isResponse) throws IOException {
        return null;
    }

    public String excuteCommandP40(String arg0, boolean arg1) throws IOException {
        return null;
    }

    public String excuteSetCommandP40(String arg0, boolean arg1) throws IOException {
        return null;
    }

    public String excuteSimpleCommandP40(String arg0) throws IOException {
        return null;
    }

    public ModBusConfig get_config() {
        return this._config;
    }

    public void set_config(ModBusConfig _config) {
        this._config = _config;
    }

    public static void main(String[] args) {
        ModbusHandler hander = new ModbusHandler("COM8");
        try {
            hander.open();
            byte[] bytes = ModbusUtil.intToRegisters((int)256);
            SimpleRegister reg = new SimpleRegister(bytes[2], bytes[3]);
            hander.writeMultipleRegisters(26, new Register[]{reg});
        }
        catch (ModbusException e) {
            e.printStackTrace();
        }
    }
}

