/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitorcommunicate;

import cn.com.voltronic.socket.SystemTrayUDPClient;
import cn.com.voltronic.util.DateUtils;
import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.configure.SystemEnv;
import cn.com.voltronicpower.data.bean.BatteryNumber;
import cn.com.voltronicpower.data.bean.BuyInfo;
import cn.com.voltronicpower.data.bean.LocalComs;
import cn.com.voltronicpower.data.bean.RatingInfo;
import cn.com.voltronicpower.data.bean.UpsIdentity;
import cn.com.voltronicpower.data.bean.UpsInfo;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.monitor.MonitorProcesserManager;
import cn.com.voltronicpower.monitor.MonitorProcessor;
import cn.com.voltronicpower.monitor.protocol.ProtocolIDS;
import cn.com.voltronicpower.monitorcommunicate.ModbusHandler;
import cn.com.voltronicpower.monitorcommunicate.SerialPortHandler;
import cn.com.voltronicpower.monitorcommunicate.USBHandler;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.utilities.SaveEvent;
import cn.com.voltronicpower.work.WorkMonitor;
import com.fazecast.jSerialComm.SerialPort;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import usb.IUSBComm;

public class CommConnector
extends Thread
implements ProtocolIDS {
    private static final Log logger = new Log();
    private static CommConnector connector = null;
    private Map<String, MonitorProcessor> commProcesserMap = new ConcurrentHashMap<String, MonitorProcessor>();
    private Map<String, Integer> usbconnectMap = new HashMap<String, Integer>();
    private IUSBComm usbComm;
    private static final int REFRESH_TIME = 5;
    private static Integer lock = new Integer(1);

    private CommConnector() {
    }

    public void setUsbDriver(IUSBComm exusbcomm) {
        this.usbComm = exusbcomm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommConnector getInstance() {
        Integer n = lock;
        synchronized (n) {
            if (connector == null) {
                connector = new CommConnector();
            }
            return connector;
        }
    }

    @Override
    public void run() {
        int number = 0;
        int count = 0;
        USBConnector usbConnector = new USBConnector();
        usbConnector.start();
        while (!SystemEnv.stopping) {
            ++number;
            try {
                if (count == 0) {
                    if (Config.getBoolean("showLocalUPS")) {
                        CommConnector.getInstance().autoSearchLocalcomms();
                    }
                } else {
                    CommConnector.sleep(1000L);
                }
                if (++count < 5) continue;
                count = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ++SystemEnv.stoped;
    }

    public MonitorProcessor getCommProcesser(String key) {
        return this.commProcesserMap.get(key);
    }

    public void removeCommProcesser(String key) {
        this.commProcesserMap.remove(key);
        SystemEnv.refreshTree = MyConstants.getRefreshTree();
    }

    public Map<String, MonitorProcessor> getProcesserMap() {
        return this.commProcesserMap;
    }

    public Collection<MonitorProcessor> getProcessers() {
        return this.commProcesserMap.values();
    }

    public void sendUPSNumber() {
        int number = this.getProcessers().size();
        try (SystemTrayUDPClient udp = null;){
            try {
                udp = new SystemTrayUDPClient("localhost", 33654);
                String str = "UPS_NUMBER###" + number;
                udp.send(str.getBytes("UTF-8"));
            }
            catch (Exception e) {
                e.printStackTrace();
                if (udp != null) {
                    udp.close();
                }
            }
        }
    }

    private String getSMSCom() {
        String str = PropertiesUtils.getProperty("SmsInfo.comPort");
        if (str == null) {
            str = "";
        }
        return str.trim();
    }

    public void autoSearchLocalcomms() {
        try {
            SerialPort[] comPorts = SerialPort.getCommPorts();
            int i = 0;
            while (i < comPorts.length) {
                SerialPort comPort = comPorts[i];
                String portname = comPort.getSystemPortName();
                if (!(this.commProcesserMap.containsKey(portname) || this.getExcludeComs().contains(portname) || this.getSMSCom().equalsIgnoreCase(portname.trim()))) {
                    if (comPort.openPort()) {
                        SerialPortHandler serialPortHandler = new SerialPortHandler(comPort);
                        MonitorProcessor processer = MonitorProcesserManager.getMonitorProcesser(serialPortHandler);
                        logger.info("processer" + processer);
                        if (processer != null) {
                            if (SystemEnv.IS_TEST_MODE) {
                                SaveEvent.saveData("SerialPort Start Monitor COM:" + processer.getProtocol().getProtocolID());
                            }
                            processer.setSupportBatNum(this.isSupportBatNum(processer, serialPortHandler));
                            WorkMonitor monitor = new WorkMonitor(processer);
                            String portName = processer.getDeviceName();
                            try {
                                PropertiesUtils.updateProperty("GlobalConfig.portName", portName);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            monitor.start();
                            String ptid = processer.getProtocol().getProtocolID();
                            this.commProcesserMap.put(portName, processer);
                            SystemEnv.refreshTree = MyConstants.getRefreshTree();
                            EventsHandler.handleEvent(portName, "6002", ptid, processer.getDeviceId(), false);
                        } else {
                            serialPortHandler.close();
                        }
                    }
                    if (!this.commProcesserMap.containsKey(comPort.getSystemPortName())) {
                        if (MyConstants.IS_OS_SOLARIS) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        if (SystemEnv.IS_TEST_MODE) {
                            SaveEvent.saveData("----search--MODBUS--Port ID:" + comPort.getSystemPortName());
                        }
                        this.searchModBus(comPort.getSystemPortName());
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<String> getExcludeComs() {
        String notComs = PropertiesUtils.getProperty("limitComs");
        if (notComs == null) {
            notComs = "";
        }
        ArrayList<String> nonComs = new ArrayList<String>();
        String[] strComs = notComs.split(",");
        int coms_i = 0;
        while (coms_i < strComs.length) {
            nonComs.add(strComs[coms_i]);
            ++coms_i;
        }
        return nonComs;
    }

    private void searchModBus(String portId) {
        block7: {
            ModbusHandler mdHandler = new ModbusHandler(portId);
            if (mdHandler.get_config() == null) {
                return;
            }
            try {
                mdHandler.open();
                MonitorProcessor processer = MonitorProcesserManager.getMonitorProcesser(mdHandler);
                if (processer != null) {
                    if (SystemEnv.IS_TEST_MODE) {
                        SaveEvent.saveData("Modbus Start Monitor COM:" + processer.getProtocol().getProtocolID());
                    }
                    WorkMonitor monitor = new WorkMonitor(processer);
                    String portName = processer.getDeviceName();
                    try {
                        PropertiesUtils.updateProperty("GlobalConfig.portName", portName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    monitor.start();
                    String ptid = processer.getProtocol().getProtocolID();
                    this.commProcesserMap.put(portName, processer);
                    SystemEnv.refreshTree = MyConstants.getRefreshTree();
                    EventsHandler.handleEvent(portName, "6002", ptid, processer.getDeviceId(), false);
                    break block7;
                }
                mdHandler.close();
            }
            catch (Exception e) {
                if (mdHandler == null) break block7;
                mdHandler.close();
            }
        }
    }

    public boolean isSupportBatNum(MonitorProcessor processer, CommunicateHandlerInterface handler) {
        boolean result = false;
        String protocolId = processer.getProtocol().getProtocolID();
        if ("PMV".equals(protocolId) || "P09".equals(protocolId) || "P10".equals(protocolId) || "P31".equals(protocolId) || "P98".equals(protocolId)) {
            return false;
        }
        if ("P33".equals(protocolId) || "P44".equals(protocolId) || "P35".equals(protocolId) || "P36".equals(protocolId) || "P38".equals(protocolId) || "P39".equals(protocolId) || "P45".equals(protocolId)) {
            return true;
        }
        try {
            String reQBV = handler.excuteCommand("QBV", true);
            if (!(reQBV == null || "".equals(reQBV) || "QBV".equals(reQBV) || "(NAK".equals(reQBV))) {
                String[] datas = reQBV.split(" ");
                String reBATGN = "";
                int i = 0;
                while (i < 3) {
                    reBATGN = handler.excuteCommand("BATGN" + datas[2], true);
                    if ("(ACK".equals(reBATGN)) break;
                    ++i;
                }
                result = "(ACK".equals(reBATGN);
            } else {
                result = false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return result;
    }

    public void removeUSB(String usbs) {
        String usbNames = usbs.toUpperCase();
        try {
            for (String port : this.commProcesserMap.keySet()) {
                String portid = port.substring(3).toUpperCase();
                if (usbNames.indexOf(portid) == -1) {
                    int reIndex = this.usbconnectMap.get(port);
                    if (reIndex < 3) {
                        this.usbconnectMap.put(port, ++reIndex);
                        continue;
                    }
                    if (reIndex != 3) continue;
                    this.commProcesserMap.get(port).close();
                    this.commProcesserMap.remove(port);
                    this.usbconnectMap.remove(port);
                    continue;
                }
                this.usbconnectMap.put(port, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void searchUSB(String usbId) {
        USBHandler handler = new USBHandler(this.usbComm, usbId);
        MonitorProcessor processer = MonitorProcesserManager.getMonitorProcesser(handler);
        if (processer != null) {
            if (SystemEnv.IS_TEST_MODE) {
                SaveEvent.saveData("USB Start Monitor USB:" + processer.getProtocol().getProtocolID());
            }
            WorkMonitor monitor = new WorkMonitor(processer);
            String portName = processer.getDeviceName();
            System.out.println("---------usbportname:" + portName);
            System.out.println(String.valueOf(portName) + ":" + processer.getProtocol().getProtocolID());
            try {
                processer.setSupportBatNum(this.isSupportBatNum(processer, handler));
                PropertiesUtils.updateProperty("GlobalConfig.portName", portName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            monitor.start();
            this.commProcesserMap.put(portName, processer);
            this.usbconnectMap.put(portName, 0);
            SystemEnv.refreshTree = MyConstants.getRefreshTree();
            String ptid = processer.getProtocol().getProtocolID();
            EventsHandler.handleEvent(portName, "6002", ptid, processer.getDeviceId(), false);
        } else {
            handler.close();
        }
    }

    public void closeAllProcessers() {
        Collection<MonitorProcessor> processers = this.commProcesserMap.values();
        for (MonitorProcessor processer : processers) {
            processer.close();
        }
        this.commProcesserMap.clear();
    }

    public Document getLocalUpsInfoXML() {
        Document document = DocumentHelper.createDocument();
        Element localHostEle = document.addElement("node").addAttribute("label", SystemEnv.getLocalHostAddress()).addAttribute("bool", "computer").addAttribute("ipAddr", SystemEnv.getLocalHostAddress());
        for (MonitorProcessor processer : this.commProcesserMap.values()) {
            Element portEle = localHostEle.addElement("node").addAttribute("label", String.valueOf(processer.getDeviceName()) + "_" + processer.getProtocol().getProtocolID()).addAttribute("bool", "port");
            try {
                Element upsEle = portEle.addElement("upsInfo");
                upsEle.addAttribute("protocolType", String.valueOf(processer.getProtocol().getProtocolID()));
                UpsIdentity identity = processer.getIdentity();
                upsEle.addElement("identity").addAttribute("morphological", identity.getMorphological()).addAttribute("ioPhase", identity.getIoPhase()).addAttribute("inputRatingVoltage", identity.getInputRatingVoltage()).addAttribute("outputRatingVoltage", identity.getOutputRatingVoltage()).addAttribute("productSN", identity.getProductSN()).addAttribute("fwVersion", identity.getFwVersion());
                RatingInfo ratingInfo = processer.getRatingInfo();
                upsEle.addElement("ratingInfo").addAttribute("ratedCapacity", ratingInfo.getRatedCapacity()).addAttribute("outputRatingVoltage", ratingInfo.getOutputRatingVoltage()).addAttribute("outputRatingFrequency", ratingInfo.getOutputRatingFrequency()).addAttribute("outputRatingCurrent", ratingInfo.getOutputRatingCurrent()).addAttribute("batteryVoltage", ratingInfo.getBatteryVoltage());
                BatteryNumber batteryNumber = processer.getBatteryNumber();
                upsEle.addElement("batteryNumber").addAttribute("batn", String.valueOf(batteryNumber.getBatn())).addAttribute("batgn", String.valueOf(batteryNumber.getBatgn()));
                BuyInfo buyInfo = processer.getBuyInfo();
                upsEle.addElement("buyInfo").addAttribute("upsBuyDate", DateUtils.getFormatDate((Date)buyInfo.getUpsBuyDate())).addAttribute("batteryBuyDate", DateUtils.getFormatDate((Date)buyInfo.getBatteryBuyDate())).addAttribute("upsWarranty", String.valueOf(buyInfo.getUpsWarranty())).addAttribute("batteryWarranty", String.valueOf(buyInfo.getBatteryWarranty()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return document;
    }

    public Document getLocalUpsInfoXML(String clientIP) {
        Document document = DocumentHelper.createDocument();
        Element localHostEle = document.addElement("node").addAttribute("label", SystemEnv.getLocalHostAddress(clientIP)).addAttribute("bool", "computer").addAttribute("ipAddr", SystemEnv.getLocalHostAddress(clientIP));
        for (MonitorProcessor processer : this.commProcesserMap.values()) {
            Element portEle = localHostEle.addElement("node").addAttribute("label", String.valueOf(processer.getDeviceName()) + "_" + processer.getProtocol().getProtocolID()).addAttribute("bool", "port");
            try {
                Element upsEle = portEle.addElement("upsInfo");
                upsEle.addAttribute("protocolType", String.valueOf(processer.getProtocol().getProtocolID()));
                UpsIdentity identity = processer.getIdentity();
                upsEle.addElement("identity").addAttribute("morphological", identity.getMorphological()).addAttribute("ioPhase", identity.getIoPhase()).addAttribute("inputRatingVoltage", identity.getInputRatingVoltage()).addAttribute("outputRatingVoltage", identity.getOutputRatingVoltage()).addAttribute("productSN", identity.getProductSN()).addAttribute("fwVersion", identity.getFwVersion());
                RatingInfo ratingInfo = processer.getRatingInfo();
                upsEle.addElement("ratingInfo").addAttribute("ratedCapacity", ratingInfo.getRatedCapacity()).addAttribute("outputRatingVoltage", ratingInfo.getOutputRatingVoltage()).addAttribute("outputRatingFrequency", ratingInfo.getOutputRatingFrequency()).addAttribute("outputRatingCurrent", ratingInfo.getOutputRatingCurrent()).addAttribute("batteryVoltage", ratingInfo.getBatteryVoltage());
                BatteryNumber batteryNumber = processer.getBatteryNumber();
                upsEle.addElement("batteryNumber").addAttribute("batn", String.valueOf(batteryNumber.getBatn())).addAttribute("batgn", String.valueOf(batteryNumber.getBatgn()));
                BuyInfo buyInfo = processer.getBuyInfo();
                upsEle.addElement("buyInfo").addAttribute("upsBuyDate", DateUtils.getFormatDate((Date)buyInfo.getUpsBuyDate())).addAttribute("batteryBuyDate", DateUtils.getFormatDate((Date)buyInfo.getBatteryBuyDate())).addAttribute("upsWarranty", String.valueOf(buyInfo.getUpsWarranty())).addAttribute("batteryWarranty", String.valueOf(buyInfo.getBatteryWarranty()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return document;
    }

    public UpsInfo conventElement(Element portEle) {
        Element upsEle = portEle.element("upsInfo");
        String protocolType = upsEle.attributeValue("protocolType");
        UpsIdentity identity = new UpsIdentity();
        RatingInfo ratingInfo = new RatingInfo();
        BatteryNumber number = new BatteryNumber();
        BuyInfo buyInfo = new BuyInfo();
        UpsInfo ups = new UpsInfo(protocolType, identity, ratingInfo, number, buyInfo);
        portEle.remove(upsEle);
        return ups;
    }

    public ArrayList<LocalComs> getLocalComs() {
        ArrayList<LocalComs> ports = new ArrayList<LocalComs>();
        try {
            SerialPort[] comPorts = SerialPort.getCommPorts();
            int i = 0;
            while (i < comPorts.length) {
                String comName = comPorts[i].getSystemPortName();
                LocalComs allCom = new LocalComs();
                if (CommConnector.getInstance().getExcludeComs().contains(comName)) {
                    allCom.setSelected(true);
                } else {
                    allCom.setSelected(false);
                }
                allCom.setComName(comName);
                ports.add(allCom);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ports;
    }

    public ArrayList<String> getPorts() {
        ArrayList<String> ports = new ArrayList<String>();
        try {
            SerialPort[] comPorts = SerialPort.getCommPorts();
            int i = 0;
            while (i < comPorts.length) {
                SerialPort comPort = comPorts[i];
                ports.add(comPort.getSystemPortName());
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ports;
    }

    class USBConnector
    extends Thread {
        USBConnector() {
        }

        @Override
        public void run() {
            int number = 0;
            int count = 0;
            while (!SystemEnv.stopping) {
                ++number;
                try {
                    if (count == 0) {
                        if (Config.getBoolean("showLocalUPS")) {
                            this.autoSearchLocalUSBs();
                        }
                    } else {
                        USBConnector.sleep(1000L);
                    }
                    if (++count < 5) continue;
                    count = 0;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++SystemEnv.stoped;
        }

        public void autoSearchLocalUSBs() {
            String[] devices;
            String usbDevices = CommConnector.this.usbComm.findUSBDevices();
            if (SystemEnv.IS_TEST_MODE) {
                SaveEvent.saveData("----search--USB--Port ID array:" + usbDevices);
            }
            if ((devices = usbDevices.split("#")) == null || devices.length <= 0) {
                return;
            }
            String[] stringArray = devices;
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                String usbId = stringArray[n2];
                if (usbId != null && !"".equals(usbId) && !CommConnector.this.commProcesserMap.containsKey("USB" + usbId)) {
                    if (SystemEnv.IS_TEST_MODE) {
                        SaveEvent.saveData("----search--USB--Port ID:" + usbId);
                    }
                    CommConnector.this.searchUSB(usbId);
                }
                ++n2;
            }
        }
    }
}

