/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.protocol;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.data.bean.AutoMenuItem;
import cn.com.voltronicpower.data.bean.AutoMenuList;
import cn.com.voltronicpower.data.bean.AutoMenuOne;
import cn.com.voltronicpower.data.bean.AutoMenuTwo;
import cn.com.voltronicpower.data.bean.HistoryDataColumns;
import cn.com.voltronicpower.data.bean.HistoryDataItem;
import cn.com.voltronicpower.data.bean.HistoryMonitorColumns;
import cn.com.voltronicpower.data.bean.HistoryMonitorItem;
import cn.com.voltronicpower.data.bean.StatusPowerFlow;
import cn.com.voltronicpower.data.bean.StatusPowerFlowItem;
import cn.com.voltronicpower.data.bean.StatusUPSInfo;
import cn.com.voltronicpower.data.bean.StatusUPSInfoItem;
import cn.com.voltronicpower.data.bean.StatusUPSInfoList;
import cn.com.voltronicpower.data.bean.WebMapping;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.monitorcommunicate.ModbusHandler;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import java.util.ArrayList;
import java.util.List;
import net.wimpi.modbus.procimg.Register;

public class PTaurus
implements IProtocol {
    private boolean _isOldVersion = false;
    public String ioPhase31 = "3/1";

    public String getEventFileName() {
        return null;
    }

    public String getProtocolID() {
        return "MODBUS";
    }

    public WebMapping getWebMapping() {
        return null;
    }

    public boolean isCouldExcuteBatteryTest(WorkInfo workinfo) {
        return false;
    }

    public boolean matchProtocol(CommunicateHandlerInterface handler) {
        if (handler instanceof ModbusHandler) {
            ModbusHandler modbus = (ModbusHandler)handler;
            handler.setCheckSum(false);
            handler.setCrcCheck(false);
            try {
                Register[] micSV = modbus.readMultipleRegisters(5016, 6);
                Register[] dspSV = modbus.readMultipleRegisters(5043, 6);
                StringBuffer micSVStr = new StringBuffer();
                StringBuffer dspSVStr = new StringBuffer();
                int item = 0;
                while (item < 6) {
                    micSVStr.append(new String(micSV[item].toBytes()));
                    dspSVStr.append(new String(dspSV[item].toBytes()));
                    ++item;
                }
                this._isOldVersion = micSVStr.toString().trim().compareToIgnoreCase("Ver. 2.7 I_") < 0 || dspSVStr.toString().trim().compareToIgnoreCase("Ver. 3.6 L_") < 0;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        String v1 = "Ver. 2.7 A_";
        String v2 = "Ver. 9.6 G_";
        System.out.println(v2.compareToIgnoreCase(v1));
    }

    public void formatMonitorData(Object arg0) {
    }

    public HistoryMonitorColumns getHistoryMonitorColumns() {
        HistoryMonitorColumns columns = new HistoryMonitorColumns();
        List items = columns.getColumns();
        items.add(new HistoryMonitorItem("[text.inputV] L1-N", "inputL1N", 300, "Voltage", "", "inputVoltage", "[text.inputV] L1-N"));
        items.add(new HistoryMonitorItem("[text.inputV] L2-N", "inputL2N", 300, "Voltage", "", "inputVoltageS", "[text.inputV] L2-N"));
        items.add(new HistoryMonitorItem("[text.inputV] L3-N", "inputL3N", 300, "Voltage", "", "inputVoltageT", "[text.inputV] L3-N"));
        items.add(new HistoryMonitorItem("[text.inputV] L1-L2", "inputVL1L2", 600, "Voltage", "", "inputVoltageL1L2", "[text.inputV] L1-L2"));
        items.add(new HistoryMonitorItem("[text.inputV] L2-L3", "inputVL2L3", 600, "Voltage", "", "inputVoltageL2L3", "[text.inputV] L2-L3"));
        items.add(new HistoryMonitorItem("[text.inputV] L1-L3", "inputVL1L3", 600, "Voltage", "", "inputVoltageL1L3", "[text.inputV] L1-L3"));
        items.add(new HistoryMonitorItem("[text.inputF]", "inputFrequency", 70, "Hz", "", "inputFrequency", "[text.inputF]"));
        items.add(new HistoryMonitorItem("[text.inputCurrent] L1", "inputCurrentL1", 300, "A", "", "inputCurrentR", "[text.inputCurrent] L1"));
        items.add(new HistoryMonitorItem("[text.inputCurrent] L2", "inputCurrentL2", 300, "A", "", "inputCurrentS", "[text.inputCurrent] L2"));
        items.add(new HistoryMonitorItem("[text.inputCurrent] L3", "inputCurrentL3", 300, "A", "", "inputCurrentT", "[text.inputCurrent] L3"));
        items.add(new HistoryMonitorItem("[text.rectiffierHTemp]", "rectifierHt", 180, "Degree", "", "rectifierHtView", "[text.rectiffierHTemp]"));
        items.add(new HistoryMonitorItem("[text.inverterHTemp]", "inverterHT", 180, "Degree", "", "inverterHTView", "[text.inverterHTemp]"));
        items.add(new HistoryMonitorItem("[text.batteryHTemp]", "batteryHT", 180, "Degree", "", "temperatureView", "[text.batteryHTemp]"));
        items.add(new HistoryMonitorItem("[text.outputV] L1", "outputVL1", 300, "Voltage", "", "outputVoltage", "[text.outputV] L1"));
        items.add(new HistoryMonitorItem("[text.outputV] L2", "outputVL2", 300, "Voltage", "", "outputVoltageS", "[text.outputV] L2"));
        items.add(new HistoryMonitorItem("[text.outputV] L3", "outputVL3", 300, "Voltage", "", "outputVoltageT", "[text.outputV] L3"));
        items.add(new HistoryMonitorItem("[text.outputF]", "outputF", 70, "Hz", "", "outputFrequency", "[text.outputF]"));
        items.add(new HistoryMonitorItem("[text.outputCurrent] L1", "outputCurrentL1", 300, "A", "", "outputCurrent", "[text.outputCurrent] L1"));
        items.add(new HistoryMonitorItem("[text.outputCurrent] L2", "outputCurrentL2", 300, "A", "", "outputCurrentS", "[text.outputCurrent] L2"));
        items.add(new HistoryMonitorItem("[text.outputCurrent] L3", "outputCurrentL3", 300, "A", "", "outputCurrentT", "[text.outputCurrent] L3"));
        items.add(new HistoryMonitorItem("[label.loadPercents] L1", "loadPercentsL1", 300, "%", "", "loadLevel", "[label.loadPercents] L1"));
        items.add(new HistoryMonitorItem("[label.loadPercents] L2", "loadPercentsL2", 300, "%", "", "loadLevelS", "[label.loadPercents] L2"));
        items.add(new HistoryMonitorItem("[label.loadPercents] L3", "loadPercentsL3", 300, "%", "", "loadLevelT", "[label.loadPercents] L3"));
        items.add(new HistoryMonitorItem("[text.totalLoadLevel]", "totalLoadLevel", 300, "%", "", "outputLoadPercent", "[text.totalLoadLevel]"));
        items.add(new HistoryMonitorItem("[text.positiveBatteryVoltage]", "positiveBatteryVoltage", 600, "Voltage", "", "positiveBatteryVoltage", "[text.positiveBatteryVoltage]"));
        items.add(new HistoryMonitorItem("[text.negativeBatteryVoltage]", "negativeBatteryVoltage", 600, "Voltage", "", "negativeBatteryVoltage", "[text.negativeBatteryVoltage]"));
        items.add(new HistoryMonitorItem("[text.bypassVoltage] L1-N", "bypassVoltageL1N", 300, "Voltage", "", "bypassVoltage", "[text.bypassVoltage] L1-N"));
        items.add(new HistoryMonitorItem("[text.bypassVoltage] L2-N", "bypassVoltageL2N", 300, "Voltage", "", "bypassVoltageS", "[text.bypassVoltage] L2-N"));
        items.add(new HistoryMonitorItem("[text.bypassVoltage] L3-N", "bypassVoltageL3N", 300, "Voltage", "", "bypassVoltageT", "[text.bypassVoltage] L3-N"));
        items.add(new HistoryMonitorItem("[text.bypassFrequency]", "bypassFrequency", 80, "Hz", "", "bypassFrequency", "[text.bypassFrequency]"));
        items.add(new HistoryMonitorItem("[text.bypassCurrent] L1", "bypassCurrentL1", 300, "A", "", "bypassCurrent", "[text.bypassCurrent] L1"));
        items.add(new HistoryMonitorItem("[text.bypassCurrent] L2", "bypassCurrentL2", 300, "A", "", "bypassCurrentS", "[text.bypassCurrent] L2"));
        items.add(new HistoryMonitorItem("[text.bypassCurrent] L3", "bypassCurrentL3", 300, "A", "", "bypassCurrentT", "[text.bypassCurrent] L3"));
        return columns;
    }

    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        List item = columns.getColumns();
        item.add(new HistoryDataItem("[text.mv.col1]", "currentTime", "", "displayDate"));
        item.add(new HistoryDataItem("[text.inputV] L1-N", "inputVoltage", "inputVoltageL1N", ""));
        item.add(new HistoryDataItem("[text.inputV] L2-N", "inputVoltageS", "inputVoltageL2N", ""));
        item.add(new HistoryDataItem("[text.inputV] L3-N", "inputVoltageT", "inputVoltageL3N", ""));
        item.add(new HistoryDataItem("[text.inputV] L1-L2", "inputVoltageL1L2", "inputVoltageL1L2", ""));
        item.add(new HistoryDataItem("[text.inputV] L2-L3", "inputVoltageL2L3", "inputVoltageL2L3", ""));
        item.add(new HistoryDataItem("[text.inputV] L1-L3", "inputVoltageL1L3", "inputVoltageL3L1", ""));
        item.add(new HistoryDataItem("[text.inputF]", "inputFrequency", "inputF", "displayInputFrequency"));
        item.add(new HistoryDataItem("[text.inputCurrent] L1", "inputCurrentR", "inputCurrentL1", ""));
        item.add(new HistoryDataItem("[text.inputCurrent] L2", "inputCurrentS", "inputCurrentL2", ""));
        item.add(new HistoryDataItem("[text.inputCurrent] L3", "inputCurrentT", "inputCurrentL3", ""));
        item.add(new HistoryDataItem("[text.rectiffierHTemp]", "rectifierHtView", "rectiffierHTemp", ""));
        item.add(new HistoryDataItem("[text.inverterHTemp]", "inverterHTView", "inverterHTemp", ""));
        item.add(new HistoryDataItem("[text.batteryHTemp]", "temperatureView", "batteryHTemp", ""));
        item.add(new HistoryDataItem("[text.outputV] L1", "outputVoltage", "outputVL1", ""));
        item.add(new HistoryDataItem("[text.outputV] L2", "outputVoltageS", "outputVL2", ""));
        item.add(new HistoryDataItem("[text.outputV] L3", "outputVoltageT", "outputVL3", ""));
        item.add(new HistoryDataItem("[text.outputF]", "outputFrequency", "outputF", ""));
        item.add(new HistoryDataItem("[text.outputCurrent] L1", "outputCurrent", "outputCurrentL1", ""));
        item.add(new HistoryDataItem("[text.outputCurrent] L2", "outputCurrentS", "outputCurrentL2", ""));
        item.add(new HistoryDataItem("[text.outputCurrent] L3", "outputCurrentT", "outputCurrentL3", ""));
        item.add(new HistoryDataItem("[label.loadPercents] L1", "loadLevel", "loadPercentsL1", ""));
        item.add(new HistoryDataItem("[label.loadPercents] L2", "loadLevelS", "loadPercentsL2", ""));
        item.add(new HistoryDataItem("[label.loadPercents] L3", "loadLevelT", "loadPercentsL3", ""));
        item.add(new HistoryDataItem("[text.totalLoadLevel]", "outputLoadPercent", "totalLoadLevel", ""));
        item.add(new HistoryDataItem("[text.positiveBatteryVoltage]", "positiveBatteryVoltage", "positiveBatteryVoltage", ""));
        item.add(new HistoryDataItem("[text.negativeBatteryVoltage]", "negativeBatteryVoltage", "negativeBatteryVoltage", ""));
        item.add(new HistoryDataItem("[text.bypassVoltage] L1-N", "bypassVoltage", "bypassVoltageL1N", ""));
        item.add(new HistoryDataItem("[text.bypassVoltage] L2-N", "bypassVoltageS", "bypassVoltageL2N", ""));
        item.add(new HistoryDataItem("[text.bypassVoltage] L3-N", "bypassVoltageT", "bypassVoltageL3N", ""));
        item.add(new HistoryDataItem("[text.bypassFrequency]", "bypassFrequency", "bypassFrequency", ""));
        item.add(new HistoryDataItem("[text.bypassCurrent] L1", "bypassCurrent", "bypassCurrentL1", ""));
        item.add(new HistoryDataItem("[text.bypassCurrent] L2", "bypassCurrentS", "bypassCurrentL2", ""));
        item.add(new HistoryDataItem("[text.bypassCurrent] L3", "bypassCurrentT", "bypassCurrentL3", ""));
        return columns;
    }

    public StatusPowerFlow getStatusPowerFlow() {
        StatusPowerFlow statusPowerFlow = new StatusPowerFlow();
        List inputlines = statusPowerFlow.getInput();
        inputlines.add(new StatusPowerFlowItem("[text.inputV] L1-N:", "{workInfo.inputVoltage}", "V"));
        inputlines.add(new StatusPowerFlowItem("[text.inputV] L2-N:", "{workInfo.inputVoltageS}", "V"));
        inputlines.add(new StatusPowerFlowItem("[text.inputV] L3-N:", "{workInfo.inputVoltageT}", "V"));
        inputlines.add(new StatusPowerFlowItem("[text.inputF]:", "{workInfo.inputFrequency}", "Hz"));
        List upslines = statusPowerFlow.getUpsInfo();
        upslines.add(new StatusPowerFlowItem("[text.workMod]:", "{workInfo.workMode}", ""));
        upslines.add(new StatusPowerFlowItem("[text.rectiffierHTemp]:", "{workInfo.rectifierHtView}", MyConstants.getTempUnit()));
        upslines.add(new StatusPowerFlowItem("[text.inverterHTemp]:", "{workInfo.inverterHTView}", MyConstants.getTempUnit()));
        upslines.add(new StatusPowerFlowItem("[text.batteryHTemp]:", "{workInfo.temperatureView}", MyConstants.getTempUnit()));
        List outputlines = statusPowerFlow.getOutput();
        outputlines.add(new StatusPowerFlowItem("[text.outputV] L1:", "{workInfo.outputVoltage}", "V"));
        outputlines.add(new StatusPowerFlowItem("[text.outputV] L2:", "{workInfo.outputVoltageS}", "V"));
        outputlines.add(new StatusPowerFlowItem("[text.outputV] L3:", "{workInfo.outputVoltageT}", "V"));
        outputlines.add(new StatusPowerFlowItem("[text.outputF]:", "{workInfo.outputFrequency}", "Hz"));
        outputlines.add(new StatusPowerFlowItem("[text.totalLoadLevel]:", "{workInfo.outputLoadPercent}", "%"));
        List batterylines = statusPowerFlow.getBattery();
        batterylines.add(new StatusPowerFlowItem("[text.positiveBatteryVoltage]:", "{workInfo.positiveBatteryVoltage}", "V"));
        batterylines.add(new StatusPowerFlowItem("[text.negativeBatteryVoltage]:", "{workInfo.negativeBatteryVoltage}", "V"));
        if (!this._isOldVersion) {
            batterylines.add(new StatusPowerFlowItem("[text.BatteryPercent]:", "{workInfo.batteryCapacity}", "%"));
            batterylines.add(new StatusPowerFlowItem("[text.batteryRemaining]:", "{workInfo.batteryRemainTime}", "Min"));
        }
        return statusPowerFlow;
    }

    public StatusUPSInfo getStatusUPSInfo() {
        StatusUPSInfo statusUpsinfo = new StatusUPSInfo();
        ArrayList<StatusUPSInfoList> info = new ArrayList<StatusUPSInfoList>();
        StatusUPSInfoList statusUpsInfolist1 = new StatusUPSInfoList();
        statusUpsInfolist1.setLabel("[label.inputInfo]");
        ArrayList<StatusUPSInfoItem> item1 = new ArrayList<StatusUPSInfoItem>();
        item1.add(new StatusUPSInfoItem("[text.inputV] L1-N:", "{workInfo.inputVoltage}", "V"));
        item1.add(new StatusUPSInfoItem("[text.inputV] L2-N:", "{workInfo.inputVoltageS}", "V"));
        item1.add(new StatusUPSInfoItem("[text.inputV] L3-N:", "{workInfo.inputVoltageT}", "V"));
        item1.add(new StatusUPSInfoItem("[text.inputV] L1-L2:", "{workInfo.inputVoltageL1L2}", "V"));
        item1.add(new StatusUPSInfoItem("[text.inputV] L2-L3:", "{workInfo.inputVoltageL2L3}", "V"));
        item1.add(new StatusUPSInfoItem("[text.inputV] L1-L3:", "{workInfo.inputVoltageL1L3}", "V"));
        item1.add(new StatusUPSInfoItem("[text.inputF]:", "{workInfo.inputFrequency}", "Hz"));
        item1.add(new StatusUPSInfoItem("[text.inputCurrent] L1:", "{workInfo.inputCurrentR}", "A"));
        item1.add(new StatusUPSInfoItem("[text.inputCurrent] L2:", "{workInfo.inputCurrentS}", "A"));
        item1.add(new StatusUPSInfoItem("[text.inputCurrent] L3:", "{workInfo.inputCurrentT}", "A"));
        statusUpsInfolist1.setLines(item1);
        info.add(statusUpsInfolist1);
        StatusUPSInfoList statusUpsInfolist2 = new StatusUPSInfoList();
        statusUpsInfolist2.setLabel("[label.upsInfo]");
        ArrayList<StatusUPSInfoItem> item2 = new ArrayList<StatusUPSInfoItem>();
        item2.add(new StatusUPSInfoItem("[text.workMod]:", "{workInfo.workMode}", ""));
        item2.add(new StatusUPSInfoItem("[text.rectiffierHTemp]:", "{workInfo.rectifierHtView}", MyConstants.getTempUnit()));
        item2.add(new StatusUPSInfoItem("[text.inverterHTemp]:", "{workInfo.inverterHTView}", MyConstants.getTempUnit()));
        item2.add(new StatusUPSInfoItem("[text.batteryHTemp]:", "{workInfo.temperatureView}", MyConstants.getTempUnit()));
        statusUpsInfolist2.setLines(item2);
        info.add(statusUpsInfolist2);
        StatusUPSInfoList statusUpsInfolist3 = new StatusUPSInfoList();
        statusUpsInfolist3.setLabel("[label.batteryInfo]");
        ArrayList<StatusUPSInfoItem> item3 = new ArrayList<StatusUPSInfoItem>();
        item3.add(new StatusUPSInfoItem("[text.positiveBatteryVoltage]:", "{workInfo.positiveBatteryVoltage}", "V"));
        item3.add(new StatusUPSInfoItem("[text.negativeBatteryVoltage]:", "{workInfo.negativeBatteryVoltage}", "V"));
        if (!this._isOldVersion) {
            item3.add(new StatusUPSInfoItem("[text.BatteryPercent]:", "{workInfo.batteryCapacity}", "%"));
            item3.add(new StatusUPSInfoItem("[text.batteryRemaining]:", "{workInfo.batteryRemainTime}", "Min"));
        }
        statusUpsInfolist3.setLines(item3);
        info.add(statusUpsInfolist3);
        StatusUPSInfoList statusUpsInfolist4 = new StatusUPSInfoList();
        statusUpsInfolist4.setLabel("[label.outputInfo]");
        ArrayList<StatusUPSInfoItem> item4 = new ArrayList<StatusUPSInfoItem>();
        item4.add(new StatusUPSInfoItem("[text.outputV] L1:", "{workInfo.outputVoltage}", "V"));
        item4.add(new StatusUPSInfoItem("[text.outputV] L2:", "{workInfo.outputVoltageS}", "V"));
        item4.add(new StatusUPSInfoItem("[text.outputV] L3:", "{workInfo.outputVoltageT}", "V"));
        item4.add(new StatusUPSInfoItem("[text.outputF]:", "{workInfo.outputFrequency}", "Hz"));
        item4.add(new StatusUPSInfoItem("[text.outputCurrent] L1:", "{workInfo.outputCurrent}", "A"));
        item4.add(new StatusUPSInfoItem("[text.outputCurrent] L2:", "{workInfo.outputCurrentS}", "A"));
        item4.add(new StatusUPSInfoItem("[text.outputCurrent] L3:", "{workInfo.outputCurrentT}", "A"));
        item4.add(new StatusUPSInfoItem("[label.loadPercents] L1:", "{workInfo.loadLevel}", "%"));
        item4.add(new StatusUPSInfoItem("[label.loadPercents] L2:", "{workInfo.loadLevelS}", "%"));
        item4.add(new StatusUPSInfoItem("[label.loadPercents] L3:", "{workInfo.loadLevelT}", "%"));
        item4.add(new StatusUPSInfoItem("[text.totalLoadLevel]:", "{workInfo.outputLoadPercent}", "%"));
        statusUpsInfolist4.setLines(item4);
        info.add(statusUpsInfolist4);
        StatusUPSInfoList statusUpsInfolist6 = new StatusUPSInfoList();
        statusUpsInfolist6.setLabel("[text.bypassInfo]");
        ArrayList<StatusUPSInfoItem> item6 = new ArrayList<StatusUPSInfoItem>();
        item6.add(new StatusUPSInfoItem("[text.bypassVoltage] L1-N:", "{workInfo.bypassVoltage}", "V"));
        item6.add(new StatusUPSInfoItem("[text.bypassVoltage] L2-N:", "{workInfo.bypassVoltageS}", "V"));
        item6.add(new StatusUPSInfoItem("[text.bypassVoltage] L3-N:", "{workInfo.bypassVoltageT}", "V"));
        item6.add(new StatusUPSInfoItem("[text.bypassFrequency]:", "{workInfo.bypassFrequency}", "Hz"));
        item6.add(new StatusUPSInfoItem("[text.bypassCurrent] L1:", "{workInfo.bypassCurrent}", "A"));
        item6.add(new StatusUPSInfoItem("[text.bypassCurrent] L2:", "{workInfo.bypassCurrentS}", "A"));
        item6.add(new StatusUPSInfoItem("[text.bypassCurrent] L3:", "{workInfo.bypassCurrentT}", "A"));
        statusUpsInfolist6.setLines(item6);
        info.add(statusUpsInfolist6);
        statusUpsinfo.setInfo(info);
        return statusUpsinfo;
    }

    public StatusUPSInfo getModulesInfo() {
        return null;
    }

    public AutoMenuList getMenuList() {
        AutoMenuList menuList = new AutoMenuList();
        ArrayList<AutoMenuOne> menus = new ArrayList<AutoMenuOne>();
        ArrayList<AutoMenuTwo> items1 = new ArrayList<AutoMenuTwo>();
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.passwordSet]", "password", "", "menu"), null));
        if (MyConstants.Customized.equals("NEXTVision") || MyConstants.Customized.equals("Forza")) {
            items1.add(new AutoMenuTwo(new AutoMenuItem("[label.smsemailSet]", "mobile", "", "menu"), null));
        } else {
            items1.add(new AutoMenuTwo(new AutoMenuItem("[label.smsinfoSet]", "mobile", "", "menu"), null));
            items1.add(new AutoMenuTwo(new AutoMenuItem("[label.emailSet]", "email", "", "menu"), null));
        }
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.electricEventSet]", "eleEvent", "", "menu"), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.netWeakUPSet]", "network", "", "menu"), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.setcom]", "setcom", "", "menu"), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.recorddata]", "recorddata", "", "menu"), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.modbussetting]", "modbus", "", "menu"), null));
        ArrayList<AutoMenuTwo> items2 = new ArrayList<AutoMenuTwo>();
        if (MyConstants.Customized.equals("NEXTVision") || MyConstants.Customized.equals("Forza")) {
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.shutdownParamSet]", "loadClose", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.remoteShutdownParamSet]", "remoteLoadClose", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.realTimeCtrl]", "onOff", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.controlParamSet]", "controlPara", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.upsBurInfoSet]", "buy", "", "menu"), null));
        } else {
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.shutdownParamSet]", "loadClose", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.remoteShutdownParamSet]", "remoteLoadClose", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.controlParamSet]", "controlPara", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.upsBurInfoSet]", "buy", "", "menu"), null));
        }
        ArrayList<AutoMenuTwo> items3 = new ArrayList<AutoMenuTwo>();
        items3.add(new AutoMenuTwo(new AutoMenuItem("[label.realTimeCtrl]", "onOff", "", "menu"), null));
        ArrayList<AutoMenuTwo> items4 = new ArrayList<AutoMenuTwo>();
        items4.add(new AutoMenuTwo(new AutoMenuItem("[label.realInfoView]", "immediately", "", "menu"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("[label.historyInfoView]", "historyInfo", "", "menu"), null));
        ArrayList<AutoMenuItem> temps = new ArrayList<AutoMenuItem>();
        temps.add(new AutoMenuItem("[label.Celsius]", "celsiur", "radio", "temp"));
        temps.add(new AutoMenuItem("[label.Fahrenheit]", "fahrenheit", "radio", "temp"));
        ArrayList<AutoMenuItem> dates = new ArrayList<AutoMenuItem>();
        dates.add(new AutoMenuItem("YYYY-MM-DD", "YYYY-MM-DD", "radio", "date"));
        dates.add(new AutoMenuItem("YYYY/MM/DD", "YYYY/MM/DD", "radio", "date"));
        dates.add(new AutoMenuItem("YYYY:MM:DD", "YYYY:MM:DD", "radio", "date"));
        dates.add(new AutoMenuItem("MM-DD-YYYY", "MM-DD-YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("MM/DD/YYYY", "MM/DD/YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("MM:DD:YYYY", "MM:DD:YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("DD-MM-YYYY", "DD-MM-YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("DD/MM/YYYY", "DD/MM/YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("DD:MM:YYYY", "DD:MM:YYYY", "radio", "date"));
        ArrayList<AutoMenuTwo> items5 = new ArrayList<AutoMenuTwo>();
        items5.add(new AutoMenuTwo(new AutoMenuItem("[label.temperatureUnit]", "temperature", "", ""), temps));
        items5.add(new AutoMenuTwo(new AutoMenuItem("[label.dateFormat]", "requireState", "", ""), dates));
        ArrayList<AutoMenuTwo> items6 = new ArrayList<AutoMenuTwo>();
        items6.add(new AutoMenuTwo(new AutoMenuItem("English", "English", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("French", "French", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("German", "German", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Italian", "Italian", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Polish", "Polish", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Portuguese", "Portuguese", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Russian", "Russian", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Spanish", "Spanish", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Ukrainian", "Ukrainian", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Turkish", "Turkish", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Czech", "Czech", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Simplified)", "Chinese", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Traditional)", "ChineseTW", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Japanese", "Japanese", "radio", "language"), null));
        ArrayList<AutoMenuTwo> items7 = new ArrayList<AutoMenuTwo>();
        items7.add(new AutoMenuTwo(new AutoMenuItem("[label.copyRight]", "copyRight", "", ""), null));
        List<AutoMenuItem> helps = MyConstants.getOnlineHelp();
        if (helps.size() > 1) {
            items7.add(new AutoMenuTwo(new AutoMenuItem("[label.systemHelp]", "systemHelp", "", ""), MyConstants.getOnlineHelp()));
        } else {
            items7.add(new AutoMenuTwo(new AutoMenuItem("[label.systemHelp]", "systemHelp_en", "", ""), null));
        }
        menus.add(new AutoMenuOne(MyConstants.getCustomerViewpower(), "system", items1));
        if (MyConstants.Customized.equals("NEXTVision") || MyConstants.Customized.equals("Forza")) {
            menus.add(new AutoMenuOne("Console", "config", items2));
        } else {
            menus.add(new AutoMenuOne("[label.upsSet]", "config", items2));
            menus.add(new AutoMenuOne("[label.controlPlatform]", "control", items3));
            menus.add(new AutoMenuOne("[label.upsWatch]", "monitor", items4));
        }
        menus.add(new AutoMenuOne("[label.systemStyle]", "top", items5));
        menus.add(new AutoMenuOne("[label.language]", "top", items6));
        menus.add(new AutoMenuOne("[label.Help]", "top", items7));
        menuList.setMenuList(menus);
        return menuList;
    }

    public void refreshData(CommunicateHandlerInterface handler) {
    }

    public void setIophase(String arg0) {
        this.ioPhase31 = arg0;
    }

    public void setProtocolPMV(String arg0) {
    }
}

