/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.protocol;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.data.bean.AutoMenuItem;
import cn.com.voltronicpower.data.bean.AutoMenuList;
import cn.com.voltronicpower.data.bean.AutoMenuOne;
import cn.com.voltronicpower.data.bean.AutoMenuTwo;
import cn.com.voltronicpower.data.bean.StatusPowerFlow;
import cn.com.voltronicpower.data.bean.StatusPowerFlowItem;
import cn.com.voltronicpower.data.bean.StatusUPSInfo;
import cn.com.voltronicpower.data.bean.StatusUPSInfoItem;
import cn.com.voltronicpower.data.bean.StatusUPSInfoList;
import cn.com.voltronicpower.monitor.protocol.PMV;
import cn.com.voltronicpower.monitorcommunicate.ModbusHandler;
import cn.com.voltronicpower.monitorcommunicate.SerialPortHandler;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.FileUtilites;
import cn.com.voltronicpower.utilities.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class PMV_H
extends PMV {
    private String type = "";
    private static final Log logger = new Log();

    @Override
    public boolean matchProtocol(CommunicateHandlerInterface handler) {
        if (handler instanceof ModbusHandler) {
            return false;
        }
        handler.setCheckSum(false);
        handler.setCrcCheck(false);
        String dataStr = "(NAK";
        boolean isPMV = false;
        int time_i = 0;
        while (time_i < 2) {
            dataStr = "(NAK";
            try {
                int i = 0;
                while (i < 5) {
                    if (!dataStr.equals("(NAK")) break;
                    this.type = dataStr = handler.excuteSimpleCommand("M");
                    ++i;
                }
                if ((isPMV = dataStr.equals("H")) && handler instanceof SerialPortHandler) {
                    dataStr = "(NAK";
                    i = 0;
                    while (i < 5) {
                        if (!dataStr.equals("(NAK")) break;
                        dataStr = handler.excuteCommand("QS", true);
                        ++i;
                    }
                    isPMV = dataStr.startsWith("(");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (isPMV) break;
            ++time_i;
        }
        return isPMV;
    }

    @Override
    public AutoMenuList getMenuList() {
        AutoMenuList menuList = new AutoMenuList();
        ArrayList<AutoMenuOne> menus = new ArrayList<AutoMenuOne>();
        ArrayList<AutoMenuTwo> items1 = new ArrayList<AutoMenuTwo>();
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.passwordSet]", "password", "", "menu"), null));
        if (MyConstants.Customized.equals("NEXTVision") || MyConstants.Customized.equals("Forza")) {
            items1.add(new AutoMenuTwo(new AutoMenuItem("[label.smsemailSet]", "mobile", "", "menu"), null));
        } else {
            items1.add(new AutoMenuTwo(new AutoMenuItem("[label.smsinfoSet]", "mobile", "", "menu"), null));
            items1.add(new AutoMenuTwo(new AutoMenuItem("[label.emailSet]", "email", "", "menu"), null));
        }
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.electricEventSet]", "eleEvent", "", "menu"), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.netWeakUPSet]", "network", "", "menu"), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.setcom]", "setcom", "", "menu"), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.recorddata]", "recorddata", "", "menu"), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.modbussetting]", "modbus", "", "menu"), null));
        ArrayList<AutoMenuTwo> items2 = new ArrayList<AutoMenuTwo>();
        if (MyConstants.Customized.equals("NEXTVision") || MyConstants.Customized.equals("Forza")) {
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.shutdownParamSet]", "loadClose", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.remoteShutdownParamSet]", "remoteLoadClose", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.realTimeCtrl]", "onOff", "", "menu"), null));
            if (MyConstants.Customized.equals("ZTE")) {
                items2.add(new AutoMenuTwo(new AutoMenuItem("[label.controlParamSet]", "controlPara", "", "menu"), null));
            }
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.powerPlan]", "onOffPlan", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.autoTestPlan]", "testPlan", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.upsBurInfoSet]", "buy", "", "menu"), null));
        } else {
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.shutdownParamSet]", "loadClose", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.remoteShutdownParamSet]", "remoteLoadClose", "", "menu"), null));
            if (MyConstants.Customized.equals("ZTE")) {
                items2.add(new AutoMenuTwo(new AutoMenuItem("[label.controlParamSet]", "controlPara", "", "menu"), null));
            }
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.upsBurInfoSet]", "buy", "", "menu"), null));
        }
        ArrayList<AutoMenuTwo> items3 = new ArrayList<AutoMenuTwo>();
        items3.add(new AutoMenuTwo(new AutoMenuItem("[label.realTimeCtrl]", "onOff", "", "menu"), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("[label.powerPlan]", "onOffPlan", "", "menu"), null));
        if ("T".equals(this.type)) {
            items3.add(new AutoMenuTwo(new AutoMenuItem("[label.autoTestPlan]", "testPlan", "", "menu"), null));
        }
        ArrayList<AutoMenuTwo> items4 = new ArrayList<AutoMenuTwo>();
        items4.add(new AutoMenuTwo(new AutoMenuItem("[label.realInfoView]", "immediately", "", "menu"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("[label.historyInfoView]", "historyInfo", "", "menu"), null));
        ArrayList<AutoMenuItem> temps = new ArrayList<AutoMenuItem>();
        temps.add(new AutoMenuItem("[label.Celsius]", "celsiur", "radio", "temp"));
        temps.add(new AutoMenuItem("[label.Fahrenheit]", "fahrenheit", "radio", "temp"));
        ArrayList<AutoMenuItem> dates = new ArrayList<AutoMenuItem>();
        dates.add(new AutoMenuItem("YYYY-MM-DD", "YYYY-MM-DD", "radio", "date"));
        dates.add(new AutoMenuItem("YYYY/MM/DD", "YYYY/MM/DD", "radio", "date"));
        dates.add(new AutoMenuItem("YYYY:MM:DD", "YYYY:MM:DD", "radio", "date"));
        dates.add(new AutoMenuItem("MM-DD-YYYY", "MM-DD-YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("MM/DD/YYYY", "MM/DD/YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("MM:DD:YYYY", "MM:DD:YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("DD-MM-YYYY", "DD-MM-YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("DD/MM/YYYY", "DD/MM/YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("DD:MM:YYYY", "DD:MM:YYYY", "radio", "date"));
        ArrayList<AutoMenuTwo> items5 = new ArrayList<AutoMenuTwo>();
        items5.add(new AutoMenuTwo(new AutoMenuItem("[label.temperatureUnit]", "temperature", "", ""), temps));
        items5.add(new AutoMenuTwo(new AutoMenuItem("[label.dateFormat]", "requireState", "", ""), dates));
        ArrayList<AutoMenuTwo> items6 = new ArrayList<AutoMenuTwo>();
        items6.add(new AutoMenuTwo(new AutoMenuItem("English", "English", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("French", "French", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("German", "German", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Italian", "Italian", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Polish", "Polish", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Portuguese", "Portuguese", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Russian", "Russian", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Spanish", "Spanish", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Ukrainian", "Ukrainian", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Turkish", "Turkish", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Czech", "Czech", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Simplified)", "Chinese", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Traditional)", "ChineseTW", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Japanese", "Japanese", "radio", "language"), null));
        ArrayList<AutoMenuTwo> items7 = new ArrayList<AutoMenuTwo>();
        items7.add(new AutoMenuTwo(new AutoMenuItem("[label.copyRight]", "copyRight", "", ""), null));
        List<AutoMenuItem> helps = MyConstants.getOnlineHelp();
        if (helps.size() > 1) {
            items7.add(new AutoMenuTwo(new AutoMenuItem("[label.systemHelp]", "systemHelp", "", ""), MyConstants.getOnlineHelp()));
        } else {
            Locale local = Locale.getDefault();
            String language = local.getLanguage();
            if ("zh".equals(language) && FileUtilites.checkFile("help_zh.swf")) {
                items7.add(new AutoMenuTwo(new AutoMenuItem("[label.systemHelp]", "systemHelp_zh", "", ""), null));
            } else if ("ru".equals(language) && FileUtilites.checkFile("help_ru.swf")) {
                items7.add(new AutoMenuTwo(new AutoMenuItem("[label.systemHelp]", "systemHelp_ru", "", ""), null));
            } else if ("tr".equals(language) && FileUtilites.checkFile("help_tr.swf")) {
                items7.add(new AutoMenuTwo(new AutoMenuItem("[label.systemHelp]", "systemHelp_tr", "", ""), null));
            } else {
                items7.add(new AutoMenuTwo(new AutoMenuItem("[label.systemHelp]", "systemHelp_en", "", ""), null));
            }
        }
        menus.add(new AutoMenuOne(MyConstants.getCustomerViewpower(), "system", items1));
        if (MyConstants.Customized.equals("NEXTVision") || MyConstants.Customized.equals("Forza")) {
            menus.add(new AutoMenuOne("Console", "config", items2));
        } else {
            menus.add(new AutoMenuOne("[label.upsSet]", "config", items2));
            menus.add(new AutoMenuOne("[label.controlPlatform]", "control", items3));
            menus.add(new AutoMenuOne("[label.upsWatch]", "monitor", items4));
        }
        menus.add(new AutoMenuOne("[label.systemStyle]", "top", items5));
        menus.add(new AutoMenuOne("[label.language]", "top", items6));
        menus.add(new AutoMenuOne("[label.Help]", "top", items7));
        menuList.setMenuList(menus);
        return menuList;
    }

    @Override
    public StatusPowerFlow getStatusPowerFlow() {
        StatusPowerFlow statusPowerFlow = new StatusPowerFlow();
        ArrayList<StatusPowerFlowItem> inputlines = new ArrayList<StatusPowerFlowItem>();
        inputlines.add(new StatusPowerFlowItem("[text.inputV]:", "{workInfo.inputVoltage}", "V"));
        ArrayList<StatusPowerFlowItem> upslines = new ArrayList<StatusPowerFlowItem>();
        upslines.add(new StatusPowerFlowItem("[text.workMod]:", "{workInfo.workMode}", ""));
        ArrayList<StatusPowerFlowItem> outputlines = new ArrayList<StatusPowerFlowItem>();
        outputlines.add(new StatusPowerFlowItem("[text.outputV]:", "{workInfo.outputVoltage}", "V"));
        outputlines.add(new StatusPowerFlowItem("[text.outputF]:", "{workInfo.outputFrequency}", "Hz"));
        outputlines.add(new StatusPowerFlowItem("[label.loadPercents]:", "{workInfo.outputLoadPercent}", "%"));
        ArrayList<StatusPowerFlowItem> batterylines = new ArrayList<StatusPowerFlowItem>();
        batterylines.add(new StatusPowerFlowItem("[text.BTV]:", "{workInfo.batteryVoltage}", "V"));
        batterylines.add(new StatusPowerFlowItem("[text.BatteryPercent]:", "{workInfo.batteryCapacity}", "%"));
        batterylines.add(new StatusPowerFlowItem("[text.batteryRemaining]:", "{workInfo.batteryRemainTime}", "min"));
        statusPowerFlow.setBattery(batterylines);
        statusPowerFlow.setInput(inputlines);
        statusPowerFlow.setOutput(outputlines);
        statusPowerFlow.setUpsInfo(upslines);
        return statusPowerFlow;
    }

    @Override
    public StatusUPSInfo getStatusUPSInfo() {
        StatusUPSInfo statusUpsinfo = new StatusUPSInfo();
        ArrayList<StatusUPSInfoList> info = new ArrayList<StatusUPSInfoList>();
        StatusUPSInfoList statusUpsInfolist1 = new StatusUPSInfoList();
        statusUpsInfolist1.setLabel("[label.inputInfo]");
        ArrayList<StatusUPSInfoItem> item1 = new ArrayList<StatusUPSInfoItem>();
        item1.add(new StatusUPSInfoItem("[text.inputV]", "{workInfo.inputVoltage}", "V"));
        statusUpsInfolist1.setLines(item1);
        info.add(statusUpsInfolist1);
        StatusUPSInfoList statusUpsInfolist2 = new StatusUPSInfoList();
        statusUpsInfolist2.setLabel("[label.upsInfo]");
        ArrayList<StatusUPSInfoItem> item2 = new ArrayList<StatusUPSInfoItem>();
        item2.add(new StatusUPSInfoItem("[text.workMod]", "{workInfo.workMode}", ""));
        statusUpsInfolist2.setLines(item2);
        info.add(statusUpsInfolist2);
        StatusUPSInfoList statusUpsInfolist3 = new StatusUPSInfoList();
        statusUpsInfolist3.setLabel("[label.batteryInfo]");
        ArrayList<StatusUPSInfoItem> item3 = new ArrayList<StatusUPSInfoItem>();
        item3.add(new StatusUPSInfoItem("[text.mv.col4]", "{workInfo.batteryVoltage}", "V"));
        item3.add(new StatusUPSInfoItem("[text.BatteryPercent]", "{workInfo.batteryCapacity}", "%"));
        statusUpsInfolist3.setLines(item3);
        info.add(statusUpsInfolist3);
        StatusUPSInfoList statusUpsInfolist4 = new StatusUPSInfoList();
        statusUpsInfolist4.setLabel("[label.outputInfo]");
        ArrayList<StatusUPSInfoItem> item4 = new ArrayList<StatusUPSInfoItem>();
        item4.add(new StatusUPSInfoItem("[text.outputV]", "{workInfo.outputVoltage}", "V"));
        item4.add(new StatusUPSInfoItem("[text.outputF]", "{workInfo.outputFrequency}", "Hz"));
        item4.add(new StatusUPSInfoItem("[label.loadLevel]", "{workInfo.outputLoadPercent}", "%"));
        statusUpsInfolist4.setLines(item4);
        info.add(statusUpsInfolist4);
        statusUpsinfo.setInfo(info);
        return statusUpsinfo;
    }
}

