/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.protocol;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.data.bean.AutoMenuItem;
import cn.com.voltronicpower.data.bean.AutoMenuList;
import cn.com.voltronicpower.data.bean.AutoMenuOne;
import cn.com.voltronicpower.data.bean.AutoMenuTwo;
import cn.com.voltronicpower.data.bean.HistoryDataColumns;
import cn.com.voltronicpower.data.bean.HistoryDataItem;
import cn.com.voltronicpower.data.bean.HistoryMonitorColumns;
import cn.com.voltronicpower.data.bean.HistoryMonitorItem;
import cn.com.voltronicpower.data.bean.StatusPowerFlow;
import cn.com.voltronicpower.data.bean.StatusPowerFlowItem;
import cn.com.voltronicpower.data.bean.StatusUPSInfo;
import cn.com.voltronicpower.data.bean.StatusUPSInfoItem;
import cn.com.voltronicpower.data.bean.StatusUPSInfoList;
import cn.com.voltronicpower.data.bean.WebMapping;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.monitor.protocol.PMV_H;
import cn.com.voltronicpower.monitorcommunicate.ModbusHandler;
import cn.com.voltronicpower.monitorcommunicate.SerialPortHandler;
import cn.com.voltronicpower.monitorcommunicate.USBHandler;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.FileUtilites;
import cn.com.voltronicpower.utilities.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class PMV
implements IProtocol {
    private static final Log logger = new Log();
    public static final String M = "M";
    public static final String QS = "QS";
    public static final String F = "F";
    public static final String QB = "QB";
    public static final String QI = "QI";
    public static final String BL = "BL?";
    public static final String BT = "BT?";
    public static final String FW = "FW?";
    public static final String FW2 = "FW2?";
    public static final String FW3 = "FW3?";
    public static final String I = "I";
    public static final String QFS = "QFS";
    public static final String QWS = "QWS";
    public static final String T = "T";
    public static final String SnRm = "SnRm";
    public static final String Q = "Q";
    public static final String C = "C";
    public static final String GM = "GM";
    public static final String WM = "WM";
    public static final String TON = "TON";
    public static final String TOFF = "TOFF";
    public static final String OPV = "OPV";
    public static final String QF = "QF";
    public static final String G = "G";
    public static final String GA = "GA";
    public static final String ES = "ES";
    public static final String QPI = "QPI";
    public String ioPhase31 = "1/1";

    public String getProtocolID() {
        return "PMV";
    }

    public boolean getV(String str) {
        byte b = (byte)str.charAt(0);
        return (b & 0xF) == 6;
    }

    public boolean notp98(CommunicateHandlerInterface handler) {
        String dataStr = "(NAK";
        boolean notP98 = false;
        try {
            int i = 0;
            while (i < 5) {
                if (!dataStr.equals("(NAK")) break;
                dataStr = handler.excuteSimpleCommand(QS);
                ++i;
            }
            if (notP98 = dataStr.startsWith("(")) {
                dataStr = "(NAK";
                i = 0;
                while (i < 5) {
                    if (!dataStr.equals("(NAK")) break;
                    dataStr = handler.excuteSimpleCommand(QPI);
                    ++i;
                }
                notP98 = !dataStr.startsWith("(PI");
                System.out.println("isP98 3" + notP98);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return !notP98;
    }

    public boolean matchProtocol(CommunicateHandlerInterface handler) {
        if (handler instanceof ModbusHandler) {
            return false;
        }
        handler.setCheckSum(false);
        handler.setCrcCheck(false);
        String dataStr = "(NAK";
        if (!(handler instanceof USBHandler) && this.notp98(handler)) {
            System.out.println("p98\u5185\u5bb9\uff0c\u9000\u51fapmv\u5339\u914d");
            return false;
        }
        boolean isPMV = false;
        int time_i = 0;
        while (time_i < 2) {
            block9: {
                block10: {
                    dataStr = "(NAK";
                    int i = 0;
                    while (i < 5) {
                        if (!dataStr.equals("(NAK")) break;
                        dataStr = handler.excuteSimpleCommand(M);
                        ++i;
                    }
                    if (!(isPMV = dataStr.equals("V"))) break block9;
                    String pq = handler.excuteSimpleCommand(QPI);
                    if (pq.indexOf("PI") == -1 || pq.indexOf(QPI) != -1) break block10;
                    return false;
                }
                try {
                    if (handler instanceof SerialPortHandler) {
                        dataStr = "(NAK";
                        int i = 0;
                        while (i < 5) {
                            if (!dataStr.equals("(NAK")) break;
                            dataStr = handler.excuteCommand(QS, true);
                            ++i;
                        }
                        isPMV = dataStr.startsWith("(");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (isPMV) break;
            ++time_i;
        }
        return isPMV;
    }

    public boolean isCouldExcuteBatteryTest(WorkInfo workinfo) {
        String workMode = workinfo.getWorkMode();
        return workMode.equals("Line mode");
    }

    public String getEventFileName() {
        return null;
    }

    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        List item = columns.getColumns();
        item.add(new HistoryDataItem("[text.mv.col1]", "currentTime", "", "displayDate"));
        item.add(new HistoryDataItem("[text.inputV]", "inputVoltage", "inputV1", ""));
        item.add(new HistoryDataItem("[text.outputV]", "outputVoltage", "outputVR", ""));
        item.add(new HistoryDataItem("[text.outputF]", "outputFrequency", "", ""));
        item.add(new HistoryDataItem("[label.loadPercents]", "outputLoadPercent", "", "displayOutpuLoadPercents"));
        item.add(new HistoryDataItem("[text.BTV]", "batteryVoltage", "", ""));
        if (this instanceof PMV_H) {
            item.add(new HistoryDataItem("[text.BatteryPercent]", "batteryCapacity", "", ""));
        }
        return columns;
    }

    public HistoryMonitorColumns getHistoryMonitorColumns() {
        HistoryMonitorColumns columns = new HistoryMonitorColumns();
        List items = columns.getColumns();
        items.add(new HistoryMonitorItem("[text.inputV]", "voltageLine", 300, "Voltage", "", "inputVoltage", "[text.inputV]"));
        items.add(new HistoryMonitorItem("[text.outputV]", "outputVoltageLine", 300, "Voltage", "", "outputVoltage", "[text.outputV]"));
        items.add(new HistoryMonitorItem("[text.outputF]", "outputFrequencyLine", 70, "Hz", "", "outputFrequency", "[text.outputF]"));
        items.add(new HistoryMonitorItem("[label.loadPercents]", "loadArea", 100, "%", "", "outputLoadPercent", "[label.loadPercents]"));
        items.add(new HistoryMonitorItem("[text.BTV]", "batteryVoltage", 300, "Voltage", "", "batteryVoltage", "[text.BTV]"));
        if (this instanceof PMV_H) {
            items.add(new HistoryMonitorItem("[text.BatteryPercent]", "batteryCapacity", 100, "%", "", "batteryCapacity", "[text.BatteryPercent]"));
        }
        return columns;
    }

    public StatusPowerFlow getStatusPowerFlow() {
        StatusPowerFlow statusPowerFlow = new StatusPowerFlow();
        ArrayList<StatusPowerFlowItem> inputlines = new ArrayList<StatusPowerFlowItem>();
        inputlines.add(new StatusPowerFlowItem("[text.inputV]:", "{workInfo.inputVoltage}", "V"));
        ArrayList<StatusPowerFlowItem> upslines = new ArrayList<StatusPowerFlowItem>();
        upslines.add(new StatusPowerFlowItem("[text.workMod]:", "{workInfo.workMode}", ""));
        ArrayList<StatusPowerFlowItem> outputlines = new ArrayList<StatusPowerFlowItem>();
        outputlines.add(new StatusPowerFlowItem("[text.outputV]:", "{workInfo.outputVoltage}", "V"));
        outputlines.add(new StatusPowerFlowItem("[text.outputF]:", "{workInfo.outputFrequency}", "Hz"));
        outputlines.add(new StatusPowerFlowItem("[label.loadPercents]:", "{workInfo.outputLoadPercent}", "%"));
        ArrayList<StatusPowerFlowItem> batterylines = new ArrayList<StatusPowerFlowItem>();
        batterylines.add(new StatusPowerFlowItem("[text.BTV]:", "{workInfo.batteryVoltage}", "V"));
        batterylines.add(new StatusPowerFlowItem("[text.BatteryPercent]:", "{workInfo.batteryCapacity}", "%"));
        statusPowerFlow.setBattery(batterylines);
        statusPowerFlow.setInput(inputlines);
        statusPowerFlow.setOutput(outputlines);
        statusPowerFlow.setUpsInfo(upslines);
        return statusPowerFlow;
    }

    public StatusUPSInfo getStatusUPSInfo() {
        StatusUPSInfo statusUpsinfo = new StatusUPSInfo();
        ArrayList<StatusUPSInfoList> info = new ArrayList<StatusUPSInfoList>();
        StatusUPSInfoList statusUpsInfolist1 = new StatusUPSInfoList();
        statusUpsInfolist1.setLabel("[label.inputInfo]");
        ArrayList<StatusUPSInfoItem> item1 = new ArrayList<StatusUPSInfoItem>();
        item1.add(new StatusUPSInfoItem("[text.inputV]", "{workInfo.inputVoltage}", "V"));
        statusUpsInfolist1.setLines(item1);
        info.add(statusUpsInfolist1);
        StatusUPSInfoList statusUpsInfolist2 = new StatusUPSInfoList();
        statusUpsInfolist2.setLabel("[label.upsInfo]");
        ArrayList<StatusUPSInfoItem> item2 = new ArrayList<StatusUPSInfoItem>();
        item2.add(new StatusUPSInfoItem("[text.workMod]", "{workInfo.workMode}", ""));
        statusUpsInfolist2.setLines(item2);
        info.add(statusUpsInfolist2);
        StatusUPSInfoList statusUpsInfolist3 = new StatusUPSInfoList();
        statusUpsInfolist3.setLabel("[label.batteryInfo]");
        ArrayList<StatusUPSInfoItem> item3 = new ArrayList<StatusUPSInfoItem>();
        item3.add(new StatusUPSInfoItem("[text.mv.col4]", "{workInfo.batteryVoltage}", "V"));
        item3.add(new StatusUPSInfoItem("[text.BatteryPercent]", "{workInfo.batteryCapacity}", "%"));
        statusUpsInfolist3.setLines(item3);
        info.add(statusUpsInfolist3);
        StatusUPSInfoList statusUpsInfolist4 = new StatusUPSInfoList();
        statusUpsInfolist4.setLabel("[label.outputInfo]");
        ArrayList<StatusUPSInfoItem> item4 = new ArrayList<StatusUPSInfoItem>();
        item4.add(new StatusUPSInfoItem("[text.outputV]", "{workInfo.outputVoltage}", "V"));
        item4.add(new StatusUPSInfoItem("[text.outputF]", "{workInfo.outputFrequency}", "Hz"));
        item4.add(new StatusUPSInfoItem("[label.loadLevel]", "{workInfo.outputLoadPercent}", "%"));
        statusUpsInfolist4.setLines(item4);
        info.add(statusUpsInfolist4);
        statusUpsinfo.setInfo(info);
        return statusUpsinfo;
    }

    public WebMapping getWebMapping() {
        return null;
    }

    public void formatMonitorData(Object arg0) {
    }

    public AutoMenuList getMenuList() {
        AutoMenuList menuList = new AutoMenuList();
        ArrayList<AutoMenuOne> menus = new ArrayList<AutoMenuOne>();
        ArrayList<AutoMenuTwo> items1 = new ArrayList<AutoMenuTwo>();
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.passwordSet]", "password", "", "menu"), null));
        if (MyConstants.Customized.equals("NEXTVision") || MyConstants.Customized.equals("Forza")) {
            items1.add(new AutoMenuTwo(new AutoMenuItem("[label.smsemailSet]", "mobile", "", "menu"), null));
        } else {
            items1.add(new AutoMenuTwo(new AutoMenuItem("[label.smsinfoSet]", "mobile", "", "menu"), null));
            items1.add(new AutoMenuTwo(new AutoMenuItem("[label.emailSet]", "email", "", "menu"), null));
        }
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.electricEventSet]", "eleEvent", "", "menu"), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.netWeakUPSet]", "network", "", "menu"), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.setcom]", "setcom", "", "menu"), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.recorddata]", "recorddata", "", "menu"), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.modbussetting]", "modbus", "", "menu"), null));
        ArrayList<AutoMenuTwo> items2 = new ArrayList<AutoMenuTwo>();
        if (MyConstants.Customized.equals("NEXTVision") || MyConstants.Customized.equals("Forza")) {
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.shutdownParamSet]", "loadClose", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.remoteShutdownParamSet]", "remoteLoadClose", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.realTimeCtrl]", "onOff", "", "menu"), null));
            if (MyConstants.Customized.equals("ZTE")) {
                items2.add(new AutoMenuTwo(new AutoMenuItem("[label.controlParamSet]", "controlPara", "", "menu"), null));
            }
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.powerPlan]", "onOffPlan", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.autoTestPlan]", "testPlan", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.upsBurInfoSet]", "buy", "", "menu"), null));
        } else {
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.shutdownParamSet]", "loadClose", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.remoteShutdownParamSet]", "remoteLoadClose", "", "menu"), null));
            if (MyConstants.Customized.equals("ZTE")) {
                items2.add(new AutoMenuTwo(new AutoMenuItem("[label.controlParamSet]", "controlPara", "", "menu"), null));
            }
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.upsBurInfoSet]", "buy", "", "menu"), null));
        }
        ArrayList<AutoMenuTwo> items3 = new ArrayList<AutoMenuTwo>();
        items3.add(new AutoMenuTwo(new AutoMenuItem("[label.realTimeCtrl]", "onOff", "", "menu"), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("[label.powerPlan]", "onOffPlan", "", "menu"), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("[label.autoTestPlan]", "testPlan", "", "menu"), null));
        ArrayList<AutoMenuTwo> items4 = new ArrayList<AutoMenuTwo>();
        items4.add(new AutoMenuTwo(new AutoMenuItem("[label.realInfoView]", "immediately", "", "menu"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("[label.historyInfoView]", "historyInfo", "", "menu"), null));
        ArrayList<AutoMenuItem> temps = new ArrayList<AutoMenuItem>();
        temps.add(new AutoMenuItem("[label.Celsius]", "celsiur", "radio", "temp"));
        temps.add(new AutoMenuItem("[label.Fahrenheit]", "fahrenheit", "radio", "temp"));
        ArrayList<AutoMenuItem> dates = new ArrayList<AutoMenuItem>();
        dates.add(new AutoMenuItem("YYYY-MM-DD", "YYYY-MM-DD", "radio", "date"));
        dates.add(new AutoMenuItem("YYYY/MM/DD", "YYYY/MM/DD", "radio", "date"));
        dates.add(new AutoMenuItem("YYYY:MM:DD", "YYYY:MM:DD", "radio", "date"));
        dates.add(new AutoMenuItem("MM-DD-YYYY", "MM-DD-YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("MM/DD/YYYY", "MM/DD/YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("MM:DD:YYYY", "MM:DD:YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("DD-MM-YYYY", "DD-MM-YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("DD/MM/YYYY", "DD/MM/YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("DD:MM:YYYY", "DD:MM:YYYY", "radio", "date"));
        ArrayList<AutoMenuTwo> items5 = new ArrayList<AutoMenuTwo>();
        items5.add(new AutoMenuTwo(new AutoMenuItem("[label.temperatureUnit]", "temperature", "", ""), temps));
        items5.add(new AutoMenuTwo(new AutoMenuItem("[label.dateFormat]", "requireState", "", ""), dates));
        ArrayList<AutoMenuTwo> items6 = new ArrayList<AutoMenuTwo>();
        items6.add(new AutoMenuTwo(new AutoMenuItem("English", "English", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("French", "French", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("German", "German", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Italian", "Italian", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Polish", "Polish", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Portuguese", "Portuguese", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Russian", "Russian", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Spanish", "Spanish", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Ukrainian", "Ukrainian", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Turkish", "Turkish", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Czech", "Czech", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Simplified)", "Chinese", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Traditional)", "ChineseTW", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Japanese", "Japanese", "radio", "language"), null));
        ArrayList<AutoMenuTwo> items7 = new ArrayList<AutoMenuTwo>();
        items7.add(new AutoMenuTwo(new AutoMenuItem("[label.copyRight]", "copyRight", "", ""), null));
        List<AutoMenuItem> helps = MyConstants.getOnlineHelp();
        if (helps.size() > 1) {
            items7.add(new AutoMenuTwo(new AutoMenuItem("[label.systemHelp]", "systemHelp", "", ""), MyConstants.getOnlineHelp()));
        } else {
            Locale local = Locale.getDefault();
            String language = local.getLanguage();
            if ("zh".equals(language) && FileUtilites.checkFile("help_zh.swf")) {
                items7.add(new AutoMenuTwo(new AutoMenuItem("[label.systemHelp]", "systemHelp_zh", "", ""), null));
            } else if ("ru".equals(language) && FileUtilites.checkFile("help_ru.swf")) {
                items7.add(new AutoMenuTwo(new AutoMenuItem("[label.systemHelp]", "systemHelp_ru", "", ""), null));
            } else if ("tr".equals(language) && FileUtilites.checkFile("help_tr.swf")) {
                items7.add(new AutoMenuTwo(new AutoMenuItem("[label.systemHelp]", "systemHelp_tr", "", ""), null));
            } else {
                items7.add(new AutoMenuTwo(new AutoMenuItem("[label.systemHelp]", "systemHelp_en", "", ""), null));
            }
        }
        menus.add(new AutoMenuOne("[label.config]", "system", items1));
        if (MyConstants.Customized.equals("NEXTVision") || MyConstants.Customized.equals("Forza")) {
            menus.add(new AutoMenuOne("Console", "config", items2));
        } else {
            menus.add(new AutoMenuOne("[label.upsSet]", "config", items2));
            menus.add(new AutoMenuOne("[label.controlPlatform]", "control", items3));
            menus.add(new AutoMenuOne("[label.upsWatch]", "monitor", items4));
        }
        menus.add(new AutoMenuOne("[label.systemStyle]", "top", items5));
        menus.add(new AutoMenuOne("[label.language]", "top", items6));
        menus.add(new AutoMenuOne("[label.Help]", "top", items7));
        menuList.setMenuList(menus);
        return menuList;
    }

    public StatusUPSInfo getModulesInfo() {
        return null;
    }

    public void refreshData(CommunicateHandlerInterface arg0) {
    }

    public void setIophase(String arg0) {
        this.ioPhase31 = "1/1";
    }

    public void setProtocolPMV(String arg0) {
    }
}

