/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.protocol;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.data.bean.AutoMenuItem;
import cn.com.voltronicpower.data.bean.AutoMenuList;
import cn.com.voltronicpower.data.bean.AutoMenuOne;
import cn.com.voltronicpower.data.bean.AutoMenuTwo;
import cn.com.voltronicpower.data.bean.HistoryDataColumns;
import cn.com.voltronicpower.data.bean.HistoryDataItem;
import cn.com.voltronicpower.data.bean.HistoryMonitorColumns;
import cn.com.voltronicpower.data.bean.HistoryMonitorItem;
import cn.com.voltronicpower.data.bean.StatusPowerFlow;
import cn.com.voltronicpower.data.bean.StatusPowerFlowItem;
import cn.com.voltronicpower.data.bean.StatusUPSInfo;
import cn.com.voltronicpower.data.bean.StatusUPSInfoItem;
import cn.com.voltronicpower.data.bean.StatusUPSInfoList;
import cn.com.voltronicpower.data.bean.WebMapping;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.monitorcommunicate.ModbusHandler;
import cn.com.voltronicpower.monitorcommunicate.USBHandler;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class P98
implements IProtocol {
    public static final String I = "I";
    public static final String F = "F";
    public static final String Q1 = "Q1";
    public static final String T = "T";
    public static final String TL = "TL";
    public static final String Tn = "Tn";
    public static final String CT = "CT";
    public static final String SnRm = "SnRm";
    public static final String Sn = "Sn";
    public static final String C = "C";
    public static final String Q = "Q";
    public String ioPhase31 = "3/1";

    public void formatMonitorData(Object data) {
    }

    public String getEventFileName() {
        return null;
    }

    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        List item = columns.getColumns();
        item.add(new HistoryDataItem("[text.mv.col1]", "currentTime", "", "displayDate"));
        item.add(new HistoryDataItem("[text.inputV]", "inputVoltage", "inputV1", ""));
        item.add(new HistoryDataItem("[text.inputF]", "inputFrequency", "inputF1", ""));
        item.add(new HistoryDataItem("[text.outputV]", "outputVoltage", "outputVR", ""));
        item.add(new HistoryDataItem("[label.loadPercents]", "outputLoadPercent", "", "displayOutpuLoadPercents"));
        item.add(new HistoryDataItem("[text.BTV]", "batteryVoltage", "", ""));
        return columns;
    }

    public HistoryMonitorColumns getHistoryMonitorColumns() {
        HistoryMonitorColumns columns = new HistoryMonitorColumns();
        List items = columns.getColumns();
        items.add(new HistoryMonitorItem("[text.inputV]", "voltageLine", 300, "Voltage", "", "inputVoltage", "[text.inputV]"));
        items.add(new HistoryMonitorItem("[text.inputF]", "voltageLine", 300, "inputFrequency", "", "inputFrequency", "[text.inputF]"));
        items.add(new HistoryMonitorItem("[text.outputV]", "outputVoltageLine", 300, "Voltage", "", "outputVoltage", "[text.outputV]"));
        items.add(new HistoryMonitorItem("[label.loadPercents]", "loadArea", 100, "%", "", "outputLoadPercent", "[label.loadPercents]"));
        items.add(new HistoryMonitorItem("[text.BTV]", "batteryVoltage", 300, "Voltage", "", "batteryVoltage", "[text.BTV]"));
        return columns;
    }

    public AutoMenuList getMenuList() {
        AutoMenuList menuList = new AutoMenuList();
        ArrayList<AutoMenuOne> menus = new ArrayList<AutoMenuOne>();
        ArrayList<AutoMenuTwo> items1 = new ArrayList<AutoMenuTwo>();
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.passwordSet]", "password", "", "menu"), null));
        if (MyConstants.Customized.equals("NEXTVision") || MyConstants.Customized.equals("Forza")) {
            items1.add(new AutoMenuTwo(new AutoMenuItem("[label.smsemailSet]", "mobile", "", "menu"), null));
        } else {
            items1.add(new AutoMenuTwo(new AutoMenuItem("[label.smsinfoSet]", "mobile", "", "menu"), null));
            items1.add(new AutoMenuTwo(new AutoMenuItem("[label.emailSet]", "email", "", "menu"), null));
        }
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.electricEventSet]", "eleEvent", "", "menu"), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.netWeakUPSet]", "network", "", "menu"), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.setcom]", "setcom", "", "menu"), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.recorddata]", "recorddata", "", "menu"), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.modbussetting]", "modbus", "", "menu"), null));
        ArrayList<AutoMenuTwo> items2 = new ArrayList<AutoMenuTwo>();
        if (MyConstants.Customized.equals("NEXTVision") || MyConstants.Customized.equals("Forza")) {
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.shutdownParamSet]", "loadClose", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.remoteShutdownParamSet]", "remoteLoadClose", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.realTimeCtrl]", "onOff", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.powerPlan]", "onOffPlan", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.autoTestPlan]", "testPlan", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.upsBurInfoSet]", "buy", "", "menu"), null));
        } else {
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.shutdownParamSet]", "loadClose", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.remoteShutdownParamSet]", "remoteLoadClose", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.upsBurInfoSet]", "buy", "", "menu"), null));
        }
        ArrayList<AutoMenuTwo> items3 = new ArrayList<AutoMenuTwo>();
        items3.add(new AutoMenuTwo(new AutoMenuItem("[label.realTimeCtrl]", "onOff", "", "menu"), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("[label.powerPlan]", "onOffPlan", "", "menu"), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("[label.autoTestPlan]", "testPlan", "", "menu"), null));
        ArrayList<AutoMenuTwo> items4 = new ArrayList<AutoMenuTwo>();
        items4.add(new AutoMenuTwo(new AutoMenuItem("[label.realInfoView]", "immediately", "", "menu"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("[label.historyInfoView]", "historyInfo", "", "menu"), null));
        ArrayList<AutoMenuItem> temps = new ArrayList<AutoMenuItem>();
        temps.add(new AutoMenuItem("[label.Celsius]", "celsiur", "radio", "temp"));
        temps.add(new AutoMenuItem("[label.Fahrenheit]", "fahrenheit", "radio", "temp"));
        ArrayList<AutoMenuItem> dates = new ArrayList<AutoMenuItem>();
        dates.add(new AutoMenuItem("YYYY-MM-DD", "YYYY-MM-DD", "radio", "date"));
        dates.add(new AutoMenuItem("YYYY/MM/DD", "YYYY/MM/DD", "radio", "date"));
        dates.add(new AutoMenuItem("YYYY:MM:DD", "YYYY:MM:DD", "radio", "date"));
        dates.add(new AutoMenuItem("MM-DD-YYYY", "MM-DD-YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("MM/DD/YYYY", "MM/DD/YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("MM:DD:YYYY", "MM:DD:YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("DD-MM-YYYY", "DD-MM-YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("DD/MM/YYYY", "DD/MM/YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("DD:MM:YYYY", "DD:MM:YYYY", "radio", "date"));
        ArrayList<AutoMenuTwo> items5 = new ArrayList<AutoMenuTwo>();
        items5.add(new AutoMenuTwo(new AutoMenuItem("[label.temperatureUnit]", "temperature", "", ""), temps));
        items5.add(new AutoMenuTwo(new AutoMenuItem("[label.dateFormat]", "requireState", "", ""), dates));
        ArrayList<AutoMenuTwo> items6 = new ArrayList<AutoMenuTwo>();
        items6.add(new AutoMenuTwo(new AutoMenuItem("English", "English", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("French", "French", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("German", "German", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Italian", "Italian", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Polish", "Polish", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Portuguese", "Portuguese", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Russian", "Russian", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Spanish", "Spanish", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Ukrainian", "Ukrainian", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Turkish", "Turkish", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Czech", "Czech", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Simplified)", "Chinese", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Traditional)", "ChineseTW", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Japanese", "Japanese", "radio", "language"), null));
        ArrayList<AutoMenuTwo> items7 = new ArrayList<AutoMenuTwo>();
        items7.add(new AutoMenuTwo(new AutoMenuItem("[label.copyRight]", "copyRight", "", ""), null));
        List<AutoMenuItem> helps = MyConstants.getOnlineHelp();
        if (helps.size() > 1) {
            items7.add(new AutoMenuTwo(new AutoMenuItem("[label.systemHelp]", "systemHelp", "", ""), MyConstants.getOnlineHelp()));
        } else {
            items7.add(new AutoMenuTwo(new AutoMenuItem("[label.systemHelp]", "systemHelp_en", "", ""), null));
        }
        menus.add(new AutoMenuOne(MyConstants.getCustomerViewpower(), "system", items1));
        if (MyConstants.Customized.equals("NEXTVision") || MyConstants.Customized.equals("Forza")) {
            menus.add(new AutoMenuOne("Console", "config", items2));
        } else {
            menus.add(new AutoMenuOne("[label.upsSet]", "config", items2));
            menus.add(new AutoMenuOne("[label.controlPlatform]", "control", items3));
            menus.add(new AutoMenuOne("[label.upsWatch]", "monitor", items4));
        }
        menus.add(new AutoMenuOne("[label.systemStyle]", "top", items5));
        menus.add(new AutoMenuOne("[label.language]", "top", items6));
        menus.add(new AutoMenuOne("[label.Help]", "top", items7));
        menuList.setMenuList(menus);
        return menuList;
    }

    public String getProtocolID() {
        return "P98";
    }

    public StatusPowerFlow getStatusPowerFlow() {
        StatusPowerFlow statusPowerFlow = new StatusPowerFlow();
        ArrayList<StatusPowerFlowItem> inputlines = new ArrayList<StatusPowerFlowItem>();
        inputlines.add(new StatusPowerFlowItem("[text.inputV]:", "{workInfo.inputVoltage}", "V"));
        inputlines.add(new StatusPowerFlowItem("[text.inputF]:", "{workInfo.inputFrequency}", "Hz"));
        ArrayList<StatusPowerFlowItem> upslines = new ArrayList<StatusPowerFlowItem>();
        upslines.add(new StatusPowerFlowItem("[text.workMod]:", "{workInfo.workMode}", ""));
        upslines.add(new StatusPowerFlowItem("[text.internalTp]:", "{workInfo.temperatureView}", MyConstants.getTempUnit()));
        ArrayList<StatusPowerFlowItem> outputlines = new ArrayList<StatusPowerFlowItem>();
        outputlines.add(new StatusPowerFlowItem("[text.outputV]:", "{workInfo.outputVoltage}", "V"));
        outputlines.add(new StatusPowerFlowItem("[label.loadPercents]:", "{workInfo.outputLoadPercent}", "%"));
        ArrayList<StatusPowerFlowItem> batterylines = new ArrayList<StatusPowerFlowItem>();
        batterylines.add(new StatusPowerFlowItem("[text.BTV]:", "{workInfo.batteryVoltage}", "V"));
        batterylines.add(new StatusPowerFlowItem("[text.BatteryPercent]:", "{workInfo.batteryCapacity}", "%"));
        statusPowerFlow.setBattery(batterylines);
        statusPowerFlow.setInput(inputlines);
        statusPowerFlow.setOutput(outputlines);
        statusPowerFlow.setUpsInfo(upslines);
        return statusPowerFlow;
    }

    public StatusUPSInfo getStatusUPSInfo() {
        StatusUPSInfo statusUpsinfo = new StatusUPSInfo();
        ArrayList<StatusUPSInfoList> info = new ArrayList<StatusUPSInfoList>();
        StatusUPSInfoList statusUpsInfolist1 = new StatusUPSInfoList();
        statusUpsInfolist1.setLabel("[label.inputInfo]");
        ArrayList<StatusUPSInfoItem> item1 = new ArrayList<StatusUPSInfoItem>();
        item1.add(new StatusUPSInfoItem("[text.inputV]", "{workInfo.inputVoltage}", "V"));
        item1.add(new StatusUPSInfoItem("[text.inputF]", "{workInfo.inputFrequency}", "Hz"));
        statusUpsInfolist1.setLines(item1);
        info.add(statusUpsInfolist1);
        StatusUPSInfoList statusUpsInfolist2 = new StatusUPSInfoList();
        statusUpsInfolist2.setLabel("[label.upsInfo]");
        ArrayList<StatusUPSInfoItem> item2 = new ArrayList<StatusUPSInfoItem>();
        item2.add(new StatusUPSInfoItem("[text.workMod]", "{workInfo.workMode}", ""));
        String unitText = " \u2103";
        if (!"celsius".equals(PropertiesUtils.getGlobalConfig().getTemperature())) {
            unitText = " \u2109";
        }
        item2.add(new StatusUPSInfoItem("[text.upsTemperature]", "{workInfo.temperature}", unitText));
        statusUpsInfolist2.setLines(item2);
        info.add(statusUpsInfolist2);
        StatusUPSInfoList statusUpsInfolist3 = new StatusUPSInfoList();
        statusUpsInfolist3.setLabel("[label.batteryInfo]");
        ArrayList<StatusUPSInfoItem> item3 = new ArrayList<StatusUPSInfoItem>();
        item3.add(new StatusUPSInfoItem("[text.mv.col4]", "{workInfo.batteryVoltage}", "V"));
        item3.add(new StatusUPSInfoItem("[text.BatteryPercent]", "{workInfo.batteryCapacity}", "%"));
        statusUpsInfolist3.setLines(item3);
        info.add(statusUpsInfolist3);
        StatusUPSInfoList statusUpsInfolist4 = new StatusUPSInfoList();
        statusUpsInfolist4.setLabel("[label.outputInfo]");
        ArrayList<StatusUPSInfoItem> item4 = new ArrayList<StatusUPSInfoItem>();
        item4.add(new StatusUPSInfoItem("[text.outputV]", "{workInfo.outputVoltage}", "V"));
        item4.add(new StatusUPSInfoItem("[label.loadLevel]", "{workInfo.outputLoadPercent}", "%"));
        statusUpsInfolist4.setLines(item4);
        info.add(statusUpsInfolist4);
        statusUpsinfo.setInfo(info);
        return statusUpsinfo;
    }

    public WebMapping getWebMapping() {
        return null;
    }

    public boolean isCouldExcuteBatteryTest(WorkInfo workInfo) {
        String workMode = workInfo.getWorkMode();
        return workMode.equals("Line mode");
    }

    public boolean matchProtocol(CommunicateHandlerInterface handler) {
        System.out.println("\u5339\u914dp98\u554a");
        if (handler instanceof ModbusHandler || handler instanceof USBHandler) {
            return false;
        }
        System.out.println("p981");
        handler.setCheckSum(false);
        handler.setCrcCheck(false);
        String dataStr = "(NAK";
        boolean isP98 = false;
        try {
            System.out.println("p982");
            int i = 0;
            while (i < 5) {
                if (!dataStr.equals("(NAK")) break;
                dataStr = handler.excuteSimpleCommand(I);
                ++i;
            }
            if (isP98 = dataStr.startsWith("#")) {
                dataStr = "(NAK";
                i = 0;
                while (i < 5) {
                    if (!dataStr.equals("(NAK")) break;
                    dataStr = handler.excuteSimpleCommand(Q1);
                    ++i;
                }
                isP98 = dataStr.startsWith("(");
            }
            if (isP98) {
                dataStr = "(NAK";
                i = 0;
                while (i < 5) {
                    if (!dataStr.equals("(NAK")) break;
                    dataStr = handler.excuteSimpleCommand("QPI");
                    ++i;
                }
                isP98 = !dataStr.startsWith("(PI");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("\u5339\u914d\u534f\u8bae p98");
        return isP98;
    }

    public StatusUPSInfo getModulesInfo() {
        return null;
    }

    public void refreshData(CommunicateHandlerInterface arg0) {
    }

    public static void main(String[] args) {
        double cellBatteryV = Double.parseDouble("2.05");
        double rateBatteryV = Double.parseDouble("36.0");
        double batteryV = rateBatteryV / 12.0 * 6.0 * cellBatteryV;
        System.out.println(batteryV);
    }

    public void setIophase(String arg0) {
    }

    public void setProtocolPMV(String arg0) {
    }
}

