/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.protocol;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.data.bean.HistoryDataColumns;
import cn.com.voltronicpower.data.bean.HistoryDataItem;
import cn.com.voltronicpower.data.bean.HistoryMonitorColumns;
import cn.com.voltronicpower.data.bean.HistoryMonitorItem;
import cn.com.voltronicpower.data.bean.StatusPowerFlow;
import cn.com.voltronicpower.data.bean.StatusPowerFlowItem;
import cn.com.voltronicpower.data.bean.StatusUPSInfo;
import cn.com.voltronicpower.data.bean.StatusUPSInfoItem;
import cn.com.voltronicpower.data.bean.StatusUPSInfoList;
import cn.com.voltronicpower.data.bean.WebMapping;
import cn.com.voltronicpower.monitor.protocol.P010203;
import cn.com.voltronicpower.monitorcommunicate.ModbusHandler;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import java.util.ArrayList;
import java.util.List;

public class P71
extends P010203 {
    public static final String QBS = "QBS";
    public static final String QTIME = "QTIME";
    public static final String MNCHGC = "MNCHGC00";
    public static final String POPM = "POPM";
    public static final String QBEQI = "QBEQI";
    public static final String QDI = "QDI";

    @Override
    public boolean matchProtocol(CommunicateHandlerInterface handler) {
        boolean result = false;
        if (handler instanceof ModbusHandler) {
            return result;
        }
        handler.setCheckSum(false);
        handler.setCrcCheck(false);
        String dataStr = "(NAK";
        try {
            int i = 0;
            while (i < 5) {
                if (!dataStr.equals("(NAK")) break;
                dataStr = handler.excuteSimpleCommand("QPI");
                ++i;
            }
            if (dataStr.startsWith("(PI") && dataStr.endsWith("71")) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String getEventFileName() {
        return null;
    }

    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        List item = columns.getColumns();
        item.add(new HistoryDataItem("[text.mv.col1]", "currentTime", "", "displayDate"));
        item.add(new HistoryDataItem("[text.inputV]", "inputVoltage", "inputV1", ""));
        item.add(new HistoryDataItem("[text.inputF]", "inputFrequency", "", "displayInputFrequency"));
        item.add(new HistoryDataItem("[text.outputV]", "outputVoltage", "outputVR", ""));
        item.add(new HistoryDataItem("[text.outputF]", "outputFrequency", "", ""));
        item.add(new HistoryDataItem("[text.loadEle]", "outputCurrent", "", "displayOutputCurrent"));
        item.add(new HistoryDataItem("[label.loadPercents]", "outputLoadPercent", "", "displayOutpuLoadPercents"));
        item.add(new HistoryDataItem("[text.BTV]", "batteryVoltage", "", ""));
        item.add(new HistoryDataItem("[text.BatteryCC]", "chargeCurr", "", "chargeCurr"));
        item.add(new HistoryDataItem("[text.BatteryDC]", "dischargeCurr", "", "dischargeCurr"));
        item.add(new HistoryDataItem("[text.BatteryPercent]", "batteryCapacity", "", "batteryCapacity"));
        item.add(new HistoryDataItem("[text.inputV.PV]", "inputVoltagePV", "", "inputVoltagePV"));
        item.add(new HistoryDataItem("[text.inputPower.PV]", "inputPowerPV", "", "inputPowerPV"));
        item.add(new HistoryDataItem("[text.upsTemperature]", "temperature", "", "calTemp"));
        return columns;
    }

    public HistoryMonitorColumns getHistoryMonitorColumns() {
        HistoryMonitorColumns columns = new HistoryMonitorColumns();
        List items = columns.getColumns();
        items.add(new HistoryMonitorItem("[text.inputV]", "voltageLine", 300, "Voltage", "", "inputVoltage", "[text.inputV]"));
        items.add(new HistoryMonitorItem("[text.inputF]", "frequencyLine", 70, "Hz", "inputFLine", "inputFrequency", "[text.inputF]"));
        items.add(new HistoryMonitorItem("[text.outputV]", "outputVoltageLine", 300, "Voltage", "", "outputVoltage", "[text.outputV]"));
        items.add(new HistoryMonitorItem("[text.outputF]", "outputFrequencyLine", 70, "Hz", "", "outputFrequency", "[text.outputF]"));
        items.add(new HistoryMonitorItem("[text.loadEle]", "currentLine", 80, "A", "", "outputCurrent", "[text.loadEle]"));
        items.add(new HistoryMonitorItem("[label.loadPercents]", "loadArea", 100, "%", "", "outputLoadPercent", "[label.loadPercents]"));
        items.add(new HistoryMonitorItem("[text.BTV]", "batteryVoltage", 300, "Voltage", "", "batteryVoltage", "[text.BTV]"));
        items.add(new HistoryMonitorItem("[text.BatteryCC]", "chargeCurr", 300, "A", "", "chargeCurr", "[text.BatteryCC]"));
        items.add(new HistoryMonitorItem("[text.BatteryDC]", "dischargeCurr", 300, "A", "", "dischargeCurr", "[text.BatteryDC]"));
        items.add(new HistoryMonitorItem("[text.BatteryPercent]", "batteryCapacity", 300, "%", "", "batteryCapacity", "[text.BatteryPercent]"));
        items.add(new HistoryMonitorItem("[text.inputV.PV]", "inputVoltagePV", 300, "V", "", "inputVoltagePV", "[text.inputV.PV]"));
        items.add(new HistoryMonitorItem("[text.inputPower.PV]", "inputPowerPV", 300, "W", "", "inputPowerPV", "[text.inputPower.PV]"));
        items.add(new HistoryMonitorItem("[text.upsTemperature]", "temperatureLine", 180, "Degree", "", "temperature", "[text.upsTemperature]"));
        return columns;
    }

    public String getProtocolID() {
        return "P71";
    }

    public StatusPowerFlow getStatusPowerFlow() {
        StatusPowerFlow statusPowerFlow = new StatusPowerFlow();
        List inputlines = statusPowerFlow.getInput();
        inputlines.add(new StatusPowerFlowItem("[text.inputV]:", "{workInfo.inputVoltage}", "V"));
        inputlines.add(new StatusPowerFlowItem("[text.inputF]:", "{workInfo.inputFrequency}", "Hz"));
        List upslines = statusPowerFlow.getUpsInfo();
        upslines.add(new StatusPowerFlowItem("[text.workMod]:", "{workInfo.workMode}", ""));
        upslines.add(new StatusPowerFlowItem("[text.internalTp]:", "{workInfo.temperature}", MyConstants.getTempUnit()));
        List outputlines = statusPowerFlow.getOutput();
        outputlines.add(new StatusPowerFlowItem("[text.outputV]:", "{workInfo.outputVoltage}", "V"));
        outputlines.add(new StatusPowerFlowItem("[text.outputF]:", "{workInfo.outputFrequency}", "Hz"));
        outputlines.add(new StatusPowerFlowItem("[text.loadEle]:", "{workInfo.outputCurrent}", "A"));
        outputlines.add(new StatusPowerFlowItem("[label.loadPercents]:", "{workInfo.outputLoadPercent}", "%"));
        List batterylines = statusPowerFlow.getBattery();
        batterylines.add(new StatusPowerFlowItem("[text.BTV]:", "{workInfo.batteryVoltage}", "V"));
        batterylines.add(new StatusPowerFlowItem("[text.BatteryCC]:", "{workInfo.chargeCurr}", "A"));
        batterylines.add(new StatusPowerFlowItem("[text.BatteryDC]:", "{workInfo.dischargeCurr}", "A"));
        batterylines.add(new StatusPowerFlowItem("[text.BatteryPercent]:", "{workInfo.batteryCapacity}", "%"));
        List solarlines = statusPowerFlow.getSolarInfoLines();
        solarlines.add(new StatusPowerFlowItem("[text.inputV.PV]:", "{workInfo.inputVoltagePV}", "V"));
        solarlines.add(new StatusPowerFlowItem("[text.inputPower.PV]:", "{workInfo.inputPowerPV}", "W"));
        return statusPowerFlow;
    }

    public StatusUPSInfo getStatusUPSInfo() {
        StatusUPSInfo statusUpsinfo = new StatusUPSInfo();
        ArrayList<StatusUPSInfoList> info = new ArrayList<StatusUPSInfoList>();
        StatusUPSInfoList statusUpsInfolist1 = new StatusUPSInfoList();
        statusUpsInfolist1.setLabel("[label.inputInfo]");
        ArrayList<StatusUPSInfoItem> item1 = new ArrayList<StatusUPSInfoItem>();
        item1.add(new StatusUPSInfoItem("[text.inputV]", "{workInfo.inputVoltage}", "V"));
        item1.add(new StatusUPSInfoItem("[text.inputF]", "{workInfo.inputFrequency}", "Hz"));
        statusUpsInfolist1.setLines(item1);
        info.add(statusUpsInfolist1);
        StatusUPSInfoList statusUpsInfolist2 = new StatusUPSInfoList();
        statusUpsInfolist2.setLabel("[label.upsInfo]");
        ArrayList<StatusUPSInfoItem> item2 = new ArrayList<StatusUPSInfoItem>();
        item2.add(new StatusUPSInfoItem("[text.workMod]", "{workInfo.workMode}", ""));
        item2.add(new StatusUPSInfoItem("[text.upsTemperature]", "{workInfo.temperature}", MyConstants.getTempUnit()));
        statusUpsInfolist2.setLines(item2);
        info.add(statusUpsInfolist2);
        StatusUPSInfoList statusUpsInfolist3 = new StatusUPSInfoList();
        statusUpsInfolist3.setLabel("[label.batteryInfo]");
        ArrayList<StatusUPSInfoItem> item3 = new ArrayList<StatusUPSInfoItem>();
        item3.add(new StatusUPSInfoItem("[text.BTV]", "{workInfo.batteryVoltage}", "V"));
        item3.add(new StatusUPSInfoItem("[text.BatteryCC]", "{workInfo.chargeCurr}", "A"));
        item3.add(new StatusUPSInfoItem("[text.BatteryDC]", "{workInfo.dischargeCurr}", "A"));
        item3.add(new StatusUPSInfoItem("[text.BatteryPercent]", "{workInfo.batteryCapacity}", "%"));
        statusUpsInfolist3.setLines(item3);
        info.add(statusUpsInfolist3);
        StatusUPSInfoList statusUpsInfolist4 = new StatusUPSInfoList();
        statusUpsInfolist4.setLabel("[label.outputInfo]");
        ArrayList<StatusUPSInfoItem> item4 = new ArrayList<StatusUPSInfoItem>();
        item4.add(new StatusUPSInfoItem("[text.outputV]", "{workInfo.outputVoltage}", "V"));
        item4.add(new StatusUPSInfoItem("[text.outputF]", "{workInfo.outputFrequency}", "Hz"));
        item4.add(new StatusUPSInfoItem("[label.loadLevel]", "{workInfo.outputLoadPercent}", "%"));
        item4.add(new StatusUPSInfoItem("[text.loadEle]", "{workInfo.outputCurrent}", "A"));
        statusUpsInfolist4.setLines(item4);
        info.add(statusUpsInfolist4);
        StatusUPSInfoList statusUpsInfolist5 = new StatusUPSInfoList();
        statusUpsInfolist5.setLabel("[label.solarInfo]");
        ArrayList<StatusUPSInfoItem> item5 = new ArrayList<StatusUPSInfoItem>();
        item5.add(new StatusUPSInfoItem("[text.inputV.PV]", "{workInfo.inputVoltagePV}", "V"));
        item5.add(new StatusUPSInfoItem("[text.inputPower.PV]", "{workInfo.inputPowerPV}", "W"));
        statusUpsInfolist5.setLines(item5);
        info.add(statusUpsInfolist5);
        statusUpsinfo.setInfo(info);
        return statusUpsinfo;
    }

    public WebMapping getWebMapping() {
        return null;
    }
}

