/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.protocol;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.data.bean.HistoryDataColumns;
import cn.com.voltronicpower.data.bean.HistoryDataItem;
import cn.com.voltronicpower.data.bean.HistoryMonitorColumns;
import cn.com.voltronicpower.data.bean.HistoryMonitorItem;
import cn.com.voltronicpower.data.bean.MonitorData;
import cn.com.voltronicpower.data.bean.StatusPowerFlow;
import cn.com.voltronicpower.data.bean.StatusPowerFlowItem;
import cn.com.voltronicpower.data.bean.StatusUPSInfo;
import cn.com.voltronicpower.data.bean.StatusUPSInfoItem;
import cn.com.voltronicpower.data.bean.StatusUPSInfoList;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.monitor.protocol.P35;
import cn.com.voltronicpower.monitorcommunicate.ModbusHandler;
import java.util.ArrayList;
import java.util.List;

public class P40
extends P35 {
    private String noSupportStr = "010";

    @Override
    public String getProtocolID() {
        return "P40";
    }

    @Override
    public boolean matchProtocol(CommunicateHandlerInterface handler) {
        boolean result = false;
        if (handler instanceof ModbusHandler) {
            return result;
        }
        handler.setCheckSum(false);
        handler.setCrcCheck(true);
        String dataStr = "(NAK";
        try {
            int i = 0;
            while (i < 5) {
                if (!dataStr.equals("(NAK")) break;
                dataStr = handler.excuteSimpleCommandP40("SEC_QPI");
                ++i;
            }
            if (dataStr.contains("40")) {
                result = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return result;
    }

    @Override
    public void formatMonitorData(Object monitor) {
        MonitorData data = (MonitorData)monitor;
        WorkInfo workInfo = data.getWorkInfo();
        if (data.getCapability().isEnableB()) {
            workInfo.setConverterMode("[label.enable]");
        } else {
            workInfo.setConverterMode("[label.disable]");
        }
        if (data.getCapability().isEnableA()) {
            workInfo.setEcomode("[label.enable]");
        } else {
            workInfo.setEcomode("[label.disable]");
        }
        if (data.getCapability().isEnableF()) {
            workInfo.setBypassOff("[label.enable]");
        } else {
            workInfo.setBypassOff("[label.disable]");
        }
        if (data.getCapability().isEnableE()) {
            workInfo.setBypassNotAllowed("[label.enable]");
        } else {
            workInfo.setBypassNotAllowed("[label.disable]");
        }
    }

    @Override
    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        List item = columns.getColumns();
        item.add(new HistoryDataItem("[text.mv.col1]", "currentTime", "", "displayDate"));
        item.add(new HistoryDataItem("[text.inputV] L1-N", "inputVoltage", "inputVL1", ""));
        item.add(new HistoryDataItem("[text.inputV] L2-N", "inputVoltageS", "inputVL2", ""));
        item.add(new HistoryDataItem("[text.inputV] L3-N", "inputVoltageT", "inputVL3", ""));
        item.add(new HistoryDataItem("[text.inputF]", "inputFrequency", "", "displayInputFrequency"));
        if (this.ioPhase31.equals("3/3")) {
            item.add(new HistoryDataItem("[text.bypassVoltage] L1-N", "bypassVoltageS", "bypassVS", ""));
            item.add(new HistoryDataItem("[text.bypassVoltage] L2-N", "bypassVoltageS", "bypassVS", ""));
            item.add(new HistoryDataItem("[text.bypassVoltage] L3-N", "bypassVoltageT", "bypassVT", ""));
        } else {
            item.add(new HistoryDataItem("[text.bypassVoltage]", "bypassVoltage", "bypassVR", ""));
        }
        item.add(new HistoryDataItem("[text.bypassFrequency]", "bypassFrequency", "bypassF", ""));
        if (this.ioPhase31.equals("3/3")) {
            item.add(new HistoryDataItem("[text.outputV] L1-N", "outputVoltage", "outputVR", ""));
            item.add(new HistoryDataItem("[text.outputV] L2-N", "outputVoltageS", "outputVS", ""));
            item.add(new HistoryDataItem("[text.outputV] L3-N", "outputVoltageT", "outputVT", ""));
            item.add(new HistoryDataItem("[text.loadEle] L1-N", "outputCurrent", "outputCR", ""));
            item.add(new HistoryDataItem("[text.loadEle] L2-N", "outputCurrentS", "outputCS", ""));
            item.add(new HistoryDataItem("[text.loadEle] L3-N", "outputCurrentT", "outputCT", ""));
            item.add(new HistoryDataItem("[text.outputF]", "outputFrequency", "", ""));
            item.add(new HistoryDataItem("[label.loadPercents] L1", "loadLevel", "loadR", ""));
            item.add(new HistoryDataItem("[label.loadPercents] L2", "loadLevelS", "loadS", ""));
            item.add(new HistoryDataItem("[label.loadPercents] L3", "loadLevelT", "loadT", ""));
        } else {
            item.add(new HistoryDataItem("[text.outputV]", "outputVoltage", "outputVR", ""));
            item.add(new HistoryDataItem("[text.loadEle]", "outputCurrent", "outputCR", ""));
            item.add(new HistoryDataItem("[text.outputF]", "outputFrequency", "", ""));
        }
        item.add(new HistoryDataItem("[label.loadPercents]", "outputLoadPercent", "", "displayOutpuLoadPercents"));
        item.add(new HistoryDataItem("[text.BTV]", "batteryVoltage", "", ""));
        item.add(new HistoryDataItem("[text.BatteryPercent]", "batteryCapacity", "", ""));
        return columns;
    }

    @Override
    public HistoryMonitorColumns getHistoryMonitorColumns() {
        HistoryMonitorColumns columns = new HistoryMonitorColumns();
        List items = columns.getColumns();
        items.add(new HistoryMonitorItem("[text.inputV] L1-N", "voltageLine", 300, "Voltage", "", "inputVoltage", "[text.inputV] L1-N"));
        items.add(new HistoryMonitorItem("[text.inputV] L2-N", "voltageLineS", 300, "Voltage", "", "inputVoltageS", "[text.inputV] L2-N"));
        items.add(new HistoryMonitorItem("[text.inputV] L3-N", "voltageLineT", 300, "Voltage", "", "inputVoltageT", "[text.inputV] L3-N"));
        items.add(new HistoryMonitorItem("[text.inputF]", "frequencyLine", 70, "Hz", "inputFLine", "inputFrequency", "[text.inputF]"));
        if (this.ioPhase31.equals("3/3")) {
            items.add(new HistoryMonitorItem("[text.bypassVoltage] L1-N", "bypassVoltage", 300, "Voltage", "", "bypassVoltage", "[text.bypassVoltage] L1-N"));
            items.add(new HistoryMonitorItem("[text.bypassVoltage] L2-N", "bypassVoltageS", 300, "Voltage", "", "bypassVoltageS", "[text.bypassVoltage] L2-N"));
            items.add(new HistoryMonitorItem("[text.bypassVoltage] L3-N", "bypassVoltageT", 300, "Voltage", "", "bypassVoltageT", "[text.bypassVoltage] L3-N"));
        } else {
            items.add(new HistoryMonitorItem("[text.bypassVoltage]", "bypassVoltage", 300, "Voltage", "", "bypassVoltage", "[text.bypassVoltage]"));
        }
        items.add(new HistoryMonitorItem("[text.bypassFrequency]", "bypassFrequency", 70, "Hz", "", "bypassFrequency", "[text.bypassFrequency]"));
        if (this.ioPhase31.equals("3/3")) {
            items.add(new HistoryMonitorItem("[text.outputV] L1-N", "outputVoltageLine", 300, "Voltage", "", "outputVoltage", "[text.outputV] L1-N"));
            items.add(new HistoryMonitorItem("[text.outputV] L2-N", "outputVoltageS", 300, "Voltage", "", "outputVoltageS", "[text.outputV] L2-N"));
            items.add(new HistoryMonitorItem("[text.outputV] L3-N", "outputVoltageT", 300, "Voltage", "", "outputVoltageT", "[text.outputV] L3-N"));
            items.add(new HistoryMonitorItem("[text.loadEle] L1-N", "outputCurrent", 80, "A", "", "outputCurrent", "[text.loadEle] L1-N"));
            items.add(new HistoryMonitorItem("[text.loadEle] L2-N", "outputCurrentS", 80, "A", "", "outputCurrentS", "[text.loadEle] L2-N"));
            items.add(new HistoryMonitorItem("[text.loadEle] L3-N", "outputCurrentT", 80, "A", "", "outputCurrentT", "[text.loadEle] L3-N"));
            items.add(new HistoryMonitorItem("[text.outputF]", "outputFrequencyLine", 70, "Hz", "", "outputFrequency", "[text.outputF]"));
            items.add(new HistoryMonitorItem("[label.loadPercents] L1", "loadLevel", 100, "%", "", "loadLevel", "[label.loadPercents] L1"));
            items.add(new HistoryMonitorItem("[label.loadPercents] L2", "loadLevelS", 100, "%", "", "loadLevelS", "[label.loadPercents] L2"));
            items.add(new HistoryMonitorItem("[label.loadPercents] L3", "loadLevelT", 100, "%", "", "loadLevelT", "[label.loadPercents] L3"));
        } else {
            items.add(new HistoryMonitorItem("[text.outputV]", "outputVoltageLine", 300, "Voltage", "", "outputVoltage", "[text.outputV]"));
            items.add(new HistoryMonitorItem("[text.loadEle]", "outputCurrent", 80, "A", "", "outputCurrent", "[text.loadEle]"));
            items.add(new HistoryMonitorItem("[text.outputF]", "outputFrequencyLine", 70, "Hz", "", "outputFrequency", "[text.outputF]"));
        }
        items.add(new HistoryMonitorItem("[label.loadPercents]", "loadArea", 100, "%", "", "outputLoadPercent", "[label.loadPercents]"));
        items.add(new HistoryMonitorItem("[text.BTV]", "batteryVoltage", 300, "Voltage", "", "batteryVoltage", "[text.BTV]"));
        items.add(new HistoryMonitorItem("[text.BatteryPercent]", "batteryCapacity", 100, "%", "", "batteryCapacity", "[text.BatteryPercent]"));
        return columns;
    }

    @Override
    public StatusPowerFlow getStatusPowerFlow() {
        StatusPowerFlow statusPowerFlow = new StatusPowerFlow();
        List inputlines = statusPowerFlow.getInput();
        inputlines.add(new StatusPowerFlowItem("[text.inputV] L1-N:", "{workInfo.inputVoltage}", "V"));
        inputlines.add(new StatusPowerFlowItem("[text.inputV] L2-N:", "{workInfo.inputVoltageS}", "V"));
        inputlines.add(new StatusPowerFlowItem("[text.inputV] L3-N:", "{workInfo.inputVoltageT}", "V"));
        inputlines.add(new StatusPowerFlowItem("[text.inputF]:", "{workInfo.inputFrequency}", "Hz"));
        List upslines = statusPowerFlow.getUpsInfo();
        upslines.add(new StatusPowerFlowItem("[text.workMod]:", "{workInfo.workMode}", ""));
        List outputlines = statusPowerFlow.getOutput();
        if (this.ioPhase31.equals("3/3")) {
            outputlines.add(new StatusPowerFlowItem("[text.outputV] L1-N:", "{workInfo.outputVoltage}", "V"));
            outputlines.add(new StatusPowerFlowItem("[text.outputV] L2-N:", "{workInfo.outputVoltageS}", "V"));
            outputlines.add(new StatusPowerFlowItem("[text.outputV] L3-N:", "{workInfo.outputVoltageT}", "V"));
            outputlines.add(new StatusPowerFlowItem("[text.loadEle] L1-N", "{workInfo.outputCurrent}", "A"));
            outputlines.add(new StatusPowerFlowItem("[text.loadEle] L2-N", "{workInfo.outputCurrentS}", "A"));
            outputlines.add(new StatusPowerFlowItem("[text.loadEle] L3-N", "{workInfo.outputCurrentT}", "A"));
            outputlines.add(new StatusPowerFlowItem("[text.outputF]:", "{workInfo.outputFrequency}", "Hz"));
            outputlines.add(new StatusPowerFlowItem("[label.loadPercents] L1:", "{workInfo.loadLevel}", "%"));
            outputlines.add(new StatusPowerFlowItem("[label.loadPercents] L2:", "{workInfo.loadLevelS}", "%"));
            outputlines.add(new StatusPowerFlowItem("[label.loadPercents] L3:", "{workInfo.loadLevelT}", "%"));
            outputlines.add(new StatusPowerFlowItem("[label.loadPercents]:", "{workInfo.outputLoadPercent}", "%"));
        } else {
            outputlines.add(new StatusPowerFlowItem("[text.outputV]:", "{workInfo.outputVoltage}", "V"));
            outputlines.add(new StatusPowerFlowItem("[text.loadEle]", "{workInfo.outputCurrent}", "A"));
            outputlines.add(new StatusPowerFlowItem("[text.outputF]:", "{workInfo.outputFrequency}", "Hz"));
            outputlines.add(new StatusPowerFlowItem("[label.loadPercents]:", "{workInfo.outputLoadPercent}", "%"));
        }
        List batterylines = statusPowerFlow.getBattery();
        batterylines.add(new StatusPowerFlowItem("[text.BTV]:", "{workInfo.batteryVoltage}", "V"));
        batterylines.add(new StatusPowerFlowItem("[text.BatteryPercent]:", "{workInfo.batteryCapacity}", "%"));
        List bypasslines = statusPowerFlow.getBypassInfoLines();
        if (this.ioPhase31.equals("3/3")) {
            bypasslines.add(new StatusPowerFlowItem("[text.bypassVoltage] L1-N:", "{workInfo.bypassVoltage}", "V"));
            bypasslines.add(new StatusPowerFlowItem("[text.bypassVoltage] L2-N:", "{workInfo.bypassVoltageS}", "V"));
            bypasslines.add(new StatusPowerFlowItem("[text.bypassVoltage] L3-N:", "{workInfo.bypassVoltageT}", "V"));
        } else {
            bypasslines.add(new StatusPowerFlowItem("[text.bypassVoltage]:", "{workInfo.bypassVoltage}", "V"));
        }
        bypasslines.add(new StatusPowerFlowItem("[text.bypassFrequency]:", "{workInfo.bypassFrequency}", "Hz"));
        return statusPowerFlow;
    }

    @Override
    public StatusUPSInfo getStatusUPSInfo() {
        StatusUPSInfo statusUpsinfo = new StatusUPSInfo();
        ArrayList<StatusUPSInfoList> info = new ArrayList<StatusUPSInfoList>();
        StatusUPSInfoList statusUpsInfolist1 = new StatusUPSInfoList();
        statusUpsInfolist1.setLabel("[label.inputInfo]");
        ArrayList<StatusUPSInfoItem> item1 = new ArrayList<StatusUPSInfoItem>();
        item1.add(new StatusUPSInfoItem("[text.inputV] L1-N", "{workInfo.inputVoltage}", "V"));
        item1.add(new StatusUPSInfoItem("[text.inputV] L2-N", "{workInfo.inputVoltageS}", "V"));
        item1.add(new StatusUPSInfoItem("[text.inputV] L3-N", "{workInfo.inputVoltageT}", "V"));
        item1.add(new StatusUPSInfoItem("[text.inputF]", "{workInfo.inputFrequency}", "Hz"));
        statusUpsInfolist1.setLines(item1);
        info.add(statusUpsInfolist1);
        StatusUPSInfoList statusUpsInfolist5 = new StatusUPSInfoList();
        statusUpsInfolist5.setLabel("[text.bypassInfo]");
        ArrayList<StatusUPSInfoItem> item5 = new ArrayList<StatusUPSInfoItem>();
        if (this.ioPhase31.equals("3/3")) {
            item5.add(new StatusUPSInfoItem("[text.bypassVoltage] L1-N", "{workInfo.bypassVoltage}", "V"));
            item5.add(new StatusUPSInfoItem("[text.bypassVoltage] L2-N", "{workInfo.bypassVoltageS}", "V"));
            item5.add(new StatusUPSInfoItem("[text.bypassVoltage] L3-N", "{workInfo.bypassVoltageT}", "V"));
        } else {
            item5.add(new StatusUPSInfoItem("[text.bypassVoltage]", "{workInfo.bypassVoltage}", "V"));
        }
        item5.add(new StatusUPSInfoItem("[text.bypassFrequency]", "{workInfo.bypassFrequency}", "Hz"));
        statusUpsInfolist5.setLines(item5);
        info.add(statusUpsInfolist5);
        StatusUPSInfoList statusUpsInfolist2 = new StatusUPSInfoList();
        statusUpsInfolist2.setLabel("[label.upsInfo]");
        ArrayList<StatusUPSInfoItem> item2 = new ArrayList<StatusUPSInfoItem>();
        item2.add(new StatusUPSInfoItem("[text.workMod]", "{workInfo.workMode}", ""));
        item2.add(new StatusUPSInfoItem("[label.converterMode]", "{workInfo.converterMode}", ""));
        item2.add(new StatusUPSInfoItem("[label.eCOMode]", "{workInfo.ecomode}", ""));
        item2.add(new StatusUPSInfoItem("[label.bypassOff]", "{workInfo.bypassOff}", ""));
        item2.add(new StatusUPSInfoItem("[label.bypassNotAllowed]", "{!workInfo.bypassNotAllowed}", ""));
        statusUpsInfolist2.setLines(item2);
        info.add(statusUpsInfolist2);
        StatusUPSInfoList statusUpsInfolist3 = new StatusUPSInfoList();
        statusUpsInfolist3.setLabel("[label.batteryInfo]");
        ArrayList<StatusUPSInfoItem> item3 = new ArrayList<StatusUPSInfoItem>();
        item3.add(new StatusUPSInfoItem("[text.BTV]", "{workInfo.batteryVoltage}", "V"));
        item3.add(new StatusUPSInfoItem("[text.BatteryPercent]", "{workInfo.batteryCapacity}", "%"));
        statusUpsInfolist3.setLines(item3);
        info.add(statusUpsInfolist3);
        StatusUPSInfoList statusUpsInfolist4 = new StatusUPSInfoList();
        statusUpsInfolist4.setLabel("[label.outputInfo]");
        ArrayList<StatusUPSInfoItem> item4 = new ArrayList<StatusUPSInfoItem>();
        if (this.ioPhase31.equals("3/3")) {
            item4.add(new StatusUPSInfoItem("[text.outputV] L1-N", "{workInfo.outputVoltage}", "V"));
            item4.add(new StatusUPSInfoItem("[text.outputV] L2-N", "{workInfo.outputVoltageS}", "V"));
            item4.add(new StatusUPSInfoItem("[text.outputV] L3-N", "{workInfo.outputVoltageT}", "V"));
            item4.add(new StatusUPSInfoItem("[text.loadEle] L1-N", "{workInfo.outputCurrent}", "A"));
            item4.add(new StatusUPSInfoItem("[text.loadEle] L2-N", "{workInfo.outputCurrentS}", "A"));
            item4.add(new StatusUPSInfoItem("[text.loadEle] L3-N", "{workInfo.outputCurrentT}", "A"));
            item4.add(new StatusUPSInfoItem("[text.outputF]", "{workInfo.outputFrequency}", "Hz"));
            item4.add(new StatusUPSInfoItem("[label.loadPercents] L1", "{workInfo.loadLevel}", "%"));
            item4.add(new StatusUPSInfoItem("[label.loadPercents] L2", "{workInfo.loadLevelS}", "%"));
            item4.add(new StatusUPSInfoItem("[label.loadPercents] L3", "{workInfo.loadLevelT}", "%"));
        } else {
            item4.add(new StatusUPSInfoItem("[text.outputV]", "{workInfo.outputVoltage}", "V"));
            item4.add(new StatusUPSInfoItem("[text.outputF]", "{workInfo.outputFrequency}", "Hz"));
            item4.add(new StatusUPSInfoItem("[text.loadEle]", "{workInfo.outputCurrent}", "A"));
        }
        item4.add(new StatusUPSInfoItem("[label.loadLevel]", "{workInfo.outputLoadPercent}", "%"));
        statusUpsInfolist4.setLines(item4);
        info.add(statusUpsInfolist4);
        statusUpsinfo.setInfo(info);
        return statusUpsinfo;
    }
}

