/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.protocol;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.data.bean.AutoMenuList;
import cn.com.voltronicpower.data.bean.HistoryDataColumns;
import cn.com.voltronicpower.data.bean.HistoryDataItem;
import cn.com.voltronicpower.data.bean.HistoryMonitorColumns;
import cn.com.voltronicpower.data.bean.HistoryMonitorItem;
import cn.com.voltronicpower.data.bean.StatusPowerFlow;
import cn.com.voltronicpower.data.bean.StatusPowerFlowItem;
import cn.com.voltronicpower.data.bean.StatusUPSInfo;
import cn.com.voltronicpower.data.bean.StatusUPSInfoItem;
import cn.com.voltronicpower.data.bean.StatusUPSInfoList;
import cn.com.voltronicpower.data.bean.WebMapping;
import cn.com.voltronicpower.monitor.protocol.P010203;
import cn.com.voltronicpower.monitor.protocol.P36;
import cn.com.voltronicpower.monitor.protocol.P38;
import cn.com.voltronicpower.monitorcommunicate.ModbusHandler;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.Log;
import java.util.ArrayList;
import java.util.List;

public class P35
extends P010203 {
    private static final Log logger = new Log();
    private int phaseIndex = 0;
    private static int isDual = 0;
    public String pids;

    public String getProtocolID() {
        return "P35";
    }

    public String getEventFileName() {
        return null;
    }

    @Override
    public boolean matchProtocol(CommunicateHandlerInterface handler) {
        if (handler instanceof ModbusHandler) {
            return false;
        }
        handler.setCheckSum(false);
        handler.setCrcCheck(false);
        String dataStr = "(NAK";
        try {
            int i = 0;
            while (i < 5) {
                if (dataStr != null && dataStr.equals("(NAK")) {
                    dataStr = handler.excuteSimpleCommand("SEC_QPI");
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dataStr != null && dataStr.startsWith("PI") && (dataStr.endsWith("35") && this instanceof P35 || dataStr.endsWith("36") && this instanceof P36 || dataStr.endsWith("38") && this instanceof P38 || dataStr.contains("35") && this instanceof P35 || dataStr.contains("36") && this instanceof P36 || dataStr.contains("38") && this instanceof P38)) {
            this.pids = dataStr;
            return true;
        }
        return false;
    }

    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        List item = columns.getColumns();
        item.add(new HistoryDataItem("[text.mv.col1]", "currentTime", "", "displayDate"));
        if (this.ioPhase31.equals("1/1")) {
            item.add(new HistoryDataItem("[text.inputV] L1-N", "inputVoltage", "inputVL", ""));
        } else {
            item.add(new HistoryDataItem("[text.inputV] L1-N", "inputVoltage", "inputVL1", ""));
            item.add(new HistoryDataItem("[text.inputV] L2-N", "inputVoltageS", "inputVL2", ""));
            item.add(new HistoryDataItem("[text.inputV] L3-N", "inputVoltageT", "inputVL3", ""));
        }
        item.add(new HistoryDataItem("[text.inputF]", "inputFrequency", "", "displayInputFrequency"));
        if (isDual == 1) {
            if (this.ioPhase31.equals("3/3")) {
                item.add(new HistoryDataItem("[text.inputV2] L1-N", "bypassVoltage", "bypassVR", ""));
                item.add(new HistoryDataItem("[text.inputV2] L2-N", "bypassVoltageS", "bypassVS", ""));
                item.add(new HistoryDataItem("[text.inputV2] L3-N", "bypassVoltageT", "bypassVT", ""));
            } else {
                item.add(new HistoryDataItem("[text.inputV2]", "bypassVoltage", "bypassVR", ""));
            }
            item.add(new HistoryDataItem("[text.inputF2]", "bypassFrequency", "bypassF", ""));
        } else {
            if (this.ioPhase31.equals("3/3")) {
                item.add(new HistoryDataItem("[text.bypassVoltage] L1-N", "bypassVoltage", "bypassVR", ""));
                item.add(new HistoryDataItem("[text.bypassVoltage] L2-N", "bypassVoltageS", "bypassVS", ""));
                item.add(new HistoryDataItem("[text.bypassVoltage] L3-N", "bypassVoltageT", "bypassVT", ""));
            } else {
                item.add(new HistoryDataItem("[text.bypassVoltage]", "bypassVoltage", "bypassVR", ""));
            }
            item.add(new HistoryDataItem("[text.bypassFrequency]", "bypassFrequency", "bypassF", ""));
        }
        item.add(new HistoryDataItem("[text.outputVR]", "outputVoltage", "outputVR", ""));
        if (this.ioPhase31.equals("3/3")) {
            item.add(new HistoryDataItem("[text.outputVS]", "outputVoltageS", "outputVS", ""));
            item.add(new HistoryDataItem("[text.outputVT]", "outputVoltageT", "outputVT", ""));
        }
        if (this.ioPhase31.equals("3/3")) {
            item.add(new HistoryDataItem("[text.loadEle] L1-N", "outputCurrent", "outputCR", ""));
            item.add(new HistoryDataItem("[text.loadEle] L2-N", "outputCurrentS", "outputCS", ""));
            item.add(new HistoryDataItem("[text.loadEle] L3-N", "outputCurrentT", "outputCT", ""));
        } else {
            item.add(new HistoryDataItem("[text.loadEle]", "outputCurrent", "outputCR", ""));
        }
        item.add(new HistoryDataItem("[text.outputF]", "outputFrequency", "", ""));
        if (this.ioPhase31.equals("3/3")) {
            item.add(new HistoryDataItem("[label.loadPercents] L1", "loadLevel", "loadR", ""));
            item.add(new HistoryDataItem("[label.loadPercents] L2", "loadLevelS", "loadS", ""));
            item.add(new HistoryDataItem("[label.loadPercents] L3", "loadLevelT", "loadT", ""));
        }
        item.add(new HistoryDataItem("[label.loadPercents]", "outputLoadPercent", "", "displayOutpuLoadPercents"));
        item.add(new HistoryDataItem("[text.PBTV]", "positiveBatteryVoltage", "", ""));
        item.add(new HistoryDataItem("[text.NBTV]", "negativeBatteryVoltage", "", ""));
        item.add(new HistoryDataItem("[text.upsTemperature]", "temperatureView", "", "calTemp"));
        return columns;
    }

    public HistoryMonitorColumns getHistoryMonitorColumns() {
        HistoryMonitorColumns columns = new HistoryMonitorColumns();
        List items = columns.getColumns();
        if (this.ioPhase31.equals("1/1")) {
            items.add(new HistoryMonitorItem("[text.inputV]", "voltageLine", 300, "Voltage", "", "inputVoltage", "[text.inputV]"));
        } else {
            items.add(new HistoryMonitorItem("[text.inputV] L1-N", "voltageLine", 300, "Voltage", "", "inputVoltage", "[text.inputV] L1-N"));
            items.add(new HistoryMonitorItem("[text.inputV] L2-N", "voltageLineS", 300, "Voltage", "", "inputVoltageS", "[text.inputV] L2-N"));
            items.add(new HistoryMonitorItem("[text.inputV] L3-N", "voltageLineT", 300, "Voltage", "", "inputVoltageT", "[text.inputV] L3-N"));
        }
        items.add(new HistoryMonitorItem("[text.inputF]", "frequencyLine", 70, "Hz", "inputFLine", "inputFrequency", "[text.inputF]"));
        if (isDual == 1) {
            if (this.ioPhase31.equals("3/3")) {
                items.add(new HistoryMonitorItem("[text.inputV2] L1-N", "bypassVoltage", 300, "Voltage", "", "bypassVoltage", "[text.inputV2] L1-N"));
                items.add(new HistoryMonitorItem("[text.inputV2] L2-N", "bypassVoltageS", 300, "Voltage", "", "bypassVoltageS", "[text.inputV2] L2-N"));
                items.add(new HistoryMonitorItem("[text.inputV2] L3-N", "bypassVoltageT", 300, "Voltage", "", "bypassVoltageT", "[text.inputV2] L3-N"));
            } else {
                items.add(new HistoryMonitorItem("[text.inputV2]", "bypassVoltage", 300, "Voltage", "", "bypassVoltage", "[text.inputV2]"));
            }
            items.add(new HistoryMonitorItem("[text.inputF2]", "bypassFrequency", 70, "Hz", "", "bypassFrequency", "[text.inputF2]"));
        } else {
            if (this.ioPhase31.equals("3/3")) {
                items.add(new HistoryMonitorItem("[text.bypassVoltage] L1-N", "bypassVoltage", 300, "Voltage", "", "bypassVoltage", "[text.bypassVoltage] L1-N"));
                items.add(new HistoryMonitorItem("[text.bypassVoltage] L2-N", "bypassVoltageS", 300, "Voltage", "", "bypassVoltageS", "[text.bypassVoltage] L2-N"));
                items.add(new HistoryMonitorItem("[text.bypassVoltage] L3-N", "bypassVoltageT", 300, "Voltage", "", "bypassVoltageT", "[text.bypassVoltage] L3-N"));
            } else {
                items.add(new HistoryMonitorItem("[text.bypassVoltage]", "bypassVoltage", 300, "Voltage", "", "bypassVoltage", "[text.bypassVoltage]"));
            }
            items.add(new HistoryMonitorItem("[text.bypassFrequency]", "bypassFrequency", 70, "Hz", "", "bypassFrequency", "[text.bypassFrequency]"));
        }
        items.add(new HistoryMonitorItem("[text.outputVR]", "outputVoltageLine", 300, "Voltage", "", "outputVoltage", "[text.outputVR]"));
        if (this.ioPhase31.equals("3/3")) {
            items.add(new HistoryMonitorItem("[text.outputVS]", "outputVoltageS", 300, "Voltage", "", "outputVoltageS", "[text.outputVS]"));
            items.add(new HistoryMonitorItem("[text.outputVT]", "outputVoltageT", 300, "Voltage", "", "outputVoltageT", "[text.outputVT]"));
        }
        if (this.ioPhase31.equals("3/3")) {
            items.add(new HistoryMonitorItem("[text.loadEle] L1-N", "outputCurrent", 80, "A", "", "outputCurrent", "[text.loadEle] L1-N"));
            items.add(new HistoryMonitorItem("[text.loadEle] L2-N", "outputCurrentS", 80, "A", "", "outputCurrentS", "[text.loadEle] L2-N"));
            items.add(new HistoryMonitorItem("[text.loadEle] L3-N", "outputCurrentT", 80, "A", "", "outputCurrentT", "[text.loadEle] L3-N"));
        } else {
            items.add(new HistoryMonitorItem("[text.loadEle]", "outputCurrent", 80, "A", "", "outputCurrent", "[text.loadEle]"));
        }
        items.add(new HistoryMonitorItem("[text.outputF]", "outputFrequencyLine", 70, "Hz", "", "outputFrequency", "[text.outputF]"));
        if (this.ioPhase31.equals("3/3")) {
            items.add(new HistoryMonitorItem("[label.loadPercents] L1", "loadLevel", 100, "%", "", "loadLevel", "[label.loadPercents] L1-N"));
            items.add(new HistoryMonitorItem("[label.loadPercents] L2", "loadLevelS", 100, "%", "", "loadLevelS", "[label.loadPercents] L2-N"));
            items.add(new HistoryMonitorItem("[label.loadPercents] L3", "loadLevelT", 100, "%", "", "loadLevelT", "[label.loadPercents] L3-N"));
        }
        items.add(new HistoryMonitorItem("[label.loadPercents]", "loadArea", 100, "%", "", "outputLoadPercent", "[label.loadPercents]"));
        items.add(new HistoryMonitorItem("[text.PBTV]", "positiveBatteryVoltage", 300, "Voltage", "", "positiveBatteryVoltage", "[text.PBTV]"));
        items.add(new HistoryMonitorItem("[text.NBTV]", "negativeBatteryVoltage", 300, "Voltage", "", "negativeBatteryVoltage", "[text.NBTV]"));
        items.add(new HistoryMonitorItem("[text.upsTemperature]", "temperatureLine", 180, "Degree", "", "temperatureView", "[text.upsTemperature]"));
        return columns;
    }

    public StatusPowerFlow getStatusPowerFlow() {
        StatusPowerFlow statusPowerFlow = new StatusPowerFlow();
        List inputlines = statusPowerFlow.getInput();
        if (this.ioPhase31.equals("1/1")) {
            inputlines.add(new StatusPowerFlowItem("[text.inputV] L1-N:", "{workInfo.inputVoltage}", "V"));
        } else {
            inputlines.add(new StatusPowerFlowItem("[text.inputV] L1-N:", "{workInfo.inputVoltage}", "V"));
            inputlines.add(new StatusPowerFlowItem("[text.inputV] L2-N:", "{workInfo.inputVoltageS}", "V"));
            inputlines.add(new StatusPowerFlowItem("[text.inputV] L3-N:", "{workInfo.inputVoltageT}", "V"));
        }
        inputlines.add(new StatusPowerFlowItem("[text.inputF]:", "{workInfo.inputFrequency}", "Hz"));
        List upslines = statusPowerFlow.getUpsInfo();
        upslines.add(new StatusPowerFlowItem("[text.workMod]:", "{workInfo.workMode}", ""));
        upslines.add(new StatusPowerFlowItem("[text.internalTp]:", "{workInfo.temperatureView}", MyConstants.getTempUnit()));
        List outputlines = statusPowerFlow.getOutput();
        outputlines.add(new StatusPowerFlowItem("[text.outputVR]", "{workInfo.outputVoltage}", "V"));
        if (this.ioPhase31.equals("3/3")) {
            outputlines.add(new StatusPowerFlowItem("[text.outputVS]", "{workInfo.outputVoltageS}", "V"));
            outputlines.add(new StatusPowerFlowItem("[text.outputVT]", "{workInfo.outputVoltageT}", "V"));
        }
        if (this.ioPhase31.equals("3/3")) {
            outputlines.add(new StatusPowerFlowItem("[text.loadEle] L1-N", "{workInfo.outputCurrent}", "A"));
            outputlines.add(new StatusPowerFlowItem("[text.loadEle] L2-N", "{workInfo.outputCurrentS}", "A"));
            outputlines.add(new StatusPowerFlowItem("[text.loadEle] L3-N", "{workInfo.outputCurrentT}", "A"));
        } else {
            outputlines.add(new StatusPowerFlowItem("[text.loadEle]", "{workInfo.outputCurrent}", "A"));
        }
        outputlines.add(new StatusPowerFlowItem("[text.outputF]:", "{workInfo.outputFrequency}", "Hz"));
        if (this.ioPhase31.equals("3/3")) {
            outputlines.add(new StatusPowerFlowItem("[label.loadPercents] L1:", "{workInfo.loadLevel}", "%"));
            outputlines.add(new StatusPowerFlowItem("[label.loadPercents] L2:", "{workInfo.loadLevelS}", "%"));
            outputlines.add(new StatusPowerFlowItem("[label.loadPercents] L3:", "{workInfo.loadLevelT}", "%"));
        }
        outputlines.add(new StatusPowerFlowItem("[label.loadPercents]:", "{workInfo.outputLoadPercent}", "%"));
        List batterylines = statusPowerFlow.getBattery();
        batterylines.add(new StatusPowerFlowItem("[text.PBTV]:", "{workInfo.positiveBatteryVoltage}", "V"));
        batterylines.add(new StatusPowerFlowItem("[text.NBTV]:", "{workInfo.negativeBatteryVoltage}", "V"));
        batterylines.add(new StatusPowerFlowItem("[text.BatteryPercent]:", "{workInfo.batteryCapacity}", "%"));
        if (isDual == 1) {
            List inputlines2 = statusPowerFlow.getBypassInfoLines();
            if (this.ioPhase31.equals("3/3")) {
                inputlines2.add(new StatusPowerFlowItem("[text.inputV2] L1-N:", "{workInfo.bypassVoltage}", "V"));
                inputlines2.add(new StatusPowerFlowItem("[text.inputV2] L2-N:", "{workInfo.bypassVoltageS}", "V"));
                inputlines2.add(new StatusPowerFlowItem("[text.inputV2] L3-N:", "{workInfo.bypassVoltageT}", "V"));
            } else {
                inputlines2.add(new StatusPowerFlowItem("[text.inputV2]:", "{workInfo.bypassVoltage}", "V"));
            }
            inputlines2.add(new StatusPowerFlowItem("[text.inputF2]:", "{workInfo.bypassFrequency}", "Hz"));
        } else {
            List bypasslines = statusPowerFlow.getBypassInfoLines();
            bypasslines.add(new StatusPowerFlowItem("[text.bypassVoltage] L1-N:", "{workInfo.bypassVoltage}", "V"));
            if (this.ioPhase31.equals("3/3")) {
                bypasslines.add(new StatusPowerFlowItem("[text.bypassVoltage] L2-N:", "{workInfo.bypassVoltageS}", "V"));
                bypasslines.add(new StatusPowerFlowItem("[text.bypassVoltage] L3-N:", "{workInfo.bypassVoltageT}", "V"));
            }
            bypasslines.add(new StatusPowerFlowItem("[text.bypassFrequency]:", "{workInfo.bypassFrequency}", "Hz"));
        }
        return statusPowerFlow;
    }

    public StatusUPSInfo getStatusUPSInfo() {
        ArrayList<StatusUPSInfoItem> item5;
        StatusUPSInfoList statusUpsInfolist5;
        StatusUPSInfo statusUpsinfo = new StatusUPSInfo();
        ArrayList<StatusUPSInfoList> info = new ArrayList<StatusUPSInfoList>();
        StatusUPSInfoList statusUpsInfolist1 = new StatusUPSInfoList();
        statusUpsInfolist1.setLabel("[label.inputInfo]");
        ArrayList<StatusUPSInfoItem> item1 = new ArrayList<StatusUPSInfoItem>();
        if (this.ioPhase31.equals("1/1")) {
            item1.add(new StatusUPSInfoItem("[text.inputV]", "{workInfo.inputVoltage}", "V"));
        } else {
            item1.add(new StatusUPSInfoItem("[text.inputV] L1-N", "{workInfo.inputVoltage}", "V"));
            item1.add(new StatusUPSInfoItem("[text.inputV] L2-N", "{workInfo.inputVoltageS}", "V"));
            item1.add(new StatusUPSInfoItem("[text.inputV] L3-N", "{workInfo.inputVoltageT}", "V"));
        }
        item1.add(new StatusUPSInfoItem("[text.inputF]", "{workInfo.inputFrequency}", "Hz"));
        statusUpsInfolist1.setLines(item1);
        info.add(statusUpsInfolist1);
        if (isDual == 1) {
            statusUpsInfolist5 = new StatusUPSInfoList();
            statusUpsInfolist5.setLabel("[label.inputInfo2]");
            item5 = new ArrayList<StatusUPSInfoItem>();
            if (this.ioPhase31.equals("3/3")) {
                item5.add(new StatusUPSInfoItem("[text.inputV2] L1-N", "{workInfo.bypassVoltage}", "V"));
                item5.add(new StatusUPSInfoItem("[text.inputV2] L2-N", "{workInfo.bypassVoltageS}", "V"));
                item5.add(new StatusUPSInfoItem("[text.inputV2] L3-N", "{workInfo.bypassVoltageT}", "V"));
            } else {
                item5.add(new StatusUPSInfoItem("[text.inputV2]", "{workInfo.bypassVoltage}", "V"));
            }
            item5.add(new StatusUPSInfoItem("[text.inputF2]", "{workInfo.bypassFrequency}", "Hz"));
            statusUpsInfolist5.setLines(item5);
            info.add(statusUpsInfolist5);
        } else {
            statusUpsInfolist5 = new StatusUPSInfoList();
            statusUpsInfolist5.setLabel("[text.bypassInfo]");
            item5 = new ArrayList();
            if (this.ioPhase31.equals("3/3")) {
                item5.add(new StatusUPSInfoItem("[text.bypassVoltage] L1-N", "{workInfo.bypassVoltage}", "V"));
                item5.add(new StatusUPSInfoItem("[text.bypassVoltage] L2-N", "{workInfo.bypassVoltageS}", "V"));
                item5.add(new StatusUPSInfoItem("[text.bypassVoltage] L3-N", "{workInfo.bypassVoltageT}", "V"));
            } else {
                item5.add(new StatusUPSInfoItem("[text.bypassVoltage]", "{workInfo.bypassVoltage}", "V"));
            }
            item5.add(new StatusUPSInfoItem("[text.bypassFrequency]", "{workInfo.bypassFrequency}", "Hz"));
            statusUpsInfolist5.setLines(item5);
            info.add(statusUpsInfolist5);
        }
        StatusUPSInfoList statusUpsInfolist2 = new StatusUPSInfoList();
        statusUpsInfolist2.setLabel("[label.upsInfo]");
        ArrayList<StatusUPSInfoItem> item2 = new ArrayList<StatusUPSInfoItem>();
        item2.add(new StatusUPSInfoItem("[text.workMod]", "{workInfo.workMode}", ""));
        item2.add(new StatusUPSInfoItem("[text.upsTemperature]", "{workInfo.temperatureView}", MyConstants.getTempUnit()));
        item2.add(new StatusUPSInfoItem("[label.autoReboot]", "{workInfo.autoReboot}", ""));
        item2.add(new StatusUPSInfoItem("[label.converterMode]", "{workInfo.converterMode}", ""));
        item2.add(new StatusUPSInfoItem("[label.eCOMode]", "{workInfo.ecomode}", ""));
        item2.add(new StatusUPSInfoItem("[label.bypassOff]", "{workInfo.bypassOff}", ""));
        item2.add(new StatusUPSInfoItem("[label.bypassNotAllowed]", "{workInfo.bypassNotAllowed}", ""));
        item2.add(new StatusUPSInfoItem("[label.faultType]", "{workInfo.faultType}", ""));
        item2.add(new StatusUPSInfoItem("[label.warn]", "{workInfo.warnings}", ""));
        statusUpsInfolist2.setLines(item2);
        info.add(statusUpsInfolist2);
        StatusUPSInfoList statusUpsInfolist3 = new StatusUPSInfoList();
        statusUpsInfolist3.setLabel("[label.batteryInfo]");
        ArrayList<StatusUPSInfoItem> item3 = new ArrayList<StatusUPSInfoItem>();
        item3.add(new StatusUPSInfoItem("[text.PBTV]", "{workInfo.positiveBatteryVoltage}", "V"));
        item3.add(new StatusUPSInfoItem("[text.NBTV]:", "{workInfo.negativeBatteryVoltage}", "V"));
        item3.add(new StatusUPSInfoItem("[text.BatteryPercent]", "{workInfo.batteryCapacity}", "%"));
        statusUpsInfolist3.setLines(item3);
        info.add(statusUpsInfolist3);
        StatusUPSInfoList statusUpsInfolist4 = new StatusUPSInfoList();
        statusUpsInfolist4.setLabel("[label.outputInfo]");
        ArrayList<StatusUPSInfoItem> item4 = new ArrayList<StatusUPSInfoItem>();
        item4.add(new StatusUPSInfoItem("[text.outputVR]", "{workInfo.outputVoltage}", "V"));
        if (this.ioPhase31.equals("3/3")) {
            item4.add(new StatusUPSInfoItem("[text.outputVS]", "{workInfo.outputVoltageS}", "V"));
            item4.add(new StatusUPSInfoItem("[text.outputVT]", "{workInfo.outputVoltageT}", "V"));
        }
        if (this.ioPhase31.equals("3/3")) {
            item4.add(new StatusUPSInfoItem("[text.loadEle] L1-N", "{workInfo.outputCurrent}", "A"));
            item4.add(new StatusUPSInfoItem("[text.loadEle] L2-N", "{workInfo.outputCurrentS}", "A"));
            item4.add(new StatusUPSInfoItem("[text.loadEle] L3-N", "{workInfo.outputCurrentT}", "A"));
        } else {
            item4.add(new StatusUPSInfoItem("[text.loadEle]", "{workInfo.outputCurrent}", "A"));
        }
        item4.add(new StatusUPSInfoItem("[text.outputF]", "{workInfo.outputFrequency}", "Hz"));
        if (this.ioPhase31.equals("3/3")) {
            item4.add(new StatusUPSInfoItem("[label.loadPercents] L1", "{workInfo.loadLevel}", "%"));
            item4.add(new StatusUPSInfoItem("[label.loadPercents] L2", "{workInfo.loadLevelS}", "%"));
            item4.add(new StatusUPSInfoItem("[label.loadPercents] L3", "{workInfo.loadLevelT}", "%"));
        }
        item4.add(new StatusUPSInfoItem("[label.loadLevel]", "{workInfo.outputLoadPercent}", "%"));
        statusUpsInfolist4.setLines(item4);
        info.add(statusUpsInfolist4);
        statusUpsinfo.setInfo(info);
        return statusUpsinfo;
    }

    public WebMapping getWebMapping() {
        return null;
    }

    @Override
    public AutoMenuList getMenuList() {
        return super.getMenuList();
    }
}

