/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.protocol;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.data.bean.HistoryDataColumns;
import cn.com.voltronicpower.data.bean.HistoryDataItem;
import cn.com.voltronicpower.data.bean.HistoryMonitorColumns;
import cn.com.voltronicpower.data.bean.HistoryMonitorItem;
import cn.com.voltronicpower.data.bean.StatusPowerFlow;
import cn.com.voltronicpower.data.bean.StatusPowerFlowItem;
import cn.com.voltronicpower.data.bean.StatusUPSInfo;
import cn.com.voltronicpower.data.bean.StatusUPSInfoItem;
import cn.com.voltronicpower.data.bean.StatusUPSInfoList;
import cn.com.voltronicpower.data.bean.WebMapping;
import cn.com.voltronicpower.monitor.protocol.P010203;
import cn.com.voltronicpower.monitor.protocol.P39;
import cn.com.voltronicpower.monitorcommunicate.ModbusHandler;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class P33
extends P010203 {
    private static final Log log = new Log();
    public static final String QPAR = "QPAR";
    public static final String QIDN = "QIDN";
    public static final String Q3GSN = "Q3GSN";
    public static final String Q3YVN = "Q3YVN";
    public static final String QYFN = "QYFN";
    public static final String QYF = "QYF";
    public static final String Q3LDN = "Q3LDN";
    public static final String QMODN = "QMODN";
    public static final String QFSN = "QFSN";
    public static final String QWSN = "Q3WSN";
    public static final String QNBV = "QNBV";
    public static final String Q3GS = "Q3GS";
    public static final String Q3WS = "Q3WS";
    public static final String QMID = "QMID";
    public static final String Q3PVN = "Q3PVN";
    public static final String QCHGC = "QCHGC";
    public static final String QBCO = "QBCO";
    public static final String QBTAH = "QBTAH";
    public static final String QPST = "QPST";
    public static final String QBID = "QBID";
    public static final String QBTD = "QBTD";
    public static final String CHGC = "CHGC";
    public static final String BATCO = "BATCO";
    public static final String BATTAH = "BATTAH";
    public static final String PST = "PST";
    public static final String TSET = "TSET";
    public static final String SBDT = "SBDT";
    public static final String SBLV = "SBLV";
    public static final String SBLC = "SBLC";
    public static final String SBSC = "SBSC";
    public static final String SBTSV = "SBTSV";
    public static final String SBTSC = "SBTSC";
    public static final String SBTST = "SBTST";
    public static final String SEAF = "SEAF";
    public static final String SCVF = "SCVF";
    public static final String UPSBYP = "UPSBYP";
    public static final String QPRI = "QPRI";
    public static final String QBMD = "QBMD";
    public static final String QSID = "QSID";
    public static final String QSMD = "QSMD";
    public static final String QRBAT = "QRBAT";
    public static final String SCB = "SCB";
    public static final String SSID = "SSID";
    public static final String SSMD = "SSMD";
    public static final String SBID = "SBID";
    public static final String SBMD = "SBMD";
    private String ioPhase22 = "";
    private static int phaseIndex;
    private StatusUPSInfo _modules = new StatusUPSInfo();
    private HashMap<String, String> snidmap = new HashMap();

    public int getPhaseIndex() {
        return phaseIndex;
    }

    public void setPhaseIndex(int phaseIndex) {
        P33.phaseIndex = phaseIndex;
    }

    public String getEventFileName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, String> getSNIDMap() {
        P33 p33 = this;
        synchronized (p33) {
            return this.snidmap;
        }
    }

    @Override
    public boolean matchProtocol(CommunicateHandlerInterface handler) {
        block15: {
            block16: {
                if (handler instanceof ModbusHandler) {
                    return false;
                }
                handler.setCheckSum(false);
                handler.setCrcCheck(false);
                String dataStr = "(NAK";
                try {
                    int i = 0;
                    while (i < 5) {
                        if (dataStr.equals("(NAK")) {
                            dataStr = handler.excuteSimpleCommand("QPI");
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception i) {
                    // empty catch block
                }
                log.info("QPI return" + dataStr);
                if (!dataStr.startsWith("(PI")) break block15;
                if (dataStr.endsWith("33") && this instanceof P33) break block16;
                if (!dataStr.endsWith("39") || !(this instanceof P39)) break block15;
            }
            try {
                while (this.ioPhase22 == null || this.ioPhase22.equals("") || this.ioPhase22.equalsIgnoreCase("(NAK")) {
                    this.ioPhase22 = handler.excuteSimpleCommand("QMD");
                }
                if (this.ioPhase22.indexOf("2/2") != -1) {
                    phaseIndex = 22;
                } else if (this.ioPhase22.indexOf("3/1") != -1) {
                    phaseIndex = 31;
                } else if (this.ioPhase22.indexOf("3/3") != -1) {
                    phaseIndex = 33;
                }
                this.refreshData(handler);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        List item = columns.getColumns();
        item.add(new HistoryDataItem("[text.mv.col1]", "currentTime", "", "displayDate"));
        item.add(new HistoryDataItem("[text.inputV] L1-N", "inputVoltage", "inputVL", ""));
        if (phaseIndex == 33 || phaseIndex == 31) {
            item.add(new HistoryDataItem("[text.inputV] L2-N", "inputVoltageS", "inputVL2", ""));
            item.add(new HistoryDataItem("[text.inputV] L3-N", "inputVoltageT", "inputVL3", ""));
        } else if (phaseIndex == 22) {
            item.add(new HistoryDataItem("[text.inputV] L2-N", "inputVoltageT", "inputVL2", ""));
        }
        item.add(new HistoryDataItem("[text.inputF]", "inputFrequency", "", "displayInputFrequency"));
        if (phaseIndex == 33) {
            item.add(new HistoryDataItem("[text.outputV] L1-N", "outputVoltage", "outputVR", ""));
            item.add(new HistoryDataItem("[text.outputV] L2-N", "outputVoltageS", "outputVS", ""));
            item.add(new HistoryDataItem("[text.outputV] L3-N", "outputVoltageT", "outputVT", ""));
        } else if (phaseIndex == 22) {
            item.add(new HistoryDataItem("[text.outputV] L1-N", "outputVoltage", "outputVR", ""));
            item.add(new HistoryDataItem("[text.outputV] L2-N", "outputVoltageT", "outputVT", ""));
        } else {
            item.add(new HistoryDataItem("[text.outputV]", "outputVoltage", "outputVR", ""));
        }
        item.add(new HistoryDataItem("[text.outputF]", "outputFrequency", "", ""));
        if (phaseIndex == 33) {
            item.add(new HistoryDataItem("[text.loadEle] L1-N", "outputCurrent", "outputCR", ""));
            item.add(new HistoryDataItem("[text.loadEle] L2-N", "outputCurrentS", "outputCS", ""));
            item.add(new HistoryDataItem("[text.loadEle] L3-N", "outputCurrentT", "outputCT", ""));
        } else if (phaseIndex == 22) {
            item.add(new HistoryDataItem("[text.loadEle] L1-N", "outputCurrent", "outputCR", ""));
            item.add(new HistoryDataItem("[text.loadEle] L2-N", "outputCurrentT", "outputCT", ""));
        } else {
            item.add(new HistoryDataItem("[text.loadEle]", "outputCurrent", "outputCR", ""));
        }
        if (phaseIndex == 33) {
            item.add(new HistoryDataItem("[label.loadPercents] L1", "loadLevel", "loadR", ""));
            item.add(new HistoryDataItem("[label.loadPercents] L2", "loadLevelS", "loadS", ""));
            item.add(new HistoryDataItem("[label.loadPercents] L3", "loadLevelT", "loadT", ""));
        } else if (phaseIndex == 22) {
            item.add(new HistoryDataItem("[label.loadPercents] L1", "loadLevel", "loadR", ""));
            item.add(new HistoryDataItem("[label.loadPercents] L2", "loadLevelT", "loadT", ""));
        }
        item.add(new HistoryDataItem("[label.loadPercents]", "outputLoadPercent", "", "displayOutpuLoadPercents"));
        if (phaseIndex == 33) {
            item.add(new HistoryDataItem("[text.bypassVoltage] L1-N", "bypassVoltage", "bypassVR", ""));
            item.add(new HistoryDataItem("[text.bypassVoltage] L2-N", "bypassVoltageS", "bypassVS", ""));
            item.add(new HistoryDataItem("[text.bypassVoltage] L3-N", "bypassVoltageT", "bypassVT", ""));
        } else if (phaseIndex == 22) {
            item.add(new HistoryDataItem("[text.bypassVoltage] L1-N", "bypassVoltage", "bypassVR", ""));
            item.add(new HistoryDataItem("[text.bypassVoltage] L2-N", "bypassVoltageT", "bypassVT", ""));
        } else {
            item.add(new HistoryDataItem("[text.bypassVoltage]", "bypassVoltage", "bypassVR", ""));
        }
        item.add(new HistoryDataItem("[text.bypassFrequency]", "bypassFrequency", "bypassF", ""));
        item.add(new HistoryDataItem("[text.PBTV]", "positiveBatteryVoltage", "", ""));
        item.add(new HistoryDataItem("[text.PBTCH]", "positiveBatteryCurrent", "", ""));
        item.add(new HistoryDataItem("[text.NBTV]", "negativeBatteryVoltage", "", ""));
        item.add(new HistoryDataItem("[text.NBTCH]", "negativeBatteryCurrent", "", ""));
        item.add(new HistoryDataItem("[text.BatteryPercent]", "batteryCapacity", "", ""));
        item.add(new HistoryDataItem("[text.upsTemperature]", "temperatureView", "", "calTemp"));
        return columns;
    }

    public HistoryMonitorColumns getHistoryMonitorColumns() {
        HistoryMonitorColumns columns = new HistoryMonitorColumns();
        List items = columns.getColumns();
        items.add(new HistoryMonitorItem("[text.inputV] L1-N", "voltageLine", 300, "Voltage", "", "inputVoltage", "[text.inputV] L1-N"));
        if (phaseIndex == 33 || phaseIndex == 31) {
            items.add(new HistoryMonitorItem("[text.inputV] L2-N", "voltageLineS", 300, "Voltage", "", "inputVoltageS", "[text.inputV] L2-N"));
            items.add(new HistoryMonitorItem("[text.inputV] L3-N", "voltageLineT", 300, "Voltage", "", "inputVoltageT", "[text.inputV] L3-N"));
        } else if (phaseIndex == 22) {
            items.add(new HistoryMonitorItem("[text.inputV] L2-N", "voltageLineT", 300, "Voltage", "", "inputVoltageT", "[text.inputV] L2-N"));
        }
        items.add(new HistoryMonitorItem("[text.inputF]", "frequencyLine", 70, "Hz", "inputFLine", "inputFrequency", "[text.inputF]"));
        if (phaseIndex == 33) {
            items.add(new HistoryMonitorItem("[text.outputV] L1-N", "outputVoltageLine", 300, "Voltage", "", "outputVoltage", "[text.outputV] L1-N"));
            items.add(new HistoryMonitorItem("[text.outputV] L2-N", "outputVoltageS", 300, "Voltage", "", "outputVoltageS", "[text.outputV] L2-N"));
            items.add(new HistoryMonitorItem("[text.outputV] L3-N", "outputVoltageT", 300, "Voltage", "", "outputVoltageT", "[text.outputV] L3-N"));
        } else if (phaseIndex == 22) {
            items.add(new HistoryMonitorItem("[text.outputV] L1-N", "outputVoltageLine", 300, "Voltage", "", "outputVoltage", "[text.outputV] L1-N"));
            items.add(new HistoryMonitorItem("[text.outputV] L2-N", "outputVoltageT", 300, "Voltage", "", "outputVoltageT", "[text.outputV] L2-N"));
        } else {
            items.add(new HistoryMonitorItem("[text.outputV]", "outputVoltageLine", 300, "Voltage", "", "outputVoltage", "[text.outputV]"));
        }
        items.add(new HistoryMonitorItem("[text.outputF]", "outputFrequencyLine", 70, "Hz", "", "outputFrequency", "[text.outputF]"));
        if (phaseIndex == 33) {
            items.add(new HistoryMonitorItem("[text.loadEle] L1-N", "outputCurrent", 80, "A", "", "outputCurrent", "[text.loadEle] L1-N"));
            items.add(new HistoryMonitorItem("[text.loadEle] L2-N", "outputCurrentS", 80, "A", "", "outputCurrentS", "[text.loadEle] L2-N"));
            items.add(new HistoryMonitorItem("[text.loadEle] L3-N", "outputCurrentT", 80, "A", "", "outputCurrentT", "[text.loadEle] L3-N"));
        } else if (phaseIndex == 22) {
            items.add(new HistoryMonitorItem("[text.loadEle] L1-N", "outputCurrent", 80, "A", "", "outputCurrent", "[text.loadEle] L1-N"));
            items.add(new HistoryMonitorItem("[text.loadEle] L2-N", "outputCurrentT", 80, "A", "", "outputCurrentT", "[text.loadEle] L2-N"));
        } else {
            items.add(new HistoryMonitorItem("[text.loadEle]", "outputCurrent", 80, "A", "", "outputCurrent", "[text.loadEle]"));
        }
        if (phaseIndex == 33) {
            items.add(new HistoryMonitorItem("[label.loadPercents] L1", "loadLevel", 100, "%", "", "loadLevel", "[label.loadPercents] L1"));
            items.add(new HistoryMonitorItem("[label.loadPercents] L2", "loadLevelS", 100, "%", "", "loadLevelS", "[label.loadPercents] L2"));
            items.add(new HistoryMonitorItem("[label.loadPercents] L3", "loadLevelT", 100, "%", "", "loadLevelT", "[label.loadPercents] L3"));
        } else if (phaseIndex == 22) {
            items.add(new HistoryMonitorItem("[label.loadPercents] L1", "loadLevel", 100, "%", "", "loadLevel", "[label.loadPercents] L1-N"));
            items.add(new HistoryMonitorItem("[label.loadPercents] L2", "loadLevelT", 100, "%", "", "loadLevelT", "[label.loadPercents] L2-N"));
        }
        items.add(new HistoryMonitorItem("[label.loadPercents]", "loadArea", 100, "%", "", "outputLoadPercent", "[label.loadPercents]"));
        if (phaseIndex == 33) {
            items.add(new HistoryMonitorItem("[text.bypassVoltage] L1-N", "bypassVoltage", 300, "Voltage", "", "bypassVoltage", "[text.bypassVoltage] L1-N"));
            items.add(new HistoryMonitorItem("[text.bypassVoltage] L2-N", "bypassVoltageS", 300, "Voltage", "", "bypassVoltageS", "[text.bypassVoltage] L2-N"));
            items.add(new HistoryMonitorItem("[text.bypassVoltage] L3-N", "bypassVoltageT", 300, "Voltage", "", "bypassVoltageT", "[text.bypassVoltage] L3-N"));
        } else if (phaseIndex == 22) {
            items.add(new HistoryMonitorItem("[text.bypassVoltage] L1-N", "bypassVoltage", 300, "Voltage", "", "bypassVoltage", "[text.bypassVoltage] L1-N"));
            items.add(new HistoryMonitorItem("[text.bypassVoltage] L2-N", "bypassVoltageT", 300, "Voltage", "", "bypassVoltageT", "[text.bypassVoltage] L2-N"));
        } else {
            items.add(new HistoryMonitorItem("[text.bypassVoltage]", "bypassVoltage", 300, "Voltage", "", "bypassVoltage", "[text.bypassVoltage]"));
        }
        items.add(new HistoryMonitorItem("[text.bypassFrequency]", "bypassFrequency", 70, "Hz", "", "bypassFrequency", "[text.bypassFrequency]"));
        items.add(new HistoryMonitorItem("[text.PBTV]", "positiveBatteryVoltage", 300, "Voltage", "", "positiveBatteryVoltage", "[text.PBTV]"));
        items.add(new HistoryMonitorItem("[text.PBTCH]", "positiveBatteryCurrent", 100, "A", "", "positiveBatteryCurrent", "[text.PBTCH]"));
        items.add(new HistoryMonitorItem("[text.NBTV]", "negativeBatteryVoltage", 300, "Voltage", "", "negativeBatteryVoltage", "[text.NBTV]"));
        items.add(new HistoryMonitorItem("[text.NBTCH]", "negativeBatteryCurrent", 100, "A", "", "negativeBatteryCurrent", "[text.NBTCH]"));
        items.add(new HistoryMonitorItem("[text.upsTemperature]", "temperatureLine", 180, "Degree", "", "temperatureView", "[text.upsTemperature]"));
        return columns;
    }

    public String getProtocolID() {
        return "P33";
    }

    @Override
    public StatusUPSInfo getModulesInfo() {
        return this._modules;
    }

    public StatusPowerFlow getStatusPowerFlow() {
        StatusPowerFlow statusPowerFlow = new StatusPowerFlow();
        List inputlines = statusPowerFlow.getInput();
        inputlines.add(new StatusPowerFlowItem("[text.inputV] L1-N:", "{workInfo.inputVoltage}", "V"));
        if (phaseIndex == 33 || phaseIndex == 31) {
            inputlines.add(new StatusPowerFlowItem("[text.inputV] L2-N:", "{workInfo.inputVoltageS}", "V"));
            inputlines.add(new StatusPowerFlowItem("[text.inputV] L3-N:", "{workInfo.inputVoltageT}", "V"));
        } else if (phaseIndex == 22) {
            inputlines.add(new StatusPowerFlowItem("[text.inputV] L2-N:", "{workInfo.inputVoltageT}", "V"));
        }
        inputlines.add(new StatusPowerFlowItem("[text.inputF]:", "{workInfo.inputFrequency}", "Hz"));
        List upslines = statusPowerFlow.getUpsInfo();
        upslines.add(new StatusPowerFlowItem("[text.workMod]:", "{workInfo.workMode}", ""));
        upslines.add(new StatusPowerFlowItem("[text.internalTp]:", "{workInfo.temperatureView}", MyConstants.getTempUnit()));
        List outputlines = statusPowerFlow.getOutput();
        if (phaseIndex == 33) {
            outputlines.add(new StatusPowerFlowItem("[text.outputV] L1-N:", "{workInfo.outputVoltage}", "V"));
            outputlines.add(new StatusPowerFlowItem("[text.outputV] L2-N:", "{workInfo.outputVoltageS}", "V"));
            outputlines.add(new StatusPowerFlowItem("[text.outputV] L3-N:", "{workInfo.outputVoltageT}", "V"));
        } else if (phaseIndex == 22) {
            outputlines.add(new StatusPowerFlowItem("[text.outputV] L1-N:", "{workInfo.outputVoltage}", "V"));
            outputlines.add(new StatusPowerFlowItem("[text.outputV] L2-N:", "{workInfo.outputVoltageT}", "V"));
        } else {
            outputlines.add(new StatusPowerFlowItem("[text.outputV]:", "{workInfo.outputVoltage}", "V"));
        }
        if (phaseIndex == 33) {
            outputlines.add(new StatusPowerFlowItem("[text.loadEle] L1-N:", "{workInfo.outputCurrent}", "V"));
            outputlines.add(new StatusPowerFlowItem("[text.loadEle] L2-N:", "{workInfo.outputCurrentS}", "V"));
            outputlines.add(new StatusPowerFlowItem("[text.loadEle] L3-N:", "{workInfo.outputCurrentT}", "V"));
        } else if (phaseIndex == 22) {
            outputlines.add(new StatusPowerFlowItem("[text.loadEle] L1-N:", "{workInfo.outputCurrent}", "V"));
            outputlines.add(new StatusPowerFlowItem("[text.loadEle] L2-N:", "{workInfo.outputCurrentT}", "V"));
        } else {
            outputlines.add(new StatusPowerFlowItem("[text.loadEle]:", "{workInfo.outputCurrent}", "V"));
        }
        outputlines.add(new StatusPowerFlowItem("[text.outputF]:", "{workInfo.outputFrequency}", "Hz"));
        if (phaseIndex == 33) {
            outputlines.add(new StatusPowerFlowItem("[label.loadPercents] L1:", "{workInfo.loadLevel}", "%"));
            outputlines.add(new StatusPowerFlowItem("[label.loadPercents] L2:", "{workInfo.loadLevelS}", "%"));
            outputlines.add(new StatusPowerFlowItem("[label.loadPercents] L3:", "{workInfo.loadLevelT}", "%"));
        } else if (phaseIndex == 22) {
            outputlines.add(new StatusPowerFlowItem("[label.loadPercents] L1:", "{workInfo.loadLevel}", "%"));
            outputlines.add(new StatusPowerFlowItem("[label.loadPercents] L2:", "{workInfo.loadLevelT}", "%"));
        }
        outputlines.add(new StatusPowerFlowItem("[label.loadPercents]:", "{workInfo.outputLoadPercent}", "%"));
        List batterylines = statusPowerFlow.getBattery();
        batterylines.add(new StatusPowerFlowItem("[text.PBTV]:", "{workInfo.positiveBatteryVoltage}", "V"));
        batterylines.add(new StatusPowerFlowItem("[text.PBTCH]:", "{workInfo.positiveBatteryCurrent}", "A"));
        batterylines.add(new StatusPowerFlowItem("[text.NBTV]:", "{workInfo.negativeBatteryVoltage}", "V"));
        batterylines.add(new StatusPowerFlowItem("[text.NBTCH]:", "{workInfo.negativeBatteryCurrent}", "A"));
        batterylines.add(new StatusPowerFlowItem("[text.BatteryPercent]:", "{workInfo.batteryCapacity}", "%"));
        batterylines.add(new StatusPowerFlowItem("[text.batteryRemaining]:", "{workInfo.batteryRemainTime}", "Min"));
        List bypasslines = statusPowerFlow.getBypassInfoLines();
        if (phaseIndex == 33) {
            bypasslines.add(new StatusPowerFlowItem("[text.bypassVoltage] L1-N:", "{workInfo.bypassVoltage}", "V"));
            bypasslines.add(new StatusPowerFlowItem("[text.bypassVoltage] L2-N:", "{workInfo.bypassVoltageS}", "V"));
            bypasslines.add(new StatusPowerFlowItem("[text.bypassVoltage] L3-N:", "{workInfo.bypassVoltageT}", "V"));
        } else if (phaseIndex == 22) {
            bypasslines.add(new StatusPowerFlowItem("[text.bypassVoltage] L1-N:", "{workInfo.bypassVoltage}", "V"));
            bypasslines.add(new StatusPowerFlowItem("[text.bypassVoltage] L2-N:", "{workInfo.bypassVoltageT}", "V"));
        } else {
            bypasslines.add(new StatusPowerFlowItem("[text.bypassVoltage]:", "{workInfo.bypassVoltage}", "V"));
        }
        bypasslines.add(new StatusPowerFlowItem("[text.bypassFrequency]:", "{workInfo.bypassFrequency}", "Hz"));
        return statusPowerFlow;
    }

    private StatusUPSInfoList getNewModuleInfo(String sn) {
        StatusUPSInfoList statusUpsInfolist1 = new StatusUPSInfoList();
        statusUpsInfolist1.setLabel(sn);
        ArrayList<StatusUPSInfoItem> item1 = new ArrayList<StatusUPSInfoItem>();
        item1.add(new StatusUPSInfoItem("[text.inputV] L1-N", "{inputVoltage}", "V"));
        if (phaseIndex == 33 || phaseIndex == 31) {
            item1.add(new StatusUPSInfoItem("[text.inputV] L2-N", "{inputVoltageS}", "V"));
            item1.add(new StatusUPSInfoItem("[text.inputV] L3-N", "{inputVoltageT}", "V"));
        } else if (phaseIndex == 22) {
            item1.add(new StatusUPSInfoItem("[text.inputV] L2-N", "{inputVoltageT}", "V"));
        }
        item1.add(new StatusUPSInfoItem("[text.inputF]", "{inputFrequency}", "Hz"));
        if (phaseIndex == 33) {
            item1.add(new StatusUPSInfoItem("[text.bypassVoltage] L1-N", "{bypassVoltage}", "V"));
            item1.add(new StatusUPSInfoItem("[text.bypassVoltage] L2-N", "{bypassVoltageS}", "V"));
            item1.add(new StatusUPSInfoItem("[text.bypassVoltage] L3-N", "{bypassVoltageT}", "V"));
        } else if (phaseIndex == 22) {
            item1.add(new StatusUPSInfoItem("[text.bypassVoltage] L1-N", "{bypassVoltage}", "V"));
            item1.add(new StatusUPSInfoItem("[text.bypassVoltage] L2-N", "{bypassVoltageT}", "V"));
        } else {
            item1.add(new StatusUPSInfoItem("[text.bypassVoltage]", "{bypassVoltage}", "V"));
        }
        item1.add(new StatusUPSInfoItem("[text.bypassFrequency]", "{bypassFrequency}", "Hz"));
        item1.add(new StatusUPSInfoItem("[text.workMod]", "{workMode}", ""));
        item1.add(new StatusUPSInfoItem("[text.upsTemperature]", "{temperatureView}", MyConstants.getTempUnit()));
        if (phaseIndex == 33) {
            item1.add(new StatusUPSInfoItem("[text.outputV] L1-N", "{outputVoltage}", "V"));
            item1.add(new StatusUPSInfoItem("[text.outputV] L2-N", "{outputVoltageS}", "V"));
            item1.add(new StatusUPSInfoItem("[text.outputV] L3-N", "{outputVoltageT}", "V"));
        } else if (phaseIndex == 22) {
            item1.add(new StatusUPSInfoItem("[text.outputV] L1-N", "{outputVoltage}", "V"));
            item1.add(new StatusUPSInfoItem("[text.outputV] L2-N", "{outputVoltageT}", "V"));
        } else {
            item1.add(new StatusUPSInfoItem("[text.outputV]", "{outputVoltage}", "V"));
        }
        if (phaseIndex == 33) {
            item1.add(new StatusUPSInfoItem("[text.loadEle] L1-N", "{outputCurrent}", "A"));
            item1.add(new StatusUPSInfoItem("[text.loadEle] L2-N", "{outputCurrentS}", "A"));
            item1.add(new StatusUPSInfoItem("[text.loadEle] L3-N", "{outputCurrentT}", "A"));
        } else if (phaseIndex == 22) {
            item1.add(new StatusUPSInfoItem("[text.loadEle] L1-N", "{outputCurrent}", "A"));
            item1.add(new StatusUPSInfoItem("[text.loadEle] L2-N", "{outputCurrentT}", "A"));
        } else {
            item1.add(new StatusUPSInfoItem("[text.loadEle]", "{outputCurrent}", "A"));
        }
        item1.add(new StatusUPSInfoItem("[text.outputF]", "{outputFrequency}", "Hz"));
        if (phaseIndex == 33) {
            item1.add(new StatusUPSInfoItem("[label.loadPercents] L1", "{loadLevel}", "%"));
            item1.add(new StatusUPSInfoItem("[label.loadPercents] L2", "{loadLevelS}", "%"));
            item1.add(new StatusUPSInfoItem("[label.loadPercents] L3", "{loadLevelT}", "%"));
        } else if (phaseIndex == 22) {
            item1.add(new StatusUPSInfoItem("[label.loadPercents] L1", "{loadLevel}", "%"));
            item1.add(new StatusUPSInfoItem("[label.loadPercents] L2", "{loadLevelT}", "%"));
        }
        item1.add(new StatusUPSInfoItem("[label.loadLevel]", "{outputLoadPercent}", "%"));
        item1.add(new StatusUPSInfoItem("[text.PBTV]", "{positiveBatteryVoltage}", "V"));
        item1.add(new StatusUPSInfoItem("[text.NBTV]", "{negativeBatteryVoltage}", "V"));
        statusUpsInfolist1.setLines(item1);
        return statusUpsInfolist1;
    }

    public StatusUPSInfo getStatusUPSInfo() {
        StatusUPSInfo statusUpsinfo = new StatusUPSInfo();
        ArrayList<StatusUPSInfoList> info = new ArrayList<StatusUPSInfoList>();
        StatusUPSInfoList statusUpsInfolist1 = new StatusUPSInfoList();
        statusUpsInfolist1.setLabel("[label.inputInfo]");
        ArrayList<StatusUPSInfoItem> item1 = new ArrayList<StatusUPSInfoItem>();
        item1.add(new StatusUPSInfoItem("[text.inputV] L1-N", "{workInfo.inputVoltage}", "V"));
        if (phaseIndex == 33 || phaseIndex == 31) {
            item1.add(new StatusUPSInfoItem("[text.inputV] L2-N", "{workInfo.inputVoltageS}", "V"));
            item1.add(new StatusUPSInfoItem("[text.inputV] L3-N", "{workInfo.inputVoltageT}", "V"));
        } else if (phaseIndex == 22) {
            item1.add(new StatusUPSInfoItem("[text.inputV] L2-N", "{workInfo.inputVoltageT}", "V"));
        }
        item1.add(new StatusUPSInfoItem("[text.inputF]", "{workInfo.inputFrequency}", "Hz"));
        statusUpsInfolist1.setLines(item1);
        info.add(statusUpsInfolist1);
        StatusUPSInfoList statusUpsInfolist5 = new StatusUPSInfoList();
        statusUpsInfolist5.setLabel("[text.bypassInfo]");
        ArrayList<StatusUPSInfoItem> item5 = new ArrayList<StatusUPSInfoItem>();
        if (phaseIndex == 33) {
            item5.add(new StatusUPSInfoItem("[text.bypassVoltage] L1-N", "{workInfo.bypassVoltage}", "V"));
            item5.add(new StatusUPSInfoItem("[text.bypassVoltage] L2-N", "{workInfo.bypassVoltageS}", "V"));
            item5.add(new StatusUPSInfoItem("[text.bypassVoltage] L3-N", "{workInfo.bypassVoltageT}", "V"));
        } else if (phaseIndex == 22) {
            item5.add(new StatusUPSInfoItem("[text.bypassVoltage] L1-N", "{workInfo.bypassVoltage}", "V"));
            item5.add(new StatusUPSInfoItem("[text.bypassVoltage] L2-N", "{workInfo.bypassVoltageT}", "V"));
        } else {
            item5.add(new StatusUPSInfoItem("[text.bypassVoltage]", "{workInfo.bypassVoltage}", "V"));
        }
        item5.add(new StatusUPSInfoItem("[text.bypassFrequency]", "{workInfo.bypassFrequency}", "Hz"));
        statusUpsInfolist5.setLines(item5);
        info.add(statusUpsInfolist5);
        StatusUPSInfoList statusUpsInfolist2 = new StatusUPSInfoList();
        statusUpsInfolist2.setLabel("[label.upsInfo]");
        ArrayList<StatusUPSInfoItem> item2 = new ArrayList<StatusUPSInfoItem>();
        item2.add(new StatusUPSInfoItem("[text.workMod]", "{workInfo.workMode}", ""));
        item2.add(new StatusUPSInfoItem("[text.upsTemperature]", "{workInfo.temperatureView}", MyConstants.getTempUnit()));
        item2.add(new StatusUPSInfoItem("[label.autoReboot]", "{workInfo.autoReboot}", ""));
        item2.add(new StatusUPSInfoItem("[label.converterMode]", "{workInfo.converterMode}", ""));
        item2.add(new StatusUPSInfoItem("[label.eCOMode]", "{workInfo.ecomode}", ""));
        item2.add(new StatusUPSInfoItem("[label.bypassOff]", "{workInfo.bypassOff}", ""));
        item2.add(new StatusUPSInfoItem("[label.bypassNotAllowed]", "{workInfo.bypassNotAllowed}", ""));
        statusUpsInfolist2.setLines(item2);
        info.add(statusUpsInfolist2);
        StatusUPSInfoList statusUpsInfolist3 = new StatusUPSInfoList();
        statusUpsInfolist3.setLabel("[label.batteryInfo]");
        ArrayList<StatusUPSInfoItem> item3 = new ArrayList<StatusUPSInfoItem>();
        item3.add(new StatusUPSInfoItem("[text.PBTV]", "{workInfo.positiveBatteryVoltage}", "V"));
        item3.add(new StatusUPSInfoItem("[text.PBTCH]:", "{workInfo.positiveBatteryCurrent}", "A"));
        item3.add(new StatusUPSInfoItem("[text.NBTV]:", "{workInfo.negativeBatteryVoltage}", "V"));
        item3.add(new StatusUPSInfoItem("[text.NBTCH]:", "{workInfo.negativeBatteryCurrent}", "A"));
        item3.add(new StatusUPSInfoItem("[text.BatteryPercent]:", "{workInfo.batteryCapacity}", "%"));
        item3.add(new StatusUPSInfoItem("[text.batteryRemaining]:", "{workInfo.batteryRemainTime}", "Min"));
        statusUpsInfolist3.setLines(item3);
        info.add(statusUpsInfolist3);
        StatusUPSInfoList statusUpsInfolist4 = new StatusUPSInfoList();
        statusUpsInfolist4.setLabel("[label.outputInfo]");
        ArrayList<StatusUPSInfoItem> item4 = new ArrayList<StatusUPSInfoItem>();
        if (phaseIndex == 33) {
            item4.add(new StatusUPSInfoItem("[text.outputV] L1-N", "{workInfo.outputVoltage}", "V"));
            item4.add(new StatusUPSInfoItem("[text.outputV] L2-N", "{workInfo.outputVoltageS}", "V"));
            item4.add(new StatusUPSInfoItem("[text.outputV] L3-N", "{workInfo.outputVoltageT}", "V"));
        } else if (phaseIndex == 22) {
            item4.add(new StatusUPSInfoItem("[text.outputV] L1-N", "{workInfo.outputVoltage}", "V"));
            item4.add(new StatusUPSInfoItem("[text.outputV] L2-N", "{workInfo.outputVoltageT}", "V"));
        } else {
            item4.add(new StatusUPSInfoItem("[text.outputV]", "{workInfo.outputVoltage}", "V"));
        }
        if (phaseIndex == 33) {
            item4.add(new StatusUPSInfoItem("[text.loadEle] L1-N", "{workInfo.outputCurrent}", "A"));
            item4.add(new StatusUPSInfoItem("[text.loadEle] L2-N", "{workInfo.outputCurrentS}", "A"));
            item4.add(new StatusUPSInfoItem("[text.loadEle] L3-N", "{workInfo.outputCurrentT}", "A"));
        } else if (phaseIndex == 22) {
            item4.add(new StatusUPSInfoItem("[text.loadEle] L1-N", "{workInfo.outputCurrent}", "A"));
            item4.add(new StatusUPSInfoItem("[text.loadEle] L2-N", "{workInfo.outputCurrentT}", "A"));
        } else {
            item4.add(new StatusUPSInfoItem("[text.loadEle]", "{workInfo.outputCurrent}", "A"));
        }
        item4.add(new StatusUPSInfoItem("[text.outputF]", "{workInfo.outputFrequency}", "Hz"));
        if (phaseIndex == 33) {
            item4.add(new StatusUPSInfoItem("[label.loadPercents] L1", "{workInfo.loadLevel}", "%"));
            item4.add(new StatusUPSInfoItem("[label.loadPercents] L2", "{workInfo.loadLevelS}", "%"));
            item4.add(new StatusUPSInfoItem("[label.loadPercents] L3", "{workInfo.loadLevelT}", "%"));
        } else if (phaseIndex == 22) {
            item4.add(new StatusUPSInfoItem("[label.loadPercents] L1", "{workInfo.loadLevel}", "%"));
            item4.add(new StatusUPSInfoItem("[label.loadPercents] L2", "{workInfo.loadLevelT}", "%"));
        }
        item4.add(new StatusUPSInfoItem("[label.loadLevel]", "{workInfo.outputLoadPercent}", "%"));
        statusUpsInfolist4.setLines(item4);
        info.add(statusUpsInfolist4);
        statusUpsinfo.setInfo(info);
        return statusUpsinfo;
    }

    public WebMapping getWebMapping() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshData(CommunicateHandlerInterface handler) {
        String dataStr = "(NAK";
        boolean found = false;
        HashMap<String, String> currentModules = new HashMap<String, String>();
        try {
            int i = 0;
            while (i < 5) {
                if (StringUtils.isEmpty((String)dataStr) || dataStr.equals("(NAK") || !dataStr.startsWith("(")) {
                    dataStr = handler.excuteSimpleCommand(QPAR);
                } else if (dataStr.length() >= 4) {
                    found = true;
                    break;
                }
                ++i;
            }
        }
        catch (IOException i) {
            // empty catch block
        }
        if (found) {
            try {
                String[] ids = null;
                dataStr = "(NAK";
                try {
                    this.delay();
                    dataStr = handler.excuteCommand(QMID, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int i = 1;
                while (StringUtils.isEmpty((String)dataStr) || dataStr.equals("(NAK") || !dataStr.startsWith("(")) {
                    this.delay();
                    dataStr = handler.excuteCommand(QMID, true);
                    System.out.println("\u7b2c" + i + "\u6b21:" + dataStr);
                }
                dataStr = dataStr.substring(1);
                String[] stringArray = ids = dataStr.split(" ");
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    dataStr = "(NAK";
                    int try_i = 0;
                    while (try_i < 3) {
                        this.delay();
                        if (!StringUtils.isEmpty((String)dataStr) && !dataStr.equals("(NAK") && dataStr.startsWith("(")) {
                            currentModules.put(dataStr.substring(1), id);
                            break;
                        }
                        dataStr = handler.excuteSimpleCommand("QIDN," + id);
                        ++try_i;
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            P33 e = this;
            synchronized (e) {
                this.snidmap.clear();
                for (Map.Entry entry : currentModules.entrySet()) {
                    this.snidmap.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            ArrayList<StatusUPSInfoList> remove = new ArrayList<StatusUPSInfoList>();
            for (StatusUPSInfoList upsinfo : this._modules.getInfo()) {
                if (currentModules.containsKey(upsinfo.getLabel())) {
                    currentModules.remove(upsinfo.getLabel());
                    continue;
                }
                remove.add(upsinfo);
            }
            for (StatusUPSInfoList upsinfo : remove) {
                this._modules.getInfo().remove(upsinfo);
            }
            remove.clear();
            for (String sn : currentModules.keySet()) {
                this._modules.getInfo().add(this.getNewModuleInfo(sn));
            }
        }
    }

    private void delay() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

