/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.protocol;

import cn.com.voltronicpower.data.bean.AutoMenuList;
import cn.com.voltronicpower.data.bean.HistoryDataColumns;
import cn.com.voltronicpower.data.bean.HistoryDataItem;
import cn.com.voltronicpower.data.bean.HistoryMonitorColumns;
import cn.com.voltronicpower.data.bean.HistoryMonitorItem;
import cn.com.voltronicpower.data.bean.StatusPowerFlow;
import cn.com.voltronicpower.data.bean.StatusPowerFlowItem;
import cn.com.voltronicpower.data.bean.StatusUPSInfo;
import cn.com.voltronicpower.data.bean.StatusUPSInfoItem;
import cn.com.voltronicpower.data.bean.StatusUPSInfoList;
import cn.com.voltronicpower.data.bean.WebMapping;
import cn.com.voltronicpower.monitor.protocol.P010203;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import java.util.ArrayList;
import java.util.List;

public class P13
extends P010203 {
    public static final String QBYV = "QBYV";
    public static final String QBYF = "QBYF";
    public static final String QHE = "QHE";
    public static final String QFRE = "QFRE";
    public static final String QBDR = "QBDR";
    public static final String FLAG = "FLAG";
    public static final String PSF = "PSF";
    public static final String PGF = "PGF";
    public static final String PLV = "PLV";
    public static final String PHV = "PHV";
    public static final String HEH = "HEH";
    public static final String HEL = "HEL";
    public static final String FREH = "FREH";
    public static final String FREL = "FREL";

    public String getProtocolID() {
        return "P13";
    }

    public String getEventFileName() {
        return null;
    }

    public StatusPowerFlow getStatusPowerFlow() {
        StatusPowerFlow statusPowerFlow = new StatusPowerFlow();
        List inputlines = statusPowerFlow.getInput();
        inputlines.add(new StatusPowerFlowItem("[text.inputV]:", "{workInfo.inputVoltage}", "V"));
        inputlines.add(new StatusPowerFlowItem("[text.inputF]:", "{workInfo.inputFrequency}", "Hz"));
        List upslines = statusPowerFlow.getUpsInfo();
        upslines.add(new StatusPowerFlowItem("[text.workMod]:", "{workInfo.workMode}", ""));
        upslines.add(new StatusPowerFlowItem("[text.internalTp]:", "{workInfo.temperatureView}", MyConstants.getTempUnit()));
        List outputlines = statusPowerFlow.getOutput();
        outputlines.add(new StatusPowerFlowItem("[text.outputV]:", "{workInfo.outputVoltage}", "V"));
        outputlines.add(new StatusPowerFlowItem("[text.outputF]:", "{workInfo.outputFrequency}", "Hz"));
        outputlines.add(new StatusPowerFlowItem("[label.loadPercents]:", "{workInfo.outputLoadPercent}", "%"));
        outputlines.add(new StatusPowerFlowItem("[text.loadEle]:", "{workInfo.outputCurrent}", "A"));
        List batterylines = statusPowerFlow.getBattery();
        batterylines.add(new StatusPowerFlowItem("[text.BTV]:", "{workInfo.batteryVoltage}", "V"));
        batterylines.add(new StatusPowerFlowItem("[text.BatteryPercent]:", "{workInfo.batteryCapacity}", "%"));
        if (this.supportRemainTime) {
            batterylines.add(new StatusPowerFlowItem("[text.batteryRemaining]:", "{workInfo.batteryRemainTime}", "Min"));
        }
        return statusPowerFlow;
    }

    public StatusUPSInfo getStatusUPSInfo() {
        StatusUPSInfo statusUpsinfo = new StatusUPSInfo();
        ArrayList<StatusUPSInfoList> info = new ArrayList<StatusUPSInfoList>();
        StatusUPSInfoList statusUpsInfolist1 = new StatusUPSInfoList();
        statusUpsInfolist1.setLabel("[label.inputInfo]");
        ArrayList<StatusUPSInfoItem> item1 = new ArrayList<StatusUPSInfoItem>();
        item1.add(new StatusUPSInfoItem("[text.inputV]", "{workInfo.inputVoltage}", "V"));
        item1.add(new StatusUPSInfoItem("[text.inputF]", "{workInfo.inputFrequency}", "Hz"));
        statusUpsInfolist1.setLines(item1);
        info.add(statusUpsInfolist1);
        StatusUPSInfoList statusUpsInfolist2 = new StatusUPSInfoList();
        statusUpsInfolist2.setLabel("[label.upsInfo]");
        ArrayList<StatusUPSInfoItem> item2 = new ArrayList<StatusUPSInfoItem>();
        item2.add(new StatusUPSInfoItem("[text.workMod]", "{workInfo.workMode}", ""));
        item2.add(new StatusUPSInfoItem("[text.upsTemperature]", "{workInfo.temperatureView}", MyConstants.getTempUnit()));
        item2.add(new StatusUPSInfoItem("[label.autoReboot]", "{workInfo.autoReboot}", ""));
        item2.add(new StatusUPSInfoItem("[label.converterMode]", "{workInfo.converterMode}", ""));
        item2.add(new StatusUPSInfoItem("[label.eCOMode]", "{workInfo.ecomode}", ""));
        item2.add(new StatusUPSInfoItem("[label.bypassOff]", "{workInfo.bypassOff}", ""));
        item2.add(new StatusUPSInfoItem("[label.bypassNotAllowed]", "{workInfo.bypassNotAllowed}", ""));
        item2.add(new StatusUPSInfoItem("[label.faultType]", "{workInfo.faultType}", ""));
        item2.add(new StatusUPSInfoItem("[label.warn]", "{workInfo.warnings}", ""));
        statusUpsInfolist2.setLines(item2);
        info.add(statusUpsInfolist2);
        StatusUPSInfoList statusUpsInfolist3 = new StatusUPSInfoList();
        statusUpsInfolist3.setLabel("[label.batteryInfo]");
        ArrayList<StatusUPSInfoItem> item3 = new ArrayList<StatusUPSInfoItem>();
        item3.add(new StatusUPSInfoItem("[text.BTV]", "{workInfo.batteryVoltage}", "V"));
        statusUpsInfolist3.setLines(item3);
        info.add(statusUpsInfolist3);
        StatusUPSInfoList statusUpsInfolist4 = new StatusUPSInfoList();
        statusUpsInfolist4.setLabel("[label.outputInfo]");
        ArrayList<StatusUPSInfoItem> item4 = new ArrayList<StatusUPSInfoItem>();
        item4.add(new StatusUPSInfoItem("[text.outputV]", "{workInfo.outputVoltage}", "V"));
        item4.add(new StatusUPSInfoItem("[text.outputF]", "{workInfo.outputFrequency}", "Hz"));
        item4.add(new StatusUPSInfoItem("[label.loadLevel]", "{workInfo.outputLoadPercent}", "%"));
        item4.add(new StatusUPSInfoItem("[text.loadEle]", "{workInfo.outputCurrent}", "A"));
        statusUpsInfolist4.setLines(item4);
        info.add(statusUpsInfolist4);
        statusUpsinfo.setInfo(info);
        return statusUpsinfo;
    }

    public HistoryMonitorColumns getHistoryMonitorColumns() {
        HistoryMonitorColumns columns = new HistoryMonitorColumns();
        List items = columns.getColumns();
        items.add(new HistoryMonitorItem("[text.inputV]", "voltageLine", 300, "Voltage", "", "inputVoltage", "[text.inputV]"));
        items.add(new HistoryMonitorItem("[text.inputF]", "frequencyLine", 70, "Hz", "inputFLine", "inputFrequency", "[text.inputF]"));
        items.add(new HistoryMonitorItem("[text.outputV]", "outputVoltageLine", 300, "Voltage", "", "outputVoltage", "[text.outputV]"));
        items.add(new HistoryMonitorItem("[text.outputF]", "outputFrequencyLine", 70, "Hz", "", "outputFrequency", "[text.outputF]"));
        items.add(new HistoryMonitorItem("[text.loadEle]", "currentLine", 80, "A", "", "outputCurrent", "[text.loadEle]"));
        items.add(new HistoryMonitorItem("[label.loadPercents]", "loadArea", 100, "%", "", "outputLoadPercent", "[label.loadPercents]"));
        items.add(new HistoryMonitorItem("[text.BTV]", "temperatureLine", 300, "Voltage", "", "batteryVoltage", "[text.BTV]"));
        items.add(new HistoryMonitorItem("[text.upsTemperature]", "temperatureLine", 180, "Degree", "", "temperatureView", "[text.upsTemperature]"));
        return columns;
    }

    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        List item = columns.getColumns();
        item.add(new HistoryDataItem("[text.mv.col1]", "currentTime", "", "displayDate"));
        item.add(new HistoryDataItem("[text.inputV]", "inputVoltage", "inputV1", ""));
        item.add(new HistoryDataItem("[text.inputF]", "inputFrequency", "", "displayInputFrequency"));
        item.add(new HistoryDataItem("[text.outputV]", "outputVoltage", "outputVR", ""));
        item.add(new HistoryDataItem("[text.outputF]", "outputFrequency", "", ""));
        item.add(new HistoryDataItem("[text.loadEle]", "outputCurrent", "", "displayOutputCurrent"));
        item.add(new HistoryDataItem("[label.loadPercents]", "outputLoadPercent", "", "displayOutpuLoadPercents"));
        item.add(new HistoryDataItem("[text.BTV]", "batteryVoltage", "", ""));
        item.add(new HistoryDataItem("[text.upsTemperature]", "temperatureView", "", "calTemp"));
        return columns;
    }

    public WebMapping getWebMapping() {
        return null;
    }

    @Override
    public AutoMenuList getMenuList() {
        return super.getMenuList();
    }
}

