/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.protocol;

import cn.com.voltronicpower.data.bean.AutoMenuList;
import cn.com.voltronicpower.data.bean.HistoryDataColumns;
import cn.com.voltronicpower.data.bean.HistoryDataItem;
import cn.com.voltronicpower.data.bean.HistoryMonitorColumns;
import cn.com.voltronicpower.data.bean.HistoryMonitorItem;
import cn.com.voltronicpower.data.bean.StatusPowerFlow;
import cn.com.voltronicpower.data.bean.StatusPowerFlowItem;
import cn.com.voltronicpower.data.bean.StatusUPSInfo;
import cn.com.voltronicpower.data.bean.StatusUPSInfoItem;
import cn.com.voltronicpower.data.bean.StatusUPSInfoList;
import cn.com.voltronicpower.data.bean.WebMapping;
import cn.com.voltronicpower.monitor.protocol.P010203;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import java.util.ArrayList;
import java.util.List;

public class P10
extends P010203 {
    public static final String QPAR = "QPAR";
    public static final String QBYV = "QBYV";
    public static final String QBYF = "QBYF";
    public static final String QLDL = "QLDL";
    public static final String QBDR = "QBDR";
    public static final String QFLAG = "QFLAG";
    public static final String QHE = "QHE";
    public static final String Q3PV = "Q3PV";
    public static final String Q3PC = "Q3PC";
    public static final String Q3OV = "Q3OV";
    public static final String Q3OC = "Q3OC";
    public static final String Q3YV = "Q3YV";
    public static final String Q3LD = "Q3LD";
    public static final String QYF = "QYF";
    public static final String PSF = "PSF";
    public static final String PGF = "PGF";
    public static final String PLV = "PLV";
    public static final String PHV = "PHV";

    public String getProtocolID() {
        return "P10";
    }

    public String getEventFileName() {
        return null;
    }

    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        List item = columns.getColumns();
        item.add(new HistoryDataItem("[text.mv.col1]", "currentTime", "", "displayDate"));
        item.add(new HistoryDataItem("[text.inputV] L1-N", "inputVoltage", "inputVL1", ""));
        item.add(new HistoryDataItem("[text.inputV] L2-N", "inputVoltageS", "inputVL2", ""));
        item.add(new HistoryDataItem("[text.inputV] L3-N", "inputVoltageT", "inputVL3", ""));
        item.add(new HistoryDataItem("[text.inputV] L1-L2", "inputVoltageL1L2", "inputVL1L2", ""));
        item.add(new HistoryDataItem("[text.inputV] L2-L3", "inputVoltageL2L3", "inputVL2L3", ""));
        item.add(new HistoryDataItem("[text.inputV] L1-L3", "inputVoltageL1L3", "inputVL1L3", ""));
        item.add(new HistoryDataItem("[text.inputF]", "inputFrequency", "", "displayInputFrequency"));
        if (this.ioPhase31.equals("3/1")) {
            item.add(new HistoryDataItem("[text.outputV] L1-N", "outputVoltage", "outputVR", ""));
            item.add(new HistoryDataItem("[text.loadEle] L1-N", "outputCurrent", "outputCR", ""));
        } else {
            item.add(new HistoryDataItem("[text.outputV] L1-N", "outputVoltage", "outputVR", ""));
            item.add(new HistoryDataItem("[text.outputV] L2-N", "outputVoltageS", "outputVS", ""));
            item.add(new HistoryDataItem("[text.outputV] L3-N", "outputVoltageT", "outputVT", ""));
            item.add(new HistoryDataItem("[text.outputV] L1-L2", "outputVoltageL1L2", "outputVL1L2", ""));
            item.add(new HistoryDataItem("[text.outputV] L2-L3", "outputVoltageL2L3", "outputVL2L3", ""));
            item.add(new HistoryDataItem("[text.outputV] L1-L3", "outputVoltageL1L3", "outputVL1L3", ""));
            item.add(new HistoryDataItem("[text.loadEle] L1-N", "outputCurrent", "outputCR", ""));
            item.add(new HistoryDataItem("[text.loadEle] L2-N", "outputCurrentS", "outputCS", ""));
            item.add(new HistoryDataItem("[text.loadEle] L3-N", "outputCurrentT", "outputCT", ""));
        }
        item.add(new HistoryDataItem("[text.bypassVoltage] L1-N", "bypassVoltage", "bypassVR", ""));
        item.add(new HistoryDataItem("[text.bypassVoltage] L2-N", "bypassVoltageS", "bypassVS", ""));
        item.add(new HistoryDataItem("[text.bypassVoltage] L3-N", "bypassVoltageT", "bypassVT", ""));
        item.add(new HistoryDataItem("[text.bypassVoltage] L1-L2", "bypassVoltageL1L2", "bypassVL1L2", ""));
        item.add(new HistoryDataItem("[text.bypassVoltage] L2-L3", "bypassVoltageL2L3", "bypassVL2L3", ""));
        item.add(new HistoryDataItem("[text.bypassVoltage] L1-L3", "bypassVoltageL1L3", "bypassVL1L3", ""));
        item.add(new HistoryDataItem("[text.bypassFrequency]", "bypassFrequency", "bypassF", ""));
        item.add(new HistoryDataItem("[text.outputF]", "outputFrequency", "", ""));
        item.add(new HistoryDataItem("[label.loadPercents] L1", "loadLevel", "loadR", ""));
        item.add(new HistoryDataItem("[label.loadPercents] L2", "loadLevelS", "loadS", ""));
        item.add(new HistoryDataItem("[label.loadPercents] L3", "loadLevelT", "loadT", ""));
        item.add(new HistoryDataItem("[label.loadPercents]", "outputLoadPercent", "", "displayOutpuLoadPercents"));
        item.add(new HistoryDataItem("[text.BTV]", "batteryVoltage", "", ""));
        item.add(new HistoryDataItem("[text.upsTemperature]", "temperatureView", "", "calTemp"));
        return columns;
    }

    public HistoryMonitorColumns getHistoryMonitorColumns() {
        HistoryMonitorColumns columns = new HistoryMonitorColumns();
        List items = columns.getColumns();
        items.add(new HistoryMonitorItem("[text.inputV] L1-N", "voltageLine", 300, "Voltage", "", "inputVoltage", "[text.inputV] L1-N"));
        items.add(new HistoryMonitorItem("[text.inputV] L2-N", "voltageLineS", 300, "Voltage", "", "inputVoltageS", "[text.inputV] L2-N"));
        items.add(new HistoryMonitorItem("[text.inputV] L3-N", "voltageLineT", 300, "Voltage", "", "inputVoltageT", "[text.inputV] L3-N"));
        items.add(new HistoryMonitorItem("[text.inputV] L1-L2", "voltageLineL1-L2", 600, "Voltage", "", "inputVoltageL1L2", "[text.inputV] L1-L2"));
        items.add(new HistoryMonitorItem("[text.inputV] L2-L3", "voltageLineL2-L3", 600, "Voltage", "", "inputVoltageL2L3", "[text.inputV] L2-L3"));
        items.add(new HistoryMonitorItem("[text.inputV] L1-L3", "voltageLineL1-L3", 600, "Voltage", "", "inputVoltageL1L3", "[text.inputV] L1-L3"));
        items.add(new HistoryMonitorItem("[text.inputF]", "frequencyLine", 70, "Hz", "inputFLine", "inputFrequency", "[text.inputF]"));
        if (this.ioPhase31.equals("3/1")) {
            items.add(new HistoryMonitorItem("[text.outputV] L1-N", "outputVoltageLine", 300, "Voltage", "", "outputVoltage", "[text.outputV] L1-N"));
            items.add(new HistoryMonitorItem("[text.loadEle] L1-N", "outputCurrent", 80, "A", "", "outputCurrent", "[text.loadEle] L1-N"));
        } else {
            items.add(new HistoryMonitorItem("[text.outputV] L1-N", "outputVoltageLine", 300, "Voltage", "", "outputVoltage", "[text.outputV] L1-N"));
            items.add(new HistoryMonitorItem("[text.outputV] L2-N", "outputVoltageS", 300, "Voltage", "", "outputVoltageS", "[text.outputV] L2-N"));
            items.add(new HistoryMonitorItem("[text.outputV] L3-N", "outputVoltageT", 300, "Voltage", "", "outputVoltageT", "[text.outputV] L3-N"));
            items.add(new HistoryMonitorItem("[text.outputV] L1-L2", "outputVoltageL1L2", 300, "Voltage", "", "outputVoltageL1L2", "[text.outputV] L1-L2"));
            items.add(new HistoryMonitorItem("[text.outputV] L2-L3", "outputVoltageL2L3", 300, "Voltage", "", "outputVoltageL2L3", "[text.outputV] L2-L3"));
            items.add(new HistoryMonitorItem("[text.outputV] L1-L3", "outputVoltageL1L3", 300, "Voltage", "", "outputVoltageL1L3", "[text.outputV] L1-L3"));
            items.add(new HistoryMonitorItem("[text.loadEle] L1-N", "outputCurrent", 80, "A", "", "outputCurrent", "[text.loadEle] L1-N"));
            items.add(new HistoryMonitorItem("[text.loadEle] L2-N", "outputCurrentS", 80, "A", "", "outputCurrentS", "[text.loadEle] L2-N"));
            items.add(new HistoryMonitorItem("[text.loadEle] L3-N", "outputCurrentT", 80, "A", "", "outputCurrentT", "[text.loadEle] L3-N"));
        }
        items.add(new HistoryMonitorItem("[text.bypassVoltage] L1-N", "bypassVoltage", 300, "Voltage", "", "bypassVoltage", "[text.bypassVoltage] L1-N"));
        items.add(new HistoryMonitorItem("[text.bypassVoltage] L2-N", "bypassVoltageS", 300, "Voltage", "", "bypassVoltageS", "[text.bypassVoltage] L2-N"));
        items.add(new HistoryMonitorItem("[text.bypassVoltage] L3-N", "bypassVoltageT", 300, "Voltage", "", "bypassVoltageT", "[text.bypassVoltage] L3-N"));
        items.add(new HistoryMonitorItem("[text.bypassVoltage] L1-L2", "bypassVoltageL1L2", 300, "Voltage", "", "bypassVoltageL1L2", "[text.bypassVoltage] L1-L2"));
        items.add(new HistoryMonitorItem("[text.bypassVoltage] L2-L3", "bypassVoltageL2L3", 300, "Voltage", "", "bypassVoltageL2L3", "[text.bypassVoltage] L2-L3"));
        items.add(new HistoryMonitorItem("[text.bypassVoltage] L1-L3", "bypassVoltageL1L3", 300, "Voltage", "", "bypassVoltageL1L3", "[text.bypassVoltage] L1-L3"));
        items.add(new HistoryMonitorItem("[text.bypassFrequency]", "bypassFrequency", 70, "Hz", "", "bypassFrequency", "[text.bypassFrequency]"));
        items.add(new HistoryMonitorItem("[text.outputF]", "outputFrequencyLine", 70, "Hz", "", "outputFrequency", "[text.outputF]"));
        items.add(new HistoryMonitorItem("[label.loadPercents] L1", "loadLevel", 100, "%", "", "loadLevel", "[label.loadPercents] L1"));
        items.add(new HistoryMonitorItem("[label.loadPercents] L2", "loadLevelS", 100, "%", "", "loadLevelS", "[label.loadPercents] L2"));
        items.add(new HistoryMonitorItem("[label.loadPercents] L3", "loadLevelT", 100, "%", "", "loadLevelT", "[label.loadPercents] L3"));
        items.add(new HistoryMonitorItem("[label.loadPercents]", "loadArea", 100, "%", "", "outputLoadPercent", "[label.loadPercents]"));
        items.add(new HistoryMonitorItem("[text.BTV]", "batteryVoltage", 300, "Voltage", "", "batteryVoltage", "[text.BTV]"));
        items.add(new HistoryMonitorItem("[text.upsTemperature]", "temperatureLine", 180, "Degree", "", "temperatureView", "[text.upsTemperature]"));
        return columns;
    }

    public StatusPowerFlow getStatusPowerFlow() {
        StatusPowerFlow statusPowerFlow = new StatusPowerFlow();
        List inputlines = statusPowerFlow.getInput();
        inputlines.add(new StatusPowerFlowItem("[text.inputV] L1-N:", "{workInfo.inputVoltage}", "V"));
        inputlines.add(new StatusPowerFlowItem("[text.inputV] L2-N:", "{workInfo.inputVoltageS}", "V"));
        inputlines.add(new StatusPowerFlowItem("[text.inputV] L3-N:", "{workInfo.inputVoltageT}", "V"));
        inputlines.add(new StatusPowerFlowItem("[text.inputF]:", "{workInfo.inputFrequency}", "Hz"));
        List upslines = statusPowerFlow.getUpsInfo();
        upslines.add(new StatusPowerFlowItem("[text.workMod]:", "{workInfo.workMode}", ""));
        upslines.add(new StatusPowerFlowItem("[text.internalTp]:", "{workInfo.temperatureView}", MyConstants.getTempUnit()));
        List outputlines = statusPowerFlow.getOutput();
        if (this.ioPhase31.equals("3/1")) {
            outputlines.add(new StatusPowerFlowItem("[text.outputV] L1-N:", "{workInfo.outputVoltage}", "V"));
            outputlines.add(new StatusPowerFlowItem("[text.outputF]:", "{workInfo.outputFrequency}", "Hz"));
            outputlines.add(new StatusPowerFlowItem("[label.loadPercents] L1:", "{workInfo.loadLevel}", "%"));
        } else {
            outputlines.add(new StatusPowerFlowItem("[text.outputV] L1-N:", "{workInfo.outputVoltage}", "V"));
            outputlines.add(new StatusPowerFlowItem("[text.outputV] L2-N:", "{workInfo.outputVoltageS}", "V"));
            outputlines.add(new StatusPowerFlowItem("[text.outputV] L3-N:", "{workInfo.outputVoltageT}", "V"));
            outputlines.add(new StatusPowerFlowItem("[text.outputF]:", "{workInfo.outputFrequency}", "Hz"));
            outputlines.add(new StatusPowerFlowItem("[label.loadPercents] L1:", "{workInfo.loadLevel}", "%"));
            outputlines.add(new StatusPowerFlowItem("[label.loadPercents] L2:", "{workInfo.loadLevelS}", "%"));
            outputlines.add(new StatusPowerFlowItem("[label.loadPercents] L3:", "{workInfo.loadLevelT}", "%"));
        }
        outputlines.add(new StatusPowerFlowItem("[label.loadPercents]:", "{workInfo.outputLoadPercent}", "%"));
        List batterylines = statusPowerFlow.getBattery();
        batterylines.add(new StatusPowerFlowItem("[text.BTV]:", "{workInfo.batteryVoltage}", "V"));
        batterylines.add(new StatusPowerFlowItem("[text.BatteryPercent]:", "{workInfo.batteryCapacity}", "%"));
        if (this.supportRemainTime) {
            batterylines.add(new StatusPowerFlowItem("[text.batteryRemaining]:", "{workInfo.batteryRemainTime}", "Min"));
        }
        List bypasslines = statusPowerFlow.getBypassInfoLines();
        bypasslines.add(new StatusPowerFlowItem("[text.bypassVoltage] L1-N:", "{workInfo.bypassVoltage}", "V"));
        bypasslines.add(new StatusPowerFlowItem("[text.bypassVoltage] L2-N:", "{workInfo.bypassVoltageS}", "V"));
        bypasslines.add(new StatusPowerFlowItem("[text.bypassVoltage] L3-N:", "{workInfo.bypassVoltageT}", "V"));
        bypasslines.add(new StatusPowerFlowItem("[text.bypassFrequency]:", "{workInfo.bypassFrequency}", "Hz"));
        return statusPowerFlow;
    }

    public StatusUPSInfo getStatusUPSInfo() {
        StatusUPSInfo statusUpsinfo = new StatusUPSInfo();
        ArrayList<StatusUPSInfoList> info = new ArrayList<StatusUPSInfoList>();
        StatusUPSInfoList statusUpsInfolist1 = new StatusUPSInfoList();
        statusUpsInfolist1.setLabel("[label.inputInfo]");
        ArrayList<StatusUPSInfoItem> item1 = new ArrayList<StatusUPSInfoItem>();
        item1.add(new StatusUPSInfoItem("[text.inputV] L1-N", "{workInfo.inputVoltage}", "V"));
        item1.add(new StatusUPSInfoItem("[text.inputV] L2-N", "{workInfo.inputVoltageS}", "V"));
        item1.add(new StatusUPSInfoItem("[text.inputV] L3-N", "{workInfo.inputVoltageT}", "V"));
        item1.add(new StatusUPSInfoItem("[text.inputV] L1-L2", "{workInfo.inputVoltageL1L2}", "V"));
        item1.add(new StatusUPSInfoItem("[text.inputV] L2-L3", "{workInfo.inputVoltageL2L3}", "V"));
        item1.add(new StatusUPSInfoItem("[text.inputV] L1-L3", "{workInfo.inputVoltageL1L3}", "V"));
        item1.add(new StatusUPSInfoItem("[text.inputF]", "{workInfo.inputFrequency}", "Hz"));
        statusUpsInfolist1.setLines(item1);
        info.add(statusUpsInfolist1);
        StatusUPSInfoList statusUpsInfolist5 = new StatusUPSInfoList();
        statusUpsInfolist5.setLabel("[text.bypassInfo]");
        ArrayList<StatusUPSInfoItem> item5 = new ArrayList<StatusUPSInfoItem>();
        item5.add(new StatusUPSInfoItem("[text.bypassVoltage] L1-N", "{workInfo.bypassVoltage}", "V"));
        item5.add(new StatusUPSInfoItem("[text.bypassVoltage] L2-N", "{workInfo.bypassVoltageS}", "V"));
        item5.add(new StatusUPSInfoItem("[text.bypassVoltage] L3-N", "{workInfo.bypassVoltageT}", "V"));
        item5.add(new StatusUPSInfoItem("[text.bypassVoltage] L1-L2", "{workInfo.bypassVoltageL1L2}", "V"));
        item5.add(new StatusUPSInfoItem("[text.bypassVoltage] L2-L3", "{workInfo.bypassVoltageL2L3}", "V"));
        item5.add(new StatusUPSInfoItem("[text.bypassVoltage] L1-L3", "{workInfo.bypassVoltageL1L3}", "V"));
        item5.add(new StatusUPSInfoItem("[text.bypassFrequency]", "{workInfo.bypassFrequency}", "Hz"));
        statusUpsInfolist5.setLines(item5);
        info.add(statusUpsInfolist5);
        StatusUPSInfoList statusUpsInfolist2 = new StatusUPSInfoList();
        statusUpsInfolist2.setLabel("[label.upsInfo]");
        ArrayList<StatusUPSInfoItem> item2 = new ArrayList<StatusUPSInfoItem>();
        item2.add(new StatusUPSInfoItem("[text.workMod]", "{workInfo.workMode}", ""));
        item2.add(new StatusUPSInfoItem("[text.upsTemperature]", "{workInfo.temperatureView}", MyConstants.getTempUnit()));
        item2.add(new StatusUPSInfoItem("[label.autoReboot]", "{workInfo.autoReboot}", ""));
        item2.add(new StatusUPSInfoItem("[label.converterMode]", "{workInfo.converterMode}", ""));
        item2.add(new StatusUPSInfoItem("[label.eCOMode]", "{workInfo.ecomode}", ""));
        item2.add(new StatusUPSInfoItem("[label.bypassOff]", "{workInfo.bypassOff}", ""));
        item2.add(new StatusUPSInfoItem("[label.bypassNotAllowed]", "{workInfo.bypassNotAllowed}", ""));
        item2.add(new StatusUPSInfoItem("[label.faultType]", "{workInfo.faultType}", ""));
        item2.add(new StatusUPSInfoItem("[label.warn]", "{workInfo.warnings}", ""));
        statusUpsInfolist2.setLines(item2);
        info.add(statusUpsInfolist2);
        StatusUPSInfoList statusUpsInfolist3 = new StatusUPSInfoList();
        statusUpsInfolist3.setLabel("[label.batteryInfo]");
        ArrayList<StatusUPSInfoItem> item3 = new ArrayList<StatusUPSInfoItem>();
        item3.add(new StatusUPSInfoItem("[text.BTV]", "{workInfo.batteryVoltage}", "V"));
        item3.add(new StatusUPSInfoItem("[text.BatteryPercent]", "{workInfo.batteryCapacity}", "%"));
        if (this.supportRemainTime) {
            item3.add(new StatusUPSInfoItem("[text.batteryRemaining]", "{workInfo.batteryRemainTime}", "Min"));
        }
        statusUpsInfolist3.setLines(item3);
        info.add(statusUpsInfolist3);
        StatusUPSInfoList statusUpsInfolist4 = new StatusUPSInfoList();
        statusUpsInfolist4.setLabel("[label.outputInfo]");
        ArrayList<StatusUPSInfoItem> item4 = new ArrayList<StatusUPSInfoItem>();
        if (this.ioPhase31.equals("3/1")) {
            item4.add(new StatusUPSInfoItem("[text.outputV] L1-N", "{workInfo.outputVoltage}", "V"));
            item4.add(new StatusUPSInfoItem("[text.loadEle] L1-N", "{workInfo.outputCurrent}", "A"));
            item4.add(new StatusUPSInfoItem("[text.outputF]", "{workInfo.outputFrequency}", "Hz"));
            item4.add(new StatusUPSInfoItem("[label.loadPercents] L1", "{workInfo.loadLevel}", "%"));
        } else {
            item4.add(new StatusUPSInfoItem("[text.outputV] L1-N", "{workInfo.outputVoltage}", "V"));
            item4.add(new StatusUPSInfoItem("[text.outputV] L2-N", "{workInfo.outputVoltageS}", "V"));
            item4.add(new StatusUPSInfoItem("[text.outputV] L3-N", "{workInfo.outputVoltageT}", "V"));
            item4.add(new StatusUPSInfoItem("[text.outputV] L1-L2", "{workInfo.outputVoltageL1L2}", "V"));
            item4.add(new StatusUPSInfoItem("[text.outputV] L2-L3", "{workInfo.outputVoltageL2L3}", "V"));
            item4.add(new StatusUPSInfoItem("[text.outputV] L1-L3", "{workInfo.outputVoltageL1L3}", "V"));
            item4.add(new StatusUPSInfoItem("[text.loadEle] L1-N", "{workInfo.outputCurrent}", "A"));
            item4.add(new StatusUPSInfoItem("[text.loadEle] L2-N", "{workInfo.outputCurrentS}", "A"));
            item4.add(new StatusUPSInfoItem("[text.loadEle] L3-N", "{workInfo.outputCurrentT}", "A"));
            item4.add(new StatusUPSInfoItem("[text.outputF]", "{workInfo.outputFrequency}", "Hz"));
            item4.add(new StatusUPSInfoItem("[label.loadPercents] L1", "{workInfo.loadLevel}", "%"));
            item4.add(new StatusUPSInfoItem("[label.loadPercents] L2", "{workInfo.loadLevelS}", "%"));
            item4.add(new StatusUPSInfoItem("[label.loadPercents] L3", "{workInfo.loadLevelT}", "%"));
            item4.add(new StatusUPSInfoItem("[label.loadLevel]", "{workInfo.outputLoadPercent}", "%"));
        }
        statusUpsInfolist4.setLines(item4);
        info.add(statusUpsInfolist4);
        statusUpsinfo.setInfo(info);
        return statusUpsinfo;
    }

    public WebMapping getWebMapping() {
        return null;
    }

    @Override
    public AutoMenuList getMenuList() {
        return super.getMenuList();
    }
}

