/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.protocol;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.data.bean.AutoMenuItem;
import cn.com.voltronicpower.data.bean.AutoMenuList;
import cn.com.voltronicpower.data.bean.AutoMenuOne;
import cn.com.voltronicpower.data.bean.AutoMenuTwo;
import cn.com.voltronicpower.data.bean.MonitorData;
import cn.com.voltronicpower.data.bean.StatusUPSInfo;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.monitor.protocol.P00;
import cn.com.voltronicpower.monitor.protocol.P01;
import cn.com.voltronicpower.monitor.protocol.P02;
import cn.com.voltronicpower.monitor.protocol.P03;
import cn.com.voltronicpower.monitor.protocol.P05;
import cn.com.voltronicpower.monitor.protocol.P08;
import cn.com.voltronicpower.monitor.protocol.P09;
import cn.com.voltronicpower.monitor.protocol.P10;
import cn.com.voltronicpower.monitor.protocol.P13;
import cn.com.voltronicpower.monitor.protocol.P14;
import cn.com.voltronicpower.monitor.protocol.P31;
import cn.com.voltronicpower.monitor.protocol.P33;
import cn.com.voltronicpower.monitor.protocol.P35;
import cn.com.voltronicpower.monitor.protocol.P36;
import cn.com.voltronicpower.monitor.protocol.P38;
import cn.com.voltronicpower.monitor.protocol.P39;
import cn.com.voltronicpower.monitor.protocol.P40;
import cn.com.voltronicpower.monitor.protocol.P44;
import cn.com.voltronicpower.monitor.protocol.P73;
import cn.com.voltronicpower.monitor.protocol.P99;
import cn.com.voltronicpower.monitorcommunicate.ModbusHandler;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.FileUtilites;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class P010203
implements IProtocol {
    public static final String QPI = "QPI";
    public static final String QGS = "QGS";
    public static final String QMD = "QMD";
    public static final String QFS = "QFS";
    public static final String QMOD = "QMOD";
    public static final String QRI = "QRI";
    public static final String QVFW = "QVFW";
    public static final String QVFW2 = "QVFW2";
    public static final String QID = "QID";
    public static final String QBV = "QBV";
    public static final String QBCO = "QBCO";
    public static final String QFLAG = "QFLAG";
    public static final String QWS = "QWS";
    public static final String QSK1 = "QSK1";
    public static final String QSK2 = "QSK2";
    public static final String QSKT = "QSKT";
    public static final String Q3PV = "Q3PV";
    public static final String Q3OV = "Q3OV";
    public static final String Q3OC = "Q3OC";
    public static final String Q3LD = "Q3LD";
    public static final String Q3YV = "Q3YV";
    public static final String QPD = "QPD";
    public static final String Q3GS = "Q3GS";
    public static final String QBKTM = "QBKTM";
    public static final String QBRPD = "QBRPD";
    public static final String QBDT = "QBDT";
    public static final String MN = "MN";
    public static final String T = "T";
    public static final String TL = "TL";
    public static final String Tn = "Tn";
    public static final String Sn = "Sn";
    public static final String SnRm = "SnRm";
    public static final String CS = "CS";
    public static final String CT = "CT";
    public static final String SON = "SON";
    public static final String SOFF = "SOFF";
    public static final String BZOFF = "BZOFF";
    public static final String BZON = "BZON";
    public static final String SKON = "SKON";
    public static final String SKOFF = "SKOFF";
    public static final String PEA = "PEA";
    public static final String PDA = "PDA";
    public static final String PE = "PE";
    public static final String PD = "PD";
    public static final String PF = "PF";
    public static final String BATN = "BATN";
    public static final String BATGN = "BATGN";
    public static final String PSK = "PSK";
    public static final String QBYV = "QBYV";
    public static final String QBYF = "QBYF";
    public static final String QHE = "QHE";
    public static final String MD = "MD";
    public static final String PBRPD = "PBRPD";
    public static final String QSID = "QSID";
    protected boolean supportRemainTime = true;
    private String noSupportStr = "010";
    public String ioPhase31 = "1/1";
    public static final String QMCHGMC = "QMCHGMC";
    public static final String MCHGMC = "MCHGMC";
    public static final String MBATHI = "MBATHI";
    public static final String QMBATHI = "QMBATHI";
    public static final String QMBATLO = "QMBATLO";
    public static final String QMCHGC = "QMCHGC";
    public static final String QMPOW = "QMPOW";
    public static final String QMPOW_T = "QM+POW";
    public static final String QSOLV = "QSOLV";
    public static final String QEMOD = "QEMOD";
    public static final String EMOD = "EMOD";
    public static final String QSOLSAT = "QSOLSAT";
    public static final String QCHGMOD = "QCHGMOD";

    public void formatMonitorData(Object monitor) {
        MonitorData data = (MonitorData)monitor;
        WorkInfo workInfo = data.getWorkInfo();
        if (data.getCapability().isCapableR()) {
            workInfo.setAutoReboot("[label.enable]");
        } else {
            workInfo.setAutoReboot("[label.disable]");
        }
        if (data.getCapability().isCapableV()) {
            workInfo.setConverterMode("[label.enable]");
        } else {
            workInfo.setConverterMode("[label.disable]");
        }
        if (data.getCapability().isCapableE()) {
            workInfo.setEcomode("[label.enable]");
        } else {
            workInfo.setEcomode("[label.disable]");
        }
        if (data.getCapability().isCapableO()) {
            workInfo.setBypassOff("[label.enable]");
        } else {
            workInfo.setBypassOff("[label.disable]");
        }
        if (data.getCapability().isCapableF()) {
            workInfo.setBypassNotAllowed("[label.enable]");
        } else {
            workInfo.setBypassNotAllowed("[label.disable]");
        }
        if (workInfo.isEnableOutlet1()) {
            workInfo.setP1outlet("[label.enable]");
        } else {
            workInfo.setP1outlet("[label.disable]");
        }
    }

    public boolean isCouldExcuteBatteryTest(WorkInfo workinfo) {
        String workMode = workinfo.getWorkMode();
        return workMode.equals("Line mode") || workMode.equals("Converter mode") || workMode.equals("ECO mode");
    }

    public boolean matchProtocol(CommunicateHandlerInterface handler) {
        boolean result = false;
        if (handler instanceof ModbusHandler) {
            return result;
        }
        handler.setCheckSum(false);
        handler.setCrcCheck(false);
        String dataStr = "(NAK";
        try {
            int i = 0;
            while (i < 5) {
                if (!dataStr.equals("(NAK")) break;
                dataStr = handler.excuteSimpleCommand(QPI);
                ++i;
            }
            if (dataStr.startsWith("(PI")) {
                if (dataStr.endsWith("00") && this instanceof P00 || dataStr.endsWith("01") && this instanceof P01 || dataStr.endsWith("02") && this instanceof P02 || dataStr.endsWith("03") && this instanceof P03 || dataStr.endsWith("05") && this instanceof P05 || dataStr.endsWith("08") && this instanceof P08 || dataStr.endsWith("09") && this instanceof P09 || dataStr.endsWith("13") && this instanceof P13 || dataStr.endsWith("14") && this instanceof P14 || dataStr.endsWith("31") && this instanceof P31 || dataStr.endsWith("33") && this instanceof P33 || dataStr.endsWith("35") && this instanceof P35 || dataStr.endsWith("36") && this instanceof P36 || dataStr.endsWith("38") && this instanceof P38 || dataStr.endsWith("44") && this instanceof P44 || dataStr.endsWith("99") && this instanceof P99 || dataStr.endsWith("10") && this instanceof P10 || dataStr.endsWith("39") && this instanceof P39 || dataStr.endsWith("73") && this instanceof P73) {
                    result = true;
                }
            } else if (dataStr.startsWith("PI")) {
                if (dataStr.endsWith("35") && this instanceof P35 || dataStr.endsWith("36") && this instanceof P36) {
                    result = true;
                } else if (dataStr.endsWith("01") && this instanceof P00) {
                    result = true;
                }
            }
            if (dataStr.endsWith("02") || dataStr.endsWith("03") || dataStr.endsWith("09") || dataStr.endsWith("10") || dataStr.endsWith("13") || dataStr.endsWith("14")) {
                String qbvStr = handler.excuteSimpleCommand(QBV);
                if (qbvStr == null || "(NAK".equals(qbvStr)) {
                    return result;
                }
                String[] strs = qbvStr.split(" ");
                int remainTimeLength = 0;
                if (strs.length <= 0) {
                    return result;
                }
                remainTimeLength = strs[4].length();
                this.supportRemainTime = !(remainTimeLength != 5 && remainTimeLength != 3 || this.noSupportStr.equals(strs[4]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public AutoMenuList getMenuList() {
        AutoMenuList menuList = new AutoMenuList();
        ArrayList<AutoMenuOne> menus = new ArrayList<AutoMenuOne>();
        ArrayList<AutoMenuTwo> items1 = new ArrayList<AutoMenuTwo>();
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.passwordSet]".replace("[", "").replace("]", ""), "password", "", "menu"), null));
        if (MyConstants.Customized.equals("NEXTVision") || MyConstants.Customized.equals("Forza")) {
            items1.add(new AutoMenuTwo(new AutoMenuItem("[label.smsemailSet]".replace("[", "").replace("]", ""), "mobile", "", "menu"), null));
        } else {
            items1.add(new AutoMenuTwo(new AutoMenuItem("[label.smsinfoSet]".replace("[", "").replace("]", ""), "mobile", "", "menu"), null));
            items1.add(new AutoMenuTwo(new AutoMenuItem("[label.emailSet]".replace("[", "").replace("]", ""), "email", "", "menu"), null));
        }
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.electricEventSet]".replace("[", "").replace("]", ""), "eleEvent", "", "menu"), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.netWeakUPSet]".replace("[", "").replace("]", ""), "network", "", "menu"), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.setcom]".replace("[", "").replace("]", ""), "setcom", "", "menu"), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.recorddata]".replace("[", "").replace("]", ""), "recorddata", "", "menu"), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("[label.modbussetting]".replace("[", "").replace("]", ""), "modbus", "", "menu"), null));
        ArrayList<AutoMenuTwo> items2 = new ArrayList<AutoMenuTwo>();
        if (MyConstants.Customized.equals("NEXTVision") || MyConstants.Customized.equals("Forza")) {
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.shutdownParamSet]".replace("[", "").replace("]", ""), "loadClose", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.remoteShutdownParamSet]".replace("[", "").replace("]", ""), "remoteLoadClose", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.realTimeCtrl]".replace("[", "").replace("]", ""), "onOff", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.controlParamSet]".replace("[", "").replace("]", ""), "controlPara", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.powerPlan]".replace("[", "").replace("]", ""), "onOffPlan", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.autoTestPlan]".replace("[", "").replace("]", ""), "testPlan", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.upsBurInfoSet]".replace("[", "").replace("]", ""), "buy", "", "menu"), null));
        } else {
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.shutdownParamSet]".replace("[", "").replace("]", ""), "loadClose", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.remoteShutdownParamSet]".replace("[", "").replace("]", ""), "remoteLoadClose", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.controlParamSet]".replace("[", "").replace("]", ""), "controlPara", "", "menu"), null));
            items2.add(new AutoMenuTwo(new AutoMenuItem("[label.upsBurInfoSet]".replace("[", "").replace("]", ""), "buy", "", "menu"), null));
        }
        ArrayList<AutoMenuTwo> items3 = new ArrayList<AutoMenuTwo>();
        if (!(this instanceof P40)) {
            items3.add(new AutoMenuTwo(new AutoMenuItem("[label.realTimeCtrl]".replace("[", "").replace("]", ""), "onOff", "", "menu"), null));
            items3.add(new AutoMenuTwo(new AutoMenuItem("[label.powerPlan]".replace("[", "").replace("]", ""), "onOffPlan", "", "menu"), null));
        }
        items3.add(new AutoMenuTwo(new AutoMenuItem("[label.autoTestPlan]".replace("[", "").replace("]", ""), "testPlan", "", "menu"), null));
        ArrayList<AutoMenuTwo> items4 = new ArrayList<AutoMenuTwo>();
        items4.add(new AutoMenuTwo(new AutoMenuItem("[label.realInfoView]".replace("[", "").replace("]", ""), "immediately", "", "menu"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("[label.historyInfoView]".replace("[", "").replace("]", ""), "historyInfo", "", "menu"), null));
        ArrayList<AutoMenuItem> temps = new ArrayList<AutoMenuItem>();
        temps.add(new AutoMenuItem("[label.Celsius]".replace("[", "").replace("]", ""), "celsiur", "radio", "temp"));
        temps.add(new AutoMenuItem("[label.Fahrenheit]".replace("[", "").replace("]", ""), "fahrenheit", "radio", "temp"));
        ArrayList<AutoMenuItem> dates = new ArrayList<AutoMenuItem>();
        dates.add(new AutoMenuItem("YYYY-MM-DD", "YYYY-MM-DD", "radio", "date"));
        dates.add(new AutoMenuItem("YYYY/MM/DD", "YYYY/MM/DD", "radio", "date"));
        dates.add(new AutoMenuItem("YYYY:MM:DD", "YYYY:MM:DD", "radio", "date"));
        dates.add(new AutoMenuItem("MM-DD-YYYY", "MM-DD-YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("MM/DD/YYYY", "MM/DD/YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("MM:DD:YYYY", "MM:DD:YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("DD-MM-YYYY", "DD-MM-YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("DD/MM/YYYY", "DD/MM/YYYY", "radio", "date"));
        dates.add(new AutoMenuItem("DD:MM:YYYY", "DD:MM:YYYY", "radio", "date"));
        ArrayList<AutoMenuTwo> items5 = new ArrayList<AutoMenuTwo>();
        items5.add(new AutoMenuTwo(new AutoMenuItem("[label.temperatureUnit]".replace("[", "").replace("]", ""), "temperature", "", ""), temps));
        items5.add(new AutoMenuTwo(new AutoMenuItem("[label.dateFormat]".replace("[", "").replace("]", ""), "requireState", "", ""), dates));
        ArrayList<AutoMenuTwo> items6 = new ArrayList<AutoMenuTwo>();
        items6.add(new AutoMenuTwo(new AutoMenuItem("English", "English", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("French", "French", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("German", "German", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Italian", "Italian", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Polish", "Polish", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Portuguese", "Portuguese", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Russian", "Russian", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Spanish", "Spanish", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Ukrainian", "Ukrainian", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Turkish", "Turkish", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Czech", "Czech", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Simplified)", "Chinese", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Traditional)", "ChineseTW", "radio", "language"), null));
        items6.add(new AutoMenuTwo(new AutoMenuItem("Japanese", "Japanese", "radio", "language"), null));
        ArrayList<AutoMenuTwo> items7 = new ArrayList<AutoMenuTwo>();
        items7.add(new AutoMenuTwo(new AutoMenuItem("[label.copyRight]".replace("[", "").replace("]", ""), "copyRight", "", ""), null));
        List<AutoMenuItem> helps = MyConstants.getOnlineHelp();
        if (helps.size() > 1) {
            items7.add(new AutoMenuTwo(new AutoMenuItem("[label.systemHelp]".replace("[", "").replace("]", ""), "systemHelp", "", ""), MyConstants.getOnlineHelp()));
        } else {
            Locale local = Locale.getDefault();
            String language = local.getLanguage();
            if ("zh".equals(language) && FileUtilites.checkFile("help_zh.swf")) {
                items7.add(new AutoMenuTwo(new AutoMenuItem("[label.systemHelp]".replace("[", "").replace("]", ""), "systemHelp_zh", "", ""), null));
            } else if ("ru".equals(language) && FileUtilites.checkFile("help_ru.swf")) {
                items7.add(new AutoMenuTwo(new AutoMenuItem("[label.systemHelp]".replace("[", "").replace("]", ""), "systemHelp_ru", "", ""), null));
            } else if ("tr".equals(language) && FileUtilites.checkFile("help_tr.swf")) {
                items7.add(new AutoMenuTwo(new AutoMenuItem("[label.systemHelp]".replace("[", "").replace("]", ""), "systemHelp_tr", "", ""), null));
            } else {
                items7.add(new AutoMenuTwo(new AutoMenuItem("[label.systemHelp]".replace("[", "").replace("]", ""), "systemHelp_en", "", ""), null));
            }
        }
        if (MyConstants.Customized.equals("Forza") || MyConstants.Customized.equals("NEXTVision")) {
            menus.add(new AutoMenuOne("[label.config]".replace("[", "").replace("]", ""), "system", items1));
        } else {
            menus.add(new AutoMenuOne(MyConstants.getCustomerViewpower(), "system", items1));
        }
        if (MyConstants.Customized.equals("NEXTVision") || MyConstants.Customized.equals("Forza")) {
            menus.add(new AutoMenuOne("Console", "config", items2));
        } else {
            menus.add(new AutoMenuOne("[label.upsSet]".replace("[", "").replace("]", ""), "config", items2));
            menus.add(new AutoMenuOne("[label.controlPlatform]".replace("[", "").replace("]", ""), "control", items3));
            menus.add(new AutoMenuOne("[label.upsWatch]".replace("[", "").replace("]", ""), "monitor", items4));
        }
        menus.add(new AutoMenuOne("[label.systemStyle]".replace("[", "").replace("]", ""), "top", items5));
        menus.add(new AutoMenuOne("[label.language]".replace("[", "").replace("]", ""), "top", items6));
        menus.add(new AutoMenuOne("[label.Help]".replace("[", "").replace("]", ""), "top", items7));
        menuList.setMenuList(menus);
        return menuList;
    }

    public StatusUPSInfo getModulesInfo() {
        return null;
    }

    public void refreshData(CommunicateHandlerInterface arg0) {
    }

    public String getIoPhase31() {
        return this.ioPhase31;
    }

    public void setIophase(String ioPhase31) {
        this.ioPhase31 = ioPhase31;
    }

    public void setProtocolPMV(String arg0) {
    }
}

