/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.processor;

import cn.com.voltronic.util.MathUtils;
import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.data.bean.Capability;
import cn.com.voltronicpower.data.bean.CapabilityTaurus;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.data.dao.ConfigDao;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.exception.UnsupportException;
import cn.com.voltronicpower.monitor.AbstractMonitorProcessor;
import cn.com.voltronicpower.monitorcommunicate.ModbusHandler;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.AES128CBC;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.utilities.StrUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import net.wimpi.modbus.ModbusException;
import net.wimpi.modbus.procimg.Register;
import net.wimpi.modbus.procimg.SimpleRegister;
import net.wimpi.modbus.util.BitVector;
import net.wimpi.modbus.util.ModbusUtil;
import org.springframework.beans.BeanWrapperImpl;

public class TaurusProcessor
extends AbstractMonitorProcessor {
    private final double MODBUS_NUMBER = 100.0;
    private CapabilityTaurus capability = new CapabilityTaurus();

    public TaurusProcessor(CommunicateHandlerInterface handler, IProtocol protocol) {
        super(handler, protocol);
    }

    private ModbusHandler getModbusHandler() {
        return (ModbusHandler)this._handler;
    }

    private void setModBusWorkMode(WorkInfo work) {
        try {
            if (this.haveInputV(work) && !this.haveOutputV(work) || !this.haveInputV(work) && !this.haveOutputV(work) && this.connectBattery()) {
                work.setWorkMode("Standby mode");
                this.isBatMod = false;
            }
            if (!this.haveInverterV(work) && this.haveOutputV(work)) {
                work.setWorkMode("Bypass mode");
                this.isBatMod = false;
            } else if (Double.parseDouble(work.getInputFrequency()) > 20.0) {
                if (this.batteryTesting()) {
                    work.setWorkMode("Battery test mode");
                    this.isBatMod = false;
                } else if (this.haveInverterV(work) && this.haveOutputV(work)) {
                    work.setWorkMode("Line mode");
                    this.isBatMod = false;
                }
            } else if (!this.haveInputV(work) && !this.haveOutputV(work) && this.connectBattery()) {
                work.setWorkMode("Standby mode");
                this.isBatMod = false;
            } else {
                work.setWorkMode("Battery mode");
                if (!this.isBatMod) {
                    this.shutdownOnBatteryMode();
                }
                this.isBatMod = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean connectBattery() {
        boolean result = true;
        try {
            CapabilityTaurus cap = (CapabilityTaurus)this.getCapability();
            if (cap.isCapable25b8() || cap.isCapable26b1()) {
                result = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (UnsupportException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean isLowBattery() {
        boolean result = false;
        try {
            CapabilityTaurus cap = (CapabilityTaurus)this.getCapability();
            if (cap.isCapable27b4() || cap.isCapable25b2()) {
                result = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (UnsupportException e) {
            e.printStackTrace();
        }
        return result;
    }

    private boolean haveInputV(WorkInfo work) {
        boolean result = true;
        try {
            result = Double.parseDouble(work.getInputVoltage()) > 100.0 || Double.parseDouble(work.getInputVoltageS()) > 100.0 || Double.parseDouble(work.getInputVoltageT()) > 100.0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private boolean haveOutputV(WorkInfo work) {
        boolean result = true;
        try {
            result = Double.parseDouble(work.getOutputVoltage()) > 100.0 || Double.parseDouble(work.getOutputVoltageS()) > 100.0 || Double.parseDouble(work.getOutputVoltageT()) > 100.0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private boolean haveInverterV(WorkInfo work) {
        boolean result = true;
        try {
            result = Double.parseDouble(work.getInverterVoltage()) > 100.0 || Double.parseDouble(work.getInverterVoltageS()) > 100.0 || Double.parseDouble(work.getInverterVoltageT()) > 100.0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private boolean batteryTesting() throws ModbusException {
        ModbusHandler modbusHandler = this.getModbusHandler();
        Register[] reg = modbusHandler.readMultipleRegisters(93, 1);
        return reg[0].getValue() == 1;
    }

    public boolean isFault() {
        return false;
    }

    @Override
    public WorkInfo queryWorkInfo() {
        try {
            this.workInfo.setPtid("MODBUS");
            ModbusHandler modbusHandler = this.getModbusHandler();
            this.workInfo.setCurrentTime(new Date());
            this.workInfo.setDeviceId(this.getDeviceId());
            Register[] registers = modbusHandler.readMultipleRegisters(4638, 10);
            this.workInfo.setInputVoltageL1L2("" + MathUtils.round((double)((double)registers[0].getValue() * 0.1), (int)1));
            this.workInfo.setInputVoltageL2L3("" + MathUtils.round((double)((double)registers[1].getValue() * 0.1), (int)1));
            this.workInfo.setInputVoltageL1L3("" + MathUtils.round((double)((double)registers[2].getValue() * 0.1), (int)1));
            this.workInfo.setInputVoltage("" + MathUtils.round((double)((double)registers[3].getValue() * 0.1), (int)1));
            this.workInfo.setInputVoltageS("" + MathUtils.round((double)((double)registers[4].getValue() * 0.1), (int)1));
            this.workInfo.setInputVoltageT("" + MathUtils.round((double)((double)registers[5].getValue() * 0.1), (int)1));
            this.workInfo.setInputFrequency("" + MathUtils.round((double)((double)registers[6].getValue() * 0.1), (int)1));
            this.workInfo.setInputCurrentR("" + MathUtils.round((double)((double)registers[7].getValue() * 0.1), (int)1));
            this.workInfo.setInputCurrentS("" + MathUtils.round((double)((double)registers[8].getValue() * 0.1), (int)1));
            this.workInfo.setInputCurrentT("" + MathUtils.round((double)((double)registers[9].getValue() * 0.1), (int)1));
            Register[] registers2 = modbusHandler.readMultipleRegisters(4651, 31);
            this.workInfo.setInverterVoltage("" + MathUtils.round((double)((double)registers2[11].getValue() * 0.1), (int)1));
            this.workInfo.setInverterVoltageS("" + MathUtils.round((double)((double)registers2[12].getValue() * 0.1), (int)1));
            this.workInfo.setInverterVoltageT("" + MathUtils.round((double)((double)registers2[13].getValue() * 0.1), (int)1));
            this.workInfo.setBypassVoltage("" + MathUtils.round((double)((double)registers2[17].getValue() * 0.1), (int)1));
            this.workInfo.setBypassVoltageS("" + MathUtils.round((double)((double)registers2[18].getValue() * 0.1), (int)1));
            this.workInfo.setBypassVoltageT("" + MathUtils.round((double)((double)registers2[19].getValue() * 0.1), (int)1));
            this.workInfo.setBypassFrequency("" + MathUtils.round((double)((double)registers2[20].getValue() * 0.1), (int)1));
            this.workInfo.setBypassCurrent("" + MathUtils.round((double)((double)registers2[21].getValue() * 0.1), (int)1));
            this.workInfo.setBypassCurrentS("" + MathUtils.round((double)((double)registers2[22].getValue() * 0.1), (int)1));
            this.workInfo.setBypassCurrentT("" + MathUtils.round((double)((double)registers2[23].getValue() * 0.1), (int)1));
            this.workInfo.setOutputVoltage("" + MathUtils.round((double)((double)registers2[24].getValue() * 0.1), (int)1));
            this.workInfo.setOutputVoltageS("" + MathUtils.round((double)((double)registers2[25].getValue() * 0.1), (int)1));
            this.workInfo.setOutputVoltageT("" + MathUtils.round((double)((double)registers2[26].getValue() * 0.1), (int)1));
            this.workInfo.setOutputFrequency("" + MathUtils.round((double)((double)registers2[27].getValue() * 0.1), (int)1));
            this.workInfo.setOutputCurrent("" + MathUtils.round((double)((double)registers2[28].getValue() * 0.1), (int)1));
            this.workInfo.setOutputCurrentS("" + MathUtils.round((double)((double)registers2[29].getValue() * 0.1), (int)1));
            this.workInfo.setOutputCurrentT("" + MathUtils.round((double)((double)registers2[30].getValue() * 0.1), (int)1));
            Register[] registers3 = modbusHandler.readMultipleRegisters(4685, 28);
            this.workInfo.setLoadLevel("" + MathUtils.round((double)((double)registers3[11].getValue() * 0.1), (int)1));
            this.workInfo.setLoadLevelS("" + MathUtils.round((double)((double)registers3[12].getValue() * 0.1), (int)1));
            this.workInfo.setLoadLevelT("" + MathUtils.round((double)((double)registers3[13].getValue() * 0.1), (int)1));
            this.workInfo.setOutputLoadPercent("" + MathUtils.round((double)((double)registers3[14].getValue() * 0.1), (int)1));
            this.workInfo.setPositiveBatteryVoltage("" + MathUtils.round((double)((double)registers3[17].getValue() * 0.1), (int)1));
            this.workInfo.setNegativeBatteryVoltage("" + MathUtils.round((double)((double)registers3[18].getValue() * 0.1), (int)1));
            this.workInfo.setRectifierHt("" + registers3[23].getValue());
            this.workInfo.setInverterHT("" + registers3[24].getValue());
            this.workInfo.setTemperature("" + registers3[25].getValue());
            this.workInfo.setBatteryRemainTime(registers3[26].getValue());
            if (MathUtils.round((double)((double)registers3[17].getValue() * 0.1), (int)1) == 0.0 && MathUtils.round((double)((double)registers3[18].getValue() * 0.1), (int)1) == 0.0 && this.workInfo.getBatteryRemainTime() == 0) {
                this.workInfo.setBatteryCapacity(0);
            } else {
                this.workInfo.setBatteryCapacity(registers3[27].getValue());
            }
            this.setModBusWorkMode(this.workInfo);
            int batteryCapacity = this.workInfo.getBatteryCapacity();
            Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
            int batCapacity = shutdown.getBatCapacity();
            if ("Battery mode".equals(this.workInfo.getWorkMode()) && batteryCapacity <= batCapacity) {
                if (!this.isBatCap && ("InfoPower".equalsIgnoreCase(MyConstants.Customized) || "NetGuard".equalsIgnoreCase(MyConstants.Customized) || "ATMUSE".equalsIgnoreCase(MyConstants.Customized))) {
                    new Thread(){

                        @Override
                        public void run() {
                            TaurusProcessor.this.isBatCap = true;
                            TaurusProcessor.this.shutdownOnBatteryCapacity();
                        }
                    }.start();
                }
            } else {
                this.isBatCap = false;
            }
            this.queryCapabilityTaurus();
            boolean inputOn = this.haveInputV(this.workInfo);
            this.shutdownOnlowBattery(inputOn, this.isLowBattery());
            this.workInfo.setInsertInput(true);
            this.workInfo.setInsertBypass(true);
            this.workInfo.setInsertOutput(true);
            this.workInfo.setCanBatteryTest(this.connectBattery());
            this.reconnectTimes = 0;
        }
        catch (Exception e) {
            this.workInfo.clear();
            this.logingCommunicateException(false);
        }
        return this.workInfo;
    }

    private final void refreshWarningStatus(boolean warnStatus, int index, String eventCode) {
        if (warnStatus) {
            EventsHandler.handleEvent(this.getDeviceName(), eventCode, "MODBUS", this.getDeviceId(), true);
        } else {
            EventsHandler.removeEvent(this.getDeviceName(), eventCode);
        }
    }

    private ArrayList<BitVector> readToBitVector(int address, int count) {
        ModbusHandler modbusHandler = this.getModbusHandler();
        ArrayList<BitVector> list = new ArrayList<BitVector>();
        try {
            Register[] reg = modbusHandler.readMultipleRegisters(address, count);
            int item = 0;
            while (item < reg.length) {
                BitVector bit = new BitVector(16);
                bit.setBytes(reg[item].toBytes(), 16);
                bit.toggleAccess(true);
                list.add(bit);
                ++item;
            }
        }
        catch (ModbusException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void queryCapabilityTaurus() {
        BeanWrapperImpl configWrapper = new BeanWrapperImpl((Object)this.capability);
        ArrayList<BitVector> bitList = this.readToBitVector(0, 5);
        int eventCodeIndex = 0;
        int capableIndex = 25;
        int i = 0;
        while (i < bitList.size()) {
            BitVector bitItem = bitList.get(i);
            int j = 0;
            while (j < bitItem.size()) {
                if (capableIndex == 29 && j > 15) break;
                String fieldname = "capable" + capableIndex + "b" + j;
                this.refreshWarningStatus(bitItem.getBit(bitItem.size() - 1 - j), 0, "35" + StrUtils.leftZero("" + ++eventCodeIndex, 2));
                try {
                    configWrapper.setPropertyValue(fieldname, (Object)bitItem.getBit(bitItem.size() - 1 - j));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++j;
            }
            ++capableIndex;
            ++i;
        }
    }

    @Override
    public synchronized String excuteCommand(int address, short value) throws IOException {
        ModbusHandler modbusHandler = this.getModbusHandler();
        int modbusPwd = 0;
        try {
            modbusPwd = Integer.parseInt(AES128CBC.descryptLocal(ConfigDao.qryValue("GlobalConfig.modbusPassword")));
        }
        catch (Exception e) {
            return "failure";
        }
        try {
            byte[] bytes = ModbusUtil.shortToRegister((short)((short)modbusPwd));
            SimpleRegister pass = new SimpleRegister(bytes[0], bytes[1]);
            modbusHandler.writeMultipleRegisters(5098, new Register[]{pass});
            Register[] value1 = modbusHandler.readMultipleRegisters(5098, 1);
            System.out.println("modbus password:" + value1[0].getValue());
            bytes = ModbusUtil.shortToRegister((short)value);
            Register[] regs = new Register[]{new SimpleRegister(bytes[0], bytes[1])};
            modbusHandler.writeMultipleRegisters(address, regs);
            Register[] value2 = modbusHandler.readMultipleRegisters(address, 1);
            System.out.println("set value:" + value2[0].getValue());
        }
        catch (ModbusException e) {
            e.printStackTrace();
        }
        return "success";
    }

    @Override
    public void queryUpsInfo() throws IOException {
        ModbusHandler modbusHandler = this.getModbusHandler();
        try {
            this.identity.setMorphological("on-line");
            Register[] unittype = modbusHandler.readMultipleRegisters(4818, 1);
            this.identity.setIoPhase(this.getUnitType(unittype[0].getValue()));
            Register[] sn = modbusHandler.readMultipleRegisters(5070, 6);
            StringBuffer snStr = new StringBuffer();
            int item = 0;
            while (item < 6) {
                snStr.append(new String(sn[item].toBytes()));
                ++item;
            }
            this.identity.setProductSN(snStr.toString());
            Register[] micSV = modbusHandler.readMultipleRegisters(5016, 6);
            Register[] dspSV = modbusHandler.readMultipleRegisters(5043, 6);
            StringBuffer micSVStr = new StringBuffer();
            StringBuffer dspSVStr = new StringBuffer();
            int item2 = 0;
            while (item2 < 6) {
                micSVStr.append(new String(micSV[item2].toBytes()));
                dspSVStr.append(new String(dspSV[item2].toBytes()));
                ++item2;
            }
            this.identity.setFwVersion(String.valueOf(micSVStr.toString().trim()) + "/" + dspSVStr.toString().trim());
            Register[] parallelUps = modbusHandler.readMultipleRegisters(4849, 1);
            this.identity.setParallelUps(this.getYesNo(parallelUps[0].getValue()));
            Register[] rating = modbusHandler.readMultipleRegisters(4799, 13);
            this.ratingInfo.setNominalInputV(String.valueOf(rating[0].getValue()) + " V");
            this.ratingInfo.setMinInputV(String.valueOf(rating[1].getValue()) + " %");
            this.ratingInfo.setMaxInputV(String.valueOf(rating[2].getValue()) + " %");
            this.ratingInfo.setNominalBypassV(String.valueOf(rating[3].getValue()) + " V");
            this.ratingInfo.setMinBypassV(String.valueOf(rating[4].getValue()) + " %");
            this.ratingInfo.setMaxBypassV(String.valueOf(rating[5].getValue()) + " %");
            this.ratingInfo.setNominalDCBusV(String.valueOf(rating[6].getValue()) + " V");
            this.ratingInfo.setDcCurrent(String.valueOf(rating[7].getValue()) + " A");
            this.ratingInfo.setNominalBatCC(String.valueOf(MathUtils.round((double)((double)rating[8].getValue() * 0.1), (int)1)) + " A");
            this.ratingInfo.setNominalInvC(String.valueOf(rating[9].getValue()) + " V");
            this.ratingInfo.setNominalOutputV(String.valueOf(rating[10].getValue()) + " V");
            this.ratingInfo.setNominalOutputC(String.valueOf(MathUtils.round((double)((double)rating[11].getValue() * 0.1), (int)1)) + " A");
            this.ratingInfo.setRectifierNominalF(String.valueOf(rating[12].getValue() == 1 ? 50 : 60) + " Hz");
            Register[] rating2 = modbusHandler.readMultipleRegisters(4814, 1);
            this.ratingInfo.setInverterNominalF(String.valueOf(rating2[0].getValue() == 1 ? 50 : 60) + " Hz");
            Register[] batVBooster = modbusHandler.readMultipleRegisters(4825, 1);
            this.batteryNumber.setBatteryVBooster(this.getYesNo(batVBooster[0].getValue()));
            Register[] batNumber = modbusHandler.readMultipleRegisters(4826, 1);
            this.batteryNumber.setBatNumber(batNumber[0].getValue());
            Register[] batCapacity = modbusHandler.readMultipleRegisters(4827, 1);
            this.batteryNumber.setBatCapacity(MathUtils.round((double)((double)batCapacity[0].getValue() * 0.1), (int)1) + " Ah");
            Register[] batLifetime = modbusHandler.readMultipleRegisters(4828, 1);
            this.batteryNumber.setBatLifetime(String.valueOf(batLifetime[0].getValue()) + " Years");
            Register[] batInstalled = modbusHandler.readMultipleRegisters(4845, 1);
            this.batteryNumber.setBatteriesInstalled(this.getYesNo(batInstalled[0].getValue()));
            Register[] commonbat = modbusHandler.readMultipleRegisters(4847, 1);
            this.batteryNumber.setCommonBatteries(this.getYesNo(commonbat[0].getValue()));
        }
        catch (ModbusException e) {
            e.printStackTrace();
        }
    }

    private String getYesNo(int value) {
        if (value == 1) {
            return "NO";
        }
        return "YES";
    }

    private String getUnitType(int unittype) {
        if (unittype == 1) {
            return "1/1";
        }
        if (unittype == 2) {
            return "1/3";
        }
        if (unittype == 3) {
            return "3/1";
        }
        return "3/3";
    }

    public void queryBaseInterface() {
    }

    @Override
    public String offSwitchCtrl() throws IOException {
        return null;
    }

    @Override
    public String cancelSwitchCtrl() throws IOException {
        return null;
    }

    @Override
    public String deepBatteryTestCtrl() throws IOException, UnsupportException {
        return null;
    }

    @Override
    public Capability getCapability() throws IOException, UnsupportException {
        return this.capability;
    }

    @Override
    public String munitesBatteryTestCtrl(float arg0) throws IOException, UnsupportException {
        return null;
    }

    @Override
    public String offBuzzerCtrl() throws IOException {
        return null;
    }

    @Override
    public void offSwitchCtrl(int arg0) throws IOException {
    }

    @Override
    public String offSwitchCtrlOntime() throws IOException {
        return null;
    }

    @Override
    public String offSwitchCtrlOntime(int arg0) throws IOException {
        return null;
    }

    @Override
    public String onBuzzerCtrl() throws IOException {
        return null;
    }

    @Override
    public String tenSencondsBatteryTestCtrl() throws IOException {
        return this.excuteCommand(93, (short)1);
    }

    @Override
    public void testOperation() throws IOException {
    }

    @Override
    public String rectifierInverterCtrl(int unit) throws IOException {
        String returnData = this.excuteCommand(92, (short)unit);
        return returnData;
    }

    @Override
    public String queryQBT() throws IOException {
        return null;
    }

    @Override
    public String queryQGR() throws IOException {
        return null;
    }

    @Override
    public boolean setPBT(String value) throws IOException {
        return false;
    }

    @Override
    public boolean setPGR(String value) throws IOException {
        return false;
    }

    @Override
    public boolean isSupportBatNum() {
        return this.supportBatNum;
    }

    @Override
    public void setSupportBatNum(boolean arg0) {
        this.supportBatNum = arg0;
    }
}

