/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.processor;

import cn.com.voltronic.util.VolStr;
import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.data.bean.LineVoltage;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.monitor.processor.PMVProcessor;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.utilities.StrConvert;
import cn.com.voltronicpower.work.BatteryTestEndHandler;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;

public class PMV_SimplifyProcessor
extends PMVProcessor {
    private static final Log logger = new Log();
    private char batTestStatus = (char)50;
    Locale locale = Locale.getDefault();

    public PMV_SimplifyProcessor(CommunicateHandlerInterface handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public void queryUpsInfo() {
        try {
            String type = this._handler.excuteSimpleCommand("M");
            if ("P".equals(type)) {
                this.identity.setManufacturer("P");
            }
            if (Config.getString("Customized").equals("PowerFrame")) {
                this.identity.setMorphological("Standby");
            }
            this.identity.setIoPhase("1/1");
            this.workInfo.setIoPhase("1/1");
            this.identity.setProductSN("----");
            this.identity.setFwVersion("----");
            this.ratingInfo.setOutputRatingCurrent("----");
            this.ratingInfo.setRatedCapacity("----");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void queryRatingInfo(int info) {
        String infos = Integer.toBinaryString(info);
        int binaryNum = Integer.parseInt(infos);
        infos = String.format("%08d", binaryNum);
        if (infos.charAt(0) == '1') {
            this.ratingInfo.setOutputRatingFrequency(String.valueOf(StrConvert.toFloat("60")));
        } else {
            this.ratingInfo.setOutputRatingFrequency(String.valueOf(StrConvert.toFloat("50")));
        }
        String ratBatVol = infos.substring(1, 3);
        if ("00".equals(ratBatVol)) {
            this.ratingInfo.setBatteryVoltage(String.valueOf(StrConvert.toFloat("12")));
        } else if ("01".equals(ratBatVol)) {
            this.ratingInfo.setBatteryVoltage(String.valueOf(StrConvert.toFloat("24")));
        } else if ("02".equals(ratBatVol)) {
            this.ratingInfo.setBatteryVoltage(String.valueOf(StrConvert.toFloat("36")));
        } else {
            this.ratingInfo.setBatteryVoltage(String.valueOf(StrConvert.toFloat("48")));
        }
        String ratVol = infos.substring(5);
        if ("000".equals(ratVol)) {
            this.identity.setInputRatingVoltage(String.valueOf(StrConvert.toFloat("110")));
            this.identity.setOutputRatingVoltage(String.valueOf(StrConvert.toFloat("110")));
            this.ratingInfo.setOutputRatingVoltage(String.valueOf(StrConvert.toFloat("110")));
        } else if ("001".equals(ratVol)) {
            this.identity.setInputRatingVoltage(String.valueOf(StrConvert.toFloat("120")));
            this.identity.setOutputRatingVoltage(String.valueOf(StrConvert.toFloat("120")));
            this.ratingInfo.setOutputRatingVoltage(String.valueOf(StrConvert.toFloat("120")));
        } else if ("010".equals(ratVol)) {
            this.identity.setInputRatingVoltage(String.valueOf(StrConvert.toFloat("220")));
            this.identity.setOutputRatingVoltage(String.valueOf(StrConvert.toFloat("220")));
            this.ratingInfo.setOutputRatingVoltage(String.valueOf(StrConvert.toFloat("220")));
        } else if ("011".equals(ratVol)) {
            this.identity.setInputRatingVoltage(String.valueOf(StrConvert.toFloat("230")));
            this.identity.setOutputRatingVoltage(String.valueOf(StrConvert.toFloat("230")));
            this.ratingInfo.setOutputRatingVoltage(String.valueOf(StrConvert.toFloat("230")));
        } else {
            this.identity.setInputRatingVoltage(String.valueOf(StrConvert.toFloat("240")));
            this.identity.setOutputRatingVoltage(String.valueOf(StrConvert.toFloat("240")));
            this.ratingInfo.setOutputRatingVoltage(String.valueOf(StrConvert.toFloat("240")));
        }
    }

    private String[] handleQS() {
        String[] datas = null;
        String dataStr = this.excuteCommand("QS", true);
        if (!dataStr.isEmpty()) {
            dataStr = dataStr.substring(1);
            String str = "";
            int i = 0;
            while (i < dataStr.length()) {
                char ch = dataStr.charAt(i);
                String hexStr = Integer.toHexString(ch);
                if (hexStr.length() == 1) {
                    hexStr = "0" + hexStr;
                }
                if ("20".equals(hexStr)) {
                    hexStr = " ";
                }
                str = String.valueOf(str) + hexStr;
                ++i;
            }
            String[] strs = str.split(" ");
            datas = new String[strs.length];
            int j = 0;
            while (j < strs.length) {
                if (strs[j].contains("2800")) {
                    strs[j] = strs[j].replace("2800", "0D");
                } else if (strs[j].contains("2801")) {
                    strs[j] = strs[j].replace("2801", "11");
                } else if (strs[j].contains("2802")) {
                    strs[j] = strs[j].replace("2802", "13");
                } else if (strs[j].contains("2803")) {
                    strs[j] = strs[j].replace("2803", "0A");
                } else if (strs[j].contains("2804")) {
                    strs[j] = strs[j].replace("2804", "20");
                }
                datas[j] = strs[j];
                ++j;
            }
        }
        return datas;
    }

    @Override
    public LineVoltage getLine() {
        String ret = this.excuteCommand("GM", true);
        this.line.setLineLowVoltage((int)ret.charAt(4));
        this.line.setLineHighVoltage((int)ret.charAt(5));
        return this.line;
    }

    @Override
    public String setPLVH(int value) throws IOException {
        String ret = "";
        String command = value > 100 ? String.valueOf(value) : "0" + value;
        command = "WM 2 " + command;
        ret = this.excuteCommand(command, true);
        return ret;
    }

    @Override
    public String setPLVL(int value) throws IOException {
        String ret = "";
        String command = value > 100 ? String.valueOf(value) : "0" + value;
        command = "WM 1 " + command;
        ret = this.excuteCommand(command, true);
        return ret;
    }

    @Override
    public WorkInfo queryWorkInfo() {
        try {
            this.workInfo.setPtid("PMV");
            this.workInfo.setCurrentTime(new Date());
            this.workInfo.setDeviceId(this.getDeviceId());
            Locale.setDefault(Locale.US);
            String[] datas = this.handleQS();
            String type = this.gettype();
            int data1 = VolStr.hexStringToInteger((String)datas[datas.length - 2]);
            int info = 0;
            if ("P".equals(type)) {
                data1 = VolStr.hexStringToInteger((String)datas[datas.length - 1]);
            } else if ("T".equals(type)) {
                info = VolStr.hexStringToInteger((String)datas[datas.length - 1]);
                this.queryRatingInfo(info);
                data1 = VolStr.hexStringToInteger((String)datas[datas.length - 2]);
            }
            if ("Forza".equalsIgnoreCase(MyConstants.Customized)) {
                String upstype = type;
                try {
                    upstype = this.excuteCommand("GM", true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (upstype.startsWith("(Fz")) {
                    type = String.valueOf(type) + "GM";
                }
            } else {
                type = "PMVS";
            }
            this.workInfo.setUpsType("P");
            String status = Integer.toBinaryString(data1);
            int binaryNum = Integer.parseInt(status);
            status = String.format("%08d", binaryNum);
            if (MyConstants.Customized.equals("ZTE")) {
                status = datas[datas.length - 2];
                int data2 = VolStr.hexStringToInteger((String)datas[datas.length - 1]);
                String statusV = Integer.toBinaryString(data2);
                if (statusV.charAt(7) == '1') {
                    EventsHandler.handleEvent(this.getDeviceName(), "3008", "PMV", this.getDeviceId(), true);
                } else {
                    EventsHandler.removeEvent(this.getDeviceName(), "3008");
                }
            }
            if (status.length() < 8) {
                WorkInfo workInfo = this.workInfo;
                return workInfo;
            }
            try {
                float batteryVoltage;
                this.batTestStatus = status.charAt(5);
                if (status.charAt(4) == '1') {
                    this.workInfo.setMorphological("line-interactive");
                    this.identity.setMorphological("line-interactive");
                } else if (status.charAt(4) == '0') {
                    this.workInfo.setMorphological("on-line");
                    this.identity.setMorphological("on-line");
                }
                if (status.charAt(3) == '1') {
                    EventsHandler.handleEvent(this.getDeviceName(), "3009", "PMV", this.getDeviceId(), true);
                } else {
                    EventsHandler.removeEvent(this.getDeviceName(), "3009");
                }
                if (status.charAt(7) == '1') {
                    this.workInfo.setBuzzerCtrl(true);
                } else {
                    this.workInfo.setBuzzerCtrl(false);
                }
                String inputHighVol = datas[0].substring(0, 2);
                String inputLowVol = datas[0].substring(2, 4);
                String inputVol = this.calcVoltage(inputHighVol, inputLowVol, datas[1]);
                this.workInfo.setInputVoltage(inputVol);
                String outputHighVol = datas[2].substring(0, 2);
                String outputLowVol = datas[2].substring(2, 4);
                String outputVol = this.calcVoltage(outputHighVol, outputLowVol, datas[3]);
                this.workInfo.setOutputVoltage(outputVol);
                String loadPercent = String.format("%03d", VolStr.hexStringToInteger((String)datas[4]));
                this.workInfo.setOutputLoadPercent(loadPercent);
                String h = datas[5].substring(0, 2);
                String i = datas[5].substring(2, 4);
                String hi = String.valueOf(h) + i;
                String j = datas[6].substring(0, 2);
                String k = datas[6].substring(2, 4);
                String l = datas[6].substring(4, 6);
                String kl = String.valueOf(k) + l;
                String outFre = this.calcFrequency(hi, j, kl);
                if ((double)Float.parseFloat(outFre) > 99.9) {
                    outFre = "99.9";
                } else {
                    this.workInfo.setOutputFrequency(outFre);
                }
                this.workInfo.setOutputFrequency(outFre);
                String batVol = this.calcBatVoltage(datas[7], datas[8]);
                this.workInfo.setBatteryVoltage(batVol);
                float vBat = batteryVoltage = Float.parseFloat(batVol);
                if (batteryVoltage < 15.0f) {
                    vBat = batteryVoltage;
                } else if (batteryVoltage <= 30.0f) {
                    vBat = batteryVoltage / 2.0f;
                } else if (batteryVoltage <= 45.0f) {
                    vBat = batteryVoltage / 3.0f;
                } else if (batteryVoltage <= 60.0f) {
                    vBat = batteryVoltage / 4.0f;
                }
                this.workInfo.setTemperature("999");
                String outputVoltage = this.workInfo.getOutputVoltage();
                double intOutputVoltage = 0.0;
                try {
                    intOutputVoltage = Double.parseDouble(outputVoltage);
                }
                catch (Exception e) {
                    intOutputVoltage = 0.0;
                }
                if (intOutputVoltage < 20.0) {
                    if (status.charAt(3) == '0') {
                        this.workInfo.setWorkMode("Standby mode");
                        this.workInfo.setOutputFrequency("0");
                    }
                } else if (status.charAt(0) == '0' && status.charAt(5) == '0') {
                    this.workInfo.setWorkMode("Line mode");
                    this.isBatMod = false;
                } else if (status.charAt(0) == '0' && status.charAt(5) == '1') {
                    this.workInfo.setWorkMode("Battery test mode");
                    this.isBatMod = false;
                } else if (status.charAt(0) == '1') {
                    this.workInfo.setWorkMode("Battery mode");
                    if (!this.isBatMod) {
                        this.shutdownOnBatteryMode();
                    }
                    this.isBatMod = true;
                    float outfre = Float.parseFloat(outFre);
                    if (outfre <= 50.0f || outfre > 50.0f && outfre < 58.0f) {
                        this.workInfo.setOutputFrequency("50");
                    } else if (outfre >= 58.0f) {
                        this.workInfo.setOutputFrequency("60");
                    }
                } else if (status.charAt(3) == '1') {
                    this.workInfo.setWorkMode("Fault mode");
                    this.workInfo.setOutputFrequency("00.0");
                    this.isBatMod = false;
                }
                if (this.firstLife.equals("")) {
                    this.firstLife = this.getLife(this.port, this.ptid);
                } else {
                    this.workInfo.setBatteryLife(this.firstLife);
                }
                this.shutdownOnlowBattery(status.charAt(0) != '1', status.charAt(1) == '1');
                int batteryCapacity = this.calculateBatteryCapacity(vBat, this.workInfo.getWorkMode());
                Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
                int batCapacity = shutdown.getBatCapacity();
                if ("Battery mode".equals(this.workInfo.getWorkMode()) && batteryCapacity <= batCapacity) {
                    if (!this.isBatCap && ("InfoPower".equalsIgnoreCase(MyConstants.Customized) || "NetGuard".equalsIgnoreCase(MyConstants.Customized) || "ATMUSE".equalsIgnoreCase(MyConstants.Customized))) {
                        new Thread(){

                            @Override
                            public void run() {
                                PMV_SimplifyProcessor.this.isBatCap = true;
                                PMV_SimplifyProcessor.this.shutdownOnBatteryCapacity();
                            }
                        }.start();
                    }
                } else {
                    this.isBatCap = false;
                }
                this.workInfo.setBatteryCapacity(batteryCapacity);
                if (status.charAt(3) == '1') {
                    this.workInfo.setWorkMode("Fault mode");
                    this.workInfo.setOutputFrequency("0");
                }
                double outputV = StrConvert.toDouble(this.workInfo.getOutputVoltage());
                char utility = status.charAt(0);
                if (this.workInfo.isFirst()) {
                    if (utility == '1') {
                        EventsHandler.putEvent(this.getDeviceName(), "1001");
                    } else {
                        EventsHandler.putEvent(this.getDeviceName(), "1002");
                    }
                } else if (utility == '1') {
                    EventsHandler.removeEvent(this.getDeviceName(), "1002");
                    EventsHandler.handleEvent(this.getDeviceName(), "1001", "PMV", this.getDeviceId(), true);
                } else if (utility == '0' && outputV > 0.0) {
                    EventsHandler.removeEvent(this.getDeviceName(), "1001");
                    EventsHandler.handleEvent(this.getDeviceName(), "1002", "PMV", this.getDeviceId(), true);
                } else {
                    EventsHandler.removeEvent(this.getDeviceName(), "1001");
                }
                this.workInfo.setInputFrequency("----");
                this.workInfo.setOutputCurrent("----");
                this.workInfo.clearWarning();
                this.workInfo.addWarning("----");
                this.workInfo.setAutoReboot("----");
                this.workInfo.setConverterMode("----");
                this.workInfo.setEcomode("----");
                this.workInfo.setBypassOff("----");
                this.workInfo.setBypassNotAllowed("----");
                this.workInfo.setFaultType("----");
                this.workInfo.setP1outlet("----");
                this.workInfo.setFirst(false);
                this.workInfo.setClear(false);
            }
            catch (Exception e) {
                logger.error("====An exception has occurred: " + e.getLocalizedMessage());
                e.printStackTrace();
                this.logingCommunicateException(false);
            }
        }
        finally {
            Locale.setDefault(this.locale);
        }
        return this.workInfo;
    }

    public String gettype() {
        String str = "";
        String dataStr = this.excuteCommand("QS", true);
        if (!dataStr.isEmpty()) {
            int i = 0;
            while (i < dataStr.length()) {
                char ch = dataStr.charAt(i);
                String hexStr = Integer.toHexString(ch);
                if (hexStr.length() == 1) {
                    hexStr = "0" + hexStr;
                }
                str = String.valueOf(str) + hexStr;
                ++i;
            }
            while (str.contains("2800") || str.contains("2801") || str.contains("2802") || str.contains("2803") || str.contains("2804")) {
                if (str.contains("2800")) {
                    str = str.replace("2800", "0D");
                    continue;
                }
                if (str.contains("2801")) {
                    str = str.replace("2801", "11");
                    continue;
                }
                if (str.contains("2802")) {
                    str = str.replace("2802", "13");
                    continue;
                }
                if (str.contains("2803")) {
                    str = str.replace("2803", "0A");
                    continue;
                }
                if (!str.contains("2804")) continue;
                str = str.replace("2804", "20");
            }
        }
        String type = "";
        if (str.length() == 50) {
            type = "P";
            return "P";
        }
        if (str.length() == 52) {
            type = "T";
            return "T";
        }
        return type;
    }

    @Override
    public String queryMorphological(String status) {
        if (status.charAt(4) == '1') {
            return "line-interactive";
        }
        if (status.charAt(4) == '0') {
            return "on-line";
        }
        if (Config.getString("Customized").equals("PowerFrame")) {
            return "Standby";
        }
        return "";
    }

    @Override
    public String offBuzzerCtrl() throws IOException {
        if (this.workInfo.isBuzzerCtrl()) {
            this.excuteCommand("Q", false);
            return "(ACK";
        }
        return "(NAK";
    }

    @Override
    public String onBuzzerCtrl() throws IOException {
        if (!this.workInfo.isBuzzerCtrl()) {
            this.excuteCommand("Q", false);
            return "(ACK";
        }
        return "(NAK";
    }

    @Override
    public String tenSencondsBatteryTestCtrl() throws IOException {
        String dataStr = this.gettype();
        this.excuteCommand("T", false);
        this.calcTime();
        return "(ACK";
    }

    private void calcTime() {
        Thread t = new Thread(){

            @Override
            public void run() {
                do {
                    try {
                        Thread.sleep(9500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } while (PMV_SimplifyProcessor.this.batTestStatus == '1');
                BatteryTestEndHandler.endEvent(PMV_SimplifyProcessor.this.getDeviceName(), "PMV", PMV_SimplifyProcessor.this.getDeviceId());
            }
        };
        t.start();
    }

    private String calcVoltage(String ad, String be, String cf) {
        String result = "";
        int param1 = VolStr.hexStringToInteger((String)(String.valueOf(ad) + be));
        int param2 = VolStr.hexStringToInteger((String)cf);
        int param3 = param1 * param2 / 51;
        String value = Integer.toHexString(param3);
        int value1 = 0;
        int value2 = 0;
        float value3 = 0.0f;
        if (value.length() == 6) {
            value1 = VolStr.hexStringToInteger((String)value.substring(0, 4));
            value2 = VolStr.hexStringToInteger((String)value.substring(4, 6));
        }
        if (value.length() == 5) {
            value1 = VolStr.hexStringToInteger((String)value.substring(0, 3));
            value2 = VolStr.hexStringToInteger((String)value.substring(3, 5));
        } else if (value.length() == 4) {
            value1 = VolStr.hexStringToInteger((String)value.substring(0, 2));
            value2 = VolStr.hexStringToInteger((String)value.substring(2, 4));
        } else if (value.length() == 3) {
            value1 = VolStr.hexStringToInteger((String)("0" + value.substring(0, 1)));
            value2 = VolStr.hexStringToInteger((String)value.substring(1, 3));
        } else if (value.length() == 2) {
            value1 = VolStr.hexStringToInteger((String)"00");
            value2 = VolStr.hexStringToInteger((String)value.substring(0, 2));
        } else if (value.length() == 1) {
            value1 = VolStr.hexStringToInteger((String)"00");
            value2 = VolStr.hexStringToInteger((String)("0" + value.substring(0, 1)));
        }
        value3 = (float)value1 + (float)value2 / 256.0f;
        result = String.format("%.1f", Float.valueOf(value3));
        return result;
    }

    private String calcFrequency(String hi, String j, String kl) {
        String result = "";
        int param1 = VolStr.hexStringToInteger((String)hi);
        int param2 = VolStr.hexStringToInteger((String)(String.valueOf(j) + kl));
        float param3 = (float)param2 / (float)param1;
        result = String.format("%.1f", Float.valueOf(param3));
        return result;
    }

    private String calcBatVoltage(String m, String n) {
        String result = "";
        int param1 = VolStr.hexStringToInteger((String)m);
        int param2 = VolStr.hexStringToInteger((String)n);
        float param3 = (float)(param1 * param2) / 510.0f;
        result = String.format("%.1f", Float.valueOf(param3));
        return result;
    }
}

