/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.processor;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.data.bean.CpuInfo;
import cn.com.voltronicpower.data.bean.LedInfo;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.monitor.processor.PMV_HProcessor;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.utilities.StrConvert;
import cn.com.voltronicpower.work.BatteryTestEndHandler;
import java.io.IOException;
import java.util.Date;
import wintools.CPUInfo;

public class PMV_JProcessor
extends PMV_HProcessor {
    public PMV_JProcessor(CommunicateHandlerInterface handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public void queryUpsInfo() {
        String[] datas = null;
        String status = null;
        String dataStr = this.excuteCommand("QS", true);
        if (dataStr.isEmpty()) {
            return;
        }
        datas = dataStr.split(" ");
        status = datas[datas.length - 1];
        this.identity.setMorphological(this.queryMorphological(status));
        this.identity.setIoPhase("1/1");
        this.workInfo.setIoPhase("1/1");
        dataStr = this.excuteCommand("F", true);
        datas = dataStr.split(" ");
        String voltage = datas[0].substring(1);
        this.identity.setInputRatingVoltage(voltage);
        this.identity.setOutputRatingVoltage(voltage);
        String sn = this.excuteCommand("G", true);
        this.identity.setProductSN(sn.substring(2));
        String fwVersion = this.excuteCommand("FW?", true);
        this.identity.setFwVersion(fwVersion);
        String ble_CentralFw = this.excuteCommand("FW2?", true);
        String ble_PeripheralFw = this.excuteCommand("FW3?", true);
        this.identity.setBle_CentralFW(ble_CentralFw);
        this.identity.setBle_PeripheralFW(ble_PeripheralFw);
        this.ratingInfo.setOutputRatingVoltage(voltage);
        this.ratingInfo.setOutputRatingFrequency(datas[3]);
        this.ratingInfo.setOutputRatingCurrent(datas[1]);
        this.ratingInfo.setBatteryVoltage(datas[2]);
        String rateCapa = this.excuteCommand("I", true);
        this.ratingInfo.setRatedCapacity(rateCapa.substring(15, rateCapa.length() - 2));
    }

    @Override
    public WorkInfo queryWorkInfo() {
        try {
            this.workInfo.setPtid("PMV");
            this.workInfo.setCurrentTime(new Date());
            this.workInfo.setDeviceId(this.getDeviceId());
            this.workInfo.setUpsType("PMVJ");
            String dataStr = this.excuteCommand("QS", true);
            Thread.sleep(200L);
            if (dataStr.isEmpty()) {
                return this.workInfo;
            }
            String[] datas = dataStr.split(" ");
            String status = datas[datas.length - 1];
            if (status.length() < 8) {
                return this.workInfo;
            }
            if (status.charAt(4) == '1') {
                this.workInfo.setMorphological("line-interactive");
            } else if (status.charAt(4) == '0') {
                this.workInfo.setMorphological("on-line");
            }
            if (status.charAt(3) == '1') {
                EventsHandler.handleEvent(this.getDeviceName(), "3009", "PMV", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "3009");
            }
            if (status.charAt(7) == '1') {
                this.workInfo.setBuzzerCtrl(true);
            } else {
                this.workInfo.setBuzzerCtrl(false);
            }
            this.workInfo.setBatteryVoltage(String.valueOf(Float.parseFloat(datas[5])));
            this.workInfo.setInputVoltage(datas[0].substring(1));
            this.workInfo.setOutputVoltage(datas[2]);
            this.workInfo.setOutputLoadPercent(String.valueOf(Integer.parseInt(datas[3])));
            this.workInfo.setOutputFrequency(datas[4]);
            this.workInfo.setBatteryVoltage(datas[5]);
            this.workInfo.setTemperature(datas[6]);
            String outputVoltage = this.workInfo.getOutputVoltage();
            double intOutputVoltage = 0.0;
            try {
                intOutputVoltage = Double.parseDouble(outputVoltage);
            }
            catch (Exception e) {
                intOutputVoltage = 0.0;
            }
            if (intOutputVoltage < 20.0) {
                if (status.charAt(3) == '0') {
                    this.workInfo.setWorkMode("Standby mode");
                }
            } else if (status.charAt(0) == '0' && status.charAt(5) == '0') {
                this.workInfo.setWorkMode("Line mode");
                this.isBatMod = false;
            } else if (status.charAt(0) == '0' && status.charAt(5) == '1') {
                this.workInfo.setWorkMode("Battery test mode");
                this.isBatMod = false;
            } else if (status.charAt(0) == '1') {
                this.workInfo.setWorkMode("Battery mode");
                if (!this.isBatMod) {
                    this.shutdownOnBatteryMode();
                }
                this.isBatMod = true;
            } else if (status.charAt(3) == '1') {
                this.workInfo.setWorkMode("Fault mode");
                this.isBatMod = false;
            }
            if (this.firstLife.equals("")) {
                this.firstLife = this.getLife(this.port, this.ptid);
            } else {
                this.workInfo.setBatteryLife(this.firstLife);
            }
            this.shutdownOnlowBattery(status.charAt(0) != '1', status.charAt(1) == '1');
            String[] cmd_QI = this.excuteCommand("QI", true).substring(1).split(" ");
            this.workInfo.setBatteryCapacity(Integer.parseInt(cmd_QI[0]));
            this.workInfo.setBatteryRemainTime(Integer.parseInt(cmd_QI[1]) / 60);
            this.workInfo.setInputFrequency(cmd_QI[3]);
            this.workInfo.setOutputCurrent(String.valueOf(Double.parseDouble(cmd_QI[4]) / 10.0));
            this.workInfo.getMaps().put("Energy Star Mode", Character.valueOf(cmd_QI[7].charAt(4)));
            String[] QF_ret = this.excuteCommand("QF", true).substring(1).split(" ");
            this.workInfo.getMaps().put("pairingcode", QF_ret[3]);
            this.workInfo.getMaps().put("Bluetooth status", QF_ret[4]);
            this.workInfo.getMaps().put("Ni-Mh battery status", QF_ret[5]);
            int batteryCapacity = this.workInfo.getBatteryCapacity();
            Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
            int batCapacity = shutdown.getBatCapacity();
            logger.info("\u5b9e\u65f6batteryCapacity\uff1a" + batteryCapacity);
            logger.info("\u8bbe\u5b9a\u503cbatCapacity" + batCapacity);
            logger.info("\u5f53\u524d\u7535\u6c60\u72b6\u6001" + this.workInfo.getWorkMode());
            logger.info("isBatCap" + this.isBatCap);
            if ("Battery mode".equals(this.workInfo.getWorkMode()) && batteryCapacity <= batCapacity) {
                if (!this.isBatCap && ("InfoPower".equalsIgnoreCase(MyConstants.Customized) || "NetGuard".equalsIgnoreCase(MyConstants.Customized) || "ATMUSE".equalsIgnoreCase(MyConstants.Customized))) {
                    new Thread(){

                        @Override
                        public void run() {
                            PMV_JProcessor.this.isBatCap = true;
                            PMV_JProcessor.this.shutdownOnBatteryCapacity();
                        }
                    }.start();
                }
            } else {
                this.isBatCap = false;
            }
            if (this.lastSelfTestProgress == '1' && status.charAt(5) == '0') {
                BatteryTestEndHandler.endEvent(this.getDeviceName(), "PMV", this.getDeviceId());
            }
            this.lastSelfTestProgress = status.charAt(5);
            double outputV = StrConvert.toDouble(this.workInfo.getOutputVoltage());
            char utility = status.charAt(0);
            if (this.workInfo.isFirst()) {
                if (utility == '1') {
                    EventsHandler.putEvent(this.getDeviceName(), "1001");
                } else {
                    EventsHandler.putEvent(this.getDeviceName(), "1002");
                }
            } else if (utility == '1') {
                EventsHandler.removeEvent(this.getDeviceName(), "1002");
                EventsHandler.handleEvent(this.getDeviceName(), "1001", "PMV", this.getDeviceId(), true);
            } else if (utility == '0' && outputV > 0.0) {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
                EventsHandler.handleEvent(this.getDeviceName(), "1002", "PMV", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
            }
            if (CPUInfo.cpu == null) {
                new CPUInfo().start();
            }
            Thread.sleep(200L);
            this.workInfo.setCpuInfo(CPUInfo.cpu == null ? new CpuInfo() : CPUInfo.cpu);
            this.setCUP(this.workInfo.getCpuInfo());
            String[] leds = this.excuteCommand("QLED", true).substring(1).split(" ");
            LedInfo led = new LedInfo();
            led.setLedStatus(Integer.parseInt(leds[0]));
            led.setSpeed(Integer.parseInt(leds[1]));
            led.setEffect(Integer.parseInt(leds[2]));
            led.setBrightness(Integer.parseInt(leds[3]));
            led.setColors(Integer.parseInt(leds[4]));
            led.setInfo(this.getColor_Hex(leds[5].substring(0, 9)));
            led.setInfo2(this.getColor_Hex(leds[5].substring(9, 18)));
            led.setInfo3(this.getColor_Hex(leds[5].substring(18)));
            this.workInfo.setLedInfo(led);
            this.workInfo.setInputFrequency("----");
            this.workInfo.setOutputCurrent("----");
            this.workInfo.setAutoReboot("----");
            this.workInfo.setConverterMode("----");
            this.workInfo.setEcomode("----");
            this.workInfo.setBypassOff("----");
            this.workInfo.setBypassNotAllowed("----");
            this.workInfo.setFaultType("----");
            this.workInfo.setP1outlet("----");
            this.workInfo.setFirst(false);
            this.workInfo.setClear(false);
            this.reconnectTimes = 0;
            Thread.sleep(200L);
        }
        catch (Exception e) {
            this.workInfo.clear();
            this.logingCommunicateException(false);
            e.printStackTrace();
        }
        return this.workInfo;
    }

    private String getColor_Hex(String color) {
        String color1 = color.substring(0, 3);
        String color2 = color.substring(3, 6);
        String color3 = color.substring(6);
        String color1_2 = Integer.toHexString(Integer.parseInt(color1));
        String color2_2 = Integer.toHexString(Integer.parseInt(color2));
        String color3_2 = Integer.toHexString(Integer.parseInt(color3));
        if (color1_2.length() < 2) {
            color1_2 = "0" + color1_2;
        }
        if (color2_2.length() < 2) {
            color2_2 = "0" + color2_2;
        }
        if (color3_2.length() < 2) {
            color3_2 = "0" + color3_2;
        }
        return "#" + color1_2 + color2_2 + color3_2;
    }

    private String getColor_Dec(String color) {
        String color1 = color.substring(0, 2);
        String color2 = color.substring(2, 4);
        String color3 = color.substring(4);
        String color1_2 = String.valueOf(Integer.parseInt(color1, 16));
        String color2_2 = String.valueOf(Integer.parseInt(color2, 16));
        String color3_2 = String.valueOf(Integer.parseInt(color3, 16));
        if (color1_2.length() == 2) {
            color1_2 = "0" + color1_2;
        } else if (color1_2.length() == 1) {
            color1_2 = "00" + color1_2;
        }
        if (color2_2.length() == 2) {
            color2_2 = "0" + color2_2;
        } else if (color2_2.length() == 1) {
            color2_2 = "00" + color2_2;
        }
        if (color3_2.length() == 2) {
            color3_2 = "0" + color3_2;
        } else if (color2_2.length() == 1) {
            color3_2 = "00" + color3_2;
        }
        return String.valueOf(color1_2) + color2_2 + color3_2;
    }

    public static void main(String[] args) {
        String color = "#D44242".substring(1);
        String color1 = color.substring(0, 2);
        String color2 = color.substring(2, 4);
        String color3 = color.substring(4);
        String color1_2 = String.valueOf(Integer.parseInt(color1, 16));
        String color2_2 = String.valueOf(Integer.parseInt(color2, 16));
        String color3_2 = String.valueOf(Integer.parseInt(color3, 16));
        if (color1_2.length() == 2) {
            color1_2 = "0" + color1_2;
        } else if (color1_2.length() == 1) {
            color1_2 = "00" + color1_2;
        }
        if (color2_2.length() == 2) {
            color2_2 = "0" + color2_2;
        } else if (color2_2.length() == 1) {
            color2_2 = "00" + color2_2;
        }
        if (color3_2.length() == 2) {
            color3_2 = "0" + color3_2;
        } else if (color2_2.length() == 1) {
            color3_2 = "00" + color3_2;
        }
        System.out.println(String.valueOf(color1_2) + color2_2 + color3_2);
    }

    @Override
    public String setNewParameter(String type, String value) {
        String cmd = "";
        if (type.equals("ledStatus")) {
            cmd = "PLEDE" + value;
            System.out.println("---------------------------------------------------------------------------------------------------------------------------------" + cmd);
        } else if (type.equals("ledSpeed")) {
            cmd = "PLEDS" + value;
        } else if (type.equals("ledEffect")) {
            cmd = "PLEDM" + value;
        } else if (type.equals("ledBrightness")) {
            cmd = "PLEDB" + value;
        } else if (type.equals("ledColorsNum")) {
            cmd = "PLEDT" + value;
        } else if (type.equals("ledColor_line")) {
            cmd = "PLEDC1" + value;
        } else if (type.equals("ledColor_bat")) {
            cmd = "PLEDC3" + value;
        } else if (type.equals("ledColor_avr")) {
            cmd = "PLEDC2" + value;
        } else if (type.equals("toggleBz")) {
            cmd = "Q";
        } else if (type.equals("outputON")) {
            cmd = "TON";
        } else if (type.equals("outputOFF")) {
            cmd = "TOFF";
        } else if (type.equals("ratingOutV")) {
            cmd = "OPV" + value;
        } else if (type.equals("bluetoothPairStatus")) {
            cmd = "QF" + value;
        } else if (type.equals("bluetoothStatus")) {
            cmd = "QF" + value;
        } else if (type.equals("energyMode")) {
            cmd = "ES" + value;
        } else if (type.equals("batterystatus")) {
            cmd = "QF" + value;
        }
        return this.excuteCommand(cmd, true);
    }

    @Override
    public String offSwitchCtrl() throws IOException {
        String delayShutdownTime = this.getDelayShutdownTime();
        String command = "Sn".replace("n", delayShutdownTime);
        logger.info("S\u6307\u4ee4\u53d1\u9001\u6210\u529f" + delayShutdownTime);
        return this.excuteCommand(command, true);
    }

    @Override
    public String onSwitchCtrlOntime() {
        String cmd = "TON";
        return this.excuteCommand(cmd, true);
    }

    @Override
    public String offSwitchCtrlOntime() {
        String cmd = "TOFF";
        return this.excuteCommand(cmd, true);
    }

    @Override
    public String cancelBatteryTest() throws IOException {
        String returnData = this.excuteCommand("C", true);
        if (this.isrecord) {
            this.isrecord = false;
            this.starttime = "";
        }
        return returnData;
    }

    @Override
    public String onBuzzerCtrl() throws IOException {
        String dataStr = this.excuteCommand("Q", true);
        return dataStr;
    }

    @Override
    public String offBuzzerCtrl() throws IOException {
        String dataStr = this.excuteCommand("Q", true);
        return dataStr;
    }

    public String setSN2UPS(String sn) {
        String res = this.excuteCommand("GA" + sn, true);
        return res;
    }
}

