/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.processor;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.monitor.processor.PMV_HProcessor;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.utilities.StrConvert;
import cn.com.voltronicpower.work.BatteryTestEndHandler;
import java.util.Date;

public class PMV_IProcessor
extends PMV_HProcessor {
    public PMV_IProcessor(CommunicateHandlerInterface handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public void queryUpsInfo() {
        try {
            String[] datas = null;
            String status = null;
            String dataStr = this.excuteCommand("QS", true);
            if (dataStr.isEmpty()) {
                return;
            }
            datas = dataStr.split(" ");
            status = datas[datas.length - 1];
            this.identity.setMorphological(this.queryMorphological(status));
            this.identity.setIoPhase("1/1");
            this.workInfo.setIoPhase("1/1");
            dataStr = this.excuteCommand("F", true);
            datas = dataStr.split(" ");
            String voltage = datas[0].substring(1);
            this.identity.setInputRatingVoltage(voltage);
            this.identity.setOutputRatingVoltage(voltage);
            this.identity.setProductSN("----");
            String fwVersion = this.excuteCommand("FW?", true);
            this.identity.setFwVersion(fwVersion);
            this.ratingInfo.setOutputRatingVoltage(voltage);
            this.ratingInfo.setOutputRatingFrequency(datas[3]);
            this.ratingInfo.setOutputRatingCurrent(datas[1]);
            this.ratingInfo.setBatteryVoltage(datas[2]);
            String rateCapa = this.excuteCommand("I", true);
            this.ratingInfo.setRatedCapacity(String.valueOf(Integer.parseInt(rateCapa.split(" ")[2])));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public WorkInfo queryWorkInfo() {
        try {
            float batteryVoltage;
            this.workInfo.setPtid("PMV");
            this.workInfo.setCurrentTime(new Date());
            this.workInfo.setDeviceId(this.getDeviceId());
            this.workInfo.setUpsType("PMVI");
            String dataStr = this.excuteCommand("QS", true);
            if (dataStr.isEmpty()) {
                return this.workInfo;
            }
            String[] datas = dataStr.split(" ");
            String status = datas[datas.length - 1];
            if (status.length() < 8) {
                return this.workInfo;
            }
            if (status.charAt(4) == '1') {
                this.workInfo.setMorphological("line-interactive");
            } else if (status.charAt(4) == '0') {
                this.workInfo.setMorphological("on-line");
            }
            if (status.charAt(3) == '1') {
                EventsHandler.handleEvent(this.getDeviceName(), "3009", "PMV", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "3009");
            }
            if (status.charAt(7) == '1') {
                this.workInfo.setBuzzerCtrl(true);
            } else {
                this.workInfo.setBuzzerCtrl(false);
            }
            this.workInfo.setOutputLoadPercent(datas[3]);
            float vBat = batteryVoltage = Float.parseFloat(datas[5]);
            this.workInfo.setBatteryVoltage(String.valueOf(vBat));
            this.workInfo.setInputVoltage(datas[0].substring(1));
            this.workInfo.setOutputVoltage(datas[2]);
            this.workInfo.setOutputFrequency(datas[4]);
            this.workInfo.setOutputLoadPercent(datas[3]);
            this.workInfo.setBatteryVoltage(datas[5]);
            this.workInfo.setTemperature(datas[6]);
            String outputVoltage = this.workInfo.getOutputVoltage();
            double intOutputVoltage = 0.0;
            try {
                intOutputVoltage = Double.parseDouble(outputVoltage);
            }
            catch (Exception e) {
                intOutputVoltage = 0.0;
            }
            if (intOutputVoltage < 20.0) {
                if (status.charAt(3) == '0') {
                    this.workInfo.setWorkMode("Standby mode");
                }
            } else if (status.charAt(0) == '0' && status.charAt(5) == '0') {
                this.workInfo.setWorkMode("Line mode");
                this.isBatMod = false;
            } else if (status.charAt(0) == '0' && status.charAt(5) == '1') {
                this.workInfo.setWorkMode("Battery test mode");
                this.isBatMod = false;
            } else if (status.charAt(0) == '1') {
                this.workInfo.setWorkMode("Battery mode");
                if (!this.isBatMod) {
                    this.shutdownOnBatteryMode();
                }
                this.isBatMod = true;
            } else if (status.charAt(3) == '1') {
                this.workInfo.setWorkMode("Fault mode");
                this.isBatMod = false;
            }
            if (this.firstLife.equals("")) {
                this.firstLife = this.getLife(this.port, this.ptid);
            } else {
                this.workInfo.setBatteryLife(this.firstLife);
            }
            this.shutdownOnlowBattery(status.charAt(0) != '1', status.charAt(1) == '1');
            String[] remainAndOut = this.excuteCommand("QI", true).substring(1).split(" ");
            this.workInfo.setBatteryCapacityReal(Integer.parseInt(remainAndOut[0]));
            this.workInfo.setBatteryRemainTime(Integer.parseInt(remainAndOut[1]) / 60);
            int batteryCapacity = this.workInfo.getBatteryCapacity();
            Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
            int batCapacity = shutdown.getBatCapacity();
            if ("Battery mode".equals(this.workInfo.getWorkMode()) && batteryCapacity <= batCapacity) {
                if (!this.isBatCap && ("InfoPower".equalsIgnoreCase(MyConstants.Customized) || "NetGuard".equalsIgnoreCase(MyConstants.Customized) || "ATMUSE".equalsIgnoreCase(MyConstants.Customized))) {
                    new Thread(){

                        @Override
                        public void run() {
                            PMV_IProcessor.this.isBatCap = true;
                            PMV_IProcessor.this.shutdownOnBatteryCapacity();
                        }
                    }.start();
                }
            } else {
                this.isBatCap = false;
            }
            if (status.charAt(3) == '1') {
                this.workInfo.setWorkMode("Fault mode");
            }
            if (this.lastSelfTestProgress == '1' && status.charAt(5) == '0') {
                BatteryTestEndHandler.endEvent(this.getDeviceName(), "PMV", this.getDeviceId());
            }
            this.lastSelfTestProgress = status.charAt(5);
            double outputV = StrConvert.toDouble(this.workInfo.getOutputVoltage());
            char utility = status.charAt(0);
            if (this.workInfo.isFirst()) {
                if (utility == '1') {
                    EventsHandler.putEvent(this.getDeviceName(), "1001");
                } else {
                    EventsHandler.putEvent(this.getDeviceName(), "1002");
                }
            } else if (utility == '1') {
                EventsHandler.removeEvent(this.getDeviceName(), "1002");
                EventsHandler.handleEvent(this.getDeviceName(), "1001", "PMV", this.getDeviceId(), true);
            } else if (utility == '0' && outputV > 0.0) {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
                EventsHandler.handleEvent(this.getDeviceName(), "1002", "PMV", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
            }
            this.workInfo.setInputFrequency("----");
            this.workInfo.setOutputCurrent("----");
            this.workInfo.setAutoReboot("----");
            this.workInfo.setConverterMode("----");
            this.workInfo.setEcomode("----");
            this.workInfo.setBypassOff("----");
            this.workInfo.setBypassNotAllowed("----");
            this.workInfo.setFaultType("----");
            this.workInfo.setP1outlet("----");
            this.workInfo.setFirst(false);
            this.workInfo.setClear(false);
            this.reconnectTimes = 0;
        }
        catch (Exception e) {
            this.workInfo.clear();
            this.logingCommunicateException(false);
        }
        return this.workInfo;
    }
}

