/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.processor;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.data.bean.Capability;
import cn.com.voltronicpower.data.bean.LineVoltage;
import cn.com.voltronicpower.data.bean.PhaseAngle;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.exception.UnsupportException;
import cn.com.voltronicpower.monitor.AbstractMonitorProcessor;
import cn.com.voltronicpower.monitorcommunicate.USBHandler;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.utilities.StrConvert;
import cn.com.voltronicpower.work.BatteryTestEndHandler;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;

public class PMV_HProcessor
extends AbstractMonitorProcessor {
    protected static long curTime;
    protected static int curCapacity;

    static {
        curCapacity = 90;
    }

    public PMV_HProcessor(CommunicateHandlerInterface handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public String cancelSwitchCtrl() throws IOException {
        this.excuteCommand("C", false);
        return "(ACK";
    }

    @Override
    public String deepBatteryTestCtrl() throws IOException, UnsupportException {
        return null;
    }

    @Override
    public Capability getCapability() throws IOException, UnsupportException {
        return null;
    }

    @Override
    public String munitesBatteryTestCtrl(float minute) throws IOException, UnsupportException {
        return null;
    }

    @Override
    public String offBuzzerCtrl() throws IOException {
        String dataStr = this.excuteCommand("QS", true);
        String[] datas = dataStr.split(" ");
        String status = datas[datas.length - 1];
        if (MyConstants.Customized.equals("ZTE")) {
            status = datas[datas.length - 2];
        }
        if (status.charAt(7) == '1') {
            this.excuteCommand("Q", false);
            return "(ACK";
        }
        return "(NAK";
    }

    @Override
    public String offSwitchCtrlOntime() throws IOException {
        String command = "SnRm".replace("n", ".2").replace("m", "0000");
        this.excuteCommand(command, false);
        return "(ACK";
    }

    @Override
    public String offSwitchCtrlOntime(int minutes) throws IOException {
        minutes = minutes > 9999 ? 9999 : minutes;
        DecimalFormat df3 = new DecimalFormat("0000");
        String turnOnDelay = df3.format(minutes);
        String command = "SnRm".replace("n", ".2").replace("m", turnOnDelay);
        this.excuteCommand(command, false);
        return "(ACK";
    }

    @Override
    public String offSwitchCtrl() throws IOException {
        String delayShutdownTime = this.getDelayShutdownTime();
        String command = "SnRm".replace("n", delayShutdownTime).replace("m", "0001");
        this.excuteCommand(command, false);
        return "(ACK";
    }

    @Override
    public void offSwitchCtrl(int minutes) throws IOException {
        String delayShutdownTime = this.getDelayShutdownTime();
        minutes = minutes > 9999 ? 9999 : minutes;
        DecimalFormat df3 = new DecimalFormat("0000");
        String turnOnDelay = df3.format(minutes);
        String command = "SnRm".replace("n", delayShutdownTime).replace("m", turnOnDelay);
        this.excuteCommand(command, false);
    }

    @Override
    public String onBuzzerCtrl() throws IOException {
        String dataStr = this.excuteCommand("QS", true);
        String[] datas = dataStr.split(" ");
        String status = datas[datas.length - 1];
        if (MyConstants.Customized.equals("ZTE")) {
            status = datas[datas.length - 2];
        }
        if (status.charAt(7) == '0') {
            this.excuteCommand("Q", false);
            return "(ACK";
        }
        return "(NAK";
    }

    @Override
    public void queryUpsInfo() throws IOException {
        try {
            String[] datas = null;
            String status = null;
            String dataStr = this.excuteCommand("QS", true);
            if (dataStr.isEmpty()) {
                return;
            }
            datas = dataStr.split(" ");
            status = datas[datas.length - 1];
            this.identity.setMorphological(this.queryMorphological(status));
            this.identity.setIoPhase("1/1");
            this.workInfo.setIoPhase("1/1");
            dataStr = this.excuteCommand("F", true);
            datas = dataStr.split(" ");
            String voltage = datas[0].substring(1);
            this.identity.setInputRatingVoltage(voltage);
            this.identity.setOutputRatingVoltage(voltage);
            this.identity.setProductSN("----");
            this.identity.setFwVersion("----");
            this.ratingInfo.setOutputRatingVoltage(voltage);
            this.ratingInfo.setOutputRatingFrequency(datas[3]);
            this.ratingInfo.setOutputRatingCurrent("----");
            this.ratingInfo.setBatteryVoltage(datas[2]);
            this.ratingInfo.setRatedCapacity("----");
            try {
                String[] remainAndOut = this.excuteCommand("QI", true).substring(1).split(" ");
                if (remainAndOut[6].equals("i")) {
                    this.identity.setFwVersion(this.excuteCommand("FW?", true));
                    String[] rating = this.excuteCommand("I", true).split(" ");
                    this.ratingInfo.setRatedCapacity(rating[1]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (Config.getString("Customized").equals("PowerFrame")) {
                String retI = this.excuteCommand("I", true);
                String Morphological = "";
                String sn = "";
                if (retI.startsWith("BM Mini 850AVRLCD")) {
                    Morphological = "line-interactive";
                    sn = retI;
                } else if (retI.startsWith("BM Mini 1000AVRLCD")) {
                    Morphological = "line-interactive";
                    sn = retI;
                } else if (retI.startsWith("BM Mini 1350AVRLCD")) {
                    Morphological = "line-interactive";
                    sn = retI;
                } else if (retI.startsWith("BM Mini 1500AVRLCD")) {
                    Morphological = "line-interactive";
                    sn = retI;
                } else if (retI.startsWith("BM550LCD")) {
                    Morphological = "standby";
                    sn = retI;
                } else if (retI.startsWith("BM750LCD")) {
                    Morphological = "standby";
                    sn = retI;
                } else if (retI.startsWith("BM850LCD")) {
                    Morphological = "standby";
                    sn = retI;
                } else if (retI.startsWith("BG450")) {
                    Morphological = "standby";
                    sn = retI;
                } else if (retI.startsWith("BG550")) {
                    Morphological = "standby";
                    sn = retI;
                } else {
                    Morphological = "standby";
                    sn = "------------";
                }
                this.identity.setMorphological(Morphological);
                this.identity.setProductSN(sn);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String queryMorphological(String status) {
        if (status.charAt(4) == '1') {
            return "line-interactive";
        }
        if (status.charAt(4) == '0') {
            return "on-line";
        }
        if (Config.getString("Customized").equals("PowerFrame")) {
            return "Standby";
        }
        return "";
    }

    @Override
    public LineVoltage getLine() {
        String[] ret = this.excuteCommand("QI", true).substring(1).split(" ");
        this.line.setLineLowVoltage(Integer.parseInt(ret[4]));
        this.line.setLineHighVoltage(Integer.parseInt(ret[5]));
        return this.line;
    }

    private void setWarningStatus(String warnStatus) {
        this.workInfo.clearWarning();
        this.refreshWarningStatus(warnStatus, 0, "5002");
        this.refreshWarningStatus(warnStatus, 1, "3049");
    }

    @Override
    public final void refreshWarningStatus(String warnStatus, int index, String eventCode) {
        if (warnStatus.charAt(index) == '1') {
            EventsHandler.handleEvent(this.getDeviceName(), eventCode, "P01", this.getDeviceId(), true);
            this.workInfo.addWarning("a" + index);
        } else {
            EventsHandler.removeEvent(this.getDeviceName(), eventCode);
        }
    }

    @Override
    public WorkInfo queryWorkInfo() {
        try {
            float batteryVoltage;
            this.workInfo.setPtid("PMV");
            this.workInfo.setUpsType("PMVH");
            this.workInfo.setCurrentTime(new Date());
            this.workInfo.setDeviceId(this.getDeviceId());
            String dataStr = this.excuteCommand("QS", true);
            if (this.wrongFormat("QS", dataStr)) {
                return this.workInfo;
            }
            if (dataStr.isEmpty()) {
                return this.workInfo;
            }
            if (this.wrongFormat("QS", dataStr)) {
                return this.workInfo;
            }
            try {
                String qi_ret = this.excuteCommand("QI", true);
                String[] remainAndOut = qi_ret.substring(1).split(" ");
                this.workInfo.setBatteryCapacityReal(Integer.parseInt(remainAndOut[0]));
                this.workInfo.setBatteryRemainTime(Integer.parseInt(remainAndOut[1]) / 60);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            String[] datas = dataStr.split(" ");
            String status = datas[datas.length - 1];
            if (status.length() < 8) {
                return this.workInfo;
            }
            if (status.charAt(4) == '1') {
                this.workInfo.setMorphological("line-interactive");
            } else if (status.charAt(4) == '0') {
                this.workInfo.setMorphological("on-line");
            }
            if (status.charAt(3) == '1') {
                EventsHandler.handleEvent(this.getDeviceName(), "3009", "PMV", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "3009");
            }
            if (status.charAt(7) == '1') {
                this.workInfo.setBuzzerCtrl(true);
            } else {
                this.workInfo.setBuzzerCtrl(false);
            }
            this.workInfo.setOutputLoadPercent(datas[3]);
            float vBat = batteryVoltage = Float.parseFloat(datas[5]);
            this.workInfo.setBatteryVoltage(String.valueOf(vBat));
            this.workInfo.setInputVoltage(datas[0].substring(1));
            this.workInfo.setOutputVoltage(datas[2]);
            this.workInfo.setOutputFrequency(datas[4]);
            this.workInfo.setTemperature("999");
            String outputVoltage = this.workInfo.getOutputVoltage();
            double intOutputVoltage = 0.0;
            try {
                intOutputVoltage = Double.parseDouble(outputVoltage);
            }
            catch (Exception e) {
                intOutputVoltage = 0.0;
            }
            if (intOutputVoltage < 20.0) {
                if (status.charAt(3) == '0') {
                    this.workInfo.setWorkMode("Standby mode");
                }
            } else if (status.charAt(0) == '0' && status.charAt(5) == '0') {
                this.workInfo.setWorkMode("Line mode");
                this.isBatMod = false;
            } else if (status.charAt(0) == '0' && status.charAt(5) == '1') {
                this.workInfo.setWorkMode("Battery test mode");
                this.isBatMod = false;
            } else if (status.charAt(0) == '1') {
                this.workInfo.setWorkMode("Battery mode");
                if (!this.isBatMod) {
                    this.shutdownOnBatteryMode();
                }
                this.isBatMod = true;
            } else if (status.charAt(3) == '1') {
                this.workInfo.setWorkMode("Fault mode");
                this.isBatMod = false;
            }
            if (this.firstLife.equals("")) {
                this.firstLife = this.getLife(this.port, this.ptid);
            } else {
                this.workInfo.setBatteryLife(this.firstLife);
            }
            this.shutdownOnlowBattery(status.charAt(0) != '1', status.charAt(1) == '1');
            int batteryCapacity = this.workInfo.getBatteryCapacity();
            Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
            int batCapacity = shutdown.getBatCapacity();
            if ("Battery mode".equals(this.workInfo.getWorkMode()) && batteryCapacity <= batCapacity) {
                if (!this.isBatCap && ("InfoPower".equalsIgnoreCase(MyConstants.Customized) || "NetGuard".equalsIgnoreCase(MyConstants.Customized) || "ATMUSE".equalsIgnoreCase(MyConstants.Customized))) {
                    new Thread(){

                        @Override
                        public void run() {
                            PMV_HProcessor.this.isBatCap = true;
                            PMV_HProcessor.this.shutdownOnBatteryCapacity();
                        }
                    }.start();
                }
            } else {
                this.isBatCap = false;
            }
            if (status.charAt(3) == '1') {
                this.workInfo.setWorkMode("Fault mode");
            }
            if (this.lastSelfTestProgress == '1' && status.charAt(5) == '0') {
                BatteryTestEndHandler.endEvent(this.getDeviceName(), "PMV", this.getDeviceId());
            }
            this.lastSelfTestProgress = status.charAt(5);
            double outputV = StrConvert.toDouble(this.workInfo.getOutputVoltage());
            char utility = status.charAt(0);
            if (this.workInfo.isFirst()) {
                if (utility == '1') {
                    EventsHandler.putEvent(this.getDeviceName(), "1001");
                } else {
                    EventsHandler.putEvent(this.getDeviceName(), "1002");
                }
            } else if (utility == '1') {
                EventsHandler.removeEvent(this.getDeviceName(), "1002");
                EventsHandler.handleEvent(this.getDeviceName(), "1001", "PMV", this.getDeviceId(), true);
            } else if (utility == '0' && outputV > 0.0) {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
                EventsHandler.handleEvent(this.getDeviceName(), "1002", "PMV", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
            }
            this.workInfo.setInputFrequency("----");
            this.workInfo.setOutputCurrent("----");
            this.workInfo.setAutoReboot("----");
            this.workInfo.setConverterMode("----");
            this.workInfo.setEcomode("----");
            this.workInfo.setBypassOff("----");
            this.workInfo.setBypassNotAllowed("----");
            this.workInfo.setFaultType("----");
            this.workInfo.setP1outlet("----");
            this.workInfo.setFirst(false);
            this.workInfo.setClear(false);
            this.reconnectTimes = 0;
        }
        catch (Exception e) {
            if (!(this._handler instanceof USBHandler)) {
                this.workInfo.clear();
            }
            this.logingCommunicateException(false);
        }
        return this.workInfo;
    }

    private String handleByte(String command) {
        String datas = "";
        String datas2 = "";
        String dataStr = this.excuteCommand(command, true);
        if (!dataStr.isEmpty()) {
            dataStr = dataStr.substring(1);
            int i = 0;
            while (i < dataStr.length()) {
                char ch = dataStr.charAt(i);
                String hexStr = Integer.toHexString(ch);
                if (ch < '\u0010') {
                    hexStr = "0" + hexStr;
                }
                datas = i != dataStr.length() - 1 ? String.valueOf(datas) + hexStr + " " : String.valueOf(datas) + hexStr;
                ++i;
            }
            datas = datas.replace("28 00", "0D").replace("28 01", "11").replace("28 02", "13").replace("28 03", "0A").replace("28 04", "20");
            String[] mydata = datas.split(" ");
            int i2 = 0;
            while (i2 < mydata.length) {
                int ch = Integer.parseInt(mydata[i2], 16);
                datas2 = i2 != dataStr.length() - 1 ? String.valueOf(datas2) + ch + " " : String.valueOf(datas2) + ch;
                ++i2;
            }
        }
        return datas2;
    }

    protected int calculateBatteryCapacity(float vBat, String workMode) {
        if (workMode.equals("Line mode") || workMode.equals("Standby mode")) {
            if ((double)vBat < 11.6) {
                return 0;
            }
            if ((double)vBat >= 13.5) {
                return 100;
            }
            if ((double)vBat >= 13.3) {
                if (curCapacity >= 100) {
                    return 100;
                }
                if (curTime > 0L) {
                    long tempTime = System.currentTimeMillis();
                    if (tempTime - curTime >= 720000L) {
                        curTime = tempTime;
                        return ++curCapacity;
                    }
                    return curCapacity;
                }
                curTime = System.currentTimeMillis();
                return curCapacity;
            }
            int batteryCapacity = (int)(90.0 * ((double)vBat - 11.6) / 1.7);
            return batteryCapacity;
        }
        if (workMode.equals("Battery mode") || workMode.equals("Battery test mode")) {
            curCapacity = 90;
            curTime = 0L;
            int load = 0;
            try {
                load = Integer.parseInt(this.workInfo.getOutputLoadPercent());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (load < 20) {
                if ((double)vBat > 13.2) {
                    return 100;
                }
                if ((double)vBat > 10.2) {
                    int batteryCapacity = (int)(100.0 * ((double)vBat - 10.2) / 3.0);
                    return batteryCapacity;
                }
                return 0;
            }
            if ((double)vBat > 12.7) {
                return 100;
            }
            if ((double)vBat > 10.2) {
                int batteryCapacity = (int)(100.0 * ((double)vBat - 10.2) / 2.5);
                return batteryCapacity;
            }
        }
        return 0;
    }

    @Override
    public String tenSencondsBatteryTestCtrl() throws IOException {
        this.excuteCommand("T", false);
        this.calcTime();
        return "(ACK";
    }

    private void calcTime() {
        Thread t = new Thread(){

            @Override
            public void run() {
                String status = "";
                do {
                    String dataStr = PMV_HProcessor.this.excuteCommand("QS", true);
                    String[] datas = dataStr.split(" ");
                    status = datas[datas.length - 1];
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } while (status.charAt(5) == '1');
                BatteryTestEndHandler.endEvent(PMV_HProcessor.this.getDeviceName(), "PMV", PMV_HProcessor.this.getDeviceId());
            }
        };
        t.start();
    }

    @Override
    public PhaseAngle getPPD() throws IOException {
        return null;
    }

    @Override
    public void testOperation() throws IOException {
    }

    @Override
    public String queryQBT() throws IOException {
        return null;
    }

    @Override
    public String queryQGR() throws IOException {
        return null;
    }

    @Override
    public boolean setPBT(String value) throws IOException {
        return false;
    }

    @Override
    public boolean setPGR(String value) throws IOException {
        return false;
    }

    @Override
    public boolean isSupportBatNum() {
        return this.supportBatNum;
    }

    @Override
    public void setSupportBatNum(boolean arg0) {
        this.supportBatNum = arg0;
    }

    @Override
    public String offSwitchCtrl(String minues) throws IOException {
        String delayShutdownTime = minues;
        String command = "SnRm".replace("n", delayShutdownTime).replace("m", "0001");
        return this.excuteCommand(command, true);
    }

    public String toHex(int x) {
        String s = Integer.toHexString(x);
        if (x < 16) {
            s = "0" + s;
        }
        return s;
    }
}

