/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.processor;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.data.bean.Capability;
import cn.com.voltronicpower.data.bean.LineVoltage;
import cn.com.voltronicpower.data.bean.PhaseAngle;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.exception.UnsupportException;
import cn.com.voltronicpower.monitor.AbstractMonitorProcessor;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.utilities.StrConvert;
import cn.com.voltronicpower.work.BatteryTestEndHandler;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;

public class PMVProcessor
extends AbstractMonitorProcessor {
    protected static long curTime;
    protected static int curCapacity;
    protected int capatemp = 0;

    static {
        curCapacity = 90;
    }

    public PMVProcessor(CommunicateHandlerInterface handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public String cancelSwitchCtrl() throws IOException {
        this.excuteCommand("C", false);
        return "(ACK";
    }

    @Override
    public String deepBatteryTestCtrl() throws IOException, UnsupportException {
        return null;
    }

    @Override
    public Capability getCapability() throws IOException, UnsupportException {
        return null;
    }

    @Override
    public String munitesBatteryTestCtrl(float minute) throws IOException, UnsupportException {
        return null;
    }

    @Override
    public String offBuzzerCtrl() throws IOException {
        String dataStr = this.excuteCommand("QS", true);
        String[] datas = dataStr.split(" ");
        String status = datas[datas.length - 1];
        if (MyConstants.Customized.equals("ZTE")) {
            status = datas[datas.length - 2];
        }
        if (status.charAt(7) == '1') {
            this.excuteCommand("Q", false);
            return "(ACK";
        }
        return "(NAK";
    }

    @Override
    public String offSwitchCtrlOntime() throws IOException {
        String command = "SnRm".replace("n", ".2").replace("m", "0000");
        this.excuteCommand(command, false);
        return "(ACK";
    }

    @Override
    public String offSwitchCtrlOntime(int minutes) throws IOException {
        minutes = minutes > 9999 ? 9999 : minutes;
        DecimalFormat df3 = new DecimalFormat("0000");
        String turnOnDelay = df3.format(minutes);
        String command = "SnRm".replace("n", ".2").replace("m", turnOnDelay);
        this.excuteCommand(command, false);
        return "(ACK";
    }

    @Override
    public String offSwitchCtrl() throws IOException {
        String delayShutdownTime = this.getDelayShutdownTime();
        String command = "SnRm".replace("n", delayShutdownTime).replace("m", "0001");
        this.excuteCommand(command, false);
        return "(ACK";
    }

    @Override
    public void offSwitchCtrl(int minutes) throws IOException {
        String delayShutdownTime = this.getDelayShutdownTime();
        minutes = minutes > 9999 ? 9999 : minutes;
        DecimalFormat df3 = new DecimalFormat("0000");
        String turnOnDelay = df3.format(minutes);
        String command = "SnRm".replace("n", delayShutdownTime).replace("m", turnOnDelay);
        this.excuteCommand(command, false);
    }

    @Override
    public String onBuzzerCtrl() throws IOException {
        String dataStr = this.excuteCommand("QS", true);
        String[] datas = dataStr.split(" ");
        String status = datas[datas.length - 1];
        if (MyConstants.Customized.equals("ZTE")) {
            status = datas[datas.length - 2];
        }
        if (status.charAt(7) == '0') {
            this.excuteCommand("Q", false);
            return "(ACK";
        }
        return "(NAK";
    }

    @Override
    public void queryUpsInfo() {
        try {
            String[] datas;
            block12: {
                datas = null;
                String status = null;
                String dataStr = this.excuteCommand("QS", true);
                if (dataStr.isEmpty()) {
                    return;
                }
                datas = dataStr.split(" ");
                status = datas[datas.length - 1];
                if (MyConstants.Customized.equals("ZTE")) {
                    status = datas[datas.length - 2];
                }
                this.identity.setIoPhase("1/1");
                this.workInfo.setIoPhase("1/1");
                dataStr = this.excuteCommand("F", true);
                datas = dataStr.split(" ");
                String sn = "";
                try {
                    try {
                        sn = this.excuteCommand("QID", true);
                        if (this.str2Hex(sn).equals("2815")) {
                            sn = "(NAK";
                        }
                        sn = "(NAK".equals(sn) ? "----" : (!"".equals(sn.trim()) ? sn.substring(1) : "----");
                    }
                    catch (Exception exception) {
                        this.identity.setProductSN(sn);
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    this.identity.setProductSN(sn);
                    throw throwable;
                }
                this.identity.setProductSN(sn);
            }
            if (Config.getString("Customized").equals("PowerFrame")) {
                this.identity.setMorphological("Standby");
                if (!datas[1].equals("003") && !datas[1].equals("004")) {
                    this.identity.setMorphological("line-interactive");
                }
            }
            String voltage = datas[0].substring(1);
            this.identity.setInputRatingVoltage(voltage);
            this.identity.setOutputRatingVoltage(voltage);
            this.identity.setFwVersion("----");
            this.ratingInfo.setOutputRatingVoltage(voltage);
            this.ratingInfo.setOutputRatingFrequency(datas[3]);
            this.ratingInfo.setOutputRatingCurrent("----");
            this.ratingInfo.setBatteryVoltage(datas[2]);
            this.ratingInfo.setRatedCapacity("----");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String queryMorphological(String status) {
        if (status.charAt(4) == '1') {
            return "line-interactive";
        }
        if (status.charAt(4) == '0') {
            return "on-line";
        }
        if (Config.getString("Customized").equals("PowerFrame")) {
            return "Standby";
        }
        return "";
    }

    @Override
    public LineVoltage getLine() {
        String ret = this.excuteCommand("GM", true);
        this.line.setLineLowVoltage((int)ret.charAt(4));
        this.line.setLineHighVoltage((int)ret.charAt(5));
        return this.line;
    }

    @Override
    public String setPLVH(int value) throws IOException {
        String ret = "";
        String command = value > 100 ? String.valueOf(value) : "0" + value;
        command = "WM 2 " + command;
        ret = this.excuteCommand(command, true);
        return ret;
    }

    @Override
    public String setPLVL(int value) throws IOException {
        String ret = "";
        String command = value > 100 ? String.valueOf(value) : "0" + value;
        command = "WM 1 " + command;
        ret = this.excuteCommand(command, true);
        return ret;
    }

    @Override
    public WorkInfo queryWorkInfo() {
        try {
            float batteryVoltage;
            this.workInfo.setPtid("PMV");
            this.workInfo.setCurrentTime(new Date());
            this.workInfo.setDeviceId(this.getDeviceId());
            String type = "";
            try {
                type = this.excuteCommand("GM", true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (type.startsWith("(Fz")) {
                this.workInfo.setUpsType("VGM");
            } else {
                this.workInfo.setUpsType("PMV");
            }
            String dataStr = this.excuteCommand("QS", true);
            if (dataStr.isEmpty()) {
                return this.workInfo;
            }
            String[] datas = dataStr.split(" ");
            String status = datas[datas.length - 1];
            if (MyConstants.Customized.equals("ZTE")) {
                status = datas[datas.length - 2];
                String statusV = datas[datas.length - 1];
                if (statusV.charAt(7) == '1') {
                    EventsHandler.handleEvent(this.getDeviceName(), "3008", "PMV", this.getDeviceId(), true);
                } else {
                    EventsHandler.removeEvent(this.getDeviceName(), "3008");
                }
            }
            if (status.length() < 8) {
                return this.workInfo;
            }
            if (status.charAt(4) == '1') {
                this.workInfo.setMorphological("line-interactive");
            } else if (status.charAt(4) == '0') {
                this.workInfo.setMorphological("on-line");
            }
            if (status.charAt(3) == '1') {
                EventsHandler.handleEvent(this.getDeviceName(), "3009", "PMV", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "3009");
            }
            if (status.charAt(7) == '1') {
                this.workInfo.setBuzzerCtrl(true);
            } else {
                this.workInfo.setBuzzerCtrl(false);
            }
            this.workInfo.setOutputLoadPercent(datas[3]);
            this.workInfo.setBatteryVoltage(datas[5]);
            float vBat = batteryVoltage = Float.parseFloat(datas[5]);
            if (batteryVoltage < 15.0f) {
                vBat = batteryVoltage;
            } else if (batteryVoltage <= 30.0f) {
                vBat = batteryVoltage / 2.0f;
            } else if (batteryVoltage <= 45.0f) {
                vBat = batteryVoltage / 3.0f;
            } else if (batteryVoltage <= 60.0f) {
                vBat = batteryVoltage / 4.0f;
            }
            this.workInfo.setInputVoltage(datas[0].substring(1));
            this.workInfo.setOutputVoltage(datas[2]);
            this.workInfo.setOutputFrequency(datas[4]);
            this.workInfo.setTemperature("999");
            String outputVoltage = this.workInfo.getOutputVoltage();
            double intOutputVoltage = 0.0;
            try {
                intOutputVoltage = Double.parseDouble(outputVoltage);
            }
            catch (Exception e) {
                intOutputVoltage = 0.0;
            }
            if (intOutputVoltage < 20.0) {
                if (status.charAt(3) == '0') {
                    this.workInfo.setWorkMode("Standby mode");
                }
            } else if (status.charAt(0) == '0' && status.charAt(5) == '0') {
                this.workInfo.setWorkMode("Line mode");
                this.isBatMod = false;
            } else if (status.charAt(0) == '0' && status.charAt(5) == '1') {
                this.workInfo.setWorkMode("Battery test mode");
                this.isBatMod = false;
            } else if (status.charAt(0) == '1') {
                this.workInfo.setWorkMode("Battery mode");
                if (!this.isBatMod) {
                    this.shutdownOnBatteryMode();
                }
                this.isBatMod = true;
            } else if (status.charAt(3) == '1') {
                this.workInfo.setWorkMode("Fault mode");
                this.isBatMod = false;
            }
            if (this.firstLife.equals("")) {
                this.firstLife = this.getLife(this.port, this.ptid);
            } else {
                this.workInfo.setBatteryLife(this.firstLife);
            }
            this.shutdownOnlowBattery(status.charAt(0) != '1', status.charAt(1) == '1');
            int batteryCapacity = this.calculateBatteryCapacity(vBat, this.workInfo.getWorkMode());
            Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
            int batCapacity = shutdown.getBatCapacity();
            if ("Battery mode".equals(this.workInfo.getWorkMode()) && batteryCapacity <= batCapacity) {
                if (!this.isBatCap && ("InfoPower".equalsIgnoreCase(MyConstants.Customized) || "NetGuard".equalsIgnoreCase(MyConstants.Customized) || "ATMUSE".equalsIgnoreCase(MyConstants.Customized))) {
                    new Thread(){

                        @Override
                        public void run() {
                            PMVProcessor.this.isBatCap = true;
                            PMVProcessor.this.shutdownOnBatteryCapacity();
                        }
                    }.start();
                }
            } else {
                this.isBatCap = false;
            }
            if (Config.getString("Customized").equals("Forza")) {
                int i;
                int batCapa2 = Integer.parseInt(this.excuteCommand("BT?", true).substring(1));
                int retBL = 0;
                if (batCapa2 > 10800) {
                    int i2 = 0;
                    while (i2 < 20) {
                        this.workInfo.setBatteryCapacity(0);
                        ++i2;
                    }
                } else {
                    String batCapa = this.excuteCommand("BL?", true);
                    if (batCapa.equals("---")) {
                        i = 0;
                        while (i < 20) {
                            this.workInfo.setBatteryCapacity(batteryCapacity);
                            ++i;
                        }
                    } else {
                        int i3;
                        int cap;
                        retBL = cap = Integer.parseInt(batCapa);
                        if (cap > 100) {
                            i3 = 0;
                            while (i3 < 20) {
                                this.workInfo.setBatteryCapacity(100);
                                ++i3;
                            }
                        } else {
                            i3 = 0;
                            while (i3 < 20) {
                                this.workInfo.setBatteryCapacity(cap);
                                ++i3;
                            }
                        }
                    }
                }
                if (this.workInfo.getWorkMode().equals("Standby mode") || this.workInfo.getWorkMode().equals("Line mode")) {
                    int maxCapa = 0;
                    maxCapa = Double.parseDouble(this.workInfo.getBatteryVoltage()) > 27.0 ? 100 : (Double.parseDouble(this.workInfo.getBatteryVoltage()) <= 27.0 && Double.parseDouble(this.workInfo.getBatteryVoltage()) > 26.0 ? (this.workInfo.getBatteryCapacity() > 99 ? 99 : (this.workInfo.getBatteryCapacity() < 75 ? 75 : this.workInfo.getBatteryCapacity())) : (Double.parseDouble(this.workInfo.getBatteryVoltage()) <= 26.0 && Double.parseDouble(this.workInfo.getBatteryVoltage()) > 24.0 ? (this.workInfo.getBatteryCapacity() > 74 ? 74 : (this.workInfo.getBatteryCapacity() < 50 ? 50 : this.workInfo.getBatteryCapacity())) : (Double.parseDouble(this.workInfo.getBatteryVoltage()) <= 24.0 && Double.parseDouble(this.workInfo.getBatteryVoltage()) > 23.0 ? (this.workInfo.getBatteryCapacity() > 49 ? 49 : (this.workInfo.getBatteryCapacity() < 25 ? 25 : this.workInfo.getBatteryCapacity())) : (Double.parseDouble(this.workInfo.getBatteryVoltage()) <= 23.0 ? (this.workInfo.getBatteryCapacity() > 24 ? 24 : (this.workInfo.getBatteryCapacity() <= 0 ? 0 : this.workInfo.getBatteryCapacity())) : this.workInfo.getBatteryCapacity()))));
                    i = 0;
                    while (i < 20) {
                        this.workInfo.setBatteryCapacity(maxCapa);
                        ++i;
                    }
                }
                if (this.workInfo.getWorkMode().equals("Battery mode") && batCapa2 < 80 && retBL > 9) {
                    if (this.capatemp == 0) {
                        this.capatemp = 30;
                        if (retBL < 30) {
                            this.capatemp = retBL;
                        }
                    }
                    int i4 = 0;
                    while (i4 < 20) {
                        this.workInfo.setBatteryCapacity(this.capatemp);
                        ++i4;
                    }
                    if (this.capatemp > 14) {
                        this.capatemp -= 5;
                    } else if (this.capatemp > 9) {
                        --this.capatemp;
                    }
                }
            } else {
                this.workInfo.setBatteryCapacity(batteryCapacity);
            }
            if (status.charAt(3) == '1') {
                this.workInfo.setWorkMode("Fault mode");
            }
            if (this.lastSelfTestProgress == '1' && status.charAt(5) == '0') {
                BatteryTestEndHandler.endEvent(this.getDeviceName(), "PMV", this.getDeviceId());
            }
            this.lastSelfTestProgress = status.charAt(5);
            double outputV = StrConvert.toDouble(this.workInfo.getOutputVoltage());
            char utility = status.charAt(0);
            if (this.workInfo.isFirst()) {
                if (utility == '1') {
                    EventsHandler.putEvent(this.getDeviceName(), "1001");
                } else {
                    EventsHandler.putEvent(this.getDeviceName(), "1002");
                }
            } else if (utility == '1') {
                EventsHandler.removeEvent(this.getDeviceName(), "1002");
                EventsHandler.handleEvent(this.getDeviceName(), "1001", "PMV", this.getDeviceId(), true);
            } else if (utility == '0' && outputV > 0.0) {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
                EventsHandler.handleEvent(this.getDeviceName(), "1002", "PMV", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
            }
            try {
                String warningstatus = this.excuteCommand("QWS", true).substring(1);
                if (!warningstatus.equals("OK")) {
                    System.out.println("warningstatus:" + warningstatus);
                    this.refreshWarning(warningstatus, this.getDeviceId());
                }
                String flutstatus = this.excuteCommand("QFS", true).substring(1);
                if (!warningstatus.equals("OK")) {
                    System.out.println("flutstatus:" + flutstatus);
                    this.refreshfault(flutstatus, this.getDeviceId());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.workInfo.setInputFrequency("----");
            this.workInfo.setOutputCurrent("----");
            this.workInfo.clearWarning();
            this.workInfo.addWarning("----");
            this.workInfo.setAutoReboot("----");
            this.workInfo.setConverterMode("----");
            this.workInfo.setEcomode("----");
            this.workInfo.setBypassOff("----");
            this.workInfo.setBypassNotAllowed("----");
            this.workInfo.setFaultType("----");
            this.workInfo.setP1outlet("----");
            this.workInfo.setFirst(false);
            this.workInfo.setClear(false);
        }
        catch (Exception e) {
            this.workInfo.clear();
            this.logingCommunicateException(false);
        }
        return this.workInfo;
    }

    public void refreshWarning(String status, String sn) {
        this.refreshWarningStatus(status, 0, "4006", sn);
        this.refreshWarningStatus(status, 0, "3537", sn);
        this.refreshWarningStatus(status, 0, "5002", sn);
        this.refreshWarningStatus(status, 0, "3008", sn);
    }

    public void refreshfault(String status, String sn) {
        if (status.equals("01")) {
            this.refreshfalut(status, 0, "4107", sn);
        } else if (status.equals("02")) {
            this.refreshfalut(status, 0, "4108", sn);
        } else if (status.equals("03")) {
            this.refreshfalut(status, 0, "5003", sn);
        } else if (status.equals("04")) {
            this.refreshfalut(status, 0, "3044", sn);
        } else if (status.equals("05")) {
            this.refreshfalut(status, 0, "3030", sn);
        } else if (status.equals("06")) {
            this.refreshfalut(status, 0, "3812", sn);
        } else if (status.equals("07")) {
            this.refreshfalut(status, 0, "3028", sn);
        } else if (status.equals("08")) {
            this.refreshfalut(status, 0, "3029", sn);
        }
        this.refreshWarningStatus(status, 0, "4006", sn);
        this.refreshWarningStatus(status, 0, "3537", sn);
        this.refreshWarningStatus(status, 0, "5002", sn);
        this.refreshWarningStatus(status, 0, "3008", sn);
    }

    private final void refreshWarningStatus(String warnStatus, int index, String eventCode, String sn) {
        if (warnStatus.charAt(index) == '1') {
            EventsHandler.handleEvent(this.getDeviceName(), eventCode, this._protocol.getProtocolID(), this.getDeviceId(), true);
            this.workInfo.addWarning("a" + index);
        } else {
            EventsHandler.removeEvent(this.getDeviceName(), eventCode);
        }
    }

    private final void refreshfalut(String warnStatus, int index, String eventCode, String sn) {
        EventsHandler.handleEvent(this.getDeviceName(), eventCode, this._protocol.getProtocolID(), this.getDeviceId(), true);
    }

    protected int calculateBatteryCapacity(float vBat, String workMode) {
        if (workMode.equals("Line mode") || workMode.equals("Standby mode")) {
            if ((double)vBat < 11.6) {
                return 0;
            }
            if ((double)vBat >= 13.5) {
                return 100;
            }
            if ((double)vBat >= 13.3) {
                if (curCapacity >= 100) {
                    return 100;
                }
                if (curTime > 0L) {
                    long tempTime = System.currentTimeMillis();
                    if (tempTime - curTime >= 720000L) {
                        curTime = tempTime;
                        return ++curCapacity;
                    }
                    return curCapacity;
                }
                curTime = System.currentTimeMillis();
                return curCapacity;
            }
            int batteryCapacity = (int)(90.0 * ((double)vBat - 11.6) / 1.7);
            return batteryCapacity;
        }
        if (workMode.equals("Battery mode") || workMode.equals("Battery test mode")) {
            curCapacity = 90;
            curTime = 0L;
            int load = 0;
            try {
                load = Integer.parseInt(this.workInfo.getOutputLoadPercent());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (load < 20) {
                if ((double)vBat > 13.2) {
                    return 100;
                }
                if ((double)vBat > 10.2) {
                    int batteryCapacity = (int)(100.0 * ((double)vBat - 10.2) / 3.0);
                    return batteryCapacity;
                }
                return 0;
            }
            if ((double)vBat > 12.7) {
                return 100;
            }
            if ((double)vBat > 10.2) {
                int batteryCapacity = (int)(100.0 * ((double)vBat - 10.2) / 2.5);
                return batteryCapacity;
            }
        }
        return 0;
    }

    @Override
    public String tenSencondsBatteryTestCtrl() throws IOException {
        this.excuteCommand("T", false);
        this.calcTime();
        return "(ACK";
    }

    private void calcTime() {
        Thread t = new Thread(){

            @Override
            public void run() {
                String status = "";
                do {
                    String dataStr = PMVProcessor.this.excuteCommand("QS", true);
                    String[] datas = dataStr.split(" ");
                    status = datas[datas.length - 1];
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } while (status.charAt(5) == '1');
                BatteryTestEndHandler.endEvent(PMVProcessor.this.getDeviceName(), "PMV", PMVProcessor.this.getDeviceId());
            }
        };
        t.start();
    }

    @Override
    public PhaseAngle getPPD() throws IOException {
        return null;
    }

    @Override
    public void testOperation() throws IOException {
    }

    @Override
    public String queryQBT() throws IOException {
        return null;
    }

    @Override
    public String queryQGR() throws IOException {
        return null;
    }

    @Override
    public boolean setPBT(String value) throws IOException {
        return false;
    }

    @Override
    public boolean setPGR(String value) throws IOException {
        return false;
    }

    @Override
    public boolean isSupportBatNum() {
        return this.supportBatNum;
    }

    @Override
    public void setSupportBatNum(boolean arg0) {
        this.supportBatNum = arg0;
    }

    @Override
    public String offSwitchCtrl(String minues) throws IOException {
        String delayShutdownTime = minues;
        String command = "SnRm".replace("n", delayShutdownTime).replace("m", "0001");
        return this.excuteCommand(command, true);
    }
}

