/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.processor;

import cn.com.voltronic.util.MathUtils;
import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.data.bean.Capability;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.exception.UnsupportException;
import cn.com.voltronicpower.monitor.AbstractMonitorProcessor;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.utilities.StrConvert;
import cn.com.voltronicpower.work.BatteryTestEndHandler;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;

public class P98Processor
extends AbstractMonitorProcessor {
    private static long curTime;
    private static int curCapacity;
    public String faultCode = "";

    static {
        curCapacity = 90;
    }

    public P98Processor(CommunicateHandlerInterface handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public String cancelSwitchCtrl() throws IOException {
        this.excuteCommand("C", false);
        return "(ACK";
    }

    @Override
    public String deepBatteryTestCtrl() throws IOException, UnsupportException {
        String returnData = this.excuteCommand("TL", true);
        return returnData;
    }

    @Override
    public Capability getCapability() throws IOException, UnsupportException {
        return null;
    }

    @Override
    public String munitesBatteryTestCtrl(float minute) throws IOException, UnsupportException {
        String commandStr = "T";
        commandStr = minute < 1.0f ? String.valueOf(commandStr) + String.valueOf(minute).substring(1, 3) : (minute < 10.0f ? String.valueOf(commandStr) + "0" + (int)minute : String.valueOf(commandStr) + String.valueOf((int)minute));
        String returnData = this.excuteCommand(commandStr, true);
        return returnData;
    }

    @Override
    public String offBuzzerCtrl() throws IOException {
        String dataStr = this.excuteCommand("Q1", true);
        String[] datas = dataStr.split(" ");
        String status = datas[datas.length - 1];
        if (status.charAt(7) == '1') {
            this.excuteCommand("Q", false);
            return "(ACK";
        }
        return "(NAK";
    }

    @Override
    public String onBuzzerCtrl() throws IOException {
        String dataStr = this.excuteCommand("Q1", true);
        String[] datas = dataStr.split(" ");
        String status = datas[datas.length - 1];
        if (status.charAt(7) == '0') {
            this.excuteCommand("Q", false);
            return "(ACK";
        }
        return "(NAK";
    }

    public String queryMorphological(char status) {
        if (status == '1') {
            return "standby";
        }
        if (status == '0') {
            return "on-line";
        }
        return "";
    }

    @Override
    public void queryUpsInfo() throws IOException {
        String[] datas = null;
        String dataStr = this.excuteCommand("Q1", true);
        datas = dataStr.split(" ");
        String status = datas[datas.length - 1];
        this.identity.setMorphological(this.queryMorphological(status.charAt(4)));
        this.identity.setProductSN("----");
        dataStr = this.excuteCommand("I", true);
        datas = dataStr.split(" ");
        this.identity.setFwVersion(datas[2].trim());
        dataStr = this.excuteCommand("F", true);
        datas = dataStr.split(" ");
        this.ratingInfo.setOutputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.ratingInfo.setOutputRatingCurrent(String.valueOf(Float.parseFloat(datas[1])));
        this.ratingInfo.setBatteryVoltage(String.valueOf(Float.parseFloat(datas[2])));
        this.ratingInfo.setOutputRatingFrequency(String.valueOf(Float.parseFloat(datas[3])));
    }

    @Override
    public WorkInfo queryWorkInfo() {
        try {
            this.workInfo.setPtid("P98");
            this.workInfo.setCurrentTime(new Date());
            this.workInfo.setDeviceId(this.getDeviceId());
            String dataStr = this.excuteCommand("Q1", true);
            String[] datas = dataStr.split(" ");
            String status = datas[datas.length - 1];
            if (status.length() < 8) {
                return this.workInfo;
            }
            if (status.charAt(4) == '1') {
                this.workInfo.setMorphological("standby");
            } else if (status.charAt(4) == '0') {
                this.workInfo.setMorphological("on-line");
            }
            if (status.charAt(3) == '1') {
                EventsHandler.handleEvent(this.getDeviceName(), "3009", "P98", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "3009");
            }
            if (status.charAt(7) == '1') {
                this.workInfo.setBuzzerCtrl(true);
            } else {
                this.workInfo.setBuzzerCtrl(false);
            }
            float cellBatteryV = Float.parseFloat(datas[5]);
            String rateBatteryVstr = this.excuteCommand("F", true);
            float rateBatteryV = Float.parseFloat(rateBatteryVstr.split(" ")[2]);
            float batteryVoltage = rateBatteryV / 12.0f * 6.0f * cellBatteryV;
            float vBat = 0.0f;
            if (status.charAt(4) == '0') {
                this.workInfo.setBatteryVoltage(String.valueOf(MathUtils.round((double)batteryVoltage, (int)1)));
                vBat = batteryVoltage;
            } else {
                this.workInfo.setBatteryVoltage(String.valueOf(MathUtils.round((double)cellBatteryV, (int)1)));
                vBat = cellBatteryV;
            }
            if (batteryVoltage < 15.0f) {
                vBat = batteryVoltage;
            } else if (batteryVoltage <= 30.0f) {
                vBat = batteryVoltage / 2.0f;
            } else if (batteryVoltage <= 45.0f) {
                vBat = batteryVoltage / 3.0f;
            } else if (batteryVoltage <= 60.0f) {
                vBat = batteryVoltage / 4.0f;
            }
            this.workInfo.setInputVoltage(datas[0].substring(1));
            this.workInfo.setOutputVoltage(datas[2]);
            this.workInfo.setOutputLoadPercent(datas[3]);
            this.workInfo.setInputFrequency(datas[4]);
            this.workInfo.setTemperature(datas[6]);
            String outputVoltage = this.workInfo.getOutputVoltage();
            double intOutputVoltage = 0.0;
            try {
                intOutputVoltage = Double.parseDouble(outputVoltage);
            }
            catch (Exception e) {
                intOutputVoltage = 0.0;
            }
            if (intOutputVoltage < 20.0) {
                if (status.charAt(3) == '0') {
                    this.workInfo.setWorkMode("Standby mode");
                }
            } else if (status.charAt(0) == '0' && status.charAt(5) == '0') {
                this.workInfo.setWorkMode("Line mode");
                this.isBatMod = false;
            } else if (status.charAt(0) == '0' && status.charAt(5) == '1') {
                this.workInfo.setWorkMode("Battery test mode");
                this.isBatMod = false;
            } else if (status.charAt(0) == '1') {
                this.workInfo.setWorkMode("Battery mode");
                if (!this.isBatMod) {
                    this.shutdownOnBatteryMode();
                }
                this.isBatMod = true;
            } else if (status.charAt(3) == '1') {
                this.workInfo.setWorkMode("Fault mode");
                this.isBatMod = false;
            }
            if (this.firstLife.equals("")) {
                this.firstLife = this.getLife(this.port, this.ptid);
            } else {
                this.workInfo.setBatteryLife(this.firstLife);
            }
            this.shutdownOnlowBattery(status.charAt(0) != '1', status.charAt(1) == '1');
            int batteryCapacity = this.calculateBatteryCapacity(vBat, this.workInfo.getWorkMode());
            Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
            int batCapacity = shutdown.getBatCapacity();
            if ("Battery mode".equals(this.workInfo.getWorkMode()) && batteryCapacity <= batCapacity) {
                if (!this.isBatCap && ("InfoPower".equalsIgnoreCase(MyConstants.Customized) || "NetGuard".equalsIgnoreCase(MyConstants.Customized) || "ATMUSE".equalsIgnoreCase(MyConstants.Customized))) {
                    new Thread(){

                        @Override
                        public void run() {
                            P98Processor.this.isBatCap = true;
                            P98Processor.this.shutdownOnBatteryCapacity();
                        }
                    }.start();
                }
            } else {
                this.isBatCap = false;
            }
            this.workInfo.setBatteryCapacity(batteryCapacity);
            if (status.charAt(3) == '1') {
                this.workInfo.setWorkMode("Fault mode");
            }
            if (this.lastSelfTestProgress == '1' && status.charAt(5) == '0') {
                BatteryTestEndHandler.endEvent(this.getDeviceName(), "P98", this.getDeviceId());
            }
            this.lastSelfTestProgress = status.charAt(5);
            double outputV = StrConvert.toDouble(this.workInfo.getOutputVoltage());
            char utility = status.charAt(0);
            if (this.workInfo.isFirst()) {
                if (utility == '1') {
                    EventsHandler.putEvent(this.getDeviceName(), "1001");
                } else {
                    EventsHandler.putEvent(this.getDeviceName(), "1002");
                }
            } else if (utility == '1') {
                EventsHandler.removeEvent(this.getDeviceName(), "1002");
                EventsHandler.handleEvent(this.getDeviceName(), "1001", "P98", this.getDeviceId(), true);
            } else if (utility == '0' && outputV > 0.0) {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
                EventsHandler.handleEvent(this.getDeviceName(), "1002", "P98", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
            }
            this.workInfo.setBypassActive(status.charAt(2) == '1');
            if (this.workInfo.isFirst()) {
                if (this.workInfo.isBypassActive()) {
                    EventsHandler.putEvent(this.getDeviceName(), "2001");
                } else {
                    EventsHandler.putEvent(this.getDeviceName(), "2002");
                }
            } else if (this.workInfo.isBypassActive()) {
                EventsHandler.removeEvent(this.getDeviceName(), "2002");
                EventsHandler.handleEvent(this.getDeviceName(), "2001", "P98", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "2001");
                EventsHandler.handleEvent(this.getDeviceName(), "2002", "P98", this.getDeviceId(), true);
            }
            this.workInfo.setShutdownActive(status.charAt(6) == '1');
            this.workInfo.setFirst(false);
            this.workInfo.setClear(false);
            try {
                String warningstatus = this.excuteCommand("QWS", true).substring(1);
                if (!warningstatus.equals("OK")) {
                    System.out.println("warningstatus:" + warningstatus);
                    this.refreshWarning(warningstatus, this.getDeviceId());
                }
                String flutstatus = this.excuteCommand("QFS", true).substring(1);
                if (!warningstatus.equals("OK")) {
                    System.out.println("flutstatus:" + flutstatus);
                    this.refreshfault(flutstatus, this.getDeviceId());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.workInfo;
    }

    public void refreshWarning(String status, String sn) {
        this.refreshWarningStatus(status, 0, "4006", sn);
        this.refreshWarningStatus(status, 1, "3537", sn);
        this.refreshWarningStatus(status, 2, "5002", sn);
        this.refreshWarningStatus(status, 3, "3008", sn);
    }

    public void refreshfault(String status, String sn) {
        System.out.println("-" + status + "-");
        if (status.equals("01")) {
            this.refreshfalut(status, 0, "4107", sn);
            this.faultCode = "4107";
        } else if (status.equals("02")) {
            this.refreshfalut(status, 0, "4108", sn);
            this.faultCode = "4108";
        } else if (status.equals("03")) {
            this.refreshfalut(status, 0, "5003", sn);
            this.faultCode = "5003";
        } else if (status.equals("04")) {
            this.refreshfalut(status, 0, "3044", sn);
            this.faultCode = "3044";
        } else if (status.equals("05")) {
            this.refreshfalut(status, 0, "3030", sn);
            this.faultCode = "3030";
        } else if (status.equals("06")) {
            this.refreshfalut(status, 0, "3812", sn);
            this.faultCode = "3812";
        } else if (status.equals("07")) {
            this.refreshfalut(status, 0, "3028", sn);
            this.faultCode = "3028";
        } else if (status.equals("08")) {
            this.refreshfalut(status, 0, "3029", sn);
            this.faultCode = "3029";
        } else {
            EventsHandler.removeEvent(this.getDeviceName(), this.faultCode);
        }
    }

    private final void refreshWarningStatus(String warnStatus, int index, String eventCode, String sn) {
        if (warnStatus.charAt(index) == '1') {
            EventsHandler.handleEvent(this.getDeviceName(), eventCode, this._protocol.getProtocolID(), this.getDeviceId(), true);
            this.workInfo.addWarning("a" + index);
        } else {
            EventsHandler.removeEvent(this.getDeviceName(), eventCode);
        }
    }

    private final void refreshfalut(String warnStatus, int index, String eventCode, String sn) {
        if (!this.faultCode.equals(eventCode)) {
            EventsHandler.removeEvent(this.getDeviceName(), this.faultCode);
        }
        EventsHandler.handleEvent(this.getDeviceName(), eventCode, this._protocol.getProtocolID(), this.getDeviceId(), true);
    }

    private int calculateBatteryCapacity(float vBat, String workMode) {
        if (workMode.equals("Line mode") || workMode.equals("Standby mode")) {
            if ((double)vBat < 11.6) {
                return 0;
            }
            if ((double)vBat >= 13.5) {
                return 100;
            }
            if ((double)vBat >= 13.3) {
                if (curCapacity >= 100) {
                    return 100;
                }
                if (curTime > 0L) {
                    long tempTime = System.currentTimeMillis();
                    if (tempTime - curTime >= 720000L) {
                        curTime = tempTime;
                        return ++curCapacity;
                    }
                    return curCapacity;
                }
                curTime = System.currentTimeMillis();
                return curCapacity;
            }
            int batteryCapacity = (int)(90.0 * ((double)vBat - 11.6) / 1.7);
            return batteryCapacity;
        }
        if (workMode.equals("Battery mode") || workMode.equals("Battery test mode")) {
            curCapacity = 90;
            curTime = 0L;
            int load = 0;
            try {
                load = Integer.parseInt(this.workInfo.getOutputLoadPercent());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (load < 20) {
                if ((double)vBat > 13.2) {
                    return 100;
                }
                if ((double)vBat > 10.2) {
                    int batteryCapacity = (int)(100.0 * ((double)vBat - 10.2) / 3.0);
                    return batteryCapacity;
                }
                return 0;
            }
            if ((double)vBat > 12.7) {
                return 100;
            }
            if ((double)vBat > 10.2) {
                int batteryCapacity = (int)(100.0 * ((double)vBat - 10.2) / 2.5);
                return batteryCapacity;
            }
        }
        return 0;
    }

    @Override
    public String tenSencondsBatteryTestCtrl() throws IOException {
        this.excuteCommand("T", false);
        return "(ACK";
    }

    @Override
    public void testOperation() throws IOException {
        this.excuteCommand("TL", true);
    }

    @Override
    public String offSwitchCtrl() throws IOException {
        String delayShutdownTime = this.getDelayShutdownTime();
        String command = "Sn".replace("n", delayShutdownTime);
        this.excuteCommand(command, false);
        return "(ACK";
    }

    @Override
    public void offSwitchCtrl(int minutes) throws IOException {
        String delayShutdownTime = this.getDelayShutdownTime();
        minutes = minutes > 9999 ? 9999 : minutes;
        DecimalFormat df3 = new DecimalFormat("0000");
        String turnOnDelay = df3.format(minutes);
        String command = null;
        command = "SnRm".replace("n", delayShutdownTime).replace("m", turnOnDelay);
        this.excuteCommand(command, true);
    }

    @Override
    public String offSwitchCtrlOntime() throws IOException {
        String command = "Sn".replace("n", ".2");
        this.excuteCommand(command, false);
        return "(ACK";
    }

    @Override
    public String offSwitchCtrlOntime(int minutes) throws IOException {
        minutes = minutes > 9999 ? 9999 : minutes;
        DecimalFormat df3 = new DecimalFormat("0000");
        String turnOnDelay = df3.format(minutes);
        String command = "SnRm".replace("n", ".2").replace("m", turnOnDelay);
        this.excuteCommand(command, false);
        return "(ACK";
    }

    @Override
    public String queryQBT() throws IOException {
        return null;
    }

    @Override
    public String queryQGR() throws IOException {
        return null;
    }

    @Override
    public boolean setPBT(String value) throws IOException {
        return false;
    }

    @Override
    public boolean setPGR(String value) throws IOException {
        return false;
    }

    @Override
    public boolean isSupportBatNum() {
        return this.supportBatNum;
    }

    @Override
    public void setSupportBatNum(boolean arg0) {
        this.supportBatNum = arg0;
    }
}

