/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.processor;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.data.bean.Capability;
import cn.com.voltronicpower.data.bean.ParameterSettings;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.exception.FaultHandler;
import cn.com.voltronicpower.exception.UnsupportException;
import cn.com.voltronicpower.monitor.AbstractMonitorProcessor;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.utilities.StrConvert;
import cn.com.voltronicpower.work.BatteryTestEndHandler;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;
import org.springframework.beans.BeanWrapperImpl;

public class P73Processor
extends AbstractMonitorProcessor {
    private Capability capability = new Capability();

    public P73Processor(CommunicateHandlerInterface handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public String cancelSwitchCtrl() throws IOException {
        return this.excuteCommand("CS", true);
    }

    @Override
    public String offSwitchCtrlOntime() throws IOException {
        return this.excuteCommand("SOFF", true);
    }

    @Override
    public String offSwitchCtrlOntime(int minutes) throws IOException {
        minutes = minutes > 9999 ? 9999 : minutes;
        DecimalFormat df3 = new DecimalFormat("0000");
        String turnOnDelay = df3.format(minutes);
        String command = null;
        command = "SnRm".replace("n", ".2").replace("m", turnOnDelay);
        this.excuteCommand(command, true);
        return "(ACK";
    }

    @Override
    public Capability getCapability() throws IOException {
        return this.capability;
    }

    @Override
    public String setTotalCapacity(int value) throws IOException {
        String val = "";
        val = value < 10 ? "000" + value : (value < 100 ? "00" + value : "0" + value);
        System.out.println("-------------setTotalCapacity:" + value + "|" + val);
        String command = "BATTAH" + val;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            this.queryUpsInfo();
            return "success";
        }
        return "failure";
    }

    private void queryCapability() throws IOException {
        String enableName;
        String fieldName;
        String ctrlName;
        String returnData = this.excuteCommand("QFLAG", true);
        if (returnData.indexOf("j") < 0) {
            this.workInfo.getMaps().put("supportOutlet", "false");
        } else {
            this.workInfo.getMaps().put("supportOutlet", "true;");
        }
        String[] datas = returnData.split("D");
        String enables = datas[0].substring(2);
        String disables = "";
        if (datas.length > 1) {
            disables = datas[1];
        }
        BeanWrapperImpl configWrapper = new BeanWrapperImpl((Object)this.capability);
        int i = 0;
        while (i < enables.length()) {
            ctrlName = enables.substring(i, i + 1).toUpperCase();
            fieldName = "capable" + ctrlName;
            enableName = "enable" + ctrlName;
            try {
                configWrapper.setPropertyValue(fieldName, (Object)true);
                configWrapper.setPropertyValue(enableName, (Object)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        i = 0;
        while (i < disables.length()) {
            ctrlName = disables.substring(i, i + 1).toUpperCase();
            fieldName = "capable" + ctrlName;
            enableName = "enable" + ctrlName;
            try {
                configWrapper.setPropertyValue(fieldName, (Object)false);
                configWrapper.setPropertyValue(enableName, (Object)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    @Override
    public String munitesBatteryTestCtrl(float minute) throws IOException, UnsupportException {
        String commandStr = "T";
        commandStr = minute < 1.0f ? String.valueOf(commandStr) + String.valueOf(minute).substring(1, 3) : (minute < 10.0f ? String.valueOf(commandStr) + "0" + (int)minute : String.valueOf(commandStr) + String.valueOf((int)minute));
        String returnData = this.excuteCommand(commandStr, true);
        return returnData;
    }

    @Override
    public String offBuzzerCtrl() throws IOException {
        String retStr = this.excuteCommand("BZOFF", true);
        return retStr;
    }

    @Override
    public String offSwitchCtrl() throws IOException {
        String delayShutdownTime = this.getDelayShutdownTime();
        String command = "Sn".replace("n", delayShutdownTime);
        return this.excuteCommand(command, true);
    }

    @Override
    public void offSwitchCtrl(int minutes) throws IOException {
        String delayShutdownTime = this.getDelayShutdownTime();
        minutes = minutes > 9999 ? 9999 : minutes;
        DecimalFormat df3 = new DecimalFormat("0000");
        String turnOnDelay = df3.format(minutes);
        String command = null;
        command = "SnRm".replace("n", delayShutdownTime).replace("m", turnOnDelay);
        this.excuteCommand(command, true);
    }

    @Override
    public String onBuzzerCtrl() throws IOException {
        String retStr = this.excuteCommand("BZON", true);
        return retStr;
    }

    @Override
    public void queryUpsInfo() throws IOException {
        String[] datas;
        block11: {
            datas = null;
            String status = null;
            String dataStr = this.excuteCommand("QGS", true);
            datas = dataStr.split(" ");
            status = datas[datas.length - 1];
            this.identity.setMorphological(this.queryMorphological(status));
            if (MyConstants.Customized.equals("PUMA_BRAZIL")) {
                dataStr = this.excuteCommand("QMF", true);
                dataStr = dataStr.substring(1);
                this.identity.setManufacturer(dataStr.substring(dataStr.lastIndexOf("#") + 1));
                String dateStr = this.excuteCommand("QMUD", true);
                dateStr = dateStr.substring(1);
                this.identity.setProductDate(dateStr);
            }
            dataStr = this.excuteCommand("QMD", true);
            String modelName = dataStr.substring(1, 17);
            dataStr = dataStr.substring(17);
            datas = dataStr.split(" ");
            this.identity.setUpsModelName(modelName.substring(modelName.lastIndexOf("#") + 1));
            this.ratingInfo.setRatedCapacity(datas[0].substring(datas[0].lastIndexOf("#") + 1));
            this.identity.setIoPhase(datas[2]);
            this.workInfo.setIoPhase(datas[2]);
            this.identity.setInputRatingVoltage(datas[3]);
            this.identity.setOutputRatingVoltage(datas[4]);
            String sn = "";
            try {
                try {
                    sn = this.excuteCommand("QID", true);
                    sn = "(NAK".equals(sn) ? "----" : (!"".equals(sn.trim()) ? sn.substring(1) : "----");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.identity.setProductSN(sn);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                this.identity.setProductSN(sn);
                throw throwable;
            }
            this.identity.setProductSN(sn);
        }
        datas = this.excuteCommand("QRI", true).split(" ");
        this.ratingInfo.setOutputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.identity.setInputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.identity.setOutputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.ratingInfo.setOutputRatingFrequency(String.valueOf(Float.parseFloat(datas[3])));
        this.ratingInfo.setOutputRatingCurrent(String.valueOf(Integer.parseInt(datas[1])));
        this.ratingInfo.setBatteryVoltage(String.valueOf(Float.parseFloat(datas[2])));
        datas = this.excuteCommand("QBV", true).split(" ");
        this.batteryNumber.setBatn(Integer.parseInt(datas[1]));
        this.batteryNumber.setBatgn(Integer.parseInt(datas[2]));
        String ahvalue = this.excuteCommand("QBTAH", true).split(" ")[1];
        this.batteryNumber.setBatTotalAHValue(Integer.parseInt(ahvalue));
        String value = "";
        try {
            try {
                String qvfw = this.excuteCommand("QVFW", true);
                value = qvfw.substring(qvfw.indexOf(":") + 1);
            }
            catch (Exception exception) {
                this.identity.setFwVersion(value);
            }
        }
        finally {
            this.identity.setFwVersion(value);
        }
    }

    @Override
    public WorkInfo queryWorkInfo() {
        try {
            this.workInfo.setSolar(true);
            this.workInfo.setPtid("P73");
            this.workInfo.setCurrentTime(new Date());
            this.workInfo.setDeviceId(this.getDeviceId());
            String returnData = this.excuteCommand("QGS", true);
            String[] datas = returnData.split(" ");
            String status = datas[datas.length - 1];
            this.shutdownOnlowBattery(status.charAt(2) != '1', status.charAt(3) == '1');
            if (status.charAt(9) == '1') {
                this.workInfo.setBuzzerCtrl(false);
            } else {
                this.workInfo.setBuzzerCtrl(true);
            }
            String[] QBCO = this.excuteCommand("QBCO", true).split(" ");
            this.workInfo.setBatteryCutOffVoltage(QBCO[1].substring(0, 4));
            double outputV = StrConvert.toDouble(this.workInfo.getOutputVoltage());
            char utility = status.charAt(2);
            if (this.workInfo.isFirst()) {
                if (utility == '1') {
                    EventsHandler.putEvent(this.getDeviceName(), "1001");
                } else if (utility == '0') {
                    EventsHandler.putEvent(this.getDeviceName(), "1002");
                }
            } else if (utility == '1') {
                EventsHandler.removeEvent(this.getDeviceName(), "1002");
                EventsHandler.handleEvent(this.getDeviceName(), "1001", "P73", this.getDeviceId(), true);
            } else if (utility == '0' && outputV > 0.0) {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
                EventsHandler.handleEvent(this.getDeviceName(), "1002", "P73", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
            }
            if (status.charAt(5) == '1') {
                returnData = this.excuteCommand("QFS", true);
                if (!returnData.equals("(OK")) {
                    String[] faultDatas = returnData.split(" ");
                    String faultKind = faultDatas[0].substring(1);
                    FaultHandler.doFaultEvent(faultKind, this.getDeviceName(), "P73", this.getDeviceId());
                    this.workInfo.setFaultKind(faultKind);
                }
            } else {
                FaultHandler.removeFaultEvent(this.getDeviceName());
                this.workInfo.setFaultKind(null);
            }
            if (this.lastSelfTestProgress == '1' && status.charAt(7) == '0') {
                BatteryTestEndHandler.endEvent(this.getDeviceName(), "P73", status);
            }
            this.lastSelfTestProgress = status.charAt(7);
            this.workInfo.setMorphological(this.queryMorphological(status));
            this.workInfo.setBypassActive(status.charAt(4) == '1');
            if (this.workInfo.isFirst()) {
                if (this.workInfo.isBypassActive()) {
                    EventsHandler.putEvent(this.getDeviceName(), "2001");
                } else {
                    EventsHandler.putEvent(this.getDeviceName(), "2002");
                }
            } else if (this.workInfo.isBypassActive()) {
                EventsHandler.removeEvent(this.getDeviceName(), "2002");
                EventsHandler.handleEvent(this.getDeviceName(), "2001", "P73", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "2001");
                EventsHandler.handleEvent(this.getDeviceName(), "2002", "P73", this.getDeviceId(), true);
            }
            this.workInfo.setInputVoltage(datas[0].substring(1));
            this.workInfo.setInputFrequency(datas[1]);
            this.workInfo.setOutputVoltage(datas[2]);
            this.workInfo.setOutputFrequency(datas[3]);
            this.workInfo.setOutputCurrent(datas[4]);
            this.workInfo.setOutputLoadPercent(datas[5]);
            this.workInfo.setTemperature(datas[10]);
            String retMPPT = this.excuteCommand("QMCHGC", true).substring(1);
            this.workInfo.setChangeA_MPPT(retMPPT);
            retMPPT = this.excuteCommand("QSOLV", true).substring(1);
            this.workInfo.setSolarV_MPPT(retMPPT);
            retMPPT = this.excuteCommand("QMPOW", true).substring(1);
            this.workInfo.setPower_MPPT(retMPPT);
            retMPPT = this.excuteCommand("QM+POW", true).substring(1);
            this.workInfo.setTotalPowerMPPT(retMPPT);
            retMPPT = this.excuteCommand("QSOLSAT", true).substring(1);
            this.workInfo.setSolarON(retMPPT.equals("1"));
            Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
            float overTempValue = shutdown.getOverTemperatureValue();
            if (StrConvert.toFloat(this.workInfo.getTemperatureView()) >= overTempValue) {
                if (!this.isOverTemperature) {
                    new Thread(){

                        @Override
                        public void run() {
                            P73Processor.this.isOverTemperature = true;
                            P73Processor.this.shutdownOverTemperature();
                        }
                    }.start();
                }
            } else {
                this.isOverTemperature = false;
            }
            if ((returnData = this.excuteCommand("QMOD", true)).equals("(P")) {
                this.workInfo.setWorkMode("Power on mode");
                this.isBatMod = false;
            } else if (returnData.equals("(S")) {
                this.workInfo.setWorkMode("Standby mode");
                this.isBatMod = false;
            } else if (returnData.equals("(Y")) {
                this.workInfo.setWorkMode("Bypass mode");
                this.isBatMod = false;
            } else if (returnData.equals("(L")) {
                this.workInfo.setWorkMode("Line mode");
                this.isBatMod = false;
            } else if (returnData.equals("(B")) {
                this.workInfo.setWorkMode("Battery mode");
                if (!this.isBatMod) {
                    this.isBatMod = true;
                    this.shutdownOnBatteryMode();
                }
            } else if (returnData.equals("(T")) {
                this.workInfo.setWorkMode("Battery test mode");
                this.isBatMod = false;
            } else if (returnData.equals("(F")) {
                this.workInfo.setWorkMode("Fault mode");
                this.isBatMod = false;
            } else if (returnData.equals("(E")) {
                this.workInfo.setWorkMode("ECO mode");
                this.isBatMod = false;
            } else if (returnData.equals("(C")) {
                this.workInfo.setWorkMode("Converter mode");
                this.isBatMod = false;
            } else if (returnData.equals("(D")) {
                this.workInfo.setWorkMode("Shutdown mode");
                this.isBatMod = false;
            }
            String warnStatus = this.excuteCommand("QWS", true);
            String warnStr = warnStatus.substring(1);
            this.setWarningStatus(warnStr);
            if (warnStr.charAt(0) == '1') {
                this.workInfo.setBatteryCapacity(0);
                this.workInfo.setBatteryVoltage("0");
                this.workInfo.setBatteryRemainTime(0);
                this.workInfo.setGroupNum("0");
            } else {
                returnData = this.excuteCommand("QBV", true);
                datas = returnData.split(" ");
                int batteryCapacity = Integer.parseInt(datas[3]);
                this.workInfo.setBatteryCapacity(batteryCapacity);
                this.workInfo.setBatteryVoltage(datas[0].substring(1));
                this.workInfo.setBatteryRemainTime(Integer.parseInt(datas[4]));
                this.workInfo.setGroupNum(datas[2]);
            }
            this.workInfo.setBatteryLife(this.firstLife);
            String os1Status = this.excuteCommand("QSK1", true);
            String os2Status = this.excuteCommand("QSK2", true);
            if (this.workInfo.isFirst()) {
                if (os1Status.equals("(1")) {
                    EventsHandler.putEvent(this.getDeviceName(), "3001");
                } else if (os1Status.equals("(0")) {
                    EventsHandler.putEvent(this.getDeviceName(), "3002");
                }
                if (os2Status.equals("(1")) {
                    EventsHandler.putEvent(this.getDeviceName(), "3003");
                } else if (os2Status.equals("(0")) {
                    EventsHandler.putEvent(this.getDeviceName(), "3004");
                }
            } else {
                if (os1Status.equals("(1")) {
                    EventsHandler.removeEvent(this.getDeviceName(), "3002");
                    EventsHandler.handleEvent(this.getDeviceName(), "3001", "P73", this.getDeviceId(), true);
                    this.workInfo.setEnableOutlet1(true);
                } else if (os1Status.equals("(0")) {
                    EventsHandler.removeEvent(this.getDeviceName(), "3001");
                    EventsHandler.handleEvent(this.getDeviceName(), "3002", "P73", this.getDeviceId(), true);
                    this.workInfo.setEnableOutlet1(false);
                }
                if (os2Status.equals("(1")) {
                    EventsHandler.removeEvent(this.getDeviceName(), "3004");
                    EventsHandler.handleEvent(this.getDeviceName(), "3003", "P73", this.getDeviceId(), true);
                    this.workInfo.setEnableOutlet2(true);
                } else if (os2Status.equals("(0")) {
                    EventsHandler.removeEvent(this.getDeviceName(), "3003");
                    EventsHandler.handleEvent(this.getDeviceName(), "3004", "P73", this.getDeviceId(), true);
                    this.workInfo.setEnableOutlet2(false);
                }
            }
            this.queryParameterSettings();
            this.queryCapability();
            this.queryBypass();
            this.queryHighEfficiencyVoltage();
            this.workInfo.setFirst(false);
            this.workInfo.setClear(false);
            this.reconnectTimes = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logingCommunicateException(false);
        }
        return this.workInfo;
    }

    public ParameterSettings queryParameterSettings() {
        try {
            String retMPPT = this.excuteCommand("QMCHGMC", true).substring(4);
            this.param.setMaxCHA_MPPT(retMPPT);
            retMPPT = this.excuteCommand("QMBATHI", true).substring(1);
            this.param.setBatVHighTraPoint_MPPT(retMPPT);
            retMPPT = this.excuteCommand("QMBATLO", true).substring(1);
            this.param.setBatVlowTraPoint_MPPT(retMPPT);
            retMPPT = this.excuteCommand("QEMOD", true).substring(1);
            this.param.setEnergyMode_MPPT(retMPPT);
            retMPPT = this.excuteCommand("QCHGMOD", true).substring(1);
            this.param.setChargeA(retMPPT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.param;
    }

    @Override
    public String setNewParameter(String type, String value) throws IOException {
        if (type.equals("MBATLO") || type.equals("MBATHI")) {
            double val = Double.parseDouble(value);
            value = String.format("%4.2f", val);
        }
        return this.returnCommandValue(String.valueOf(type) + value);
    }

    private void setWarningStatus(String warnStatus) {
        this.workInfo.clearWarning();
        this.refreshWarningStatus(warnStatus, 0, "4004");
        this.refreshWarningStatus(warnStatus, 1, "1003");
        this.refreshWarningStatus(warnStatus, 2, "1004");
        this.refreshWarningStatus(warnStatus, 3, "1005");
        this.refreshWarningStatus(warnStatus, 4, "2003");
        this.refreshWarningStatus(warnStatus, 5, "2004");
        this.refreshWarningStatus(warnStatus, 6, "4006");
        this.refreshWarningStatus(warnStatus, 7, "4001");
        this.refreshWarningStatus(warnStatus, 8, "5002");
        this.refreshWarningStatus(warnStatus, 9, "3005");
        this.refreshWarningStatus(warnStatus, 10, "3006");
        this.refreshWarningStatus(warnStatus, 11, "3007");
        this.refreshWarningStatus(warnStatus, 12, "3008");
        this.refreshWarningStatus(warnStatus, 13, "3010");
        this.refreshWarningStatus(warnStatus, 14, "3011");
        this.refreshWarningStatus(warnStatus, 15, "3012");
        this.refreshWarningStatus(warnStatus, 16, "3013");
        this.refreshWarningStatus(warnStatus, 17, "3014");
        this.refreshWarningStatus(warnStatus, 18, "3015");
        this.refreshWarningStatus(warnStatus, 19, "3016");
        this.refreshWarningStatus(warnStatus, 20, "3017");
        this.refreshWarningStatus(warnStatus, 21, "3018");
        this.refreshWarningStatus(warnStatus, 22, "3019");
        this.refreshWarningStatus(warnStatus, 23, "3020");
        this.refreshWarningStatus(warnStatus, 24, "8001");
        this.refreshWarningStatus(warnStatus, 25, "8002");
        this.refreshWarningStatus(warnStatus, 26, "8003");
        this.refreshWarningStatus(warnStatus, 27, "8004");
        this.refreshWarningStatus(warnStatus, 28, "8005");
        this.refreshWarningStatus(warnStatus, 29, "8006");
        this.refreshWarningStatus(warnStatus, 30, "8007");
        this.refreshWarningStatus(warnStatus, 31, "8008");
        this.refreshWarningStatus(warnStatus, 32, "8009");
        this.refreshWarningStatus(warnStatus, 33, "8010");
        this.refreshWarningStatus(warnStatus, 34, "8011");
        this.refreshWarningStatus(warnStatus, 35, "8012");
        this.refreshWarningStatus(warnStatus, 36, "8013");
        this.refreshWarningStatus(warnStatus, 37, "8014");
        this.refreshWarningStatus(warnStatus, 38, "8015");
        this.refreshWarningStatus(warnStatus, 39, "8016");
        this.refreshWarningStatus(warnStatus, 40, "8017");
        this.refreshWarningStatus(warnStatus, 41, "8018");
        this.refreshWarningStatus(warnStatus, 42, "8019");
        this.refreshWarningStatus(warnStatus, 43, "8020");
        this.refreshWarningStatus(warnStatus, 44, "8021");
        this.refreshWarningStatus(warnStatus, 45, "8022");
        this.refreshWarningStatus(warnStatus, 46, "8023");
        this.refreshWarningStatus(warnStatus, 47, "8024");
        this.refreshWarningStatus(warnStatus, 48, "8025");
        this.refreshWarningStatus(warnStatus, 49, "8026");
        this.refreshWarningStatus(warnStatus, 50, "8032");
        this.refreshWarningStatus(warnStatus, 51, "8033");
        this.refreshWarningStatus(warnStatus, 52, "8034");
        this.refreshWarningStatus(warnStatus, 53, "8035");
        this.refreshWarningStatus(warnStatus, 54, "3048");
        this.refreshWarningStatus(warnStatus, 55, "3049");
    }

    @Override
    public String tenSencondsBatteryTestCtrl() throws IOException {
        return this.excuteCommand("T", true);
    }

    public void queryBypass() throws IOException {
        try {
            String[] values = this.excuteCommand("QBYV", true).split(" ");
            this.bypass.setBypassHighVoltage(Integer.parseInt(values[0].substring(1)));
            this.bypass.setBypassLowVoltage(Integer.parseInt(values[1]));
            values = this.excuteCommand("QBYF", true).split(" ");
            this.bypass.setBypassHighFrequency(Float.parseFloat(values[0].substring(1)));
            this.bypass.setBypassLowFrequency(Float.parseFloat(values[1]));
            values = this.excuteCommand("QMD", true).substring(17).split(" ");
            int nVol = (int)Float.parseFloat(values[4]);
            if (nVol >= 200) {
                this.bypass.setMinBypassLowVoltage(170);
                this.bypass.setMaxBypassLowVoltage(220);
                this.bypass.setMinBypassHighVoltage(230);
                this.bypass.setMaxBypassHighVoltage(264);
            } else {
                this.bypass.setMinBypassLowVoltage(85);
                this.bypass.setMaxBypassLowVoltage(115);
                this.bypass.setMinBypassHighVoltage(120);
                this.bypass.setMaxBypassHighVoltage(140);
            }
            values = this.excuteCommand("QRI", true).split(" ");
            if (values[3].equals("60.0")) {
                this.bypass.setMinBypassLowFrequency(50.0f);
                this.bypass.setMaxBypassLowFrequency(59.0f);
                this.bypass.setMinBypassHighFrequency(61.0f);
                this.bypass.setMaxBypassHighFrequency(70.0f);
            } else if (values[3].equals("50.0")) {
                this.bypass.setMinBypassLowFrequency(40.0f);
                this.bypass.setMaxBypassLowFrequency(49.0f);
                this.bypass.setMinBypassHighFrequency(51.0f);
                this.bypass.setMaxBypassHighFrequency(60.0f);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public void queryHighEfficiencyVoltage() throws IOException {
        String[] values = this.excuteCommand("QHE", true).split(" ");
        this.voltage.setHeh(Integer.parseInt(values[0].substring(1)));
        this.voltage.setHel(Integer.parseInt(values[1]));
        values = this.excuteCommand("QRI", true).split(" ");
        int nVol = (int)Float.parseFloat(values[0].substring(1));
        if (nVol >= 200) {
            this.voltage.setMinHel(nVol - 24);
            this.voltage.setMaxHel(nVol - 7);
            this.voltage.setMinHeh(nVol + 7);
            this.voltage.setMaxHeh(nVol + 24);
        } else {
            this.voltage.setMinHel(nVol - 12);
            this.voltage.setMaxHel(nVol - 3);
            this.voltage.setMinHeh(nVol + 3);
            this.voltage.setMaxHeh(nVol + 12);
        }
    }

    @Override
    public void testOperation() throws IOException {
        this.excuteCommand("TL", true);
    }

    @Override
    public String deepBatteryTestCtrl() throws IOException, UnsupportException {
        String returnData = this.excuteCommand("TL", true);
        return returnData;
    }

    @Override
    public String queryQBT() throws IOException {
        return null;
    }

    @Override
    public String queryQGR() throws IOException {
        return null;
    }

    @Override
    public boolean setPBT(String value) throws IOException {
        return false;
    }

    @Override
    public boolean setPGR(String value) throws IOException {
        return false;
    }

    @Override
    public boolean isSupportBatNum() {
        return this.supportBatNum;
    }

    @Override
    public void setSupportBatNum(boolean arg0) {
        this.supportBatNum = arg0;
    }
}

