/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.processor;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.data.bean.BuyInfo;
import cn.com.voltronicpower.data.bean.Capability;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.data.dao.BatteryWarnDao;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.exception.FaultHandler;
import cn.com.voltronicpower.exception.UnsupportException;
import cn.com.voltronicpower.monitor.AbstractMonitorProcessor;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import java.io.IOException;
import java.util.Date;
import org.springframework.beans.BeanWrapperImpl;

public class P71Processor
extends AbstractMonitorProcessor {
    private String customeName = "ViewPower";
    private boolean firstTest = false;
    public boolean isnew = false;
    public boolean islowV = false;
    private Capability capability = new Capability();

    public P71Processor(CommunicateHandlerInterface handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public void queryUpsInfo() throws IOException {
        try {
            String ret_QSID;
            String[] retuen_QMD = this.excuteCommand("QMD", true).split(" ");
            this.identity.setUpsModelName(retuen_QMD[0].substring(retuen_QMD[1].lastIndexOf("#") + 1));
            this.ratingInfo.setRatedCapacity(retuen_QMD[1].substring(retuen_QMD[1].lastIndexOf("#") + 1));
            this.identity.setIoPhase(retuen_QMD[3]);
            this.workInfo.setIoPhase(retuen_QMD[3]);
            this.ratingInfo.setNominalInputV(retuen_QMD[4]);
            this.ratingInfo.setNominalOutputV(retuen_QMD[5]);
            int batnum = Integer.parseInt(retuen_QMD[6]);
            this.batteryNumber.setBatn(batnum);
            this.workInfo.setIs3k(retuen_QMD[0].indexOf("3K") != -1);
            String[] retuen_QDI = this.excuteCommand("QDI", true).split(" ");
            if (Double.parseDouble(retuen_QDI[0].substring(1)) < 200.0) {
                this.workInfo.setLowV(true);
                this.islowV = true;
            } else {
                this.workInfo.setLowV(false);
                this.islowV = false;
            }
            System.out.println("lowv" + this.workInfo.isLowV());
            try {
                String qt = this.excuteCommand("QTIME", true);
                this.isnew = true;
            }
            catch (Exception e) {
                this.isnew = false;
            }
            this.workInfo.setIsnew(this.isnew);
            String[] ret_QRI = this.excuteCommand("QRI", true).split(" ");
            this.ratingInfo.setOutputRatingVoltage(ret_QRI[0].substring(1));
            this.ratingInfo.setOutputRatingCurrent(String.valueOf(Double.parseDouble(ret_QRI[1])));
            this.ratingInfo.setOutputRatingFrequency(String.valueOf(Double.parseDouble(ret_QRI[3])));
            this.ratingInfo.setBatteryVoltage(String.valueOf(Double.parseDouble(ret_QRI[2])));
            String ret_QVFW = this.excuteCommand("QVFW", true).substring(1);
            this.identity.setFwVersion(ret_QVFW);
            try {
                ret_QSID = this.excuteCommand("QSID", true).substring(1);
                int len = Integer.parseInt(ret_QSID.substring(1, 3));
                ret_QSID = ret_QSID.substring(3);
            }
            catch (Exception e) {
                e.printStackTrace();
                ret_QSID = "----";
            }
            this.identity.setProductSN(ret_QSID.substring(0, 20));
            String[] ret_QGS1 = this.excuteCommand("QGS", true).split(" ");
            String string = this.queryMorphological(ret_QGS1[0]);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private boolean isSolarModel() {
        String ret_QGMN = this.excuteCommand("QGMN", true).substring(1);
        return ret_QGMN.equals("002");
    }

    @Override
    public WorkInfo queryWorkInfo() {
        try {
            int fact_capa;
            int cfg_capa;
            this.workInfo.setPtid("P71");
            this.workInfo.setCurrentTime(new Date());
            this.workInfo.setDeviceId(this.getDeviceId());
            try {
                String[] qbs = this.excuteCommand("QBS", true).split(" ");
                if (qbs.length > 2) {
                    this.customeName = "HUAWEI";
                }
            }
            catch (Exception e) {
                this.customeName = "ViewPower";
            }
            try {
                String qt = this.excuteCommand("QTIME", true);
                this.isnew = true;
            }
            catch (Exception e) {
                this.isnew = false;
            }
            if (this.isnew || this.islowV) {
                String[] ret_QBEQI = this.excuteCommand("QBEQI", true).split(" ");
                this.workInfo.setBaEq(ret_QBEQI[0].substring(1).equals("1"));
                this.workInfo.setEqualizationTime(ret_QBEQI[1]);
                this.workInfo.setEqualizationPeriod(ret_QBEQI[2]);
                this.workInfo.setEqualizationOverTime(ret_QBEQI[7]);
                this.workInfo.setEqualizationActiveStatus(ret_QBEQI[8].equals("1"));
                this.workInfo.setBatteryEqualizationVoltage(ret_QBEQI[5]);
            }
            this.identity.setMorphological("on-line");
            this.workInfo.setMorphological("on-line");
            String[] ret_QGS = this.excuteCommand("QGS", true).split(" ");
            this.workInfo.setInputVoltage(ret_QGS[0].substring(1));
            this.workInfo.setInputFrequency(ret_QGS[1]);
            this.workInfo.setOutputVoltage(ret_QGS[2]);
            this.workInfo.setOutputFrequency(ret_QGS[3]);
            this.workInfo.setOutputCurrent(ret_QGS[4]);
            this.workInfo.setOutputLoadPercent(ret_QGS[5]);
            this.workInfo.setBatteryVoltage(ret_QGS[8]);
            this.workInfo.setTemperature(ret_QGS[10]);
            String[] ret_QGS2 = this.excuteCommand("QGS2", true).split(" ");
            this.workInfo.setBatteryCapacity(Integer.parseInt(ret_QGS2[2]));
            this.workInfo.setChargeCurr(ret_QGS2[4]);
            this.workInfo.setDischargeCurr(ret_QGS2[5]);
            this.workInfo.setInputVoltagePV(ret_QGS2[6]);
            this.workInfo.setInputPowerPV(ret_QGS2[7]);
            String status_QGS2 = ret_QGS2[ret_QGS2.length - 1];
            this.workInfo.setOutputON(status_QGS2.charAt(0) == '1');
            this.workInfo.setSolarON(status_QGS2.charAt(1) == '1');
            this.workInfo.setChargeON(status_QGS2.charAt(2) == '1');
            this.workInfo.setSettingChanged(status_QGS2.charAt(3) == '1');
            this.workInfo.setSolar(this.isSolarModel());
            if (this.workInfo.isFirst()) {
                if (Double.parseDouble(this.workInfo.getInputVoltage()) <= 20.0) {
                    EventsHandler.putEvent(this.getDeviceName(), "1001");
                } else if (Double.parseDouble(this.workInfo.getInputVoltage()) > 20.0) {
                    EventsHandler.putEvent(this.getDeviceName(), "1002");
                }
            } else if (Double.parseDouble(this.workInfo.getInputVoltage()) <= 20.0) {
                EventsHandler.removeEvent(this.getDeviceName(), "1002");
                EventsHandler.handleEvent(this.getDeviceName(), "1001", "P71", this.getDeviceId(), true);
            } else if (Double.parseDouble(this.workInfo.getInputVoltage()) > 20.0) {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
                EventsHandler.handleEvent(this.getDeviceName(), "1002", "P71", this.getDeviceId(), true);
            }
            String ret_QMOD = this.excuteCommand("QMOD", true);
            if (ret_QMOD.equals("(P")) {
                this.workInfo.setWorkMode("Power on mode");
                this.isBatMod = false;
            } else if (ret_QMOD.equals("(S")) {
                this.workInfo.setWorkMode("Standby mode");
                this.isBatMod = false;
            } else if (ret_QMOD.equals("(Y")) {
                this.workInfo.setWorkMode("Bypass mode");
                this.isBatMod = false;
            } else if (ret_QMOD.equals("(L")) {
                this.workInfo.setWorkMode("Line mode");
                this.isBatMod = false;
            } else if (ret_QMOD.equals("(B")) {
                this.workInfo.setWorkMode("Battery mode");
                if (!this.isBatMod) {
                    this.shutdownOnBatteryMode();
                }
                this.isBatMod = true;
            } else if (ret_QMOD.equals("(T")) {
                this.workInfo.setWorkMode("Battery test mode");
                this.isBatMod = false;
            } else if (ret_QMOD.equals("(F")) {
                this.workInfo.setWorkMode("Fault mode");
                this.isBatMod = false;
            } else if (ret_QMOD.equals("(E")) {
                this.workInfo.setWorkMode("ECO mode");
                this.isBatMod = false;
            } else if (ret_QMOD.equals("(C")) {
                this.workInfo.setWorkMode("Converter mode");
                this.isBatMod = false;
            } else if (ret_QMOD.equals("(D")) {
                this.workInfo.setWorkMode("Shutdown mode");
                this.isBatMod = false;
            }
            String ret_QWS = this.excuteCommand("QWS", true).substring(1);
            if (this.customeName.equals("HUAWEI")) {
                if (ret_QWS.charAt(21) == '1') {
                    this.workInfo.setWorkMode("Battery test mode");
                    if (!this.firstTest) {
                        EventsHandler.handleEvent(this.getDeviceName(), "1001", "P71", this.getDeviceId(), true);
                        this.firstTest = true;
                    }
                    this.isBatMod = false;
                } else if (this.firstTest) {
                    EventsHandler.handleEvent(this.getDeviceName(), "4011", "P71", this.getDeviceId(), true);
                }
            }
            Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
            if (this.workInfo.getWorkMode().equals("Battery mode") && (cfg_capa = shutdown.getBatCapacity()) <= (fact_capa = this.workInfo.getBatteryCapacity())) {
                new Thread(){

                    @Override
                    public void run() {
                        P71Processor.this.isBatCap = true;
                        P71Processor.this.shutdownOnBatteryCapacity();
                    }
                }.start();
            }
            this.setWarningStatus(ret_QWS);
            String ret_QFS = this.excuteCommand("QFS", true).substring(1);
            if (!ret_QFS.equals("00")) {
                FaultHandler.doFaultEventP71(ret_QFS, this.getDeviceName(), "P71", this.getDeviceId(), this.customeName.equals("HUAWEI"));
                this.workInfo.setFaultKind(ret_QFS);
            } else {
                this.workInfo.setFaultKind(null);
            }
            this.queryCapacity();
            this.queryParameterSettings();
            this.workInfo.setFirst(false);
            this.workInfo.setClear(false);
            this.workInfo.setInsertInput(true);
            this.workInfo.setInsertBypass(true);
            this.workInfo.setInsertOutput(true);
            this.reconnectTimes = 0;
        }
        catch (Exception e) {
            this.logingCommunicateException(false);
        }
        return this.workInfo;
    }

    public String setCuCh(int val) {
        String command = "MNCHGC00" + val;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    private void setWarningStatus(String warnStatus) {
        this.workInfo.clearWarning();
        if (this.customeName.equals("HUAWEI")) {
            this.refreshWarningStatus(warnStatus, 1, "3008");
            this.refreshWarningStatus(warnStatus, 2, "3755");
            this.refreshWarningStatus(warnStatus, 3, "4001");
            this.refreshWarningStatus(warnStatus, 5, "5002");
            this.refreshWarningStatus(warnStatus, 7, "4004");
            this.refreshWarningStatus(warnStatus, 8, "3801");
            this.refreshWarningStatus(warnStatus, 9, "3802");
            this.refreshWarningStatus(warnStatus, 10, "3803");
            this.refreshWarningStatus(warnStatus, 12, "3804");
            this.refreshWarningStatus(warnStatus, 13, "3806");
            this.refreshWarningStatus(warnStatus, 14, "3791");
            this.refreshWarningStatus(warnStatus, 15, "3792");
            this.refreshWarningStatus(warnStatus, 16, "3617");
            this.refreshWarningStatus(warnStatus, 17, "3793");
            this.refreshWarningStatus(warnStatus, 18, "3794");
            this.refreshWarningStatus(warnStatus, 19, "3795");
            this.refreshWarningStatus(warnStatus, 20, "3796");
            this.refreshWarningStatus(warnStatus, 21, "3797");
            this.refreshWarningStatus(warnStatus, 22, "3798");
            this.refreshWarningStatus(warnStatus, 23, "3799");
            this.refreshWarningStatus(warnStatus, 24, "2001");
            this.refreshWarningStatus(warnStatus, 25, "3808");
            this.refreshWarningStatus(warnStatus, 26, "3805");
        } else {
            this.refreshWarningStatus(warnStatus, 1, "3008");
            this.refreshWarningStatus(warnStatus, 2, "3005");
            this.refreshWarningStatus(warnStatus, 3, "4001");
            this.refreshWarningStatus(warnStatus, 5, "5002");
            this.refreshWarningStatus(warnStatus, 6, "3760");
            this.refreshWarningStatus(warnStatus, 7, "4004");
        }
    }

    public void queryCapacity() {
        String enableName;
        String fieldName;
        String ctrlName;
        String parameter = this.excuteCommand("QFLAG", true);
        String[] datas = parameter.split("D");
        String enables = datas[0].substring(2);
        String disables = "";
        if (datas.length > 1) {
            disables = datas[1];
        }
        BeanWrapperImpl configWrapper = new BeanWrapperImpl((Object)this.capability);
        int i = 0;
        while (i < enables.length()) {
            ctrlName = enables.substring(i, i + 1);
            fieldName = "capable" + ctrlName;
            enableName = "enable" + ctrlName;
            try {
                configWrapper.setPropertyValue(fieldName, (Object)true);
                configWrapper.setPropertyValue(enableName, (Object)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        i = 0;
        while (i < disables.length()) {
            ctrlName = disables.substring(i, i + 1);
            fieldName = "capable" + ctrlName;
            enableName = "enable" + ctrlName;
            try {
                configWrapper.setPropertyValue(fieldName, (Object)false);
                configWrapper.setPropertyValue(enableName, (Object)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public void queryParameterSettings() {
        String[] ret_QPSI = this.excuteCommand("QPSI", true).substring(1).split(" ");
        this.param.setOutputFre(Double.parseDouble(ret_QPSI[3]));
        this.param.setBatReChV(ret_QPSI[8]);
        this.param.setBatCutOffVolPCS(Double.parseDouble(ret_QPSI[9]));
        this.param.setBatFV(ret_QPSI[11]);
        this.param.setBatType(ret_QPSI[12]);
        if (this.isSolarModel()) {
            this.param.setSolar_inputCurrent(ret_QPSI[13]);
        }
        this.param.setChCurrMax(ret_QPSI[14]);
        this.param.setOutPriority(ret_QPSI[15]);
        this.param.setChPriority(ret_QPSI[16]);
        this.param.setBulkV(ret_QPSI[17]);
        this.param.setOutMode(ret_QPSI[18]);
        this.param.setBatReDisch(ret_QPSI[19]);
        this.param.setChTimeCV(ret_QPSI[10]);
        this.param.setOperatLogic(ret_QPSI[21]);
        String[] mod = this.excuteCommand("QMODBUS", true).substring(1).split(" ");
        this.param.setChACCurrMax(mod[0]);
    }

    @Override
    public void doBatteryWarn() {
        BatteryWarnDao dao = new BatteryWarnDao();
        String deviceId = this.getDeviceId();
        String ptid = this.getProtocol().getProtocolID();
        String portName = this.getDeviceName();
        BuyInfo oldInfo = null;
        oldInfo = deviceId.equals("00000000000000000000") ? dao.getBuyInfo(deviceId, ptid) : dao.getBuyInfo(deviceId, ptid, portName);
        if (oldInfo == null) {
            BuyInfo info = new BuyInfo();
            info.setDeviceId(deviceId);
            info.setPortName(portName);
            info.setPtid(ptid);
            info.setBatteryLifetime(PropertiesUtils.getGlobalConfig().getBatteryLifetime());
            dao.addBuyInfo(info);
        } else if (deviceId.equals("00000000000000000000") && !portName.equals(oldInfo.getPortName())) {
            dao.updatePortName(deviceId, ptid, portName);
            oldInfo.setPortName(portName);
        }
    }

    @Override
    public String setNewParameter(String type, String value) throws IOException {
        if (type.equals("PSDV") || type.equals("PCVV") || type.equals("PBFT")) {
            double val = Double.parseDouble(value);
            value = String.format("%2.01f", val);
        }
        return this.returnCommandValue(String.valueOf(type) + value);
    }

    @Override
    public void testOperation() throws IOException {
        this.excuteCommand("TL", true);
    }

    @Override
    public String deepBatteryTestCtrl() throws IOException {
        String command = "TL";
        if (this.customeName.equals("HUAWEI")) {
            command = "ST";
        }
        String retStr = this.excuteCommand(command, true);
        return retStr.substring(0, 4);
    }

    @Override
    public String cancelBatteryTest() throws IOException {
        String command = "CT";
        String retStr = this.excuteCommand(command, true);
        return retStr.substring(0, 4);
    }

    @Override
    public String onSwitchCtrlOntime() throws IOException {
        String retStr = this.excuteCommand("SON", true);
        return retStr.substring(0, 4);
    }

    @Override
    public String offSwitchCtrlOntime() throws IOException {
        String retStr = this.excuteCommand("SOFF", true);
        return retStr.substring(0, 4);
    }

    @Override
    public Capability getCapability() throws IOException, UnsupportException {
        return this.capability;
    }

    public boolean isFirstTest() {
        return this.firstTest;
    }

    public void setFirstTest(boolean firstTest) {
        this.firstTest = firstTest;
    }

    public String getCustomeName() {
        return this.customeName;
    }

    public void setCustomeName(String customeName) {
        this.customeName = customeName;
    }
}

