/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.processor;

import cn.com.voltronic.util.DateUtils;
import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.data.bean.Bypass;
import cn.com.voltronicpower.data.bean.Capability;
import cn.com.voltronicpower.data.bean.HighEfficiencyVoltage;
import cn.com.voltronicpower.data.bean.LineVoltage;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.exception.FaultHandler;
import cn.com.voltronicpower.exception.UnsupportException;
import cn.com.voltronicpower.monitor.AbstractMonitorProcessor;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.utilities.StrConvert;
import cn.com.voltronicpower.work.BatteryTestEndHandler;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;
import org.springframework.beans.BeanWrapperImpl;

public class P45Processor
extends AbstractMonitorProcessor {
    protected int _ratvol = 220;
    protected int _ratfre = 50;
    protected int count = 3;
    protected String iwt3P4W = "3P4W";
    protected String iwt3P3W = "3P3W";
    protected String iw1P = "1P";
    protected String owt3P4W = "3P4W";
    protected String owt3P3W = "3P3W";
    protected String ow1P = "1P";
    protected static final String ACK = "ACK";
    protected static final String NAK = "NAK";
    protected IProtocol protocol;
    protected String currentWorkMode = "";
    protected Capability capability = new Capability();

    public P45Processor(CommunicateHandlerInterface handler, IProtocol protocol) {
        super(handler, protocol);
        this.protocol = protocol;
    }

    @Override
    public Capability getCapability() throws IOException {
        return this.capability;
    }

    protected void queryCapability() throws IOException {
        String enableName;
        String fieldName;
        String ctrlName;
        String returnData = this.excuteCommand("SEC_QFLG", true);
        String enables = "";
        String disables = "";
        int i = 0;
        while (i < returnData.length()) {
            if (i != 0 && returnData.charAt(i) == '1') {
                enables = String.valueOf(enables) + returnData.charAt(i - 1);
            } else if (i != 0 && returnData.charAt(i) == '0') {
                disables = String.valueOf(disables) + returnData.charAt(i - 1);
            }
            ++i;
        }
        BeanWrapperImpl configWrapper = new BeanWrapperImpl((Object)this.capability);
        int i2 = 0;
        while (i2 < enables.length()) {
            ctrlName = enables.substring(i2, i2 + 1);
            fieldName = "capable" + ctrlName;
            enableName = "enable" + ctrlName;
            try {
                configWrapper.setPropertyValue(fieldName, (Object)true);
                configWrapper.setPropertyValue(enableName, (Object)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < disables.length()) {
            ctrlName = disables.substring(i2, i2 + 1);
            fieldName = "capable" + ctrlName;
            enableName = "enable" + ctrlName;
            try {
                configWrapper.setPropertyValue(fieldName, (Object)false);
                configWrapper.setPropertyValue(enableName, (Object)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
    }

    @Override
    public void queryUpsInfo() throws IOException {
        String[] datas;
        block10: {
            datas = null;
            String status = null;
            String dataStr = this.excuteCommand("SEC_Q3GS", true);
            datas = dataStr.split(",");
            status = datas[datas.length - 1];
            this.identity.setMorphological(this.queryMorphological(status));
            dataStr = this.excuteCommand("SEC_QMD", true);
            datas = dataStr.split(",");
            String modelName = datas[0];
            this.identity.setUpsModelName(modelName.substring(modelName.lastIndexOf("#") + 1));
            this.ratingInfo.setRatedCapacity(datas[1].substring(datas[1].lastIndexOf("#") + 1));
            this.identity.setIoPhase(datas[3]);
            this.workInfo.setIoPhase(datas[3]);
            this.identity.setInputRatingVoltage(datas[4]);
            this.identity.setOutputRatingVoltage(datas[5]);
            String sn = "";
            try {
                try {
                    sn = this.excuteCommand("SEC_QID", true);
                    sn = NAK.equals(sn) ? "----" : (!"".equals(sn.trim()) ? sn.substring(1) : "----");
                }
                catch (Exception exception) {
                    this.identity.setProductSN(sn);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                this.identity.setProductSN(sn);
                throw throwable;
            }
            this.identity.setProductSN(sn);
        }
        datas = this.excuteCommand("SEC_QRI", true).split(",");
        this.ratingInfo.setOutputRatingVoltage(String.valueOf(Float.parseFloat(datas[0])));
        this.identity.setInputRatingVoltage(String.valueOf(Float.parseFloat(datas[0])));
        this.identity.setOutputRatingVoltage(String.valueOf(Float.parseFloat(datas[0])));
        this.ratingInfo.setOutputRatingCurrent("----");
        this.ratingInfo.setBatteryVoltage(String.valueOf(Float.parseFloat(datas[1])));
        this.batteryNumber.setBatTotalAHValue(Integer.parseInt(datas[2]));
        this.ratingInfo.setOutputRatingFrequency(String.valueOf(Float.parseFloat(datas[3])));
        String[] fwDatas = null;
        try {
            try {
                String qvfw = this.excuteCommand("SEC_QVFW", true);
                fwDatas = qvfw.split(",");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.identity.setFwVersion("----");
                this.identity.setDspNumber(fwDatas[0]);
                this.identity.setDspFwVersion(fwDatas[1]);
                this.identity.setDspFwExtraVersion("");
                this.identity.setMcuNumber(fwDatas[2]);
                this.identity.setMcuFwVersion(fwDatas[3]);
                this.identity.setMcuFwExtraVersion("");
                String fw = "DSP:" + fwDatas[0] + "." + fwDatas[1].replace(".", "") + "; MCU:" + fwDatas[2] + "." + fwDatas[3].replace(".", "");
                this.identity.setFwVersion(fw);
            }
        }
        finally {
            this.identity.setDspNumber(fwDatas[0]);
            this.identity.setDspFwVersion(fwDatas[1]);
            this.identity.setDspFwExtraVersion("");
            this.identity.setMcuNumber(fwDatas[2]);
            this.identity.setMcuFwVersion(fwDatas[3]);
            this.identity.setMcuFwExtraVersion("");
            String fw = "DSP:" + fwDatas[0] + "." + fwDatas[1].replace(".", "") + "; MCU:" + fwDatas[2] + "." + fwDatas[3].replace(".", "");
            this.identity.setFwVersion(fw);
        }
    }

    @Override
    public WorkInfo queryWorkInfo() {
        try {
            this.workInfo.setPtid(this.protocol.getProtocolID());
            this.workInfo.setCurrentTime(new Date());
            this.workInfo.setDeviceId(this.getDeviceId());
            String returnData = this.excuteCommand("SEC_Q3GS", true);
            String[] datas = returnData.split(",");
            String status = datas[datas.length - 1];
            if (status.length() >= 4) {
                this.shutdownOnlowBattery(status.charAt(2) != '1', status.charAt(3) == '1');
            }
            if (status.charAt(9) == '1') {
                this.workInfo.setBuzzerCtrl(false);
            } else {
                this.workInfo.setBuzzerCtrl(true);
            }
            double outputV = StrConvert.toDouble(this.workInfo.getOutputVoltage());
            char utility = status.charAt(2);
            if (this.workInfo.isFirst()) {
                if (utility == '1') {
                    EventsHandler.putEvent(this.getDeviceName(), "1001");
                } else if (utility == '0') {
                    EventsHandler.putEvent(this.getDeviceName(), "1002");
                }
            } else if (utility == '1') {
                EventsHandler.removeEvent(this.getDeviceName(), "1002");
                EventsHandler.handleEvent(this.getDeviceName(), "1001", this.protocol.getProtocolID(), this.getDeviceId(), true);
            } else if (utility == '0' && outputV > 0.0) {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
                EventsHandler.handleEvent(this.getDeviceName(), "1002", this.protocol.getProtocolID(), this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
            }
            if (status.charAt(5) == '1') {
                returnData = this.excuteCommand("SEC_QFS", true);
                if (!returnData.equals("00")) {
                    String[] faultDatas = returnData.split(" ");
                    String faultKind = faultDatas[0].substring(1);
                    FaultHandler.doFaultEventP45(faultKind, this.getDeviceName(), this.protocol.getProtocolID(), this.getDeviceId());
                    this.workInfo.setFaultKind(faultKind);
                }
            } else {
                FaultHandler.removeFaultEvent(this.getDeviceName());
                this.workInfo.setFaultKind(null);
            }
            if (this.lastSelfTestProgress == '1' && status.charAt(7) == '0') {
                BatteryTestEndHandler.endEvent(this.getDeviceName(), this.protocol.getProtocolID(), status);
            }
            this.lastSelfTestProgress = status.charAt(7);
            this.workInfo.setMorphological(this.queryMorphological(status));
            this.workInfo.setBypassActive(status.charAt(4) == '1');
            if (this.workInfo.isFirst()) {
                if (this.workInfo.isBypassActive()) {
                    EventsHandler.putEvent(this.getDeviceName(), "2005");
                } else {
                    EventsHandler.putEvent(this.getDeviceName(), "2006");
                }
            } else if (this.workInfo.isBypassActive()) {
                EventsHandler.removeEvent(this.getDeviceName(), "2006");
                EventsHandler.handleEvent(this.getDeviceName(), "2005", this.protocol.getProtocolID(), this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "2005");
                EventsHandler.handleEvent(this.getDeviceName(), "2006", this.protocol.getProtocolID(), this.getDeviceId(), true);
            }
            this.workInfo.setInputVoltage(datas[1]);
            this.workInfo.setInputVoltageS(datas[2]);
            this.workInfo.setInputVoltageT(datas[3]);
            this.workInfo.setInputFrequency(datas[4]);
            this.workInfo.setOutputVoltage(datas[5]);
            this.workInfo.setOutputVoltageS(datas[6]);
            this.workInfo.setOutputVoltageT(datas[7]);
            this.workInfo.setOutputFrequency(datas[8]);
            this.workInfo.setOutputCurrent(datas[9]);
            this.workInfo.setOutputCurrentS(datas[10]);
            this.workInfo.setOutputCurrentT(datas[11]);
            this.workInfo.setLoadLevel(datas[12]);
            this.workInfo.setLoadLevelS(datas[13]);
            this.workInfo.setLoadLevelT(datas[14]);
            this.workInfo.setOutputLoadPercent(datas[15]);
            this.workInfo.setPositiveBatteryVoltage(datas[16]);
            this.workInfo.setNegativeBatteryVoltage(datas[17]);
            this.workInfo.setTemperature(datas[18]);
            this.currentWorkMode = returnData = datas[0];
            if (returnData.equals("01")) {
                this.workInfo.setWorkMode("Power on mode");
                this.isBatMod = false;
            } else if (returnData.equals("02")) {
                this.workInfo.setWorkMode("Standby mode");
                this.isBatMod = false;
            } else if (returnData.equals("03")) {
                this.workInfo.setWorkMode("Bypass mode");
                this.isBatMod = false;
            } else if (returnData.equals("04")) {
                this.workInfo.setWorkMode("Line mode");
                this.isBatMod = false;
            } else if (returnData.equals("05")) {
                this.workInfo.setWorkMode("Battery mode");
                if (!this.isBatMod) {
                    this.shutdownOnBatteryMode();
                }
                this.isBatMod = true;
            } else if (returnData.equals("06")) {
                this.workInfo.setWorkMode("Battery test mode");
                this.isBatMod = false;
            } else if (returnData.equals("07")) {
                this.workInfo.setWorkMode("Fault mode");
                this.isBatMod = false;
            } else if (returnData.equals("09")) {
                this.workInfo.setWorkMode("ECO mode");
                this.isBatMod = false;
            } else if (returnData.equals("08")) {
                this.workInfo.setWorkMode("Converter mode");
                this.isBatMod = false;
            } else if (returnData.equals("10")) {
                this.workInfo.setWorkMode("Shutdown mode");
                this.isBatMod = false;
            }
            if (this.workInfo.isBypassActive() && this.currentWorkMode.equals("03")) {
                EventsHandler.removeEvent(this.getDeviceName(), "2002");
                EventsHandler.handleEvent(this.getDeviceName(), "2001", this.protocol.getProtocolID(), this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "2001");
                EventsHandler.handleEvent(this.getDeviceName(), "2002", this.protocol.getProtocolID(), this.getDeviceId(), true);
            }
            returnData = this.excuteCommand("SEC_Q3Y", true);
            datas = returnData.split(",");
            this.workInfo.setBypassVoltage(datas[0]);
            this.workInfo.setBypassVoltageS(datas[1]);
            this.workInfo.setBypassVoltageT(datas[2]);
            this.workInfo.setBypassCurrent(datas[3]);
            this.workInfo.setBypassCurrentS(datas[4]);
            this.workInfo.setBypassCurrentT(datas[5]);
            this.workInfo.setBypassFrequency(datas[6]);
            if ("Bypass mode".equals(this.workInfo.getWorkMode()) || "ECO mode".equals(this.workInfo.getWorkMode()) || "AVR mode".equals(this.workInfo.getWorkMode())) {
                this.workInfo.setInputVoltage(this.workInfo.getBypassVoltage());
                this.workInfo.setInputVoltageS(this.workInfo.getBypassVoltageS());
                this.workInfo.setInputVoltageT(this.workInfo.getBypassVoltageT());
                this.workInfo.setInputFrequency(this.workInfo.getBypassFrequency());
            }
            String warnStatus = this.excuteCommand("SEC_QWS", true);
            this.setWarningStatus(warnStatus);
            if (warnStatus.charAt(0) == '1') {
                this.workInfo.setBatteryCapacity(0);
                this.workInfo.setBatteryVoltage("0");
                this.workInfo.setBatteryRemainTime(0);
                this.workInfo.setGroupNum("0");
                this.workInfo.setBatChargingCurrentP("0");
                this.workInfo.setBatDisChargingCurrentP("0");
                this.workInfo.setBatChargingCurrentN("0");
                this.workInfo.setBatDisChargingCurrentN("0");
            } else {
                returnData = this.excuteCommand("SEC_QBV", true);
                datas = returnData.split(",");
                int batteryCapacity = Integer.parseInt(datas[6]);
                Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
                int batCapacity = shutdown.getBatCapacity();
                if ("Battery mode".equals(this.workInfo.getWorkMode()) && batteryCapacity <= batCapacity) {
                    if (!this.isBatCap && ("InfoPower".equalsIgnoreCase(MyConstants.Customized) || "NetGuard".equalsIgnoreCase(MyConstants.Customized) || "ATMUSE".equalsIgnoreCase(MyConstants.Customized))) {
                        new Thread(){

                            @Override
                            public void run() {
                                P45Processor.this.isBatCap = true;
                                P45Processor.this.shutdownOnBatteryCapacity();
                            }
                        }.start();
                    }
                } else {
                    this.isBatCap = false;
                }
                this.workInfo.setBatteryCapacity(batteryCapacity);
                this.workInfo.setBatteryVoltage(datas[0]);
                this.workInfo.setPositiveBatteryVoltage(datas[0]);
                this.workInfo.setBatChargingCurrentP(datas[1]);
                this.workInfo.setBatDisChargingCurrentP(datas[2]);
                this.workInfo.setNegativeBatteryVoltage(datas[3]);
                this.workInfo.setBatChargingCurrentN(datas[4]);
                this.workInfo.setBatDisChargingCurrentN(datas[5]);
                this.workInfo.setBatteryRemainTime(Integer.parseInt(datas[7]));
            }
            String[] qiotValues = this.excuteCommand("SEC_QIOT", true).split(",");
            String inWireType = qiotValues[0];
            String outWireType = qiotValues[2];
            int intype = StrConvert.toInteger(inWireType);
            int outtype = StrConvert.toInteger(outWireType);
            if (intype == 0) {
                this.workInfo.setInputWireType(this.iwt3P4W);
            } else if (intype == 1) {
                this.workInfo.setInputWireType(this.iwt3P3W);
            } else {
                this.workInfo.setInputWireType("");
            }
            if (outtype == 0) {
                this.workInfo.setOutputWireType(this.owt3P4W);
            } else if (outtype == 1) {
                this.workInfo.setOutputWireType(this.owt3P3W);
            } else if (intype == 2) {
                this.workInfo.setInputWireType(this.ow1P);
            } else {
                this.workInfo.setOutputWireType("");
            }
            this.workInfo.setInputScaleFactor(qiotValues[1]);
            this.workInfo.setOutputScaleFactor(qiotValues[3]);
            String[] loads = this.excuteCommand("SEC_Q3LD", true).split(",");
            this.loadInfo.setMaxLoadPercentR(loads[0]);
            this.loadInfo.setMaxLoadPercentS(loads[1]);
            this.loadInfo.setMaxLoadPercentT(loads[2]);
            this.loadInfo.setMaxTotalPercent(loads[3]);
            this.loadInfo.setLoadVAPercentR(loads[4]);
            this.loadInfo.setLoadVAPercentS(loads[5]);
            this.loadInfo.setLoadVAPercentT(loads[6]);
            this.loadInfo.setLoadVATotalPercent(loads[7]);
            this.loadInfo.setLoadWattPercentR(loads[8]);
            this.loadInfo.setLoadWattPercentS(loads[9]);
            this.loadInfo.setLoadWattPercentT(loads[10]);
            this.loadInfo.setLoadWattTotalPercent(loads[11]);
            this.loadInfo.setLoadVAR(loads[12]);
            this.loadInfo.setLoadVAR(loads[13]);
            this.loadInfo.setLoadVAR(loads[14]);
            this.loadInfo.setLoadWattR(loads[15]);
            this.loadInfo.setLoadWattS(loads[16]);
            this.loadInfo.setLoadWattT(loads[17]);
            String[] qopfValues = this.excuteCommand("SEC_QOPF", true).split(",");
            this.workInfo.setOutputPowerFactorL1(qopfValues[0]);
            this.workInfo.setOutputPowerFactorL2(qopfValues[0]);
            this.workInfo.setOutputPowerFactorL3(qopfValues[0]);
            String qlfd = this.excuteCommand("SEC_QLFD", true);
            this.workInfo.setLastfaultID(qlfd);
            this.queryCapability();
            this.queryBypass();
            this.queryHighEfficiencyVoltage();
            this.queryLine();
            this.queryParameterSettings();
            this.workInfo.setFirst(false);
            this.workInfo.setClear(false);
            this.workInfo.setInsertInput(true);
            this.workInfo.setInsertBypass(true);
            this.workInfo.setInsertOutput(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.workInfo;
    }

    protected void setWarningStatus(String warnStatus) {
        this.workInfo.clearWarning();
        this.refreshWarningStatus(warnStatus, 0, "4004");
        this.refreshWarningStatus(warnStatus, 1, "1003");
        this.refreshWarningStatus(warnStatus, 2, "1004");
        this.refreshWarningStatus(warnStatus, 3, "1005");
        this.refreshWarningStatus(warnStatus, 4, "2003");
        this.refreshWarningStatus(warnStatus, 5, "2004");
        this.refreshWarningStatus(warnStatus, 6, "4006");
        this.refreshWarningStatus(warnStatus, 7, "4001");
        this.refreshWarningStatus(warnStatus, 8, "5002");
        this.refreshWarningStatus(warnStatus, 9, "3005");
        this.refreshWarningStatus(warnStatus, 10, "3006");
        this.refreshWarningStatus(warnStatus, 11, "3007");
        this.refreshWarningStatus(warnStatus, 12, "3008");
        this.refreshWarningStatus(warnStatus, 13, "3010");
        this.refreshWarningStatus(warnStatus, 14, "3011");
        this.refreshWarningStatus(warnStatus, 15, "3012");
        this.refreshWarningStatus(warnStatus, 16, "3013");
        this.refreshWarningStatus(warnStatus, 17, "3014");
        this.refreshWarningStatus(warnStatus, 18, "3015");
        this.refreshWarningStatus(warnStatus, 19, "3016");
        this.refreshWarningStatus(warnStatus, 20, "3017");
        this.refreshWarningStatus(warnStatus, 21, "3018");
        this.refreshWarningStatus(warnStatus, 22, "3019");
        this.refreshWarningStatus(warnStatus, 23, "3020");
        this.refreshWarningStatus(warnStatus, 24, "8001");
        this.refreshWarningStatus(warnStatus, 25, "8002");
        this.refreshWarningStatus(warnStatus, 26, "8003");
        this.refreshWarningStatus(warnStatus, 27, "8004");
        this.refreshWarningStatus(warnStatus, 28, "8005");
        this.refreshWarningStatus(warnStatus, 29, "8006");
        this.refreshWarningStatus(warnStatus, 30, "8007");
        this.refreshWarningStatus(warnStatus, 31, "8008");
        this.refreshWarningStatus(warnStatus, 32, "8009");
        this.refreshWarningStatus(warnStatus, 33, "8010");
        this.refreshWarningStatus(warnStatus, 34, "8011");
        this.refreshWarningStatus(warnStatus, 35, "8012");
        this.refreshWarningStatus(warnStatus, 36, "8013");
        this.refreshWarningStatus(warnStatus, 37, "8014");
        this.refreshWarningStatus(warnStatus, 38, "8015");
        this.refreshWarningStatus(warnStatus, 39, "8016");
        this.refreshWarningStatus(warnStatus, 40, "8017");
        this.refreshWarningStatus(warnStatus, 41, "8018");
        this.refreshWarningStatus(warnStatus, 42, "8019");
        this.refreshWarningStatus(warnStatus, 43, "8020");
        this.refreshWarningStatus(warnStatus, 44, "8021");
        this.refreshWarningStatus(warnStatus, 45, "8022");
        this.refreshWarningStatus(warnStatus, 46, "8023");
        this.refreshWarningStatus(warnStatus, 47, "8024");
        this.refreshWarningStatus(warnStatus, 48, "8025");
        this.refreshWarningStatus(warnStatus, 49, "8026");
        this.refreshWarningStatus(warnStatus, 50, "8032");
        this.refreshWarningStatus(warnStatus, 51, "8033");
        this.refreshWarningStatus(warnStatus, 52, "8034");
        this.refreshWarningStatus(warnStatus, 53, "8035");
        this.refreshWarningStatus(warnStatus, 54, "3048");
        this.refreshWarningStatus(warnStatus, 55, "3049");
        this.refreshWarningStatus(warnStatus, 56, "3101");
        this.refreshWarningStatus(warnStatus, 57, "3102");
        this.refreshWarningStatus(warnStatus, 58, "3567");
        this.refreshWarningStatus(warnStatus, 59, "3568");
        this.refreshWarningStatus(warnStatus, 60, "3569");
        this.refreshWarningStatus(warnStatus, 61, "4061");
        this.refreshWarningStatus(warnStatus, 62, "3570");
        this.refreshWarningStatus(warnStatus, 63, "3067");
        this.refreshWarningStatus(warnStatus, 64, "9003");
        this.refreshWarningStatus(warnStatus, 65, "9004");
        this.refreshWarningStatus(warnStatus, 66, "3516");
        this.refreshWarningStatus(warnStatus, 67, "4020");
        this.refreshWarningStatus(warnStatus, 68, "3509");
        this.refreshWarningStatus(warnStatus, 69, "3517");
        this.refreshWarningStatus(warnStatus, 70, "3565");
        this.refreshWarningStatus(warnStatus, 71, "3566");
    }

    protected void queryLine() {
        String[] values = this.excuteCommand("SEC_QRHL", true).split(",");
        this.line.setLineHighVoltage((int)StrConvert.toDouble(values[0]));
        this.line.setLineLowVoltage(Integer.parseInt(values[1]));
        this.line.setLineHighFrequency(Float.parseFloat(values[2]));
        this.line.setLineLowFrequency(Float.parseFloat(values[3]));
        values = this.excuteCommand("SEC_QRI", true).split(",");
        this._ratvol = (int)Float.parseFloat(values[0]);
        this._ratfre = (int)Float.parseFloat(values[3]);
        this.line.setMinLineLowVoltage(this._ratvol - 44);
        this.line.setMaxLineLowVoltage(this._ratvol - 15);
        this.line.setMinLineHighVoltage(this._ratvol + 15);
        this.line.setMaxLineHighVoltage(this._ratvol + 44);
        this.line.setMinLineLowFrequency((float)(this._ratfre - 5));
        this.line.setMaxLineLowFrequency((float)(this._ratfre - 1));
        this.line.setMinLineHighFrequency((float)(this._ratfre + 1));
        this.line.setMaxLineHighFrequency((float)(this._ratfre + 5));
    }

    @Override
    public LineVoltage getLine() throws IOException {
        return this.line;
    }

    public void queryBypass() throws IOException {
        if (this.bypass == null) {
            this.bypass = new Bypass();
        }
        String[] values = this.excuteCommand("SEC_QRHL", true).split(",");
        this.bypass.setBypassHighVoltage((int)StrConvert.toDouble(values[4]));
        this.bypass.setBypassLowVoltage(Integer.parseInt(values[5]));
        this.bypass.setBypassHighFrequency(Float.parseFloat(values[6]));
        this.bypass.setBypassLowFrequency(Float.parseFloat(values[7]));
        values = this.excuteCommand("SEC_QRI", true).split(",");
        this._ratvol = (int)Float.parseFloat(values[0]);
        this._ratfre = (int)Float.parseFloat(values[3]);
        this.bypass.setMinBypassLowVoltage(this._ratvol - 44);
        this.bypass.setMaxBypassLowVoltage(this._ratvol - 15);
        this.bypass.setMinBypassHighVoltage(this._ratvol + 15);
        this.bypass.setMaxBypassHighVoltage(this._ratvol + 44);
        this.bypass.setMinBypassLowFrequency((float)(this._ratfre - 5));
        this.bypass.setMaxBypassLowFrequency((float)(this._ratfre - 1));
        this.bypass.setMinBypassHighFrequency((float)(this._ratfre + 1));
        this.bypass.setMaxBypassHighFrequency((float)(this._ratfre + 5));
    }

    public void queryHighEfficiencyVoltage() throws IOException {
        if (this.voltage == null) {
            this.voltage = new HighEfficiencyVoltage();
        }
        String[] values = this.excuteCommand("SEC_QRHL", true).split(",");
        this.voltage.setHeh(Integer.parseInt(values[8]));
        this.voltage.setHel(Integer.parseInt(values[9]));
        this.voltage.setHeFh(Float.parseFloat(values[10]));
        this.voltage.setHeFl(Float.parseFloat(values[11]));
        values = this.excuteCommand("SEC_QRI", true).split(",");
        this._ratvol = (int)Float.parseFloat(values[0]);
        this._ratfre = (int)Float.parseFloat(values[3]);
        if (this._ratvol >= 200) {
            this.voltage.setMinHel(this._ratvol - 44);
            this.voltage.setMaxHel(this._ratvol - 10);
            this.voltage.setMinHeh(this._ratvol + 10);
            this.voltage.setMaxHeh(this._ratvol + 44);
        } else {
            this.voltage.setMinHel(this._ratvol - 12);
            this.voltage.setMaxHel(this._ratvol - 5);
            this.voltage.setMinHeh(this._ratvol + 5);
            this.voltage.setMaxHeh(this._ratvol + 12);
        }
        this.voltage.setMinHeFl((float)(this._ratfre - 5));
        this.voltage.setMaxHeFl((float)(this._ratfre - 1));
        this.voltage.setMinHeFh((float)(this._ratfre + 1));
        this.voltage.setMaxHeFh((float)(this._ratfre + 5));
    }

    public void queryParameterSettings() throws IOException {
        String[] queryQBRT = this.excuteCommand("SEC_QBRT", true).split(",");
        String batShutdownVol = queryQBRT[1];
        this.param.setBatShutdownVol(StrConvert.toDouble(batShutdownVol));
        String batLowVoltage = queryQBRT[2];
        this.param.setBatLowVoltage(StrConvert.toDouble(batLowVoltage));
        String batTotalAH = queryQBRT[3];
        this.batteryNumber.setBatTotalAHValue(StrConvert.toInteger(batTotalAH));
        String maxChargingCurrent = queryQBRT[4];
        this.param.setMaxChargingCurrent(StrConvert.toDouble(maxChargingCurrent));
        String batHighWarnVol = queryQBRT[5];
        this.param.setBatHighWarnVol(StrConvert.toDouble(batHighWarnVol));
        String batCellNumber = queryQBRT[6];
        this.batteryNumber.setBatn(StrConvert.toInteger(batCellNumber));
        String batDischargeTime = queryQBRT[7];
        if ("000".equals(batDischargeTime)) {
            batDischargeTime = "0";
        }
        this.param.setBatDischargerTime(StrConvert.toInteger(batDischargeTime));
        String modbusAddress = this.excuteCommand("SEC_QMAP", true);
        this.param.setModbusAddress(StrConvert.toInteger(modbusAddress));
        String[] queryQBTT = this.excuteCommand("SEC_QBTT", true).split(",");
        String batTestStopVol = queryQBTT[2];
        this.param.setBatTestStopVol(StrConvert.toDouble(batTestStopVol));
        String[] queryQMD = this.excuteCommand("SEC_QMD", true).split(",");
        String inputNominalVol = queryQMD[4];
        this.param.setInputNominalVol(StrConvert.toInteger(inputNominalVol));
        String outputNominalVol = queryQMD[5];
        this.param.setOutputNominalVol(StrConvert.toInteger(outputNominalVol));
        String outputVol = queryQMD[5];
        this.param.setOutputVol(StrConvert.toInteger(outputVol));
        String[] queryQ3GS = this.excuteCommand("SEC_Q3GS", true).split(",");
        String status = queryQ3GS[queryQ3GS.length - 1];
        if (status.charAt(6) == '1') {
            this.param.setEpoFunction(1);
        } else {
            this.param.setEpoFunction(0);
        }
        String outputFre = queryQ3GS[8];
        this.param.setOutputFre(StrConvert.toDouble(outputFre));
    }

    @Override
    public Date queryBID(String value) throws IOException {
        String[] dates = this.excuteCommand("SEC_QBDT", true).split(",");
        return this.getDate(dates[0]);
    }

    @Override
    public Date queryBMD(String value) throws IOException {
        String[] dates = this.excuteCommand("SEC_QBDT", true).split(",");
        return this.getDate(dates[1]);
    }

    @Override
    public Date querySID(String value) throws IOException {
        String[] dates = this.excuteCommand("SEC_QSDT", true).split(",");
        return this.getDate(dates[0]);
    }

    @Override
    public Date querySMD(String value) throws IOException {
        String[] dates = this.excuteCommand("SEC_QSDT", true).split(",");
        return this.getDate(dates[1]);
    }

    @Override
    public Date queryTIME() throws IOException {
        String dateStr = this.excuteCommand("SEC_QTIME", true);
        if (dateStr == null || dateStr.trim().length() == 0) {
            return new Date();
        }
        String day = dateStr.substring(0, 8);
        day = DateUtils.getFormatDate((Date)this.getDate(day));
        String time = dateStr.substring(8);
        time = String.valueOf(time.substring(0, 2)) + ":" + time.substring(2, 4) + ":" + time.substring(4, 6);
        Date date = DateUtils.parseTimestamp((String)(String.valueOf(day) + " " + time));
        return date;
    }

    protected Date getDate(String result) {
        Date date = null;
        date = "".equals(result) ? new Date() : DateUtils.getFormatyyyyMMdd((String)result);
        return date;
    }

    @Override
    public String setTotalCapacity(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "BATAH" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setBatn(int value) throws IOException {
        String str = String.format("%02d", value);
        String command = "BATN" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setBaud(int value) throws Exception {
        String str = String.format("%04d", value);
        String command = "BAUD" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String offBuzzerCtrl() throws IOException {
        String retStr = this.excuteSetCommand("BOFF", true);
        return "(" + retStr;
    }

    @Override
    public String onBuzzerCtrl() throws IOException {
        String retStr = this.excuteSetCommand("BON", true);
        return "(" + retStr;
    }

    @Override
    public String setCFTD() throws IOException {
        String reStr = this.excuteSetCommand("CFTD", true);
        if (reStr.equalsIgnoreCase(ACK)) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setCHMC(float value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf(value / (float)this.batteryNumber.getBatTotalAHValue()));
        String command = "CHMC" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setCHTC(int value) throws IOException {
        String str = String.format("%02d", value);
        String command = "CHTC" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setCLDL() throws IOException {
        String reStr = this.excuteSetCommand("CLDL", true);
        if (reStr.equalsIgnoreCase(ACK)) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String cancelSwitchCtrl() throws IOException {
        String retStr = this.excuteSetCommand("CS", true);
        return "(" + retStr;
    }

    @Override
    public String setMADD(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "MADD" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setFreh(float value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf(value));
        String command = "PHFH" + str;
        return "failure";
    }

    @Override
    public String setFrel(float value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf(value));
        String command = "PHFL" + str;
        return "failure";
    }

    @Override
    public String setHeh(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "PHVH" + str;
        return "failure";
    }

    @Override
    public String setHel(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "PHVL" + str;
        return "failure";
    }

    @Override
    public String setPFTD() throws IOException {
        String reStr = this.excuteSetCommand("PFTD", true);
        if (reStr.equalsIgnoreCase(ACK)) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setPLFH(float value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf(value));
        String command = "PLFH" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setPLFL(float value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf(value));
        String command = "PLFL" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setPLVH(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "PLVH" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setPLVL(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "PLVL" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setBypassHighFrequency(float value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf(value));
        float val = (value - Float.parseFloat(this.identity.getOutputRatingVoltage()) * 100.0f) / Float.parseFloat(this.identity.getOutputRatingVoltage());
        String command = "PSFH" + (long)val;
        return this.returnCommandValue(command);
    }

    @Override
    public String setBypassLowFrequency(float value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf(value));
        float val = -((value - Float.parseFloat(this.identity.getOutputRatingVoltage()) * 100.0f) / Float.parseFloat(this.identity.getOutputRatingVoltage()));
        String command = "PSFL" + val;
        return this.returnCommandValue(command);
    }

    @Override
    public String setBypassHighVoltage(int value) throws IOException {
        String str = String.format("%05.1f", Float.valueOf(value));
        int val = (value - Integer.parseInt(this.identity.getOutputRatingVoltage()) * 100) / Integer.parseInt(this.identity.getOutputRatingVoltage());
        String command = "PSVH" + val;
        return this.returnCommandValue(command);
    }

    public static void main(String[] args) {
        float var = 2.2f;
        System.out.println((long)var);
    }

    @Override
    public String setBypassLowVoltage(int value) throws IOException {
        int val = -((value - Integer.parseInt(this.identity.getOutputRatingVoltage()) * 100) / Integer.parseInt(this.identity.getOutputRatingVoltage()));
        String command = "PSVL" + val;
        return this.returnCommandValue(command);
    }

    @Override
    public String setREEP() throws IOException {
        String reStr = this.excuteSetCommand("REEP", true);
        if (reStr.equalsIgnoreCase(ACK)) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setSBDT(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "SBDT" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setSBHV(float value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf(value));
        String command = "SBHV" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setBID(String id, Date selectDate) throws IOException {
        String value = DateUtils.getFormatyyyyMMdd((Date)selectDate);
        String command = "SBID" + id + value;
        return this.returnCommandValue(command);
    }

    @Override
    public String setBatLowVoltage(double value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf((float)value));
        String command = "SBLV" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setBMD(String id, Date selectDate) throws IOException {
        String value = DateUtils.getFormatyyyyMMdd((Date)selectDate);
        String command = "SBMD" + id + value;
        return this.returnCommandValue(command);
    }

    @Override
    public String setSBNV(float value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf(value));
        String command = "SBNV" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setSBSV(float value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf(value));
        String command = "SBSV" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setSBTT(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "SBTT" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setSBTV(float value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf(value));
        String command = "SBTV" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setEpoFunction(int value) throws IOException {
        String command = "SEAF" + value;
        return this.returnCommandValue(command);
    }

    @Override
    public String setSIPT(int value1, int value2) throws IOException {
        String str = String.format("%03d", value2);
        String command = "SIPT" + value1 + "," + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setSIPV(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "SIPV" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setSOPV(int value) throws IOException {
        String command = "SOPV" + value;
        return this.returnCommandValue(command);
    }

    @Override
    public String offSwitchCtrl() throws IOException {
        String delayShutdownTime = this.getDelayShutdownTime();
        String command = "SN" + delayShutdownTime;
        return this.excuteSetCommand(command, true);
    }

    @Override
    public String onSwitchCtrlOntime() throws IOException {
        String retStr = this.excuteSetCommand("SON", true);
        return "(" + retStr;
    }

    @Override
    public String offSwitchCtrlOntime() throws IOException {
        String retStr = this.excuteSetCommand("SOFF", true);
        return "(" + retStr;
    }

    @Override
    public String setSOPF(float value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf(value));
        String command = "SOPF" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setSOPT(int value1, int value2) throws IOException {
        String str = String.format("%03d", value2);
        String command = "SOPT" + value1 + "," + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setCapability(String x, boolean isEnable) throws IOException {
        String command = isEnable ? "SPE" : "SPD";
        String returnData = this.excuteSetCommand(command = String.valueOf(command) + x, true);
        if (returnData.equalsIgnoreCase(ACK)) {
            return "success," + x;
        }
        return "failure," + x;
    }

    @Override
    public String offSwitchCtrlOntime(int minutes) throws IOException {
        minutes = minutes > 9999 ? 9999 : minutes;
        DecimalFormat df3 = new DecimalFormat("0000");
        String turnOnDelay = df3.format(minutes);
        String command = "";
        String commandShutdown = "";
        commandShutdown = "SN.2";
        command = "SR" + turnOnDelay;
        String recmd1 = "";
        String recmd2 = "";
        int times = 0;
        do {
            try {
                recmd1 = this.excuteSetCommand(commandShutdown, true);
                if (ACK.equals(recmd1) && ACK.equals(recmd2 = this.excuteSetCommand(command, true))) {
                    System.out.println("ok!");
                    break;
                }
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (times++ < this.count);
        return ACK;
    }

    @Override
    public String setSID(String id, Date selectDate) throws IOException {
        String value = DateUtils.getFormatyyyyMMdd((Date)selectDate);
        String command = "SSID" + id + value;
        return this.returnCommandValue(command);
    }

    @Override
    public String setSMD(String id, Date selectDate) throws IOException {
        String value = DateUtils.getFormatyyyyMMdd((Date)selectDate);
        String command = "SSMD" + value;
        return this.returnCommandValue(command);
    }

    @Override
    public String setSSTN(int value1, int value2) throws IOException {
        String command = "SSTN" + value1 + "," + value2;
        return this.returnCommandValue(command);
    }

    @Override
    public String setSTIME(Date selectDate) throws IOException {
        String value = DateUtils.getFormatHHmmss((Date)selectDate);
        value = value.replace(":", "");
        String command = "STIME" + value;
        return this.returnCommandValue(command);
    }

    @Override
    public String setSVOL(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "SVOL" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String turnToBypass() throws IOException {
        String retStr = this.excuteSetCommand("TBYP", true);
        return "(" + retStr;
    }

    @Override
    public String setSPWIT(int value) throws IOException {
        String str = String.format("%02d", value);
        String command = "SPWIT" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setSPWID(int value) throws IOException {
        String str = String.format("%04d", value);
        String command = "SPWID" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setSBLF(int value) throws IOException {
        String command = "SBLF" + value;
        return this.returnCommandValue(command);
    }

    @Override
    public String setSMOD(int value) throws IOException {
        String str = String.format("%02d", value);
        String command = "SMOD" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setSDATE(String id, Date selectDate) throws IOException {
        String value = DateUtils.getFormatyyyyMMdd((Date)selectDate);
        String command = "SDATE" + id + value;
        return this.returnCommandValue(command);
    }

    @Override
    public String setSABTP(int type, int weekday, int hour, int minute, int month, int day) throws IOException {
        String hourStr = String.format("%02d", hour);
        String minuteStr = String.format("%02d", minute);
        String monthStr = String.format("%02d", month);
        String dayStr = String.format("%02d", day);
        String command = "SABTP" + type + "," + weekday + "," + hourStr + "," + minuteStr + "," + monthStr + "," + dayStr;
        return this.returnCommandValue(command);
    }

    @Override
    public String tenSencondsBatteryTestCtrl() throws IOException {
        String retStr = this.excuteSetCommand("T10", true);
        return "(" + retStr;
    }

    @Override
    public String munitesBatteryTestCtrl(float minute) throws IOException, UnsupportException {
        String commandStr = "TN";
        commandStr = minute < 1.0f ? String.valueOf(commandStr) + String.valueOf(minute).substring(1, 3) : (minute < 10.0f ? String.valueOf(commandStr) + "0" + (int)minute : String.valueOf(commandStr) + String.valueOf((int)minute));
        String retStr = this.excuteSetCommand(commandStr, true);
        return "(" + retStr;
    }

    @Override
    public String deepBatteryTestCtrl() throws IOException, UnsupportException {
        String retStr = this.excuteSetCommand("TL", true);
        return "(" + retStr;
    }

    @Override
    public void testOperation() throws IOException {
        this.excuteSetCommand("TL", true);
    }

    @Override
    protected String returnCommandValue(String command) {
        String returnData = this.excuteSetCommand(command, true);
        if (returnData.equalsIgnoreCase(ACK)) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String cancelBatteryTest() throws IOException {
        String retStr = this.excuteSetCommand("CT", true);
        return "(" + retStr;
    }

    @Override
    public void offSwitchCtrl(int minutes) throws IOException {
        String delayShutdownTime = this.getDelayShutdownTime();
        minutes = minutes > 9999 ? 9999 : minutes;
        DecimalFormat df3 = new DecimalFormat("0000");
        String turnOnDelay = df3.format(minutes);
        String commandShut = null;
        String commandReset = null;
        commandShut = "SN" + delayShutdownTime;
        commandReset = "SR" + turnOnDelay;
        String recmd1 = "";
        String recmd2 = "";
        int times = 0;
        do {
            try {
                recmd1 = this.excuteSetCommand(commandShut, true);
                if (ACK.equals(recmd1) && ACK.equals(recmd2 = this.excuteSetCommand(commandReset, true))) break;
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (times++ < this.count);
    }

    @Override
    public String queryQBT() throws IOException {
        return null;
    }

    @Override
    public String queryQGR() throws IOException {
        return null;
    }

    @Override
    public boolean setPBT(String value) throws IOException {
        return false;
    }

    @Override
    public boolean setPGR(String value) throws IOException {
        return false;
    }

    @Override
    public boolean isSupportBatNum() throws IOException {
        return false;
    }
}

