/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.processor;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.data.bean.Bypass;
import cn.com.voltronicpower.data.bean.Capability;
import cn.com.voltronicpower.data.bean.HighEfficiencyVoltage;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.exception.FaultHandler;
import cn.com.voltronicpower.monitor.processor.P35Processor;
import cn.com.voltronicpower.utilities.StrConvert;
import java.io.IOException;
import java.util.Date;
import org.springframework.beans.BeanWrapperImpl;

public class P40Processor
extends P35Processor {
    private Capability capability = new Capability();

    public P40Processor(CommunicateHandlerInterface handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public void queryUpsInfo() throws IOException {
        Object datas = null;
        String returnData = this.excuteCommand("SEC_BATN?", true);
        this.batteryNumber.setBatn(Integer.parseInt(returnData));
        returnData = this.excuteCommand("SEC_OPV?", true);
        this.identity.setOutputRatingVoltage(returnData);
        this.ratingInfo.setOutputRatingVoltage(returnData);
        this.identity.setMorphological("on-line");
        String par = this.excuteCommand("SEC_PAR", true);
        if (par.equals("31")) {
            this.identity.setIoPhase("3/1");
        } else if (par.equals("33")) {
            this.identity.setIoPhase("3/3");
        } else {
            this.identity.setIoPhase("3/1");
        }
        this.workInfo.setIoPhase(this.identity.getIoPhase());
        returnData = this.excuteCommand("SEC_USID?", true);
        this.identity.setProductSN(returnData);
        returnData = this.excuteCommand("SEC_QVER", true);
        this.identity.setDspFwVersion(returnData.split(",")[0]);
        this.identity.setMcuFwVersion(returnData.split(",")[1]);
        this.identity.setFwVersion(returnData.split(",")[0]);
        returnData = this.excuteCommand("SEC_QRI", true);
        String[] ret = returnData.split(",");
        this.ratingInfo.setRatedCapacity(ret[0]);
        this.ratingInfo.setOutputRatingVoltage(ret[1]);
        this.ratingInfo.setOutputRatingFrequency(ret[2]);
        this.ratingInfo.setOutputRatingCurrent(ret[3]);
        this.ratingInfo.setBatteryVoltage(ret[4]);
    }

    @Override
    protected void setWarningStatus(String warnStatus) {
        this.workInfo.clearWarning();
        String[] status = warnStatus.split(",");
        this.refreshWarningStatus(status[4], 2, "3700");
        this.refreshWarningStatus(status[4], 3, "3753");
        this.refreshWarningStatus(status[5], 0, "3701");
        this.refreshWarningStatus(status[5], 2, "4061");
        this.refreshWarningStatus(status[5], 3, "3703");
        this.refreshWarningStatus(status[6], 0, "2004");
        this.refreshWarningStatus(status[6], 1, "3790");
        this.refreshWarningStatus(status[6], 2, "3006");
        this.refreshWarningStatus(status[6], 3, "5002");
        this.refreshWarningStatus(status[7], 0, "3617");
        this.refreshWarningStatus(status[7], 1, "8014");
        this.refreshWarningStatus(status[7], 2, "3739");
        this.refreshWarningStatus(status[7], 3, "4004");
    }

    @Override
    public WorkInfo queryWorkInfo() {
        try {
            this.workInfo.setPtid(this.protocol.getProtocolID());
            this.workInfo.setCurrentTime(new Date());
            this.workInfo.setDeviceId(this.getDeviceId());
            String returnData = this.excuteCommand("SEC_QGS1", true);
            String[] datas = returnData.split(",");
            this.workInfo.setInputVoltage(datas[0]);
            this.workInfo.setInputVoltageS(datas[1]);
            this.workInfo.setInputVoltageT(datas[2]);
            this.workInfo.setInputFrequency(datas[3]);
            this.workInfo.setOutputVoltage(datas[11]);
            this.workInfo.setOutputVoltageS(datas[12]);
            this.workInfo.setOutputVoltageT(datas[13]);
            this.workInfo.setOutputCurrent(datas[15]);
            this.workInfo.setOutputCurrentS(datas[16]);
            this.workInfo.setOutputCurrentT(datas[17]);
            this.workInfo.setOutputFrequency(datas[14]);
            String par = this.excuteCommand("SEC_PAR", true);
            if (par.equals("31")) {
                this.workInfo.setBypassVoltage(datas[18]);
                this.workInfo.setBypassFrequency(datas[19]);
            } else {
                this.workInfo.setBypassVoltage(datas[18]);
                this.workInfo.setBypassVoltageS(datas[20]);
                this.workInfo.setBypassVoltageT(datas[21]);
                this.workInfo.setBypassFrequency(datas[19]);
            }
            this.workInfo.setBypassVoltage(datas[18]);
            this.workInfo.setBypassFrequency(datas[19]);
            returnData = this.excuteCommand("SEC_QGS2", true);
            datas = returnData.split(",");
            this.currentWorkMode = datas[0];
            this.workInfo.setLoadLevel(datas[13]);
            this.workInfo.setLoadLevelS(datas[14]);
            this.workInfo.setLoadLevelT(datas[15]);
            this.workInfo.setOutputLoadPercent(datas[13]);
            this.workInfo.setBatteryVoltage(datas[18]);
            if (this.workInfo.isFirst()) {
                if (Double.parseDouble(this.workInfo.getInputVoltage()) <= 20.0) {
                    EventsHandler.putEvent(this.getDeviceName(), "1001");
                } else if (Double.parseDouble(this.workInfo.getInputVoltage()) > 20.0) {
                    EventsHandler.putEvent(this.getDeviceName(), "1002");
                }
            } else if (Double.parseDouble(this.workInfo.getInputVoltage()) <= 20.0) {
                EventsHandler.removeEvent(this.getDeviceName(), "1002");
                EventsHandler.handleEvent(this.getDeviceName(), "1001", "P40", this.getDeviceId(), true);
            } else if (Double.parseDouble(this.workInfo.getInputVoltage()) > 20.0) {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
                EventsHandler.handleEvent(this.getDeviceName(), "1002", "P40", this.getDeviceId(), true);
            }
            returnData = this.excuteCommand("SEC_BCAP?", true);
            this.workInfo.setTemp2(returnData);
            this.workInfo.setTemp1(Config.getString("showO"));
            String batteryCapaPercent = this.excuteCommand("SEC_QCHG", true);
            String[] bcp = batteryCapaPercent.split(",");
            if (bcp.length == 7 && Boolean.parseBoolean(this.workInfo.getTemp1())) {
                this.workInfo.setBatteryCapacity(Integer.parseInt(bcp[6]));
            }
            String[] QGS3 = this.excuteCommand("SEC_QGS3", true).split(",");
            this.workInfo.setBatteryCapacity(Integer.parseInt(QGS3[QGS3.length - 1]));
            String warnStatus = this.excuteCommand("SEC_QPIWS", true);
            this.setWarningStatus(warnStatus);
            this.currentWorkMode = returnData = datas[0];
            String[] ret = this.excuteCommand("SEC_PEPD?", true).split(",");
            this.workInfo.setBypassActive(ret[4].equals("E0"));
            if (returnData.equals("01")) {
                this.workInfo.setWorkMode("Power on mode");
                this.isBatMod = false;
            } else if (returnData.equals("02")) {
                this.workInfo.setWorkMode("Standby mode");
                this.isBatMod = false;
            } else if (returnData.equals("04")) {
                this.workInfo.setWorkMode("Bypass mode");
                this.isBatMod = false;
            } else if (returnData.equals("03")) {
                if (ret[1].equals("B1")) {
                    this.workInfo.setWorkMode("Converter mode");
                } else {
                    this.workInfo.setWorkMode("Line mode");
                }
                this.isBatMod = false;
            } else if (returnData.equals("05")) {
                this.workInfo.setWorkMode("Battery mode");
                if (!this.isBatMod) {
                    this.shutdownOnBatteryMode();
                }
                this.isBatMod = true;
            } else if (returnData.equals("06")) {
                this.workInfo.setWorkMode("ECO mode");
                this.isBatMod = false;
            } else if (returnData.equals("07")) {
                this.workInfo.setWorkMode("Fault mode");
                String faultCode = this.excuteCommand("SEC_QFAULT0", true);
                if (faultCode != null && !faultCode.equals("")) {
                    String faultKind = faultCode.split(",")[0];
                    FaultHandler.doFaultEventP40(faultKind, this.getDeviceName(), this.protocol.getProtocolID(), this.getDeviceId());
                    this.workInfo.setFaultKind(faultKind);
                }
                this.isBatMod = false;
            } else if (returnData.equals("09")) {
                this.workInfo.setWorkMode("Battery test mode");
                this.isBatMod = false;
            } else if (returnData.equals("08")) {
                this.workInfo.setWorkMode("Shutdown mode");
                this.isBatMod = false;
            }
            this.workInfo.setMorphological("on-line");
            if (this.workInfo.isFirst()) {
                if (this.workInfo.isBypassActive()) {
                    EventsHandler.putEvent(this.getDeviceName(), "2001");
                } else {
                    EventsHandler.putEvent(this.getDeviceName(), "2002");
                }
            } else if (this.workInfo.isBypassActive()) {
                EventsHandler.removeEvent(this.getDeviceName(), "2002");
                EventsHandler.handleEvent(this.getDeviceName(), "2001", "P40", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "2001");
                EventsHandler.handleEvent(this.getDeviceName(), "2002", "P40", this.getDeviceId(), true);
            }
            this.queryCapability();
            this.queryBypass();
            this.queryHighEfficiencyVoltage();
            this.queryLine();
            this.queryParameterSettings();
            this.workInfo.setFirst(false);
            this.workInfo.setClear(false);
            this.workInfo.setInsertInput(true);
            this.workInfo.setInsertBypass(true);
            this.workInfo.setInsertOutput(true);
            this.reconnectTimes = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logingCommunicateException(false);
        }
        return this.workInfo;
    }

    @Override
    public void queryBypass() throws IOException {
        if (this.bypass == null) {
            this.bypass = new Bypass();
        }
        String[] values = this.excuteCommand("SEC_SBVL?", true).split(",");
        this.bypass.setBypassHighVoltage(Integer.parseInt(values[0]));
        this.bypass.setBypassLowVoltage(Integer.parseInt(values[1]));
        values = this.excuteCommand("SEC_SBFL?", true).split(",");
        this.bypass.setBypassHighFrequency(Float.parseFloat(values[0]));
        this.bypass.setBypassLowFrequency(Float.parseFloat(values[1]));
        this._ratfre = Integer.parseInt(this.excuteCommand("SEC_OPF?", true));
        this.bypass.setMinBypassLowVoltage(165);
        this.bypass.setMaxBypassLowVoltage(225);
        this.bypass.setMinBypassHighVoltage(235);
        this.bypass.setMaxBypassHighVoltage(285);
        this.bypass.setMinBypassLowFrequency((float)(this._ratfre - 5));
        this.bypass.setMaxBypassLowFrequency((float)(this._ratfre - 1));
        this.bypass.setMinBypassHighFrequency((float)(this._ratfre + 1));
        this.bypass.setMaxBypassHighFrequency((float)(this._ratfre + 6));
    }

    @Override
    public void queryHighEfficiencyVoltage() throws IOException {
        if (this.voltage == null) {
            this.voltage = new HighEfficiencyVoltage();
        }
        String[] values = this.excuteCommand("SEC_SEVL?", true).split(",");
        this.voltage.setHeh(Integer.parseInt(values[0]));
        this.voltage.setHel(Integer.parseInt(values[1]));
        values = this.excuteCommand("SEC_SEFL?", true).split(",");
        this.voltage.setHeFh(Float.parseFloat(values[0]));
        this.voltage.setHeFl(Float.parseFloat(values[1]));
        values = this.excuteCommand("SEC_QRI", true).split(",");
        this._ratfre = Integer.parseInt(this.excuteCommand("SEC_OPF?", true));
        this.voltage.setMinHel(165);
        this.voltage.setMaxHel(225);
        this.voltage.setMinHeh(235);
        this.voltage.setMaxHeh(285);
        this.voltage.setMinHeFl((float)(this._ratfre - 5));
        this.voltage.setMaxHeFl((float)(this._ratfre - 1));
        this.voltage.setMinHeFh((float)(this._ratfre + 1));
        this.voltage.setMaxHeFh((float)(this._ratfre + 6));
    }

    @Override
    protected void queryLine() {
        String[] values = this.excuteCommand("SEC_SGVL?", true).split(",");
        this.line.setLineHighVoltage((int)StrConvert.toDouble(values[0]));
        this.line.setLineLowVoltage(Integer.parseInt(values[1]));
        values = this.excuteCommand("SEC_SGFL?", true).split(",");
        this.line.setLineHighFrequency(Float.parseFloat(values[0]));
        this.line.setLineLowFrequency(Float.parseFloat(values[1]));
        this._ratfre = Integer.parseInt(this.excuteCommand("SEC_OPF?", true));
        this.line.setMinLineLowVoltage(165);
        this.line.setMaxLineLowVoltage(225);
        this.line.setMinLineHighVoltage(235);
        this.line.setMaxLineHighVoltage(285);
        this.line.setMinLineLowFrequency(40.0f);
        this.line.setMaxLineLowFrequency(Float.parseFloat(values[0]) - 1.0f);
        this.line.setMinLineHighFrequency(Float.parseFloat(values[1]) + 1.0f);
        this.line.setMaxLineHighFrequency(70.0f);
    }

    @Override
    public void queryCapability() throws IOException {
        String[] ret = this.excuteCommand("SEC_PEPD?", true).split(",");
        BeanWrapperImpl configWrapper = new BeanWrapperImpl((Object)this.capability);
        String[] stringArray = ret;
        int n = ret.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            String capable = "capable" + str.substring(0, 1);
            String enable = "enable" + str.substring(0, 1);
            configWrapper.setPropertyValue(capable, (Object)true);
            boolean enORdis = str.endsWith("1");
            configWrapper.setPropertyValue(enable, (Object)enORdis);
            ++n2;
        }
        configWrapper.setPropertyValue("capableO", (Object)Boolean.parseBoolean(Config.getString("showO")));
        configWrapper.setPropertyValue("enableO", (Object)Boolean.parseBoolean(Config.getString("showO")));
    }

    @Override
    public Capability getCapability() throws IOException {
        return this.capability;
    }

    @Override
    public void queryParameterSettings() throws IOException {
        String[] ret = this.excuteCommand("SEC_QCHGMS", true).split(",");
        this.param.setBulkV(ret[0]);
        this.param.setFloatV(ret[1]);
        this.param.setChargeA(ret[2]);
        this.param.setC2FV_time(ret[3]);
        ret = this.excuteCommand("SEC_QCHG", true).split(",");
        this.param.setRT_busV(ret[0]);
        this.param.setRT_chargV(ret[1]);
        this.param.setChargerTemp(Integer.parseInt(ret[4]));
        this.param.setRT_chargStage(ret[5]);
        String returnData = this.excuteCommand("SEC_BATN?", true);
        this.param.setBatNum(returnData);
        returnData = this.excuteCommand("SEC_BATT?", true);
        this.param.setBatTT(Integer.parseInt(returnData));
        returnData = this.excuteCommand("SEC_USID?", true);
        this.param.setUserId(returnData);
        returnData = this.excuteCommand("SEC_BATN?", true);
        this.param.setBatNum(returnData);
        returnData = this.excuteCommand("SEC_BCAP?", true);
        this.batteryNumber.setBatTotalAHValue(Integer.parseInt(returnData));
    }

    @Override
    public String setPLFH(float value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf(value));
        String command = "SET_SGFLH" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setPLFL(float value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf(value));
        String command = "SET_SGFLL" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setPLVH(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "SET_SGVLH" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setPLVL(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "SET_SGVLL" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setBypassHighFrequency(float value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf(value));
        String command = "SET_SBFLH" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setBypassLowFrequency(float value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf(value));
        String command = "SET_SBFLL" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setBypassHighVoltage(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "SET_SBVLH" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setBypassLowVoltage(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "SET_SBVLL" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setFreh(float value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf(value));
        String command = "SET_SEFLH" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setFrel(float value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf(value));
        String command = "SET_SEFLL" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setHeh(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "SET_SEVLH" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setHel(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "SET_SEVLL" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setBatn(int value) throws IOException {
        String str = String.format("%02d", value);
        String command = "SET_BATN" + str;
        System.out.println("batn: " + command);
        return this.returnCommandValue(command);
    }

    @Override
    protected String returnCommandValue(String command) {
        String returnData = this.excuteSetCommand(command, true);
        if (returnData.substring(0, 3).equalsIgnoreCase("ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setCHMC(float value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf(value));
        String command = "CHGI" + str;
        return this.returnCommandValue(command);
    }

    @Override
    public String setCapability(String x, boolean isEnable) throws IOException {
        if (x.equals("O")) {
            Config.updateProperty("showO", String.valueOf(isEnable));
            Config.refreashProperties();
        }
        String command = "SET_PEPD";
        System.out.println("-------x:" + x + "," + isEnable);
        String state = isEnable ? "E" : "D";
        command = String.valueOf(command) + state + x;
        System.out.println("setCapability:" + command);
        String returnData = this.excuteSetCommand(command, true);
        System.out.println("returnSET:" + returnData.substring(0, 3));
        if (returnData.substring(0, 3).equalsIgnoreCase("ACK")) {
            return "success," + x;
        }
        return "failure," + x;
    }

    @Override
    public String onSwitchCtrlOntime() throws IOException {
        String retStr = this.excuteSetCommand("SET_SON", true);
        return "(" + retStr.substring(0, 3);
    }

    @Override
    public String offSwitchCtrlOntime() throws IOException {
        String retStr = this.excuteSetCommand("SET_SOFF", true);
        return "(" + retStr.substring(0, 3);
    }

    @Override
    public String tenSencondsBatteryTestCtrl() throws IOException {
        String command = "SET_BATTEST1";
        String retStr = this.excuteSetCommand(command, true);
        return "(" + retStr.substring(0, 3);
    }

    @Override
    public String deepBatteryTestCtrl() throws IOException {
        String command = "SET_BATTEST1";
        String retStr = this.excuteSetCommand(command, true);
        return "(" + retStr.substring(0, 3);
    }

    @Override
    public void testOperation() throws IOException {
        String command = "SET_BATTEST1";
        String retStr = this.excuteSetCommand(command, true);
    }

    @Override
    public String cancelBatteryTest() throws IOException {
        String command = "SET_BATTEST0";
        String retStr = this.excuteSetCommand(command, true);
        return "(" + retStr.substring(0, 3);
    }

    @Override
    public String setBULKV(float value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf(value));
        String command = "SEC_BULKV" + str;
        System.out.println("bulk--------:" + command);
        String retStr = this.excuteSetCommand(command, true);
        return "(" + retStr.substring(0, 3);
    }

    @Override
    public String setFLATV(float value) throws IOException {
        String str = String.format("%04.1f", Float.valueOf(value));
        String command = "SEC_FLATV" + str;
        String retStr = this.excuteSetCommand(command, true);
        return "(" + retStr.substring(0, 3);
    }

    @Override
    public String setCTFT(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "SEC_CTFT" + str;
        String retStr = this.excuteSetCommand(command, true);
        return "(" + retStr.substring(0, 3);
    }

    @Override
    public String setUSID(String value) throws IOException {
        String command = "SEC_USID" + value;
        String retStr = this.excuteSetCommand(command, true);
        return "(" + retStr.substring(0, 3);
    }

    @Override
    public String setBATT(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "SET_BATT" + str;
        String retStr = this.excuteSetCommand(command, true);
        return "(" + retStr.substring(0, 3);
    }

    @Override
    public String setTotalCapacity(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "SET_BCAP" + str;
        System.out.println("set bcap  command: " + command);
        return this.returnCommandValue(command);
    }

    @Override
    public synchronized String excuteCommand(String command, boolean isResponse) {
        boolean result = true;
        String rts = "";
        try {
            rts = this._handler.excuteCommandP40(command, isResponse);
            if (rts == null || "".equals(rts)) {
                result = false;
            }
        }
        catch (Exception ex) {
            result = false;
        }
        return rts;
    }

    @Override
    public synchronized String excuteSetCommand(String command, boolean isResponse) {
        boolean result = true;
        String rts = "";
        try {
            rts = this._handler.excuteSetCommandP40(command, isResponse);
            if (rts == null || "".equals(rts)) {
                result = false;
            }
        }
        catch (Exception ex) {
            result = false;
        }
        return rts;
    }
}

