/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.processor;

import cn.com.voltronic.util.DateUtils;
import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.data.bean.BatLowVoltage;
import cn.com.voltronicpower.data.bean.Bypass;
import cn.com.voltronicpower.data.bean.Capability;
import cn.com.voltronicpower.data.bean.HighEfficiencyVoltage;
import cn.com.voltronicpower.data.bean.PhaseAngle;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.data.bean.UPSModuleInfo;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.exception.FaultHandler;
import cn.com.voltronicpower.exception.UnsupportException;
import cn.com.voltronicpower.monitor.AbstractMonitorProcessor;
import cn.com.voltronicpower.monitor.protocol.P39;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.utilities.StrConvert;
import cn.com.voltronicpower.work.BatteryTestEndHandler;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeanWrapperImpl;

public class P39Processor
extends AbstractMonitorProcessor {
    private static final Log log = new Log();
    private float _ratvol = 220.0f;
    private float _ratfre = 50.0f;
    private Capability capability = new Capability();

    public P39Processor(CommunicateHandlerInterface handler, IProtocol protocol) {
        super(handler, protocol);
    }

    private void queryCapability() throws IOException {
        String enableName;
        String fieldName;
        String ctrlName;
        String returnData = this.excuteCommand("QFLAG", true);
        String[] datas = returnData.split("D");
        String enables = datas[0].substring(2);
        String disables = "";
        if (datas.length > 1) {
            disables = datas[1];
        }
        BeanWrapperImpl configWrapper = new BeanWrapperImpl((Object)this.capability);
        int i = 0;
        while (i < enables.length()) {
            ctrlName = enables.substring(i, i + 1).toUpperCase();
            fieldName = "capable" + ctrlName;
            enableName = "enable" + ctrlName;
            try {
                configWrapper.setPropertyValue(fieldName, (Object)true);
                configWrapper.setPropertyValue(enableName, (Object)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        i = 0;
        while (i < disables.length()) {
            ctrlName = disables.substring(i, i + 1).toUpperCase();
            fieldName = "capable" + ctrlName;
            enableName = "enable" + ctrlName;
            try {
                configWrapper.setPropertyValue(fieldName, (Object)false);
                configWrapper.setPropertyValue(enableName, (Object)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    @Override
    public String setBypassHighVoltage(int value) throws IOException {
        String command = "PHV" + value;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setBypassLowVoltage(int value) throws IOException {
        String command;
        String returnData;
        String vlow = String.valueOf(value);
        if (value < 100) {
            vlow = "0" + vlow;
        }
        if ((returnData = this.excuteCommand(command = "PLV" + vlow, true)).equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setBypassHighFrequency(float value) throws IOException {
        int diff = 0;
        if (value > this._ratfre) {
            diff = (int)(value - this._ratfre);
            String command = "PSF" + diff;
            String returnData = this.excuteCommand(command, true);
            if (returnData.equalsIgnoreCase("(ACK")) {
                return "success";
            }
            return "failure";
        }
        return "failure";
    }

    @Override
    public String setBypassLowFrequency(float value) throws IOException {
        int diff = 0;
        if (this._ratfre > value) {
            diff = (int)(this._ratfre - value);
            String command = "PSF" + diff;
            String returnData = this.excuteCommand(command, true);
            if (returnData.equalsIgnoreCase("(ACK")) {
                return "success";
            }
            return "failure";
        }
        return "failure";
    }

    @Override
    public void queryUpsInfo() throws IOException {
        String[] datas;
        block12: {
            datas = null;
            this.identity.setMorphological("on-line");
            String dataStr = this.excuteCommand("QMD", true);
            String rateCap = dataStr.substring(17, 24).replace("#", "");
            this.ratingInfo.setRatedCapacity(String.valueOf(Integer.parseInt(rateCap)));
            String phase = dataStr.substring(29, 32);
            this.identity.setIoPhase(phase);
            this.workInfo.setIoPhase(phase);
            String InRateV = dataStr.substring(33, 36);
            this.identity.setInputRatingVoltage(InRateV);
            String OutRateV = dataStr.substring(37, 40);
            this.identity.setOutputRatingVoltage(OutRateV);
            String sn = "";
            try {
                try {
                    Thread.sleep(100L);
                    sn = this.excuteCommand("QID", true);
                    sn = "(NAK".equals(sn) ? "----" : (!"".equals(sn.trim()) ? sn.substring(4) : "");
                }
                catch (Exception exception) {
                    this.identity.setProductSN(sn);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                this.identity.setProductSN(sn);
                throw throwable;
            }
            this.identity.setProductSN(sn);
        }
        datas = this.excuteCommand("QRI", true).split(" ");
        this.ratingInfo.setOutputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.identity.setInputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.identity.setOutputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.ratingInfo.setOutputRatingFrequency(String.valueOf(Float.parseFloat(datas[3])));
        this.ratingInfo.setOutputRatingCurrent(String.valueOf(Integer.parseInt(datas[1])));
        this.ratingInfo.setBatteryVoltage(String.valueOf(Float.parseFloat(datas[2])));
        datas = this.excuteCommand("QBV", true).split(" ");
        String qvfw = this.excuteCommand("QVFW", true);
        qvfw = qvfw.substring(qvfw.indexOf(".") + 1);
        int version = StrConvert.toInteger(qvfw);
        if (version < 50) {
            this.batteryNumber.setBatn(Integer.parseInt(datas[1]));
        } else {
            this.batteryNumber.setBatn(10);
        }
        this.batteryNumber.setBatAHvalue(Integer.parseInt(datas[2]));
        String value = "";
        try {
            try {
                value = this.excuteCommand("QVFW", true);
            }
            catch (Exception exception) {
                this.identity.setFwVersion(value);
            }
        }
        finally {
            this.identity.setFwVersion(value);
        }
    }

    @Override
    public String queryQBT() throws IOException {
        return null;
    }

    @Override
    public String queryQGR() throws IOException {
        return null;
    }

    @Override
    public boolean setPBT(String value) throws IOException {
        return false;
    }

    @Override
    public boolean setPGR(String value) throws IOException {
        return false;
    }

    private void setWarningStatus(String sn, String warnStatus) {
        this.workInfo.clearWarning();
        warnStatus = warnStatus.substring(1);
        this.refreshWarningStatus(warnStatus, 0, "3617", sn);
        this.refreshWarningStatus(warnStatus, 1, "4004", sn);
        this.refreshWarningStatus(warnStatus, 2, "3602", sn);
        this.refreshWarningStatus(warnStatus, 3, "3615", sn);
        this.refreshWarningStatus(warnStatus, 4, "1005", sn);
        this.refreshWarningStatus(warnStatus, 5, "3603", sn);
        this.refreshWarningStatus(warnStatus, 6, "3604", sn);
        this.refreshWarningStatus(warnStatus, 7, "3605", sn);
        this.refreshWarningStatus(warnStatus, 8, "3606", sn);
        this.refreshWarningStatus(warnStatus, 9, "3607", sn);
        this.refreshWarningStatus(warnStatus, 10, "3601", sn);
        this.refreshWarningStatus(warnStatus, 11, "3005", sn);
        this.refreshWarningStatus(warnStatus, 12, "3609", sn);
        this.refreshWarningStatus(warnStatus, 13, "3610", sn);
        this.refreshWarningStatus(warnStatus, 14, "3611", sn);
        this.refreshWarningStatus(warnStatus, 15, "3612", sn);
        this.refreshWarningStatus(warnStatus, 16, "3613", sn);
        this.refreshWarningStatus(warnStatus, 17, "3614", sn);
        this.refreshWarningStatus(warnStatus, 18, "5002", sn);
        this.refreshWarningStatus(warnStatus, 19, "3616", sn);
        this.refreshWarningStatus(warnStatus, 20, "3006", sn);
        this.refreshWarningStatus(warnStatus, 21, "3618", sn);
        this.refreshWarningStatus(warnStatus, 22, "3619", sn);
        this.refreshWarningStatus(warnStatus, 23, "3620", sn);
        this.refreshWarningStatus(warnStatus, 24, "3621", sn);
        this.refreshWarningStatus(warnStatus, 25, "3622", sn);
        this.refreshWarningStatus(warnStatus, 26, "3623", sn);
        this.refreshWarningStatus(warnStatus, 27, "3624", sn);
        this.refreshWarningStatus(warnStatus, 28, "3625", sn);
        this.refreshWarningStatus(warnStatus, 29, "3626", sn);
        this.refreshWarningStatus(warnStatus, 30, "3627", sn);
        this.refreshWarningStatus(warnStatus, 31, "3628", sn);
    }

    private final void refreshWarningStatus(String warnStatus, int index, String eventCode, String sn) {
        if (warnStatus.charAt(index) == '1') {
            EventsHandler.handleEvent(this.getDeviceName(), eventCode, "P39", sn, true);
            this.workInfo.addWarning("a" + index);
        } else {
            EventsHandler.removeEvent(this.getDeviceName(), eventCode);
        }
    }

    public void queryBypass() throws IOException {
        boolean isLv;
        if (this.bypass == null) {
            this.bypass = new Bypass();
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String[] values = this.excuteCommand("QBYV", true).split(" ");
        this.bypass.setBypassHighVoltage((int)StrConvert.toDouble(values[0].substring(1)));
        this.bypass.setBypassLowVoltage(Integer.parseInt(values[1]));
        values = this.excuteCommand("QBYF", true).split(" ");
        this.bypass.setBypassHighFrequency(Float.parseFloat(values[0].substring(1)));
        this.bypass.setBypassLowFrequency(Float.parseFloat(values[1]));
        values = this.excuteCommand("QRI", true).split(" ");
        this._ratvol = Float.parseFloat(values[0].substring(1));
        this._ratfre = Float.parseFloat(values[3]);
        String qmd = this.excuteCommand("QMD", true);
        boolean bl = isLv = Integer.parseInt(qmd.substring(33, 36).replace("#", "")) < 180;
        if (isLv) {
            this.bypass.setMinBypassLowVoltage(88);
            this.bypass.setMaxBypassLowVoltage((int)(this._ratvol - 6.0f));
            this.bypass.setMinBypassHighVoltage((int)(this._ratvol + 6.0f));
            this.bypass.setMaxBypassHighVoltage(155);
        } else {
            this.bypass.setMinBypassLowVoltage(110);
            this.bypass.setMaxBypassLowVoltage((int)(this._ratvol - 11.0f));
            this.bypass.setMinBypassHighVoltage((int)(this._ratvol + 11.0f));
            this.bypass.setMaxBypassHighVoltage(276);
        }
        this.bypass.setMinBypassLowFrequency(this._ratfre - 4.0f);
        this.bypass.setMaxBypassLowFrequency(this._ratfre - 1.0f);
        this.bypass.setMinBypassHighFrequency(this._ratfre + 1.0f);
        this.bypass.setMaxBypassHighFrequency(this._ratfre + 4.0f);
        if (this.bypass.getMinBypassLowVoltage() == 88) {
            this.batteryNumber.setMaxNum(10);
            this.batteryNumber.setMinNum(8);
        } else {
            this.batteryNumber.setMaxNum(20);
            this.batteryNumber.setMinNum(16);
        }
    }

    @Override
    public Capability getCapability() throws IOException, UnsupportException {
        return this.capability;
    }

    public void queryHighEfficiencyVoltage() throws IOException {
        if (this.voltage == null) {
            this.voltage = new HighEfficiencyVoltage();
        }
        String[] values = this.excuteCommand("QHE", true).split(" ");
        this.voltage.setHeh((int)StrConvert.toDouble(values[0].substring(1)));
        this.voltage.setHel((int)StrConvert.toDouble(values[1]));
    }

    @Override
    public String cancelSwitchCtrl() throws IOException {
        return this.excuteCommand("CS", true);
    }

    @Override
    public String offSwitchCtrlOntime() throws IOException {
        return this.excuteCommand("SOFF", true);
    }

    @Override
    public String offSwitchCtrlOntime(int minutes) throws IOException {
        minutes = minutes > 9999 ? 9999 : minutes;
        DecimalFormat df3 = new DecimalFormat("0000");
        String turnOnDelay = df3.format(minutes);
        String command = null;
        command = "SnRm".replace("n", ".2").replace("m", turnOnDelay);
        this.excuteCommand(command, true);
        return "(ACK";
    }

    @Override
    public String deepBatteryTestCtrl() throws IOException, UnsupportException {
        String returnData = this.excuteCommand("TL", true);
        return returnData;
    }

    @Override
    public String munitesBatteryTestCtrl(float minute) throws IOException, UnsupportException {
        String commandStr = "T";
        commandStr = minute < 1.0f ? String.valueOf(commandStr) + String.valueOf(minute).substring(1, 3) : (minute < 10.0f ? String.valueOf(commandStr) + "0" + (int)minute : String.valueOf(commandStr) + String.valueOf((int)minute));
        String returnData = this.excuteCommand(commandStr, true);
        return returnData;
    }

    @Override
    public String offBuzzerCtrl() throws IOException {
        String retStr = this.excuteCommand("PEA", true);
        return retStr;
    }

    @Override
    public String onBuzzerCtrl() throws IOException {
        String retStr = this.excuteCommand("PDA", true);
        return retStr;
    }

    @Override
    public String offSwitchCtrl() throws IOException {
        String delayShutdownTime = this.getDelayShutdownTime();
        String command = "Sn".replace("n", delayShutdownTime);
        return this.excuteCommand(command, true);
    }

    @Override
    public void offSwitchCtrl(int minutes) throws IOException {
        String delayShutdownTime = this.getDelayShutdownTime();
        minutes = minutes > 9999 ? 9999 : minutes;
        DecimalFormat df3 = new DecimalFormat("0000");
        String turnOnDelay = df3.format(minutes);
        String command = null;
        command = "SnRm".replace("n", delayShutdownTime).replace("m", turnOnDelay);
        this.excuteCommand(command, true);
    }

    @Override
    public WorkInfo queryWorkInfo() {
        try {
            HashMap<String, String> snidmap = null;
            this.workInfo.setPtid("P39");
            this.workInfo.setCurrentTime(new Date());
            this.workInfo.setDeviceId(this.getDeviceId());
            String returnData = this.excuteCommand("Q3GS", true);
            String[] datas = returnData.split(" ");
            String status = datas[datas.length - 1];
            this.shutdownOnlowBattery(status.charAt(2) != '1', status.charAt(3) == '1');
            double outputV = StrConvert.toDouble(this.workInfo.getOutputVoltage());
            char utility = status.charAt(2);
            if (this.workInfo.isFirst()) {
                if (utility == '1') {
                    EventsHandler.putEvent(this.getDeviceName(), "1001");
                } else if (utility == '0') {
                    EventsHandler.putEvent(this.getDeviceName(), "1002");
                }
            } else if (utility == '1') {
                EventsHandler.removeEvent(this.getDeviceName(), "1002");
                EventsHandler.handleEvent(this.getDeviceName(), "1001", "P39", this.getDeviceId(), true);
            } else if (utility == '0' && outputV > 0.0) {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
                EventsHandler.handleEvent(this.getDeviceName(), "1002", "P39", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
            }
            if (status.charAt(5) == '1') {
                returnData = this.excuteCommand("QFS", true);
                if (!returnData.equals("(00")) {
                    String[] faultDatas = returnData.split(" ");
                    String faultKind = faultDatas[0].substring(1);
                    FaultHandler.doFaultEventP39(faultKind, this.getDeviceName(), "P39", this.getDeviceId());
                    this.workInfo.setFaultKind(faultKind);
                }
            } else {
                FaultHandler.removeFaultEvent(this.getDeviceName());
                this.workInfo.setFaultKind(null);
            }
            if (this.lastSelfTestProgress == '1' && status.charAt(7) == '0') {
                BatteryTestEndHandler.endEvent(this.getDeviceName(), "P39", status);
            }
            this.lastSelfTestProgress = status.charAt(7);
            this.workInfo.setMorphological("on-line");
            this.workInfo.setBypassActive(status.charAt(4) == '1');
            if (this.workInfo.isFirst()) {
                if (this.workInfo.isBypassActive()) {
                    EventsHandler.putEvent(this.getDeviceName(), "2001");
                } else {
                    EventsHandler.putEvent(this.getDeviceName(), "2002");
                }
            } else if (this.workInfo.isBypassActive()) {
                EventsHandler.removeEvent(this.getDeviceName(), "2002");
                EventsHandler.handleEvent(this.getDeviceName(), "2001", "P39", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "2001");
                EventsHandler.handleEvent(this.getDeviceName(), "2002", "P39", this.getDeviceId(), true);
            }
            this.workInfo.setInputVoltage(datas[0].substring(1));
            this.workInfo.setInputVoltageS(datas[1]);
            this.workInfo.setInputVoltageT(datas[2]);
            this.workInfo.setInputFrequency(datas[3]);
            this.workInfo.setOutputVoltage(datas[4]);
            this.workInfo.setOutputVoltageS(datas[5]);
            this.workInfo.setOutputVoltageT(datas[6]);
            this.workInfo.setOutputFrequency(datas[7]);
            this.workInfo.setOutputCurrent(datas[8]);
            this.workInfo.setOutputCurrentS(datas[9]);
            this.workInfo.setOutputCurrentT(datas[10]);
            this.workInfo.setLoadLevel(datas[11]);
            this.workInfo.setLoadLevelS(datas[12]);
            this.workInfo.setLoadLevelT(datas[13]);
            this.workInfo.setTemperature(datas[18]);
            returnData = this.excuteCommand("Q3LD", true);
            datas = returnData.split(" ");
            if (datas.length >= 4) {
                this.workInfo.setOutputLoadPercent(datas[3]);
            }
            if ((datas = (returnData = this.excuteCommand("Q3YV", true)).split(" ")).length >= 3) {
                this.workInfo.setBypassVoltage(datas[0].substring(1));
                this.workInfo.setBypassVoltageS(datas[1]);
                this.workInfo.setBypassVoltageT(datas[2]);
            }
            returnData = this.excuteCommand("QYF", true);
            this.workInfo.setBypassFrequency(returnData.substring(1));
            returnData = this.excuteCommand("QMOD", true);
            if (returnData.equals("(P")) {
                this.workInfo.setWorkMode("Power on mode");
                this.isBatMod = false;
            } else if (returnData.equals("(S")) {
                this.workInfo.setWorkMode("Standby mode");
                this.isBatMod = false;
            } else if (returnData.equals("(Y")) {
                this.workInfo.setWorkMode("Bypass mode");
                this.isBatMod = false;
            } else if (returnData.equals("(L")) {
                this.workInfo.setWorkMode("Line mode");
                this.isBatMod = false;
            } else if (returnData.equals("(B")) {
                this.workInfo.setWorkMode("Battery mode");
                if (!this.isBatMod) {
                    this.shutdownOnBatteryMode();
                }
                this.isBatMod = true;
            } else if (returnData.equals("(T")) {
                this.workInfo.setWorkMode("Battery test mode");
                this.isBatMod = false;
            } else if (returnData.equals("(F")) {
                this.workInfo.setWorkMode("Fault mode");
                this.isBatMod = false;
            } else if (returnData.equals("(E")) {
                this.workInfo.setWorkMode("ECO mode");
                this.isBatMod = false;
            } else if (returnData.equals("(C")) {
                this.workInfo.setWorkMode("Converter mode");
                this.isBatMod = false;
            } else if (returnData.equals("(D")) {
                this.workInfo.setWorkMode("Shutdown mode");
                this.isBatMod = false;
            }
            String reQFLAG = this.excuteCommand("QFLAG", true);
            int index_a = reQFLAG.indexOf("a");
            int index_D = reQFLAG.indexOf("D");
            this.workInfo.setBuzzerCtrl(index_a >= index_D);
            String qvfw = this.excuteCommand("QVFW", true);
            qvfw = qvfw.substring(0, qvfw.indexOf("."));
            if ("03".equals(qvfw) && ("Bypass mode".equals(this.workInfo.getWorkMode()) || "ECO mode".equals(this.workInfo.getWorkMode()))) {
                String v03returnData = this.excuteCommand("Q3GSN,08", true);
                String[] v03Datas = v03returnData.split(" ");
                if (datas.length >= 20) {
                    this.workInfo.setOutputCurrent(v03Datas[8]);
                    this.workInfo.setOutputCurrentS(v03Datas[9]);
                    this.workInfo.setOutputCurrentT(v03Datas[10]);
                    this.workInfo.setTemperatureView(v03Datas[18]);
                }
            }
            String warnStatus = this.excuteCommand("Q3WS", true);
            this.setWarningStatus(this.getDeviceId(), warnStatus);
            returnData = this.excuteCommand("QBV", true);
            datas = returnData.split(" ");
            this.workInfo.setPositiveBatteryCurrent(datas[5]);
            qvfw = this.excuteCommand("QVFW", true);
            qvfw = qvfw.substring(qvfw.indexOf(".") + 1);
            int version = StrConvert.toInteger(qvfw);
            if (version < 50) {
                this.workInfo.setGroupNum(datas[1]);
                this.batteryNumber.setBatn(Integer.parseInt(datas[1]));
            } else {
                this.workInfo.setGroupNum("10");
                this.batteryNumber.setBatn(10);
            }
            int batteryCapacity = 0;
            if (warnStatus.substring(1).charAt(1) == '1') {
                this.workInfo.setPositiveBatteryVoltage("0");
                this.workInfo.setBatteryVoltage("0");
                this.workInfo.setBatteryCapacity(0);
                this.workInfo.setBatteryRemainTime(0);
                this.workInfo.setPositiveBatteryCurrent("0");
                this.workInfo.setNegativeBatteryVoltage("0");
                this.workInfo.setNegativeBatteryCurrent("0");
            } else {
                this.workInfo.setPositiveBatteryVoltage(datas[0].substring(1));
                this.workInfo.setBatteryVoltage(this.workInfo.getPositiveBatteryVoltage());
                this.batteryNumber.setBatAHvalue(Integer.parseInt(datas[2]));
                this.workInfo.setBatteryCapacity(Integer.parseInt(datas[3]));
                this.workInfo.setBatteryRemainTime(Integer.parseInt(datas[4]));
                this.workInfo.setPositiveBatteryCurrent(datas[5]);
                returnData = this.excuteCommand("QNBV", true);
                datas = returnData.split(" ");
                this.workInfo.setNegativeBatteryVoltage(datas[0].substring(1));
                this.workInfo.setNegativeBatteryCurrent(datas[5]);
            }
            String totalAH = this.excuteCommand("QBTAH", true);
            this.batteryNumber.setBatTotalAHValue(StrConvert.toInteger(totalAH.substring(1)));
            Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
            int batCapacity = shutdown.getBatCapacity();
            if ("Battery mode".equals(this.workInfo.getWorkMode()) && batteryCapacity <= batCapacity) {
                if (!this.isBatCap && ("InfoPower".equalsIgnoreCase(MyConstants.Customized) || "NetGuard".equalsIgnoreCase(MyConstants.Customized) || "ATMUSE".equalsIgnoreCase(MyConstants.Customized))) {
                    new Thread(){

                        @Override
                        public void run() {
                            P39Processor.this.isBatCap = true;
                            P39Processor.this.shutdownOnBatteryCapacity();
                        }
                    }.start();
                }
            } else {
                this.isBatCap = false;
            }
            this.queryCapability();
            this.queryBypass();
            this.queryHighEfficiencyVoltage();
            this.queryParameterSettings();
            this.workInfo.setFirst(false);
            this.workInfo.setClear(false);
            this.workInfo.setInsertInput(true);
            this.workInfo.setInsertBypass(true);
            this.workInfo.setInsertOutput(true);
            this._protocol.refreshData(this._handler);
            snidmap = ((P39)this._protocol).getSNIDMap();
            ArrayList<UPSModuleInfo> removeItems = new ArrayList<UPSModuleInfo>();
            for (UPSModuleInfo uPSModuleInfo : this.workInfo.getModulesInfo()) {
                if (snidmap.containsKey(uPSModuleInfo.getModuleSN())) continue;
                removeItems.add(uPSModuleInfo);
            }
            for (UPSModuleInfo uPSModuleInfo : removeItems) {
                this.workInfo.getModulesInfo().remove(uPSModuleInfo);
            }
            for (Map.Entry entry : snidmap.entrySet()) {
                UPSModuleInfo info = this.workInfo.getModuleInfo((String)entry.getKey());
                if (info == null) {
                    info = new UPSModuleInfo();
                    info.setModuleSN((String)entry.getKey());
                    this.workInfo.addModules(info);
                }
                this.queryModule(info, (String)entry.getValue());
            }
            this.reconnectTimes = 0;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            log.error(e.getLocalizedMessage());
            e.printStackTrace();
            this.logingCommunicateException(false);
        }
        return this.workInfo;
    }

    private boolean queryModule(UPSModuleInfo info, String id) throws Exception {
        String returnData = this.excuteCommand("Q3GSN," + id, true);
        String[] datas = returnData.split(" ");
        if (datas.length >= 20) {
            info.setInputVoltage(datas[0].substring(1));
            info.setInputVoltageS(datas[1]);
            info.setInputVoltageT(datas[2]);
            info.setInputFrequency(datas[3]);
            info.setOutputVoltage(datas[4]);
            info.setOutputVoltageS(datas[5]);
            info.setOutputVoltageT(datas[6]);
            info.setOutputFrequency(datas[7]);
            info.setOutputCurrent(datas[8]);
            info.setOutputCurrentS(datas[9]);
            info.setOutputCurrentT(datas[10]);
            info.setLoadLevel(datas[11]);
            info.setLoadLevelS(datas[12]);
            info.setLoadLevelT(datas[13]);
            info.setPositiveBatteryVoltage(datas[16]);
            info.setNegativeBatteryVoltage(datas[17]);
            info.setTemperatureView(datas[18]);
        }
        if ((datas = (returnData = this.excuteCommand("Q3YVN," + id, true)).split(" ")).length >= 3) {
            info.setBypassVoltage(datas[0].substring(1));
            info.setBypassVoltageS(datas[1]);
            info.setBypassVoltageT(datas[2]);
        }
        if ((returnData = this.excuteCommand("QYFN," + id, true)).length() >= 3) {
            info.setBypassFrequency(returnData.substring(1));
        }
        if ((datas = (returnData = this.excuteCommand("Q3LDN," + id, true)).split(" ")).length >= 4) {
            info.setOutputLoadPercent(datas[3]);
        }
        if ((returnData = this.excuteCommand("QMODN," + id, true)).equals("(P")) {
            info.setWorkMode("Power on mode");
        } else if (returnData.equals("(S")) {
            info.setWorkMode("Standby mode");
        } else if (returnData.equals("(Y")) {
            info.setWorkMode("Bypass mode");
        } else if (returnData.equals("(L")) {
            info.setWorkMode("Line mode");
        } else if (returnData.equals("(B")) {
            info.setWorkMode("Battery mode");
        } else if (returnData.equals("(T")) {
            info.setWorkMode("Battery test mode");
        } else if (returnData.equals("(F")) {
            info.setWorkMode("Fault mode");
        } else if (returnData.equals("(E")) {
            info.setWorkMode("ECO mode");
        } else if (returnData.equals("(C")) {
            info.setWorkMode("Converter mode");
        } else if (returnData.equals("(D")) {
            info.setWorkMode("Shutdown mode");
        }
        returnData = this.excuteCommand("QFSN," + id, true);
        if (!returnData.equals("(00")) {
            String[] faultDatas = returnData.split(" ");
            String faultKind = faultDatas[0].substring(1);
            FaultHandler.doFaultEventP39(faultKind, this.getDeviceName(), "P39", info.getModuleSN());
            this.workInfo.setFaultKind(faultKind);
        }
        String warnStatus = this.excuteCommand("Q3WSN," + id, true);
        this.setWarningStatus(info.getModuleSN(), warnStatus);
        return true;
    }

    @Override
    public void setSupportBatNum(boolean arg0) throws IOException {
    }

    @Override
    public String tenSencondsBatteryTestCtrl() throws IOException {
        return this.excuteCommand("T", true);
    }

    @Override
    public void testOperation() throws IOException {
        this.excuteCommand("TL", true);
    }

    @Override
    public boolean isSupportBatNum() throws IOException {
        return false;
    }

    public void queryParameterSettings() throws IOException {
        String chargingCurrent = this.excuteCommand("QCHGC", true);
        this.param.setChargingCurrent(StrConvert.toInteger(chargingCurrent.substring(5)));
        String returnData = this.excuteCommand("QBCO", true);
        String[] cutOffVol = returnData.split(" ");
        this.param.setBatMinCutOffVol(StrConvert.toDouble(cutOffVol[1]));
        this.param.setBatCutOffVolPCS(StrConvert.toDouble(cutOffVol[1]));
        this.param.setBatLowVoltage(StrConvert.toDouble(cutOffVol[2]));
        this.param.setBatLowCapacity(StrConvert.toInteger(cutOffVol[3]));
        String returnQGS = this.excuteCommand("Q3GS", true);
        String[] datas = returnQGS.split(" ");
        String status = datas[datas.length - 1];
        if (status.charAt(6) == '1') {
            this.param.setEpoFunction(1);
        } else {
            this.param.setEpoFunction(0);
        }
        String[] returnQRI = this.excuteCommand("QRI", true).split(" ");
        this.param.setConverterModeOutFre((int)StrConvert.toFloat(returnQRI[3]));
        String returnQBDT = this.excuteCommand("QBDT", true);
        this.param.setBatShutdownDelay(StrConvert.toInteger(returnQBDT.substring(1)));
    }

    @Override
    public String setBatLowCapacity(int value) throws IOException {
        String command = "SBLC" + value;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setBatLowVoltage(double value) throws IOException {
        String str = String.format("%03.01f", value);
        String command = "SBLV" + str;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setBatMinCutOffVol(double value) throws IOException {
        String str = String.format("%3.01f", value);
        str = value < 10.0 ? "0" + str : str;
        System.out.println("BATCO:" + str);
        String command = "BATCO" + str;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setBatShutdownCapacity(int value) throws IOException {
        String command = "SBSC" + value;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setBatShutdownDelay(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "SBDT" + str;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setBatTestStopCapacity(int value) throws IOException {
        String command = "SBTSC" + value;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setBatTestStopTime(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "SBTST" + str;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setBatTestStopVol(double value) throws IOException {
        String str = String.format("%05.02f", value);
        String command = "SBTSV" + str;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setChargingCurrent(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "CHGC" + str;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setConverterModeOutFre(int value) throws IOException {
        String command = "SCVF" + value;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setEpoFunction(int value) throws IOException {
        String str = String.format("%02d", value);
        String command = "SEAF" + str;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setPeriodSelfTest(int value) throws IOException {
        String str = String.format("%02d", value);
        String command = "PST" + str;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setTotalCapacity(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "BATTAH" + str;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setBatn(int value) throws IOException {
        String command;
        String returnData;
        String batVal = String.valueOf(value);
        if (value < 10) {
            batVal = "0" + batVal;
        }
        if ((returnData = this.excuteCommand(command = "BATN" + batVal, true)).equalsIgnoreCase("(ACK")) {
            this.queryUpsInfo();
            return "success";
        }
        return "failure";
    }

    @Override
    public String turnToBypass() throws IOException {
        return this.excuteCommand("UPSBYP", true);
    }

    @Override
    public BatLowVoltage getBatLow() throws IOException {
        return null;
    }

    @Override
    public PhaseAngle getPPD() throws IOException {
        return null;
    }

    @Override
    public String querySPR() throws IOException {
        String result = this.excuteCommand("QPRI", true);
        String[] datas = result.split(" ");
        return datas[0].substring(1);
    }

    @Override
    public String querySCB() throws IOException {
        String result = this.excuteCommand("QPRI", true);
        String[] datas = result.split(" ");
        return datas[0];
    }

    @Override
    public Date queryBID(String value) throws IOException {
        String result = "";
        result = "08".equals(value) ? this.excuteCommand("QBID08", true) : ("17".equals(value) ? this.excuteCommand("QBID17", true) : this.excuteCommand("QBID", true));
        String[] dates = result.split(" ");
        String str = String.valueOf(dates[0].substring(1)) + "-" + dates[1] + "-" + dates[2];
        Date date = null;
        date = "".equals(str) ? new Date() : DateUtils.parseDate((String)str);
        return date;
    }

    @Override
    public Date queryBMD(String value) throws IOException {
        String result = "";
        result = "08".equals(value) ? this.excuteCommand("QBMD08", true) : ("17".equals(value) ? this.excuteCommand("QBMD17", true) : this.excuteCommand("QBMD", true));
        String[] dates = result.split(" ");
        String str = String.valueOf(dates[0].substring(1)) + "-" + dates[1] + "-" + dates[2];
        Date date = null;
        date = "".equals(str) ? new Date() : DateUtils.parseDate((String)str);
        return date;
    }

    @Override
    public Date querySID(String value) throws IOException {
        String result = "";
        result = "08".equals(value) ? this.excuteCommand("QSID08", true) : ("17".equals(value) ? this.excuteCommand("QSID17", true) : this.excuteCommand("QSID", true));
        String[] dates = result.split(" ");
        String str = String.valueOf(dates[0].substring(1)) + "-" + dates[1] + "-" + dates[2];
        Date date = null;
        date = "".equals(str) ? new Date() : DateUtils.parseDate((String)str);
        return date;
    }

    @Override
    public Date querySMD(String value) throws IOException {
        String result = "";
        result = "08".equals(value) ? this.excuteCommand("QSMD08", true) : ("17".equals(value) ? this.excuteCommand("QSMD17", true) : this.excuteCommand("QSMD", true));
        String[] dates = result.split(" ");
        String str = String.valueOf(dates[0].substring(1)) + "-" + dates[1] + "-" + dates[2];
        Date date = null;
        date = "".equals(str) ? new Date() : DateUtils.parseDate((String)str);
        return date;
    }

    @Override
    public String setBID(String id, Date selectDate) throws IOException {
        String value = DateUtils.getFormatyyyyMMdd((Date)selectDate);
        String command = "SBID" + id + value;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setBMD(String id, Date selectDate) throws IOException {
        String value = DateUtils.getFormatyyyyMMdd((Date)selectDate);
        String command = "SBMD" + id + value;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setSID(String id, Date selectDate) throws IOException {
        String value = DateUtils.getFormatyyyyMMdd((Date)selectDate);
        String command = "SSID" + id + value;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setSMD(String id, Date selectDate) throws IOException {
        String value = DateUtils.getFormatyyyyMMdd((Date)selectDate);
        String command = "SSMD" + id + value;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setSCB(String value) throws IOException {
        String command = "SCB" + value;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }
}

