/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.processor;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.data.bean.Bypass;
import cn.com.voltronicpower.data.bean.HighEfficiencyVoltage;
import cn.com.voltronicpower.data.bean.LineVoltage;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.exception.FaultHandler;
import cn.com.voltronicpower.monitor.processor.P35Processor;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.utilities.StrConvert;
import cn.com.voltronicpower.work.BatteryTestEndHandler;
import java.io.IOException;
import java.util.Date;

public class P38Processor
extends P35Processor {
    public P38Processor(CommunicateHandlerInterface handler, IProtocol protocol) {
        super(handler, protocol);
        this.protocol = protocol;
    }

    @Override
    public void queryUpsInfo() throws IOException {
        String[] datas;
        block10: {
            datas = null;
            String status = null;
            String dataStr = this.excuteCommand("SEC_Q3GS", true);
            datas = dataStr.split(",");
            status = datas[datas.length - 1];
            this.identity.setMorphological(this.queryMorphological(status));
            dataStr = this.excuteCommand("SEC_QMD", true);
            datas = dataStr.split(",");
            String modelName = datas[0];
            this.identity.setUpsModelName(modelName.substring(modelName.lastIndexOf("#") + 1));
            this.ratingInfo.setRatedCapacity(datas[1].substring(datas[1].lastIndexOf("#") + 1));
            this.identity.setIoPhase(datas[3]);
            this.workInfo.setIoPhase(datas[3]);
            this.identity.setInputRatingVoltage(datas[4]);
            this.identity.setOutputRatingVoltage(datas[5]);
            String sn = "";
            try {
                try {
                    sn = this.excuteCommand("SEC_QID", true);
                    sn = "NAK".equals(sn) ? "----" : (!"".equals(sn.trim()) ? sn.substring(1) : "----");
                }
                catch (Exception exception) {
                    this.identity.setProductSN(sn);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                this.identity.setProductSN(sn);
                throw throwable;
            }
            this.identity.setProductSN(sn);
        }
        datas = this.excuteCommand("SEC_QRI", true).split(",");
        this.ratingInfo.setOutputRatingVoltage(String.valueOf(Float.parseFloat(datas[0])));
        this.identity.setInputRatingVoltage(String.valueOf(Float.parseFloat(datas[0])));
        this.identity.setOutputRatingVoltage(String.valueOf(Float.parseFloat(datas[0])));
        this.ratingInfo.setOutputRatingCurrent("----");
        this.ratingInfo.setBatteryVoltage(String.valueOf(Float.parseFloat(datas[1])));
        this.batteryNumber.setBatTotalAHValue(Integer.parseInt(datas[2]));
        this.ratingInfo.setOutputRatingFrequency(String.valueOf(Float.parseFloat(datas[3])));
        String[] fwDatas = null;
        try {
            try {
                String qvfw = this.excuteCommand("SEC_QVFW", true);
                fwDatas = qvfw.split(",");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.identity.setFwVersion("----");
                this.identity.setDspNumber(fwDatas[0]);
                this.identity.setDspFwVersion(fwDatas[1]);
                this.identity.setDspFwExtraVersion("");
                this.identity.setMcuNumber(fwDatas[2]);
                this.identity.setMcuFwVersion(fwDatas[3]);
                this.identity.setMcuFwExtraVersion("");
                String fw = "DSP:" + fwDatas[0] + "." + fwDatas[1].replace(".", "") + "; MCU:" + fwDatas[2] + "." + fwDatas[3].replace(".", "");
                this.identity.setFwVersion(fw);
            }
        }
        finally {
            this.identity.setDspNumber(fwDatas[0]);
            this.identity.setDspFwVersion(fwDatas[1]);
            this.identity.setDspFwExtraVersion("");
            this.identity.setMcuNumber(fwDatas[2]);
            this.identity.setMcuFwVersion(fwDatas[3]);
            this.identity.setMcuFwExtraVersion("");
            String fw = "DSP:" + fwDatas[0] + "." + fwDatas[1].replace(".", "") + "; MCU:" + fwDatas[2] + "." + fwDatas[3].replace(".", "");
            this.identity.setFwVersion(fw);
        }
    }

    @Override
    public WorkInfo queryWorkInfo() {
        try {
            this.workInfo.setPtid(this.protocol.getProtocolID());
            this.workInfo.setCurrentTime(new Date());
            this.workInfo.setDeviceId(this.getDeviceId());
            String jduge = "";
            int isDual = 0;
            try {
                jduge = this.excuteCommand("SEC_QTYPE", true);
                isDual = Integer.parseInt(jduge.split(" ")[1]);
                if (isDual == 1) {
                    this.workInfo.setDual(true);
                } else {
                    this.workInfo.setDual(false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String returnData = this.excuteCommand("SEC_Q3GS", true);
            String[] datas = returnData.split(",");
            String status = datas[datas.length - 1];
            this.shutdownOnlowBattery(status.charAt(2) != '1', status.charAt(3) == '1');
            if (status.charAt(9) == '1') {
                this.workInfo.setBuzzerCtrl(false);
            } else {
                this.workInfo.setBuzzerCtrl(true);
            }
            String qmddata = this.excuteCommand("SEC_QMD", true);
            String[] dat = qmddata.split(",");
            this.identity.setIoPhase(dat[3]);
            this.workInfo.setIoPhase(dat[3]);
            double outputV = StrConvert.toDouble(this.workInfo.getOutputVoltage());
            char utility = status.charAt(2);
            if (this.workInfo.isFirst()) {
                if (utility == '1') {
                    EventsHandler.putEvent(this.getDeviceName(), "1001");
                } else if (utility == '0') {
                    EventsHandler.putEvent(this.getDeviceName(), "1002");
                }
            } else if (utility == '1') {
                EventsHandler.removeEvent(this.getDeviceName(), "1002");
                EventsHandler.handleEvent(this.getDeviceName(), "1001", this.protocol.getProtocolID(), this.getDeviceId(), true);
            } else if (utility == '0' && outputV > 0.0) {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
                EventsHandler.handleEvent(this.getDeviceName(), "1002", this.protocol.getProtocolID(), this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
            }
            if (status.charAt(5) == '1') {
                returnData = this.excuteCommand("SEC_QFS", true);
                if (!returnData.equals("00")) {
                    String[] faultDatas = returnData.split(" ");
                    String faultKind = faultDatas[0].substring(1);
                    FaultHandler.doFaultEventP38(faultKind, this.getDeviceName(), this.protocol.getProtocolID(), this.getDeviceId());
                    this.workInfo.setFaultKind(faultKind);
                }
            } else {
                FaultHandler.removeFaultEvent(this.getDeviceName());
                this.workInfo.setFaultKind(null);
            }
            if (this.lastSelfTestProgress == '1' && status.charAt(7) == '0') {
                BatteryTestEndHandler.endEvent(this.getDeviceName(), this.protocol.getProtocolID(), status);
            }
            this.lastSelfTestProgress = status.charAt(7);
            this.workInfo.setMorphological(this.queryMorphological(status));
            this.workInfo.setBypassActive(status.charAt(4) == '1');
            if (this.workInfo.isFirst()) {
                if (this.workInfo.isBypassActive()) {
                    EventsHandler.putEvent(this.getDeviceName(), "2005");
                } else {
                    EventsHandler.putEvent(this.getDeviceName(), "2006");
                }
            } else if (this.workInfo.isBypassActive()) {
                EventsHandler.removeEvent(this.getDeviceName(), "2006");
                EventsHandler.handleEvent(this.getDeviceName(), "2005", this.protocol.getProtocolID(), this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "2005");
                EventsHandler.handleEvent(this.getDeviceName(), "2006", this.protocol.getProtocolID(), this.getDeviceId(), true);
            }
            this.workInfo.setInputVoltage(datas[1]);
            this.workInfo.setInputVoltageS(datas[2]);
            this.workInfo.setInputVoltageT(datas[3]);
            this.workInfo.setInputFrequency(datas[4]);
            this.workInfo.setOutputVoltage(datas[5]);
            this.workInfo.setOutputVoltageS(datas[6]);
            this.workInfo.setOutputVoltageT(datas[7]);
            this.workInfo.setOutputFrequency(datas[8]);
            this.workInfo.setOutputCurrent(datas[9]);
            this.workInfo.setOutputCurrentS(datas[10]);
            this.workInfo.setOutputCurrentT(datas[11]);
            this.workInfo.setLoadLevel(datas[12]);
            this.workInfo.setLoadLevelS(datas[13]);
            this.workInfo.setLoadLevelT(datas[14]);
            this.workInfo.setOutputLoadPercent(datas[15]);
            this.workInfo.setPositiveBatteryVoltage(datas[16]);
            this.workInfo.setNegativeBatteryVoltage(datas[17]);
            this.workInfo.setTemperature(datas[18]);
            this.currentWorkMode = returnData = datas[0];
            if (returnData.equals("01")) {
                this.workInfo.setWorkMode("Power on mode");
                this.isBatMod = false;
            } else if (returnData.equals("02")) {
                this.workInfo.setWorkMode("Standby mode");
                this.isBatMod = false;
            } else if (returnData.equals("03")) {
                this.workInfo.setWorkMode("Bypass mode");
                this.isBatMod = false;
            } else if (returnData.equals("04")) {
                this.workInfo.setWorkMode("Line mode");
                this.isBatMod = false;
            } else if (returnData.equals("05")) {
                this.workInfo.setWorkMode("Battery mode");
                if (!this.isBatMod) {
                    this.shutdownOnBatteryMode();
                }
                this.isBatMod = true;
            } else if (returnData.equals("06")) {
                this.workInfo.setWorkMode("Battery test mode");
                this.isBatMod = false;
            } else if (returnData.equals("07")) {
                this.workInfo.setWorkMode("Fault mode");
                this.isBatMod = false;
            } else if (returnData.equals("09")) {
                this.workInfo.setWorkMode("ECO mode");
                this.isBatMod = false;
            } else if (returnData.equals("08")) {
                this.workInfo.setWorkMode("Converter mode");
                this.isBatMod = false;
            } else if (returnData.equals("10")) {
                this.workInfo.setWorkMode("Shutdown mode");
                this.isBatMod = false;
            }
            if (this.workInfo.isBypassActive() && this.currentWorkMode.equals("03")) {
                EventsHandler.removeEvent(this.getDeviceName(), "2002");
                EventsHandler.handleEvent(this.getDeviceName(), "2001", this.protocol.getProtocolID(), this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "2001");
                EventsHandler.handleEvent(this.getDeviceName(), "2002", this.protocol.getProtocolID(), this.getDeviceId(), true);
            }
            returnData = this.excuteCommand("SEC_Q3Y", true);
            datas = returnData.split(",");
            this.workInfo.setBypassVoltage(datas[0]);
            this.workInfo.setBypassVoltageS(datas[1]);
            this.workInfo.setBypassVoltageT(datas[2]);
            this.workInfo.setBypassCurrent(datas[3]);
            this.workInfo.setBypassCurrentS(datas[4]);
            this.workInfo.setBypassCurrentT(datas[5]);
            this.workInfo.setBypassFrequency(datas[6]);
            if (isDual == 1) {
                this.workInfo.setInputVoltage2(datas[0]);
                this.workInfo.setInputVoltageS2(datas[1]);
                this.workInfo.setInputVoltageT2(datas[2]);
            }
            if (("Bypass mode".equals(this.workInfo.getWorkMode()) || "ECO mode".equals(this.workInfo.getWorkMode()) || "AVR mode".equals(this.workInfo.getWorkMode())) && isDual != 1) {
                this.workInfo.setInputVoltage(this.workInfo.getBypassVoltage());
                this.workInfo.setInputVoltageS(this.workInfo.getBypassVoltageS());
                this.workInfo.setInputVoltageT(this.workInfo.getBypassVoltageT());
                this.workInfo.setInputFrequency(this.workInfo.getBypassFrequency());
            }
            String warnStatus = this.excuteCommand("SEC_QWS", true);
            this.setWarningStatus(warnStatus);
            if (warnStatus.charAt(0) == '1') {
                this.workInfo.setBatteryCapacity(0);
                this.workInfo.setBatteryVoltage("0");
                this.workInfo.setBatteryRemainTime(0);
                this.workInfo.setGroupNum("0");
                this.workInfo.setBatChargingCurrentP("0");
                this.workInfo.setBatDisChargingCurrentP("0");
                this.workInfo.setBatChargingCurrentN("0");
                this.workInfo.setBatDisChargingCurrentN("0");
            } else {
                returnData = this.excuteCommand("SEC_QBV", true);
                datas = returnData.split(",");
                int batteryCapacity = Integer.parseInt(datas[6]);
                Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
                int batCapacity = shutdown.getBatCapacity();
                if ("Battery mode".equals(this.workInfo.getWorkMode()) && batteryCapacity <= batCapacity) {
                    if (!this.isBatCap && ("InfoPower".equalsIgnoreCase(MyConstants.Customized) || "NetGuard".equalsIgnoreCase(MyConstants.Customized) || "ATMUSE".equalsIgnoreCase(MyConstants.Customized))) {
                        new Thread(){

                            @Override
                            public void run() {
                                P38Processor.this.isBatCap = true;
                                P38Processor.this.shutdownOnBatteryCapacity();
                            }
                        }.start();
                    }
                } else {
                    this.isBatCap = false;
                }
                this.workInfo.setBatteryCapacity(batteryCapacity);
                this.workInfo.setBatteryVoltage(datas[0]);
                this.workInfo.setPositiveBatteryVoltage(datas[0]);
                this.workInfo.setBatChargingCurrentP(datas[1]);
                this.workInfo.setBatDisChargingCurrentP(datas[2]);
                this.workInfo.setNegativeBatteryVoltage(datas[3]);
                this.workInfo.setBatChargingCurrentN(datas[4]);
                this.workInfo.setBatDisChargingCurrentN(datas[5]);
                this.workInfo.setBatteryRemainTime(Integer.parseInt(datas[7]));
            }
            String[] loads = this.excuteCommand("SEC_Q3LD", true).split(",");
            this.loadInfo.setMaxLoadPercentR(loads[0]);
            this.loadInfo.setMaxLoadPercentS(loads[1]);
            this.loadInfo.setMaxLoadPercentT(loads[2]);
            this.loadInfo.setMaxTotalPercent(loads[3]);
            this.loadInfo.setLoadVAPercentR(loads[4]);
            this.loadInfo.setLoadVAPercentS(loads[5]);
            this.loadInfo.setLoadVAPercentT(loads[6]);
            this.loadInfo.setLoadVATotalPercent(loads[7]);
            this.loadInfo.setLoadWattPercentR(loads[8]);
            this.loadInfo.setLoadWattPercentS(loads[9]);
            this.loadInfo.setLoadWattPercentT(loads[10]);
            this.loadInfo.setLoadWattTotalPercent(loads[11]);
            this.loadInfo.setLoadVAR(loads[12]);
            this.loadInfo.setLoadVAR(loads[13]);
            this.loadInfo.setLoadVAR(loads[14]);
            this.loadInfo.setLoadWattS(loads[16]);
            this.loadInfo.setLoadWattT(loads[17]);
            this.queryCapability();
            this.queryBypass();
            this.queryHighEfficiencyVoltage();
            this.queryLine();
            this.queryParameterSettings();
            this.workInfo.setFirst(false);
            this.workInfo.setClear(false);
            this.workInfo.setInsertInput(true);
            this.workInfo.setInsertBypass(true);
            this.workInfo.setInsertOutput(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.workInfo;
    }

    @Override
    protected void queryLine() {
        String[] values = this.excuteCommand("SEC_QRHL", true).split(",");
        this.line.setLineHighVoltage((int)StrConvert.toDouble(values[0]));
        this.line.setLineLowVoltage(Integer.parseInt(values[1]));
        this.line.setLineHighFrequency(Float.parseFloat(values[2]));
        this.line.setLineLowFrequency(Float.parseFloat(values[3]));
        values = this.excuteCommand("SEC_QRI", true).split(",");
        this._ratvol = (int)Float.parseFloat(values[0]);
        this._ratfre = (int)Float.parseFloat(values[3]);
        if (this._ratvol >= 200) {
            this.line.setMinLineLowVoltage(110);
            this.line.setMaxLineLowVoltage(209);
            this.line.setMinLineHighVoltage(231);
            this.line.setMaxLineHighVoltage(276);
        }
        this.line.setMinLineLowFrequency((float)(this._ratfre - 4));
        this.line.setMaxLineLowFrequency((float)(this._ratfre - 1));
        this.line.setMinLineHighFrequency((float)(this._ratfre + 1));
        this.line.setMaxLineHighFrequency((float)(this._ratfre + 4));
    }

    @Override
    public LineVoltage getLine() throws IOException {
        return this.line;
    }

    @Override
    public void queryBypass() throws IOException {
        if (this.bypass == null) {
            this.bypass = new Bypass();
        }
        String[] values = this.excuteCommand("SEC_QRHL", true).split(",");
        this.bypass.setBypassHighVoltage((int)StrConvert.toDouble(values[4]));
        this.bypass.setBypassLowVoltage(Integer.parseInt(values[5]));
        this.bypass.setBypassHighFrequency(Float.parseFloat(values[6]));
        this.bypass.setBypassLowFrequency(Float.parseFloat(values[7]));
        values = this.excuteCommand("SEC_QRI", true).split(",");
        this._ratvol = (int)Float.parseFloat(values[0]);
        this._ratfre = (int)Float.parseFloat(values[3]);
        if (this._ratvol >= 200) {
            this.bypass.setMinBypassLowVoltage(110);
            this.bypass.setMaxBypassLowVoltage(209);
            this.bypass.setMinBypassHighVoltage(231);
            this.bypass.setMaxBypassHighVoltage(276);
        } else {
            this.bypass.setMinBypassLowVoltage(88);
            this.bypass.setMaxBypassLowVoltage(96);
            this.bypass.setMinBypassHighVoltage(130);
            this.bypass.setMaxBypassHighVoltage(146);
        }
        this.bypass.setMinBypassLowFrequency((float)(this._ratfre - 4));
        this.bypass.setMaxBypassLowFrequency((float)(this._ratfre - 1));
        this.bypass.setMinBypassHighFrequency((float)(this._ratfre + 1));
        this.bypass.setMaxBypassHighFrequency((float)(this._ratfre + 4));
    }

    @Override
    public void queryHighEfficiencyVoltage() throws IOException {
        if (this.voltage == null) {
            this.voltage = new HighEfficiencyVoltage();
        }
        String[] values = this.excuteCommand("SEC_QRHL", true).split(",");
        this.voltage.setHeh(Integer.parseInt(values[8]));
        this.voltage.setHel(Integer.parseInt(values[9]));
        this.voltage.setHeFh(Float.parseFloat(values[10]));
        this.voltage.setHeFl(Float.parseFloat(values[11]));
        values = this.excuteCommand("SEC_QRI", true).split(",");
        this._ratvol = (int)Float.parseFloat(values[0]);
        this._ratfre = (int)Float.parseFloat(values[3]);
        if (this._ratvol >= 200) {
            this.voltage.setMinHel(this._ratvol - 24);
            this.voltage.setMaxHel(this._ratvol - 11);
            this.voltage.setMinHeh(this._ratvol + 11);
            this.voltage.setMaxHeh(this._ratvol + 24);
        } else {
            this.voltage.setMinHel(this._ratvol - 10);
            this.voltage.setMaxHel(this._ratvol - 5);
            this.voltage.setMinHeh(this._ratvol + 5);
            this.voltage.setMaxHeh(this._ratvol + 10);
        }
        this.voltage.setMinHeFl((float)(this._ratfre - 4));
        this.voltage.setMaxHeFl((float)(this._ratfre - 1));
        this.voltage.setMinHeFh((float)(this._ratfre + 1));
        this.voltage.setMaxHeFh((float)(this._ratfre + 4));
    }

    @Override
    protected void setWarningStatus(String warnStatus) {
        this.workInfo.clearWarning();
        this.refreshWarningStatus(warnStatus, 0, "4004");
        this.refreshWarningStatus(warnStatus, 1, "1003");
        this.refreshWarningStatus(warnStatus, 3, "1005");
        this.refreshWarningStatus(warnStatus, 4, "2003");
        this.refreshWarningStatus(warnStatus, 6, "4006");
        this.refreshWarningStatus(warnStatus, 7, "4001");
        this.refreshWarningStatus(warnStatus, 8, "5002");
        this.refreshWarningStatus(warnStatus, 9, "3005");
        this.refreshWarningStatus(warnStatus, 10, "3006");
        this.refreshWarningStatus(warnStatus, 12, "3008");
        this.refreshWarningStatus(warnStatus, 13, "3010");
        this.refreshWarningStatus(warnStatus, 32, "8009");
        this.refreshWarningStatus(warnStatus, 33, "8010");
        this.refreshWarningStatus(warnStatus, 50, "8032");
        this.refreshWarningStatus(warnStatus, 51, "8033");
        this.refreshWarningStatus(warnStatus, 53, "8035");
        this.refreshWarningStatus(warnStatus, 55, "3049");
        this.refreshWarningStatus(warnStatus, 57, "3102");
        this.refreshWarningStatus(warnStatus, 59, "3568");
        this.refreshWarningStatus(warnStatus, 60, "3569");
        this.refreshWarningStatus(warnStatus, 66, "3573");
        this.refreshWarningStatus(warnStatus, 67, "3574");
        this.refreshWarningStatus(warnStatus, 68, "3575");
    }

    @Override
    public Date queryTIME() throws IOException {
        return new Date();
    }
}

