/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.processor;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.exception.FaultHandler;
import cn.com.voltronicpower.monitor.processor.P35Processor;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.utilities.StrConvert;
import cn.com.voltronicpower.work.BatteryTestEndHandler;
import java.io.IOException;
import java.util.Date;

public class P36Processor
extends P35Processor {
    public P36Processor(CommunicateHandlerInterface handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public void queryUpsInfo() throws IOException {
        String[] datas;
        block10: {
            datas = null;
            String status = null;
            String dataStr = this.excuteCommand("SEC_Q3GS", true);
            datas = dataStr.split(",");
            status = datas[datas.length - 1];
            this.identity.setMorphological(this.queryMorphological(status));
            dataStr = this.excuteCommand("SEC_QMD", true);
            datas = dataStr.split(",");
            String modelName = datas[0];
            this.identity.setUpsModelName(modelName.substring(modelName.lastIndexOf("#") + 1));
            this.ratingInfo.setRatedCapacity(datas[1].substring(datas[1].lastIndexOf("#") + 1));
            this.identity.setIoPhase(datas[3]);
            this.workInfo.setIoPhase(datas[3]);
            this.identity.setInputRatingVoltage(datas[4]);
            this.identity.setOutputRatingVoltage(datas[5]);
            String sn = "";
            try {
                try {
                    sn = this.excuteCommand("SEC_QID", true);
                    sn = "NAK".equals(sn) ? "----" : (!"".equals(sn.trim()) ? sn.substring(1) : "----");
                }
                catch (Exception exception) {
                    this.identity.setProductSN(sn);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                this.identity.setProductSN(sn);
                throw throwable;
            }
            this.identity.setProductSN(sn);
        }
        datas = this.excuteCommand("SEC_QRI", true).split(",");
        this.ratingInfo.setOutputRatingVoltage(String.valueOf(Float.parseFloat(datas[0])));
        this.identity.setInputRatingVoltage(String.valueOf(Float.parseFloat(datas[0])));
        this.identity.setOutputRatingVoltage(String.valueOf(Float.parseFloat(datas[0])));
        this.ratingInfo.setOutputRatingCurrent("----");
        this.ratingInfo.setBatteryVoltage(String.valueOf(Float.parseFloat(datas[1])));
        this.batteryNumber.setBatTotalAHValue(Integer.parseInt(datas[2]));
        this.ratingInfo.setOutputRatingFrequency(String.valueOf(Float.parseFloat(datas[3])));
        String qvfw = "";
        try {
            try {
                qvfw = this.excuteCommand("SEC_QVFW", true);
            }
            catch (Exception e) {
                e.printStackTrace();
                qvfw = "----";
                this.identity.setFwVersion(qvfw);
            }
        }
        finally {
            this.identity.setFwVersion(qvfw);
        }
    }

    @Override
    public WorkInfo queryWorkInfo() {
        try {
            this.workInfo.setPtid(this.protocol.getProtocolID());
            this.workInfo.setCurrentTime(new Date());
            this.workInfo.setDeviceId(this.getDeviceId());
            String returnData = this.excuteCommand("SEC_Q3GS", true);
            String[] datas = returnData.split(",");
            String status = datas[datas.length - 1];
            if (status.length() >= 4) {
                this.shutdownOnlowBattery(status.charAt(2) != '1', status.charAt(3) == '1');
            }
            if (status.charAt(9) == '1') {
                this.workInfo.setBuzzerCtrl(false);
            } else {
                this.workInfo.setBuzzerCtrl(true);
            }
            double outputV = StrConvert.toDouble(this.workInfo.getOutputVoltage());
            char utility = status.charAt(2);
            if (this.workInfo.isFirst()) {
                if (utility == '1') {
                    EventsHandler.putEvent(this.getDeviceName(), "1001");
                } else if (utility == '0') {
                    EventsHandler.putEvent(this.getDeviceName(), "1002");
                }
            } else if (utility == '1') {
                EventsHandler.removeEvent(this.getDeviceName(), "1002");
                EventsHandler.handleEvent(this.getDeviceName(), "1001", this.protocol.getProtocolID(), this.getDeviceId(), true);
            } else if (utility == '0' && outputV > 0.0) {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
                EventsHandler.handleEvent(this.getDeviceName(), "1002", this.protocol.getProtocolID(), this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
            }
            if (status.charAt(5) == '1') {
                returnData = this.excuteCommand("SEC_QFS", true);
                if (!returnData.equals("00")) {
                    String[] faultDatas = returnData.split(" ");
                    String faultKind = faultDatas[0].substring(1);
                    FaultHandler.doFaultEventP35(faultKind, this.getDeviceName(), this.protocol.getProtocolID(), this.getDeviceId());
                    this.workInfo.setFaultKind(faultKind);
                }
            } else {
                FaultHandler.removeFaultEvent(this.getDeviceName());
                this.workInfo.setFaultKind(null);
            }
            if (this.lastSelfTestProgress == '1' && status.charAt(7) == '0') {
                BatteryTestEndHandler.endEvent(this.getDeviceName(), this.protocol.getProtocolID(), status);
            }
            this.lastSelfTestProgress = status.charAt(7);
            this.workInfo.setMorphological(this.queryMorphological(status));
            this.workInfo.setBypassActive(status.charAt(4) == '1');
            if (this.workInfo.isFirst()) {
                if (this.workInfo.isBypassActive()) {
                    EventsHandler.putEvent(this.getDeviceName(), "2005");
                } else {
                    EventsHandler.putEvent(this.getDeviceName(), "2006");
                }
            } else if (this.workInfo.isBypassActive()) {
                EventsHandler.removeEvent(this.getDeviceName(), "2006");
                EventsHandler.handleEvent(this.getDeviceName(), "2005", this.protocol.getProtocolID(), this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "2005");
                EventsHandler.handleEvent(this.getDeviceName(), "2006", this.protocol.getProtocolID(), this.getDeviceId(), true);
            }
            this.workInfo.setInputVoltage(datas[1]);
            this.workInfo.setInputVoltageS(datas[2]);
            this.workInfo.setInputVoltageT(datas[3]);
            this.workInfo.setInputFrequency(datas[4]);
            this.workInfo.setOutputVoltage(datas[5]);
            this.workInfo.setOutputVoltageS(datas[6]);
            this.workInfo.setOutputVoltageT(datas[7]);
            this.workInfo.setOutputFrequency(datas[8]);
            this.workInfo.setOutputCurrent(datas[9]);
            this.workInfo.setOutputCurrentS(datas[10]);
            this.workInfo.setOutputCurrentT(datas[11]);
            this.workInfo.setLoadLevel(datas[12]);
            this.workInfo.setLoadLevelS(datas[13]);
            this.workInfo.setLoadLevelT(datas[14]);
            this.workInfo.setOutputLoadPercent(datas[15]);
            this.workInfo.setPositiveBatteryVoltage(datas[16]);
            this.workInfo.setNegativeBatteryVoltage(datas[17]);
            this.workInfo.setTemperature(datas[18]);
            this.currentWorkMode = returnData = datas[0];
            if (returnData.equals("01")) {
                this.workInfo.setWorkMode("Power on mode");
                this.isBatMod = false;
            } else if (returnData.equals("02")) {
                this.workInfo.setWorkMode("Standby mode");
                this.isBatMod = false;
            } else if (returnData.equals("03")) {
                this.workInfo.setWorkMode("Bypass mode");
                this.isBatMod = false;
            } else if (returnData.equals("04")) {
                this.workInfo.setWorkMode("Line mode");
                this.isBatMod = false;
            } else if (returnData.equals("05")) {
                this.workInfo.setWorkMode("Battery mode");
                if (!this.isBatMod) {
                    this.shutdownOnBatteryMode();
                }
                this.isBatMod = true;
            } else if (returnData.equals("06")) {
                this.workInfo.setWorkMode("Battery test mode");
                this.isBatMod = false;
            } else if (returnData.equals("07")) {
                this.workInfo.setWorkMode("Fault mode");
                this.isBatMod = false;
            } else if (returnData.equals("09")) {
                this.workInfo.setWorkMode("ECO mode");
                this.isBatMod = false;
            } else if (returnData.equals("08")) {
                this.workInfo.setWorkMode("Converter mode");
                this.isBatMod = false;
            } else if (returnData.equals("10")) {
                this.workInfo.setWorkMode("Shutdown mode");
                this.isBatMod = false;
            }
            if (this.workInfo.isBypassActive() && this.currentWorkMode.equals("03")) {
                EventsHandler.removeEvent(this.getDeviceName(), "2002");
                EventsHandler.handleEvent(this.getDeviceName(), "2001", this.protocol.getProtocolID(), this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "2001");
                EventsHandler.handleEvent(this.getDeviceName(), "2002", this.protocol.getProtocolID(), this.getDeviceId(), true);
            }
            returnData = this.excuteCommand("SEC_Q3Y", true);
            datas = returnData.split(",");
            this.workInfo.setBypassVoltage(datas[0]);
            this.workInfo.setBypassVoltageS(datas[1]);
            this.workInfo.setBypassVoltageT(datas[2]);
            this.workInfo.setBypassCurrent(datas[3]);
            this.workInfo.setBypassCurrentS(datas[4]);
            this.workInfo.setBypassCurrentT(datas[5]);
            this.workInfo.setBypassFrequency(datas[6]);
            String warnStatus = this.excuteCommand("SEC_QWS", true);
            this.setWarningStatus(warnStatus);
            if (warnStatus.charAt(0) == '1') {
                this.workInfo.setBatteryCapacity(0);
                this.workInfo.setBatteryVoltage("0");
                this.workInfo.setBatteryRemainTime(0);
                this.workInfo.setGroupNum("0");
                this.workInfo.setBatChargingCurrentP("0");
                this.workInfo.setBatDisChargingCurrentP("0");
                this.workInfo.setBatChargingCurrentN("0");
                this.workInfo.setBatDisChargingCurrentN("0");
            } else {
                returnData = this.excuteCommand("SEC_QBV", true);
                datas = returnData.split(",");
                int batteryCapacity = Integer.parseInt(datas[6]);
                Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
                int batCapacity = shutdown.getBatCapacity();
                if ("Battery mode".equals(this.workInfo.getWorkMode()) && batteryCapacity <= batCapacity) {
                    if (!this.isBatCap && ("InfoPower".equalsIgnoreCase(MyConstants.Customized) || "NetGuard".equalsIgnoreCase(MyConstants.Customized) || "ATMUSE".equalsIgnoreCase(MyConstants.Customized))) {
                        new Thread(){

                            @Override
                            public void run() {
                                P36Processor.this.isBatCap = true;
                                P36Processor.this.shutdownOnBatteryCapacity();
                            }
                        }.start();
                    }
                } else {
                    this.isBatCap = false;
                }
                this.workInfo.setBatteryCapacity(batteryCapacity);
                this.workInfo.setBatteryVoltage(datas[0]);
                this.workInfo.setPositiveBatteryVoltage(datas[0]);
                this.workInfo.setBatChargingCurrentP(datas[1]);
                this.workInfo.setBatDisChargingCurrentP(datas[2]);
                this.workInfo.setNegativeBatteryVoltage(datas[3]);
                this.workInfo.setBatChargingCurrentN(datas[4]);
                this.workInfo.setBatDisChargingCurrentN(datas[5]);
                this.workInfo.setBatteryRemainTime(Integer.parseInt(datas[7]));
            }
            String[] qiotValues = this.excuteCommand("SEC_QIOT", true).split(",");
            String inWireType = qiotValues[0];
            String outWireType = qiotValues[2];
            int intype = StrConvert.toInteger(inWireType);
            int outtype = StrConvert.toInteger(outWireType);
            if (intype == 0) {
                this.workInfo.setInputWireType(this.iwt3P4W);
            } else if (intype == 1) {
                this.workInfo.setInputWireType(this.iwt3P3W);
            } else {
                this.workInfo.setInputWireType("");
            }
            if (outtype == 0) {
                this.workInfo.setOutputWireType(this.owt3P4W);
            } else if (outtype == 1) {
                this.workInfo.setOutputWireType(this.owt3P3W);
            } else {
                this.workInfo.setOutputWireType("");
            }
            this.workInfo.setInputScaleFactor(qiotValues[1]);
            this.workInfo.setOutputScaleFactor(qiotValues[3]);
            String[] loads = this.excuteCommand("SEC_Q3LD", true).split(",");
            this.loadInfo.setMaxLoadPercentR(loads[0]);
            this.loadInfo.setMaxLoadPercentS(loads[1]);
            this.loadInfo.setMaxLoadPercentT(loads[2]);
            this.loadInfo.setMaxTotalPercent(loads[3]);
            this.loadInfo.setLoadVAPercentR(loads[4]);
            this.loadInfo.setLoadVAPercentS(loads[5]);
            this.loadInfo.setLoadVAPercentT(loads[6]);
            this.loadInfo.setLoadVATotalPercent(loads[7]);
            this.loadInfo.setLoadWattPercentR(loads[8]);
            this.loadInfo.setLoadWattPercentS(loads[9]);
            this.loadInfo.setLoadWattPercentT(loads[10]);
            this.loadInfo.setLoadWattTotalPercent(loads[11]);
            this.loadInfo.setLoadVAR(loads[12]);
            this.loadInfo.setLoadVAR(loads[13]);
            this.loadInfo.setLoadVAR(loads[14]);
            this.loadInfo.setLoadWattR(loads[15]);
            this.loadInfo.setLoadWattS(loads[16]);
            this.loadInfo.setLoadWattT(loads[17]);
            String[] qopfValues = this.excuteCommand("SEC_QOPF", true).split(",");
            this.workInfo.setOutputPowerFactorL1(qopfValues[0]);
            this.workInfo.setOutputPowerFactorL2(qopfValues[0]);
            this.workInfo.setOutputPowerFactorL3(qopfValues[0]);
            String qlfd = this.excuteCommand("SEC_QLFD", true);
            this.workInfo.setLastfaultID(qlfd);
            this.queryCapability();
            this.queryBypass();
            this.queryHighEfficiencyVoltage();
            this.queryLine();
            this.queryParameterSettings();
            this.workInfo.setFirst(false);
            this.workInfo.setClear(false);
            this.workInfo.setInsertInput(true);
            this.workInfo.setInsertBypass(true);
            this.workInfo.setInsertOutput(true);
            this.reconnectTimes = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logingCommunicateException(false);
        }
        return this.workInfo;
    }
}

