/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.processor;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.data.bean.Capability;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.exception.FaultHandler;
import cn.com.voltronicpower.exception.UnsupportException;
import cn.com.voltronicpower.monitor.AbstractMonitorProcessor;
import cn.com.voltronicpower.utilities.StrConvert;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;
import org.springframework.beans.BeanWrapperImpl;

public class P31Processor
extends AbstractMonitorProcessor {
    private Capability capability = new Capability();

    public P31Processor(CommunicateHandlerInterface handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public String cancelSwitchCtrl() throws IOException {
        return this.excuteCommand("CS", true);
    }

    @Override
    public String offSwitchCtrlOntime() throws IOException {
        return this.excuteCommand("SOFF", true);
    }

    @Override
    public String offSwitchCtrlOntime(int minutes) throws IOException {
        minutes = minutes > 9999 ? 9999 : minutes;
        DecimalFormat df3 = new DecimalFormat("0000");
        String turnOnDelay = df3.format(minutes);
        String command = null;
        command = "SnRm".replace("n", ".2").replace("m", turnOnDelay);
        this.excuteCommand(command, true);
        return "(ACK";
    }

    @Override
    public String deepBatteryTestCtrl() throws IOException, UnsupportException {
        String returnData = this.excuteCommand("TL", true);
        return returnData;
    }

    @Override
    public Capability getCapability() throws IOException {
        return this.capability;
    }

    private void queryCapability() throws IOException {
        String enableName;
        String fieldName;
        String ctrlName;
        String returnData = this.excuteCommand("QFLAG", true);
        String[] datas = returnData.split("D");
        String enables = datas[0].substring(2);
        String disables = "";
        if (datas.length > 1) {
            disables = datas[1];
        }
        BeanWrapperImpl configWrapper = new BeanWrapperImpl((Object)this.capability);
        int i = 0;
        while (i < enables.length()) {
            ctrlName = enables.substring(i, i + 1).toUpperCase();
            fieldName = "capable" + ctrlName;
            enableName = "enable" + ctrlName;
            try {
                configWrapper.setPropertyValue(fieldName, (Object)true);
                configWrapper.setPropertyValue(enableName, (Object)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        i = 0;
        while (i < disables.length()) {
            ctrlName = disables.substring(i, i + 1).toUpperCase();
            fieldName = "capable" + ctrlName;
            enableName = "enable" + ctrlName;
            try {
                configWrapper.setPropertyValue(fieldName, (Object)false);
                configWrapper.setPropertyValue(enableName, (Object)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    @Override
    public String munitesBatteryTestCtrl(float minute) throws IOException, UnsupportException {
        String commandStr = "T";
        commandStr = minute < 1.0f ? String.valueOf(commandStr) + String.valueOf(minute).substring(1, 3) : (minute < 10.0f ? String.valueOf(commandStr) + "0" + (int)minute : String.valueOf(commandStr) + String.valueOf((int)minute));
        String returnData = this.excuteCommand(commandStr, true);
        return returnData;
    }

    @Override
    public String offBuzzerCtrl() throws IOException {
        String retStr = this.excuteCommand("BZOFF", true);
        return retStr;
    }

    @Override
    public String offSwitchCtrl() throws IOException {
        String delayShutdownTime = this.getDelayShutdownTime();
        String command = "Sn".replace("n", delayShutdownTime);
        return this.excuteCommand(command, true);
    }

    @Override
    public void offSwitchCtrl(int minutes) throws IOException {
        String delayShutdownTime = this.getDelayShutdownTime();
        minutes = minutes > 9999 ? 9999 : minutes;
        DecimalFormat df3 = new DecimalFormat("0000");
        String turnOnDelay = df3.format(minutes);
        String command = null;
        command = "SnRm".replace("n", delayShutdownTime).replace("m", turnOnDelay);
        this.excuteCommand(command, true);
    }

    @Override
    public String onBuzzerCtrl() throws IOException {
        String retStr = this.excuteCommand("BZON", true);
        return retStr;
    }

    @Override
    public boolean setPGR(String value) throws IOException {
        String returnData = this.excuteCommand("PGR" + value, true);
        return "(ACK".equalsIgnoreCase(returnData);
    }

    @Override
    public boolean setPBT(String value) throws IOException {
        String returnData = this.excuteCommand("PBT" + value, true);
        return "(ACK".equalsIgnoreCase(returnData);
    }

    @Override
    public String queryQGR() throws IOException {
        String dataStr = this.excuteCommand("QGR", true);
        return dataStr.substring(1);
    }

    @Override
    public String queryQBT() throws IOException {
        String dataStr = this.excuteCommand("QBT", true);
        return dataStr.substring(1);
    }

    @Override
    public void queryUpsInfo() throws IOException {
        String[] datas;
        block10: {
            datas = null;
            String status = null;
            String dataStr = this.excuteCommand("QGS", true);
            datas = dataStr.split(" ");
            status = datas[datas.length - 1];
            this.identity.setMorphological(this.queryMorphological(status));
            dataStr = this.excuteCommand("QMD", true);
            System.out.println(dataStr);
            datas = dataStr.split(" ");
            this.ratingInfo.setRatedCapacity(datas[1].substring(datas[1].lastIndexOf("#") + 1));
            this.identity.setIoPhase(datas[3]);
            this.workInfo.setIoPhase(datas[3]);
            this.identity.setInputRatingVoltage(datas[4]);
            this.identity.setOutputRatingVoltage(datas[5]);
            String sn = "";
            try {
                try {
                    sn = this.excuteCommand("QID", true);
                    sn = "(NAK".equals(sn) ? "----" : (sn != null && !"".equals(sn.trim()) ? sn.substring(1) : "----");
                }
                catch (Exception exception) {
                    this.identity.setProductSN(sn);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                this.identity.setProductSN(sn);
                throw throwable;
            }
            this.identity.setProductSN(sn);
        }
        datas = this.excuteCommand("QRI", true).split(" ");
        this.ratingInfo.setOutputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.identity.setInputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.identity.setOutputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.ratingInfo.setOutputRatingFrequency(String.valueOf(Float.parseFloat(datas[3])));
        this.ratingInfo.setOutputRatingCurrent(String.valueOf(Integer.parseInt(datas[1])));
        this.ratingInfo.setBatteryVoltage(String.valueOf(Float.parseFloat(datas[2])));
        String value = "";
        try {
            try {
                String qvfw = this.excuteCommand("QVFW", true);
                value = qvfw.substring(qvfw.indexOf(":") + 1);
            }
            catch (Exception exception) {
                this.identity.setFwVersion(value);
            }
        }
        finally {
            this.identity.setFwVersion(value);
        }
    }

    @Override
    public WorkInfo queryWorkInfo() {
        try {
            this.workInfo.setPtid("P31");
            this.workInfo.setCurrentTime(new Date());
            this.workInfo.setDeviceId(this.getDeviceId());
            String returnData = this.excuteCommand("QGS", true);
            String[] datas = returnData.split(" ");
            String status = datas[datas.length - 1];
            double outputV = StrConvert.toDouble(this.workInfo.getOutputVoltage());
            char utility = status.charAt(2);
            if (this.workInfo.isFirst()) {
                if (utility == '1') {
                    EventsHandler.putEvent(this.getDeviceName(), "1001");
                } else if (utility == '0') {
                    EventsHandler.putEvent(this.getDeviceName(), "1002");
                }
            } else if (utility == '1') {
                EventsHandler.removeEvent(this.getDeviceName(), "1002");
                EventsHandler.handleEvent(this.getDeviceName(), "1001", "P31", this.getDeviceId(), true);
            } else if (utility == '0' && outputV > 0.0) {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
                EventsHandler.handleEvent(this.getDeviceName(), "1002", "P31", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
            }
            if (status.charAt(5) == '1') {
                returnData = this.excuteCommand("QFS", true);
                if (!returnData.equals("(OK")) {
                    String[] faultDatas = returnData.split(" ");
                    String faultKind = faultDatas[0].substring(1);
                    FaultHandler.doFaultEventP31(faultKind, this.getDeviceName(), "P31", this.getDeviceId());
                    this.workInfo.setFaultKind(faultKind);
                }
            } else {
                FaultHandler.removeFaultEvent(this.getDeviceName());
                this.workInfo.setFaultKind(null);
            }
            this.workInfo.setMorphological(this.queryMorphological(status));
            this.workInfo.setBypassActive(status.charAt(4) == '1');
            this.workInfo.setShutdownActive(status.charAt(8) == '1');
            this.workInfo.setInputVoltage(datas[0].substring(1));
            this.workInfo.setInputFrequency(datas[1]);
            this.workInfo.setOutputVoltage(datas[2]);
            this.workInfo.setOutputFrequency(datas[3]);
            this.workInfo.setOutputCurrent(datas[4]);
            this.workInfo.setOutputLoadPercent(datas[5]);
            this.workInfo.setTemperature(datas[10]);
            returnData = this.excuteCommand("QMOD", true);
            if (returnData.equals("(P")) {
                this.workInfo.setWorkMode("Power on mode");
                this.isBatMod = false;
            } else if (returnData.equals("(S")) {
                this.workInfo.setWorkMode("Standby mode");
                this.isBatMod = false;
            } else if (returnData.equals("(Y")) {
                this.workInfo.setWorkMode("Bypass mode");
                this.isBatMod = false;
            } else if (returnData.equals("(L")) {
                this.workInfo.setWorkMode("Line mode");
                this.isBatMod = false;
            } else if (returnData.equals("(B")) {
                this.workInfo.setWorkMode("Battery mode");
                if (!this.isBatMod) {
                    this.shutdownOnBatteryMode();
                }
                this.isBatMod = true;
            } else if (returnData.equals("(T")) {
                this.workInfo.setWorkMode("Battery test mode");
                this.isBatMod = false;
            } else if (returnData.equals("(F")) {
                this.workInfo.setWorkMode("Fault mode");
                this.isBatMod = false;
            } else if (returnData.equals("(E")) {
                this.workInfo.setWorkMode("ECO mode");
                this.isBatMod = false;
            } else if (returnData.equals("(C")) {
                this.workInfo.setWorkMode("Converter mode");
                this.isBatMod = false;
            } else if (returnData.equals("(D")) {
                this.workInfo.setWorkMode("Shutdown mode");
                this.isBatMod = false;
            }
            returnData = this.excuteCommand("QBV", true);
            datas = returnData.split(" ");
            this.workInfo.setBatteryVoltage(datas[0].substring(1));
            int batteryCapacity = Integer.parseInt(datas[1]);
            this.workInfo.setBatteryCapacity(batteryCapacity);
            String warnStatus = this.excuteCommand("QWS", true);
            this.setWarningStatus(warnStatus.substring(1));
            this.queryCapability();
            this.workInfo.setFirst(false);
            this.workInfo.setClear(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.workInfo;
    }

    private void setWarningStatus(String warnStatus) {
        this.workInfo.clearWarning();
        this.refreshWarningStatus(warnStatus, 0, "4004");
        this.refreshWarningStatus(warnStatus, 1, "1003");
        this.refreshWarningStatus(warnStatus, 2, "1004");
        this.refreshWarningStatus(warnStatus, 3, "1005");
        this.refreshWarningStatus(warnStatus, 4, "2003");
        this.refreshWarningStatus(warnStatus, 5, "2004");
        this.refreshWarningStatus(warnStatus, 6, "4006");
        this.refreshWarningStatus(warnStatus, 7, "4001");
        this.refreshWarningStatus(warnStatus, 8, "5002");
        this.refreshWarningStatus(warnStatus, 9, "3005");
        this.refreshWarningStatus(warnStatus, 10, "3006");
        this.refreshWarningStatus(warnStatus, 11, "3007");
        this.refreshWarningStatus(warnStatus, 12, "3008");
        this.refreshWarningStatus(warnStatus, 13, "3010");
        this.refreshWarningStatus(warnStatus, 14, "3011");
        this.refreshWarningStatus(warnStatus, 15, "3012");
        this.refreshWarningStatus(warnStatus, 16, "3013");
        this.refreshWarningStatus(warnStatus, 17, "3014");
        this.refreshWarningStatus(warnStatus, 18, "3015");
        this.refreshWarningStatus(warnStatus, 19, "3016");
        this.refreshWarningStatus(warnStatus, 20, "3017");
        this.refreshWarningStatus(warnStatus, 21, "3018");
        this.refreshWarningStatus(warnStatus, 22, "3019");
        this.refreshWarningStatus(warnStatus, 23, "3020");
        this.refreshWarningStatus(warnStatus, 24, "8001");
        this.refreshWarningStatus(warnStatus, 25, "8002");
        this.refreshWarningStatus(warnStatus, 26, "8003");
        this.refreshWarningStatus(warnStatus, 27, "8004");
        this.refreshWarningStatus(warnStatus, 28, "8005");
        this.refreshWarningStatus(warnStatus, 29, "8006");
        this.refreshWarningStatus(warnStatus, 30, "8007");
        this.refreshWarningStatus(warnStatus, 31, "8008");
        this.refreshWarningStatus(warnStatus, 32, "8009");
        this.refreshWarningStatus(warnStatus, 33, "8010");
        this.refreshWarningStatus(warnStatus, 34, "8011");
        this.refreshWarningStatus(warnStatus, 35, "8012");
        this.refreshWarningStatus(warnStatus, 36, "8013");
        this.refreshWarningStatus(warnStatus, 37, "8014");
        this.refreshWarningStatus(warnStatus, 38, "8015");
        this.refreshWarningStatus(warnStatus, 39, "8016");
        this.refreshWarningStatus(warnStatus, 40, "8017");
        this.refreshWarningStatus(warnStatus, 41, "8018");
        this.refreshWarningStatus(warnStatus, 42, "8019");
        this.refreshWarningStatus(warnStatus, 43, "8020");
        this.refreshWarningStatus(warnStatus, 44, "8021");
        this.refreshWarningStatus(warnStatus, 45, "8022");
        this.refreshWarningStatus(warnStatus, 46, "8023");
        this.refreshWarningStatus(warnStatus, 47, "8024");
        this.refreshWarningStatus(warnStatus, 48, "8025");
        this.refreshWarningStatus(warnStatus, 49, "8026");
        this.refreshWarningStatus(warnStatus, 50, "8032");
        this.refreshWarningStatus(warnStatus, 51, "8033");
        this.refreshWarningStatus(warnStatus, 52, "8034");
        this.refreshWarningStatus(warnStatus, 53, "8035");
        this.refreshWarningStatus(warnStatus, 54, "3048");
        this.refreshWarningStatus(warnStatus, 55, "3049");
        this.refreshWarningStatus(warnStatus, 61, "4061");
    }

    @Override
    public String tenSencondsBatteryTestCtrl() throws IOException {
        return this.excuteCommand("T", true);
    }

    @Override
    public void testOperation() throws IOException {
        this.excuteCommand("TL", true);
    }

    @Override
    public boolean isSupportBatNum() {
        return this.supportBatNum;
    }

    @Override
    public void setSupportBatNum(boolean arg0) {
        this.supportBatNum = arg0;
    }
}

