/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.processor;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.data.bean.Bypass;
import cn.com.voltronicpower.data.bean.Capability;
import cn.com.voltronicpower.data.bean.HighEfficiencyVoltage;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.exception.FaultHandler;
import cn.com.voltronicpower.exception.UnsupportException;
import cn.com.voltronicpower.monitor.AbstractMonitorProcessor;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.utilities.StrConvert;
import cn.com.voltronicpower.work.BatteryTestEndHandler;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;
import org.springframework.beans.BeanWrapperImpl;

public class P09Processor
extends AbstractMonitorProcessor {
    private Capability capability = new Capability();

    public P09Processor(CommunicateHandlerInterface handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public String offSwitchCtrl() throws IOException {
        String delayShutdownTime = this.getDelayShutdownTime();
        String command = "Sn".replace("n", delayShutdownTime);
        return this.excuteCommand(command, true);
    }

    @Override
    public String cancelSwitchCtrl() throws IOException {
        return this.excuteCommand("CS", true);
    }

    @Override
    public String deepBatteryTestCtrl() throws IOException, UnsupportException {
        String returnData = this.excuteCommand("TL", true);
        return returnData;
    }

    public void queryBypass() throws IOException {
        if (this.bypass == null) {
            this.bypass = new Bypass();
        }
        String[] values = this.excuteCommand("QBYV", true).split(" ");
        this.bypass.setBypassHighVoltage(Integer.parseInt(values[0].substring(1)));
        this.bypass.setBypassLowVoltage(Integer.parseInt(values[1]));
        values = this.excuteCommand("QBYF", true).split(" ");
        this.bypass.setBypassHighFrequency(Float.parseFloat(values[0].substring(1)));
        this.bypass.setBypassLowFrequency(Float.parseFloat(values[1]));
        this.bypass.setMinBypassLowVoltage(60);
        this.bypass.setMaxBypassLowVoltage(140);
        this.bypass.setMinBypassHighVoltage(60);
        this.bypass.setMaxBypassHighVoltage(140);
        values = this.excuteCommand("QRI", true).split(" ");
        if (values[3].equals("60.0")) {
            this.bypass.setMinBypassLowFrequency(50.0f);
            this.bypass.setMaxBypassLowFrequency(59.0f);
            this.bypass.setMinBypassHighFrequency(61.0f);
            this.bypass.setMaxBypassHighFrequency(70.0f);
        } else if (values[3].equals("50.0")) {
            this.bypass.setMinBypassLowFrequency(40.0f);
            this.bypass.setMaxBypassLowFrequency(49.0f);
            this.bypass.setMinBypassHighFrequency(51.0f);
            this.bypass.setMaxBypassHighFrequency(60.0f);
        }
    }

    @Override
    public Capability getCapability() throws IOException, UnsupportException {
        return this.capability;
    }

    public void queryHighEfficiencyVoltage() throws IOException {
        if (this.voltage == null) {
            this.voltage = new HighEfficiencyVoltage();
        }
        String[] values = this.excuteCommand("QHE", true).split(" ");
        this.voltage.setHeh(Integer.parseInt(values[0].substring(1)));
        this.voltage.setHel(Integer.parseInt(values[1]));
        values = this.excuteCommand("QRI", true).split(" ");
        int nVol = (int)Float.parseFloat(values[0].substring(1));
        if (nVol >= 200) {
            this.voltage.setMinHel(nVol - 24);
            this.voltage.setMaxHel(nVol - 7);
            this.voltage.setMinHeh(nVol + 7);
            this.voltage.setMaxHeh(nVol + 24);
        } else {
            this.voltage.setMinHel(nVol - 12);
            this.voltage.setMaxHel(nVol - 3);
            this.voltage.setMinHeh(nVol + 3);
            this.voltage.setMaxHeh(nVol + 12);
        }
    }

    @Override
    public String munitesBatteryTestCtrl(float minute) throws IOException, UnsupportException {
        String commandStr = "T";
        commandStr = minute < 1.0f ? String.valueOf(commandStr) + String.valueOf(minute).substring(1, 3) : (minute < 10.0f ? String.valueOf(commandStr) + "0" + (int)minute : String.valueOf(commandStr) + String.valueOf((int)minute));
        String returnData = this.excuteCommand(commandStr, true);
        return returnData;
    }

    @Override
    public String offBuzzerCtrl() throws IOException {
        String retStr = this.excuteCommand("BZOFF", true);
        return retStr;
    }

    @Override
    public void offSwitchCtrl(int minutes) throws IOException {
        String delayShutdownTime = this.getDelayShutdownTime();
        minutes = minutes > 9999 ? 9999 : minutes;
        DecimalFormat df3 = new DecimalFormat("0000");
        String turnOnDelay = df3.format(minutes);
        String command = null;
        command = "SnRm".replace("n", delayShutdownTime).replace("m", turnOnDelay);
        this.excuteCommand(command, true);
    }

    @Override
    public String offSwitchCtrlOntime() throws IOException {
        return this.excuteCommand("SOFF", true);
    }

    @Override
    public String offSwitchCtrlOntime(int minutes) throws IOException {
        minutes = minutes > 9999 ? 9999 : minutes;
        DecimalFormat df3 = new DecimalFormat("0000");
        String turnOnDelay = df3.format(minutes);
        String command = null;
        command = "SnRm".replace("n", ".2").replace("m", turnOnDelay);
        String returnData = this.excuteCommand(command, true);
        System.out.println(String.valueOf(command) + "-----------offSwitchCtrlOntime: " + returnData);
        return "(ACK";
    }

    @Override
    public String onBuzzerCtrl() throws IOException {
        String retStr = this.excuteCommand("BZON", true);
        return retStr;
    }

    @Override
    public void queryUpsInfo() throws IOException {
        String[] datas;
        block10: {
            datas = null;
            String status = null;
            String dataStr = this.excuteCommand("QGS", true);
            datas = dataStr.split(" ");
            status = datas[datas.length - 1];
            this.identity.setMorphological(this.queryMorphological(status));
            dataStr = this.excuteCommand("QMD", true);
            datas = dataStr.split(" ");
            this.ratingInfo.setRatedCapacity(datas[1].substring(datas[1].lastIndexOf("#") + 1));
            this.identity.setIoPhase(datas[3]);
            this.workInfo.setIoPhase(datas[3]);
            this.identity.setInputRatingVoltage(datas[4]);
            this.identity.setOutputRatingVoltage(datas[5]);
            String sn = "";
            try {
                try {
                    sn = this.excuteCommand("QID", true);
                    sn = "(NAK".equals(sn) ? "----" : (!"".equals(sn.trim()) ? sn.substring(1) : "----");
                }
                catch (Exception exception) {
                    this.identity.setProductSN(sn);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                this.identity.setProductSN(sn);
                throw throwable;
            }
            this.identity.setProductSN(sn);
        }
        datas = this.excuteCommand("QRI", true).split(" ");
        this.ratingInfo.setOutputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.identity.setInputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.identity.setOutputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.ratingInfo.setOutputRatingFrequency(String.valueOf(Float.parseFloat(datas[3])));
        this.ratingInfo.setOutputRatingCurrent(String.valueOf(Integer.parseInt(datas[1])));
        this.ratingInfo.setBatteryVoltage(String.valueOf(Float.parseFloat(datas[2])));
        datas = this.excuteCommand("QBV", true).split(" ");
        this.batteryNumber.setBatn(Integer.parseInt(datas[1]));
        this.batteryNumber.setBatgn(Integer.parseInt(datas[2]));
        String value = "";
        try {
            try {
                String qvfw = this.excuteCommand("QVFW", true);
                value = qvfw.substring(qvfw.indexOf(":") + 1);
            }
            catch (Exception exception) {
                this.identity.setFwVersion(value);
            }
        }
        finally {
            this.identity.setFwVersion(value);
        }
    }

    @Override
    public WorkInfo queryWorkInfo() {
        try {
            this.workInfo.setPtid("P09");
            this.workInfo.setCurrentTime(new Date());
            this.workInfo.setDeviceId(this.getDeviceId());
            String returnData = this.excuteCommand("QGS", true);
            String[] datas = returnData.split(" ");
            String status = datas[datas.length - 1];
            this.shutdownOnlowBattery(status.charAt(2) != '1', status.charAt(3) == '1');
            if (status.charAt(9) == '1') {
                this.workInfo.setBuzzerCtrl(false);
            } else {
                this.workInfo.setBuzzerCtrl(true);
            }
            double outputV = StrConvert.toDouble(this.workInfo.getOutputVoltage());
            char utility = status.charAt(2);
            if (this.workInfo.isFirst()) {
                if (utility == '1') {
                    EventsHandler.putEvent(this.getDeviceName(), "1001");
                } else if (utility == '0') {
                    EventsHandler.putEvent(this.getDeviceName(), "1002");
                }
            } else if (utility == '1') {
                EventsHandler.removeEvent(this.getDeviceName(), "1002");
                EventsHandler.handleEvent(this.getDeviceName(), "1001", "P09", this.getDeviceId(), true);
            } else if (utility == '0' && outputV > 0.0) {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
                EventsHandler.handleEvent(this.getDeviceName(), "1002", "P09", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
            }
            if (status.charAt(5) == '1') {
                returnData = this.excuteCommand("QFS", true);
                if (!returnData.equals("(OK")) {
                    String[] faultDatas = returnData.split(" ");
                    String faultKind = faultDatas[0].substring(1);
                    FaultHandler.doFaultEvent(faultKind, this.getDeviceName(), "P09", this.getDeviceId());
                    this.workInfo.setFaultKind(faultKind);
                }
            } else {
                FaultHandler.removeFaultEvent(this.getDeviceName());
                this.workInfo.setFaultKind(null);
            }
            if (this.lastSelfTestProgress == '1' && status.charAt(7) == '0') {
                BatteryTestEndHandler.endEvent(this.getDeviceName(), "P09", status);
            }
            this.lastSelfTestProgress = status.charAt(7);
            this.workInfo.setMorphological(this.queryMorphological(status));
            this.workInfo.setBypassActive(status.charAt(4) == '1');
            if (this.workInfo.isFirst()) {
                if (this.workInfo.isBypassActive()) {
                    EventsHandler.putEvent(this.getDeviceName(), "2001");
                } else {
                    EventsHandler.putEvent(this.getDeviceName(), "2002");
                }
            } else if (this.workInfo.isBypassActive()) {
                EventsHandler.removeEvent(this.getDeviceName(), "2002");
                EventsHandler.handleEvent(this.getDeviceName(), "2001", "P09", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "2001");
                EventsHandler.handleEvent(this.getDeviceName(), "2002", "P09", this.getDeviceId(), true);
            }
            this.workInfo.setInputFrequency(datas[1]);
            this.workInfo.setOutputFrequency(datas[3]);
            this.workInfo.setTemperature(datas[10]);
            Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
            float overTempValue = shutdown.getOverTemperatureValue();
            if (StrConvert.toFloat(this.workInfo.getTemperatureView()) >= overTempValue) {
                if (!this.isOverTemperature) {
                    new Thread(){

                        @Override
                        public void run() {
                            P09Processor.this.isOverTemperature = true;
                            P09Processor.this.shutdownOverTemperature();
                        }
                    }.start();
                }
            } else {
                this.isOverTemperature = false;
            }
            returnData = this.excuteCommand("Q3PV", true);
            String[] inputDatas = returnData.split(" ");
            this.workInfo.setInputVoltage(inputDatas[0].substring(1));
            this.workInfo.setInputVoltageS(inputDatas[1]);
            this.workInfo.setInputVoltageT(inputDatas[2]);
            this.workInfo.setInputVoltageL1L2(inputDatas[3]);
            this.workInfo.setInputVoltageL1L3(inputDatas[4]);
            this.workInfo.setInputVoltageL2L3(inputDatas[5]);
            returnData = this.excuteCommand("Q3OV", true);
            String[] outputDatas = returnData.split(" ");
            this.workInfo.setOutputVoltage(outputDatas[0].substring(1));
            this.workInfo.setOutputVoltageS(outputDatas[1]);
            this.workInfo.setOutputVoltageT(outputDatas[2]);
            this.workInfo.setOutputVoltageL1L2(outputDatas[3]);
            this.workInfo.setOutputVoltageL1L3(outputDatas[4]);
            this.workInfo.setOutputVoltageL2L3(outputDatas[5]);
            returnData = this.excuteCommand("Q3OC", true);
            String[] currents = returnData.split(" ");
            this.workInfo.setOutputCurrent(currents[0].substring(1));
            this.workInfo.setOutputCurrentS(currents[1]);
            this.workInfo.setOutputCurrentT(currents[2]);
            returnData = this.excuteCommand("QPD", true);
            String[] angles = returnData.split(" ");
            this.workInfo.setIntputAngle(angles[0].substring(1));
            this.workInfo.setOutputAngle(angles[1]);
            returnData = this.excuteCommand("Q3LD", true);
            String[] loads = returnData.split(" ");
            this.workInfo.setLoadLevel(loads[0].substring(1));
            this.workInfo.setLoadLevelS(loads[1]);
            this.workInfo.setLoadLevelT(loads[2]);
            this.workInfo.setOutputLoadPercent(loads[3]);
            returnData = this.excuteCommand("Q3YV", true);
            String[] bypass = returnData.split(" ");
            this.workInfo.setBypassVoltage(bypass[0].substring(1));
            this.workInfo.setBypassVoltageS(bypass[1]);
            this.workInfo.setBypassVoltageT(bypass[2]);
            this.workInfo.setBypassFrequency(this.workInfo.getInputFrequency());
            returnData = this.excuteCommand("QMOD", true);
            if (returnData.equals("(P")) {
                this.workInfo.setWorkMode("Power on mode");
                this.isBatMod = false;
            } else if (returnData.equals("(S")) {
                this.workInfo.setWorkMode("Standby mode");
                this.isBatMod = false;
            } else if (returnData.equals("(Y")) {
                this.workInfo.setWorkMode("Bypass mode");
                this.isBatMod = false;
            } else if (returnData.equals("(L")) {
                this.workInfo.setWorkMode("Line mode");
                this.isBatMod = false;
            } else if (returnData.equals("(B")) {
                this.workInfo.setWorkMode("Battery mode");
                if (!this.isBatMod) {
                    this.shutdownOnBatteryMode();
                }
                this.isBatMod = true;
            } else if (returnData.equals("(T")) {
                this.workInfo.setWorkMode("Battery test mode");
                this.isBatMod = false;
            } else if (returnData.equals("(F")) {
                this.workInfo.setWorkMode("Fault mode");
                this.isBatMod = false;
            } else if (returnData.equals("(E")) {
                this.workInfo.setWorkMode("ECO mode");
                this.isBatMod = false;
            } else if (returnData.equals("(C")) {
                this.workInfo.setWorkMode("Converter mode");
                this.isBatMod = false;
            } else if (returnData.equals("(D")) {
                this.workInfo.setWorkMode("Shutdown mode");
                this.isBatMod = false;
            }
            String warnStatus = this.excuteCommand("QWS", true);
            String warnStr = warnStatus.substring(1);
            this.setWarningStatus(warnStr);
            if (warnStr.charAt(0) == '1') {
                this.workInfo.setBatteryCapacity(0);
                this.workInfo.setBatteryVoltage("0");
                this.workInfo.setBatteryRemainTime(0);
                this.workInfo.setGroupNum("0");
            } else {
                returnData = this.excuteCommand("QBV", true);
                datas = returnData.split(" ");
                int batteryCapacity = Integer.parseInt(datas[3]);
                int batCapacity = shutdown.getBatCapacity();
                if ("Battery mode".equals(this.workInfo.getWorkMode()) && batteryCapacity <= batCapacity) {
                    if (!this.isBatCap && ("InfoPower".equalsIgnoreCase(MyConstants.Customized) || "NetGuard".equalsIgnoreCase(MyConstants.Customized) || "ATMUSE".equalsIgnoreCase(MyConstants.Customized))) {
                        new Thread(){

                            @Override
                            public void run() {
                                P09Processor.this.isBatCap = true;
                                P09Processor.this.shutdownOnBatteryCapacity();
                            }
                        }.start();
                    }
                } else {
                    this.isBatCap = false;
                }
                this.workInfo.setBatteryCapacity(batteryCapacity);
                this.workInfo.setBatteryVoltage(datas[0].substring(1));
                this.workInfo.setBatteryRemainTime(Integer.parseInt(datas[4]));
                this.workInfo.setGroupNum(datas[2]);
            }
            this.queryCapability();
            this.queryBypass();
            this.queryHighEfficiencyVoltage();
            this.workInfo.setInsertBypass(true);
            this.workInfo.setInsertInput(true);
            this.workInfo.setInsertOutput(true);
            this.workInfo.setFirst(false);
            this.workInfo.setClear(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.workInfo;
    }

    private void queryCapability() throws IOException {
        String enableName;
        String fieldName;
        String ctrlName;
        String returnData = this.excuteCommand("QFLAG", true);
        String[] datas = returnData.split("D");
        String enables = datas[0].substring(2);
        String disables = "";
        if (datas.length > 1) {
            disables = datas[1];
        }
        BeanWrapperImpl configWrapper = new BeanWrapperImpl((Object)this.capability);
        int i = 0;
        while (i < enables.length()) {
            ctrlName = enables.substring(i, i + 1).toUpperCase();
            fieldName = "capable" + ctrlName;
            enableName = "enable" + ctrlName;
            try {
                configWrapper.setPropertyValue(fieldName, (Object)true);
                configWrapper.setPropertyValue(enableName, (Object)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        i = 0;
        while (i < disables.length()) {
            ctrlName = disables.substring(i, i + 1).toUpperCase();
            fieldName = "capable" + ctrlName;
            enableName = "enable" + ctrlName;
            try {
                configWrapper.setPropertyValue(fieldName, (Object)false);
                configWrapper.setPropertyValue(enableName, (Object)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    private void setWarningStatus(String warnStatus) {
        this.workInfo.clearWarning();
        this.refreshWarningStatus(warnStatus, 0, "4004");
        this.refreshWarningStatus(warnStatus, 1, "1003");
        this.refreshWarningStatus(warnStatus, 2, "1004");
        this.refreshWarningStatus(warnStatus, 3, "1005");
        this.refreshWarningStatus(warnStatus, 4, "2003");
        this.refreshWarningStatus(warnStatus, 5, "2004");
        this.refreshWarningStatus(warnStatus, 6, "4006");
        this.refreshWarningStatus(warnStatus, 7, "4001");
        this.refreshWarningStatus(warnStatus, 8, "5002");
        this.refreshWarningStatus(warnStatus, 9, "3005");
        this.refreshWarningStatus(warnStatus, 10, "3006");
        this.refreshWarningStatus(warnStatus, 11, "3007");
        this.refreshWarningStatus(warnStatus, 12, "3008");
        this.refreshWarningStatus(warnStatus, 13, "3010");
        this.refreshWarningStatus(warnStatus, 14, "3011");
        this.refreshWarningStatus(warnStatus, 15, "3012");
        this.refreshWarningStatus(warnStatus, 16, "3013");
        this.refreshWarningStatus(warnStatus, 17, "3014");
        this.refreshWarningStatus(warnStatus, 18, "3015");
        this.refreshWarningStatus(warnStatus, 19, "3016");
        this.refreshWarningStatus(warnStatus, 20, "3017");
        this.refreshWarningStatus(warnStatus, 21, "3018");
        this.refreshWarningStatus(warnStatus, 22, "3019");
        this.refreshWarningStatus(warnStatus, 23, "3020");
        this.refreshWarningStatus(warnStatus, 24, "8001");
        this.refreshWarningStatus(warnStatus, 25, "8002");
        this.refreshWarningStatus(warnStatus, 26, "8003");
        this.refreshWarningStatus(warnStatus, 27, "8004");
        this.refreshWarningStatus(warnStatus, 28, "8005");
        this.refreshWarningStatus(warnStatus, 29, "8006");
        this.refreshWarningStatus(warnStatus, 30, "8007");
        this.refreshWarningStatus(warnStatus, 31, "8008");
        this.refreshWarningStatus(warnStatus, 32, "8009");
        this.refreshWarningStatus(warnStatus, 33, "8010");
        this.refreshWarningStatus(warnStatus, 34, "8011");
        this.refreshWarningStatus(warnStatus, 35, "8012");
        this.refreshWarningStatus(warnStatus, 36, "8013");
        this.refreshWarningStatus(warnStatus, 37, "8014");
        this.refreshWarningStatus(warnStatus, 38, "8015");
        this.refreshWarningStatus(warnStatus, 39, "8016");
        this.refreshWarningStatus(warnStatus, 40, "8017");
        this.refreshWarningStatus(warnStatus, 41, "8018");
        this.refreshWarningStatus(warnStatus, 42, "8019");
        this.refreshWarningStatus(warnStatus, 43, "8020");
        this.refreshWarningStatus(warnStatus, 44, "8021");
        this.refreshWarningStatus(warnStatus, 45, "8022");
        this.refreshWarningStatus(warnStatus, 46, "8023");
        this.refreshWarningStatus(warnStatus, 47, "8024");
        this.refreshWarningStatus(warnStatus, 48, "8025");
        this.refreshWarningStatus(warnStatus, 49, "8026");
        this.refreshWarningStatus(warnStatus, 50, "8032");
        this.refreshWarningStatus(warnStatus, 51, "8033");
        this.refreshWarningStatus(warnStatus, 52, "8034");
        this.refreshWarningStatus(warnStatus, 53, "8035");
        this.refreshWarningStatus(warnStatus, 54, "3048");
        this.refreshWarningStatus(warnStatus, 55, "3049");
        this.refreshWarningStatus(warnStatus, 56, "3101");
        this.refreshWarningStatus(warnStatus, 57, "3102");
    }

    @Override
    public String tenSencondsBatteryTestCtrl() throws IOException {
        return this.excuteCommand("T", true);
    }

    @Override
    public void testOperation() throws IOException {
        this.excuteCommand("TL", true);
    }

    @Override
    public String queryQBT() throws IOException {
        return null;
    }

    @Override
    public String queryQGR() throws IOException {
        return null;
    }

    @Override
    public boolean setPBT(String value) throws IOException {
        return false;
    }

    @Override
    public boolean setPGR(String value) throws IOException {
        return false;
    }

    @Override
    public boolean isSupportBatNum() {
        return this.supportBatNum;
    }

    @Override
    public void setSupportBatNum(boolean arg0) {
        this.supportBatNum = arg0;
    }
}

