/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.processor;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.data.bean.Capability;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.exception.FaultHandler;
import cn.com.voltronicpower.monitor.processor.P01Processor;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.utilities.StrConvert;
import cn.com.voltronicpower.work.BatteryTestEndHandler;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;
import org.springframework.beans.BeanWrapperImpl;

public class P05Processor
extends P01Processor {
    private Capability capability = new Capability();

    public P05Processor(CommunicateHandlerInterface handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public void queryUpsInfo() throws IOException {
        String[] datas;
        block10: {
            datas = null;
            String status = null;
            String dataStr = this.excuteCommand("QGS", true);
            datas = dataStr.split(" ");
            status = datas[datas.length - 1];
            this.identity.setMorphological(this.queryMorphological(status));
            dataStr = this.excuteCommand("QMD", true).substring(1);
            datas = dataStr.split(" ");
            this.identity.setUpsModelName(datas[0].substring(datas[0].lastIndexOf("#") + 1));
            this.ratingInfo.setRatedCapacity(datas[1].substring(datas[1].lastIndexOf("#") + 1));
            this.identity.setIoPhase(datas[3]);
            this.workInfo.setIoPhase(datas[3]);
            this.identity.setInputRatingVoltage(datas[4]);
            this.identity.setOutputRatingVoltage(datas[5]);
            datas = this.excuteCommand("QBV", true).split(" ");
            this.batteryNumber.setBatn(Integer.parseInt(datas[1]));
            this.batteryNumber.setBatgn(Integer.parseInt(datas[2]));
            String sn = "";
            try {
                try {
                    sn = this.excuteCommand("QID", true);
                    sn = "(NAK".equals(sn) ? "----" : (!"".equals(sn.trim()) ? sn.substring(1) : "----");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.identity.setProductSN(sn);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                this.identity.setProductSN(sn);
                throw throwable;
            }
            this.identity.setProductSN(sn);
        }
        datas = this.excuteCommand("QRI", true).split(" ");
        this.ratingInfo.setOutputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.identity.setInputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.identity.setOutputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.ratingInfo.setOutputRatingFrequency(String.valueOf(Float.parseFloat(datas[3])));
        this.ratingInfo.setOutputRatingCurrent(String.valueOf(Integer.parseInt(datas[1])));
        this.ratingInfo.setBatteryVoltage(String.valueOf(Float.parseFloat(datas[2])));
        String value = "";
        try {
            try {
                String qvfw = this.excuteCommand("QVFW", true);
                value = qvfw.substring(qvfw.indexOf(":") + 1);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.identity.setFwVersion(value);
            }
        }
        finally {
            this.identity.setFwVersion(value);
        }
    }

    @Override
    public WorkInfo queryWorkInfo() {
        try {
            this.workInfo.setPtid("P05");
            this.workInfo.setCurrentTime(new Date());
            this.workInfo.setDeviceId(this.getDeviceId());
            String returnData = this.excuteCommand("QGS", true);
            String[] datas = returnData.split(" ");
            String status = datas[datas.length - 1];
            this.shutdownOnlowBattery(status.charAt(2) != '1', status.charAt(3) == '1');
            if (status.charAt(9) == '1') {
                this.workInfo.setBuzzerCtrl(false);
            } else {
                this.workInfo.setBuzzerCtrl(true);
            }
            this.workInfo.setInputVoltage(datas[0].substring(1));
            this.workInfo.setInputFrequency(datas[1]);
            this.workInfo.setOutputVoltage(datas[2]);
            this.workInfo.setOutputFrequency(datas[3]);
            this.workInfo.setOutputCurrent(datas[4]);
            this.workInfo.setOutputLoadPercent(datas[5]);
            this.workInfo.setTemperature(datas[10]);
            double outputV = StrConvert.toDouble(this.workInfo.getOutputVoltage());
            char utility = status.charAt(2);
            if (this.workInfo.isFirst()) {
                if (utility == '1') {
                    EventsHandler.putEvent(this.getDeviceName(), "1001");
                } else if (utility == '0') {
                    EventsHandler.putEvent(this.getDeviceName(), "1002");
                }
            } else if (utility == '1') {
                EventsHandler.removeEvent(this.getDeviceName(), "1002");
                EventsHandler.handleEvent(this.getDeviceName(), "1001", "P05", this.getDeviceId(), true);
            } else if (utility == '0' && outputV > 0.0) {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
                EventsHandler.handleEvent(this.getDeviceName(), "1002", "P05", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
            }
            if (status.charAt(5) == '1') {
                returnData = this.excuteCommand("QFS", true);
                if (!returnData.equals("(OK")) {
                    String[] faultDatas = returnData.split(" ");
                    String faultKind = faultDatas[0].substring(1);
                    FaultHandler.doFaultEventP05(faultKind, this.getDeviceName(), "P05", this.getDeviceId());
                    this.workInfo.setFaultKind(faultKind);
                }
            } else {
                FaultHandler.removeFaultEvent(this.getDeviceName());
                this.workInfo.setFaultKind(null);
            }
            if (this.lastSelfTestProgress == '1' && status.charAt(7) == '0') {
                BatteryTestEndHandler.endEvent(this.getDeviceName(), "P05", status);
            }
            this.lastSelfTestProgress = status.charAt(7);
            this.workInfo.setMorphological(this.queryMorphological(status));
            this.workInfo.setBypassActive(status.charAt(4) == '1');
            if (this.workInfo.isFirst()) {
                if (this.workInfo.isBypassActive()) {
                    EventsHandler.putEvent(this.getDeviceName(), "2001");
                } else {
                    EventsHandler.putEvent(this.getDeviceName(), "2002");
                }
            } else if (this.workInfo.isBypassActive()) {
                EventsHandler.removeEvent(this.getDeviceName(), "2002");
                EventsHandler.handleEvent(this.getDeviceName(), "2001", "P05", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "2001");
                EventsHandler.handleEvent(this.getDeviceName(), "2002", "P05", this.getDeviceId(), true);
            }
            Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
            float overTempValue = shutdown.getOverTemperatureValue();
            if (StrConvert.toFloat(this.workInfo.getTemperatureView()) >= overTempValue) {
                if (!this.isOverTemperature) {
                    new Thread(){

                        @Override
                        public void run() {
                            P05Processor.this.isOverTemperature = true;
                            P05Processor.this.shutdownOverTemperature();
                        }
                    }.start();
                }
            } else {
                this.isOverTemperature = false;
            }
            if ((returnData = this.excuteCommand("QMOD", true)).equals("(P")) {
                this.workInfo.setWorkMode("Power on mode");
                this.isBatMod = false;
            } else if (returnData.equals("(S")) {
                this.workInfo.setWorkMode("Standby mode");
                this.isBatMod = false;
            } else if (returnData.equals("(Y")) {
                this.workInfo.setWorkMode("Bypass mode");
                this.isBatMod = false;
            } else if (returnData.equals("(L")) {
                this.workInfo.setWorkMode("Line mode");
                this.isBatMod = false;
            } else if (returnData.equals("(B")) {
                this.workInfo.setWorkMode("Battery mode");
                if (!this.isBatMod) {
                    this.shutdownOnBatteryMode();
                }
                this.isBatMod = true;
            } else if (returnData.equals("(T")) {
                this.workInfo.setWorkMode("Battery test mode");
                this.isBatMod = false;
            } else if (returnData.equals("(F")) {
                this.workInfo.setWorkMode("Fault mode");
                this.isBatMod = false;
            } else if (returnData.equals("(E")) {
                this.workInfo.setWorkMode("ECO mode");
                this.isBatMod = false;
            } else if (returnData.equals("(C")) {
                this.workInfo.setWorkMode("Converter mode");
                this.isBatMod = false;
            } else if (returnData.equals("(D")) {
                this.workInfo.setWorkMode("Shutdown mode");
                this.isBatMod = false;
            }
            String warnStatus = this.excuteCommand("QWS", true);
            String warnStr = warnStatus.substring(1);
            this.setWarningStatus(warnStr);
            if (warnStr.charAt(0) == '1') {
                this.workInfo.setBatteryCapacity(0);
                this.workInfo.setBatteryVoltage("0");
                this.workInfo.setBatteryRemainTime(0);
                this.workInfo.setGroupNum("0");
            } else {
                returnData = this.excuteCommand("QBV", true);
                datas = returnData.split(" ");
                int batteryCapacity = Integer.parseInt(datas[3]);
                int batCapacity = shutdown.getBatCapacity();
                if ("Battery mode".equals(this.workInfo.getWorkMode()) && batteryCapacity <= batCapacity) {
                    if (!this.isBatCap && ("InfoPower".equalsIgnoreCase(MyConstants.Customized) || "NetGuard".equalsIgnoreCase(MyConstants.Customized) || "ATMUSE".equalsIgnoreCase(MyConstants.Customized))) {
                        new Thread(){

                            @Override
                            public void run() {
                                P05Processor.this.isBatCap = true;
                                P05Processor.this.shutdownOnBatteryCapacity();
                            }
                        }.start();
                    }
                } else {
                    this.isBatCap = false;
                }
                this.workInfo.setBatteryCapacity(batteryCapacity);
                this.workInfo.setBatteryVoltage(datas[0].substring(1));
                this.workInfo.setBatteryRemainTime(Integer.parseInt(datas[4]));
                this.workInfo.setGroupNum(datas[2]);
            }
            this.workInfo.setBatteryLife(this.firstLife);
            String os1Status = this.excuteCommand("QSK1", true);
            String os2Status = this.excuteCommand("QSK2", true);
            if (this.workInfo.isFirst()) {
                if (os1Status.equals("(1")) {
                    EventsHandler.putEvent(this.getDeviceName(), "3001");
                } else if (os1Status.equals("(0")) {
                    EventsHandler.putEvent(this.getDeviceName(), "3002");
                }
                if (os2Status.equals("(1")) {
                    EventsHandler.putEvent(this.getDeviceName(), "3003");
                } else if (os2Status.equals("(0")) {
                    EventsHandler.putEvent(this.getDeviceName(), "3004");
                }
            } else {
                System.out.println("os1Status--" + os1Status);
                if (os1Status.equals("(1")) {
                    EventsHandler.removeEvent(this.getDeviceName(), "3002");
                    EventsHandler.handleEvent(this.getDeviceName(), "3001", "P05", this.getDeviceId(), true);
                    this.workInfo.setEnableOutlet1(true);
                } else if (os1Status.equals("(0")) {
                    EventsHandler.removeEvent(this.getDeviceName(), "3001");
                    EventsHandler.handleEvent(this.getDeviceName(), "3002", "P05", this.getDeviceId(), true);
                    this.workInfo.setEnableOutlet1(false);
                }
                if (os2Status.equals("(1")) {
                    EventsHandler.removeEvent(this.getDeviceName(), "3004");
                    EventsHandler.handleEvent(this.getDeviceName(), "3003", "P05", this.getDeviceId(), true);
                    this.workInfo.setEnableOutlet2(true);
                } else if (os2Status.equals("(0")) {
                    EventsHandler.removeEvent(this.getDeviceName(), "3003");
                    EventsHandler.handleEvent(this.getDeviceName(), "3004", "P05", this.getDeviceId(), true);
                    this.workInfo.setEnableOutlet2(false);
                }
            }
            this.queryCapability();
            System.out.println(22);
            this.queryBypass();
            this.queryHighEfficiencyVoltage();
            System.out.println(33);
            this.queryParameterSettings();
            System.out.println("???????????????");
            this.workInfo.setFirst(false);
            System.out.println("sssss");
            this.workInfo.setClear(false);
            this.reconnectTimes = 0;
        }
        catch (Exception e) {
            System.out.println("jinrucatsh" + e.getMessage());
            this.logingCommunicateException(false);
        }
        return this.workInfo;
    }

    public void queryParameterSettings() throws IOException {
        String totalAH = null;
        try {
            totalAH = this.excuteCommand("QBTAH", true).split(" ")[1];
        }
        catch (Exception e) {
            totalAH = this.excuteCommand("QBTAH", true).substring(1).split(" ")[0];
            e.printStackTrace();
        }
        System.out.println("QBTAH");
        this.batteryNumber.setBatTotalAHValue(StrConvert.toInteger(totalAH.substring(1)));
        String batstopDelay = this.excuteCommand("QBKTM", true).substring(1);
        this.param.setBatTestStopTime(StrConvert.toInteger(batstopDelay));
        String epoFunction = this.excuteCommand("QREPO", true).substring(1);
        this.param.setEpoFunction(StrConvert.toInteger(epoFunction));
        String periodSelf = this.excuteCommand("QPST", true);
        this.param.setPeriodSelfTest(StrConvert.toInteger(periodSelf.substring(5)));
        String[] dryInAndOut = this.excuteCommand("QDRY", true).substring(1).split(" ");
        this.param.setDryContactIn(dryInAndOut[0]);
        this.param.setDryContactOut(dryInAndOut[1]);
        String lcdDisplay = this.excuteCommand("QLCD", true).substring(1);
        this.param.setLCDdisPlay(lcdDisplay);
    }

    @Override
    public void queryBypass() throws IOException {
        String[] values = this.excuteCommand("QBYV", true).split(" ");
        this.bypass.setBypassHighVoltage(Integer.parseInt(values[0].substring(1)));
        this.bypass.setBypassLowVoltage(Integer.parseInt(values[1]));
        values = this.excuteCommand("QBYF", true).split(" ");
        this.bypass.setBypassHighFrequency(Float.parseFloat(values[0].substring(1)));
        this.bypass.setBypassLowFrequency(Float.parseFloat(values[1]));
        this.bypass.setMinBypassLowVoltage(176);
        this.bypass.setMaxBypassLowVoltage(264);
        this.bypass.setMinBypassHighVoltage(176);
        this.bypass.setMaxBypassHighVoltage(276);
        values = this.excuteCommand("QRI", true).split(" ");
        if (values[3].equals("60.0")) {
            this.bypass.setMinBypassLowFrequency(50.0f);
            this.bypass.setMaxBypassLowFrequency(59.0f);
            this.bypass.setMinBypassHighFrequency(61.0f);
            this.bypass.setMaxBypassHighFrequency(70.0f);
        } else {
            this.bypass.setMinBypassLowFrequency(40.0f);
            this.bypass.setMaxBypassLowFrequency(49.0f);
            this.bypass.setMinBypassHighFrequency(51.0f);
            this.bypass.setMaxBypassHighFrequency(60.0f);
        }
    }

    @Override
    public void queryHighEfficiencyVoltage() throws IOException {
        String[] values = this.excuteCommand("QHE", true).split(" ");
        this.voltage.setHeh(Integer.parseInt(values[0].substring(1)));
        this.voltage.setHel(Integer.parseInt(values[1]));
        values = this.excuteCommand("QHEF", true).split(" ");
        this.voltage.setHeFh(Float.parseFloat(values[0].substring(1)));
        this.voltage.setHeFl(Float.parseFloat(values[1]));
        this.voltage.setMinHel(1);
        this.voltage.setMaxHel(300);
        this.voltage.setMinHeh(1);
        this.voltage.setMaxHeh(300);
    }

    private void queryCapability() throws IOException {
        String enableName;
        String fieldName;
        String ctrlName;
        String returnData = this.excuteCommand("QFLAG", true);
        String[] datas = returnData.split("D");
        String enables = datas[0].substring(2);
        String disables = "";
        if (datas.length > 1) {
            disables = datas[1];
        }
        BeanWrapperImpl configWrapper = new BeanWrapperImpl((Object)this.capability);
        int i = 0;
        while (i < enables.length()) {
            ctrlName = enables.substring(i, i + 1);
            fieldName = "capable" + ctrlName;
            enableName = "enable" + ctrlName;
            try {
                configWrapper.setPropertyValue(fieldName, (Object)true);
                configWrapper.setPropertyValue(enableName, (Object)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        i = 0;
        while (i < disables.length()) {
            ctrlName = disables.substring(i, i + 1);
            fieldName = "capable" + ctrlName;
            enableName = "enable" + ctrlName;
            try {
                configWrapper.setPropertyValue(fieldName, (Object)false);
                configWrapper.setPropertyValue(enableName, (Object)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    @Override
    public Capability getCapability() throws IOException {
        return this.capability;
    }

    private void setWarningStatus(String warnStatus) {
        this.workInfo.clearWarning();
        this.refreshWarningStatus(warnStatus, 0, "4004");
        this.refreshWarningStatus(warnStatus, 5, "2004");
        this.refreshWarningStatus(warnStatus, 6, "4006");
        this.refreshWarningStatus(warnStatus, 7, "4001");
        this.refreshWarningStatus(warnStatus, 8, "5002");
        this.refreshWarningStatus(warnStatus, 12, "3008");
        this.refreshWarningStatus(warnStatus, 13, "3010");
        this.refreshWarningStatus(warnStatus, 55, "3049");
        this.refreshWarningStatus(warnStatus, 60, "3622");
        this.refreshWarningStatus(warnStatus, 61, "4061");
        this.refreshWarningStatus(warnStatus, 62, "3813");
        this.refreshWarningStatus(warnStatus, 63, "3814");
    }

    @Override
    public String setTotalCapacity(int value) throws IOException {
        String val = "";
        val = value < 10 ? "00" + value : (value < 100 ? "0" + value : String.valueOf(value));
        System.out.println("-------------setTotalCapacity:" + value + "|" + val);
        String command = "BATTAH" + val;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            this.queryUpsInfo();
            return "success";
        }
        return "failure";
    }

    @Override
    public String setEpoFunction(int value) throws IOException {
        String var = "0" + value;
        String command = "SEAF" + var;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setHeh(int value) throws IOException {
        String command = "HEH" + String.format("%02d", value);
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setHel(int value) throws IOException {
        String command = "HEL" + String.format("%02d", value);
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setFreh(float value) throws IOException {
        String command = "HEFH" + String.format("%02d", (int)value);
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setFrel(float value) throws IOException {
        String command = "HEFL" + String.format("%02d", (int)value);
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    public String setDryCobtactIn(String value) {
        String command = "DRYI" + value;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    public String setDryCobtactOut(String value) {
        String command = "DRYO" + value;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setPeriodSelfTest(int value) throws IOException {
        String str = String.format("%02d", value);
        String command = "PST" + str;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setBatShutdownDelay(int value) throws IOException {
        String str = String.format("%03d", value);
        String command = "MD" + str;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    public String setLCDdisplay(String value) throws IOException {
        String command = "LCD" + value;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public int getOutputSocketDelayTime(String socketNum) throws IOException {
        String command = "QSKT" + socketNum;
        String returnData = this.excuteCommand(command, true);
        int result = 0;
        if (returnData.equalsIgnoreCase("(NAK")) {
            result = -1;
        } else {
            try {
                result = Integer.parseInt(returnData.substring(1));
            }
            catch (Exception e) {
                result = -1;
            }
        }
        return result;
    }

    @Override
    public String setOutputSocketDelayTime(String outlet, int value) throws IOException {
        DecimalFormat df3 = new DecimalFormat("000");
        String temp = df3.format(value);
        String command = "PSK" + outlet + temp;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase("(ACK")) {
            return "success";
        }
        return "failure";
    }

    @Override
    public String setNewParameter(String type, String value) throws IOException {
        if (type.equals("drycontactIn")) {
            return this.setDryCobtactIn(value);
        }
        if (type.equals("drycontactOut")) {
            return this.setDryCobtactOut(value);
        }
        if (type.equals("LCDdisplay")) {
            return this.setLCDdisplay(value);
        }
        return null;
    }

    public static void main(String[] args) {
        P05Processor.getPCInfo();
    }
}

