/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor.processor;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.data.bean.Capability;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.exception.FaultHandler;
import cn.com.voltronicpower.exception.UnsupportException;
import cn.com.voltronicpower.monitor.AbstractMonitorProcessor;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.utilities.StrConvert;
import cn.com.voltronicpower.work.BatteryTestEndHandler;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;
import org.springframework.beans.BeanWrapperImpl;

public class P00Processor
extends AbstractMonitorProcessor {
    private boolean isWB_OVRC = false;
    private int faultFirst = 0;
    private Capability capability = new Capability();

    public P00Processor(CommunicateHandlerInterface handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    public String cancelSwitchCtrl() throws IOException {
        return this.excuteCommand("CS", true);
    }

    @Override
    public String offSwitchCtrlOntime() throws IOException {
        return this.excuteCommand("SOFF", true);
    }

    @Override
    public String offSwitchCtrlOntime(int minutes) throws IOException {
        minutes = minutes > 9999 ? 9999 : minutes;
        DecimalFormat df3 = new DecimalFormat("0000");
        String turnOnDelay = df3.format(minutes);
        String command = null;
        command = "SnRm".replace("n", ".2").replace("m", turnOnDelay);
        this.excuteCommand(command, true);
        return "(ACK";
    }

    @Override
    public Capability getCapability() throws IOException {
        return this.capability;
    }

    private void queryCapability() throws IOException {
        String enableName;
        String fieldName;
        String ctrlName;
        String returnData = this.excuteCommand("QFLAG", true);
        String[] datas = returnData.split("D");
        String enables = datas[0].substring(2);
        String disables = "";
        if (datas.length > 1) {
            disables = datas[1];
        }
        BeanWrapperImpl configWrapper = new BeanWrapperImpl((Object)this.capability);
        int i = 0;
        while (i < enables.length()) {
            ctrlName = enables.substring(i, i + 1).toUpperCase();
            fieldName = "capable" + ctrlName;
            enableName = "enable" + ctrlName;
            try {
                configWrapper.setPropertyValue(fieldName, (Object)true);
                configWrapper.setPropertyValue(enableName, (Object)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        i = 0;
        while (i < disables.length()) {
            ctrlName = disables.substring(i, i + 1).toUpperCase();
            fieldName = "capable" + ctrlName;
            enableName = "enable" + ctrlName;
            try {
                configWrapper.setPropertyValue(fieldName, (Object)false);
                configWrapper.setPropertyValue(enableName, (Object)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    @Override
    public String munitesBatteryTestCtrl(float minute) throws IOException, UnsupportException {
        String commandStr = "T";
        commandStr = minute < 1.0f ? String.valueOf(commandStr) + String.valueOf(minute).substring(1, 3) : (minute < 10.0f ? String.valueOf(commandStr) + "0" + (int)minute : String.valueOf(commandStr) + String.valueOf((int)minute));
        String returnData = this.excuteCommand(commandStr, true);
        return returnData;
    }

    @Override
    public String offBuzzerCtrl() throws IOException {
        String retStr = this.excuteCommand("BZOFF", true);
        return retStr;
    }

    @Override
    public String offSwitchCtrl() throws IOException {
        String delayShutdownTime = this.getDelayShutdownTime();
        System.out.println("-----delayShutdownTime--" + delayShutdownTime);
        if (this.workInfo.getPtid().equals("P00V")) {
            String command = "SnRm".replace("n", delayShutdownTime).replace("m", "0001");
            this.excuteCommand(command, false);
            return "(ACK";
        }
        String command = "Sn".replace("n", delayShutdownTime);
        return this.excuteCommand(command, true);
    }

    @Override
    public void offSwitchCtrl(int minutes) throws IOException {
        String delayShutdownTime = this.getDelayShutdownTime();
        minutes = minutes > 9999 ? 9999 : minutes;
        DecimalFormat df3 = new DecimalFormat("0000");
        String turnOnDelay = df3.format(minutes);
        String command = null;
        command = "SnRm".replace("n", delayShutdownTime).replace("m", turnOnDelay);
        this.excuteCommand(command, true);
    }

    @Override
    public String onBuzzerCtrl() throws IOException {
        String retStr = this.excuteCommand("BZON", true);
        return retStr;
    }

    public void queryUpsInfoV() throws IOException {
        String[] datas;
        block11: {
            datas = null;
            String status = null;
            String dataStr = this.excuteCommand("QGS", true);
            datas = dataStr.split(" ");
            status = datas[datas.length - 1];
            this.identity.setMorphological(this.queryMorphological(status));
            dataStr = this.excuteCommand("QMD", true);
            datas = dataStr.split(" ");
            this.ratingInfo.setRatedCapacity(datas[1].substring(datas[1].lastIndexOf("#") + 1));
            this.identity.setIoPhase(datas[3]);
            this.workInfo.setIoPhase(datas[3]);
            this.identity.setInputRatingVoltage(datas[4]);
            this.identity.setOutputRatingVoltage(datas[5]);
            String sn = "";
            try {
                try {
                    sn = this.excuteCommand("QID", true);
                    if (this.str2Hex(sn).equals("2815")) {
                        sn = "(NAK";
                    }
                    sn = "(NAK".equals(sn) ? "----" : (!"".equals(sn.trim()) ? sn.substring(1) : "----");
                }
                catch (Exception exception) {
                    this.identity.setProductSN(sn);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                this.identity.setProductSN(sn);
                throw throwable;
            }
            this.identity.setProductSN(sn);
        }
        datas = this.excuteCommand("QRI", true).split(" ");
        this.ratingInfo.setOutputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.identity.setInputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.identity.setOutputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.ratingInfo.setOutputRatingFrequency(String.valueOf(Float.parseFloat(datas[3])));
        this.ratingInfo.setOutputRatingCurrent(String.valueOf(Integer.parseInt(datas[1])));
        this.ratingInfo.setBatteryVoltage(String.valueOf(Float.parseFloat(datas[2])));
        datas = this.excuteCommand("QBV", true).split(" ");
        this.batteryNumber.setBatn(Integer.parseInt(datas[1]));
        this.batteryNumber.setBatgn(Integer.parseInt(datas[2]));
        String value = "";
        try {
            try {
                String qvfw = this.excuteCommand("QVFW", true);
                value = qvfw.substring(qvfw.indexOf(":") + 1);
            }
            catch (Exception exception) {
                this.identity.setFwVersion(value);
            }
        }
        finally {
            this.identity.setFwVersion(value);
        }
    }

    @Override
    public void queryUpsInfo() throws IOException {
        String[] datas;
        block13: {
            String cmd_mn = this.excuteCommand("MN", true);
            if (cmd_mn.equals("V")) {
                this.isWB_OVRC = true;
            }
            if (this.isWB_OVRC) {
                this.queryUpsInfoV();
                return;
            }
            datas = null;
            String status = null;
            String dataStr = this.excuteCommand("QGS", true);
            datas = dataStr.split(" ");
            status = datas[datas.length - 1];
            this.identity.setMorphological(this.queryMorphological(status));
            dataStr = this.excuteCommand("QMD", true);
            System.out.println(dataStr);
            datas = dataStr.split(" ");
            this.ratingInfo.setRatedCapacity(datas[1].substring(datas[1].lastIndexOf("#") + 1));
            this.identity.setIoPhase(datas[3]);
            this.workInfo.setIoPhase(datas[3]);
            this.identity.setInputRatingVoltage(datas[4]);
            this.identity.setOutputRatingVoltage(datas[5]);
            String sn = "";
            try {
                try {
                    sn = this.excuteCommand("QID", true);
                    sn = "(NAK".equals(sn) ? "----" : (!"".equals(sn.trim()) ? sn.substring(1) : "----");
                }
                catch (Exception exception) {
                    this.identity.setProductSN(sn);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                this.identity.setProductSN(sn);
                throw throwable;
            }
            this.identity.setProductSN(sn);
        }
        datas = this.excuteCommand("QRI", true).split(" ");
        this.ratingInfo.setOutputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.identity.setInputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.identity.setOutputRatingVoltage(String.valueOf(Float.parseFloat(datas[0].substring(1))));
        this.ratingInfo.setOutputRatingFrequency(String.valueOf(Float.parseFloat(datas[3])));
        this.ratingInfo.setOutputRatingCurrent(String.valueOf(Integer.parseInt(datas[1])));
        this.ratingInfo.setBatteryVoltage(String.valueOf(Float.parseFloat(datas[2])));
        datas = this.excuteCommand("QBV", true).split(" ");
        this.batteryNumber.setBatn(Integer.parseInt(datas[1]));
        this.batteryNumber.setBatgn(Integer.parseInt(datas[2]));
        if (this.excuteCommand("QMD", true).indexOf("PSI5") != -1) {
            String[] AH = this.excuteCommand("QBTAH", true).substring(1).split(" ");
            int valAH = (Integer.parseInt(AH[1]) - Integer.parseInt(AH[0])) / 18;
            this.batteryNumber.setBatgn(valAH);
        }
        String value = "";
        try {
            try {
                String qvfw = this.excuteCommand("QVFW", true);
                value = qvfw.substring(qvfw.indexOf(":") + 1);
            }
            catch (Exception exception) {
                this.identity.setFwVersion(value);
            }
        }
        finally {
            this.identity.setFwVersion(value);
        }
    }

    public WorkInfo queryWorkInfoV() {
        try {
            this.workInfo.setPtid("P00V");
            this.workInfo.setCurrentTime(new Date());
            this.workInfo.setDeviceId(this.getDeviceId());
            String returnData = this.excuteCommand("QGS", true);
            String[] datas = returnData.split(" ");
            String status = datas[datas.length - 1];
            this.shutdownOnlowBattery(status.charAt(2) != '1', status.charAt(3) == '1');
            if (status.charAt(9) == '1') {
                this.workInfo.setBuzzerCtrl(false);
            } else {
                this.workInfo.setBuzzerCtrl(true);
            }
            double outputV = StrConvert.toDouble(this.workInfo.getOutputVoltage());
            char utility = status.charAt(2);
            if (this.workInfo.isFirst()) {
                if (utility == '1') {
                    EventsHandler.putEvent(this.getDeviceName(), "1001");
                } else if (utility == '0') {
                    EventsHandler.putEvent(this.getDeviceName(), "1002");
                }
            } else if (utility == '1') {
                EventsHandler.removeEvent(this.getDeviceName(), "1002");
                EventsHandler.handleEvent(this.getDeviceName(), "1001", "P00", this.getDeviceId(), true);
            } else if (utility == '0' && outputV > 0.0) {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
                EventsHandler.handleEvent(this.getDeviceName(), "1002", "P00", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
            }
            if (status.charAt(5) == '1') {
                returnData = this.excuteCommand("QFS", true);
                if (!returnData.equals("(OK")) {
                    String[] faultDatas = returnData.split(" ");
                    String faultKind = faultDatas[0].substring(1);
                    FaultHandler.doFaultEvent(faultKind, this.getDeviceName(), "P00", this.getDeviceId());
                    this.workInfo.setFaultKind(faultKind);
                }
            } else {
                FaultHandler.removeFaultEvent(this.getDeviceName());
                this.workInfo.setFaultKind(null);
            }
            if (this.lastSelfTestProgress == '1' && status.charAt(7) == '0') {
                BatteryTestEndHandler.endEvent(this.getDeviceName(), "P00", status);
            }
            this.lastSelfTestProgress = status.charAt(7);
            this.workInfo.setMorphological(this.queryMorphological(status));
            this.workInfo.setBypassActive(status.charAt(4) == '1');
            if (this.workInfo.isFirst()) {
                if (this.workInfo.isBypassActive()) {
                    EventsHandler.putEvent(this.getDeviceName(), "1006");
                } else {
                    EventsHandler.putEvent(this.getDeviceName(), "1007");
                }
            } else if (this.workInfo.isBypassActive()) {
                EventsHandler.removeEvent(this.getDeviceName(), "1007");
                EventsHandler.handleEvent(this.getDeviceName(), "1006", "P00", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "1006");
                EventsHandler.handleEvent(this.getDeviceName(), "1007", "P00", this.getDeviceId(), true);
            }
            this.workInfo.setInputVoltage(datas[0].substring(1));
            this.workInfo.setInputFrequency(datas[1]);
            this.workInfo.setOutputVoltage(datas[2]);
            this.workInfo.setOutputFrequency(datas[3]);
            this.workInfo.setOutputCurrent(datas[4]);
            this.workInfo.setOutputLoadPercent(datas[5]);
            this.workInfo.setTemperature(datas[10]);
            Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
            float overTempValue = shutdown.getOverTemperatureValue();
            if (StrConvert.toFloat(this.workInfo.getTemperatureView()) >= overTempValue) {
                if (!this.isOverTemperature) {
                    new Thread(){

                        @Override
                        public void run() {
                            P00Processor.this.isOverTemperature = true;
                            P00Processor.this.shutdownOverTemperature();
                        }
                    }.start();
                }
            } else {
                this.isOverTemperature = false;
            }
            returnData = this.excuteCommand("QMOD", true);
            if (Config.getString("Customized").equalsIgnoreCase("Wattbox")) {
                returnData = returnData.substring(1);
            }
            if (this.workInfo.isBypassActive()) {
                this.workInfo.setWorkMode("AVR mode");
                this.isBatMod = false;
            } else if (returnData.equals("P")) {
                this.workInfo.setWorkMode("Power on mode");
                this.isBatMod = false;
                this.faultFirst = 0;
            } else if (returnData.equals("S")) {
                this.workInfo.setWorkMode("Standby mode");
                this.isBatMod = false;
                this.faultFirst = 0;
            } else if (returnData.equals("Y")) {
                this.workInfo.setWorkMode("Bypass mode");
                this.isBatMod = false;
                this.faultFirst = 0;
            } else if (returnData.equals("L")) {
                this.workInfo.setWorkMode("Line mode");
                this.isBatMod = false;
                this.faultFirst = 0;
            } else if (returnData.equals("B")) {
                this.workInfo.setWorkMode("Battery mode");
                if (!this.isBatMod) {
                    this.shutdownOnBatteryMode();
                    this.isBatMod = true;
                }
                this.faultFirst = 0;
            } else if (returnData.equals("T")) {
                this.workInfo.setWorkMode("Battery test mode");
                this.isBatMod = false;
                this.faultFirst = 0;
            } else if (returnData.equals("F")) {
                ++this.faultFirst;
                this.workInfo.setWorkMode("Fault mode");
                if (this.faultFirst > 1) {
                    EventsHandler.handleEvent(this.getDeviceName(), "3009", "P00", this.getDeviceId(), true);
                }
                this.isBatMod = false;
            } else if (returnData.equals("E")) {
                this.workInfo.setWorkMode("ECO mode");
                this.isBatMod = false;
                this.faultFirst = 0;
            } else if (returnData.equals("C")) {
                this.workInfo.setWorkMode("Converter mode");
                this.isBatMod = false;
                this.faultFirst = 0;
            } else if (returnData.equals("D")) {
                this.workInfo.setWorkMode("Shutdown mode");
                this.isBatMod = false;
                this.faultFirst = 0;
            }
            String warnStatus = this.excuteCommand("QWS", true);
            String warnStr = warnStatus.substring(1);
            this.setWarningStatus(warnStr);
            returnData = this.excuteCommand("QBV", true);
            datas = returnData.split(" ");
            int batteryCapacity = Integer.parseInt(datas[3]);
            int batCapacity = shutdown.getBatCapacity();
            if ("Battery mode".equals(this.workInfo.getWorkMode()) && batteryCapacity <= batCapacity) {
                if (!this.isBatCap && ("InfoPower".equalsIgnoreCase(MyConstants.Customized) || "NetGuard".equalsIgnoreCase(MyConstants.Customized) || "ATMUSE".equalsIgnoreCase(MyConstants.Customized))) {
                    new Thread(){

                        @Override
                        public void run() {
                            P00Processor.this.isBatCap = true;
                            P00Processor.this.shutdownOnBatteryCapacity();
                        }
                    }.start();
                }
            } else {
                this.isBatCap = false;
            }
            this.workInfo.setBatteryCapacity(batteryCapacity);
            this.workInfo.setBatteryVoltage(datas[0].substring(1));
            this.workInfo.setBatteryRemainTime(Integer.parseInt(datas[4]) / 60);
            this.workInfo.setGroupNum(datas[2]);
            this.queryCapability();
            this.workInfo.setFirst(false);
            this.workInfo.setClear(false);
            this.reconnectTimes = 0;
        }
        catch (Exception e) {
            this.logingCommunicateException(false);
        }
        return this.workInfo;
    }

    @Override
    public WorkInfo queryWorkInfo() {
        try {
            String cmd_mn = this.excuteCommand("MN", true);
            if (cmd_mn.equals("V")) {
                this.isWB_OVRC = true;
            }
            if (this.isWB_OVRC) {
                WorkInfo workInfo = this.queryWorkInfoV();
                return workInfo;
            }
            this.workInfo.setPtid("P00");
            this.workInfo.setCurrentTime(new Date());
            this.workInfo.setDeviceId(this.getDeviceId());
            String returnData = this.excuteCommand("QGS", true);
            String[] datas = returnData.split(" ");
            String status = datas[datas.length - 1];
            this.shutdownOnlowBattery(status.charAt(2) != '1', status.charAt(3) == '1');
            if (status.charAt(9) == '1') {
                this.workInfo.setBuzzerCtrl(false);
            } else {
                this.workInfo.setBuzzerCtrl(true);
            }
            double outputV = StrConvert.toDouble(this.workInfo.getOutputVoltage());
            char utility = status.charAt(2);
            if (this.workInfo.isFirst()) {
                if (utility == '1') {
                    EventsHandler.putEvent(this.getDeviceName(), "1001");
                } else if (utility == '0') {
                    EventsHandler.putEvent(this.getDeviceName(), "1002");
                }
            } else if (utility == '1') {
                EventsHandler.removeEvent(this.getDeviceName(), "1002");
                EventsHandler.handleEvent(this.getDeviceName(), "1001", "P00", this.getDeviceId(), true);
            } else if (utility == '0' && outputV > 0.0) {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
                EventsHandler.handleEvent(this.getDeviceName(), "1002", "P00", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "1001");
            }
            if (status.charAt(5) == '1') {
                returnData = this.excuteCommand("QFS", true);
                if (!returnData.equals("(OK")) {
                    String[] faultDatas = returnData.split(" ");
                    String faultKind = faultDatas[0].substring(1);
                    FaultHandler.doFaultEvent(faultKind, this.getDeviceName(), "P00", this.getDeviceId());
                    this.workInfo.setFaultKind(faultKind);
                }
            } else {
                FaultHandler.removeFaultEvent(this.getDeviceName());
                this.workInfo.setFaultKind(null);
            }
            if (this.lastSelfTestProgress == '1' && status.charAt(7) == '0') {
                BatteryTestEndHandler.endEvent(this.getDeviceName(), "P00", status);
            }
            this.lastSelfTestProgress = status.charAt(7);
            this.workInfo.setMorphological(this.queryMorphological(status));
            this.workInfo.setBypassActive(status.charAt(4) == '1');
            if (this.workInfo.isFirst()) {
                if (this.workInfo.isBypassActive()) {
                    EventsHandler.putEvent(this.getDeviceName(), "1006");
                } else {
                    EventsHandler.putEvent(this.getDeviceName(), "1007");
                }
            } else if (this.workInfo.isBypassActive()) {
                EventsHandler.removeEvent(this.getDeviceName(), "1007");
                EventsHandler.handleEvent(this.getDeviceName(), "1006", "P00", this.getDeviceId(), true);
            } else {
                EventsHandler.removeEvent(this.getDeviceName(), "1006");
                EventsHandler.handleEvent(this.getDeviceName(), "1007", "P00", this.getDeviceId(), true);
            }
            this.workInfo.setInputVoltage(datas[0].substring(1));
            this.workInfo.setInputFrequency(datas[1]);
            this.workInfo.setOutputVoltage(datas[2]);
            this.workInfo.setOutputFrequency(datas[3]);
            this.workInfo.setOutputCurrent(datas[4]);
            this.workInfo.setOutputLoadPercent(datas[5]);
            this.workInfo.setTemperature(datas[10]);
            Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
            float overTempValue = shutdown.getOverTemperatureValue();
            if (StrConvert.toFloat(this.workInfo.getTemperatureView()) >= overTempValue) {
                if (!this.isOverTemperature) {
                    new Thread(){

                        @Override
                        public void run() {
                            P00Processor.this.isOverTemperature = true;
                            P00Processor.this.shutdownOverTemperature();
                        }
                    }.start();
                }
            } else {
                this.isOverTemperature = false;
            }
            returnData = this.excuteCommand("QMOD", true);
            if (this.workInfo.isBypassActive()) {
                this.workInfo.setWorkMode("AVR mode");
                this.isBatMod = false;
            } else if (returnData.equals("(P")) {
                this.workInfo.setWorkMode("Power on mode");
                this.isBatMod = false;
            } else if (returnData.equals("(S")) {
                this.workInfo.setWorkMode("Standby mode");
                this.isBatMod = false;
            } else if (returnData.equals("(Y")) {
                this.workInfo.setWorkMode("Bypass mode");
                this.isBatMod = false;
            } else if (returnData.equals("(L")) {
                this.workInfo.setWorkMode("Line mode");
                this.isBatMod = false;
            } else if (returnData.equals("(B")) {
                this.workInfo.setWorkMode("Battery mode");
                if (!this.isBatMod) {
                    this.isBatMod = true;
                    this.shutdownOnBatteryMode();
                }
            } else if (returnData.equals("(T")) {
                this.workInfo.setWorkMode("Battery test mode");
                this.isBatMod = false;
            } else if (returnData.equals("(F")) {
                this.workInfo.setWorkMode("Fault mode");
                this.isBatMod = false;
            } else if (returnData.equals("(E")) {
                this.workInfo.setWorkMode("ECO mode");
                this.isBatMod = false;
            } else if (returnData.equals("(C")) {
                this.workInfo.setWorkMode("Converter mode");
                this.isBatMod = false;
            } else if (returnData.equals("(D")) {
                this.workInfo.setWorkMode("Shutdown mode");
                this.isBatMod = false;
            }
            String warnStatus = this.excuteCommand("QWS", true);
            String warnStr = warnStatus.substring(1);
            this.setWarningStatus(warnStr);
            if (warnStr.charAt(0) == '1') {
                logger.info("\u5b58\u5728\u7535\u6c60\u672a\u63a5\u4e8b\u4ef6\uff0c \u7535\u6c60\u5bb9\u91cf\u4e3a0");
                this.workInfo.setBatteryCapacity(0);
                this.workInfo.setBatteryVoltage("0");
                this.workInfo.setBatteryRemainTime(0);
                this.workInfo.setGroupNum("0");
            } else {
                returnData = this.excuteCommand("QBV", true);
                datas = returnData.split(" ");
                int batteryCapacity = Integer.parseInt(datas[3]);
                int batCapacity = shutdown.getBatCapacity();
                if ("Battery mode".equals(this.workInfo.getWorkMode()) && batteryCapacity <= batCapacity) {
                    if (!this.isBatCap && ("InfoPower".equalsIgnoreCase(MyConstants.Customized) || "NetGuard".equalsIgnoreCase(MyConstants.Customized) || "ATMUSE".equalsIgnoreCase(MyConstants.Customized))) {
                        new Thread(){

                            @Override
                            public void run() {
                                P00Processor.this.isBatCap = true;
                                P00Processor.this.shutdownOnBatteryCapacity();
                            }
                        }.start();
                    }
                } else {
                    this.isBatCap = false;
                }
                this.workInfo.setBatteryCapacity(batteryCapacity);
                this.workInfo.setBatteryVoltage(datas[0].substring(1));
                this.workInfo.setBatteryRemainTime(Integer.parseInt(datas[4]));
                this.workInfo.setGroupNum(datas[2]);
            }
            String os1Status = this.excuteCommand("QSK1", true);
            String os2Status = this.excuteCommand("QSK2", true);
            if (this.workInfo.isFirst()) {
                if (os1Status.equals("(1")) {
                    EventsHandler.putEvent(this.getDeviceName(), "3001");
                } else if (os1Status.equals("(0")) {
                    EventsHandler.putEvent(this.getDeviceName(), "3002");
                }
                if (os2Status.equals("(1")) {
                    EventsHandler.putEvent(this.getDeviceName(), "3001");
                } else if (os2Status.equals("(0")) {
                    EventsHandler.putEvent(this.getDeviceName(), "3002");
                }
            } else {
                if (os1Status.equals("(1")) {
                    EventsHandler.removeEvent(this.getDeviceName(), "3002");
                    EventsHandler.handleEvent(this.getDeviceName(), "3001", "P00", this.getDeviceId(), true);
                    this.workInfo.setEnableOutlet1(true);
                } else if (os1Status.equals("(0")) {
                    EventsHandler.removeEvent(this.getDeviceName(), "3001");
                    EventsHandler.handleEvent(this.getDeviceName(), "3002", "P00", this.getDeviceId(), true);
                    this.workInfo.setEnableOutlet1(false);
                }
                if (os2Status.equals("(1")) {
                    EventsHandler.removeEvent(this.getDeviceName(), "3002");
                    EventsHandler.handleEvent(this.getDeviceName(), "3001", "P00", this.getDeviceId(), true);
                    this.workInfo.setEnableOutlet2(true);
                } else if (os2Status.equals("(0")) {
                    EventsHandler.removeEvent(this.getDeviceName(), "3001");
                    EventsHandler.handleEvent(this.getDeviceName(), "3002", "P00", this.getDeviceId(), true);
                    this.workInfo.setEnableOutlet2(false);
                }
            }
            this.queryCapability();
            this.workInfo.setFirst(false);
            this.workInfo.setClear(false);
            this.reconnectTimes = 0;
        }
        catch (Exception e) {
            this.logingCommunicateException(false);
        }
        return this.workInfo;
    }

    private void setWarningStatus(String warnStatus) {
        this.workInfo.clearWarning();
        this.refreshWarningStatus(warnStatus, 0, "4004");
        this.refreshWarningStatus(warnStatus, 1, "1003");
        this.refreshWarningStatus(warnStatus, 2, "1004");
        this.refreshWarningStatus(warnStatus, 3, "1005");
        this.refreshWarningStatus(warnStatus, 4, "2003");
        this.refreshWarningStatus(warnStatus, 5, "2004");
        this.refreshWarningStatus(warnStatus, 6, "4006");
        this.refreshWarningStatus(warnStatus, 7, "4001");
        this.refreshWarningStatus(warnStatus, 8, "5002");
        this.refreshWarningStatus(warnStatus, 9, "3005");
        this.refreshWarningStatus(warnStatus, 10, "3006");
        this.refreshWarningStatus(warnStatus, 11, "3007");
        this.refreshWarningStatus(warnStatus, 12, "3008");
        this.refreshWarningStatus(warnStatus, 13, "3010");
        this.refreshWarningStatus(warnStatus, 14, "3011");
        this.refreshWarningStatus(warnStatus, 15, "3012");
        this.refreshWarningStatus(warnStatus, 16, "3013");
        this.refreshWarningStatus(warnStatus, 17, "3014");
        this.refreshWarningStatus(warnStatus, 18, "3015");
        this.refreshWarningStatus(warnStatus, 19, "3016");
        this.refreshWarningStatus(warnStatus, 20, "3017");
        this.refreshWarningStatus(warnStatus, 21, "3018");
        this.refreshWarningStatus(warnStatus, 22, "3019");
        this.refreshWarningStatus(warnStatus, 23, "3020");
        this.refreshWarningStatus(warnStatus, 24, "8001");
        this.refreshWarningStatus(warnStatus, 25, "8002");
        this.refreshWarningStatus(warnStatus, 26, "8003");
        this.refreshWarningStatus(warnStatus, 27, "8004");
        this.refreshWarningStatus(warnStatus, 28, "8005");
        this.refreshWarningStatus(warnStatus, 29, "8006");
        this.refreshWarningStatus(warnStatus, 30, "8007");
        this.refreshWarningStatus(warnStatus, 31, "8008");
        this.refreshWarningStatus(warnStatus, 32, "8009");
        this.refreshWarningStatus(warnStatus, 33, "8010");
        this.refreshWarningStatus(warnStatus, 34, "8011");
        this.refreshWarningStatus(warnStatus, 35, "8012");
        this.refreshWarningStatus(warnStatus, 36, "8013");
        this.refreshWarningStatus(warnStatus, 37, "8014");
        this.refreshWarningStatus(warnStatus, 38, "8015");
        this.refreshWarningStatus(warnStatus, 39, "8016");
        this.refreshWarningStatus(warnStatus, 40, "8017");
        this.refreshWarningStatus(warnStatus, 41, "8018");
        this.refreshWarningStatus(warnStatus, 42, "8019");
        this.refreshWarningStatus(warnStatus, 43, "8020");
        this.refreshWarningStatus(warnStatus, 44, "8021");
        this.refreshWarningStatus(warnStatus, 45, "8022");
        this.refreshWarningStatus(warnStatus, 46, "8023");
        this.refreshWarningStatus(warnStatus, 47, "8024");
        this.refreshWarningStatus(warnStatus, 48, "8025");
        this.refreshWarningStatus(warnStatus, 49, "8026");
        this.refreshWarningStatus(warnStatus, 50, "8032");
        this.refreshWarningStatus(warnStatus, 51, "8033");
        this.refreshWarningStatus(warnStatus, 52, "8034");
        this.refreshWarningStatus(warnStatus, 53, "8035");
        this.refreshWarningStatus(warnStatus, 54, "3048");
        this.refreshWarningStatus(warnStatus, 55, "3049");
    }

    @Override
    public String tenSencondsBatteryTestCtrl() throws IOException {
        return this.excuteCommand("T", true);
    }

    @Override
    public void testOperation() throws IOException {
        String ret = this.excuteCommand("TL", true);
        if (!ret.equals("(ACK")) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String deepBatteryTestCtrl() throws IOException, UnsupportException {
        String returnData = this.excuteCommand("TL", true);
        return returnData;
    }

    public String testOperationP00() throws IOException {
        String ret = this.excuteCommand("TL", true);
        return ret;
    }

    @Override
    public String queryQBT() throws IOException {
        return null;
    }

    @Override
    public String queryQGR() throws IOException {
        return null;
    }

    @Override
    public boolean setPBT(String value) throws IOException {
        return false;
    }

    @Override
    public boolean setPGR(String value) throws IOException {
        return false;
    }

    @Override
    public boolean isSupportBatNum() {
        return this.supportBatNum;
    }

    @Override
    public void setSupportBatNum(boolean arg0) {
        this.supportBatNum = arg0;
    }
}

