/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitor;

import cn.com.voltronic.socket.SystemTrayUDPClient;
import cn.com.voltronic.util.Constants;
import cn.com.voltronic.util.DateUtils;
import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.data.bean.BatLowVoltage;
import cn.com.voltronicpower.data.bean.BatteryNumber;
import cn.com.voltronicpower.data.bean.BuyInfo;
import cn.com.voltronicpower.data.bean.Bypass;
import cn.com.voltronicpower.data.bean.CpuInfo;
import cn.com.voltronicpower.data.bean.GlobalConfig;
import cn.com.voltronicpower.data.bean.HighEfficiencyVoltage;
import cn.com.voltronicpower.data.bean.LineVoltage;
import cn.com.voltronicpower.data.bean.LoadInfo;
import cn.com.voltronicpower.data.bean.ParameterSettings;
import cn.com.voltronicpower.data.bean.PhaseAngle;
import cn.com.voltronicpower.data.bean.RatingInfo;
import cn.com.voltronicpower.data.bean.RemoteShutdown;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.data.bean.SnmpEnvInfo;
import cn.com.voltronicpower.data.bean.UpsIdentity;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.data.dao.BatteryLifeDao;
import cn.com.voltronicpower.data.dao.BatteryWarnDao;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.exception.UnsupportException;
import cn.com.voltronicpower.monitor.MonitorProcessor;
import cn.com.voltronicpower.monitor.processor.P00Processor;
import cn.com.voltronicpower.monitor.processor.P71Processor;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.rmiclass.GlobalService;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.utilities.SaveEvent;
import cn.com.voltronicpower.work.RemoteShutdownProcesser;
import cn.com.voltronicpower.work.SystemShutdown;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractMonitorProcessor
implements MonitorProcessor {
    protected static final Log logger = new Log();
    public static final String SUCCESS = "success";
    public static final String FAILURE = "failure";
    public static final String ERROR = "error";
    protected static final String ACK = "(ACK";
    protected static final String NAK = "(NAK";
    protected WorkInfo workInfo;
    protected UpsIdentity identity;
    protected RatingInfo ratingInfo;
    protected BatteryNumber batteryNumber;
    protected LoadInfo loadInfo;
    protected IProtocol _protocol;
    protected CommunicateHandlerInterface _handler = null;
    protected BuyInfo buyinfo;
    protected SnmpEnvInfo snmpInfo;
    protected boolean isBatLow = false;
    protected boolean isShutDown = false;
    protected boolean isBatMod = false;
    protected boolean isBatCap = false;
    public int reconnectTimes = 0;
    protected boolean isClosed = false;
    protected boolean supportBatNum = true;
    protected char lastSelfTestProgress = (char)48;
    private GlobalService globalService;
    protected ParameterSettings param = null;
    protected boolean isExcuteShutFile = false;
    protected Bypass bypass;
    protected HighEfficiencyVoltage voltage;
    protected LineVoltage line;
    protected boolean timeFlag = true;
    protected boolean fileFlag = true;
    Shutdownconfigure shutdown = null;
    protected boolean isOverTemperature = false;
    protected String port = "";
    protected String ptid = "";
    protected String starttime = "";
    protected String currlife = "";
    protected boolean isrecord = false;
    protected String firstLife = "0";
    private boolean _shutdownexecute = false;
    Thread shutdownTimer = null;
    Thread remoteShutdownTimer = null;

    public AbstractMonitorProcessor(CommunicateHandlerInterface handler, IProtocol protocol) {
        this.initDataBuffer();
        this.setHandler(handler);
        this._protocol = protocol;
        try {
            this.queryUpsInfo();
            this.doBatteryWarn();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setStartTimeAndPort(String start, String portName) {
        this.starttime = start;
        this.port = portName;
        this.isrecord = true;
    }

    public void doBatteryWarn() {
        BatteryWarnDao dao = new BatteryWarnDao();
        String deviceId = this.getDeviceId();
        String ptid = this.getProtocol().getProtocolID();
        String portName = this.getDeviceName();
        BuyInfo oldInfo = null;
        oldInfo = deviceId.equals("00000000000000000000") ? dao.getBuyInfo(deviceId, ptid) : dao.getBuyInfo(deviceId, ptid, portName);
        if (oldInfo == null) {
            BuyInfo info = new BuyInfo();
            info.setDeviceId(deviceId);
            info.setPortName(portName);
            info.setPtid(ptid);
            String returnData = NAK;
            if ("P33".equals(ptid) || "P44".equals(ptid)) {
                returnData = this.excuteCommand("QBID", true);
                String[] lifeTimes = returnData.split(" ");
                String lifeTime = "";
                int i = 0;
                while (i < lifeTimes.length) {
                    lifeTime = String.valueOf(lifeTime) + lifeTimes[i];
                    if (i != lifeTimes.length - 1) {
                        lifeTime = String.valueOf(lifeTime) + "-";
                    }
                    ++i;
                }
                info.setBatteryBuyDate(DateUtils.parseDate((String)lifeTime.substring(1)));
            } else if ("P01".equals(ptid)) {
                returnData = this.excuteCommand("QBRPD", true);
                if (returnData != null && !"".equals(returnData) && !NAK.equals(returnData)) {
                    String str = returnData.substring(1);
                    String[] dateStrs = str.split("/");
                    String dateStr = str;
                    if (dateStrs.length == 3) {
                        dateStr = String.valueOf(dateStrs[2]) + "-" + dateStrs[0] + "-" + dateStrs[1];
                    }
                    Date date = DateUtils.parseFormatMMddyyyy((String)dateStr);
                    info.setBatteryBuyDate(date);
                } else {
                    Date date = new Date();
                    info.setBatteryBuyDate(date);
                }
            } else {
                info.setBatteryLifetime(PropertiesUtils.getGlobalConfig().getBatteryLifetime());
            }
            dao.addBuyInfo(info);
            this.setBuyInfo(info);
        } else {
            if (deviceId.equals("00000000000000000000") && !portName.equals(oldInfo.getPortName())) {
                dao.updatePortName(deviceId, ptid, portName);
                oldInfo.setPortName(portName);
            }
            this.setBuyInfo(oldInfo);
        }
        String portname = this.getDeviceName();
        String p = this.getProtocol().getProtocolID();
        this.firstLife = this.getLife(this.getDeviceName(), this.getProtocol().getProtocolID());
    }

    @Override
    public String getDeviceId() {
        String sn = this.getIdentity().getProductSN();
        if ("".equals(sn) || "----".equals(sn) || sn == null) {
            sn = "00000000000000000000";
        }
        return sn;
    }

    public void shutdownOnlowBattery(boolean inputon, boolean batterylow) throws IOException {
        if (inputon) {
            if (this._shutdownexecute) {
                this._shutdownexecute = false;
                this.cancelSwitchCtrl();
                EventsHandler.removeEvent(this.getDeviceName(), "4001");
            }
        } else if (batterylow && !this._shutdownexecute) {
            this.shutdownOnLowBattery();
            this._shutdownexecute = true;
            EventsHandler.handleEvent(this.getDeviceName(), "4001", this.getProtocol().getProtocolID(), this.getDeviceId(), true);
        }
    }

    protected void initDataBuffer() {
        this.workInfo = new WorkInfo();
        this.workInfo.clear();
        this.identity = new UpsIdentity();
        this.ratingInfo = new RatingInfo();
        this.batteryNumber = new BatteryNumber();
        this.snmpInfo = new SnmpEnvInfo();
        this.param = new ParameterSettings();
        this.loadInfo = new LoadInfo();
        this.bypass = new Bypass();
        this.voltage = new HighEfficiencyVoltage();
        this.line = new LineVoltage();
        try {
            this.globalService = new GlobalService();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean closed() {
        return this.isClosed;
    }

    protected void setHandler(CommunicateHandlerInterface handler) {
        this._handler = handler;
    }

    @Override
    public BatteryNumber getBatteryNumber() {
        return this.batteryNumber;
    }

    @Override
    public BuyInfo getBuyInfo() {
        return this.buyinfo;
    }

    @Override
    public void setBuyInfo(BuyInfo info) {
        this.buyinfo = info;
        Date date = info.getBatteryBuyDate();
        String dateStr = DateUtils.getFormatMMddyyyy((Date)date);
        this.excuteCommand("PBRPD" + dateStr, true);
    }

    @Override
    public boolean setPGR(String value) throws IOException {
        return false;
    }

    @Override
    public boolean setPBT(String value) throws IOException {
        return false;
    }

    @Override
    public String queryQGR() throws IOException {
        return null;
    }

    @Override
    public String queryQBT() throws IOException {
        return null;
    }

    protected String getDelayShutdownTime() {
        Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
        float shutdownTime = shutdown.getShutdownTime();
        String delayShutdownTime = "";
        delayShutdownTime = shutdownTime < 1.0f ? String.valueOf(delayShutdownTime) + String.valueOf(shutdownTime).substring(1, 3) : (shutdownTime < 10.0f ? String.valueOf(delayShutdownTime) + "0" + (int)shutdownTime : String.valueOf(delayShutdownTime) + String.valueOf((int)shutdownTime));
        return delayShutdownTime;
    }

    @Override
    public UpsIdentity getIdentity() {
        return this.identity;
    }

    @Override
    public RatingInfo getRatingInfo() {
        return this.ratingInfo;
    }

    @Override
    public WorkInfo getWorkInfo() {
        return this.workInfo;
    }

    @Override
    public IProtocol getProtocol() {
        return this._protocol;
    }

    @Override
    public SnmpEnvInfo getSnmpInfo() {
        return this.snmpInfo;
    }

    @Override
    public Bypass getBypass() {
        return this.bypass;
    }

    @Override
    public HighEfficiencyVoltage getHighEfficiencyVoltage() {
        return this.voltage;
    }

    @Override
    public String offSwitchCtrl() throws IOException {
        return null;
    }

    @Override
    public String onSwitchCtrlOntime() throws IOException {
        return this.excuteCommand("SON", true);
    }

    @Override
    public String cancelBatteryTest() throws IOException {
        String returnData = this.excuteCommand("CT", true);
        if (this.isrecord) {
            this.isrecord = false;
            this.starttime = "";
        }
        return returnData;
    }

    @Override
    public String offOutletCtrl(String group) throws IOException {
        return this.excuteCommand("SKOFF" + group, true);
    }

    @Override
    public String onOutletCtrl(String group) throws IOException {
        return this.excuteCommand("SKON" + group, true);
    }

    @Override
    public String setCapability(String x, boolean isEnable) throws IOException {
        String command = isEnable ? "PE" : "PD";
        String returnData = this.excuteCommand(command = String.valueOf(command) + x, true);
        if (returnData.equalsIgnoreCase(ACK)) {
            return "success," + x;
        }
        return "failure," + x;
    }

    @Override
    public String setBypassLowVoltage(int value) throws IOException {
        String blv = value < 100 ? "0" + value : String.valueOf(value);
        String command = "PLV" + blv;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase(ACK)) {
            return SUCCESS;
        }
        return FAILURE;
    }

    @Override
    public String setBatgn(int value) throws IOException {
        String returnData;
        String btnum = value < 10 ? "0" + value : String.valueOf(value);
        String command = "BATGN" + btnum;
        if (this instanceof P00Processor && this.excuteCommand("QMD", true).indexOf("PSI5") != -1) {
            int innerAh = Integer.parseInt(this.excuteCommand("QBTAH", true).split(" ")[0].substring(1)) + value * 18;
            DecimalFormat df3 = new DecimalFormat("0000");
            String temp = df3.format(innerAh);
            command = "BATTAH" + temp;
        }
        if ((returnData = this.excuteCommand(command, true)).equalsIgnoreCase(ACK)) {
            this.queryUpsInfo();
            return SUCCESS;
        }
        return FAILURE;
    }

    @Override
    public String setBatn(int value) throws IOException {
        String command = "BATN" + value;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase(ACK)) {
            this.queryUpsInfo();
            return SUCCESS;
        }
        return FAILURE;
    }

    @Override
    public String setBypassHighFrequency(float value) throws IOException {
        String command = "PGF" + value;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase(ACK)) {
            return SUCCESS;
        }
        return FAILURE;
    }

    @Override
    public String setBypassHighVoltage(int value) throws IOException {
        String bhv = value < 100 ? "0" + value : String.valueOf(value);
        String command = "PHV" + bhv;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase(ACK)) {
            return SUCCESS;
        }
        return FAILURE;
    }

    @Override
    public String setBypassLowFrequency(float value) throws IOException {
        String command = "PSF" + value;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase(ACK)) {
            return SUCCESS;
        }
        return FAILURE;
    }

    @Override
    public String setFreh(float value) throws IOException {
        String command = "FREH" + value;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase(ACK)) {
            return SUCCESS;
        }
        return FAILURE;
    }

    @Override
    public String setFrel(float value) throws IOException {
        String command = "FREL" + value;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase(ACK)) {
            return SUCCESS;
        }
        return FAILURE;
    }

    @Override
    public String setPPD(String value) throws IOException {
        String command = "PPD" + value;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase(ACK)) {
            return SUCCESS;
        }
        return FAILURE;
    }

    @Override
    public String setHeh(int value) throws IOException {
        String command = "HEH" + value;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase(ACK)) {
            return SUCCESS;
        }
        return FAILURE;
    }

    @Override
    public String setHel(int value) throws IOException {
        String command = "HEL" + value;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase(ACK)) {
            return SUCCESS;
        }
        return FAILURE;
    }

    @Override
    public String setOutputSocketDelayTime(String outlet, int value) throws IOException {
        DecimalFormat df3 = new DecimalFormat("000");
        String temp = df3.format(value);
        String command = "PSK" + outlet + temp;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase(ACK)) {
            return SUCCESS;
        }
        return FAILURE;
    }

    @Override
    public String setDefault() throws IOException {
        String returnData = this.excuteCommand("PF", true);
        if (returnData.equalsIgnoreCase(ACK)) {
            return SUCCESS;
        }
        return FAILURE;
    }

    @Override
    public BatLowVoltage getBatLow() throws IOException {
        BatLowVoltage batlow = new BatLowVoltage();
        try {
            String returnData = this.excuteCommand("RE0", true);
            batlow.setBatlow((double)Float.parseFloat(returnData.substring(1)));
            String dataStr = this.excuteCommand("F", true);
            String[] datas = dataStr.split(" ");
            double voltage = Double.parseDouble(datas[0].substring(1));
            double current = Double.parseDouble(datas[1]);
            if (voltage * current < 1000.0) {
                batlow.setMinBatlow(20.0);
                batlow.setMaxBatlow(24.0);
            } else {
                batlow.setMinBatlow(20.0);
                batlow.setMaxBatlow(28.0);
            }
        }
        catch (Exception e) {
            batlow = new BatLowVoltage();
        }
        return batlow;
    }

    @Override
    public boolean setBatLow(int value) throws IOException {
        String command = "W0E" + value;
        String returnData = this.excuteCommand(command, true);
        return returnData.equalsIgnoreCase(ACK);
    }

    @Override
    public int getOutputSocketDelayTime(String socketNum) throws IOException {
        String command = "QSKT" + socketNum;
        String returnData = this.excuteCommand(command, true);
        int result = 0;
        if (returnData.equalsIgnoreCase(NAK)) {
            result = -1;
        } else {
            try {
                result = Integer.parseInt(returnData.substring(1));
            }
            catch (Exception e) {
                result = -1;
            }
        }
        return result;
    }

    public void refreshWarningStatus(String warnStatus, int index, String eventCode) {
        if (eventCode.equals("4001") && this instanceof P71Processor) {
            double inputV = 0.0;
            try {
                inputV = Double.parseDouble(this.workInfo.getInputVoltage());
            }
            catch (NumberFormatException e) {
                inputV = 0.0;
            }
            try {
                this.shutdownOnlowBattery(inputV > 0.0, warnStatus.charAt(3) == '1');
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (warnStatus.charAt(index) == '1') {
            EventsHandler.handleEvent(this.getDeviceName(), eventCode, this._protocol.getProtocolID(), this.getDeviceId(), true);
            this.workInfo.addWarning("a" + index);
        } else {
            EventsHandler.removeEvent(this.getDeviceName(), eventCode);
        }
    }

    @Override
    public PhaseAngle getPPD() throws IOException {
        String command = "QPD";
        String returnData = this.excuteCommand(command, true);
        PhaseAngle pa = new PhaseAngle();
        if (!NAK.equals(returnData)) {
            String[] list = returnData.split(" ");
            pa.setInputPhaseAngle(list[0].substring(1));
            pa.setOutputPhaseAngle(list[1]);
            return pa;
        }
        return null;
    }

    protected void executeFile(Shutdownconfigure shutdown) {
        logger.info("isShutDown-------" + this.isShutDown + "-----------" + Constants.IS_OS_LINUX);
        if (this.isShutDown) {
            return;
        }
        SystemTrayUDPClient client = null;
        String execfile = shutdown.getExcuteProgram().trim();
        if (StringUtils.isEmpty((String)execfile)) {
            return;
        }
        if (execfile.contains(" ")) {
            execfile = execfile.replace(" ", "\" \"");
        }
        try {
            try {
                if ((execfile.contains(".bat") || execfile.contains(".exe")) && MyConstants.IS_OS_WINDOWS) {
                    execfile = "cmd /C start " + execfile;
                }
                client = new SystemTrayUDPClient("localhost", 33654);
                client.send(("exec###" + execfile).getBytes());
                String re = new String(client.receive(), "UTF-8");
                if (re.equals(NAK)) {
                    if (Constants.IS_OS_LINUX) {
                        Runtime.getRuntime().exec("chmod 777 " + execfile);
                        Runtime.getRuntime().exec(execfile);
                        logger.info("---------linux 1-------------");
                    } else {
                        Runtime.getRuntime().exec(execfile);
                    }
                }
                this.isExcuteShutFile = true;
                this.isShutDown = true;
            }
            catch (Exception e) {
                logger.info(" catch-------" + Constants.IS_OS_LINUX);
                e.printStackTrace();
                try {
                    if (Constants.IS_OS_LINUX || Constants.IS_OS_SOLARIS) {
                        Runtime.getRuntime().exec("chmod 777 " + execfile);
                        Runtime.getRuntime().exec(execfile);
                        logger.info("---linux 2---");
                    } else if (Constants.IS_OS_MAC_OSX || Constants.IS_OS_MAC) {
                        Runtime.getRuntime().exec("chmod 777 " + execfile);
                        Runtime.getRuntime().exec("open " + execfile);
                    }
                    Runtime.getRuntime().exec(execfile);
                    this.isExcuteShutFile = true;
                    this.isShutDown = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (client != null) {
                    client.close();
                }
            }
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    protected void executeShutdown(Shutdownconfigure shutdown, long delayTime, boolean timeFlag) {
        try {
            logger.info("shutdown the UPS");
            if (shutdown.isBatModeShutdownUps()) {
                this.offSwitchCtrl();
            }
            if (!shutdown.isNoShutLocalExecute()) {
                SystemShutdown.shutdown(this.getDeviceName(), this.getProtocol().getProtocolID(), this.getDeviceId());
            }
            timeFlag = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void executeWarningTime(Shutdownconfigure shutdown, int leftSeconds) {
        try {
            GlobalConfig config = new GlobalConfig();
            PropertiesUtils.wrapProperties(config);
            String type = null;
            String name = null;
            if (config.getLanguage().equals("zh_CN")) {
                type = "\u7cfb\u7edf\u5173\u673a\u4fe1\u606f";
                name = shutdown.isShutdownMode() && !shutdown.isNoShutLocalExecute() ? "\u7cfb\u7edf\u5c06\u5728" + leftSeconds + "\u79d2\u540e\u5173\u95ed" : "\u7cfb\u7edf\u5c06\u5728" + leftSeconds + "\u79d2\u540e\u4f11\u7720";
            } else if (config.getLanguage().equals("zh_TW")) {
                type = "\u7cfb\u7d71\u95dc\u6a5f\u4fe1\u606f";
                name = shutdown.isShutdownMode() && !shutdown.isNoShutLocalExecute() ? "\u7cfb\u7d71\u5c07\u5728" + leftSeconds + "\u79d2\u5f8c\u95dc\u9589" : "\u7cfb\u7d71\u5c07\u5728" + leftSeconds + "\u79d2\u5f8c\u4f11\u7720";
            } else {
                type = "System Shutdown Infomation";
                name = shutdown.isShutdownMode() && !shutdown.isNoShutLocalExecute() ? "System shutdown after " + leftSeconds + " seconds" : "System sleep after " + leftSeconds + " seconds";
            }
            if (leftSeconds > 0) {
                EventsHandler.trayClient(type, null, name, "003");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void shutdownOnBatteryMode() {
        RemoteShutdown remoteShutdown = new RemoteShutdown();
        PropertiesUtils.wrapProperties(remoteShutdown);
        final Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
        if (remoteShutdown.isBatteryMode()) {
            if (this.remoteShutdownTimer == null) {
                this.remoteShutdownTimer = new Thread(remoteShutdown){
                    long delayTime;
                    boolean flagTime;
                    {
                        this.delayTime = remoteShutdown.getBatteryModeTime() * 60000 + remoteShutdown.getBatteryModeSeconds() * 1000;
                        this.flagTime = true;
                    }

                    @Override
                    public void run() {
                        while (this.flagTime) {
                            if (!AbstractMonitorProcessor.this.workInfo.getWorkMode().equals("Line mode") && !AbstractMonitorProcessor.this.workInfo.getWorkMode().equals("ECO mode")) {
                                if (this.delayTime <= 0L) {
                                    RemoteShutdownProcesser processer = new RemoteShutdownProcesser();
                                    logger.info("------------send remote shutdown command----------");
                                    processer.sendRemoteShutdownMsg();
                                    this.flagTime = false;
                                    logger.info("remote shutdown have been done!");
                                    continue;
                                }
                                this.delayTime -= 1000L;
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                continue;
                            }
                            AbstractMonitorProcessor.this.isBatMod = false;
                            this.flagTime = false;
                            logger.info("Timing for remote shutdown have been canceled!");
                        }
                    }
                };
                this.remoteShutdownTimer.start();
                logger.info("delay " + remoteShutdown.getBatteryModeTime() + " before remote shutdown,Timing is begining");
            }
            this.remoteShutdownTimer = null;
        }
        if (remoteShutdown.isBatteryLowLevel()) {
            if (this.remoteShutdownTimer == null) {
                this.remoteShutdownTimer = new Thread(remoteShutdown){
                    boolean flagTime = true;
                    int absoluteCapacity;
                    {
                        this.absoluteCapacity = remoteShutdown.getBatCapacity();
                    }

                    @Override
                    public void run() {
                        while (this.flagTime) {
                            if (!AbstractMonitorProcessor.this.workInfo.getWorkMode().equals("Line mode") && !AbstractMonitorProcessor.this.workInfo.getWorkMode().equals("ECO mode")) {
                                System.out.println("----remoteShutdown batacity----------absoluteCapacity:" + this.absoluteCapacity + "|realtime:" + AbstractMonitorProcessor.this.workInfo.getBatteryCapacity());
                                if (this.absoluteCapacity >= AbstractMonitorProcessor.this.workInfo.getBatteryCapacity()) {
                                    RemoteShutdownProcesser processer = new RemoteShutdownProcesser();
                                    logger.info("------send remote shutdown command triggerd by battery capacity----------");
                                    processer.sendRemoteShutdownMsg();
                                    this.flagTime = false;
                                    logger.info("remoteShutdown batacity have been done!");
                                    continue;
                                }
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                continue;
                            }
                            AbstractMonitorProcessor.this.isBatMod = false;
                            this.flagTime = false;
                            logger.info("Battery capacity remote shutdown have been canceled!");
                        }
                    }
                };
                this.remoteShutdownTimer.start();
                logger.info("Battery capacity remote shutdown is begining");
            }
            this.remoteShutdownTimer = null;
        }
        logger.info("shutdown.isBatModeShutdown()" + shutdown.isBatModeShutdown());
        logger.info("shutdown.isNoShutLocalExecute()" + shutdown.isNoShutLocalExecute());
        if (shutdown.isBatModeShutdown() || shutdown.isNoShutLocalExecute()) {
            int batShutTime = shutdown.getBatModeShutdownTime();
            int batShutSecond = shutdown.getBatModeShutdownSeconds();
            long delayTime = batShutTime * 60000 + batShutSecond * 1000;
            if (this.shutdownTimer != null) {
                return;
            }
            this.shutdownTimer = new Thread(){
                int batShutTime;
                int batShutSecond;
                long delayTime;
                long execTime;
                long delayWarningTime;
                long warningPeriod;
                private int leftSeconds;
                long delaytime1;
                {
                    this.batShutTime = shutdownconfigure.getBatModeShutdownTime();
                    this.batShutSecond = shutdownconfigure.getBatModeShutdownSeconds();
                    this.delayTime = this.batShutTime * 60000 + this.batShutSecond * 1000;
                    this.execTime = this.delayTime - shutdownconfigure.getExcuteProgramTimeMillis();
                    this.delayWarningTime = (this.batShutTime * 60 + this.batShutSecond - shutdownconfigure.getBeforeAlertTime()) * 1000;
                    this.warningPeriod = shutdownconfigure.getAlertIntervalTime() * 1000;
                    this.leftSeconds = shutdownconfigure.getBeforeAlertTime();
                    this.delaytime1 = this.delayTime;
                }

                @Override
                public void run() {
                    if (this.execTime < 0L) {
                        this.execTime = shutdown.getExcuteProgramTimeMillis();
                        this.delayTime = shutdown.getExcuteProgramTimeMillis() + 10000L;
                    }
                    boolean shutdownupsflag = false;
                    AbstractMonitorProcessor.this.timeFlag = true;
                    while (AbstractMonitorProcessor.this.timeFlag) {
                        try {
                            if (!AbstractMonitorProcessor.this.workInfo.getWorkMode().equals("Line mode") && !AbstractMonitorProcessor.this.workInfo.getWorkMode().equals("ECO mode")) {
                                if (this.execTime == 0L && AbstractMonitorProcessor.this.fileFlag) {
                                    logger.info("----------Battery mode execute file begin...");
                                    AbstractMonitorProcessor.this.executeFile(shutdown);
                                    logger.info("----------Battery mode execute file end!");
                                    AbstractMonitorProcessor.this.isExcuteShutFile = true;
                                    AbstractMonitorProcessor.this.fileFlag = false;
                                    logger.info("script file have been excuted\uff01");
                                } else {
                                    this.execTime -= 1000L;
                                }
                                if (this.delayWarningTime > 0L) {
                                    this.delayWarningTime -= 1000L;
                                } else if (this.delayTime / 1000L == (long)this.leftSeconds) {
                                    AbstractMonitorProcessor.this.executeWarningTime(shutdown, this.leftSeconds);
                                    this.leftSeconds -= shutdown.getAlertIntervalTime();
                                }
                                if (this.delayTime <= 0L) {
                                    AbstractMonitorProcessor.this.executeShutdown(shutdown, this.delayTime, AbstractMonitorProcessor.this.timeFlag);
                                    AbstractMonitorProcessor.this.timeFlag = false;
                                    logger.info("shutdown have been excuted\uff01");
                                } else {
                                    this.delayTime -= 1000L;
                                }
                                Thread.sleep(1000L);
                                continue;
                            }
                            if (AbstractMonitorProcessor.this.isExcuteShutFile) {
                                AbstractMonitorProcessor.this.cancelExcuteFile(shutdown);
                                AbstractMonitorProcessor.this.isExcuteShutFile = false;
                                AbstractMonitorProcessor.this.isShutDown = false;
                                AbstractMonitorProcessor.this.fileFlag = true;
                                logger.info("cancel excutor or the ecxutor has been excuted");
                            }
                            AbstractMonitorProcessor.this.isBatMod = false;
                            AbstractMonitorProcessor.this.timeFlag = false;
                            if (!shutdown.isNoShutLocalExecute()) {
                                logger.info("cancel Timing of shutdown!");
                                continue;
                            }
                            logger.info("cancel Timing of excutor of script!");
                        }
                        catch (Exception e) {
                            AbstractMonitorProcessor.this.isExcuteShutFile = false;
                            AbstractMonitorProcessor.this.fileFlag = true;
                            logger.error(e.toString());
                        }
                    }
                    AbstractMonitorProcessor.this.shutdownTimer = null;
                }
            };
            this.shutdownTimer.setName("sleep thread");
            this.shutdownTimer.start();
            if (!shutdown.isNoShutLocalExecute()) {
                logger.info("delay " + delayTime / 1000L + "seconds before local shutdown,then timing!");
            } else {
                logger.info("delay " + delayTime / 1000L + "seconds before local excute script,then timing!");
            }
        } else {
            if (this.shutdownTimer != null) {
                return;
            }
            this.shutdownTimer = new Thread(){
                int absoluteCapacity;
                int batShutTime;
                int batShutSecond;
                long delayTime;
                long execTime;
                long delayWarningTime;
                long warningPeriod;
                private int leftSeconds;
                {
                    this.absoluteCapacity = shutdownconfigure.getBatCapacity();
                    this.batShutTime = shutdownconfigure.getBatModeShutdownTime();
                    this.batShutSecond = shutdownconfigure.getBatModeShutdownSeconds();
                    this.delayTime = this.batShutTime * 60000 + this.batShutSecond * 1000;
                    this.execTime = this.delayTime - shutdownconfigure.getExcuteProgramTimeMillis();
                    this.delayWarningTime = (this.batShutTime * 60 + this.batShutSecond - shutdownconfigure.getBeforeAlertTime()) * 1000;
                    this.warningPeriod = shutdownconfigure.getAlertIntervalTime() * 1000;
                    this.leftSeconds = shutdownconfigure.getBeforeAlertTime();
                }

                @Override
                public void run() {
                    if (this.execTime < 0L) {
                        this.execTime = shutdown.getExcuteProgramTimeMillis();
                        this.delayTime = shutdown.getExcuteProgramTimeMillis() + 10000L;
                    }
                    boolean shutdownupsflag = false;
                    AbstractMonitorProcessor.this.timeFlag = true;
                    while (AbstractMonitorProcessor.this.timeFlag) {
                        try {
                            if (!(AbstractMonitorProcessor.this.workInfo.getWorkMode().equals("Line mode") || AbstractMonitorProcessor.this.workInfo.getWorkMode().equals("ECO mode") || AbstractMonitorProcessor.this.workInfo.getWorkMode().equals(""))) {
                                if (this.absoluteCapacity < AbstractMonitorProcessor.this.workInfo.getBatteryCapacity()) {
                                    Thread.sleep(1000L);
                                    continue;
                                }
                                if (this.execTime == 0L && AbstractMonitorProcessor.this.fileFlag) {
                                    logger.info("----------Battery mode execute file begin...");
                                    AbstractMonitorProcessor.this.executeFile(shutdown);
                                    logger.info("----------Battery mode execute file end!");
                                    AbstractMonitorProcessor.this.isExcuteShutFile = true;
                                    AbstractMonitorProcessor.this.fileFlag = false;
                                    logger.info("script file have been excuted\uff01");
                                } else {
                                    this.execTime -= 1000L;
                                }
                                if (this.delayWarningTime > 0L) {
                                    this.delayWarningTime -= 1000L;
                                } else if (this.delayTime / 1000L == (long)this.leftSeconds) {
                                    AbstractMonitorProcessor.this.executeWarningTime(shutdown, this.leftSeconds);
                                    this.leftSeconds -= shutdown.getAlertIntervalTime();
                                }
                                if (this.delayTime <= 0L) {
                                    AbstractMonitorProcessor.this.executeShutdown(shutdown, this.delayTime, AbstractMonitorProcessor.this.timeFlag);
                                    AbstractMonitorProcessor.this.timeFlag = false;
                                    logger.info("shutdown have been excuted\uff01");
                                } else {
                                    this.delayTime -= 1000L;
                                }
                                Thread.sleep(1000L);
                                continue;
                            }
                            if (AbstractMonitorProcessor.this.isExcuteShutFile) {
                                AbstractMonitorProcessor.this.cancelExcuteFile(shutdown);
                                AbstractMonitorProcessor.this.isExcuteShutFile = false;
                                AbstractMonitorProcessor.this.fileFlag = true;
                                AbstractMonitorProcessor.this.isShutDown = false;
                                logger.info("cancel excutor or the ecxutor has been excuted");
                            }
                            AbstractMonitorProcessor.this.isBatMod = false;
                            AbstractMonitorProcessor.this.timeFlag = false;
                            if (!shutdown.isNoShutLocalExecute()) {
                                logger.info("cancel Timing of shutdown!");
                                continue;
                            }
                            logger.info("cancel Timing of excutor of script!");
                        }
                        catch (Exception e) {
                            AbstractMonitorProcessor.this.isExcuteShutFile = false;
                            AbstractMonitorProcessor.this.fileFlag = true;
                            logger.error(e.toString());
                        }
                    }
                    AbstractMonitorProcessor.this.shutdownTimer = null;
                }
            };
            this.shutdownTimer.setName("sleep thread");
            this.shutdownTimer.start();
            if (!shutdown.isNoShutLocalExecute()) {
                logger.info("local shutdown is starting!");
            } else {
                logger.info("local excute script is starting!");
            }
        }
    }

    protected void shutdownOnLowBattery() {
        String protocolId;
        Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
        RemoteShutdownProcesser processer = new RemoteShutdownProcesser();
        processer.sendLowLevelRemoteShutdownMsg();
        logger.info("shutdown.isLowBatShutdown()" + shutdown.isLowBatShutdown());
        if (!shutdown.isLowBatShutdown()) {
            return;
        }
        String executeFile = shutdown.getExcuteProgram();
        if (executeFile != null && !"".equals(executeFile) && this.fileFlag) {
            logger.info("----------Low battery execute file begin...");
            this.executeFile(shutdown);
            logger.info("----------Low battery execute file end!");
            try {
                Thread.sleep(shutdown.getExcuteProgramTimeMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.fileFlag = false;
        }
        logger.info("shutdown.getLowBatShutdownUPS()" + shutdown.getLowBatShutdownUPS());
        if (shutdown.getLowBatShutdownUPS() == 1) {
            try {
                this.offSwitchCtrl();
                logger.info("shutdown the UPS");
            }
            catch (IOException iOException) {}
        } else if (!(shutdown.getLowBatShutdownUPS() != 0 || (protocolId = this.getProtocol().getProtocolID()).equals("MODBUS") || protocolId.equals("P02") || protocolId.equals("P03"))) {
            try {
                this.offSwitchCtrl();
                logger.info("shutdown the UPS");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.isExcuteShutFile = false;
        SystemShutdown.shutdown(this.getDeviceName(), this.getProtocol().getProtocolID(), this.getDeviceId());
    }

    protected void shutdownOnBatteryCapacity() {
        if ("PowerWalker".equalsIgnoreCase(MyConstants.Customized)) {
            return;
        }
        Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
        RemoteShutdown remoteShutdown = new RemoteShutdown();
        PropertiesUtils.wrapProperties(remoteShutdown);
        if (remoteShutdown.isBatCapRemoteShutdown()) {
            RemoteShutdownProcesser processer = new RemoteShutdownProcesser();
            processer.sendRemoteBatCapShutdownMsg();
            logger.info("\u7535\u6c60\u6a21\u5f0f\u4e0b\u7535\u6c60\u5bb9\u91cf\u4f4e\u4e8eN\u65f6\u53d1\u9001\u8fdc\u7a0b\u5173\u673a send the remote shutdown sign while the battery capacity under the reference number on battery mode");
        }
        logger.info("shutdown.isBatCapacityShutdown()" + shutdown.isBatCapacityShutdown());
        if (!shutdown.isBatCapacityShutdown()) {
            return;
        }
        logger.info("----------Battery capacity execute file begin...");
        this.executeFile(shutdown);
        logger.info("----------Battery capacity execute file end!");
        try {
            Thread.sleep(shutdown.getExcuteProgramTimeMillis());
        }
        catch (InterruptedException processer) {
            // empty catch block
        }
        logger.info("shutdown.isBatModeShutdownUps()" + shutdown.isBatModeShutdownUps());
        if (shutdown.isBatModeShutdownUps()) {
            try {
                this.offSwitchCtrl();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!shutdown.isNoShutLocalExecute()) {
            SystemShutdown.shutdown(this.getDeviceName(), this.getProtocol().getProtocolID(), this.getDeviceId());
        }
        this.isExcuteShutFile = false;
        this.isBatCap = false;
    }

    protected void runBeforeExcuteFile(Shutdownconfigure shutdown) {
        if (shutdown.isBatModeShutdownUps()) {
            try {
                float shut = shutdown.getExcuteProgramTime() + shutdown.getShutdownTime();
                String delayShutdownTime = this.getFormatUPSShutdownTime(shut);
                this.offSwitchCtrl(delayShutdownTime);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String queryMorphological(String status) {
        if (status.startsWith("00")) {
            return "standby";
        }
        if (status.startsWith("01")) {
            return "line-interactive";
        }
        if (status.startsWith("10")) {
            return "on-line";
        }
        return "";
    }

    @Override
    public synchronized String excuteCommand(String command, boolean isResponse) {
        boolean result = true;
        String rts = "";
        try {
            try {
                rts = this._handler.excuteCommand(command, isResponse);
                if (rts == null || "".equals(rts)) {
                    result = false;
                }
            }
            catch (Exception ex) {
                result = false;
                this.logingCommunicateException(result);
            }
        }
        finally {
            this.logingCommunicateException(result);
        }
        return rts;
    }

    public synchronized String excuteSetCommand(String command, boolean isResponse) {
        boolean result = true;
        String rts = "";
        try {
            try {
                rts = this._handler.excuteSetCommand(command, isResponse);
                if (rts == null || "".equals(rts)) {
                    result = false;
                }
            }
            catch (Exception ex) {
                result = false;
                this.logingCommunicateException(result);
            }
        }
        finally {
            this.logingCommunicateException(result);
        }
        return rts;
    }

    public void logingCommunicateException(boolean success) {
        if (success) {
            this.reconnectTimes = 0;
            return;
        }
        ++this.reconnectTimes;
        int reconncectCount = this.globalService.getGlobalConfig().getReconnectCount();
        if (this.reconnectTimes > reconncectCount) {
            EventsHandler.handleEvent(this.getDeviceName(), "6001", this.getProtocol().getProtocolID(), this.getDeviceId(), false);
            this.getWorkInfo().clear();
            this.close();
            SaveEvent.saveData("\u8fde\u7eed" + reconncectCount + "\u6b21\u901a\u8baf\u5931\u8d25\uff0c\u901a\u8baf\u7aef\u53e3\u5173\u95ed");
            this.reconnectTimes = 0;
        }
        SaveEvent.saveData("\u901a\u8baf\u5931\u8d25\uff0c\u5f00\u59cb\u7b2c" + this.reconnectTimes + "\u6b21\u5c1d\u8bd5\u901a\u8baf............");
    }

    @Override
    public String excuteCommand(String oid, String value, int dataType) {
        return null;
    }

    @Override
    public String excuteCommand(int address, short value) throws IOException {
        return null;
    }

    @Override
    public String getDeviceName() {
        return this._handler.getDeviceName();
    }

    @Override
    public void close() {
        this.isClosed = true;
        this._handler.close();
        EventsHandler.removeDeviceEvents(this.getDeviceName());
    }

    @Override
    public String rectifierInverterCtrl(int unit) throws IOException {
        return null;
    }

    private void cancelExcuteFile(Shutdownconfigure shutdown) {
        block14: {
            SystemTrayUDPClient client = null;
            String cancelExecuteFile = shutdown.getCancelShutExcute().trim();
            if (StringUtils.isEmpty((String)cancelExecuteFile)) {
                return;
            }
            if (cancelExecuteFile.contains(" ")) {
                cancelExecuteFile = cancelExecuteFile.replace(" ", "\" \"");
            }
            try {
                try {
                    if ((cancelExecuteFile.contains(".bat") || cancelExecuteFile.contains(".exe")) && MyConstants.IS_OS_WINDOWS) {
                        cancelExecuteFile = "cmd /C start " + cancelExecuteFile;
                    }
                    client = new SystemTrayUDPClient("localhost", 33654);
                    client.send(("exec###" + cancelExecuteFile).getBytes());
                    String re = new String(client.receive(), "UTF-8");
                    if (!re.equals(NAK)) break block14;
                    if (Constants.IS_OS_LINUX || Constants.IS_OS_SOLARIS || Constants.IS_OS_MAC_OSX || Constants.IS_OS_MAC) {
                        Runtime.getRuntime().exec("chmod 777 " + shutdown.getCancelShutExcute());
                        Runtime.getRuntime().exec(shutdown.getCancelShutExcute());
                        break block14;
                    }
                    Runtime.getRuntime().exec(cancelExecuteFile);
                }
                catch (Exception e) {
                    try {
                        if (Constants.IS_OS_LINUX || Constants.IS_OS_SOLARIS || Constants.IS_OS_MAC_OSX || Constants.IS_OS_MAC) {
                            Runtime.getRuntime().exec("chmod 777 " + shutdown.getCancelShutExcute());
                        }
                        Runtime.getRuntime().exec(shutdown.getCancelShutExcute());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (client != null) {
                        client.close();
                    }
                }
            }
            finally {
                if (client != null) {
                    client.close();
                }
            }
        }
    }

    @Override
    public String setBatMaxBakTime(int value) throws IOException {
        String str = String.format("%04d", value);
        String command = "MD" + str;
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase(ACK)) {
            this.queryUpsInfo();
            return SUCCESS;
        }
        return FAILURE;
    }

    @Override
    public int getBatMaxBakTime() throws IOException {
        String command = "QBKTM";
        String returnData = this.excuteCommand(command, true);
        int result = 0;
        if (returnData.equalsIgnoreCase(NAK)) {
            result = -1;
        } else {
            try {
                result = Integer.parseInt(returnData.substring(1));
            }
            catch (Exception e) {
                result = -1;
            }
        }
        if (this instanceof P00Processor && result == 9999 && this.excuteCommand("QMD", true).indexOf("PSI5") != -1) {
            return -1;
        }
        return result;
    }

    public static String getPCInfo() {
        String urlStr = "http://localhost:8189/cpusum.json";
        URL url = null;
        HttpURLConnection conn = null;
        BufferedReader br = null;
        String res = "";
        try {
            try {
                url = new URL(urlStr);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.connect();
                br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                String line = "";
                while ((line = br.readLine()) != null) {
                    res = String.valueOf(res) + line;
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                try {
                    br.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    br.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    @Override
    public String setBatLowCapacity(int value) throws IOException {
        return null;
    }

    @Override
    public String setBatLowVoltage(double value) throws IOException {
        return null;
    }

    @Override
    public String setBatMinCutOffVol(double value) throws IOException {
        return null;
    }

    @Override
    public String setBatShutdownCapacity(int value) throws IOException {
        return null;
    }

    @Override
    public String setBatShutdownDelay(int value) throws IOException {
        return null;
    }

    @Override
    public String setBatTestStopCapacity(int value) throws IOException {
        return null;
    }

    @Override
    public String setBatTestStopTime(int value) throws IOException {
        return null;
    }

    @Override
    public String setBatTestStopVol(double value) throws IOException {
        return null;
    }

    @Override
    public String setChargingCurrent(int value) throws IOException {
        return null;
    }

    @Override
    public String setConverterModeOutFre(int value) throws IOException {
        return null;
    }

    @Override
    public String setEpoFunction(int value) throws IOException {
        return null;
    }

    @Override
    public String setPeriodSelfTest(int value) throws IOException {
        return null;
    }

    @Override
    public void setSupportBatNum(boolean arg0) throws IOException {
    }

    @Override
    public String setTotalCapacity(int value) throws IOException {
        return null;
    }

    @Override
    public ParameterSettings getParameterSettings() throws IOException {
        return this.param;
    }

    @Override
    public String turnToBypass() throws IOException {
        return null;
    }

    @Override
    public Date queryBID(String value) throws IOException {
        return null;
    }

    @Override
    public Date queryBMD(String value) throws IOException {
        return null;
    }

    @Override
    public Date querySID(String value) throws IOException {
        return null;
    }

    @Override
    public Date querySMD(String value) throws IOException {
        return null;
    }

    @Override
    public String setBID(String id, Date selectDate) throws IOException {
        return null;
    }

    @Override
    public String setBMD(String id, Date selectDate) throws IOException {
        return null;
    }

    @Override
    public String setSCB(String value) throws IOException {
        return null;
    }

    @Override
    public String setSID(String id, Date selectDate) throws IOException {
        return null;
    }

    @Override
    public String setSMD(String id, Date selectDate) throws IOException {
        return null;
    }

    @Override
    public String querySCB() throws IOException {
        return null;
    }

    @Override
    public String querySPR() throws IOException {
        return null;
    }

    @Override
    public String setBATAH(int value) throws IOException {
        return null;
    }

    @Override
    public String setBaud(int value) throws Exception {
        return null;
    }

    @Override
    public String setCFTD() throws IOException {
        return null;
    }

    @Override
    public String setCHMC(float value) throws IOException {
        return null;
    }

    @Override
    public String setCHTC(int value) throws IOException {
        return null;
    }

    @Override
    public String setCLDL() throws IOException {
        return null;
    }

    @Override
    public String setMADD(int value) throws IOException {
        return null;
    }

    @Override
    public String setPFTD() throws IOException {
        return null;
    }

    @Override
    public String setPLFH(float value) throws IOException {
        return null;
    }

    @Override
    public String setPLFL(float value) throws IOException {
        return null;
    }

    @Override
    public String setPLVH(int value) throws IOException {
        return null;
    }

    @Override
    public String setPLVL(int value) throws IOException {
        return null;
    }

    @Override
    public String setREEP() throws IOException {
        return null;
    }

    @Override
    public String setSBDT(int value) throws IOException {
        return null;
    }

    @Override
    public String setSBHV(float value) throws IOException {
        return null;
    }

    @Override
    public String setSBNV(float value) throws IOException {
        return null;
    }

    @Override
    public String setSBSV(float value) throws IOException {
        return null;
    }

    @Override
    public String setSBTT(int value) throws IOException {
        return null;
    }

    @Override
    public String setSBTV(float value) throws IOException {
        return null;
    }

    @Override
    public String setSIPT(int value1, int value2) throws IOException {
        return null;
    }

    @Override
    public String setSIPV(int value) throws IOException {
        return null;
    }

    @Override
    public String setSOPF(float value) throws IOException {
        return null;
    }

    @Override
    public String setSOPT(int value1, int value2) throws IOException {
        return null;
    }

    @Override
    public String setSSTN(int value1, int value2) throws IOException {
        return null;
    }

    @Override
    public String setSTIME(Date selectDate) throws IOException {
        return null;
    }

    @Override
    public String setSVOL(int value) throws IOException {
        return null;
    }

    @Override
    public String setSABTP(int type, int weekday, int hour, int minute, int month, int day) throws IOException {
        return null;
    }

    @Override
    public String setSBLF(int value) throws IOException {
        return null;
    }

    @Override
    public String setSDATE(String id, Date selectDate) throws IOException {
        return null;
    }

    @Override
    public String setSMOD(int value) throws IOException {
        return null;
    }

    @Override
    public String setSOPV(int value) throws IOException {
        return null;
    }

    @Override
    public String setSPWID(int value) throws IOException {
        return null;
    }

    @Override
    public String setSPWIT(int value) throws IOException {
        return null;
    }

    @Override
    public LineVoltage getLine() throws IOException {
        return null;
    }

    @Override
    public Date queryTIME() throws IOException {
        return null;
    }

    public String offSwitchCtrl(String minues) throws IOException {
        String delayShutdownTime = minues;
        String command = "Sn".replace("n", delayShutdownTime);
        return this.excuteCommand(command, true);
    }

    @Override
    public void offSwitchCtrl(int minutes) throws IOException {
        String delayShutdownTime = this.getDelayShutdownTime();
        minutes = minutes > 9999 ? 9999 : minutes;
        DecimalFormat df3 = new DecimalFormat("0000");
        String turnOnDelay = df3.format(minutes);
        String command = null;
        command = "SnRm".replace("n", delayShutdownTime).replace("m", turnOnDelay);
        this.excuteCommand(command, true);
    }

    public void offSwitchCtrl(String delayShutdownTime, int minutes) throws IOException {
        minutes = minutes > 9999 ? 9999 : minutes;
        DecimalFormat df3 = new DecimalFormat("0000");
        String turnOnDelay = df3.format(minutes);
        String command = null;
        command = "SnRm".replace("n", delayShutdownTime).replace("m", turnOnDelay);
        this.excuteCommand(command, true);
    }

    protected String returnCommandValue(String command) {
        String returnData = this.excuteCommand(command, true);
        if (returnData.equalsIgnoreCase(ACK)) {
            return SUCCESS;
        }
        return FAILURE;
    }

    protected void shutdownOverTemperature() {
        if (!"ATMUSE".equalsIgnoreCase(MyConstants.Customized)) {
            return;
        }
        Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
        int minutes = 30;
        RemoteShutdown remoteShutdown = new RemoteShutdown();
        PropertiesUtils.wrapProperties(remoteShutdown);
        if (remoteShutdown.isOverTemperatureRemoteShutdown()) {
            RemoteShutdownProcesser processer = new RemoteShutdownProcesser();
            processer.sendOverTempRemoteShutdownMsg();
            logger.info("----------Over temperature execute remote shutdown!");
        }
        if (shutdown.isOverTemperatureShutdown()) {
            minutes = shutdown.getTurnOnUPSdelay();
            this.runBeforeExcuteFileForOverTemp(shutdown);
            logger.info("----------Over temperature execute file begin...");
            this.executeFile(shutdown);
            logger.info("----------Over temperature execute file end!");
            try {
                Thread.sleep(shutdown.getExcuteProgramTimeMillis());
            }
            catch (InterruptedException processer) {
                // empty catch block
            }
            if (shutdown.isBatModeShutdownUps()) {
                try {
                    if (shutdown.isTurnOnUPS()) {
                        this.offSwitchCtrl(minutes);
                    } else {
                        this.offSwitchCtrl();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!shutdown.isNoShutLocalExecute()) {
                SystemShutdown.shutdown(this.getDeviceName(), this.getProtocol().getProtocolID(), this.getDeviceId());
            }
            this.isExcuteShutFile = false;
            this.isOverTemperature = false;
        }
    }

    private void runBeforeExcuteFileForOverTemp(Shutdownconfigure shutdown) {
        if (shutdown.isBatModeShutdownUps()) {
            try {
                float shut = shutdown.getExcuteProgramTime() + shutdown.getShutdownTime();
                String delayShutdownTime = this.getFormatUPSShutdownTime(shut);
                if (shutdown.isOverTemperatureShutdown() && shutdown.isTurnOnUPS()) {
                    int minutes = shutdown.getTurnOnUPSdelay();
                    this.offSwitchCtrl(delayShutdownTime, minutes);
                } else {
                    this.offSwitchCtrl();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getFormatUPSShutdownTime(float shutdownTime) {
        String delayShutdownTime = "";
        delayShutdownTime = shutdownTime < 1.0f ? String.valueOf(delayShutdownTime) + String.valueOf(shutdownTime).substring(1, 3) : (shutdownTime < 10.0f ? String.valueOf(delayShutdownTime) + "0" + (int)shutdownTime : String.valueOf(delayShutdownTime) + String.valueOf((int)shutdownTime));
        return delayShutdownTime;
    }

    @Override
    public String setBULKV(float value) throws IOException {
        return null;
    }

    @Override
    public String setFLATV(float value) throws IOException {
        return null;
    }

    @Override
    public String setCTFT(int value) throws IOException {
        return null;
    }

    @Override
    public String setUSID(String value) throws IOException {
        return null;
    }

    @Override
    public String setBATT(int value) throws IOException {
        return null;
    }

    @Override
    public String setNewParameter(String type, String value) throws IOException {
        return null;
    }

    public String str2Hex(String str) {
        char[] chars = str.toCharArray();
        StringBuffer hex = new StringBuffer();
        int i = 0;
        while (i < chars.length) {
            hex.append(Integer.toHexString(chars[i]));
            ++i;
        }
        return hex.toString();
    }

    public boolean insertBatteryLife(String port, String ptid, String start, String life) {
        BatteryLifeDao dao = new BatteryLifeDao();
        return dao.insert(port, ptid, start, life);
    }

    public boolean updateBatteryLife(String port, String ptid, String start, String life) {
        BatteryLifeDao dao = new BatteryLifeDao();
        return dao.updateLife(port, ptid, start, life);
    }

    public String getLife(String port, String ptid) {
        BatteryLifeDao dao = new BatteryLifeDao();
        return dao.qryLife(port, ptid);
    }

    public void delLife(String port, String ptid) {
        BatteryLifeDao dao = new BatteryLifeDao();
        dao.deleteLife(port, ptid);
    }

    @Override
    public String cancelSwitchCtrl() throws IOException {
        return null;
    }

    @Override
    public String deepBatteryTestCtrl() throws IOException, UnsupportException {
        return null;
    }

    @Override
    public String munitesBatteryTestCtrl(float minute) throws IOException, UnsupportException {
        return null;
    }

    @Override
    public String offBuzzerCtrl() throws IOException {
        return null;
    }

    @Override
    public String offSwitchCtrlOntime() throws IOException {
        return null;
    }

    @Override
    public String offSwitchCtrlOntime(int minutes) throws IOException {
        return null;
    }

    @Override
    public String onBuzzerCtrl() throws IOException {
        return null;
    }

    @Override
    public String tenSencondsBatteryTestCtrl() throws IOException {
        return null;
    }

    @Override
    public void testOperation() throws IOException {
    }

    @Override
    public boolean isSupportBatNum() throws IOException {
        return false;
    }

    public boolean wrongFormat(String cmd, String ret) {
        if (ret.length() < 4) {
            return false;
        }
        String[] arr = ret.split(" ");
        if (cmd.equals("QS") && arr.length != 8) {
            return true;
        }
        if (cmd.equals("QI") && arr.length != 5) {
            return true;
        }
        return cmd.equals("F") && arr.length != 4;
    }

    @Override
    public String getStartTime() {
        return this.starttime;
    }

    public void setCUP(CpuInfo info) {
        int speed = info.getSpeed();
        int temp = info.getTemp();
        double load = info.getLoad();
        DecimalFormat df = new DecimalFormat("0000");
        String speed1 = df.format(speed);
        DecimalFormat df2 = new DecimalFormat("00");
        String temp1 = df2.format(temp);
        DecimalFormat df3 = new DecimalFormat("00.0000");
        String load1 = df3.format(load);
        String cmd = "CPU" + speed1 + " " + temp1 + " " + load1;
        this.excuteCommand(cmd, true);
    }
}

