/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.modem;

import cn.com.voltronicpower.modem.GFString;

public class PduPack {
    private String smscLen;
    private String smscFormat;
    private String smsc;
    private int addrLen;
    private String addrFormat;
    private String addr;
    private String msgCoding;
    private int msgLen;
    private String msgContent;

    public PduPack() {
        this.smscLen = "08";
        this.smscFormat = "91";
        this.addrLen = 13;
        this.addrFormat = "91";
    }

    public PduPack(String src) {
        if (src != null && src.length() > 44) {
            String temp = src.substring(4, 18);
            this.smsc = GFString.interChange(temp);
            if (this.smsc != null && this.smsc.length() > 1) {
                this.smsc = this.smsc.substring(0, this.smsc.length() - 1);
                if (this.smsc.length() == 13) {
                    this.smsc = this.smsc.substring(2);
                }
            }
            temp = src.substring(20, 22);
            this.addrLen = Integer.parseInt(temp, 16);
            temp = this.addrLen % 2 == 0 ? src.substring(24, 24 + this.addrLen) : src.substring(24, 24 + this.addrLen + 1);
            this.addr = GFString.interChange(temp);
            if (this.addr != null && this.addr.length() % 2 == 0) {
                this.addr = this.addr.substring(0, this.addr.length() - 1);
                if (this.addr.length() == 13) {
                    this.addr = this.addr.substring(2);
                }
            }
            if (this.addrLen % 2 == 0) {
                this.msgCoding = src.substring(24 + this.addrLen + 2, 24 + this.addrLen + 4);
                temp = src.substring(24 + this.addrLen + 4 + 16);
            } else {
                this.msgCoding = src.substring(24 + this.addrLen + 3, 24 + this.addrLen + 5);
                temp = src.substring(24 + this.addrLen + 5 + 16);
            }
            this.msgContent = this.msgCoding.equals("08") ? GFString.unicode2gb(temp) : GFString.decode7bit(temp);
        }
    }

    public void setSmsc(String s) {
        if (s != null) {
            String centerNo = null;
            if (s.length() == 11 && s.substring(0, 2).equals("13")) {
                centerNo = "86" + s;
            } else if (s.length() == 13 && s.substring(0, 4).equals("8613")) {
                centerNo = s;
            } else if (s.length() == 14 && s.substring(0, 5).equals("+8613")) {
                centerNo = s.substring(1);
            } else {
                return;
            }
            this.smsc = GFString.interChange(centerNo);
        }
    }

    public void setAddr(String ad) {
        if (ad != null) {
            String centerNo = null;
            if (ad.length() == 11 && ad.substring(0, 2).equals("13")) {
                centerNo = "86" + ad;
            } else if (ad.length() == 13 && ad.substring(0, 4).equals("8613")) {
                centerNo = ad;
            } else if (ad.length() == 14 && ad.substring(0, 5).equals("+8613")) {
                centerNo = ad.substring(1);
            } else if (ad.length() > 0) {
                this.addrFormat = "A1";
                this.addrLen = ad.length();
                centerNo = ad;
            } else {
                return;
            }
            this.addr = GFString.interChange(centerNo);
        }
    }

    public void setMsgCoding(int encoding) {
        this.msgCoding = encoding == 8 ? "08" : (encoding == 4 ? "04" : "00");
    }

    public void setMsgContent(String content) {
        if (content != null) {
            if (content.length() == content.getBytes().length) {
                this.msgCoding = "00";
                this.msgLen = content.getBytes().length;
                this.msgContent = PduPack.encode7bit(content);
            } else {
                this.msgCoding = "08";
                this.msgContent = GFString.gb2unicode(content);
                if (this.msgContent != null) {
                    this.msgLen = this.msgContent.length() / 2;
                }
            }
            if (this.msgContent != null) {
                this.msgContent = this.msgContent.toUpperCase();
            }
        }
    }

    public String getCodedResult() {
        String result = null;
        String tp_mti = "11";
        String tp_mr = "00";
        String tp_pid = "00";
        String tp_vp = "00";
        if (this.smsc != null && this.addr != null && this.msgContent != null) {
            result = String.valueOf(this.smscLen) + this.smscFormat + this.smsc + "11" + "00" + GFString.byte2hex((byte)this.addrLen) + this.addrFormat + this.addr + "00" + this.msgCoding + "00" + GFString.byte2hex((byte)this.msgLen) + this.msgContent;
            result = result.toUpperCase();
        }
        return result;
    }

    public String getAddr() {
        return this.addr;
    }

    public String getMsgCoding() {
        return this.msgCoding;
    }

    public String getMsgContent() {
        return this.msgContent;
    }

    public int getMsgLen() {
        return this.msgLen;
    }

    public String getSmsc() {
        return this.smsc;
    }

    public static String encode7bit(String src) {
        String result = null;
        String hex = null;
        if (src != null && src.length() == src.getBytes().length) {
            result = "";
            byte left = 0;
            byte[] b = src.getBytes();
            int i = 0;
            int j = 0;
            while (i < b.length) {
                j = i & 7;
                if (j == 0) {
                    left = b[i];
                } else {
                    byte value = (byte)(b[i] << 8 - j | left);
                    left = (byte)(b[i] >> j);
                    hex = GFString.byte2hex(value);
                    result = String.valueOf(result) + hex;
                    if (i == b.length - 1) {
                        result = String.valueOf(result) + GFString.byte2hex(left);
                    }
                }
                ++i;
            }
            result = result.toUpperCase();
        }
        return result;
    }
}

