/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.modem;

import cn.com.voltronicpower.data.bean.SmsInfo;
import cn.com.voltronicpower.modem.PDUUSC2Format;
import cn.com.voltronicpower.monitorcommunicate.SerialPortHandler;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.StrConvert;
import com.fazecast.jSerialComm.SerialPort;
import java.io.InputStream;
import java.io.OutputStream;

public class ModemAdapter {
    private String[] destinations;
    private String message;
    private int baudRate;
    private String portName;
    String mstr2 = null;
    private static final Log logger = new Log();

    public ModemAdapter(SmsInfo smsInfo, String message) {
        this.destinations = smsInfo.getMobileNums().split(",");
        this.message = message;
        this.baudRate = StrConvert.toInteger(smsInfo.getBit());
        this.portName = smsInfo.getComPort();
    }

    public ModemAdapter(String portName, int baudRate, String[] destinations, String message) {
        this.destinations = destinations;
        this.message = message;
        this.baudRate = baudRate;
        this.portName = portName;
    }

    public boolean startSendForPDU() {
        boolean result = false;
        SerialPort serialPort = null;
        SerialPort[] comPorts = SerialPort.getCommPorts();
        int i = 0;
        while (i < comPorts.length) {
            block19: {
                String comName = comPorts[i].getSystemPortName();
                if (comName.equals(this.portName)) {
                    try {
                        try {
                            serialPort = comPorts[i];
                            if (serialPort.openPort()) {
                                serialPort.setComPortParameters(this.baudRate, 8, 1, 0);
                                serialPort.setComPortTimeouts(1, 100, 1200, true);
                                String[] stringArray = this.destinations;
                                int n = this.destinations.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String destination = stringArray[n2];
                                    Thread.sleep(500L);
                                    if (destination != null && !"".equals(destination)) {
                                        this.sendSMSPDU(serialPort, destination, this.message);
                                        result = true;
                                    }
                                    ++n2;
                                }
                            }
                        }
                        catch (Exception e) {
                            result = false;
                            if (serialPort != null) {
                                try {
                                    serialPort.closePort();
                                }
                                catch (Exception exception) {}
                            }
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        if (serialPort != null) {
                            try {
                                serialPort.closePort();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (serialPort != null) {
                        try {
                            serialPort.closePort();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
        String[] destinations = new String[]{"18970843583"};
        ModemAdapter adapter = new ModemAdapter("COM1", 9600, destinations, "This is a test for SMSzzz");
        try {
            adapter.startSendForAT();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean startSendForAT() {
        boolean result = false;
        SerialPortHandler handler = null;
        SerialPort[] comPorts = SerialPort.getCommPorts();
        int i = 0;
        while (i < comPorts.length) {
            block13: {
                String comName = comPorts[i].getSystemPortName();
                if (comName.equals(this.portName)) {
                    try {
                        try {
                            SerialPort serialPort = comPorts[i];
                            if (serialPort.openPort()) {
                                handler = new SerialPortHandler(serialPort);
                                serialPort.setComPortParameters(this.baudRate, 8, 1, 0);
                                serialPort.setComPortTimeouts(1, 10000, 0);
                                OutputStream output = serialPort.getOutputStream();
                                String[] stringArray = this.destinations;
                                int n = this.destinations.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String destination = stringArray[n2];
                                    System.out.println("AT start");
                                    String at = handler.excuteCommand("AT");
                                    String cmgf = handler.excuteCommand("AT+CMGF=1");
                                    if (destination != null && !"".equals(destination)) {
                                        String receiveStr = handler.excuteCommand("AT+CMGS=" + destination);
                                        if (receiveStr.contains("ERROR") || receiveStr.contains("error")) {
                                            handler.excuteCommand("AT+CMGS=\"" + destination + "\"");
                                        }
                                        String value = handler.excuteCommand(this.message);
                                        while (value.indexOf(">") != -1) {
                                            this.message = this.message.substring(this.message.indexOf("\r\n") + 2);
                                            value = handler.excuteCommand(this.message);
                                            if (this.message.indexOf("\r\n") < 0) break;
                                        }
                                        output.write(26);
                                        if (value != null && value.length() > 0) {
                                            result = true;
                                        }
                                    }
                                    ++n2;
                                }
                            }
                        }
                        catch (Exception e) {
                            result = false;
                            logger.error(e.toString());
                            handler.close();
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        handler.close();
                        throw throwable;
                    }
                    handler.close();
                }
            }
            ++i;
        }
        return result;
    }

    private void sendAndRead(SerialPort serialPort, byte[] bytes) {
        try {
            OutputStream output = serialPort.getOutputStream();
            InputStream input = serialPort.getInputStream();
            output.write(bytes);
            output.flush();
            long end = System.currentTimeMillis() + 3000L;
            StringBuilder sb = new StringBuilder();
            while (System.currentTimeMillis() < end) {
                int ch = input.read();
                if (ch <= 0) continue;
                sb.append((char)ch);
            }
            String returnValue = sb.toString();
            System.out.println(returnValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendSMSPDU(SerialPort serialPort, String phone, String message) throws Exception {
        PDUUSC2Format pdu = new PDUUSC2Format(phone, message);
        String sContent = pdu.getString();
        int length = (sContent.length() - 2) / 2;
        String cstemp = "AT";
        cstemp = String.valueOf(cstemp) + "\r";
        this.sendAndRead(serialPort, cstemp.getBytes());
        this.delayTime();
        this.delayTime();
        cstemp = "AT+CMGF=0";
        cstemp = String.valueOf(cstemp) + "\r";
        this.sendAndRead(serialPort, cstemp.getBytes());
        this.delayTime();
        cstemp = "AT+CMGS=" + length;
        cstemp = String.valueOf(cstemp) + "\r";
        this.sendAndRead(serialPort, cstemp.getBytes());
        long current = System.currentTimeMillis();
        this.delayTime();
        this.sendAndRead(serialPort, sContent.getBytes());
        this.delayTime();
        this.delayTime();
        this.sendAndRead(serialPort, new byte[]{26});
        this.sendAndRead(serialPort, new byte[]{26});
    }

    private void delayTime() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

