/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.mail;

import cn.com.voltronicpower.data.bean.EmailInfo;
import cn.com.voltronicpower.mail.EmailUtil;
import cn.com.voltronicpower.mail.SendMail;
import cn.com.voltronicpower.utilities.Log;
import javax.mail.MessagingException;

public class EmailSendUtil
extends EmailUtil {
    private static final Log logger = new Log();
    private String to;
    private String from;
    private String host;
    private int port;
    private String username;
    private String password;
    private Boolean needAuth = true;

    public EmailSendUtil(EmailInfo info) {
        this.host = info.getSmtp().trim();
        this.port = info.getPort();
        this.username = info.getAccount().trim();
        this.needAuth = info.getNeedAuth();
        this.password = info.getPassword().trim();
        this.from = info.getSender().trim();
    }

    @Override
    public boolean sendMail(String to, String subject, String content) {
        boolean isSuccess = true;
        SendMail themail = new SendMail(this.host, this.port, true);
        themail.setNeedAuth(this.needAuth);
        try {
            themail.setSubject(subject);
            themail.setBody(content);
            themail.setTo(to);
            themail.setFrom(this.from);
            themail.setNamePass(this.from, this.password);
            themail.sendout();
            logger.info("------");
        }
        catch (MessagingException e) {
            logger.info(e.getMessage());
            isSuccess = false;
        }
        if (isSuccess) {
            return true;
        }
        SendMail themail2 = new SendMail(this.host, this.port, false);
        themail2.setNeedAuth(this.needAuth);
        try {
            themail2.setSubject(subject);
            themail2.setBody(content);
            themail2.setTo(to);
            themail2.setFrom(this.from);
            themail2.setNamePass(this.username, this.password);
            themail2.sendout();
        }
        catch (MessagingException e) {
            return false;
        }
        return true;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Boolean getNeedAuth() {
        return this.needAuth;
    }

    public void setNeedAuth(Boolean needAuth) {
        this.needAuth = needAuth;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public static void main(String[] args) {
        String mailbody = "hello java mail via TLSv1.2!";
        SendMail themail = new SendMail("smtp.163.com", 465, false);
        themail.setNeedAuth(true);
        try {
            themail.setSubject("test mail send");
            themail.setBody(mailbody);
            themail.setTo("Peili_da@voltronicpower.com.cn");
            themail.setFrom("peilida1998@163.com");
            themail.setNamePass("peilida1998@163.com", "NQWDILYCUWHBUCXG");
            themail.sendout();
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }
}

