/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.exception;

import cn.com.voltronic.socket.SystemTrayUDPClient;
import cn.com.voltronic.util.DateUtils;
import cn.com.voltronicpower.data.bean.BuyInfo;
import cn.com.voltronicpower.data.bean.EletricEvent;
import cn.com.voltronicpower.data.bean.Event;
import cn.com.voltronicpower.data.bean.EventInfo;
import cn.com.voltronicpower.data.bean.EventStatis;
import cn.com.voltronicpower.data.bean.GlobalConfig;
import cn.com.voltronicpower.data.dao.EventConfigDao;
import cn.com.voltronicpower.data.dao.EventDao;
import cn.com.voltronicpower.data.tools.DBManager;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.utilities.SaveEvent;
import cn.com.voltronicpower.utilities.SendEventsUtil;
import cn.com.voltronicpower.work.BroadcastHandler;
import cn.com.voltronicpower.work.SystemShutdown;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class EventsHandler {
    private static Document document;
    private static Map<String, List<String>> eventsMap;
    private static final Log logger;

    static {
        eventsMap = new HashMap<String, List<String>>();
        logger = new Log();
        document = EventsHandler.doDocument("eletricEvents.xml");
    }

    public static Document getDocument() {
        return document;
    }

    public static List<Element> getExtEventDocument() {
        Document document = EventsHandler.doDocument("eletricEvents_EXT.xml");
        List list = document.getRootElement().elements("event");
        return list;
    }

    public static List<Element> getEventDocument(String ptid) {
        String fileName = "eletricEvents_" + ptid + ".xml";
        if ("".equals(ptid)) {
            fileName = "eletricEvents_PMV.xml";
        }
        Document document = EventsHandler.doDocument(fileName);
        List list = document.getRootElement().elements("event");
        return list;
    }

    public static List<Element> getAllEvent() {
        Document document = EventsHandler.doDocument("eletricEvents.xml");
        List list = document.getRootElement().elements("event");
        return list;
    }

    public static Document doDocument(String fileName) {
        Document document;
        block13: {
            document = null;
            SAXReader reader = new SAXReader();
            File fileExt = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + "xml" + File.separator + fileName);
            if (fileExt != null && fileExt.exists() && fileExt.isFile()) {
                FileInputStream fisExt = null;
                try {
                    try {
                        fisExt = new FileInputStream(fileExt);
                        document = reader.read((InputStream)fisExt);
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                        if (fisExt == null) break block13;
                        try {
                            fisExt.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    if (fisExt != null) {
                        try {
                            fisExt.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        return document;
    }

    public static ArrayList<EventInfo> queryPortEvents(Date startDate, Date endDate, String port, String ptid, String sn) {
        EventDao eventDao = new EventDao();
        ArrayList<EventInfo> events = null;
        events = StringUtils.isEmpty((String)sn) ? eventDao.getEvents(startDate, endDate, port, ptid) : eventDao.getEvents(startDate, endDate, port, ptid, sn);
        for (EventInfo event : events) {
            Element eventEle = (Element)document.selectSingleNode("//event[@id='" + event.getEventId() + "']");
            if (eventEle == null) continue;
            event.setLevel(eventEle.attributeValue("level"));
            event.setName(eventEle.attributeValue("name"));
            event.setType(eventEle.attributeValue("type"));
            event.setTwName(eventEle.attributeValue("twName"));
            event.setTwType(eventEle.attributeValue("twType"));
            event.setEnName(eventEle.attributeValue("enName"));
            event.setEnType(eventEle.attributeValue("enType"));
            event.setFrName(eventEle.attributeValue("frName"));
            event.setFrType(eventEle.attributeValue("frType"));
            event.setDeName(eventEle.attributeValue("deName"));
            event.setDeType(eventEle.attributeValue("deType"));
            event.setItName(eventEle.attributeValue("itName"));
            event.setItType(eventEle.attributeValue("itType"));
            event.setPlName(eventEle.attributeValue("plName"));
            event.setPlType(eventEle.attributeValue("plType"));
            event.setPtName(eventEle.attributeValue("ptName"));
            event.setPtType(eventEle.attributeValue("ptType"));
            event.setRusName(eventEle.attributeValue("rusName"));
            event.setRusType(eventEle.attributeValue("rusType"));
            event.setSpName(eventEle.attributeValue("spName"));
            event.setSpType(eventEle.attributeValue("spType"));
            event.setUkrName(eventEle.attributeValue("ukrName"));
            event.setUkrType(eventEle.attributeValue("ukrType"));
            event.setTurName(eventEle.attributeValue("turName"));
            event.setTurType(eventEle.attributeValue("turType"));
            event.setCsName(eventEle.attributeValue("csName"));
            event.setCsType(eventEle.attributeValue("csType"));
            event.setJpName(eventEle.attributeValue("jpName"));
            event.setJpType(eventEle.attributeValue("jpType"));
        }
        return events;
    }

    public static void handleEvent(String portName, String eventCode, String ptid, String sn, boolean isStore) {
        List<String> events;
        String upsPN = EventsHandler.getUPSPN(ptid, portName);
        if ("".equals(sn = sn.trim()) || sn == null || "----".equals(sn) || "00000000000000000000".equals(sn)) {
            sn = upsPN;
        }
        if ((events = eventsMap.get(portName)) == null) {
            events = new LinkedList<String>();
            eventsMap.put(portName, events);
        }
        if (!events.contains(eventCode)) {
            System.out.println("\u7f13\u5b58" + eventCode);
            if (isStore) {
                events.add(eventCode);
            }
            EventsHandler.reocrdEvent(portName, eventCode, ptid, sn);
        }
    }

    public static String getUPSPN(String ptid, String portName) {
        String pn;
        block21: {
            pn = "";
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("select UPS_PN from BUYINFO where ptid=? and port_name=?");
                    ps.setString(1, ptid);
                    ps.setString(2, portName);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        pn = rs.getString("UPS_PN");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (ps == null) break block21;
                    try {
                        ps.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return pn;
    }

    public static void removeEvent(String portName, String eventCode) {
        List<String> events = eventsMap.get(portName);
        if (events != null) {
            events.remove(eventCode);
        }
    }

    public static void putEvent(String portName, String eventCode) {
        List<String> events = eventsMap.get(portName);
        if (events == null) {
            events = new LinkedList<String>();
            eventsMap.put(portName, events);
        }
        if (!events.contains(eventCode)) {
            events.add(eventCode);
        }
    }

    public static void removeDeviceEvents(String portName) {
        eventsMap.remove(portName);
    }

    public static void batteryWarnEvent(BuyInfo info) {
        String eventId = "4019";
        String portName = "";
        portName = info.getPortName();
        EventsHandler.handleEvent(portName, eventId, info.getPtid(), info.getDeviceId(), true);
        EventConfigDao configDao = new EventConfigDao();
        EletricEvent eventConfig = configDao.getEventConfigById(eventId);
        Element eventEle = (Element)document.selectSingleNode("//event[@id='" + eventId + "']");
        GlobalConfig config = PropertiesUtils.getGlobalConfig();
        String type = null;
        String name = null;
        if (config.getLanguage().equals("zh_CN")) {
            type = eventEle.attributeValue("type");
            name = eventEle.attributeValue("name");
        } else if (config.getLanguage().equals("zh_TW")) {
            type = eventEle.attributeValue("twType");
            name = eventEle.attributeValue("twName");
        } else if (config.getLanguage().equals("fr_FR")) {
            type = eventEle.attributeValue("frType");
            name = eventEle.attributeValue("frName");
        } else if (config.getLanguage().equals("de_DE")) {
            type = eventEle.attributeValue("deType");
            name = eventEle.attributeValue("deName");
        } else if (config.getLanguage().equals("it_IT")) {
            type = eventEle.attributeValue("itType");
            name = eventEle.attributeValue("itName");
        } else if (config.getLanguage().equals("pl_PL")) {
            type = eventEle.attributeValue("plType");
            name = eventEle.attributeValue("plName");
        } else if (config.getLanguage().equals("pt_PT")) {
            type = eventEle.attributeValue("ptType");
            name = eventEle.attributeValue("ptName");
        } else if (config.getLanguage().equals("ru_RU")) {
            type = eventEle.attributeValue("rusType");
            name = eventEle.attributeValue("rusName");
        } else if (config.getLanguage().equals("es_ES")) {
            type = eventEle.attributeValue("spType");
            name = eventEle.attributeValue("spName");
        } else if (config.getLanguage().equals("uk_UA")) {
            type = eventEle.attributeValue("ukrType");
            name = eventEle.attributeValue("ukrName");
        } else if (config.getLanguage().equals("tr_TR")) {
            type = eventEle.attributeValue("turType");
            name = eventEle.attributeValue("turName");
        } else if (config.getLanguage().equals("cs_CS")) {
            type = eventEle.attributeValue("csType");
            name = eventEle.attributeValue("csName");
        } else if (config.getLanguage().equals("ja_JP")) {
            type = eventEle.attributeValue("jpType");
            name = eventEle.attributeValue("jpName");
        } else {
            type = eventEle.attributeValue("enType");
            name = eventEle.attributeValue("enName");
        }
        if (eventConfig.isBroadcastMethod()) {
            BroadcastHandler handler = new BroadcastHandler(type, portName, name);
            handler.start();
        }
        if (eventConfig.isWarningMethod()) {
            EventsHandler.trayClient(type, portName, name, eventId);
        }
        SendEventsUtil eventsUtil = new SendEventsUtil(portName, type, name, eventConfig, config, null);
        eventsUtil.start();
    }

    private static void reocrdEvent(String portName, String eventId, String ptid, String sn) {
        EventConfigDao configDao = new EventConfigDao();
        EletricEvent eventConfig = configDao.getEventConfigById(eventId);
        Element eventEle = (Element)document.selectSingleNode("//event[@id='" + eventId + "']");
        GlobalConfig config = PropertiesUtils.getGlobalConfig();
        if (eventConfig.isRecordMethod()) {
            EventDao eventDao = new EventDao();
            if (StringUtils.isEmpty((String)sn)) {
                eventDao.addEventRecord(eventId, portName, ptid);
            } else {
                eventDao.addEventRecord(eventId, portName, ptid, sn);
            }
            SaveEvent.exportDatasForCSV(portName, ptid, sn);
        }
        if (eventConfig.isBuzzerMethod()) {
            Toolkit.getDefaultToolkit().beep();
            if (SystemShutdown.getShutdownObj() != null) {
                SystemShutdown.getShutdownObj().beep(10);
            }
        }
        String type = null;
        String name = null;
        if (config.getLanguage().equals("zh_CN")) {
            type = eventEle.attributeValue("type");
            name = eventEle.attributeValue("name");
        } else if (config.getLanguage().equals("zh_TW")) {
            type = eventEle.attributeValue("twType");
            name = eventEle.attributeValue("twName");
        } else if (config.getLanguage().equals("fr_FR")) {
            type = eventEle.attributeValue("frType");
            name = eventEle.attributeValue("frName");
        } else if (config.getLanguage().equals("de_DE")) {
            type = eventEle.attributeValue("deType");
            name = eventEle.attributeValue("deName");
        } else if (config.getLanguage().equals("it_IT")) {
            type = eventEle.attributeValue("itType");
            name = eventEle.attributeValue("itName");
        } else if (config.getLanguage().equals("pl_PL")) {
            type = eventEle.attributeValue("plType");
            name = eventEle.attributeValue("plName");
        } else if (config.getLanguage().equals("pt_PT")) {
            type = eventEle.attributeValue("ptType");
            name = eventEle.attributeValue("ptName");
        } else if (config.getLanguage().equals("ru_RU")) {
            type = eventEle.attributeValue("rusType");
            name = eventEle.attributeValue("rusName");
        } else if (config.getLanguage().equals("es_ES")) {
            type = eventEle.attributeValue("spType");
            name = eventEle.attributeValue("spName");
        } else if (config.getLanguage().equals("uk_UA")) {
            type = eventEle.attributeValue("ukrType");
            name = eventEle.attributeValue("ukrName");
        } else if (config.getLanguage().equals("tr_TR")) {
            type = eventEle.attributeValue("turType");
            name = eventEle.attributeValue("turName");
        } else if (config.getLanguage().equals("cs_CS")) {
            type = eventEle.attributeValue("csType");
            name = eventEle.attributeValue("csName");
        } else if (config.getLanguage().equals("ja_JP")) {
            type = eventEle.attributeValue("jpType");
            name = eventEle.attributeValue("jpName");
        } else {
            type = eventEle.attributeValue("enType");
            name = eventEle.attributeValue("enName");
        }
        if (eventConfig.isBroadcastMethod()) {
            BroadcastHandler handler = new BroadcastHandler(type, portName, name);
            handler.start();
        }
        if (eventConfig.isWarningMethod()) {
            EventsHandler.trayClient(type, portName, name, eventId);
        }
        SendEventsUtil eventsUtil = new SendEventsUtil(portName, type, name, eventConfig, config, sn);
        eventsUtil.start();
    }

    public static void trayClient(String type, String portName, String name, String eventid) {
        try (SystemTrayUDPClient client = null;){
            try {
                client = new SystemTrayUDPClient("localhost", 33654);
                String eventDescription = "(Event:[localhost_";
                eventDescription = portName == null ? String.valueOf(eventDescription) + DateUtils.getFormatTimestamp((Date)new Date()) + "] [" + type + "] " + name + "13" : String.valueOf(eventDescription) + portName + "] [" + DateUtils.getFormatTimestamp((Date)new Date()) + "] [" + type + "] " + name + "13";
                eventDescription = String.valueOf(eventDescription) + "*" + eventid;
                eventDescription = String.valueOf(eventDescription) + '\r';
                byte[] cmdb = eventDescription.getBytes("UTF-8");
                client.send(cmdb);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (client != null) {
                    client.close();
                }
            }
        }
    }

    public static Collection<EventStatis> getEventPeriodStatis(Date startADate, Date endADate, Date startBDate, Date endBDate, String portName, String ptid, String sn) {
        HashMap<String, EventStatis> statisMap = new HashMap<String, EventStatis>();
        ArrayList<Element> eventEles = new ArrayList<Element>();
        if ("All".equals(ptid)) {
            eventEles.addAll(EventsHandler.getAllEvent());
        } else if ("P31".equals(ptid)) {
            eventEles.addAll(EventsHandler.getEventDocument(ptid));
        } else {
            eventEles.addAll(EventsHandler.getExtEventDocument());
            eventEles.addAll(EventsHandler.getEventDocument(ptid));
        }
        for (Element eventEle : eventEles) {
            EventStatis statis = new EventStatis();
            statis.setName(eventEle.attributeValue("name"));
            statis.setType(eventEle.attributeValue("type"));
            statis.setTwName(eventEle.attributeValue("twName"));
            statis.setTwType(eventEle.attributeValue("twType"));
            statis.setEnName(eventEle.attributeValue("enName"));
            statis.setEnType(eventEle.attributeValue("enType"));
            statis.setFrName(eventEle.attributeValue("frName"));
            statis.setFrType(eventEle.attributeValue("frType"));
            statis.setDeName(eventEle.attributeValue("deName"));
            statis.setDeType(eventEle.attributeValue("deType"));
            statis.setItName(eventEle.attributeValue("itName"));
            statis.setItType(eventEle.attributeValue("itType"));
            statis.setPlName(eventEle.attributeValue("plName"));
            statis.setPlType(eventEle.attributeValue("plType"));
            statis.setPtName(eventEle.attributeValue("ptName"));
            statis.setPtType(eventEle.attributeValue("ptType"));
            statis.setRusName(eventEle.attributeValue("rusName"));
            statis.setRusType(eventEle.attributeValue("rusType"));
            statis.setSpName(eventEle.attributeValue("spName"));
            statis.setSpType(eventEle.attributeValue("spType"));
            statis.setUkrName(eventEle.attributeValue("ukrName"));
            statis.setUkrType(eventEle.attributeValue("ukrType"));
            statis.setTurName(eventEle.attributeValue("turName"));
            statis.setTurType(eventEle.attributeValue("turType"));
            statis.setCsType(eventEle.attributeValue("csType"));
            statis.setCsName(eventEle.attributeValue("csName"));
            statis.setJpType(eventEle.attributeValue("jpType"));
            statis.setJpName(eventEle.attributeValue("jpName"));
            statis.setLevel(eventEle.attributeValue("level"));
            statis.setId(eventEle.attributeValue("id"));
            statisMap.put(statis.getId(), statis);
        }
        EventDao eventDao = new EventDao();
        ArrayList<EventInfo> periodAEvents = null;
        periodAEvents = StringUtils.isEmpty((String)sn) ? eventDao.getEvents(startADate, endADate, portName, ptid) : eventDao.getEvents(startADate, endADate, portName, ptid, sn);
        for (EventInfo event : periodAEvents) {
            try {
                EventStatis statis = (EventStatis)statisMap.get(event.getEventId());
                if (statis != null) {
                    statis.setPeriodA(statis.getPeriodA() + 1);
                    continue;
                }
                System.err.println("A Event Id not found:" + event.getEventId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ArrayList<EventInfo> periodBEvents = null;
        periodBEvents = StringUtils.isEmpty((String)sn) ? eventDao.getEvents(startBDate, endBDate, portName, ptid) : eventDao.getEvents(startBDate, endBDate, portName, ptid, sn);
        for (EventInfo event : periodBEvents) {
            EventStatis statis = (EventStatis)statisMap.get(event.getEventId());
            if (statis != null) {
                statis.setPeriodB(statis.getPeriodB() + 1);
                continue;
            }
            System.err.println("B Event Id not found:" + event.getEventId());
        }
        for (EventStatis stat : statisMap.values()) {
            stat.calChange();
        }
        return statisMap.values();
    }

    public static void main(String[] args) {
        Document d1 = EventsHandler.doDocument("eletricEvents_P71.xml");
        int[] a = new int[]{3755, 3404, 3757, 3758, 3761, 3762, 3763, 5003, 3301, 3764, 3765, 3766, 3767, 3517, 3768, 3412, 9057, 3769, 3770, 3751, 3771, 3414, 3772, 8029, 3773, 3774, 3775, 3776};
        List list1 = d1.getRootElement().elements("event");
        int[] nArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            String id = String.valueOf(i);
            for (Element e2 : list1) {
                if (!id.equals(e2.attributeValue("id"))) continue;
                System.out.println(e2.attributeValue("name"));
                break;
            }
            ++n2;
        }
    }

    public static List<Event> getEvents(String fileName) {
        LinkedList<Event> events = new LinkedList<Event>();
        Document document = EventsHandler.doDocument(fileName);
        List list = document.getRootElement().elements("event");
        for (Element eventEle : list) {
            String id = eventEle.attributeValue("id");
            String level = eventEle.attributeValue("level");
            String type = EventsHandler.getEventType(eventEle);
            String name = EventsHandler.getEventName(eventEle);
            Event event = new Event();
            event.setId(id);
            event.setLevel(level);
            event.setType(type);
            event.setName(name);
            events.add(event);
        }
        return events;
    }

    public static String getEventType(Element eventEle) {
        GlobalConfig config = PropertiesUtils.getGlobalConfig();
        String name = null;
        name = config.getLanguage().equals("zh_CN") ? eventEle.attributeValue("type") : (config.getLanguage().equals("fr_FR") ? eventEle.attributeValue("frType") : (config.getLanguage().equals("de_DE") ? eventEle.attributeValue("deType") : (config.getLanguage().equals("it_IT") ? eventEle.attributeValue("itType") : (config.getLanguage().equals("pl_PL") ? eventEle.attributeValue("plType") : (config.getLanguage().equals("pt_PT") ? eventEle.attributeValue("ptType") : (config.getLanguage().equals("ru_RU") ? eventEle.attributeValue("rusType") : (config.getLanguage().equals("es_ES") ? eventEle.attributeValue("spType") : (config.getLanguage().equals("uk_UK") ? eventEle.attributeValue("ukrType") : (config.getLanguage().equals("tr_TR") ? eventEle.attributeValue("turType") : (config.getLanguage().equals("zh_TW") ? eventEle.attributeValue("twType") : (config.getLanguage().equals("ja_JP") ? eventEle.attributeValue("jpType") : eventEle.attributeValue("enType"))))))))))));
        return name;
    }

    public static String getEventName(Element eventEle) {
        GlobalConfig config = PropertiesUtils.getGlobalConfig();
        String name = null;
        name = config.getLanguage().equals("zh_CN") ? eventEle.attributeValue("name") : (config.getLanguage().equals("fr_FR") ? eventEle.attributeValue("frName") : (config.getLanguage().equals("de_DE") ? eventEle.attributeValue("deName") : (config.getLanguage().equals("it_IT") ? eventEle.attributeValue("itName") : (config.getLanguage().equals("pl_PL") ? eventEle.attributeValue("plName") : (config.getLanguage().equals("pt_PT") ? eventEle.attributeValue("ptName") : (config.getLanguage().equals("ru_RU") ? eventEle.attributeValue("rusName") : (config.getLanguage().equals("es_ES") ? eventEle.attributeValue("spName") : (config.getLanguage().equals("uk_UK") ? eventEle.attributeValue("ukrName") : (config.getLanguage().equals("tr_TR") ? eventEle.attributeValue("turName") : (config.getLanguage().equals("zh_TW") ? eventEle.attributeValue("twName") : (config.getLanguage().equals("ja_JP") ? eventEle.attributeValue("jpName") : eventEle.attributeValue("enName"))))))))))));
        return name;
    }
}

