/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.data.tools;

import cn.com.voltronicpower.data.tools.DBField;
import cn.com.voltronicpower.data.tools.DBIndex;
import java.util.ArrayList;
import java.util.List;

public abstract class DBTable {
    protected String description;
    protected List<DBIndex> indecies;
    protected List<DBField> fields;

    public DBTable() {
        this.indecies = new ArrayList<DBIndex>();
        this.fields = new ArrayList<DBField>();
        this.initFields();
        this.initIndecies();
    }

    public DBTable(ArrayList<DBIndex> indecies, ArrayList<DBField> fields) {
        this.indecies = indecies;
        this.fields = fields;
    }

    public void addDateField(String field) {
        this.fields.add(new DBField(field, 2, 0, 0, true, ""));
    }

    public void addTimeField(String field) {
        this.fields.add(new DBField(field, 7, 0, 0, true, ""));
    }

    public void addProdSerialNo() {
        this.fields.add(new DBField("prodid", 1, 3, 0, false, ""));
        this.fields.add(new DBField("serialno", 1, 20, 0, false, ""));
    }

    public void addIndexProdSerial() {
        this.indecies.add(new DBIndex("serialno"));
    }

    public void addIndex_portname() {
        this.indecies.add(new DBIndex("portname"));
    }

    public void addIndexf_recno() {
        this.indecies.add(new DBIndex("f_recno"));
    }

    public void addfieldf_recno() {
        this.fields.add(new DBField("f_recno", 0, 4, 0, false, ""));
    }

    public void addVoltageField(String field) {
        this.fields.add(new DBField(field, 3, 10, 2, true, ""));
    }

    public void addCurrentField(String field) {
        this.fields.add(new DBField(field, 3, 10, 2, true, ""));
    }

    public void addFrequencyField(String field) {
        this.fields.add(new DBField(field, 3, 8, 2, true, ""));
    }

    public void addPowerField(String field) {
        this.fields.add(new DBField(field, 3, 15, 2, true, ""));
    }

    public void addEnergyField(String field) {
        this.fields.add(new DBField(field, 3, 15, 3, true, ""));
    }

    public void addPercentField(String field) {
        this.fields.add(new DBField(field, 3, 6, 2, true, ""));
    }

    public abstract String getTablename();

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<DBIndex> getIndecies() {
        return this.indecies;
    }

    public void setIndecies(ArrayList<DBIndex> indecies) {
        this.indecies = indecies;
    }

    public abstract void initFields();

    public abstract void initIndecies();

    public List<String> getDefaultDataSqlList() {
        return null;
    }

    public void setFields(List<DBField> fields) {
        this.fields = fields;
    }

    public List<DBField> getFields() {
        return this.fields;
    }

    public String getPrimaryKey() {
        return null;
    }

    public String getIncrease() {
        return null;
    }
}

