/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.data.tools;

import cn.com.voltronicpower.data.tools.DBField;
import cn.com.voltronicpower.data.tools.DBIndex;
import cn.com.voltronicpower.data.tools.DBTable;
import cn.com.voltronicpower.utilities.Log;
import java.util.List;

public class DBDriverTools {
    public static final String MYSQL_SINGLE = "";
    private static final String ENTER = "\r\n";
    private static final Log logger = new Log();

    public static String getCreateTableString(DBTable table) {
        StringBuffer str = new StringBuffer();
        str.append(" CREATE TABLE " + table.getTablename() + "(" + ENTER);
        int item = 0;
        while (item < table.getFields().size()) {
            DBField field = table.getFields().get(item);
            str.append(field.getFieldname()).append(" ").append(DBDriverTools.resultFiledType(field)).append(" ");
            if (field.isAllownull()) {
                str.append("DEFAULT NULL");
            } else {
                str.append("NOT NULL");
            }
            if (field.getFieldname().equalsIgnoreCase(table.getIncrease())) {
                str.append(" generated always as identity (start with 1,increment by 1)");
            }
            if (item != table.getFields().size() - 1) {
                str.append(",");
            } else if (table.getPrimaryKey() != null && !MYSQL_SINGLE.equals(table.getPrimaryKey())) {
                str.append(",");
            }
            str.append(ENTER);
            ++item;
        }
        str.append(" )");
        String res = str.toString();
        return res.replace("  ", " ");
    }

    public static String resultFiledType(DBField field) {
        String str = DBDriverTools.getfieldType(field.getFieldtype());
        if (str.equals("int")) {
            return "int";
        }
        if (str.equals("double")) {
            return "double";
        }
        if (str.equals("timestamp")) {
            return "timestamp";
        }
        if (str.equals("smallint")) {
            return "smallint";
        }
        if (field.getFieldtype() != 2 && field.getFieldtype() != 6) {
            str = String.valueOf(str) + "(" + field.getFieldlength();
            if (field.getFielddecimal() != 0) {
                str = String.valueOf(str) + "," + field.getFielddecimal();
            }
            str = String.valueOf(str) + ")";
        }
        return str;
    }

    public static String getIndexString(List<DBIndex> list) {
        String indexStr = MYSQL_SINGLE;
        int item = 0;
        while (item < list.size()) {
            indexStr = String.valueOf(indexStr) + list.get(item).getColumn();
            if (item != list.size() - 1) {
                indexStr = String.valueOf(indexStr) + ",";
            }
            ++item;
        }
        return indexStr;
    }

    public static String getfieldType(int value) {
        String result = MYSQL_SINGLE;
        if (value == 0) {
            result = "int";
        } else if (value == 1) {
            result = "varchar";
        } else if (value == 2) {
            result = "date";
        } else if (value == 3) {
            result = "double";
        } else if (value == 4) {
            result = "double";
        } else if (value == 5) {
            result = "bit";
        } else if (value == 6) {
            result = "mediumblob";
        } else if (value == 7) {
            result = "timestamp";
        } else if (value == 8) {
            result = "smallint";
        }
        return result;
    }
}

