/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.data.dao;

import cn.com.voltronicpower.data.bean.UPSModuleInfo;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.data.dao.BaseDao;
import cn.com.voltronicpower.data.tools.DBManager;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class WorkDataDao
extends BaseDao {
    private static final Log logger = new Log();
    private static final String INSERT_SQL = "INSERT INTO WORK_DATA(WORK_MODE,INPUT_VOLTAGE,INPUT_FREQUENCY,OUTPUT_VOLTAGE,OUTPUT_FREQUENCY,OUTPUT_CURRENT,OUTPUT_LOAD_PERCENT,BATTERY_VOLTAGE,POSITIVE_BATTERY_VOLTAGE, POSITIVE_BATTERY_CURRENT, NEGATIVE_BATTERY_VOLTAGE, NEGATIVE_BATTERY_CURRENT, BATTERY_CAPACITY,TEMPERATURE,IO_PHASE,RECORD_TIME,PORT_NAME,PTID,DEVICEID,BATTERY_CHARGECURRENT,BATTERY_DISCHARGECURRENT,SOLARINPUT_VOLTAGE,SOLARINPUT_POWER) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_INPUT = "insert into WORK_DATA_INPUT(WORK_ID,INPUT_VOLTAGE_S,INPUT_VOLTAGE_T,INPUT_VOLTAGEL1L2,INPUT_VOLTAGEL1L3,INPUT_VOLTAGEL2L3,INPUT_CURRENT_R,INPUT_CURRENT_S,INPUT_CURRENT_T) values(?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_OUTPUT = "insert into WORK_DATA_OUTPUT(WORK_ID,OUTPUT_VOLTAGE_S,OUTPUT_VOLTAGE_T,OUTPUT_CURRENT_S,OUTPUT_CURRENT_T,OUTPUT_VOLTAGEL1L2,OUTPUT_VOLTAGEL1L3,OUTPUT_VOLTAGEL2L3,LOAD_LEVEL_R,LOAD_LEVEL_S,LOAD_LEVEL_T) values(?,?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_BYPASS = "insert into WORK_DATA_BYPASS(WORK_ID,BYPASS_VOLTAGE_R,BYPASS_VOLTAGE_S,BYPASS_VOLTAGE_T,BYPASS_FREQUENCY,BYPASS_CURRENT_R,BYPASS_CURRENT_S,BYPASS_CURRENT_T,BYPASS_VOLTAGEL1L2,BYPASS_VOLTAGEL2L3,BYPASS_VOLTAGEL1L3) values(?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SELECT_BASE = "SELECT t1.*,t2.*,t3.*,t4.* FROM WORK_DATA t1 left join WORK_DATA_INPUT t2 on t1.work_id = t2.work_id left join WORK_DATA_OUTPUT t3 on t1.work_id = t3.work_id left join WORK_DATA_BYPASS t4 on t1.work_id = t4.work_id ";
    private static final String SELECT_BY_PTID = "SELECT t1.*,t2.*,t3.*,t4.* FROM WORK_DATA t1 left join WORK_DATA_INPUT t2 on t1.work_id = t2.work_id left join WORK_DATA_OUTPUT t3 on t1.work_id = t3.work_id left join WORK_DATA_BYPASS t4 on t1.work_id = t4.work_id  WHERE t1.RECORD_TIME BETWEEN ? AND ? AND t1.PORT_NAME=? AND t1.PTID=? ORDER BY t1.RECORD_TIME DESC";
    private static final String REMOVE = "DELETE FROM WORK_DATA WHERE WORK_ID=?";
    private static final String REMOVEBase = "delete FROM WORK_DATA";
    private static final String REMOVEAll = "delete FROM WORK_DATA WHERE record_time BETWEEN ? AND ? AND (PORT_NAME=? OR PORT_NAME='host') AND PTID=?";
    private static final String REMOVEAllSN = "delete FROM WORK_DATA WHERE record_time BETWEEN ? AND ? AND (PORT_NAME=? OR PORT_NAME='host') AND PTID=? and deviceid=?";
    private static final String QUERY_PORTS = "SELECT DISTINCT PORT_NAME FROM WORK_DATA";
    private static final String QUERY_PTIDS_BY_COM = "SELECT DISTINCT PTID FROM WORK_DATA WHERE PORT_NAME=? ";
    private static final String QUERY_YEAR = "SELECT t1.*,t2.*,t3.*,t4.* FROM WORK_DATA t1 left join WORK_DATA_INPUT t2 on t1.work_id = t2.work_id left join WORK_DATA_OUTPUT t3 on t1.work_id = t3.work_id left join WORK_DATA_BYPASS t4 on t1.work_id = t4.work_id  WHERE YEAR(t1.RECORD_TIME)=? AND t1.PORT_NAME=? AND t1.PTID=? ORDER BY t1.RECORD_TIME ASC";
    private static final String QUERY_MONTH = "SELECT t1.*,t2.*,t3.*,t4.* FROM WORK_DATA t1 left join WORK_DATA_INPUT t2 on t1.work_id = t2.work_id left join WORK_DATA_OUTPUT t3 on t1.work_id = t3.work_id left join WORK_DATA_BYPASS t4 on t1.work_id = t4.work_id  WHERE YEAR(t1.RECORD_TIME)=? AND MONTH(t1.RECORD_TIME)=? AND t1.PORT_NAME=? AND t1.PTID=? ORDER BY t1.RECORD_TIME ASC";
    private static final String QUERY_DAY = "SELECT t1.*,t2.*,t3.*,t4.* FROM WORK_DATA t1 left join WORK_DATA_INPUT t2 on t1.work_id = t2.work_id left join WORK_DATA_OUTPUT t3 on t1.work_id = t3.work_id left join WORK_DATA_BYPASS t4 on t1.work_id = t4.work_id  WHERE YEAR(t1.RECORD_TIME)=? AND MONTH(t1.RECORD_TIME)=? AND DAY(t1.RECORD_TIME)=? AND t1.PORT_NAME=? AND t1.PTID=? ORDER BY t1.RECORD_TIME ASC";
    private static final String QUERY_HOUR = "SELECT t1.*,t2.*,t3.*,t4.* FROM WORK_DATA t1 left join WORK_DATA_INPUT t2 on t1.work_id = t2.work_id left join WORK_DATA_OUTPUT t3 on t1.work_id = t3.work_id left join WORK_DATA_BYPASS t4 on t1.work_id = t4.work_id  WHERE YEAR(t1.RECORD_TIME)=? AND MONTH(t1.RECORD_TIME)=? AND DAY(t1.RECORD_TIME)=? AND HOUR(t1.RECORD_TIME)=? AND t1.PORT_NAME=? AND t1.PTID=? ORDER BY t1.RECORD_TIME ASC";
    private static final String QUERY_SN_BY_PTIDS = " select distinct deviceid from work_data where port_name=? and ptid=? order by deviceid";
    private static final String SELECT_BY_PTID_SN = "SELECT t1.*,t2.*,t3.*,t4.* FROM WORK_DATA t1 left join WORK_DATA_INPUT t2 on t1.work_id = t2.work_id left join WORK_DATA_OUTPUT t3 on t1.work_id = t3.work_id left join WORK_DATA_BYPASS t4 on t1.work_id = t4.work_id  WHERE t1.RECORD_TIME BETWEEN ? AND ? AND t1.PORT_NAME=? AND t1.PTID=? and t1.deviceid=? ORDER BY t1.RECORD_TIME DESC";
    private static final String QUERY_YEAR_SN = "SELECT t1.*,t2.*,t3.*,t4.* FROM WORK_DATA t1 left join WORK_DATA_INPUT t2 on t1.work_id = t2.work_id left join WORK_DATA_OUTPUT t3 on t1.work_id = t3.work_id left join WORK_DATA_BYPASS t4 on t1.work_id = t4.work_id  WHERE YEAR(t1.RECORD_TIME)=? AND t1.PORT_NAME=? AND t1.PTID=? and t1.deviceid=? ORDER BY t1.RECORD_TIME ASC";
    private static final String QUERY_MONTH_SN = "SELECT t1.*,t2.*,t3.*,t4.* FROM WORK_DATA t1 left join WORK_DATA_INPUT t2 on t1.work_id = t2.work_id left join WORK_DATA_OUTPUT t3 on t1.work_id = t3.work_id left join WORK_DATA_BYPASS t4 on t1.work_id = t4.work_id  WHERE YEAR(t1.RECORD_TIME)=? AND MONTH(t1.RECORD_TIME)=? AND t1.PORT_NAME=? AND t1.PTID=? and t1.deviceid=? ORDER BY t1.RECORD_TIME ASC";
    private static final String QUERY_DAY_SN = "SELECT t1.*,t2.*,t3.*,t4.* FROM WORK_DATA t1 left join WORK_DATA_INPUT t2 on t1.work_id = t2.work_id left join WORK_DATA_OUTPUT t3 on t1.work_id = t3.work_id left join WORK_DATA_BYPASS t4 on t1.work_id = t4.work_id  WHERE YEAR(t1.RECORD_TIME)=? AND MONTH(t1.RECORD_TIME)=? AND DAY(t1.RECORD_TIME)=? AND t1.PORT_NAME=? AND t1.PTID=? and t1.deviceid =? ORDER BY t1.RECORD_TIME ASC";
    private static final String QUERY_HOUR_SN = "SELECT t1.*,t2.*,t3.*,t4.* FROM WORK_DATA t1 left join WORK_DATA_INPUT t2 on t1.work_id = t2.work_id left join WORK_DATA_OUTPUT t3 on t1.work_id = t3.work_id left join WORK_DATA_BYPASS t4 on t1.work_id = t4.work_id  WHERE YEAR(t1.RECORD_TIME)=? AND MONTH(t1.RECORD_TIME)=? AND DAY(t1.RECORD_TIME)=? AND HOUR(t1.RECORD_TIME)=? AND t1.PORT_NAME=? AND t1.PTID=? and t1.deviceid=?  ORDER BY t1.RECORD_TIME ASC";
    private static final String QUERY_BY_PTID_AND_PORTNAME = "SELECT IO_PHASE FROM WORK_DATA WHERE PTID=? AND PORT_NAME=? ORDER BY RECORD_TIME DESC";
    private static final String MAX_WORK = "SELECT MAX(WORK_ID) FROM WORK_DATA";
    private static final String LIMIT_WORK = "DELETE FROM WORK_DATA WHERE WORK_ID<?";
    private boolean _next = false;

    public void addWorkData(WorkInfo work, String portName) {
        this.insertBase(work, portName);
        int workId = this.getCurrentWorkId();
        if (workId > 0) {
            if (work.isInsertInput()) {
                this.insertInput(work, workId);
            }
            if (work.isInsertOutput()) {
                this.insertOutput(work, workId);
            }
            if (work.isInsertBypass()) {
                this.insertBypass(work, workId);
            }
        }
        if (work.getPtid().equalsIgnoreCase("P33") || work.getPtid().equalsIgnoreCase("P44") || work.getPtid().equalsIgnoreCase("P39")) {
            try {
                for (UPSModuleInfo info : work.getModulesInfo()) {
                    WorkInfo module = this.convertModuletoWorkInfo(work, info);
                    this.insertBase(module, portName);
                    workId = this.getCurrentWorkId();
                    if (workId <= 0) continue;
                    this.insertInput(module, workId);
                    this.insertOutput(module, workId);
                    this.insertBypass(module, workId);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                logger.error(e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
    }

    public String getIO(String ptid, String portname) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        String io = "";
        try {
            ps = conn.prepareStatement(QUERY_BY_PTID_AND_PORTNAME);
            ps.setString(1, ptid);
            ps.setString(2, portname);
            rs = ps.executeQuery();
            if (rs.next()) {
                io = rs.getString("IO_PHASE");
            }
            return io;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private WorkInfo convertModuletoWorkInfo(WorkInfo parent, UPSModuleInfo info) {
        WorkInfo work = parent.cloneAll();
        work.setDeviceId(info.getModuleSN());
        work.setInputVoltage(info.getInputVoltage());
        work.setInputVoltageS(info.getInputVoltageS());
        work.setInputVoltageT(info.getInputVoltageT());
        work.setInputFrequency(info.getInputFrequency());
        work.setBypassVoltage(info.getBypassVoltage());
        work.setBypassVoltageS(info.getBypassVoltageS());
        work.setBypassVoltageT(info.getBypassVoltageT());
        work.setOutputFrequency(info.getBypassFrequency());
        work.setWorkMode(info.getWorkMode());
        work.setTemperatureView(info.getTemperatureView());
        work.setFaultType(info.getFaultType());
        work.setWarnings(info.getWarnings());
        work.setOutputVoltage(info.getOutputVoltage());
        work.setOutputVoltageS(info.getOutputVoltageS());
        work.setOutputVoltageT(info.getOutputVoltageT());
        work.setOutputCurrent(info.getOutputCurrent());
        work.setOutputCurrentS(info.getOutputCurrentS());
        work.setOutputCurrentT(info.getOutputCurrentT());
        work.setOutputFrequency(info.getOutputFrequency());
        work.setLoadLevel(info.getLoadLevel());
        work.setLoadLevelS(info.getLoadLevelS());
        work.setLoadLevelT(info.getLoadLevelT());
        work.setOutputLoadPercent(info.getOutputLoadPercent());
        return work;
    }

    private void insertBase(WorkInfo work, String portName) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                String ptid = work.getPtid();
                if (ptid != null && !"".equals(ptid)) {
                    ps = conn.prepareStatement(INSERT_SQL);
                    ps.setString(1, work.getWorkMode());
                    double inputVoltage = 0.0;
                    if (!work.getInputVoltage().equals("")) {
                        inputVoltage = Double.parseDouble(work.getInputVoltage());
                    }
                    ps.setString(2, inputVoltage > 9.0 ? work.getInputVoltage() : String.valueOf("0"));
                    ps.setString(3, work.getInputFrequency());
                    ps.setString(4, work.getOutputVoltage());
                    ps.setString(5, work.getOutputFrequency());
                    ps.setString(6, work.getOutputCurrent());
                    ps.setString(7, work.getOutputLoadPercent());
                    ps.setString(8, work.getBatteryVoltage());
                    ps.setString(9, work.getPositiveBatteryVoltage());
                    ps.setString(10, work.getPositiveBatteryCurrent());
                    ps.setString(11, work.getNegativeBatteryVoltage());
                    ps.setString(12, work.getNegativeBatteryCurrent());
                    ps.setString(13, String.valueOf(work.getBatteryCapacity()));
                    ps.setString(14, work.getTemperature());
                    ps.setString(15, work.getIoPhase());
                    ps.setTimestamp(16, new Timestamp(work.getCurrentTime().getTime()));
                    ps.setString(17, portName);
                    ps.setString(18, work.getPtid());
                    ps.setString(19, work.getDeviceId());
                    ps.setString(20, work.getChargeCurr());
                    ps.setString(21, work.getDischargeCurr());
                    ps.setString(22, work.getInputVoltagePV());
                    ps.setString(23, work.getInputPowerPV());
                    ps.executeUpdate();
                    conn.commit();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
    }

    private void insertInput(WorkInfo work, int workId) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(INSERT_INPUT);
                ps.setInt(1, workId);
                ps.setString(2, work.getInputVoltageS());
                ps.setString(3, work.getInputVoltageT());
                ps.setString(4, work.getInputVoltageL1L2());
                ps.setString(5, work.getInputVoltageL1L3());
                ps.setString(6, work.getInputVoltageL2L3());
                ps.setString(7, work.getInputCurrentR());
                ps.setString(8, work.getInputCurrentS());
                ps.setString(9, work.getInputCurrentT());
                ps.executeUpdate();
                conn.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
    }

    private void insertOutput(WorkInfo work, int workId) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(INSERT_OUTPUT);
                ps.setInt(1, workId);
                ps.setString(2, work.getOutputVoltageS());
                ps.setString(3, work.getOutputVoltageT());
                ps.setString(4, work.getOutputCurrentS());
                ps.setString(5, work.getOutputCurrentT());
                ps.setString(6, work.getOutputVoltageL1L2());
                ps.setString(7, work.getOutputVoltageL1L3());
                ps.setString(8, work.getOutputVoltageL2L3());
                ps.setString(9, work.getLoadLevel());
                ps.setString(10, work.getLoadLevelS());
                ps.setString(11, work.getLoadLevelT());
                ps.executeUpdate();
                conn.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
    }

    private void insertBypass(WorkInfo work, int workId) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(INSERT_BYPASS);
                ps.setInt(1, workId);
                ps.setString(2, work.getBypassVoltage());
                ps.setString(3, work.getBypassVoltageS());
                ps.setString(4, work.getBypassVoltageT());
                ps.setString(5, work.getBypassFrequency());
                ps.setString(6, work.getBypassCurrent());
                ps.setString(7, work.getBypassCurrentS());
                ps.setString(8, work.getBypassCurrentT());
                ps.setString(9, work.getBypassVoltageL1L2());
                ps.setString(10, work.getBypassVoltageL2L3());
                ps.setString(11, work.getBypassVoltageL1L3());
                ps.executeUpdate();
                conn.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
    }

    public void removeWork(int workId) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(REMOVE);
                ps.setInt(1, workId);
                ps.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
    }

    public void removeWorkDataAll(Date startDate, Date endDate, String port, String ptid, String sn) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        String sql = REMOVEAll;
        if (sn != null) {
            sql = REMOVEAllSN;
        }
        System.out.println("----------delAlldata----2---:" + startDate + "," + endDate + "," + port + "," + ptid);
        try {
            try {
                ps = conn.prepareStatement(sql);
                ps.setDate(1, new java.sql.Date(startDate.getTime()));
                ps.setDate(2, new java.sql.Date(endDate.getTime()));
                ps.setString(3, port);
                ps.setString(4, ptid);
                if (sn != null) {
                    ps.setString(5, sn);
                }
                ps.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
    }

    public ArrayList<WorkInfo> getWorkDatasByPtid(Date startDate, Date endDate, String portName, String ptid) {
        ArrayList<WorkInfo> works;
        block6: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            works = new ArrayList<WorkInfo>();
            try {
                try {
                    ps = conn.prepareStatement(SELECT_BY_PTID);
                    ps.setDate(1, new java.sql.Date(startDate.getTime()));
                    ps.setDate(2, new java.sql.Date(endDate.getTime()));
                    ps.setString(3, portName);
                    ps.setString(4, ptid);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        WorkInfo work = new WorkInfo();
                        work = this.getWorkInDB(work, rs);
                        works.add(work);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return works;
    }

    public ArrayList<WorkInfo> getWorkDatasByPtid_SN(Date startDate, Date endDate, String portName, String ptid, String sn) {
        ArrayList<WorkInfo> works;
        block6: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            works = new ArrayList<WorkInfo>();
            try {
                try {
                    ps = conn.prepareStatement(SELECT_BY_PTID_SN);
                    ps.setDate(1, new java.sql.Date(startDate.getTime()));
                    ps.setDate(2, new java.sql.Date(endDate.getTime()));
                    ps.setString(3, portName);
                    ps.setString(4, ptid);
                    ps.setString(5, sn);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        WorkInfo work = new WorkInfo();
                        work = this.getWorkInDB(work, rs);
                        works.add(work);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return works;
    }

    public ArrayList<String> getLogPorts() {
        ArrayList<String> ports;
        block6: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            ports = new ArrayList<String>();
            try {
                try {
                    ps = conn.prepareStatement(QUERY_PORTS);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        ports.add(rs.getString(1));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return ports;
    }

    public ArrayList<String> getLogPtidsByCom(String com) {
        ArrayList<String> ptids;
        block6: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            ptids = new ArrayList<String>();
            try {
                try {
                    ps = conn.prepareStatement(QUERY_PTIDS_BY_COM);
                    ps.setString(1, com);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        ptids.add(rs.getString(1));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return ptids;
    }

    public ArrayList<String> getLogSNByPtid(String com, String ptid) {
        ArrayList<String> ptids;
        block6: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            ptids = new ArrayList<String>();
            try {
                try {
                    ps = conn.prepareStatement(QUERY_SN_BY_PTIDS);
                    ps.setString(1, com);
                    ps.setString(2, ptid);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        ptids.add(rs.getString(1));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return ptids;
    }

    private boolean rsnext(ResultSet rs, boolean next) throws SQLException {
        if (next) {
            this._next = rs.next();
            return this._next;
        }
        return this._next;
    }

    /*
     * Unable to fully structure code
     */
    public ArrayList<WorkInfo> getWorkDatasByYear(int year, String portName, String ptid) {
        block9: {
            conn = DBManager.getConnection();
            ps = null;
            rs = null;
            ca = Calendar.getInstance();
            ca.set(year, 0, 1, 0, 0, 0);
            works = new ArrayList<WorkInfo>();
            try {
                try {
                    ps = conn.prepareStatement("SELECT t1.*,t2.*,t3.*,t4.* FROM WORK_DATA t1 left join WORK_DATA_INPUT t2 on t1.work_id = t2.work_id left join WORK_DATA_OUTPUT t3 on t1.work_id = t3.work_id left join WORK_DATA_BYPASS t4 on t1.work_id = t4.work_id  WHERE YEAR(t1.RECORD_TIME)=? AND t1.PORT_NAME=? AND t1.PTID=? ORDER BY t1.RECORD_TIME ASC");
                    ps.setInt(1, year);
                    ps.setString(2, portName);
                    ps.setString(3, ptid);
                    rs = ps.executeQuery();
                    this.rsnext(rs, true);
                    while (this.rsnext(rs, false)) {
                        recordTime = rs.getTimestamp("RECORD_TIME");
                        recordMillis = recordTime.getTime();
                        if (recordMillis >= ca.getTimeInMillis()) ** GOTO lbl26
                        continue;
lbl-1000:
                        // 1 sources

                        {
                            work = new WorkInfo();
                            work.setCurrentTime(ca.getTime());
                            works.add(work);
                            ca.add(6, 3);
lbl26:
                            // 2 sources

                            ** while (recordMillis > ca.getTimeInMillis() + 259200000L)
                        }
lbl27:
                        // 1 sources

                        work = new WorkInfo();
                        work = this.getWorkInDB(work, rs);
                        while (this.rsnext(rs, true) && recordTime.getTime() < ca.getTimeInMillis() + 259200000L) {
                            work = this.compare(rs, work);
                            recordTime = rs.getTimestamp("RECORD_TIME");
                        }
                        works.add(work);
                        ca.add(6, 3);
                    }
                    while (ca.get(1) == year) {
                        work = new WorkInfo();
                        work.setCurrentTime(ca.getTime());
                        works.add(work);
                        ca.add(6, 3);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block9;
                }
            }
            catch (Throwable var13_13) {
                this.close(rs, ps);
                throw var13_13;
            }
            this.close(rs, ps);
        }
        return works;
    }

    /*
     * Unable to fully structure code
     */
    public ArrayList<WorkInfo> getWorkDatasByYear_SN(int year, String portName, String ptid, String sn) {
        block9: {
            conn = DBManager.getConnection();
            ps = null;
            rs = null;
            ca = Calendar.getInstance();
            ca.set(year, 0, 1, 0, 0, 0);
            works = new ArrayList<WorkInfo>();
            try {
                try {
                    ps = conn.prepareStatement("SELECT t1.*,t2.*,t3.*,t4.* FROM WORK_DATA t1 left join WORK_DATA_INPUT t2 on t1.work_id = t2.work_id left join WORK_DATA_OUTPUT t3 on t1.work_id = t3.work_id left join WORK_DATA_BYPASS t4 on t1.work_id = t4.work_id  WHERE YEAR(t1.RECORD_TIME)=? AND t1.PORT_NAME=? AND t1.PTID=? and t1.deviceid=? ORDER BY t1.RECORD_TIME ASC");
                    ps.setInt(1, year);
                    ps.setString(2, portName);
                    ps.setString(3, ptid);
                    ps.setString(4, sn);
                    rs = ps.executeQuery();
                    this.rsnext(rs, true);
                    while (this.rsnext(rs, false)) {
                        recordTime = rs.getTimestamp("RECORD_TIME");
                        recordMillis = recordTime.getTime();
                        if (recordMillis >= ca.getTimeInMillis()) ** GOTO lbl27
                        continue;
lbl-1000:
                        // 1 sources

                        {
                            work = new WorkInfo();
                            work.setCurrentTime(ca.getTime());
                            works.add(work);
                            ca.add(6, 3);
lbl27:
                            // 2 sources

                            ** while (recordMillis > ca.getTimeInMillis() + 259200000L)
                        }
lbl28:
                        // 1 sources

                        work = new WorkInfo();
                        work = this.getWorkInDB(work, rs);
                        while (this.rsnext(rs, true) && recordTime.getTime() < ca.getTimeInMillis() + 259200000L) {
                            work = this.compare(rs, work);
                            recordTime = rs.getTimestamp("RECORD_TIME");
                        }
                        works.add(work);
                        ca.add(6, 3);
                    }
                    while (ca.get(1) == year) {
                        work = new WorkInfo();
                        work.setCurrentTime(ca.getTime());
                        works.add(work);
                        ca.add(6, 3);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block9;
                }
            }
            catch (Throwable var14_14) {
                this.close(rs, ps);
                throw var14_14;
            }
            this.close(rs, ps);
        }
        return works;
    }

    private WorkInfo compare(ResultSet rs, WorkInfo work) throws SQLException {
        try {
            if (Double.parseDouble(rs.getString("INPUT_VOLTAGE")) > Double.parseDouble(work.getInputVoltage())) {
                work = this.getWorkInDB(work, rs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Double.parseDouble(rs.getString("INPUT_FREQUENCY")) > Double.parseDouble(work.getInputFrequency())) {
                work = this.getWorkInDB(work, rs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Double.parseDouble(rs.getString("OUTPUT_VOLTAGE")) > Double.parseDouble(work.getOutputVoltage())) {
                work = this.getWorkInDB(work, rs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Double.parseDouble(rs.getString("OUTPUT_FREQUENCY")) > Double.parseDouble(work.getOutputFrequency())) {
                work = this.getWorkInDB(work, rs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Double.parseDouble(rs.getString("OUTPUT_CURRENT")) > Double.parseDouble(work.getOutputCurrent())) {
                work = this.getWorkInDB(work, rs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Double.parseDouble(rs.getString("OUTPUT_LOAD_PERCENT")) > Double.parseDouble(work.getOutputLoadPercent())) {
                work = this.getWorkInDB(work, rs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Double.parseDouble(String.valueOf(rs.getString("BATTERY_CAPACITY"))) > Double.parseDouble(String.valueOf(work.getBatteryCapacity()))) {
                work = this.getWorkInDB(work, rs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string = rs.getString("TEMPERATURE").equals("---.-") ? "999" : rs.getString("TEMPERATURE");
            if (Double.parseDouble(String.valueOf(string)) > Double.parseDouble(String.valueOf(work.getTemperature()))) {
                work = this.getWorkInDB(work, rs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return work;
    }

    public ArrayList<WorkInfo> getWorkDatasByMonth(int year, int month, String portName, String ptid) {
        ArrayList<WorkInfo> works;
        block9: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            Calendar ca = Calendar.getInstance();
            ca.set(year, month - 1, 1, 0, 0, 0);
            works = new ArrayList<WorkInfo>();
            try {
                try {
                    ps = conn.prepareStatement(QUERY_MONTH);
                    ps.setInt(1, year);
                    ps.setInt(2, month);
                    ps.setString(3, portName);
                    ps.setString(4, ptid);
                    rs = ps.executeQuery();
                    this.rsnext(rs, true);
                    while (this.rsnext(rs, false)) {
                        WorkInfo work;
                        Timestamp recordTime = rs.getTimestamp("RECORD_TIME");
                        long recordMillis = ((Date)recordTime).getTime();
                        while (recordMillis > ca.getTimeInMillis() + 21600000L) {
                            work = new WorkInfo();
                            work.setCurrentTime(ca.getTime());
                            works.add(work);
                            ca.add(11, 6);
                        }
                        if (recordMillis < ca.getTimeInMillis()) continue;
                        work = new WorkInfo();
                        work = this.getWorkInDB(work, rs);
                        while (this.rsnext(rs, true) && ((Date)recordTime).getTime() < ca.getTimeInMillis() + 21600000L) {
                            work = this.compare(rs, work);
                            recordTime = rs.getTimestamp("RECORD_TIME");
                        }
                        works.add(work);
                        ca.add(11, 6);
                    }
                    while (ca.get(2) == month - 1) {
                        WorkInfo work = new WorkInfo();
                        work.setCurrentTime(ca.getTime());
                        works.add(work);
                        ca.add(11, 6);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return works;
    }

    public ArrayList<WorkInfo> getWorkDatasByMonth_SN(int year, int month, String portName, String ptid, String sn) {
        ArrayList<WorkInfo> works;
        block9: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            Calendar ca = Calendar.getInstance();
            ca.set(year, month - 1, 1, 0, 0, 0);
            works = new ArrayList<WorkInfo>();
            try {
                try {
                    ps = conn.prepareStatement(QUERY_MONTH_SN);
                    ps.setInt(1, year);
                    ps.setInt(2, month);
                    ps.setString(3, portName);
                    ps.setString(4, ptid);
                    ps.setString(5, sn);
                    rs = ps.executeQuery();
                    this.rsnext(rs, true);
                    while (this.rsnext(rs, false)) {
                        WorkInfo work;
                        Timestamp recordTime = rs.getTimestamp("RECORD_TIME");
                        long recordMillis = ((Date)recordTime).getTime();
                        while (recordMillis > ca.getTimeInMillis() + 21600000L) {
                            work = new WorkInfo();
                            work.setCurrentTime(ca.getTime());
                            works.add(work);
                            ca.add(11, 6);
                        }
                        if (recordMillis < ca.getTimeInMillis()) continue;
                        work = new WorkInfo();
                        work = this.getWorkInDB(work, rs);
                        while (this.rsnext(rs, true) && ((Date)recordTime).getTime() < ca.getTimeInMillis() + 21600000L) {
                            work = this.compare(rs, work);
                            recordTime = rs.getTimestamp("RECORD_TIME");
                        }
                        works.add(work);
                        ca.add(11, 6);
                    }
                    while (ca.get(2) == month - 1) {
                        WorkInfo work = new WorkInfo();
                        work.setCurrentTime(ca.getTime());
                        works.add(work);
                        ca.add(11, 6);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return works;
    }

    public ArrayList<WorkInfo> getWorkDatasByDay(Date queryDate, String portName, String ptid) {
        ArrayList<WorkInfo> works;
        block8: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            Calendar ca = Calendar.getInstance();
            ca.setTime(queryDate);
            works = new ArrayList<WorkInfo>();
            try {
                try {
                    int year = ca.get(1);
                    int month = ca.get(2) + 1;
                    int day = ca.get(5);
                    ps = conn.prepareStatement(QUERY_DAY);
                    ps.setInt(1, year);
                    ps.setInt(2, month);
                    ps.setInt(3, day);
                    ps.setString(4, portName);
                    ps.setString(5, ptid);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        WorkInfo work;
                        Timestamp recordTime = rs.getTimestamp("RECORD_TIME");
                        long recordMillis = ((Date)recordTime).getTime();
                        while (recordMillis > ca.getTimeInMillis() + 900000L) {
                            work = new WorkInfo();
                            work.setCurrentTime(ca.getTime());
                            works.add(work);
                            ca.add(12, 15);
                        }
                        if (recordMillis < ca.getTimeInMillis()) continue;
                        work = new WorkInfo();
                        work = this.getWorkInDB(work, rs);
                        works.add(work);
                        ca.add(12, 15);
                    }
                    while (ca.get(5) == day) {
                        WorkInfo work = new WorkInfo();
                        work.setCurrentTime(ca.getTime());
                        works.add(work);
                        ca.add(12, 15);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return works;
    }

    public ArrayList<WorkInfo> getWorkDatasByDay_SN(Date queryDate, String portName, String ptid, String sn) {
        ArrayList<WorkInfo> works;
        block8: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            Calendar ca = Calendar.getInstance();
            ca.setTime(queryDate);
            works = new ArrayList<WorkInfo>();
            try {
                try {
                    int year = ca.get(1);
                    int month = ca.get(2) + 1;
                    int day = ca.get(5);
                    ps = conn.prepareStatement(QUERY_DAY_SN);
                    ps.setInt(1, year);
                    ps.setInt(2, month);
                    ps.setInt(3, day);
                    ps.setString(4, portName);
                    ps.setString(5, ptid);
                    ps.setString(6, sn);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        WorkInfo work;
                        Timestamp recordTime = rs.getTimestamp("RECORD_TIME");
                        long recordMillis = ((Date)recordTime).getTime();
                        while (recordMillis > ca.getTimeInMillis() + 900000L) {
                            work = new WorkInfo();
                            work.setCurrentTime(ca.getTime());
                            works.add(work);
                            ca.add(12, 15);
                        }
                        if (recordMillis < ca.getTimeInMillis()) continue;
                        work = new WorkInfo();
                        work = this.getWorkInDB(work, rs);
                        works.add(work);
                        ca.add(12, 15);
                    }
                    while (ca.get(5) == day) {
                        WorkInfo work = new WorkInfo();
                        work.setCurrentTime(ca.getTime());
                        works.add(work);
                        ca.add(12, 15);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return works;
    }

    /*
     * Unable to fully structure code
     */
    public ArrayList<WorkInfo> getWorkDatasByHour(Date queryDate, int hour, String portName, String ptid) {
        block10: {
            conn = DBManager.getConnection();
            ps = null;
            rs = null;
            ca = Calendar.getInstance();
            ca.setTime(queryDate);
            ca.set(11, hour);
            works = new ArrayList<WorkInfo>();
            try {
                try {
                    year = ca.get(1);
                    month = ca.get(2) + 1;
                    day = ca.get(5);
                    ps = conn.prepareStatement("SELECT t1.*,t2.*,t3.*,t4.* FROM WORK_DATA t1 left join WORK_DATA_INPUT t2 on t1.work_id = t2.work_id left join WORK_DATA_OUTPUT t3 on t1.work_id = t3.work_id left join WORK_DATA_BYPASS t4 on t1.work_id = t4.work_id  WHERE YEAR(t1.RECORD_TIME)=? AND MONTH(t1.RECORD_TIME)=? AND DAY(t1.RECORD_TIME)=? AND HOUR(t1.RECORD_TIME)=? AND t1.PORT_NAME=? AND t1.PTID=? ORDER BY t1.RECORD_TIME ASC", 1004, 1007);
                    ps.setInt(1, year);
                    ps.setInt(2, month);
                    ps.setInt(3, day);
                    ps.setInt(4, hour);
                    ps.setString(5, portName);
                    ps.setString(6, ptid);
                    rs = ps.executeQuery();
                    temp = null;
                    target = 60;
                    while (rs.next()) {
                        time = rs.getTimestamp("RECORD_TIME").getTime();
                        if (temp != null && (temptarget = (int)(time - temp) / 1000) < target && temptarget % 30 == 0) {
                            target = temptarget;
                        }
                        temp = time;
                    }
                    rs.beforeFirst();
                    while (rs.next()) {
                        recordTime = rs.getTimestamp("RECORD_TIME");
                        recordMillis = recordTime.getTime();
                        if (recordMillis >= ca.getTimeInMillis()) ** GOTO lbl40
                        continue;
lbl-1000:
                        // 1 sources

                        {
                            work = new WorkInfo();
                            work.setCurrentTime(ca.getTime());
                            works.add(work);
                            ca.add(13, target);
lbl40:
                            // 2 sources

                            ** while (recordMillis > ca.getTimeInMillis() + 60000L)
                        }
lbl41:
                        // 1 sources

                        work = new WorkInfo();
                        work = this.getWorkInDB(work, rs);
                        works.add(work);
                        ca.add(13, target);
                    }
                    while (ca.get(11) == hour) {
                        work = new WorkInfo();
                        work.setCurrentTime(ca.getTime());
                        works.add(work);
                        ca.add(13, target);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block10;
                }
            }
            catch (Throwable var19_20) {
                this.close(rs, ps);
                throw var19_20;
            }
            this.close(rs, ps);
        }
        return works;
    }

    /*
     * Unable to fully structure code
     */
    public ArrayList<WorkInfo> getWorkDatasByHour_SN(Date queryDate, int hour, String portName, String ptid, String sn) {
        block10: {
            conn = DBManager.getConnection();
            ps = null;
            rs = null;
            ca = Calendar.getInstance();
            ca.setTime(queryDate);
            ca.set(11, hour);
            works = new ArrayList<WorkInfo>();
            try {
                try {
                    year = ca.get(1);
                    month = ca.get(2) + 1;
                    day = ca.get(5);
                    ps = conn.prepareStatement("SELECT t1.*,t2.*,t3.*,t4.* FROM WORK_DATA t1 left join WORK_DATA_INPUT t2 on t1.work_id = t2.work_id left join WORK_DATA_OUTPUT t3 on t1.work_id = t3.work_id left join WORK_DATA_BYPASS t4 on t1.work_id = t4.work_id  WHERE YEAR(t1.RECORD_TIME)=? AND MONTH(t1.RECORD_TIME)=? AND DAY(t1.RECORD_TIME)=? AND HOUR(t1.RECORD_TIME)=? AND t1.PORT_NAME=? AND t1.PTID=? and t1.deviceid=?  ORDER BY t1.RECORD_TIME ASC", 1004, 1007);
                    ps.setInt(1, year);
                    ps.setInt(2, month);
                    ps.setInt(3, day);
                    ps.setInt(4, hour);
                    ps.setString(5, portName);
                    ps.setString(6, ptid);
                    ps.setString(7, sn);
                    rs = ps.executeQuery();
                    temp = null;
                    target = 60;
                    while (rs.next()) {
                        time = rs.getTimestamp("RECORD_TIME").getTime();
                        if (temp != null && (temptarget = (int)(time - temp) / 1000) < target && temptarget % 30 == 0) {
                            target = temptarget;
                        }
                        temp = time;
                    }
                    rs.beforeFirst();
                    while (rs.next()) {
                        recordTime = rs.getTimestamp("RECORD_TIME");
                        recordMillis = recordTime.getTime();
                        if (recordMillis >= ca.getTimeInMillis()) ** GOTO lbl41
                        continue;
lbl-1000:
                        // 1 sources

                        {
                            work = new WorkInfo();
                            work.setCurrentTime(ca.getTime());
                            works.add(work);
                            ca.add(13, target);
lbl41:
                            // 2 sources

                            ** while (recordMillis > ca.getTimeInMillis() + 60000L)
                        }
lbl42:
                        // 1 sources

                        work = new WorkInfo();
                        work = this.getWorkInDB(work, rs);
                        works.add(work);
                        ca.add(13, target);
                    }
                    while (ca.get(11) == hour) {
                        work = new WorkInfo();
                        work.setCurrentTime(ca.getTime());
                        works.add(work);
                        ca.add(13, target);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block10;
                }
            }
            catch (Throwable var20_21) {
                this.close(rs, ps);
                throw var20_21;
            }
            this.close(rs, ps);
        }
        return works;
    }

    private WorkInfo getWorkInDB(WorkInfo work, ResultSet rs) throws SQLException {
        work.setWorkMode(rs.getString("WORK_MODE"));
        work.setInputVoltage(rs.getString("INPUT_VOLTAGE"));
        work.setInputVoltageS(rs.getString("INPUT_VOLTAGE_S"));
        work.setInputVoltageT(rs.getString("INPUT_VOLTAGE_T"));
        work.setInputFrequency(rs.getString("INPUT_FREQUENCY"));
        work.setInputCurrentR(rs.getString("INPUT_CURRENT_R"));
        work.setInputCurrentS(rs.getString("INPUT_CURRENT_S"));
        work.setInputCurrentT(rs.getString("INPUT_CURRENT_T"));
        work.setInputVoltageL1L2(rs.getString("INPUT_VOLTAGEL1L2"));
        work.setInputVoltageL1L3(rs.getString("INPUT_VOLTAGEL1L3"));
        work.setInputVoltageL2L3(rs.getString("INPUT_VOLTAGEL2L3"));
        work.setOutputVoltage(rs.getString("OUTPUT_VOLTAGE"));
        work.setOutputVoltageS(rs.getString("OUTPUT_VOLTAGE_S"));
        work.setOutputVoltageT(rs.getString("OUTPUT_VOLTAGE_T"));
        work.setOutputFrequency(rs.getString("OUTPUT_FREQUENCY"));
        work.setOutputCurrent(rs.getString("OUTPUT_CURRENT"));
        work.setOutputCurrentS(rs.getString("OUTPUT_CURRENT_S"));
        work.setOutputCurrentT(rs.getString("OUTPUT_CURRENT_T"));
        work.setOutputVoltageL1L2(rs.getString("OUTPUT_VOLTAGEL1L2"));
        work.setOutputVoltageL1L3(rs.getString("OUTPUT_VOLTAGEL1L3"));
        work.setOutputVoltageL2L3(rs.getString("OUTPUT_VOLTAGEL2L3"));
        work.setLoadLevel(rs.getString("LOAD_LEVEL_R"));
        work.setLoadLevelS(rs.getString("LOAD_LEVEL_S"));
        work.setLoadLevelT(rs.getString("LOAD_LEVEL_T"));
        work.setOutputLoadPercent(rs.getString("OUTPUT_LOAD_PERCENT"));
        work.setBypassVoltage(rs.getString("BYPASS_VOLTAGE_R"));
        work.setBypassVoltageS(rs.getString("BYPASS_VOLTAGE_S"));
        work.setBypassVoltageT(rs.getString("BYPASS_VOLTAGE_T"));
        work.setBypassFrequency(rs.getString("BYPASS_FREQUENCY"));
        work.setBypassCurrent(rs.getString("BYPASS_CURRENT_R"));
        work.setBypassCurrentS(rs.getString("BYPASS_CURRENT_S"));
        work.setBypassCurrentT(rs.getString("BYPASS_CURRENT_T"));
        work.setBypassVoltageL1L2(rs.getString("BYPASS_VOLTAGEL1L2"));
        work.setBypassVoltageL2L3(rs.getString("BYPASS_VOLTAGEL2L3"));
        work.setBypassVoltageL1L3(rs.getString("BYPASS_VOLTAGEL1L3"));
        work.setBatteryVoltage(rs.getString("BATTERY_VOLTAGE"));
        work.setPositiveBatteryVoltage(rs.getString("POSITIVE_BATTERY_VOLTAGE"));
        work.setPositiveBatteryCurrent(rs.getString("POSITIVE_BATTERY_CURRENT"));
        work.setNegativeBatteryVoltage(rs.getString("NEGATIVE_BATTERY_VOLTAGE"));
        work.setNegativeBatteryCurrent(rs.getString("NEGATIVE_BATTERY_CURRENT"));
        work.setBatteryCapacity(Integer.parseInt(rs.getString("BATTERY_CAPACITY")));
        work.setChargeCurr(rs.getString("BATTERY_CHARGECURRENT"));
        work.setDischargeCurr(rs.getString("BATTERY_DISCHARGECURRENT"));
        work.setInputVoltagePV(rs.getString("SOLARINPUT_VOLTAGE"));
        work.setInputPowerPV(rs.getString("SOLARINPUT_POWER"));
        work.setTemperature(rs.getString("TEMPERATURE"));
        work.setIoPhase(rs.getString("IO_PHASE"));
        work.setCurrentTime((Date)rs.getTimestamp("RECORD_TIME"));
        work.setWorkId(rs.getInt("WORK_ID"));
        MyConstants.doTemperature(work);
        return work;
    }

    public void limitRecord(int limitNum) {
        block6: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    int maxWorkId;
                    int minWorkId;
                    ps = conn.prepareStatement(MAX_WORK);
                    rs = ps.executeQuery();
                    if (rs.next() && (minWorkId = (maxWorkId = rs.getInt(1)) - limitNum) > 0) {
                        this.close(ps);
                        ps = conn.prepareStatement(LIMIT_WORK);
                        ps.setInt(1, minWorkId);
                        ps.executeUpdate();
                        conn.commit();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
    }

    public int getCurrentWorkId() {
        int returnValue;
        block6: {
            returnValue = 0;
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement(MAX_WORK);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        returnValue = rs.getInt(1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return returnValue;
    }
}

