/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.data.dao;

import cn.com.voltronicpower.data.bean.SSHInfo;
import cn.com.voltronicpower.data.dao.BaseDao;
import cn.com.voltronicpower.data.tools.DBManager;
import cn.com.voltronicpower.utilities.AES128CBC;
import cn.com.voltronicpower.utilities.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SSHInfoDao
extends BaseDao {
    private static final Log logger = new Log();
    private static final String INSERT_SQL = "INSERT INTO SSHINFO(SSHIP, SSHUSER, SSHPASSWORD, ISSSHSHUTDOWN, SSHCOMMAND, SSHPORT) VALUES(?,?,?,?,?,?)";
    private static final String QUERY = "SELECT * FROM SSHINFO WHERE SSHIP = ?";
    private static final String QUERYALL = "SELECT * FROM SSHINFO";
    private static final String DELETEIP = "DELETE FROM SSHINFO WHERE SSHIP=?";
    private static final String CLEARIP = "DELETE FROM SSHINFO";
    private static final String UPDATE = "UPDATE SSHINFO SET SSHIP=?,SSHUSER=?,SSHPASSWORD=?,ISSSHSHUTDOWN=?,SSHCOMMAND=?,SSHPORT=? WHERE SSHIP=?";
    private static final String queryNameandPsd = "SELECT SSHUSER,SSHPASSWORD FROM SSHINFO WHERE SSHIP = ?";
    private static final String queryLan = "select * from lan";
    private static final String addLan = "insert into lan values(?)";
    private static final String delLan = "delete from LAN where lan=?";
    private static final String exsitLan = "select * from lan where lan=?";

    public List<String> queryLan() {
        ArrayList<String> li;
        block6: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            li = new ArrayList<String>();
            try {
                try {
                    ps = conn.prepareStatement(queryLan);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        String lan = rs.getString("lan");
                        li.add(lan);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return li;
    }

    public boolean addLan(String lan) {
        boolean result = false;
        System.out.println("lan:" + lan);
        if (this.exsitLan(lan)) {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            int res = 0;
            try {
                try {
                    ps = conn.prepareStatement(addLan);
                    ps.setString(1, lan);
                    res = ps.executeUpdate();
                    result = res >= 0;
                    conn.commit();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(ps);
                }
            }
            finally {
                this.close(ps);
            }
        }
        return result;
    }

    public boolean delLan(String lan) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        int res = 0;
        boolean result = false;
        try {
            try {
                ps = conn.prepareStatement(delLan);
                ps.setString(1, lan);
                res = ps.executeUpdate();
                result = res >= 0;
                conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean exsitLan(String lan) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            ps = conn.prepareStatement(exsitLan);
            ps.setString(1, lan);
            rs = ps.executeQuery();
            while (rs.next()) {
                list.add(rs.getString("lan"));
            }
            if (list.size() < 1) {
                result = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean isexsit(SSHInfo info) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(QUERY);
            ps.setString(1, info.getIp());
            rs = ps.executeQuery();
            if (rs == null) {
                result = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean addInfo(SSHInfo info) {
        boolean result;
        block7: {
            Connection conn = DBManager.getConnection();
            int update = 0;
            result = false;
            PreparedStatement ps = null;
            System.out.println("password:" + info.getPassword() + "|len:" + info.getPassword().length());
            try {
                try {
                    if (info != null) {
                        ps = conn.prepareStatement(INSERT_SQL);
                        ps.setString(1, info.getIp());
                        ps.setString(2, info.getUser());
                        String password = info.getPassword();
                        if (password != null && !password.equals("")) {
                            password = AES128CBC.encryptLocal(password);
                        }
                        ps.setString(3, password);
                        ps.setInt(4, info.isSshMode() ? 1 : 0);
                        ps.setString(5, info.getCommand());
                        ps.setString(6, info.getPort());
                        update = ps.executeUpdate();
                        result = update >= 0;
                    }
                    conn.commit();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(ps);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.close(ps);
                throw throwable;
            }
            this.close(ps);
        }
        return result;
    }

    public static void main(String[] args) {
        SSHInfo info = new SSHInfo();
        info.setIp("111.111.111.115");
        info.setSshMode(true);
        String pass = " 1234567890asdfghjklqwertyuiopzxcvbnm,./;'[]!@#$%^&*()_+ ";
        info.setPassword(pass);
        info.setUser("aaa");
        SSHInfoDao dao = new SSHInfoDao();
        dao.addInfo(info);
        SSHInfo info2 = dao.getSSHInfos("111.111.111.115");
    }

    public SSHInfo getSSHInfos(String ip) {
        SSHInfo info;
        block9: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            info = null;
            try {
                try {
                    ps = conn.prepareStatement(QUERY);
                    ps.setString(1, ip);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        info = new SSHInfo();
                        info.setIp(rs.getString("SSHIP"));
                        info.setUser(rs.getString("SSHUSER"));
                        info.setPassword(rs.getString("SSHPASSWORD"));
                        info.setCommand(rs.getString("sshCommand"));
                        info.setPort(rs.getString("sshPORT"));
                        int isselect = rs.getInt("ISSSHSHUTDOWN");
                        if (isselect == 1) {
                            info.setSshMode(true);
                        } else {
                            info.setSshMode(false);
                        }
                        String password = info.getPassword();
                        if (password != null && !password.equals("")) {
                            password = AES128CBC.descryptLocal(password);
                            info.setPassword(password);
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return info;
    }

    public List<SSHInfo> getSSHInfos() {
        ArrayList<SSHInfo> infos;
        Connection conn;
        block11: {
            conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            infos = new ArrayList<SSHInfo>();
            try {
                try {
                    ps = conn.prepareStatement(QUERYALL);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        SSHInfo info = new SSHInfo();
                        info.setIp(rs.getString("SSHIP"));
                        info.setUser(rs.getString("SSHUSER"));
                        info.setPassword(rs.getString("SSHPASSWORD"));
                        info.setCommand(rs.getString("sshCommand"));
                        info.setPort(rs.getString("sshPORT"));
                        int isselect = rs.getInt("ISSSHSHUTDOWN");
                        if (isselect == 1) {
                            info.setSshMode(true);
                        } else {
                            info.setSshMode(false);
                        }
                        String password = info.getPassword();
                        if (password != null && !password.equals("")) {
                            password = AES128CBC.descryptLocal(password);
                            info.setPassword(password);
                        }
                        infos.add(info);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.info("close database failed " + e.getMessage());
        }
        return infos;
    }

    public List<SSHInfo> showSSHInfos() {
        ArrayList<SSHInfo> infos;
        block8: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            infos = new ArrayList<SSHInfo>();
            try {
                try {
                    ps = conn.prepareStatement(QUERYALL);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        SSHInfo info = new SSHInfo();
                        info.setIp(rs.getString("SSHIP"));
                        info.setUser(rs.getString("SSHUSER"));
                        info.setPassword(!rs.getString("SSHPASSWORD").equals("") ? "******" : "");
                        info.setCommand(rs.getString("sshCommand"));
                        info.setPort(rs.getString("sshPORT"));
                        int isselect = rs.getInt("ISSSHSHUTDOWN");
                        if (isselect == 1) {
                            info.setSshMode(true);
                        } else {
                            info.setSshMode(false);
                        }
                        infos.add(info);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return infos;
    }

    public void setSSHInfo(SSHInfo info) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                ps = conn.prepareStatement(UPDATE);
                ps.setString(1, info.getIp());
                String password = info.getPassword();
                if (password != null && !password.equals("")) {
                    password = AES128CBC.encryptLocal(password);
                    info.setPassword(password);
                }
                ps.setString(2, info.getPassword());
                ps.setString(3, info.getUser());
                ps.setInt(4, info.isSshMode() ? 1 : 0);
                ps.setString(5, info.getCommand());
                ps.setString(6, info.getPort());
                ps.setString(7, info.getIp());
                ps.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.close(rs, ps);
            }
        }
        finally {
            this.close(rs, ps);
        }
    }

    public void removeRemoteIP(String ip) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(DELETEIP);
                ps.setString(1, ip);
                ps.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
    }

    public void clearRemoteIP() {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(CLEARIP);
                ps.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
    }

    public String getNameandPsd(String ip) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(queryNameandPsd);
            ps.setString(1, ip);
            ResultSet rs = ps.executeQuery();
            String password = rs.getString("PASSWORD");
            String sshuser = rs.getString("SSHUSER");
            if (password != null && !password.equals("")) {
                password = AES128CBC.descryptLocal(password);
            }
            String result = String.valueOf(sshuser) + "," + password;
            return result;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

