/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.data.dao;

import cn.com.voltronicpower.data.bean.PowerPlan;
import cn.com.voltronicpower.data.dao.BaseDao;
import cn.com.voltronicpower.data.tools.DBManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;

public class PowerPlanDao
extends BaseDao {
    private static final String INSERT_SQL = "INSERT INTO POWER_PLAN(CYCLE1,ON_DATE,OFF_DATE,ON_WEEK,OFF_WEEK,ON_MONTH,OFF_MONTH,ON_TIME,OFF_TIME,PORTS) VALUES(?,?,?,?,?,?,?,?,?,?)";
    private static final String SELECT = "SELECT * FROM POWER_PLAN";
    private static final String REMOVE = "DELETE FROM POWER_PLAN WHERE PLAN_ID=?";
    private static final String DELETEALL = "DELETE FROM POWER_PLAN";

    public PowerPlan addPowerPlan(PowerPlan plan) {
        block6: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement(INSERT_SQL, 1);
                    ps.setString(1, plan.getCycle());
                    ps.setDate(2, new java.sql.Date(plan.getOnDate().getTime()));
                    ps.setDate(3, new java.sql.Date(plan.getOffDate().getTime()));
                    ps.setInt(4, plan.getOnWeek());
                    ps.setInt(5, plan.getOffWeek());
                    ps.setInt(6, plan.getOnMonth());
                    ps.setInt(7, plan.getOffMonth());
                    ps.setTimestamp(8, new Timestamp(plan.getOnTime().getTime()));
                    ps.setTimestamp(9, new Timestamp(plan.getOffTime().getTime()));
                    ps.setString(10, plan.getPorts());
                    ps.executeUpdate();
                    rs = ps.getGeneratedKeys();
                    if (rs.next()) {
                        plan.setPlanId(rs.getInt(1));
                    }
                    conn.commit();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return plan;
    }

    public ArrayList<PowerPlan> getPowerPlans() {
        ArrayList<PowerPlan> plans;
        block12: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            plans = new ArrayList<PowerPlan>();
            try {
                try {
                    ps = conn.prepareStatement(SELECT);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        PowerPlan plan = new PowerPlan();
                        plan.setCycle(rs.getString("CYCLE1"));
                        plan.setOffDate((Date)rs.getDate("OFF_DATE"));
                        plan.setOffMonth(rs.getInt("OFF_MONTH"));
                        plan.setOffTime((Date)rs.getTimestamp("OFF_TIME"));
                        plan.setOffWeek(rs.getInt("OFF_WEEK"));
                        plan.setOnDate((Date)rs.getDate("ON_DATE"));
                        plan.setOnMonth(rs.getInt("ON_MONTH"));
                        plan.setOnTime((Date)rs.getTimestamp("ON_TIME"));
                        plan.setOnWeek(rs.getInt("ON_WEEK"));
                        plan.setPorts(rs.getString("PORTS"));
                        plan.setPlanId(rs.getInt("PLAN_ID"));
                        plans.add(plan);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    try {
                        conn.close();
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            this.close(rs, ps);
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return plans;
    }

    public void deleteAll() {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(DELETEALL);
                ps.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
    }

    public void removePowerPlan(int planId) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(REMOVE);
                ps.setInt(1, planId);
                ps.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
    }
}

