/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.data.dao;

import cn.com.voltronicpower.data.bean.EventInfo;
import cn.com.voltronicpower.data.dao.BaseDao;
import cn.com.voltronicpower.data.tools.DBManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class EventDao
extends BaseDao {
    private static final String INSERT_SQL = "INSERT INTO EVENTS_RECORD(EVENT_ID,PORT_NAME,OCCUR_TIME,PTID,SN) VALUES(?,?,?,?,?)";
    private static final String QUERY_PORTS = "SELECT DISTINCT PORT_NAME FROM EVENTS_RECORD ORDER BY PORT_NAME";
    private static final String QUERY_PTIDS_BY_COM = "SELECT DISTINCT PTID FROM EVENTS_RECORD WHERE PORT_NAME=? ORDER BY PTID";
    private static final String QUERY_SN_BY_PT_PID = " SELECT DISTINCT sn from events_record where port_name=? and ptid=? order by sn ";
    private static final String QUERY_BY_PTID = "SELECT * FROM EVENTS_RECORD WHERE OCCUR_TIME BETWEEN ? AND ? AND (1=1) AND PTID=? ORDER BY OCCUR_TIME DESC";
    private static final String QUERY_BY_PTID_SN = "SELECT * FROM EVENTS_RECORD WHERE OCCUR_TIME BETWEEN ? and ? and ptid=? and sn=? order by occur_time desc ";
    private static final String QUERY_BY_PORT = "SELECT * FROM EVENTS_RECORD WHERE OCCUR_TIME BETWEEN ? AND ? AND (PORT_NAME=? OR PORT_NAME='host') AND 1=1 ORDER BY OCCUR_TIME DESC";
    private static final String QUERY_BY_PORT_AND_PTID = "SELECT * FROM EVENTS_RECORD WHERE OCCUR_TIME BETWEEN ? AND ? AND (PORT_NAME=? OR PORT_NAME='host') AND PTID=? ORDER BY OCCUR_TIME DESC";
    private static final String QUERY_BY_PORT_PTID_SN = "SELECT * FROM EVENTS_RECORD WHERE OCCUR_TIME BETWEEN ? AND ? AND (PORT_NAME=? OR PORT_NAME='host') AND PTID=? and sn=? ORDER BY OCCUR_TIME DESC";
    private static final String QUERY_ALL = "SELECT * FROM EVENTS_RECORD WHERE OCCUR_TIME BETWEEN ? AND ? ORDER BY OCCUR_TIME DESC";
    private static final String REMOVE = "DELETE FROM EVENTS_RECORD WHERE RECORD_ID=?";
    private static final String REMOVEAll = "DELETE FROM EVENTS_RECORD WHERE OCCUR_TIME BETWEEN ? AND ? AND (PORT_NAME=? OR PORT_NAME='host') AND PTID=?";
    private static final String REMOVEAllSN = "DELETE FROM EVENTS_RECORD WHERE OCCUR_TIME BETWEEN ? and ? and ptid=? and sn=?";
    private static final String MAX_EVENT = "SELECT MAX(RECORD_ID) FROM EVENTS_RECORD";
    private static final String LIMIT_EVENT = "DELETE FROM EVENTS_RECORD WHERE RECORD_ID<?";

    public void addEventRecord(String eventId, String portName, String ptid) {
        this.addEventRecord(eventId, portName, ptid, null);
    }

    public void addEventRecord(String eventId, String portName, String ptid, String sn) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                if (!(ptid.equals("") || portName.equals("") || eventId.equals("") || ptid == null || portName == null || eventId == null)) {
                    if (ptid.startsWith("SNMP")) {
                        ptid = ptid.substring(4);
                    }
                    ps = conn.prepareStatement(INSERT_SQL);
                    ps.setString(1, eventId);
                    ps.setString(2, portName);
                    ps.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                    ps.setString(4, ptid);
                    System.out.println("portName:" + portName + "--" + sn);
                    if (sn != null) {
                        ps.setString(5, sn);
                    } else {
                        ps.setString(5, "");
                    }
                    ps.executeUpdate();
                    conn.commit();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
    }

    public void removeEventRecord(int recordId) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(REMOVE);
                ps.setInt(1, recordId);
                ps.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
    }

    public void removeAllEventRecord(Date startDate, Date endDate, String port, String ptid, String sn) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        String sql = REMOVEAll;
        if (sn != null) {
            sql = REMOVEAllSN;
        }
        try {
            try {
                ps = conn.prepareStatement(sql);
                ps.setDate(1, new java.sql.Date(startDate.getTime()));
                ps.setDate(2, new java.sql.Date(endDate.getTime()));
                ps.setString(3, port);
                ps.setString(4, ptid);
                if (sn != null) {
                    ps.setString(5, sn);
                }
                ps.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
    }

    public ArrayList<String> getEventPorts() {
        ArrayList<String> ports;
        block6: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            ports = new ArrayList<String>();
            try {
                try {
                    ps = conn.prepareStatement(QUERY_PORTS);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        String portName = rs.getString(1);
                        if (portName.equals("host")) continue;
                        ports.add(portName);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return ports;
    }

    public void clearall() {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("DELETE FROM EVENTS_RECORD");
                ps.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
    }

    public ArrayList<String> getEventPtidsByCom(String com) {
        ArrayList<String> ports;
        block6: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            ports = new ArrayList<String>();
            try {
                try {
                    ps = conn.prepareStatement(QUERY_PTIDS_BY_COM);
                    ps.setString(1, com);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        String portName = rs.getString(1);
                        if (portName.equals("host")) continue;
                        ports.add(portName);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return ports;
    }

    public List<EventInfo> selcetALL() {
        ArrayList<EventInfo> events;
        block6: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            events = new ArrayList<EventInfo>();
            try {
                try {
                    ps = conn.prepareStatement("SELECT * FROM EVENTS_RECORD");
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        EventInfo event = new EventInfo();
                        event.setRecordId(rs.getInt("RECORD_ID"));
                        event.setEventId(rs.getString("EVENT_ID"));
                        event.setOccurTime((Date)rs.getTimestamp("OCCUR_TIME"));
                        event.setName(rs.getString("PORT_NAME"));
                        event.setLevel(rs.getString("SN"));
                        event.setType(rs.getString("PTID"));
                        events.add(event);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return events;
    }

    public ArrayList<String> getEventSNByPortPID(String port, String pid) {
        ArrayList<String> ports;
        block6: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            ports = new ArrayList<String>();
            try {
                try {
                    ps = conn.prepareStatement(QUERY_SN_BY_PT_PID);
                    ps.setString(1, port);
                    ps.setString(2, pid);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        String portName = rs.getString(1);
                        if (portName.equals("host")) continue;
                        ports.add(portName);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return ports;
    }

    public ArrayList<EventInfo> getEvents(Date startDate, Date endDate, String port, String ptid, String sn) {
        ArrayList<EventInfo> events;
        block8: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            events = new ArrayList<EventInfo>();
            try {
                try {
                    if (port.equals("All")) {
                        ps = conn.prepareStatement(QUERY_BY_PTID_SN);
                        ps.setDate(1, new java.sql.Date(startDate.getTime()));
                        ps.setDate(2, new java.sql.Date(endDate.getTime()));
                        ps.setString(3, ptid);
                        ps.setString(4, sn);
                    } else {
                        ps = conn.prepareStatement(QUERY_BY_PORT_PTID_SN);
                        ps.setDate(1, new java.sql.Date(startDate.getTime()));
                        ps.setDate(2, new java.sql.Date(endDate.getTime()));
                        ps.setString(3, port);
                        ps.setString(4, ptid);
                        ps.setString(5, sn);
                    }
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        EventInfo event = new EventInfo();
                        event.setRecordId(rs.getInt("RECORD_ID"));
                        event.setEventId(rs.getString("EVENT_ID"));
                        event.setOccurTime((Date)rs.getTimestamp("OCCUR_TIME"));
                        events.add(event);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return events;
    }

    public ArrayList<EventInfo> getEvents(Date startDate, Date endDate, String port, String ptid) {
        ArrayList<EventInfo> events;
        block12: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            events = new ArrayList<EventInfo>();
            try {
                try {
                    if (port.equals("All") && ptid.equals("All")) {
                        ps = conn.prepareStatement(QUERY_ALL);
                        ps.setDate(1, new java.sql.Date(startDate.getTime()));
                        ps.setDate(2, new java.sql.Date(endDate.getTime()));
                    } else if (port.equals("All")) {
                        ps = conn.prepareStatement(QUERY_BY_PTID);
                        ps.setDate(1, new java.sql.Date(startDate.getTime()));
                        ps.setDate(2, new java.sql.Date(endDate.getTime()));
                        ps.setString(3, ptid);
                    } else if (ptid.equals("All")) {
                        ps = conn.prepareStatement(QUERY_BY_PORT);
                        ps.setDate(1, new java.sql.Date(startDate.getTime()));
                        ps.setDate(2, new java.sql.Date(endDate.getTime()));
                        ps.setString(3, port);
                    } else {
                        ps = conn.prepareStatement(QUERY_BY_PORT_AND_PTID);
                        ps.setDate(1, new java.sql.Date(startDate.getTime()));
                        ps.setDate(2, new java.sql.Date(endDate.getTime()));
                        ps.setString(3, port);
                        ps.setString(4, ptid);
                    }
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        EventInfo event = new EventInfo();
                        event.setRecordId(rs.getInt("RECORD_ID"));
                        event.setEventId(rs.getString("EVENT_ID"));
                        event.setOccurTime((Date)rs.getTimestamp("OCCUR_TIME"));
                        events.add(event);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return events;
    }

    public void addEvent(EventInfo eve) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                ps = conn.prepareStatement(INSERT_SQL);
                ps.setString(1, eve.getEventId());
                ps.setString(2, eve.getName());
                ps.setTimestamp(3, new Timestamp(eve.getOccurTime().getTime()));
                ps.setString(4, eve.getType());
                if (eve.getLevel().equals(null)) {
                    ps.setString(5, "");
                } else {
                    ps.setString(5, eve.getLevel());
                }
                ps.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.close(rs, ps);
            }
        }
        finally {
            this.close(rs, ps);
        }
    }

    public void limitRecord(int limitNum) {
        block6: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    int maxEventId;
                    int minEventId;
                    ps = conn.prepareStatement(MAX_EVENT);
                    rs = ps.executeQuery();
                    if (rs.next() && (minEventId = (maxEventId = rs.getInt(1)) - limitNum) > 0) {
                        this.close(ps);
                        ps = conn.prepareStatement(LIMIT_EVENT);
                        ps.setInt(1, minEventId);
                        ps.executeUpdate();
                        conn.commit();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
    }
}

