/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.data.dao;

import cn.com.voltronicpower.data.bean.EletricEvent;
import cn.com.voltronicpower.data.bean.EmailSelection;
import cn.com.voltronicpower.data.bean.EventInfo;
import cn.com.voltronicpower.data.bean.MobileSelection;
import cn.com.voltronicpower.data.bean.SmsInfo;
import cn.com.voltronicpower.data.dao.BaseDao;
import cn.com.voltronicpower.data.dao.ConfigDao;
import cn.com.voltronicpower.data.tools.DBManager;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class EventConfigDao
extends BaseDao {
    private static final String INSERT_SQL = "INSERT INTO EVENT_CONFIG(EVENT_ID,RECORD_METHOD,BUZZER_METHOD,WARNING_METHOD,BROADCAST_METHOD,MOBILE_SELECTIONS,EMAIL_SELECTIONS) VALUES(?,?,?,?,?,?,?)";
    private static final String QUERY = "SELECT * FROM EVENT_CONFIG WHERE EVENT_ID=?";
    private static final String UPDATE = "UPDATE EVENT_CONFIG SET RECORD_METHOD=?,BUZZER_METHOD=?,WARNING_METHOD=?,BROADCAST_METHOD=?,MOBILE_SELECTIONS=?,EMAIL_SELECTIONS=? WHERE EVENT_ID=?";
    private static final String QRYAll = "SELECT * FROM EVENT_CONFIG";
    private static final String DELAll = "DELETE FROM EVENT_CONFIG";

    public void addEventConfig(EletricEvent eletricEvent) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(INSERT_SQL);
                ps.setString(1, eletricEvent.getEventId());
                ps.setInt(2, eletricEvent.isRecordMethod() ? 1 : 0);
                ps.setInt(3, eletricEvent.isBuzzerMethod() ? 1 : 0);
                ps.setInt(4, eletricEvent.isWarningMethod() ? 1 : 0);
                ps.setInt(5, eletricEvent.isBroadcastMethod() ? 1 : 0);
                ps.setString(6, eletricEvent.getMobileStr());
                ps.setString(7, eletricEvent.getEmailStr());
                ps.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
    }

    public EletricEvent getEventConfigById(String eventId) {
        EletricEvent event;
        block13: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            event = new EletricEvent(eventId);
            String[] selectedMobiles = null;
            String[] selectedEmails = null;
            try {
                try {
                    ps = conn.prepareStatement(QUERY);
                    ps.setString(1, eventId);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        event.setRecordMethod(rs.getInt("RECORD_METHOD") > 0);
                        event.setBuzzerMethod(rs.getInt("BUZZER_METHOD") > 0);
                        event.setWarningMethod(rs.getInt("WARNING_METHOD") > 0);
                        event.setBroadcastMethod(rs.getInt("BROADCAST_METHOD") > 0);
                        selectedMobiles = rs.getString("MOBILE_SELECTIONS").split(",");
                        selectedEmails = rs.getString("EMAIL_SELECTIONS").split(",");
                    }
                    SmsInfo smsInfo = new SmsInfo();
                    PropertiesUtils.wrapProperties(smsInfo);
                    String daomobileNums = "";
                    daomobileNums = MyConstants.Customized.equals("LADIS") ? ConfigDao.qryValue("mobileNums") : smsInfo.getMobileNums();
                    ArrayList<MobileSelection> mobileSelections = new ArrayList<MobileSelection>();
                    if (daomobileNums.length() != 0) {
                        String[] mobileNums;
                        String[] stringArray = mobileNums = daomobileNums.split(",");
                        int n = mobileNums.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String mobile = stringArray[n2];
                            MobileSelection selection = new MobileSelection(mobile);
                            if (selectedMobiles != null) {
                                selection.setSelected(this.isSelected(selectedMobiles, mobile));
                            }
                            mobileSelections.add(selection);
                            ++n2;
                        }
                    }
                    ArrayList<EmailSelection> emailSelections = new ArrayList<EmailSelection>();
                    String emailrecieve = ConfigDao.qryValue("EmailInfo.recievers");
                    if (!emailrecieve.equals("email_reciver@test.com")) {
                        String[] mails;
                        String[] stringArray = mails = emailrecieve.split(",");
                        int n = mails.length;
                        int n3 = 0;
                        while (n3 < n) {
                            String mail = stringArray[n3];
                            if (!mail.equals("email_reciver@test.com")) {
                                EmailSelection selection = new EmailSelection(mail);
                                if (selectedEmails != null) {
                                    selection.setSelected(this.isSelected(selectedEmails, mail));
                                }
                                emailSelections.add(selection);
                            }
                            ++n3;
                        }
                    }
                    event.setMobileSelections(mobileSelections);
                    event.setEmailSelections(emailSelections);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return event;
    }

    public boolean isExistConfig(String eventId) {
        block7: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(QUERY);
                ps.setString(1, eventId);
                rs = ps.executeQuery();
                if (rs.next()) {
                    this.close(rs, ps);
                    return true;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                this.close(rs, ps);
            }
            this.close(rs, ps);
        }
        return false;
    }

    public boolean deleteAll() {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                ps = conn.prepareStatement(DELAll);
                ps.execute();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.close(rs, ps);
            }
        }
        finally {
            this.close(rs, ps);
        }
        return false;
    }

    private boolean isSelected(String[] selecteds, String content) {
        String[] stringArray = selecteds;
        int n = selecteds.length;
        int n2 = 0;
        while (n2 < n) {
            String selected = stringArray[n2];
            if (selected.equals(content)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public List<EventInfo> setEventConfig(EletricEvent eletricEvent) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<EventInfo> events = new ArrayList<EventInfo>();
        try {
            try {
                ps = conn.prepareStatement(UPDATE);
                ps.setInt(1, eletricEvent.isRecordMethod() ? 1 : 0);
                ps.setInt(2, eletricEvent.isBuzzerMethod() ? 1 : 0);
                ps.setInt(3, eletricEvent.isWarningMethod() ? 1 : 0);
                ps.setInt(4, eletricEvent.isBroadcastMethod() ? 1 : 0);
                ps.setString(5, eletricEvent.getMobileStr());
                ps.setString(6, eletricEvent.getEmailStr());
                ps.setString(7, eletricEvent.getEventId());
                ps.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.close(rs, ps);
            }
        }
        finally {
            this.close(rs, ps);
        }
        return events;
    }

    public List<EletricEvent> getEventAllConfig2() {
        ArrayList<EletricEvent> events;
        Connection conn;
        block8: {
            conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            events = new ArrayList<EletricEvent>();
            String mobiles = null;
            String emails = null;
            try {
                try {
                    ps = conn.prepareStatement(QRYAll);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        EletricEvent event = new EletricEvent();
                        event.setConfigId(rs.getInt("CONFIG_ID"));
                        event.setEventId(rs.getString("EVENT_ID"));
                        event.setRecordMethod(rs.getInt("RECORD_METHOD") > 0);
                        event.setBuzzerMethod(rs.getInt("BUZZER_METHOD") > 0);
                        event.setWarningMethod(rs.getInt("WARNING_METHOD") > 0);
                        event.setBroadcastMethod(rs.getInt("BROADCAST_METHOD") > 0);
                        mobiles = rs.getString("MOBILE_SELECTIONS");
                        emails = rs.getString("EMAIL_SELECTIONS");
                        ArrayList<MobileSelection> li = new ArrayList<MobileSelection>();
                        MobileSelection m = new MobileSelection();
                        li.add(m);
                        ArrayList<EmailSelection> li2 = new ArrayList<EmailSelection>();
                        EmailSelection e = new EmailSelection();
                        li2.add(e);
                        event.setMobileSelections(li);
                        event.setEmailSelections(li2);
                        event.setMobiles(mobiles);
                        event.setEmails(emails);
                        events.add(event);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return events;
    }

    public void importEletricEvent(EletricEvent eletricEvent) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(INSERT_SQL);
                ps.setString(1, eletricEvent.getEventId());
                ps.setInt(2, eletricEvent.isRecordMethod() ? 1 : 0);
                ps.setInt(3, eletricEvent.isBuzzerMethod() ? 1 : 0);
                ps.setInt(4, eletricEvent.isWarningMethod() ? 1 : 0);
                ps.setInt(5, eletricEvent.isBroadcastMethod() ? 1 : 0);
                ps.setString(6, eletricEvent.getMobiles());
                ps.setString(7, eletricEvent.getEmails());
                ps.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
    }
}

