/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.data.dao;

import cn.com.voltronicpower.data.bean.BuyInfo;
import cn.com.voltronicpower.data.dao.BaseDao;
import cn.com.voltronicpower.data.tools.DBManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BatteryWarnDao
extends BaseDao {
    public boolean addBuyInfo(BuyInfo info) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("insert into BUYINFO(DEVICE_ID,PTID,PORT_NAME,UPS_BUYDATE,BATTERY_BUYDATE,UPS_WARRANTY,BATTERY_WARRANTY,BATTERY_LIFETIME,UPS_PN,USEPROMPT) VALUES(?,?,?,?,?,?,?,?,?,?)");
                ps.setString(1, info.getDeviceId());
                ps.setString(2, info.getPtid());
                ps.setString(3, info.getPortName());
                ps.setDate(4, new java.sql.Date(info.getUpsBuyDate().getTime()));
                ps.setDate(5, new java.sql.Date(info.getBatteryBuyDate().getTime()));
                ps.setInt(6, info.getUpsWarranty());
                ps.setInt(7, info.getBatteryWarranty());
                ps.setInt(8, info.getBatteryLifetime());
                ps.setString(9, info.getUpspn());
                ps.setBoolean(10, info.isUsePrompt());
                if (ps.executeUpdate() > 0) {
                    conn.commit();
                    result = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean updateBuyInfo(BuyInfo info) {
        boolean result = false;
        BuyInfo oldInfo = null;
        oldInfo = info.getDeviceId().equals("00000000000000000000") ? this.getBuyInfo(info.getDeviceId(), info.getPtid()) : this.getBuyInfo(info.getDeviceId(), info.getPtid(), info.getPortName());
        if (oldInfo == null) {
            result = this.addBuyInfo(info);
        } else {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement(" update BUYINFO set UPS_BUYDATE=?,BATTERY_BUYDATE=?,UPS_WARRANTY=?,BATTERY_WARRANTY=?, BATTERY_LIFETIME=?,UPS_PN=?,USEPROMPT=?  where DEVICE_ID=? and PTID=? and PORT_NAME=?");
                    ps.setDate(1, new java.sql.Date(info.getUpsBuyDate().getTime()));
                    ps.setDate(2, new java.sql.Date(info.getBatteryBuyDate().getTime()));
                    ps.setInt(3, info.getUpsWarranty());
                    ps.setInt(4, info.getBatteryWarranty());
                    ps.setInt(5, info.getBatteryLifetime());
                    ps.setString(6, info.getUpspn());
                    ps.setBoolean(7, info.isUsePrompt());
                    ps.setString(8, info.getDeviceId());
                    ps.setString(9, info.getPtid());
                    ps.setString(10, info.getPortName());
                    if (ps.executeUpdate() > 0) {
                        conn.commit();
                        result = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                }
            }
            finally {
                this.close(rs, ps);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        BatteryWarnDao dao = new BatteryWarnDao();
        List<BuyInfo> list = dao.getBattery();
        for (BuyInfo buy : list) {
            System.out.println("buy:" + buy.getBatteryLifetime());
        }
    }

    public List<BuyInfo> getBattery() {
        ArrayList<BuyInfo> list;
        block8: {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            list = new ArrayList<BuyInfo>();
            try {
                try {
                    ps = conn.prepareStatement("select * from BUYINFO");
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        BuyInfo info = new BuyInfo();
                        info.setDeviceId(rs.getString("DEVICE_ID"));
                        info.setPtid(rs.getString("PTID"));
                        info.setPortName(rs.getString("PORT_NAME"));
                        info.setUpsBuyDate((Date)rs.getDate("UPS_BUYDATE"));
                        info.setBatteryBuyDate((Date)rs.getDate("BATTERY_BUYDATE"));
                        info.setUpsWarranty(rs.getInt("UPS_WARRANTY"));
                        info.setBatteryWarranty(rs.getInt("BATTERY_WARRANTY"));
                        info.setBatteryLifetime(rs.getInt("BATTERY_LIFETIME"));
                        info.setUsePrompt(rs.getBoolean("USEPROMPT"));
                        info.setUpspn(rs.getString("UPS_PN"));
                        list.add(info);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return list;
    }

    public BuyInfo getBuyInfo(String deviceId, String ptid, String portName) {
        BuyInfo info;
        block6: {
            info = null;
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("select * from BUYINFO where DEVICE_ID=? and ptid=? and port_name=?");
                    ps.setString(1, deviceId);
                    ps.setString(2, ptid);
                    ps.setString(3, portName);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        info = new BuyInfo();
                        info.setDeviceId(rs.getString("DEVICE_ID"));
                        info.setPtid(rs.getString("PTID"));
                        info.setPortName(rs.getString("PORT_NAME"));
                        info.setUpsBuyDate((Date)rs.getDate("UPS_BUYDATE"));
                        info.setBatteryBuyDate((Date)rs.getDate("BATTERY_BUYDATE"));
                        info.setUpsWarranty(rs.getInt("UPS_WARRANTY"));
                        info.setBatteryWarranty(rs.getInt("BATTERY_WARRANTY"));
                        info.setBatteryLifetime(rs.getInt("BATTERY_LIFETIME"));
                        info.setUsePrompt(rs.getBoolean("USEPROMPT"));
                        info.setUpspn(rs.getString("UPS_PN"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return info;
    }

    public BuyInfo getBuyInfo(String deviceId, String ptid) {
        BuyInfo info;
        block6: {
            info = null;
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("select * from BUYINFO where DEVICE_ID=? and ptid=?");
                    ps.setString(1, deviceId);
                    ps.setString(2, ptid);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        info = new BuyInfo();
                        info.setDeviceId(rs.getString("DEVICE_ID"));
                        info.setPtid(rs.getString("PTID"));
                        info.setPortName(rs.getString("PORT_NAME"));
                        info.setUpsBuyDate((Date)rs.getDate("UPS_BUYDATE"));
                        info.setBatteryBuyDate((Date)rs.getDate("BATTERY_BUYDATE"));
                        info.setUpsWarranty(rs.getInt("UPS_WARRANTY"));
                        info.setBatteryWarranty(rs.getInt("BATTERY_WARRANTY"));
                        info.setBatteryLifetime(rs.getInt("BATTERY_LIFETIME"));
                        info.setUsePrompt(rs.getBoolean("USEPROMPT"));
                        info.setUpspn(rs.getString("UPS_PN"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return info;
    }

    public void updatePortName(String deviceId, String ptid, String portName) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(" update BUYINFO set PORT_NAME=? where DEVICE_ID=? and PTID=? ");
                ps.setString(1, portName);
                ps.setString(2, deviceId);
                ps.setString(3, ptid);
                ps.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
    }
}

