/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.data.dao;

import cn.com.voltronicpower.data.bean.TestPlan;
import cn.com.voltronicpower.data.dao.BaseDao;
import cn.com.voltronicpower.data.tools.DBManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;

public class BatteryTestPlanDao
extends BaseDao {
    private static final String INSERT_SQL = "INSERT INTO BATTERY_TEST_PLAN(CYCLE1,PLAN_DATE,PLAN_WEEK,PLAN_MONTH,PLAN_TIME,OPERATION,DELAY_MINUTE,PORTS) VALUES(?,?,?,?,?,?,?,?)";
    private static final String SELECT = "SELECT * FROM BATTERY_TEST_PLAN";
    private static final String REMOVE = "DELETE FROM BATTERY_TEST_PLAN WHERE PLAN_ID=?";
    private static final String DELETEALL = "DELETE FROM BATTERY_TEST_PLAN";

    public TestPlan addBatteryTestPlan(TestPlan plan) {
        block6: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement(INSERT_SQL, 1);
                    ps.setString(1, plan.getCycle());
                    ps.setDate(2, new java.sql.Date(plan.getPlanDate().getTime()));
                    ps.setInt(3, plan.getPlanWeek());
                    ps.setInt(4, plan.getPlanMonth());
                    ps.setTimestamp(5, new Timestamp(plan.getPlanTime().getTime()));
                    ps.setString(6, plan.getOperation());
                    ps.setFloat(7, plan.getDelayMinute());
                    ps.setString(8, plan.getPorts());
                    ps.executeUpdate();
                    rs = ps.getGeneratedKeys();
                    if (rs.next()) {
                        plan.setPlanId(rs.getInt(1));
                    }
                    conn.commit();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return plan;
    }

    public ArrayList<TestPlan> getBatteryTestPlans() {
        ArrayList<TestPlan> plans;
        block18: {
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            plans = new ArrayList<TestPlan>();
            try {
                try {
                    ps = conn.prepareStatement(SELECT);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        TestPlan plan = new TestPlan();
                        plan.setCycle(rs.getString("CYCLE1"));
                        plan.setDelayMinute(rs.getFloat("DELAY_MINUTE"));
                        plan.setOperation(rs.getString("OPERATION"));
                        plan.setPlanDate((Date)rs.getDate("PLAN_DATE"));
                        plan.setPlanId(rs.getInt("PLAN_ID"));
                        plan.setPlanMonth(rs.getInt("PLAN_MONTH"));
                        plan.setPlanTime((Date)rs.getTimestamp("PLAN_TIME"));
                        plan.setPlanWeek(rs.getInt("PLAN_WEEK"));
                        plan.setPorts(rs.getString("PORTS"));
                        plan.setPlanId(rs.getInt("PLAN_ID"));
                        plans.add(plan);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    try {
                        conn.close();
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                    try {
                        conn.close();
                    }
                    catch (SQLException e3) {
                        e3.printStackTrace();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            this.close(rs, ps);
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return plans;
    }

    public void deleteAll() {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(DELETEALL);
                ps.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
    }

    public void removeBatteryTestPlan(int planId) {
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(REMOVE);
                ps.setInt(1, planId);
                ps.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
    }
}

