/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.configure;

import cn.com.voltronic.util.DateUtils;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.Log;
import java.io.File;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class SystemEnv {
    private static final Log logger = new Log();
    public static String localHostAddr = "127.0.0.1";
    public static boolean isIpv6 = false;
    public static volatile boolean IS_TEST_MODE = false;
    public static volatile int FILE_NUMBER = 0;
    private static String localHostName = "localhost";
    private static List<InetAddress> interfaces;
    public static String refreshTree;
    public static boolean refreshSearchingUPS;
    public static String refreshSearchUPSTree;
    public static String oldIPAddress;
    public static volatile boolean stopping;
    public static volatile int stoped;
    public static boolean useTCPShutdown;

    static {
        refreshTree = "";
        refreshSearchingUPS = false;
        refreshSearchUPSTree = "";
        oldIPAddress = "";
        stopping = false;
        stoped = 0;
        useTCPShutdown = true;
        SystemEnv.initInterfaces();
        if (interfaces.size() > 0) {
            InetAddress ip = interfaces.get(0);
            isIpv6 = ip instanceof Inet6Address;
            localHostAddr = ip.getHostAddress();
            localHostName = ip.getHostName();
        }
    }

    public static boolean isLan(String ips) {
        return interfaces.contains(ips);
    }

    public static void setTestMode(boolean value) {
        if (value) {
            ++FILE_NUMBER;
            SystemEnv.setFileNumber();
        }
        IS_TEST_MODE = value;
    }

    public static String getFileNumber() {
        String result = String.valueOf(FILE_NUMBER);
        while (result.length() < 5) {
            result = "0" + result;
        }
        return result;
    }

    public static void setFileNumber() {
        String url = String.valueOf(System.getProperty("user.dir")) + File.separator + "log" + File.separator + "testlog";
        File f = new File(url);
        if (!f.exists()) {
            f.mkdirs();
        }
        File[] files = f.listFiles();
        int number1 = 0;
        String nowDateString = DateUtils.getNowDate((String)"yyyy-MM-dd");
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String filename = file.getName();
            try {
                String subStr;
                int number2;
                String fileDate = filename.substring(0, 10);
                if (nowDateString.equals(fileDate) && number1 < (number2 = Integer.parseInt(subStr = filename.substring(11, filename.lastIndexOf("."))))) {
                    number1 = number2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        if (number1 == 0) {
            FILE_NUMBER = number1;
        }
        if (FILE_NUMBER <= number1) {
            FILE_NUMBER = number1;
            ++FILE_NUMBER;
        }
    }

    public static void initInterfaces() {
        boolean haveipv4 = false;
        boolean haveipv6 = false;
        interfaces = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                InetAddress ip;
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> cardipaddress = ni.getInetAddresses();
                while (cardipaddress.hasMoreElements()) {
                    ip = cardipaddress.nextElement();
                    if (!(ip instanceof Inet4Address) || ip.getHostAddress().equalsIgnoreCase("127.0.0.1")) continue;
                    haveipv4 = true;
                    interfaces.add(ip);
                }
                while (cardipaddress.hasMoreElements()) {
                    ip = cardipaddress.nextElement();
                    if (haveipv4 || !(ip instanceof Inet6Address) || ip.getHostAddress().indexOf("0:0:0:0:0:0:1") != -1) continue;
                    haveipv6 = true;
                    interfaces.add(ip);
                }
            }
            if (!haveipv4 && !haveipv6) {
                try {
                    interfaces.add(InetAddress.getByName("127.0.0.1"));
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    public static List<InetAddress> getInterfaces() {
        if (interfaces.size() == 1 && interfaces.get(0).getHostAddress().equals("127.0.0.1") || interfaces.size() < 1) {
            SystemEnv.initInterfaces();
            if (interfaces.size() > 0) {
                InetAddress ip = interfaces.get(0);
                isIpv6 = ip instanceof Inet6Address;
                localHostAddr = ip.getHostAddress();
                localHostName = ip.getHostName();
            }
        }
        return interfaces;
    }

    public static String getLocalHostAddress() {
        return localHostAddr;
    }

    public static String getLocalHostAddress(String clientIP) {
        for (InetAddress ipaddr : interfaces) {
            String str = ipaddr.getHostAddress();
            if (!clientIP.equals(str)) continue;
            return str;
        }
        return interfaces.get(0).getHostAddress();
    }

    public static boolean compareIp(String ip1, String ip2) {
        return ip1.substring(0, ip1.lastIndexOf(".")).equals(ip2.substring(0, ip2.lastIndexOf(".")));
    }

    public static String getLocalHostName() {
        return localHostName;
    }

    public static String getLocalURL(String port) {
        SystemEnv.initInterfaces();
        String ipstr = "http://localhost:" + port + "/" + MyConstants.SERVER_NAME;
        return ipstr;
    }

    public static void main(String[] args) {
        SystemEnv.getInterfaces();
    }
}

