/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower;

import cn.com.voltronicpower.SocketService;
import cn.com.voltronicpower.StartTomcat;
import cn.com.voltronicpower.StopTomcat;
import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.configure.SystemEnv;
import cn.com.voltronicpower.data.dao.EventDao;
import cn.com.voltronicpower.data.dao.WorkDataDao;
import cn.com.voltronicpower.data.tools.DBCreate;
import cn.com.voltronicpower.monitor.MonitorAdpater;
import cn.com.voltronicpower.monitor.MonitorProcesserManager;
import cn.com.voltronicpower.monitor.processor.P00Processor;
import cn.com.voltronicpower.monitor.processor.P01Processor;
import cn.com.voltronicpower.monitor.processor.P02Processor;
import cn.com.voltronicpower.monitor.processor.P03Processor;
import cn.com.voltronicpower.monitor.processor.P05Processor;
import cn.com.voltronicpower.monitor.processor.P08Processor;
import cn.com.voltronicpower.monitor.processor.P09Processor;
import cn.com.voltronicpower.monitor.processor.P10Processor;
import cn.com.voltronicpower.monitor.processor.P13Processor;
import cn.com.voltronicpower.monitor.processor.P14Processor;
import cn.com.voltronicpower.monitor.processor.P31Processor;
import cn.com.voltronicpower.monitor.processor.P33Processor;
import cn.com.voltronicpower.monitor.processor.P35Processor;
import cn.com.voltronicpower.monitor.processor.P36Processor;
import cn.com.voltronicpower.monitor.processor.P38Processor;
import cn.com.voltronicpower.monitor.processor.P39Processor;
import cn.com.voltronicpower.monitor.processor.P40Processor;
import cn.com.voltronicpower.monitor.processor.P44Processor;
import cn.com.voltronicpower.monitor.processor.P45Processor;
import cn.com.voltronicpower.monitor.processor.P71Processor;
import cn.com.voltronicpower.monitor.processor.P73Processor;
import cn.com.voltronicpower.monitor.processor.P98Processor;
import cn.com.voltronicpower.monitor.processor.P99Processor;
import cn.com.voltronicpower.monitor.processor.PMVProcessor;
import cn.com.voltronicpower.monitor.processor.PMV_HProcessor;
import cn.com.voltronicpower.monitor.processor.PMV_IProcessor;
import cn.com.voltronicpower.monitor.processor.PMV_JProcessor;
import cn.com.voltronicpower.monitor.processor.PMV_SimplifyProcessor;
import cn.com.voltronicpower.monitor.processor.TaurusProcessor;
import cn.com.voltronicpower.monitor.protocol.P00;
import cn.com.voltronicpower.monitor.protocol.P01;
import cn.com.voltronicpower.monitor.protocol.P02;
import cn.com.voltronicpower.monitor.protocol.P03;
import cn.com.voltronicpower.monitor.protocol.P05;
import cn.com.voltronicpower.monitor.protocol.P08;
import cn.com.voltronicpower.monitor.protocol.P09;
import cn.com.voltronicpower.monitor.protocol.P10;
import cn.com.voltronicpower.monitor.protocol.P13;
import cn.com.voltronicpower.monitor.protocol.P14;
import cn.com.voltronicpower.monitor.protocol.P31;
import cn.com.voltronicpower.monitor.protocol.P33;
import cn.com.voltronicpower.monitor.protocol.P35;
import cn.com.voltronicpower.monitor.protocol.P36;
import cn.com.voltronicpower.monitor.protocol.P38;
import cn.com.voltronicpower.monitor.protocol.P39;
import cn.com.voltronicpower.monitor.protocol.P40;
import cn.com.voltronicpower.monitor.protocol.P44;
import cn.com.voltronicpower.monitor.protocol.P45;
import cn.com.voltronicpower.monitor.protocol.P71;
import cn.com.voltronicpower.monitor.protocol.P73;
import cn.com.voltronicpower.monitor.protocol.P98;
import cn.com.voltronicpower.monitor.protocol.P99;
import cn.com.voltronicpower.monitor.protocol.PMV;
import cn.com.voltronicpower.monitor.protocol.PMV_H;
import cn.com.voltronicpower.monitor.protocol.PMV_I;
import cn.com.voltronicpower.monitor.protocol.PMV_J;
import cn.com.voltronicpower.monitor.protocol.PMV_Simplify;
import cn.com.voltronicpower.monitor.protocol.PTaurus;
import cn.com.voltronicpower.monitorcommunicate.CommConnector;
import cn.com.voltronicpower.monitorcommunicate.ModbusHandler;
import cn.com.voltronicpower.monitorcommunicate.SerialPortHandler;
import cn.com.voltronicpower.monitorcommunicate.UDPController;
import cn.com.voltronicpower.monitorcommunicate.USBHandler;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.rmiclass.ConfigService;
import cn.com.voltronicpower.rmiclass.ControlService;
import cn.com.voltronicpower.rmiclass.GlobalService;
import cn.com.voltronicpower.rmiclass.HistoryService;
import cn.com.voltronicpower.rmiclass.MonitorService;
import cn.com.voltronicpower.rmiclass.SearchService;
import cn.com.voltronicpower.rmiclass.SystemService;
import cn.com.voltronicpower.tomcat.Cmd;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.work.BatteryWarnHandler;
import cn.com.voltronicpower.work.DataRecordThread;
import cn.com.voltronicpower.work.SystemShutdown;
import cn.com.voltronicpower.work.UpsScheduler;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Locale;
import usb.IUSBComm;
import usb.MacUSBRemote;
import usb.USBCommEx;
import wintools.WinShutdown;

public class StartMain {
    private static final Log logger = new Log();
    private static MacUSBRemote macusbdriver;
    private static USBCommEx usbdriver;
    private static IUSBComm iusbdriver;
    private static Remote reg;
    private static ConfigService configService;
    private static ControlService controlService;
    private static GlobalService globalService;
    private static HistoryService historyService;
    private static MonitorService monitorService;
    private static SearchService searchService;
    private static SystemService systemService;

    static {
        reg = null;
        configService = null;
        controlService = null;
        globalService = null;
        historyService = null;
        monitorService = null;
        searchService = null;
        systemService = null;
    }

    public static void initSystem() {
        try {
            if (MyConstants.IS_OS_MAC_OSX) {
                macusbdriver = new MacUSBRemote();
                iusbdriver = macusbdriver;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            } else if (MyConstants.IS_OS_WINDOWS || MyConstants.IS_OS_LINUX || MyConstants.IS_OS_SOLARIS) {
                usbdriver = new USBCommEx();
                iusbdriver = usbdriver;
            } else {
                usbdriver = new USBCommEx();
                iusbdriver = usbdriver;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (MyConstants.IS_OS_WINDOWS) {
            SystemShutdown.setShutdownObj(new WinShutdown());
        } else if (MyConstants.IS_OS_MAC) {
            SystemShutdown.setShutdownObj(macusbdriver);
        } else {
            SystemShutdown.setShutdownObj(usbdriver);
        }
        if (DBCreate.inittables()) {
            DBCreate.createTables();
        }
        StartMain.initMoniterProcess();
    }

    public static void main(String[] args) {
        StartMain.startRun();
    }

    public static void startRun() {
        try {
            if (StartMain.initializeSystem()) {
                if (StartMain.registryRMI()) {
                    SocketService socket = new SocketService();
                    socket.start();
                    if (Cmd.serverstatusinapprun() == 4) {
                        StopTomcat stopTomcat = new StopTomcat();
                        stopTomcat.start();
                    } else {
                        StartTomcat tomcat = new StartTomcat();
                        tomcat.start();
                    }
                } else {
                    StartMain.stopMonitor();
                }
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
    }

    public static void stopMonitor() {
        logger.error("MONITOR SYSTEM EXIT");
        System.exit(0);
    }

    private static boolean registryRMI() {
        try {
            configService = new ConfigService();
            controlService = new ControlService();
            globalService = new GlobalService();
            historyService = new HistoryService();
            monitorService = new MonitorService();
            searchService = new SearchService();
            systemService = new SystemService();
            System.setProperty("java.rmi.server.hostname", "localhost");
            reg = LocateRegistry.createRegistry(51099);
            Naming.rebind("rmi://localhost:51099/config", configService);
            Naming.rebind("rmi://localhost:51099/control", controlService);
            Naming.rebind("rmi://localhost:51099/global", globalService);
            Naming.rebind("rmi://localhost:51099/history", historyService);
            Naming.rebind("rmi://localhost:51099/monitor", monitorService);
            Naming.rebind("rmi://localhost:51099/search", searchService);
            Naming.rebind("rmi://localhost:51099/system", systemService);
            return true;
        }
        catch (Exception e) {
            logger.error("RMI ERROR:" + e.getMessage());
            return false;
        }
    }

    public static boolean reRegistryRMI() {
        try {
            Naming.unbind("rmi://localhost:51099/config");
            Naming.unbind("rmi://localhost:51099/control");
            Naming.unbind("rmi://localhost:51099/global");
            Naming.unbind("rmi://localhost:51099/history");
            Naming.unbind("rmi://localhost:51099/monitor");
            Naming.unbind("rmi://localhost:51099/search");
            Naming.unbind("rmi://localhost:51099/system");
            UnicastRemoteObject.unexportObject(reg, true);
            StartMain.registryRMI();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("UN RMI ERROR:" + e.getMessage());
            return false;
        }
    }

    private static void initMoniterProcess() {
        MonitorAdpater madpater = new MonitorAdpater();
        madpater.registerMonitor(P00.class, SerialPortHandler.class, P00Processor.class);
        madpater.registerMonitor(P01.class, SerialPortHandler.class, P01Processor.class);
        madpater.registerMonitor(P02.class, SerialPortHandler.class, P02Processor.class);
        madpater.registerMonitor(P03.class, SerialPortHandler.class, P03Processor.class);
        madpater.registerMonitor(P10.class, SerialPortHandler.class, P10Processor.class);
        madpater.registerMonitor(P33.class, SerialPortHandler.class, P33Processor.class);
        madpater.registerMonitor(P35.class, SerialPortHandler.class, P35Processor.class);
        madpater.registerMonitor(P45.class, SerialPortHandler.class, P45Processor.class);
        madpater.registerMonitor(P36.class, SerialPortHandler.class, P36Processor.class);
        madpater.registerMonitor(P13.class, SerialPortHandler.class, P13Processor.class);
        madpater.registerMonitor(P14.class, SerialPortHandler.class, P14Processor.class);
        madpater.registerMonitor(P38.class, SerialPortHandler.class, P38Processor.class);
        madpater.registerMonitor(P08.class, SerialPortHandler.class, P08Processor.class);
        madpater.registerMonitor(P09.class, SerialPortHandler.class, P09Processor.class);
        madpater.registerMonitor(P98.class, SerialPortHandler.class, P98Processor.class);
        madpater.registerMonitor(P99.class, SerialPortHandler.class, P99Processor.class);
        madpater.registerMonitor(P31.class, SerialPortHandler.class, P31Processor.class);
        madpater.registerMonitor(P39.class, SerialPortHandler.class, P39Processor.class);
        madpater.registerMonitor(P40.class, SerialPortHandler.class, P40Processor.class);
        madpater.registerMonitor(P71.class, SerialPortHandler.class, P71Processor.class);
        madpater.registerMonitor(P05.class, SerialPortHandler.class, P05Processor.class);
        madpater.registerMonitor(P73.class, SerialPortHandler.class, P73Processor.class);
        madpater.registerMonitor(P44.class, SerialPortHandler.class, P44Processor.class);
        madpater.registerMonitor(PMV.class, SerialPortHandler.class, PMVProcessor.class);
        madpater.registerMonitor(PMV_Simplify.class, SerialPortHandler.class, PMV_SimplifyProcessor.class);
        madpater.registerMonitor(PMV_H.class, SerialPortHandler.class, PMV_HProcessor.class);
        madpater.registerMonitor(PMV_I.class, SerialPortHandler.class, PMV_IProcessor.class);
        madpater.registerMonitor(PMV_J.class, SerialPortHandler.class, PMV_JProcessor.class);
        madpater.registerMonitor(P00.class, USBHandler.class, P00Processor.class);
        madpater.registerMonitor(P01.class, USBHandler.class, P01Processor.class);
        madpater.registerMonitor(P02.class, USBHandler.class, P02Processor.class);
        madpater.registerMonitor(P03.class, USBHandler.class, P03Processor.class);
        madpater.registerMonitor(P10.class, USBHandler.class, P10Processor.class);
        madpater.registerMonitor(P33.class, USBHandler.class, P33Processor.class);
        madpater.registerMonitor(P35.class, USBHandler.class, P35Processor.class);
        madpater.registerMonitor(P36.class, USBHandler.class, P36Processor.class);
        madpater.registerMonitor(P13.class, USBHandler.class, P13Processor.class);
        madpater.registerMonitor(P14.class, USBHandler.class, P14Processor.class);
        madpater.registerMonitor(P38.class, USBHandler.class, P38Processor.class);
        madpater.registerMonitor(P08.class, USBHandler.class, P08Processor.class);
        madpater.registerMonitor(P09.class, USBHandler.class, P09Processor.class);
        madpater.registerMonitor(P98.class, USBHandler.class, P98Processor.class);
        madpater.registerMonitor(P99.class, USBHandler.class, P99Processor.class);
        madpater.registerMonitor(P31.class, USBHandler.class, P31Processor.class);
        madpater.registerMonitor(P39.class, USBHandler.class, P39Processor.class);
        madpater.registerMonitor(P40.class, USBHandler.class, P40Processor.class);
        madpater.registerMonitor(P71.class, USBHandler.class, P71Processor.class);
        madpater.registerMonitor(P05.class, USBHandler.class, P05Processor.class);
        madpater.registerMonitor(P73.class, USBHandler.class, P73Processor.class);
        madpater.registerMonitor(P44.class, USBHandler.class, P44Processor.class);
        madpater.registerMonitor(P45.class, USBHandler.class, P45Processor.class);
        madpater.registerMonitor(PMV.class, USBHandler.class, PMVProcessor.class);
        madpater.registerMonitor(PMV_Simplify.class, USBHandler.class, PMV_SimplifyProcessor.class);
        madpater.registerMonitor(PMV_H.class, USBHandler.class, PMV_HProcessor.class);
        madpater.registerMonitor(PMV_I.class, USBHandler.class, PMV_IProcessor.class);
        madpater.registerMonitor(PMV_J.class, USBHandler.class, PMV_JProcessor.class);
        madpater.registerMonitor(PTaurus.class, ModbusHandler.class, TaurusProcessor.class);
        MonitorProcesserManager.setMonitorAdpater(madpater);
    }

    public static boolean initializeSystem() {
        boolean result = true;
        try {
            StartMain.initSystem();
            CommConnector connector = CommConnector.getInstance();
            connector.setUsbDriver(iusbdriver);
            PropertiesUtils.initProperties();
            PropertiesUtils.setModBusConfigs();
            WorkDataDao workDataDao = new WorkDataDao();
            workDataDao.limitRecord(PropertiesUtils.getGlobalConfig().getDataLimit());
            EventDao eventDao = new EventDao();
            eventDao.limitRecord(PropertiesUtils.getGlobalConfig().getEventLimit());
            UDPController.startSearch(SystemEnv.getLocalHostAddress());
            UpsScheduler scheduler = new UpsScheduler();
            scheduler.start();
            BatteryWarnHandler batteryWarn = new BatteryWarnHandler();
            batteryWarn.start();
            DataRecordThread recordThread = new DataRecordThread();
            recordThread.start();
            connector.start();
        }
        catch (Exception e) {
            logger.error("initializeSystem error:" + e.getMessage());
            result = false;
        }
        return result;
    }

    private static void initDefaultLanguage() {
        Locale local = Locale.getDefault();
        String language = local.getLanguage();
        if ("zh".equals(language)) {
            Config.updateProperty("showEnglish", "false");
            Config.updateProperty("showChinese", "true");
            Config.updateProperty("showTurkish", "false");
            Config.updateProperty("showRussian", "false");
        }
        if ("ru".equals(language)) {
            Config.updateProperty("showEnglish", "false");
            Config.updateProperty("showChinese", "false");
            Config.updateProperty("showTurkish", "false");
            Config.updateProperty("showRussian", "true");
        }
        if ("en".equals(language)) {
            Config.updateProperty("showEnglish", "true");
            Config.updateProperty("showChinese", "false");
            Config.updateProperty("showTurkish", "false");
            Config.updateProperty("showRussian", "false");
        }
        if ("tr".equals(language)) {
            Config.updateProperty("showEnglish", "false");
            Config.updateProperty("showChinese", "false");
            Config.updateProperty("showTurkish", "true");
            Config.updateProperty("showRussian", "false");
        }
    }
}

