/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower;

import cn.com.voltronic.socket.DatagramServer;
import cn.com.voltronicpower.StartMain;
import cn.com.voltronicpower.StartTomcat;
import cn.com.voltronicpower.StopTomcat;
import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.configure.SystemEnv;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.monitor.MonitorProcessor;
import cn.com.voltronicpower.monitorcommunicate.CommConnector;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.tomcat.Cmd;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.work.SystemShutdown;
import java.util.Map;

public class SocketService
extends Thread {
    DatagramServer _server;
    public static final String UPDATE_UPS_PROPERTIES = "updateUPS";
    public static final String UPDATE_VIEWPOWER_PROPERTIES = "updateVIEWPOWER";
    private static final Log logger = new Log();

    public SocketService() {
        try {
            this._server = new DatagramServer("localhost", 51222);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (!SystemEnv.stopping) {
            try {
                String[] messages;
                String rec = this._server.receive().trim();
                if (rec.startsWith(UPDATE_UPS_PROPERTIES)) {
                    String[] values = rec.split("#");
                    if ("del".equals(values[1])) {
                        for (Map.Entry<String, MonitorProcessor> entry : CommConnector.getInstance().getProcesserMap().entrySet()) {
                            if (!entry.getKey().startsWith(values[2])) continue;
                            entry.getValue().close();
                        }
                    }
                    PropertiesUtils.refreshProperties();
                    continue;
                }
                if (rec.startsWith("RESTART")) {
                    this._server.response("(OK");
                    if (!StartMain.reRegistryRMI()) continue;
                    if (Cmd.serverstatusinapprun() == 4) {
                        StopTomcat stopTomcat = new StopTomcat();
                        stopTomcat.start();
                    } else {
                        StartTomcat tomcat = new StartTomcat();
                        tomcat.start();
                    }
                    CommConnector.getInstance().sendUPSNumber();
                    continue;
                }
                if (rec.equals(UPDATE_VIEWPOWER_PROPERTIES)) {
                    Config.refreashProperties();
                    continue;
                }
                if (rec.startsWith("shutdown")) {
                    messages = rec.split("#");
                    this.shutdown(messages[1]);
                    continue;
                }
                if (rec.startsWith("stopmonitor")) {
                    if (!MyConstants.IS_OS_WINDOWS && !MyConstants.IS_OS_LINUX) continue;
                    System.exit(0);
                    continue;
                }
                if (rec.trim().equals("LINUX_TEXT_STOP")) {
                    System.exit(0);
                    continue;
                }
                if (rec.equals("VP_LINK")) {
                    this._server.response("monitorOK");
                    continue;
                }
                if (rec.equals("getProcessorNumber")) {
                    CommConnector.getInstance().sendUPSNumber();
                    continue;
                }
                if (!rec.startsWith("TEST_MODE")) continue;
                messages = rec.split("#");
                boolean value = false;
                value = Boolean.parseBoolean(messages[1]);
                SystemEnv.setTestMode(value);
            }
            catch (Exception e) {
                logger.info(e.getStackTrace().toString());
            }
        }
        ++SystemEnv.stoped;
    }

    public void shutdown(String ip) {
        Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
        if (shutdown.isRemoteShutdown()) {
            String[] acceptRemoteIps = shutdown.getRemoteAddrs().split(",");
            boolean isAccept = false;
            String[] stringArray = acceptRemoteIps;
            int n = acceptRemoteIps.length;
            int n2 = 0;
            while (n2 < n) {
                String acceptRemoteIp = stringArray[n2];
                if (ip.contains(acceptRemoteIp)) {
                    isAccept = true;
                    break;
                }
                ++n2;
            }
            if (isAccept) {
                if (shutdown.getExcuteProgram() != null && !shutdown.getExcuteProgram().equals("")) {
                    try {
                        Runtime.getRuntime().exec(shutdown.getExcuteProgram());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                SystemShutdown.shutdown("", "", "");
            }
        }
    }
}

