/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.ejalbert;

import com.apple.mrj.MRJFileUtils;
import edu.stanford.cs.ejalbert.LaunchUnixBrowser;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.StringTokenizer;

public class BrowserLauncher {
    private static int jvm;
    private static Object browser;
    private static boolean loadedWithoutErrors;
    private static Object linkage;
    private static final int MRJ_2_2 = 1;
    private static final int MRJ_3_0 = 3;
    private static final int MRJ_3_1 = 4;
    private static final int WINDOWS_NT = 5;
    private static final int WINDOWS_9x = 6;
    private static final int OTHER = -1;
    private static final String FIRST_WINDOWS_PARAMETER = "/c";
    private static final String SECOND_WINDOWS_PARAMETER = "start";
    private static final String THIRD_WINDOWS_PARAMETER = "\"\"";
    private static final String NETSCAPE_REMOTE_PARAMETER = "-remote";
    private static final String NETSCAPE_OPEN_PARAMETER_START = "'openURL(";
    private static final String NETSCAPE_OPEN_PARAMETER_END_1 = ")'";
    private static final String NETSCAPE_OPEN_PARAMETER_END_2 = ", new-window)'";
    private static String errorMessage;

    private BrowserLauncher() {
    }

    private static boolean loadClasses() {
        switch (jvm) {
            case 3: {
                try {
                    Class<?> clazz = Class.forName("com.apple.mrj.jdirect.Linker");
                    Constructor<?> constructor = clazz.getConstructor(Class.class);
                    linkage = constructor.newInstance(BrowserLauncher.class);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    errorMessage = classNotFoundException.getMessage();
                    return false;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    errorMessage = noSuchMethodException.getMessage();
                    return false;
                }
                catch (InvocationTargetException invocationTargetException) {
                    errorMessage = invocationTargetException.getMessage();
                    return false;
                }
                catch (InstantiationException instantiationException) {
                    errorMessage = instantiationException.getMessage();
                    return false;
                }
                catch (IllegalAccessException illegalAccessException) {
                    errorMessage = illegalAccessException.getMessage();
                    return false;
                }
                catch (Throwable throwable) {
                    errorMessage = throwable.getMessage();
                    return false;
                }
            }
        }
        return true;
    }

    private static Object locateBrowser() {
        if (browser != null) {
            return browser;
        }
        switch (jvm) {
            case 1: {
                browser = "MRJFileUtils.openURL()";
                break;
            }
            case 3: {
                browser = "JDirect Invocation";
                break;
            }
            case 4: {
                browser = "MRJFileUtils.openURL()";
                break;
            }
            case 5: {
                browser = "cmd.exe";
                break;
            }
            case 6: {
                browser = "command.com";
                break;
            }
            default: {
                browser = "netscape";
            }
        }
        return browser;
    }

    public static void openURL(String string) throws IOException {
        if (ZeroGd.z) {
            string = BrowserLauncher.escapeSpaces(string);
        }
        System.err.println("\nBrowserLauncher.openURL(" + string + ")\n");
        if (!loadedWithoutErrors) {
            throw new IOException("Exception in finding browser: " + errorMessage);
        }
        Object object = BrowserLauncher.locateBrowser();
        if (object == null) {
            throw new IOException("Unable to locate browser: " + errorMessage);
        }
        BrowserLauncher.openURL(string, object);
    }

    private static String escapeSpaces(String string) {
        String string2 = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string2 + "%20" + stringTokenizer.nextToken();
            }
        }
        return string2;
    }

    private static void openURL(String string, Object object) throws IOException {
        block1 : switch (jvm) {
            case 1: 
            case 4: {
                try {
                    MRJFileUtils.openURL((String)string);
                    break;
                }
                catch (Exception exception) {
                    throw new IOException("Unable to launch default browser using: " + object);
                }
            }
            case 3: {
                int[] nArray = new int[1];
                int n = BrowserLauncher.ICStart(nArray, 0);
                if (n == 0) {
                    int[] nArray2;
                    int[] nArray3 = new int[]{0};
                    byte[] byArray = string.getBytes();
                    n = BrowserLauncher.ICLaunchURL(nArray[0], new byte[]{0}, byArray, byArray.length, nArray3, nArray2 = new int[]{byArray.length});
                    if (n == 0) {
                        BrowserLauncher.ICStop(nArray);
                        break;
                    }
                    throw new IOException("Unable to launch URL: " + n);
                }
                throw new IOException("Unable to create an Internet Config instance: " + n);
            }
            case 5: 
            case 6: {
                if (!string.startsWith("\"")) {
                    string = '\"' + string + '\"';
                }
                String[] stringArray = null;
                stringArray = jvm == 5 ? new String[]{(String)object, FIRST_WINDOWS_PARAMETER, SECOND_WINDOWS_PARAMETER, THIRD_WINDOWS_PARAMETER, string} : new String[]{(String)object, FIRST_WINDOWS_PARAMETER, SECOND_WINDOWS_PARAMETER, string};
                if (ZeroGd.a(stringArray, true, "BrowserLaunch (Win32): ", false, true)) break;
                throw new IOException("BrowserLauncher(Win32): unable to open default browser");
            }
            case -1: {
                String[] stringArray = new String[]{"netscape", "mozilla", "firefox", "mozilla-firefox", "konqueror", "opera"};
                for (int i = 0; i < stringArray.length; ++i) {
                    LaunchUnixBrowser launchUnixBrowser = new LaunchUnixBrowser(stringArray[i], string);
                    launchUnixBrowser.run();
                    if (launchUnixBrowser.getReturnCode() == 0) break block1;
                }
                break;
            }
            default: {
                Runtime.getRuntime().exec(new String[]{(String)object, string});
            }
        }
    }

    private static native int ICStart(int[] var0, int var1);

    private static native int ICStop(int[] var0);

    private static native int ICLaunchURL(int var0, byte[] var1, byte[] var2, int var3, int[] var4, int[] var5);

    static {
        block11: {
            loadedWithoutErrors = true;
            String string = System.getProperty("os.name");
            if (string.startsWith("Mac OS")) {
                String string2 = System.getProperty("mrj.version");
                String string3 = string2.substring(0, 3);
                try {
                    double d = Double.valueOf(string3);
                    if (d >= 2.2) {
                        if (d >= 2.2 && d < 3.0) {
                            jvm = 1;
                        } else if (d == 3.0) {
                            jvm = 3;
                        } else if (d >= 3.1) {
                            jvm = 4;
                        }
                        break block11;
                    }
                    loadedWithoutErrors = false;
                    errorMessage = "Unsupported MRJ version: " + d;
                }
                catch (NumberFormatException numberFormatException) {
                    loadedWithoutErrors = false;
                    errorMessage = "Invalid MRJ version: " + string2;
                }
            } else {
                jvm = string.startsWith("Windows") ? (string.indexOf("9") != -1 || string.toLowerCase().indexOf("me") != -1 ? 6 : 5) : -1;
            }
        }
        if (loadedWithoutErrors) {
            loadedWithoutErrors = BrowserLauncher.loadClasses();
        }
    }
}

